#!/bin/bash

# Change to the same installDir used in installChilkat.sh
installDir=~

cd $installDir/chilkatsoft.com/chilkat_example2
if [ $? -ne 0 ]; then
    echo "Failed to cd to chilkat_example2"
    exit 1
fi

export CGO_LDFLAGS="-L$installDir/chilkatsoft.com/native_c_lib -lchilkatext -lresolv -lpthread -ldl -lstdc++"

if [ ! -e "go.mod" ]; then
	go mod init chilkatsoft.com/chilkat_example2
	go mod edit -replace chilkat=../chilkat
fi

go mod tidy

echo "Building chilkat_example2"
echo "The 1st time building takes a long time, but subsequent builds are fast."
echo "If 'go build' fails, run 'go build -x > buildLog.txt 2>&1'"
go build
if [ $? -ne 0 ]; then
    echo "Failed to build chilkat_example2"
    exit 1
fi
echo "Successfully built the chilkat_example2."




