#!/bin/bash

# Change to the same installDir used in installChilkat.sh
installDir=~

cd $installDir/chilkatsoft.com/chilkat_example1
if [ $? -ne 0 ]; then
    echo "Failed to cd to chilkat_example1"
    exit 1
fi

machineArch=`uname -m`
export CGO_LDFLAGS="-L$installDir/chilkatsoft.com/native_c_lib -lchilkatext_$machineArch -lpthread -lresolv -ldl -lstdc++ -framework CoreFoundation -framework Security"

if [ ! -e "go.mod" ]; then
	go mod init chilkatsoft.com/chilkat_example1
	go mod edit -replace chilkat=../chilkat
fi

go mod tidy

echo "Building chilkat_example1"
echo "The 1st time building takes a long time, but subsequent builds are fast."
echo "If 'go build' fails, run 'go build -x > buildLog.txt 2>&1'"
go build
if [ $? -ne 0 ]; then
    echo "Failed to build chilkat_example1"
    exit 1
fi
echo "Successfully built the chilkat_example1."




