REM @ECHO OFF

REM This is the install .bat script for the Chilkat v11.2.0 Go module on Windows.
REM This assumes 64-bit Windows. 
SET "InitialDir=%CD%"

REM The InstallDir will be automatically created if it does not yet exist.
REM HOMEPATH does not contain the drive letter.  If running this script
REM from a different drive letter, make sure to include "C:"
SET InstallDir=C:%HOMEPATH%

REM ------------------------------------------------------------------------------
REM Check for prerequisites.  We need 7z, curl, and gcc commands to be present.
REM See https://www.chilkatsoft.com/go_windows.asp

WHERE 7z
IF %ERRORLEVEL% EQU 0 (
	ECHO Good, 7z Exists
) ELSE (
	ECHO 7z does not exist.  See https://www.chilkatsoft.com/go_windows.asp
	GOTO :ErrorExit
)

WHERE curl
IF %ERRORLEVEL% EQU 0 (
	ECHO Good, curl Exists
) ELSE (
	ECHO curl does not exist.  See https://www.chilkatsoft.com/go_windows.asp
	GOTO :ErrorExit
)

WHERE gcc
IF %ERRORLEVEL% EQU 0 (
	ECHO Good, gcc Exists
) ELSE (
	ECHO gcc does not exist.  See https://www.chilkatsoft.com/go_windows.asp
	GOTO :ErrorExit
)

REM The certutil command should already exist on a Windows system.
REM We're checking it here to be sure..
REM We'll be using certutil to check the SHA256 hash of the files we download from chilkatdownload.com
WHERE certutil
IF %ERRORLEVEL% EQU 0 (
	ECHO Good, certutil Exists
) ELSE (
	ECHO certutil does not exist.
	GOTO :ErrorExit
)

REM ------------------------------------------------------------------------------
REM Check to see if we have TDM or MinGW-w64.  

REM Chilkat updates this script with each new version with the expected SHA256 of the .tar.gz file.
gcc --version | FIND "tdm64"
IF ERRORLEVEL 1 (
	SET NativeCLibUrl=https://chilkatdownload.com/11.2.0/chilkatext-mingw-x86_64-10.0.0-posix-seh.tar.gz
	SET CLibSHA256=96ffb6fc7425c07abb0ffc44b241df68bd429a1c532c3b7c6c9f0ec09fa69bd9
	SET CLibSubdir=x86_64-10.0.0-posix-seh
	ECHO Assuming MinGW-W64...
) ELSE (
	SET NativeCLibUrl=https://chilkatdownload.com/11.2.0/chilkatext-tdm-gcc-64-10.3.0.tar.gz
	SET CLibSHA256=5542e2c8647b91c8939d44b3d78b816201408ef97161163752c462c8d3648a4b
	SET CLibSubdir=tdm-gcc-64-10.3.0
	ECHO Looks like you have tdm-gcc installed.  Good.
)

REM ------------------------------------------------------------------------------
REM Go to the InstallDir and create the "chilkatsoft.com" directory if it does not yet exist.
REM (Put %InstallDir% in quotes in case there are SPACE chars in the path.)
IF NOT EXIST "%InstallDir%" (
	ECHO Creating %InstallDir% ...
	MKDIR "%InstallDir%"
	IF ERRORLEVEL 1 (
		ECHO Failed to MKDIR %InstallDir%
		GOTO :ErrorExit
	)
)

REM The /d flag is necessary when a drive letter is in the path...
CD /d "%InstallDir%"

REM Create the chilkatsoft.com sub-directory if needed.
SET subdir=chilkatsoft.com
IF NOT EXIST "%subdir%" (
	ECHO Creating %subdir% subdirectory ...
	MKDIR "%subdir%"
	IF ERRORLEVEL 1 (
		ECHO Failed to MKDIR %subdir%
		GOTO :ErrorExit
	)
)

CD "%subdir%"
ECHO Current Directory: %CD%

REM We are going to download the Chilkat Native "C" library into the chilkatsoft.com\native_c_lib directory
SET nativecdir=native_c_lib
IF NOT EXIST "%nativecdir%" (
	ECHO Creating %nativecdir% subdirectory ...
	MKDIR "%nativecdir%"
	IF ERRORLEVEL 1 (
		ECHO Failed to MKDIR %nativecdir%
		GOTO :ErrorExit
	)
)

CD "%nativecdir%"
ECHO Current Directory: %CD%

REM ------------------------------------------------------------------------------
REM Delete anything from previous installs.
if EXIST chilkat_native_c.tar.gz (
	DEL chilkat_native_c.tar.gz
	)
if EXIST chilkat_native_c.tar (
	DEL chilkat_native_c.tar
	)
if EXIST libchilkatExt.a (
	DEL libchilkatExt.a
	)
if EXIST "%CLibSubdir%" (
	RMDIR /S /Q "%CLibSubdir%"
	)
	
REM download the native "C" lib, check the SHA256 hash, and extract.
REM This is where we'll need the curl and 7z commands, and also certutil.
curl %NativeCLibUrl% -o chilkat_native_c.tar.gz

REM Verify the file we downloaded has the expected SHA256 digest.
certutil -hashfile chilkat_native_c.tar.gz SHA256 | FIND "%CLibSHA256%"
 IF ERRORLEVEL 1 (
	ECHO The C library download does not have the expected SHA256 digest.
	GOTO :ErrorExit
)
ECHO Good, the downloaded native C library (.tar.gz) has the expected SHA256 digest.

REM ------------------------------------------------------------------------------
REM Extract the C native library.
REM extract from .gz to .tar
7z x chilkat_native_c.tar.gz
REM extract the .a static lib from the .tar
7z x chilkat_native_c.tar

REM delete the .tar and .tar.gz
DEL chilkat_native_c.tar.gz
DEL chilkat_native_c.tar

REM move the .a static lib up one directory level
MOVE "%CLibSubdir%"\libchilkatExt.a libchilkatExt.a

REM cleanup
if EXIST "%CLibSubdir%" (
	RMDIR /S /Q "%CLibSubdir%"
	)

REM ------------------------------------------------------------------------------
SET CGO_LDFLAGS=-L${SRCDIR}/../native_c_lib -lchilkatExt -lws2_32 -lstdc++

REM move back up to the chilkatsoft.com directory.
CD ..

REM ------------------------------------------------------------------------------
REM Download the chilkat_golang.zip, check the SHA256 digest, and unzip

REM First cleanup from any previous installs
if EXIST "chilkat" (
	RMDIR /S /Q "chilkat"
	)
if EXIST "chilkat_example1" (
	RMDIR /S /Q "chilkat_example1"
	)
if EXIST "chilkat_example2" (
	RMDIR /S /Q "chilkat_example2"
	)
if EXIST chilkat_golang.zip (
	DEL chilkat_golang.zip
	)
if EXIST license.pdf (
	DEL license.pdf
	)

curl https://chilkatdownload.com/11.2.0/chilkat_golang.zip -o chilkat_golang.zip

certutil -hashfile chilkat_golang.zip SHA256 | FIND "78d39a0d309395c85b1a096793d977b38136a88b5b752e0e938cf84e0c750bc1"
IF ERRORLEVEL 1 (
	ECHO The chilkat_golang.zip does not have the expected SHA256 digest.
	GOTO :ErrorExit
)
ECHO Good, the downloaded chilkat_golang.zip has the expected SHA256 digest.

REM extract the files.
7z x chilkat_golang.zip

REM cleanup
if EXIST chilkat_golang.zip (
	DEL chilkat_golang.zip
	)

REM ------------------------------------------------------------------------------
ECHO Let's build the Chilkat module...
ECHO This can take a minute or two, or three...
CD chilkat
go mod init chilkatsoft.com/chilkat
go build

CD /d %InitialDir%

ECHO Successfully installed the Chilkat Go module on Windows
GOTO :EOF

:ErrorExit
CD /d %InitialDir%
ECHO Failed
