unit Asn;

interface

type

HCkBinData = Pointer;
HCkByteData = Pointer;
HCkAsn = Pointer;
HCkString = Pointer;


function CkAsn_Create: HCkAsn;  stdcall;
procedure CkAsn_Dispose(handle: HCkAsn); stdcall;
function CkAsn_getBoolValue(objHandle: HCkAsn): wordbool;
procedure CkAsn_putBoolValue(objHandle: HCkAsn; newPropVal: wordbool);
function CkAsn_getConstructed(objHandle: HCkAsn): wordbool;
procedure CkAsn_getContentStr(objHandle: HCkAsn; outPropVal: HCkString);
procedure CkAsn_putContentStr(objHandle: HCkAsn; newPropVal: PWideChar);
function CkAsn__contentStr(objHandle: HCkAsn): PWideChar;
procedure CkAsn_getDebugLogFilePath(objHandle: HCkAsn; outPropVal: HCkString);
procedure CkAsn_putDebugLogFilePath(objHandle: HCkAsn; newPropVal: PWideChar);
function CkAsn__debugLogFilePath(objHandle: HCkAsn): PWideChar;
function CkAsn_getIntValue(objHandle: HCkAsn): Integer;
procedure CkAsn_putIntValue(objHandle: HCkAsn; newPropVal: Integer);
procedure CkAsn_getLastErrorHtml(objHandle: HCkAsn; outPropVal: HCkString);
function CkAsn__lastErrorHtml(objHandle: HCkAsn): PWideChar;
procedure CkAsn_getLastErrorText(objHandle: HCkAsn; outPropVal: HCkString);
function CkAsn__lastErrorText(objHandle: HCkAsn): PWideChar;
procedure CkAsn_getLastErrorXml(objHandle: HCkAsn; outPropVal: HCkString);
function CkAsn__lastErrorXml(objHandle: HCkAsn): PWideChar;
function CkAsn_getLastMethodSuccess(objHandle: HCkAsn): wordbool;
procedure CkAsn_putLastMethodSuccess(objHandle: HCkAsn; newPropVal: wordbool);
function CkAsn_getNumSubItems(objHandle: HCkAsn): Integer;
procedure CkAsn_getTag(objHandle: HCkAsn; outPropVal: HCkString);
function CkAsn__tag(objHandle: HCkAsn): PWideChar;
function CkAsn_getTagValue(objHandle: HCkAsn): Integer;
function CkAsn_getVerboseLogging(objHandle: HCkAsn): wordbool;
procedure CkAsn_putVerboseLogging(objHandle: HCkAsn; newPropVal: wordbool);
procedure CkAsn_getVersion(objHandle: HCkAsn; outPropVal: HCkString);
function CkAsn__version(objHandle: HCkAsn): PWideChar;
function CkAsn_AppendBigInt(objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
function CkAsn_AppendBits(objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
function CkAsn_AppendBool(objHandle: HCkAsn; value: wordbool): wordbool;
function CkAsn_AppendContextConstructed(objHandle: HCkAsn; tag: Integer): wordbool;
function CkAsn_AppendContextPrimitive(objHandle: HCkAsn; tag: Integer; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
function CkAsn_AppendInt(objHandle: HCkAsn; value: Integer): wordbool;
function CkAsn_AppendNull(objHandle: HCkAsn): wordbool;
function CkAsn_AppendOctets(objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
function CkAsn_AppendOid(objHandle: HCkAsn; oid: PWideChar): wordbool;
function CkAsn_AppendSequence(objHandle: HCkAsn): wordbool;
function CkAsn_AppendSequence2(objHandle: HCkAsn): wordbool;
function CkAsn_AppendSequenceR(objHandle: HCkAsn): HCkAsn;
function CkAsn_AppendSet(objHandle: HCkAsn): wordbool;
function CkAsn_AppendSet2(objHandle: HCkAsn): wordbool;
function CkAsn_AppendSetR(objHandle: HCkAsn): HCkAsn;
function CkAsn_AppendString(objHandle: HCkAsn; strType: PWideChar; value: PWideChar): wordbool;
function CkAsn_AppendTime(objHandle: HCkAsn; timeFormat: PWideChar; dateTimeStr: PWideChar): wordbool;
function CkAsn_AsnToXml(objHandle: HCkAsn; outStr: HCkString): wordbool;
function CkAsn__asnToXml(objHandle: HCkAsn): PWideChar;
function CkAsn_DeleteSubItem(objHandle: HCkAsn; index: Integer): wordbool;
function CkAsn_GetBinaryDer(objHandle: HCkAsn; outData: HCkByteData): wordbool;
function CkAsn_GetEncodedContent(objHandle: HCkAsn; encoding: PWideChar; outStr: HCkString): wordbool;
function CkAsn__getEncodedContent(objHandle: HCkAsn; encoding: PWideChar): PWideChar;
function CkAsn_GetEncodedDer(objHandle: HCkAsn; encoding: PWideChar; outStr: HCkString): wordbool;
function CkAsn__getEncodedDer(objHandle: HCkAsn; encoding: PWideChar): PWideChar;
function CkAsn_GetLastSubItem(objHandle: HCkAsn): HCkAsn;
function CkAsn_GetSubItem(objHandle: HCkAsn; index: Integer): HCkAsn;
function CkAsn_LoadAsnXml(objHandle: HCkAsn; xmlStr: PWideChar): wordbool;
function CkAsn_LoadBd(objHandle: HCkAsn; bd: HCkBinData): wordbool;
function CkAsn_LoadBinary(objHandle: HCkAsn; derBytes: HCkByteData): wordbool;
function CkAsn_LoadBinaryFile(objHandle: HCkAsn; path: PWideChar): wordbool;
function CkAsn_LoadEncoded(objHandle: HCkAsn; asnContent: PWideChar; encoding: PWideChar): wordbool;
function CkAsn_SetEncodedContent(objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
function CkAsn_WriteBd(objHandle: HCkAsn; bd: HCkBinData): wordbool;
function CkAsn_WriteBinaryDer(objHandle: HCkAsn; path: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkAsn_Create = function : HCkAsn; stdcall;
  TCkAsn_Dispose = procedure (handle: HCkAsn); stdcall;
  TCkAsn_getBoolValue = function (objHandle: HCkAsn): wordbool; stdcall;
  TCkAsn_putBoolValue = procedure (objHandle: HCkAsn; newPropVal: wordbool); stdcall;
  TCkAsn_getConstructed = function (objHandle: HCkAsn): wordbool; stdcall;
  TCkAsn_getContentStr = procedure (objHandle: HCkAsn; outPropVal: HCkString); stdcall;
  TCkAsn_putContentStr = procedure (objHandle: HCkAsn; newPropVal: PWideChar); stdcall;
  TCkAsn__contentStr = function (objHandle: HCkAsn): PWideChar; stdcall;
  TCkAsn_getDebugLogFilePath = procedure (objHandle: HCkAsn; outPropVal: HCkString); stdcall;
  TCkAsn_putDebugLogFilePath = procedure (objHandle: HCkAsn; newPropVal: PWideChar); stdcall;
  TCkAsn__debugLogFilePath = function (objHandle: HCkAsn): PWideChar; stdcall;
  TCkAsn_getIntValue = function (objHandle: HCkAsn): Integer; stdcall;
  TCkAsn_putIntValue = procedure (objHandle: HCkAsn; newPropVal: Integer); stdcall;
  TCkAsn_getLastErrorHtml = procedure (objHandle: HCkAsn; outPropVal: HCkString); stdcall;
  TCkAsn__lastErrorHtml = function (objHandle: HCkAsn): PWideChar; stdcall;
  TCkAsn_getLastErrorText = procedure (objHandle: HCkAsn; outPropVal: HCkString); stdcall;
  TCkAsn__lastErrorText = function (objHandle: HCkAsn): PWideChar; stdcall;
  TCkAsn_getLastErrorXml = procedure (objHandle: HCkAsn; outPropVal: HCkString); stdcall;
  TCkAsn__lastErrorXml = function (objHandle: HCkAsn): PWideChar; stdcall;
  TCkAsn_getLastMethodSuccess = function (objHandle: HCkAsn): wordbool; stdcall;
  TCkAsn_putLastMethodSuccess = procedure (objHandle: HCkAsn; newPropVal: wordbool); stdcall;
  TCkAsn_getNumSubItems = function (objHandle: HCkAsn): Integer; stdcall;
  TCkAsn_getTag = procedure (objHandle: HCkAsn; outPropVal: HCkString); stdcall;
  TCkAsn__tag = function (objHandle: HCkAsn): PWideChar; stdcall;
  TCkAsn_getTagValue = function (objHandle: HCkAsn): Integer; stdcall;
  TCkAsn_getVerboseLogging = function (objHandle: HCkAsn): wordbool; stdcall;
  TCkAsn_putVerboseLogging = procedure (objHandle: HCkAsn; newPropVal: wordbool); stdcall;
  TCkAsn_getVersion = procedure (objHandle: HCkAsn; outPropVal: HCkString); stdcall;
  TCkAsn__version = function (objHandle: HCkAsn): PWideChar; stdcall;
  TCkAsn_AppendBigInt = function (objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkAsn_AppendBits = function (objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkAsn_AppendBool = function (objHandle: HCkAsn; value: wordbool): wordbool; stdcall;
  TCkAsn_AppendContextConstructed = function (objHandle: HCkAsn; tag: Integer): wordbool; stdcall;
  TCkAsn_AppendContextPrimitive = function (objHandle: HCkAsn; tag: Integer; encodedBytes: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkAsn_AppendInt = function (objHandle: HCkAsn; value: Integer): wordbool; stdcall;
  TCkAsn_AppendNull = function (objHandle: HCkAsn): wordbool; stdcall;
  TCkAsn_AppendOctets = function (objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkAsn_AppendOid = function (objHandle: HCkAsn; oid: PWideChar): wordbool; stdcall;
  TCkAsn_AppendSequence = function (objHandle: HCkAsn): wordbool; stdcall;
  TCkAsn_AppendSequence2 = function (objHandle: HCkAsn): wordbool; stdcall;
  TCkAsn_AppendSequenceR = function (objHandle: HCkAsn): HCkAsn; stdcall;
  TCkAsn_AppendSet = function (objHandle: HCkAsn): wordbool; stdcall;
  TCkAsn_AppendSet2 = function (objHandle: HCkAsn): wordbool; stdcall;
  TCkAsn_AppendSetR = function (objHandle: HCkAsn): HCkAsn; stdcall;
  TCkAsn_AppendString = function (objHandle: HCkAsn; strType: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkAsn_AppendTime = function (objHandle: HCkAsn; timeFormat: PWideChar; dateTimeStr: PWideChar): wordbool; stdcall;
  TCkAsn_AsnToXml = function (objHandle: HCkAsn; outStr: HCkString): wordbool; stdcall;
  TCkAsn__asnToXml = function (objHandle: HCkAsn): PWideChar; stdcall;
  TCkAsn_DeleteSubItem = function (objHandle: HCkAsn; index: Integer): wordbool; stdcall;
  TCkAsn_GetBinaryDer = function (objHandle: HCkAsn; outData: HCkByteData): wordbool; stdcall;
  TCkAsn_GetEncodedContent = function (objHandle: HCkAsn; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkAsn__getEncodedContent = function (objHandle: HCkAsn; encoding: PWideChar): PWideChar; stdcall;
  TCkAsn_GetEncodedDer = function (objHandle: HCkAsn; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkAsn__getEncodedDer = function (objHandle: HCkAsn; encoding: PWideChar): PWideChar; stdcall;
  TCkAsn_GetLastSubItem = function (objHandle: HCkAsn): HCkAsn; stdcall;
  TCkAsn_GetSubItem = function (objHandle: HCkAsn; index: Integer): HCkAsn; stdcall;
  TCkAsn_LoadAsnXml = function (objHandle: HCkAsn; xmlStr: PWideChar): wordbool; stdcall;
  TCkAsn_LoadBd = function (objHandle: HCkAsn; bd: HCkBinData): wordbool; stdcall;
  TCkAsn_LoadBinary = function (objHandle: HCkAsn; derBytes: HCkByteData): wordbool; stdcall;
  TCkAsn_LoadBinaryFile = function (objHandle: HCkAsn; path: PWideChar): wordbool; stdcall;
  TCkAsn_LoadEncoded = function (objHandle: HCkAsn; asnContent: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkAsn_SetEncodedContent = function (objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkAsn_WriteBd = function (objHandle: HCkAsn; bd: HCkBinData): wordbool; stdcall;
  TCkAsn_WriteBinaryDer = function (objHandle: HCkAsn; path: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..63] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkAsn_Create : HCkAsn;
begin
  result := TCkAsn_Create(_map(0, 'CkAsn_Create'));
end;

procedure CkAsn_Dispose (handle: HCkAsn);
begin
  TCkAsn_Dispose(_map(1, 'CkAsn_Dispose'))
    (handle);
end;


function CkAsn_getBoolValue (objHandle: HCkAsn): wordbool;
begin
    result := TCkAsn_getBoolValue(_map(2, 'CkAsn_getBoolValue'))
    (objHandle);
end;

procedure CkAsn_putBoolValue (objHandle: HCkAsn; newPropVal: wordbool);
begin
  TCkAsn_putBoolValue(_map(3, 'CkAsn_putBoolValue'))
    (objHandle, newPropVal);
end;

function CkAsn_getConstructed (objHandle: HCkAsn): wordbool;
begin
    result := TCkAsn_getConstructed(_map(4, 'CkAsn_getConstructed'))
    (objHandle);
end;

procedure CkAsn_getContentStr (objHandle: HCkAsn; outPropVal: HCkString);
begin
  TCkAsn_getContentStr(_map(5, 'CkAsn_getContentStr'))
    (objHandle, outPropVal);
end;

procedure CkAsn_putContentStr (objHandle: HCkAsn; newPropVal: PWideChar);
begin
  TCkAsn_putContentStr(_map(6, 'CkAsn_putContentStr'))
    (objHandle, newPropVal);
end;

function CkAsn__contentStr (objHandle: HCkAsn): PWideChar;
begin
  result := TCkAsn__contentStr(_map(7, 'CkAsn__contentStr'))
    (objHandle);
end;

procedure CkAsn_getDebugLogFilePath (objHandle: HCkAsn; outPropVal: HCkString);
begin
  TCkAsn_getDebugLogFilePath(_map(8, 'CkAsn_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkAsn_putDebugLogFilePath (objHandle: HCkAsn; newPropVal: PWideChar);
begin
  TCkAsn_putDebugLogFilePath(_map(9, 'CkAsn_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkAsn__debugLogFilePath (objHandle: HCkAsn): PWideChar;
begin
  result := TCkAsn__debugLogFilePath(_map(10, 'CkAsn__debugLogFilePath'))
    (objHandle);
end;

function CkAsn_getIntValue (objHandle: HCkAsn): Integer;
begin
    result := TCkAsn_getIntValue(_map(11, 'CkAsn_getIntValue'))
    (objHandle);
end;

procedure CkAsn_putIntValue (objHandle: HCkAsn; newPropVal: Integer);
begin
  TCkAsn_putIntValue(_map(12, 'CkAsn_putIntValue'))
    (objHandle, newPropVal);
end;

procedure CkAsn_getLastErrorHtml (objHandle: HCkAsn; outPropVal: HCkString);
begin
  TCkAsn_getLastErrorHtml(_map(13, 'CkAsn_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkAsn__lastErrorHtml (objHandle: HCkAsn): PWideChar;
begin
  result := TCkAsn__lastErrorHtml(_map(14, 'CkAsn__lastErrorHtml'))
    (objHandle);
end;

procedure CkAsn_getLastErrorText (objHandle: HCkAsn; outPropVal: HCkString);
begin
  TCkAsn_getLastErrorText(_map(15, 'CkAsn_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkAsn__lastErrorText (objHandle: HCkAsn): PWideChar;
begin
  result := TCkAsn__lastErrorText(_map(16, 'CkAsn__lastErrorText'))
    (objHandle);
end;

procedure CkAsn_getLastErrorXml (objHandle: HCkAsn; outPropVal: HCkString);
begin
  TCkAsn_getLastErrorXml(_map(17, 'CkAsn_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkAsn__lastErrorXml (objHandle: HCkAsn): PWideChar;
begin
  result := TCkAsn__lastErrorXml(_map(18, 'CkAsn__lastErrorXml'))
    (objHandle);
end;

function CkAsn_getLastMethodSuccess (objHandle: HCkAsn): wordbool;
begin
    result := TCkAsn_getLastMethodSuccess(_map(19, 'CkAsn_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkAsn_putLastMethodSuccess (objHandle: HCkAsn; newPropVal: wordbool);
begin
  TCkAsn_putLastMethodSuccess(_map(20, 'CkAsn_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkAsn_getNumSubItems (objHandle: HCkAsn): Integer;
begin
    result := TCkAsn_getNumSubItems(_map(21, 'CkAsn_getNumSubItems'))
    (objHandle);
end;

procedure CkAsn_getTag (objHandle: HCkAsn; outPropVal: HCkString);
begin
  TCkAsn_getTag(_map(22, 'CkAsn_getTag'))
    (objHandle, outPropVal);
end;

function CkAsn__tag (objHandle: HCkAsn): PWideChar;
begin
  result := TCkAsn__tag(_map(23, 'CkAsn__tag'))
    (objHandle);
end;

function CkAsn_getTagValue (objHandle: HCkAsn): Integer;
begin
    result := TCkAsn_getTagValue(_map(24, 'CkAsn_getTagValue'))
    (objHandle);
end;

function CkAsn_getVerboseLogging (objHandle: HCkAsn): wordbool;
begin
    result := TCkAsn_getVerboseLogging(_map(25, 'CkAsn_getVerboseLogging'))
    (objHandle);
end;

procedure CkAsn_putVerboseLogging (objHandle: HCkAsn; newPropVal: wordbool);
begin
  TCkAsn_putVerboseLogging(_map(26, 'CkAsn_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkAsn_getVersion (objHandle: HCkAsn; outPropVal: HCkString);
begin
  TCkAsn_getVersion(_map(27, 'CkAsn_getVersion'))
    (objHandle, outPropVal);
end;

function CkAsn__version (objHandle: HCkAsn): PWideChar;
begin
  result := TCkAsn__version(_map(28, 'CkAsn__version'))
    (objHandle);
end;

function CkAsn_AppendBigInt (objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkAsn_AppendBigInt(_map(29, 'CkAsn_AppendBigInt'))
    (objHandle, encodedBytes, encoding);
end;

function CkAsn_AppendBits (objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkAsn_AppendBits(_map(30, 'CkAsn_AppendBits'))
    (objHandle, encodedBytes, encoding);
end;

function CkAsn_AppendBool (objHandle: HCkAsn; value: wordbool): wordbool;
begin
  result := TCkAsn_AppendBool(_map(31, 'CkAsn_AppendBool'))
    (objHandle, value);
end;

function CkAsn_AppendContextConstructed (objHandle: HCkAsn; tag: Integer): wordbool;
begin
  result := TCkAsn_AppendContextConstructed(_map(32, 'CkAsn_AppendContextConstructed'))
    (objHandle, tag);
end;

function CkAsn_AppendContextPrimitive (objHandle: HCkAsn; tag: Integer; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkAsn_AppendContextPrimitive(_map(33, 'CkAsn_AppendContextPrimitive'))
    (objHandle, tag, encodedBytes, encoding);
end;

function CkAsn_AppendInt (objHandle: HCkAsn; value: Integer): wordbool;
begin
  result := TCkAsn_AppendInt(_map(34, 'CkAsn_AppendInt'))
    (objHandle, value);
end;

function CkAsn_AppendNull (objHandle: HCkAsn): wordbool;
begin
  result := TCkAsn_AppendNull(_map(35, 'CkAsn_AppendNull'))
    (objHandle);
end;

function CkAsn_AppendOctets (objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkAsn_AppendOctets(_map(36, 'CkAsn_AppendOctets'))
    (objHandle, encodedBytes, encoding);
end;

function CkAsn_AppendOid (objHandle: HCkAsn; oid: PWideChar): wordbool;
begin
  result := TCkAsn_AppendOid(_map(37, 'CkAsn_AppendOid'))
    (objHandle, oid);
end;

function CkAsn_AppendSequence (objHandle: HCkAsn): wordbool;
begin
  result := TCkAsn_AppendSequence(_map(38, 'CkAsn_AppendSequence'))
    (objHandle);
end;

function CkAsn_AppendSequence2 (objHandle: HCkAsn): wordbool;
begin
  result := TCkAsn_AppendSequence2(_map(39, 'CkAsn_AppendSequence2'))
    (objHandle);
end;

function CkAsn_AppendSequenceR (objHandle: HCkAsn): HCkAsn;
begin
  result := TCkAsn_AppendSequenceR(_map(40, 'CkAsn_AppendSequenceR'))
    (objHandle);
end;

function CkAsn_AppendSet (objHandle: HCkAsn): wordbool;
begin
  result := TCkAsn_AppendSet(_map(41, 'CkAsn_AppendSet'))
    (objHandle);
end;

function CkAsn_AppendSet2 (objHandle: HCkAsn): wordbool;
begin
  result := TCkAsn_AppendSet2(_map(42, 'CkAsn_AppendSet2'))
    (objHandle);
end;

function CkAsn_AppendSetR (objHandle: HCkAsn): HCkAsn;
begin
  result := TCkAsn_AppendSetR(_map(43, 'CkAsn_AppendSetR'))
    (objHandle);
end;

function CkAsn_AppendString (objHandle: HCkAsn; strType: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkAsn_AppendString(_map(44, 'CkAsn_AppendString'))
    (objHandle, strType, value);
end;

function CkAsn_AppendTime (objHandle: HCkAsn; timeFormat: PWideChar; dateTimeStr: PWideChar): wordbool;
begin
  result := TCkAsn_AppendTime(_map(45, 'CkAsn_AppendTime'))
    (objHandle, timeFormat, dateTimeStr);
end;

function CkAsn_AsnToXml (objHandle: HCkAsn; outStr: HCkString): wordbool;
begin
  result := TCkAsn_AsnToXml(_map(46, 'CkAsn_AsnToXml'))
    (objHandle, outStr);
end;

function CkAsn__asnToXml (objHandle: HCkAsn): PWideChar;
begin
  result := TCkAsn__asnToXml(_map(47, 'CkAsn__asnToXml'))
    (objHandle);
end;

function CkAsn_DeleteSubItem (objHandle: HCkAsn; index: Integer): wordbool;
begin
  result := TCkAsn_DeleteSubItem(_map(48, 'CkAsn_DeleteSubItem'))
    (objHandle, index);
end;

function CkAsn_GetBinaryDer (objHandle: HCkAsn; outData: HCkByteData): wordbool;
begin
  result := TCkAsn_GetBinaryDer(_map(49, 'CkAsn_GetBinaryDer'))
    (objHandle, outData);
end;

function CkAsn_GetEncodedContent (objHandle: HCkAsn; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkAsn_GetEncodedContent(_map(50, 'CkAsn_GetEncodedContent'))
    (objHandle, encoding, outStr);
end;

function CkAsn__getEncodedContent (objHandle: HCkAsn; encoding: PWideChar): PWideChar;
begin
  result := TCkAsn__getEncodedContent(_map(51, 'CkAsn__getEncodedContent'))
    (objHandle, encoding);
end;

function CkAsn_GetEncodedDer (objHandle: HCkAsn; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkAsn_GetEncodedDer(_map(52, 'CkAsn_GetEncodedDer'))
    (objHandle, encoding, outStr);
end;

function CkAsn__getEncodedDer (objHandle: HCkAsn; encoding: PWideChar): PWideChar;
begin
  result := TCkAsn__getEncodedDer(_map(53, 'CkAsn__getEncodedDer'))
    (objHandle, encoding);
end;

function CkAsn_GetLastSubItem (objHandle: HCkAsn): HCkAsn;
begin
  result := TCkAsn_GetLastSubItem(_map(54, 'CkAsn_GetLastSubItem'))
    (objHandle);
end;

function CkAsn_GetSubItem (objHandle: HCkAsn; index: Integer): HCkAsn;
begin
  result := TCkAsn_GetSubItem(_map(55, 'CkAsn_GetSubItem'))
    (objHandle, index);
end;

function CkAsn_LoadAsnXml (objHandle: HCkAsn; xmlStr: PWideChar): wordbool;
begin
  result := TCkAsn_LoadAsnXml(_map(56, 'CkAsn_LoadAsnXml'))
    (objHandle, xmlStr);
end;

function CkAsn_LoadBd (objHandle: HCkAsn; bd: HCkBinData): wordbool;
begin
  result := TCkAsn_LoadBd(_map(57, 'CkAsn_LoadBd'))
    (objHandle, bd);
end;

function CkAsn_LoadBinary (objHandle: HCkAsn; derBytes: HCkByteData): wordbool;
begin
  result := TCkAsn_LoadBinary(_map(58, 'CkAsn_LoadBinary'))
    (objHandle, derBytes);
end;

function CkAsn_LoadBinaryFile (objHandle: HCkAsn; path: PWideChar): wordbool;
begin
  result := TCkAsn_LoadBinaryFile(_map(59, 'CkAsn_LoadBinaryFile'))
    (objHandle, path);
end;

function CkAsn_LoadEncoded (objHandle: HCkAsn; asnContent: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkAsn_LoadEncoded(_map(60, 'CkAsn_LoadEncoded'))
    (objHandle, asnContent, encoding);
end;

function CkAsn_SetEncodedContent (objHandle: HCkAsn; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkAsn_SetEncodedContent(_map(61, 'CkAsn_SetEncodedContent'))
    (objHandle, encodedBytes, encoding);
end;

function CkAsn_WriteBd (objHandle: HCkAsn; bd: HCkBinData): wordbool;
begin
  result := TCkAsn_WriteBd(_map(62, 'CkAsn_WriteBd'))
    (objHandle, bd);
end;

function CkAsn_WriteBinaryDer (objHandle: HCkAsn; path: PWideChar): wordbool;
begin
  result := TCkAsn_WriteBinaryDer(_map(63, 'CkAsn_WriteBinaryDer'))
    (objHandle, path);
end;

end.
