unit AuthAzureSAS;

interface

type

HCkAuthAzureSAS = Pointer;
HCkString = Pointer;


function CkAuthAzureSAS_Create: HCkAuthAzureSAS;  stdcall;
procedure CkAuthAzureSAS_Dispose(handle: HCkAuthAzureSAS); stdcall;
procedure CkAuthAzureSAS_getAccessKey(objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
procedure CkAuthAzureSAS_putAccessKey(objHandle: HCkAuthAzureSAS; newPropVal: PWideChar);
function CkAuthAzureSAS__accessKey(objHandle: HCkAuthAzureSAS): PWideChar;
procedure CkAuthAzureSAS_getDebugLogFilePath(objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
procedure CkAuthAzureSAS_putDebugLogFilePath(objHandle: HCkAuthAzureSAS; newPropVal: PWideChar);
function CkAuthAzureSAS__debugLogFilePath(objHandle: HCkAuthAzureSAS): PWideChar;
procedure CkAuthAzureSAS_getLastErrorHtml(objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
function CkAuthAzureSAS__lastErrorHtml(objHandle: HCkAuthAzureSAS): PWideChar;
procedure CkAuthAzureSAS_getLastErrorText(objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
function CkAuthAzureSAS__lastErrorText(objHandle: HCkAuthAzureSAS): PWideChar;
procedure CkAuthAzureSAS_getLastErrorXml(objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
function CkAuthAzureSAS__lastErrorXml(objHandle: HCkAuthAzureSAS): PWideChar;
function CkAuthAzureSAS_getLastMethodSuccess(objHandle: HCkAuthAzureSAS): wordbool;
procedure CkAuthAzureSAS_putLastMethodSuccess(objHandle: HCkAuthAzureSAS; newPropVal: wordbool);
procedure CkAuthAzureSAS_getStringToSign(objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
procedure CkAuthAzureSAS_putStringToSign(objHandle: HCkAuthAzureSAS; newPropVal: PWideChar);
function CkAuthAzureSAS__stringToSign(objHandle: HCkAuthAzureSAS): PWideChar;
function CkAuthAzureSAS_getVerboseLogging(objHandle: HCkAuthAzureSAS): wordbool;
procedure CkAuthAzureSAS_putVerboseLogging(objHandle: HCkAuthAzureSAS; newPropVal: wordbool);
procedure CkAuthAzureSAS_getVersion(objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
function CkAuthAzureSAS__version(objHandle: HCkAuthAzureSAS): PWideChar;
procedure CkAuthAzureSAS_Clear(objHandle: HCkAuthAzureSAS);
function CkAuthAzureSAS_GenerateToken(objHandle: HCkAuthAzureSAS; outStr: HCkString): wordbool;
function CkAuthAzureSAS__generateToken(objHandle: HCkAuthAzureSAS): PWideChar;
function CkAuthAzureSAS_SetNonTokenParam(objHandle: HCkAuthAzureSAS; name: PWideChar; value: PWideChar): wordbool;
function CkAuthAzureSAS_SetTokenParam(objHandle: HCkAuthAzureSAS; name: PWideChar; authParamName: PWideChar; value: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkAuthAzureSAS_Create = function : HCkAuthAzureSAS; stdcall;
  TCkAuthAzureSAS_Dispose = procedure (handle: HCkAuthAzureSAS); stdcall;
  TCkAuthAzureSAS_getAccessKey = procedure (objHandle: HCkAuthAzureSAS; outPropVal: HCkString); stdcall;
  TCkAuthAzureSAS_putAccessKey = procedure (objHandle: HCkAuthAzureSAS; newPropVal: PWideChar); stdcall;
  TCkAuthAzureSAS__accessKey = function (objHandle: HCkAuthAzureSAS): PWideChar; stdcall;
  TCkAuthAzureSAS_getDebugLogFilePath = procedure (objHandle: HCkAuthAzureSAS; outPropVal: HCkString); stdcall;
  TCkAuthAzureSAS_putDebugLogFilePath = procedure (objHandle: HCkAuthAzureSAS; newPropVal: PWideChar); stdcall;
  TCkAuthAzureSAS__debugLogFilePath = function (objHandle: HCkAuthAzureSAS): PWideChar; stdcall;
  TCkAuthAzureSAS_getLastErrorHtml = procedure (objHandle: HCkAuthAzureSAS; outPropVal: HCkString); stdcall;
  TCkAuthAzureSAS__lastErrorHtml = function (objHandle: HCkAuthAzureSAS): PWideChar; stdcall;
  TCkAuthAzureSAS_getLastErrorText = procedure (objHandle: HCkAuthAzureSAS; outPropVal: HCkString); stdcall;
  TCkAuthAzureSAS__lastErrorText = function (objHandle: HCkAuthAzureSAS): PWideChar; stdcall;
  TCkAuthAzureSAS_getLastErrorXml = procedure (objHandle: HCkAuthAzureSAS; outPropVal: HCkString); stdcall;
  TCkAuthAzureSAS__lastErrorXml = function (objHandle: HCkAuthAzureSAS): PWideChar; stdcall;
  TCkAuthAzureSAS_getLastMethodSuccess = function (objHandle: HCkAuthAzureSAS): wordbool; stdcall;
  TCkAuthAzureSAS_putLastMethodSuccess = procedure (objHandle: HCkAuthAzureSAS; newPropVal: wordbool); stdcall;
  TCkAuthAzureSAS_getStringToSign = procedure (objHandle: HCkAuthAzureSAS; outPropVal: HCkString); stdcall;
  TCkAuthAzureSAS_putStringToSign = procedure (objHandle: HCkAuthAzureSAS; newPropVal: PWideChar); stdcall;
  TCkAuthAzureSAS__stringToSign = function (objHandle: HCkAuthAzureSAS): PWideChar; stdcall;
  TCkAuthAzureSAS_getVerboseLogging = function (objHandle: HCkAuthAzureSAS): wordbool; stdcall;
  TCkAuthAzureSAS_putVerboseLogging = procedure (objHandle: HCkAuthAzureSAS; newPropVal: wordbool); stdcall;
  TCkAuthAzureSAS_getVersion = procedure (objHandle: HCkAuthAzureSAS; outPropVal: HCkString); stdcall;
  TCkAuthAzureSAS__version = function (objHandle: HCkAuthAzureSAS): PWideChar; stdcall;
  TCkAuthAzureSAS_Clear = procedure (objHandle: HCkAuthAzureSAS); stdcall;
  TCkAuthAzureSAS_GenerateToken = function (objHandle: HCkAuthAzureSAS; outStr: HCkString): wordbool; stdcall;
  TCkAuthAzureSAS__generateToken = function (objHandle: HCkAuthAzureSAS): PWideChar; stdcall;
  TCkAuthAzureSAS_SetNonTokenParam = function (objHandle: HCkAuthAzureSAS; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkAuthAzureSAS_SetTokenParam = function (objHandle: HCkAuthAzureSAS; name: PWideChar; authParamName: PWideChar; value: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..27] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkAuthAzureSAS_Create : HCkAuthAzureSAS;
begin
  result := TCkAuthAzureSAS_Create(_map(0, 'CkAuthAzureSAS_Create'));
end;

procedure CkAuthAzureSAS_Dispose (handle: HCkAuthAzureSAS);
begin
  TCkAuthAzureSAS_Dispose(_map(1, 'CkAuthAzureSAS_Dispose'))
    (handle);
end;


procedure CkAuthAzureSAS_getAccessKey (objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
begin
  TCkAuthAzureSAS_getAccessKey(_map(2, 'CkAuthAzureSAS_getAccessKey'))
    (objHandle, outPropVal);
end;

procedure CkAuthAzureSAS_putAccessKey (objHandle: HCkAuthAzureSAS; newPropVal: PWideChar);
begin
  TCkAuthAzureSAS_putAccessKey(_map(3, 'CkAuthAzureSAS_putAccessKey'))
    (objHandle, newPropVal);
end;

function CkAuthAzureSAS__accessKey (objHandle: HCkAuthAzureSAS): PWideChar;
begin
  result := TCkAuthAzureSAS__accessKey(_map(4, 'CkAuthAzureSAS__accessKey'))
    (objHandle);
end;

procedure CkAuthAzureSAS_getDebugLogFilePath (objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
begin
  TCkAuthAzureSAS_getDebugLogFilePath(_map(5, 'CkAuthAzureSAS_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkAuthAzureSAS_putDebugLogFilePath (objHandle: HCkAuthAzureSAS; newPropVal: PWideChar);
begin
  TCkAuthAzureSAS_putDebugLogFilePath(_map(6, 'CkAuthAzureSAS_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkAuthAzureSAS__debugLogFilePath (objHandle: HCkAuthAzureSAS): PWideChar;
begin
  result := TCkAuthAzureSAS__debugLogFilePath(_map(7, 'CkAuthAzureSAS__debugLogFilePath'))
    (objHandle);
end;

procedure CkAuthAzureSAS_getLastErrorHtml (objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
begin
  TCkAuthAzureSAS_getLastErrorHtml(_map(8, 'CkAuthAzureSAS_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkAuthAzureSAS__lastErrorHtml (objHandle: HCkAuthAzureSAS): PWideChar;
begin
  result := TCkAuthAzureSAS__lastErrorHtml(_map(9, 'CkAuthAzureSAS__lastErrorHtml'))
    (objHandle);
end;

procedure CkAuthAzureSAS_getLastErrorText (objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
begin
  TCkAuthAzureSAS_getLastErrorText(_map(10, 'CkAuthAzureSAS_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkAuthAzureSAS__lastErrorText (objHandle: HCkAuthAzureSAS): PWideChar;
begin
  result := TCkAuthAzureSAS__lastErrorText(_map(11, 'CkAuthAzureSAS__lastErrorText'))
    (objHandle);
end;

procedure CkAuthAzureSAS_getLastErrorXml (objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
begin
  TCkAuthAzureSAS_getLastErrorXml(_map(12, 'CkAuthAzureSAS_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkAuthAzureSAS__lastErrorXml (objHandle: HCkAuthAzureSAS): PWideChar;
begin
  result := TCkAuthAzureSAS__lastErrorXml(_map(13, 'CkAuthAzureSAS__lastErrorXml'))
    (objHandle);
end;

function CkAuthAzureSAS_getLastMethodSuccess (objHandle: HCkAuthAzureSAS): wordbool;
begin
    result := TCkAuthAzureSAS_getLastMethodSuccess(_map(14, 'CkAuthAzureSAS_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkAuthAzureSAS_putLastMethodSuccess (objHandle: HCkAuthAzureSAS; newPropVal: wordbool);
begin
  TCkAuthAzureSAS_putLastMethodSuccess(_map(15, 'CkAuthAzureSAS_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkAuthAzureSAS_getStringToSign (objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
begin
  TCkAuthAzureSAS_getStringToSign(_map(16, 'CkAuthAzureSAS_getStringToSign'))
    (objHandle, outPropVal);
end;

procedure CkAuthAzureSAS_putStringToSign (objHandle: HCkAuthAzureSAS; newPropVal: PWideChar);
begin
  TCkAuthAzureSAS_putStringToSign(_map(17, 'CkAuthAzureSAS_putStringToSign'))
    (objHandle, newPropVal);
end;

function CkAuthAzureSAS__stringToSign (objHandle: HCkAuthAzureSAS): PWideChar;
begin
  result := TCkAuthAzureSAS__stringToSign(_map(18, 'CkAuthAzureSAS__stringToSign'))
    (objHandle);
end;

function CkAuthAzureSAS_getVerboseLogging (objHandle: HCkAuthAzureSAS): wordbool;
begin
    result := TCkAuthAzureSAS_getVerboseLogging(_map(19, 'CkAuthAzureSAS_getVerboseLogging'))
    (objHandle);
end;

procedure CkAuthAzureSAS_putVerboseLogging (objHandle: HCkAuthAzureSAS; newPropVal: wordbool);
begin
  TCkAuthAzureSAS_putVerboseLogging(_map(20, 'CkAuthAzureSAS_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkAuthAzureSAS_getVersion (objHandle: HCkAuthAzureSAS; outPropVal: HCkString);
begin
  TCkAuthAzureSAS_getVersion(_map(21, 'CkAuthAzureSAS_getVersion'))
    (objHandle, outPropVal);
end;

function CkAuthAzureSAS__version (objHandle: HCkAuthAzureSAS): PWideChar;
begin
  result := TCkAuthAzureSAS__version(_map(22, 'CkAuthAzureSAS__version'))
    (objHandle);
end;

procedure CkAuthAzureSAS_Clear (objHandle: HCkAuthAzureSAS);
begin
  TCkAuthAzureSAS_Clear(_map(23, 'CkAuthAzureSAS_Clear'))
    (objHandle);
end;

function CkAuthAzureSAS_GenerateToken (objHandle: HCkAuthAzureSAS; outStr: HCkString): wordbool;
begin
  result := TCkAuthAzureSAS_GenerateToken(_map(24, 'CkAuthAzureSAS_GenerateToken'))
    (objHandle, outStr);
end;

function CkAuthAzureSAS__generateToken (objHandle: HCkAuthAzureSAS): PWideChar;
begin
  result := TCkAuthAzureSAS__generateToken(_map(25, 'CkAuthAzureSAS__generateToken'))
    (objHandle);
end;

function CkAuthAzureSAS_SetNonTokenParam (objHandle: HCkAuthAzureSAS; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkAuthAzureSAS_SetNonTokenParam(_map(26, 'CkAuthAzureSAS_SetNonTokenParam'))
    (objHandle, name, value);
end;

function CkAuthAzureSAS_SetTokenParam (objHandle: HCkAuthAzureSAS; name: PWideChar; authParamName: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkAuthAzureSAS_SetTokenParam(_map(27, 'CkAuthAzureSAS_SetTokenParam'))
    (objHandle, name, authParamName, value);
end;

end.
