unit Cache;

interface

type

HCkBinData = Pointer;
HCkDateTime = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkCache = Pointer;
HCkStringBuilder = Pointer;


function CkCache_Create: HCkCache;  stdcall;
procedure CkCache_Dispose(handle: HCkCache); stdcall;
procedure CkCache_getDebugLogFilePath(objHandle: HCkCache; outPropVal: HCkString);
procedure CkCache_putDebugLogFilePath(objHandle: HCkCache; newPropVal: PWideChar);
function CkCache__debugLogFilePath(objHandle: HCkCache): PWideChar;
procedure CkCache_getLastErrorHtml(objHandle: HCkCache; outPropVal: HCkString);
function CkCache__lastErrorHtml(objHandle: HCkCache): PWideChar;
procedure CkCache_getLastErrorText(objHandle: HCkCache; outPropVal: HCkString);
function CkCache__lastErrorText(objHandle: HCkCache): PWideChar;
procedure CkCache_getLastErrorXml(objHandle: HCkCache; outPropVal: HCkString);
function CkCache__lastErrorXml(objHandle: HCkCache): PWideChar;
procedure CkCache_getLastEtagFetched(objHandle: HCkCache; outPropVal: HCkString);
function CkCache__lastEtagFetched(objHandle: HCkCache): PWideChar;
procedure CkCache_getLastExpirationFetchedStr(objHandle: HCkCache; outPropVal: HCkString);
function CkCache__lastExpirationFetchedStr(objHandle: HCkCache): PWideChar;
function CkCache_getLastHitExpired(objHandle: HCkCache): wordbool;
procedure CkCache_getLastKeyFetched(objHandle: HCkCache; outPropVal: HCkString);
function CkCache__lastKeyFetched(objHandle: HCkCache): PWideChar;
function CkCache_getLastMethodSuccess(objHandle: HCkCache): wordbool;
procedure CkCache_putLastMethodSuccess(objHandle: HCkCache; newPropVal: wordbool);
function CkCache_getLevel(objHandle: HCkCache): Integer;
procedure CkCache_putLevel(objHandle: HCkCache; newPropVal: Integer);
function CkCache_getNumRoots(objHandle: HCkCache): Integer;
function CkCache_getVerboseLogging(objHandle: HCkCache): wordbool;
procedure CkCache_putVerboseLogging(objHandle: HCkCache; newPropVal: wordbool);
procedure CkCache_getVersion(objHandle: HCkCache; outPropVal: HCkString);
function CkCache__version(objHandle: HCkCache): PWideChar;
procedure CkCache_AddRoot(objHandle: HCkCache; path: PWideChar);
function CkCache_DeleteAll(objHandle: HCkCache): Integer;
function CkCache_DeleteAllExpired(objHandle: HCkCache): Integer;
function CkCache_DeleteFromCache(objHandle: HCkCache; key: PWideChar): wordbool;
function CkCache_DeleteOlderDt(objHandle: HCkCache; dateTime: HCkDateTime): Integer;
function CkCache_DeleteOlderStr(objHandle: HCkCache; dateTimeStr: PWideChar): Integer;
function CkCache_FetchBd(objHandle: HCkCache; key: PWideChar; bd: HCkBinData): wordbool;
function CkCache_FetchFromCache(objHandle: HCkCache; key: PWideChar; outData: HCkByteData): wordbool;
function CkCache_FetchSb(objHandle: HCkCache; key: PWideChar; sb: HCkStringBuilder): wordbool;
function CkCache_FetchText(objHandle: HCkCache; key: PWideChar; outStr: HCkString): wordbool;
function CkCache__fetchText(objHandle: HCkCache; key: PWideChar): PWideChar;
function CkCache_GetEtag(objHandle: HCkCache; key: PWideChar; outStr: HCkString): wordbool;
function CkCache__getEtag(objHandle: HCkCache; key: PWideChar): PWideChar;
function CkCache_GetExpirationDt(objHandle: HCkCache; key: PWideChar): HCkDateTime;
function CkCache_GetExpirationStr(objHandle: HCkCache; url: PWideChar; outStr: HCkString): wordbool;
function CkCache__getExpirationStr(objHandle: HCkCache; url: PWideChar): PWideChar;
function CkCache_GetFilename(objHandle: HCkCache; key: PWideChar; outStr: HCkString): wordbool;
function CkCache__getFilename(objHandle: HCkCache; key: PWideChar): PWideChar;
function CkCache_GetRoot(objHandle: HCkCache; index: Integer; outStr: HCkString): wordbool;
function CkCache__getRoot(objHandle: HCkCache; index: Integer): PWideChar;
function CkCache_IsCached(objHandle: HCkCache; key: PWideChar): wordbool;
function CkCache_SaveBd(objHandle: HCkCache; key: PWideChar; expiration: PWideChar; etag: PWideChar; bd: HCkBinData): wordbool;
function CkCache_SaveTextDt(objHandle: HCkCache; key: PWideChar; expireDateTime: HCkDateTime; eTag: PWideChar; itemTextData: PWideChar): wordbool;
function CkCache_SaveTextNoExpire(objHandle: HCkCache; key: PWideChar; eTag: PWideChar; itemTextData: PWideChar): wordbool;
function CkCache_SaveTextStr(objHandle: HCkCache; key: PWideChar; expireDateTime: PWideChar; eTag: PWideChar; itemTextData: PWideChar): wordbool;
function CkCache_SaveToCacheDt(objHandle: HCkCache; key: PWideChar; expireDateTime: HCkDateTime; eTag: PWideChar; itemData: HCkByteData): wordbool;
function CkCache_SaveToCacheNoExpire(objHandle: HCkCache; key: PWideChar; eTag: PWideChar; itemData: HCkByteData): wordbool;
function CkCache_SaveToCacheStr(objHandle: HCkCache; key: PWideChar; expireDateTime: PWideChar; eTag: PWideChar; itemData: HCkByteData): wordbool;
function CkCache_UpdateExpirationDt(objHandle: HCkCache; key: PWideChar; expireDateTime: HCkDateTime): wordbool;
function CkCache_UpdateExpirationStr(objHandle: HCkCache; key: PWideChar; expireDateTime: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkCache_Create = function : HCkCache; stdcall;
  TCkCache_Dispose = procedure (handle: HCkCache); stdcall;
  TCkCache_getDebugLogFilePath = procedure (objHandle: HCkCache; outPropVal: HCkString); stdcall;
  TCkCache_putDebugLogFilePath = procedure (objHandle: HCkCache; newPropVal: PWideChar); stdcall;
  TCkCache__debugLogFilePath = function (objHandle: HCkCache): PWideChar; stdcall;
  TCkCache_getLastErrorHtml = procedure (objHandle: HCkCache; outPropVal: HCkString); stdcall;
  TCkCache__lastErrorHtml = function (objHandle: HCkCache): PWideChar; stdcall;
  TCkCache_getLastErrorText = procedure (objHandle: HCkCache; outPropVal: HCkString); stdcall;
  TCkCache__lastErrorText = function (objHandle: HCkCache): PWideChar; stdcall;
  TCkCache_getLastErrorXml = procedure (objHandle: HCkCache; outPropVal: HCkString); stdcall;
  TCkCache__lastErrorXml = function (objHandle: HCkCache): PWideChar; stdcall;
  TCkCache_getLastEtagFetched = procedure (objHandle: HCkCache; outPropVal: HCkString); stdcall;
  TCkCache__lastEtagFetched = function (objHandle: HCkCache): PWideChar; stdcall;
  TCkCache_getLastExpirationFetchedStr = procedure (objHandle: HCkCache; outPropVal: HCkString); stdcall;
  TCkCache__lastExpirationFetchedStr = function (objHandle: HCkCache): PWideChar; stdcall;
  TCkCache_getLastHitExpired = function (objHandle: HCkCache): wordbool; stdcall;
  TCkCache_getLastKeyFetched = procedure (objHandle: HCkCache; outPropVal: HCkString); stdcall;
  TCkCache__lastKeyFetched = function (objHandle: HCkCache): PWideChar; stdcall;
  TCkCache_getLastMethodSuccess = function (objHandle: HCkCache): wordbool; stdcall;
  TCkCache_putLastMethodSuccess = procedure (objHandle: HCkCache; newPropVal: wordbool); stdcall;
  TCkCache_getLevel = function (objHandle: HCkCache): Integer; stdcall;
  TCkCache_putLevel = procedure (objHandle: HCkCache; newPropVal: Integer); stdcall;
  TCkCache_getNumRoots = function (objHandle: HCkCache): Integer; stdcall;
  TCkCache_getVerboseLogging = function (objHandle: HCkCache): wordbool; stdcall;
  TCkCache_putVerboseLogging = procedure (objHandle: HCkCache; newPropVal: wordbool); stdcall;
  TCkCache_getVersion = procedure (objHandle: HCkCache; outPropVal: HCkString); stdcall;
  TCkCache__version = function (objHandle: HCkCache): PWideChar; stdcall;
  TCkCache_AddRoot = procedure (objHandle: HCkCache; path: PWideChar); stdcall;
  TCkCache_DeleteAll = function (objHandle: HCkCache): Integer; stdcall;
  TCkCache_DeleteAllExpired = function (objHandle: HCkCache): Integer; stdcall;
  TCkCache_DeleteFromCache = function (objHandle: HCkCache; key: PWideChar): wordbool; stdcall;
  TCkCache_DeleteOlderDt = function (objHandle: HCkCache; dateTime: HCkDateTime): Integer; stdcall;
  TCkCache_DeleteOlderStr = function (objHandle: HCkCache; dateTimeStr: PWideChar): Integer; stdcall;
  TCkCache_FetchBd = function (objHandle: HCkCache; key: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkCache_FetchFromCache = function (objHandle: HCkCache; key: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkCache_FetchSb = function (objHandle: HCkCache; key: PWideChar; sb: HCkStringBuilder): wordbool; stdcall;
  TCkCache_FetchText = function (objHandle: HCkCache; key: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCache__fetchText = function (objHandle: HCkCache; key: PWideChar): PWideChar; stdcall;
  TCkCache_GetEtag = function (objHandle: HCkCache; key: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCache__getEtag = function (objHandle: HCkCache; key: PWideChar): PWideChar; stdcall;
  TCkCache_GetExpirationDt = function (objHandle: HCkCache; key: PWideChar): HCkDateTime; stdcall;
  TCkCache_GetExpirationStr = function (objHandle: HCkCache; url: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCache__getExpirationStr = function (objHandle: HCkCache; url: PWideChar): PWideChar; stdcall;
  TCkCache_GetFilename = function (objHandle: HCkCache; key: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCache__getFilename = function (objHandle: HCkCache; key: PWideChar): PWideChar; stdcall;
  TCkCache_GetRoot = function (objHandle: HCkCache; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkCache__getRoot = function (objHandle: HCkCache; index: Integer): PWideChar; stdcall;
  TCkCache_IsCached = function (objHandle: HCkCache; key: PWideChar): wordbool; stdcall;
  TCkCache_SaveBd = function (objHandle: HCkCache; key: PWideChar; expiration: PWideChar; etag: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkCache_SaveTextDt = function (objHandle: HCkCache; key: PWideChar; expireDateTime: HCkDateTime; eTag: PWideChar; itemTextData: PWideChar): wordbool; stdcall;
  TCkCache_SaveTextNoExpire = function (objHandle: HCkCache; key: PWideChar; eTag: PWideChar; itemTextData: PWideChar): wordbool; stdcall;
  TCkCache_SaveTextStr = function (objHandle: HCkCache; key: PWideChar; expireDateTime: PWideChar; eTag: PWideChar; itemTextData: PWideChar): wordbool; stdcall;
  TCkCache_SaveToCacheDt = function (objHandle: HCkCache; key: PWideChar; expireDateTime: HCkDateTime; eTag: PWideChar; itemData: HCkByteData): wordbool; stdcall;
  TCkCache_SaveToCacheNoExpire = function (objHandle: HCkCache; key: PWideChar; eTag: PWideChar; itemData: HCkByteData): wordbool; stdcall;
  TCkCache_SaveToCacheStr = function (objHandle: HCkCache; key: PWideChar; expireDateTime: PWideChar; eTag: PWideChar; itemData: HCkByteData): wordbool; stdcall;
  TCkCache_UpdateExpirationDt = function (objHandle: HCkCache; key: PWideChar; expireDateTime: HCkDateTime): wordbool; stdcall;
  TCkCache_UpdateExpirationStr = function (objHandle: HCkCache; key: PWideChar; expireDateTime: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..56] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkCache_Create : HCkCache;
begin
  result := TCkCache_Create(_map(0, 'CkCache_Create'));
end;

procedure CkCache_Dispose (handle: HCkCache);
begin
  TCkCache_Dispose(_map(1, 'CkCache_Dispose'))
    (handle);
end;


procedure CkCache_getDebugLogFilePath (objHandle: HCkCache; outPropVal: HCkString);
begin
  TCkCache_getDebugLogFilePath(_map(2, 'CkCache_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkCache_putDebugLogFilePath (objHandle: HCkCache; newPropVal: PWideChar);
begin
  TCkCache_putDebugLogFilePath(_map(3, 'CkCache_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkCache__debugLogFilePath (objHandle: HCkCache): PWideChar;
begin
  result := TCkCache__debugLogFilePath(_map(4, 'CkCache__debugLogFilePath'))
    (objHandle);
end;

procedure CkCache_getLastErrorHtml (objHandle: HCkCache; outPropVal: HCkString);
begin
  TCkCache_getLastErrorHtml(_map(5, 'CkCache_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkCache__lastErrorHtml (objHandle: HCkCache): PWideChar;
begin
  result := TCkCache__lastErrorHtml(_map(6, 'CkCache__lastErrorHtml'))
    (objHandle);
end;

procedure CkCache_getLastErrorText (objHandle: HCkCache; outPropVal: HCkString);
begin
  TCkCache_getLastErrorText(_map(7, 'CkCache_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkCache__lastErrorText (objHandle: HCkCache): PWideChar;
begin
  result := TCkCache__lastErrorText(_map(8, 'CkCache__lastErrorText'))
    (objHandle);
end;

procedure CkCache_getLastErrorXml (objHandle: HCkCache; outPropVal: HCkString);
begin
  TCkCache_getLastErrorXml(_map(9, 'CkCache_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkCache__lastErrorXml (objHandle: HCkCache): PWideChar;
begin
  result := TCkCache__lastErrorXml(_map(10, 'CkCache__lastErrorXml'))
    (objHandle);
end;

procedure CkCache_getLastEtagFetched (objHandle: HCkCache; outPropVal: HCkString);
begin
  TCkCache_getLastEtagFetched(_map(11, 'CkCache_getLastEtagFetched'))
    (objHandle, outPropVal);
end;

function CkCache__lastEtagFetched (objHandle: HCkCache): PWideChar;
begin
  result := TCkCache__lastEtagFetched(_map(12, 'CkCache__lastEtagFetched'))
    (objHandle);
end;

procedure CkCache_getLastExpirationFetchedStr (objHandle: HCkCache; outPropVal: HCkString);
begin
  TCkCache_getLastExpirationFetchedStr(_map(13, 'CkCache_getLastExpirationFetchedStr'))
    (objHandle, outPropVal);
end;

function CkCache__lastExpirationFetchedStr (objHandle: HCkCache): PWideChar;
begin
  result := TCkCache__lastExpirationFetchedStr(_map(14, 'CkCache__lastExpirationFetchedStr'))
    (objHandle);
end;

function CkCache_getLastHitExpired (objHandle: HCkCache): wordbool;
begin
    result := TCkCache_getLastHitExpired(_map(15, 'CkCache_getLastHitExpired'))
    (objHandle);
end;

procedure CkCache_getLastKeyFetched (objHandle: HCkCache; outPropVal: HCkString);
begin
  TCkCache_getLastKeyFetched(_map(16, 'CkCache_getLastKeyFetched'))
    (objHandle, outPropVal);
end;

function CkCache__lastKeyFetched (objHandle: HCkCache): PWideChar;
begin
  result := TCkCache__lastKeyFetched(_map(17, 'CkCache__lastKeyFetched'))
    (objHandle);
end;

function CkCache_getLastMethodSuccess (objHandle: HCkCache): wordbool;
begin
    result := TCkCache_getLastMethodSuccess(_map(18, 'CkCache_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkCache_putLastMethodSuccess (objHandle: HCkCache; newPropVal: wordbool);
begin
  TCkCache_putLastMethodSuccess(_map(19, 'CkCache_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkCache_getLevel (objHandle: HCkCache): Integer;
begin
    result := TCkCache_getLevel(_map(20, 'CkCache_getLevel'))
    (objHandle);
end;

procedure CkCache_putLevel (objHandle: HCkCache; newPropVal: Integer);
begin
  TCkCache_putLevel(_map(21, 'CkCache_putLevel'))
    (objHandle, newPropVal);
end;

function CkCache_getNumRoots (objHandle: HCkCache): Integer;
begin
    result := TCkCache_getNumRoots(_map(22, 'CkCache_getNumRoots'))
    (objHandle);
end;

function CkCache_getVerboseLogging (objHandle: HCkCache): wordbool;
begin
    result := TCkCache_getVerboseLogging(_map(23, 'CkCache_getVerboseLogging'))
    (objHandle);
end;

procedure CkCache_putVerboseLogging (objHandle: HCkCache; newPropVal: wordbool);
begin
  TCkCache_putVerboseLogging(_map(24, 'CkCache_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkCache_getVersion (objHandle: HCkCache; outPropVal: HCkString);
begin
  TCkCache_getVersion(_map(25, 'CkCache_getVersion'))
    (objHandle, outPropVal);
end;

function CkCache__version (objHandle: HCkCache): PWideChar;
begin
  result := TCkCache__version(_map(26, 'CkCache__version'))
    (objHandle);
end;

procedure CkCache_AddRoot (objHandle: HCkCache; path: PWideChar);
begin
  TCkCache_AddRoot(_map(27, 'CkCache_AddRoot'))
    (objHandle, path);
end;

function CkCache_DeleteAll (objHandle: HCkCache): Integer;
begin
  result := TCkCache_DeleteAll(_map(28, 'CkCache_DeleteAll'))
    (objHandle);
end;

function CkCache_DeleteAllExpired (objHandle: HCkCache): Integer;
begin
  result := TCkCache_DeleteAllExpired(_map(29, 'CkCache_DeleteAllExpired'))
    (objHandle);
end;

function CkCache_DeleteFromCache (objHandle: HCkCache; key: PWideChar): wordbool;
begin
  result := TCkCache_DeleteFromCache(_map(30, 'CkCache_DeleteFromCache'))
    (objHandle, key);
end;

function CkCache_DeleteOlderDt (objHandle: HCkCache; dateTime: HCkDateTime): Integer;
begin
  result := TCkCache_DeleteOlderDt(_map(31, 'CkCache_DeleteOlderDt'))
    (objHandle, dateTime);
end;

function CkCache_DeleteOlderStr (objHandle: HCkCache; dateTimeStr: PWideChar): Integer;
begin
  result := TCkCache_DeleteOlderStr(_map(32, 'CkCache_DeleteOlderStr'))
    (objHandle, dateTimeStr);
end;

function CkCache_FetchBd (objHandle: HCkCache; key: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkCache_FetchBd(_map(33, 'CkCache_FetchBd'))
    (objHandle, key, bd);
end;

function CkCache_FetchFromCache (objHandle: HCkCache; key: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkCache_FetchFromCache(_map(34, 'CkCache_FetchFromCache'))
    (objHandle, key, outData);
end;

function CkCache_FetchSb (objHandle: HCkCache; key: PWideChar; sb: HCkStringBuilder): wordbool;
begin
  result := TCkCache_FetchSb(_map(35, 'CkCache_FetchSb'))
    (objHandle, key, sb);
end;

function CkCache_FetchText (objHandle: HCkCache; key: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCache_FetchText(_map(36, 'CkCache_FetchText'))
    (objHandle, key, outStr);
end;

function CkCache__fetchText (objHandle: HCkCache; key: PWideChar): PWideChar;
begin
  result := TCkCache__fetchText(_map(37, 'CkCache__fetchText'))
    (objHandle, key);
end;

function CkCache_GetEtag (objHandle: HCkCache; key: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCache_GetEtag(_map(38, 'CkCache_GetEtag'))
    (objHandle, key, outStr);
end;

function CkCache__getEtag (objHandle: HCkCache; key: PWideChar): PWideChar;
begin
  result := TCkCache__getEtag(_map(39, 'CkCache__getEtag'))
    (objHandle, key);
end;

function CkCache_GetExpirationDt (objHandle: HCkCache; key: PWideChar): HCkDateTime;
begin
  result := TCkCache_GetExpirationDt(_map(40, 'CkCache_GetExpirationDt'))
    (objHandle, key);
end;

function CkCache_GetExpirationStr (objHandle: HCkCache; url: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCache_GetExpirationStr(_map(41, 'CkCache_GetExpirationStr'))
    (objHandle, url, outStr);
end;

function CkCache__getExpirationStr (objHandle: HCkCache; url: PWideChar): PWideChar;
begin
  result := TCkCache__getExpirationStr(_map(42, 'CkCache__getExpirationStr'))
    (objHandle, url);
end;

function CkCache_GetFilename (objHandle: HCkCache; key: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCache_GetFilename(_map(43, 'CkCache_GetFilename'))
    (objHandle, key, outStr);
end;

function CkCache__getFilename (objHandle: HCkCache; key: PWideChar): PWideChar;
begin
  result := TCkCache__getFilename(_map(44, 'CkCache__getFilename'))
    (objHandle, key);
end;

function CkCache_GetRoot (objHandle: HCkCache; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkCache_GetRoot(_map(45, 'CkCache_GetRoot'))
    (objHandle, index, outStr);
end;

function CkCache__getRoot (objHandle: HCkCache; index: Integer): PWideChar;
begin
  result := TCkCache__getRoot(_map(46, 'CkCache__getRoot'))
    (objHandle, index);
end;

function CkCache_IsCached (objHandle: HCkCache; key: PWideChar): wordbool;
begin
  result := TCkCache_IsCached(_map(47, 'CkCache_IsCached'))
    (objHandle, key);
end;

function CkCache_SaveBd (objHandle: HCkCache; key: PWideChar; expiration: PWideChar; etag: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkCache_SaveBd(_map(48, 'CkCache_SaveBd'))
    (objHandle, key, expiration, etag, bd);
end;

function CkCache_SaveTextDt (objHandle: HCkCache; key: PWideChar; expireDateTime: HCkDateTime; eTag: PWideChar; itemTextData: PWideChar): wordbool;
begin
  result := TCkCache_SaveTextDt(_map(49, 'CkCache_SaveTextDt'))
    (objHandle, key, expireDateTime, eTag, itemTextData);
end;

function CkCache_SaveTextNoExpire (objHandle: HCkCache; key: PWideChar; eTag: PWideChar; itemTextData: PWideChar): wordbool;
begin
  result := TCkCache_SaveTextNoExpire(_map(50, 'CkCache_SaveTextNoExpire'))
    (objHandle, key, eTag, itemTextData);
end;

function CkCache_SaveTextStr (objHandle: HCkCache; key: PWideChar; expireDateTime: PWideChar; eTag: PWideChar; itemTextData: PWideChar): wordbool;
begin
  result := TCkCache_SaveTextStr(_map(51, 'CkCache_SaveTextStr'))
    (objHandle, key, expireDateTime, eTag, itemTextData);
end;

function CkCache_SaveToCacheDt (objHandle: HCkCache; key: PWideChar; expireDateTime: HCkDateTime; eTag: PWideChar; itemData: HCkByteData): wordbool;
begin
  result := TCkCache_SaveToCacheDt(_map(52, 'CkCache_SaveToCacheDt'))
    (objHandle, key, expireDateTime, eTag, itemData);
end;

function CkCache_SaveToCacheNoExpire (objHandle: HCkCache; key: PWideChar; eTag: PWideChar; itemData: HCkByteData): wordbool;
begin
  result := TCkCache_SaveToCacheNoExpire(_map(53, 'CkCache_SaveToCacheNoExpire'))
    (objHandle, key, eTag, itemData);
end;

function CkCache_SaveToCacheStr (objHandle: HCkCache; key: PWideChar; expireDateTime: PWideChar; eTag: PWideChar; itemData: HCkByteData): wordbool;
begin
  result := TCkCache_SaveToCacheStr(_map(54, 'CkCache_SaveToCacheStr'))
    (objHandle, key, expireDateTime, eTag, itemData);
end;

function CkCache_UpdateExpirationDt (objHandle: HCkCache; key: PWideChar; expireDateTime: HCkDateTime): wordbool;
begin
  result := TCkCache_UpdateExpirationDt(_map(55, 'CkCache_UpdateExpirationDt'))
    (objHandle, key, expireDateTime);
end;

function CkCache_UpdateExpirationStr (objHandle: HCkCache; key: PWideChar; expireDateTime: PWideChar): wordbool;
begin
  result := TCkCache_UpdateExpirationStr(_map(56, 'CkCache_UpdateExpirationStr'))
    (objHandle, key, expireDateTime);
end;

end.
