unit CertChain;

interface

type

HCkCert = Pointer;
HCkCertChain = Pointer;
HCkJsonObject = Pointer;
HCkTrustedRoots = Pointer;
HCkString = Pointer;


function CkCertChain_Create: HCkCertChain;  stdcall;
procedure CkCertChain_Dispose(handle: HCkCertChain); stdcall;
procedure CkCertChain_getDebugLogFilePath(objHandle: HCkCertChain; outPropVal: HCkString);
procedure CkCertChain_putDebugLogFilePath(objHandle: HCkCertChain; newPropVal: PWideChar);
function CkCertChain__debugLogFilePath(objHandle: HCkCertChain): PWideChar;
procedure CkCertChain_getLastErrorHtml(objHandle: HCkCertChain; outPropVal: HCkString);
function CkCertChain__lastErrorHtml(objHandle: HCkCertChain): PWideChar;
procedure CkCertChain_getLastErrorText(objHandle: HCkCertChain; outPropVal: HCkString);
function CkCertChain__lastErrorText(objHandle: HCkCertChain): PWideChar;
procedure CkCertChain_getLastErrorXml(objHandle: HCkCertChain; outPropVal: HCkString);
function CkCertChain__lastErrorXml(objHandle: HCkCertChain): PWideChar;
function CkCertChain_getLastMethodSuccess(objHandle: HCkCertChain): wordbool;
procedure CkCertChain_putLastMethodSuccess(objHandle: HCkCertChain; newPropVal: wordbool);
function CkCertChain_getNumCerts(objHandle: HCkCertChain): Integer;
function CkCertChain_getNumExpiredCerts(objHandle: HCkCertChain): Integer;
function CkCertChain_getReachesRoot(objHandle: HCkCertChain): wordbool;
procedure CkCertChain_getUncommonOptions(objHandle: HCkCertChain; outPropVal: HCkString);
procedure CkCertChain_putUncommonOptions(objHandle: HCkCertChain; newPropVal: PWideChar);
function CkCertChain__uncommonOptions(objHandle: HCkCertChain): PWideChar;
function CkCertChain_getVerboseLogging(objHandle: HCkCertChain): wordbool;
procedure CkCertChain_putVerboseLogging(objHandle: HCkCertChain; newPropVal: wordbool);
procedure CkCertChain_getVersion(objHandle: HCkCertChain; outPropVal: HCkString);
function CkCertChain__version(objHandle: HCkCertChain): PWideChar;
function CkCertChain_CertAt(objHandle: HCkCertChain; index: Integer; cert: HCkCert): wordbool;
function CkCertChain_GetCert(objHandle: HCkCertChain; index: Integer): HCkCert;
function CkCertChain_IsRootTrusted(objHandle: HCkCertChain; trustedRoots: HCkTrustedRoots): wordbool;
function CkCertChain_LoadX5C(objHandle: HCkCertChain; jwk: HCkJsonObject): wordbool;
function CkCertChain_VerifyCertSignatures(objHandle: HCkCertChain): wordbool;
function CkCertChain_X509PKIPathv1(objHandle: HCkCertChain; outStr: HCkString): wordbool;
function CkCertChain__x509PKIPathv1(objHandle: HCkCertChain): PWideChar;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkCertChain_Create = function : HCkCertChain; stdcall;
  TCkCertChain_Dispose = procedure (handle: HCkCertChain); stdcall;
  TCkCertChain_getDebugLogFilePath = procedure (objHandle: HCkCertChain; outPropVal: HCkString); stdcall;
  TCkCertChain_putDebugLogFilePath = procedure (objHandle: HCkCertChain; newPropVal: PWideChar); stdcall;
  TCkCertChain__debugLogFilePath = function (objHandle: HCkCertChain): PWideChar; stdcall;
  TCkCertChain_getLastErrorHtml = procedure (objHandle: HCkCertChain; outPropVal: HCkString); stdcall;
  TCkCertChain__lastErrorHtml = function (objHandle: HCkCertChain): PWideChar; stdcall;
  TCkCertChain_getLastErrorText = procedure (objHandle: HCkCertChain; outPropVal: HCkString); stdcall;
  TCkCertChain__lastErrorText = function (objHandle: HCkCertChain): PWideChar; stdcall;
  TCkCertChain_getLastErrorXml = procedure (objHandle: HCkCertChain; outPropVal: HCkString); stdcall;
  TCkCertChain__lastErrorXml = function (objHandle: HCkCertChain): PWideChar; stdcall;
  TCkCertChain_getLastMethodSuccess = function (objHandle: HCkCertChain): wordbool; stdcall;
  TCkCertChain_putLastMethodSuccess = procedure (objHandle: HCkCertChain; newPropVal: wordbool); stdcall;
  TCkCertChain_getNumCerts = function (objHandle: HCkCertChain): Integer; stdcall;
  TCkCertChain_getNumExpiredCerts = function (objHandle: HCkCertChain): Integer; stdcall;
  TCkCertChain_getReachesRoot = function (objHandle: HCkCertChain): wordbool; stdcall;
  TCkCertChain_getUncommonOptions = procedure (objHandle: HCkCertChain; outPropVal: HCkString); stdcall;
  TCkCertChain_putUncommonOptions = procedure (objHandle: HCkCertChain; newPropVal: PWideChar); stdcall;
  TCkCertChain__uncommonOptions = function (objHandle: HCkCertChain): PWideChar; stdcall;
  TCkCertChain_getVerboseLogging = function (objHandle: HCkCertChain): wordbool; stdcall;
  TCkCertChain_putVerboseLogging = procedure (objHandle: HCkCertChain; newPropVal: wordbool); stdcall;
  TCkCertChain_getVersion = procedure (objHandle: HCkCertChain; outPropVal: HCkString); stdcall;
  TCkCertChain__version = function (objHandle: HCkCertChain): PWideChar; stdcall;
  TCkCertChain_CertAt = function (objHandle: HCkCertChain; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkCertChain_GetCert = function (objHandle: HCkCertChain; index: Integer): HCkCert; stdcall;
  TCkCertChain_IsRootTrusted = function (objHandle: HCkCertChain; trustedRoots: HCkTrustedRoots): wordbool; stdcall;
  TCkCertChain_LoadX5C = function (objHandle: HCkCertChain; jwk: HCkJsonObject): wordbool; stdcall;
  TCkCertChain_VerifyCertSignatures = function (objHandle: HCkCertChain): wordbool; stdcall;
  TCkCertChain_X509PKIPathv1 = function (objHandle: HCkCertChain; outStr: HCkString): wordbool; stdcall;
  TCkCertChain__x509PKIPathv1 = function (objHandle: HCkCertChain): PWideChar; stdcall;

var
  _fkt_ptr_arr:   array [0..29] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkCertChain_Create : HCkCertChain;
begin
  result := TCkCertChain_Create(_map(0, 'CkCertChain_Create'));
end;

procedure CkCertChain_Dispose (handle: HCkCertChain);
begin
  TCkCertChain_Dispose(_map(1, 'CkCertChain_Dispose'))
    (handle);
end;


procedure CkCertChain_getDebugLogFilePath (objHandle: HCkCertChain; outPropVal: HCkString);
begin
  TCkCertChain_getDebugLogFilePath(_map(2, 'CkCertChain_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkCertChain_putDebugLogFilePath (objHandle: HCkCertChain; newPropVal: PWideChar);
begin
  TCkCertChain_putDebugLogFilePath(_map(3, 'CkCertChain_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkCertChain__debugLogFilePath (objHandle: HCkCertChain): PWideChar;
begin
  result := TCkCertChain__debugLogFilePath(_map(4, 'CkCertChain__debugLogFilePath'))
    (objHandle);
end;

procedure CkCertChain_getLastErrorHtml (objHandle: HCkCertChain; outPropVal: HCkString);
begin
  TCkCertChain_getLastErrorHtml(_map(5, 'CkCertChain_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkCertChain__lastErrorHtml (objHandle: HCkCertChain): PWideChar;
begin
  result := TCkCertChain__lastErrorHtml(_map(6, 'CkCertChain__lastErrorHtml'))
    (objHandle);
end;

procedure CkCertChain_getLastErrorText (objHandle: HCkCertChain; outPropVal: HCkString);
begin
  TCkCertChain_getLastErrorText(_map(7, 'CkCertChain_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkCertChain__lastErrorText (objHandle: HCkCertChain): PWideChar;
begin
  result := TCkCertChain__lastErrorText(_map(8, 'CkCertChain__lastErrorText'))
    (objHandle);
end;

procedure CkCertChain_getLastErrorXml (objHandle: HCkCertChain; outPropVal: HCkString);
begin
  TCkCertChain_getLastErrorXml(_map(9, 'CkCertChain_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkCertChain__lastErrorXml (objHandle: HCkCertChain): PWideChar;
begin
  result := TCkCertChain__lastErrorXml(_map(10, 'CkCertChain__lastErrorXml'))
    (objHandle);
end;

function CkCertChain_getLastMethodSuccess (objHandle: HCkCertChain): wordbool;
begin
    result := TCkCertChain_getLastMethodSuccess(_map(11, 'CkCertChain_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkCertChain_putLastMethodSuccess (objHandle: HCkCertChain; newPropVal: wordbool);
begin
  TCkCertChain_putLastMethodSuccess(_map(12, 'CkCertChain_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkCertChain_getNumCerts (objHandle: HCkCertChain): Integer;
begin
    result := TCkCertChain_getNumCerts(_map(13, 'CkCertChain_getNumCerts'))
    (objHandle);
end;

function CkCertChain_getNumExpiredCerts (objHandle: HCkCertChain): Integer;
begin
    result := TCkCertChain_getNumExpiredCerts(_map(14, 'CkCertChain_getNumExpiredCerts'))
    (objHandle);
end;

function CkCertChain_getReachesRoot (objHandle: HCkCertChain): wordbool;
begin
    result := TCkCertChain_getReachesRoot(_map(15, 'CkCertChain_getReachesRoot'))
    (objHandle);
end;

procedure CkCertChain_getUncommonOptions (objHandle: HCkCertChain; outPropVal: HCkString);
begin
  TCkCertChain_getUncommonOptions(_map(16, 'CkCertChain_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkCertChain_putUncommonOptions (objHandle: HCkCertChain; newPropVal: PWideChar);
begin
  TCkCertChain_putUncommonOptions(_map(17, 'CkCertChain_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkCertChain__uncommonOptions (objHandle: HCkCertChain): PWideChar;
begin
  result := TCkCertChain__uncommonOptions(_map(18, 'CkCertChain__uncommonOptions'))
    (objHandle);
end;

function CkCertChain_getVerboseLogging (objHandle: HCkCertChain): wordbool;
begin
    result := TCkCertChain_getVerboseLogging(_map(19, 'CkCertChain_getVerboseLogging'))
    (objHandle);
end;

procedure CkCertChain_putVerboseLogging (objHandle: HCkCertChain; newPropVal: wordbool);
begin
  TCkCertChain_putVerboseLogging(_map(20, 'CkCertChain_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkCertChain_getVersion (objHandle: HCkCertChain; outPropVal: HCkString);
begin
  TCkCertChain_getVersion(_map(21, 'CkCertChain_getVersion'))
    (objHandle, outPropVal);
end;

function CkCertChain__version (objHandle: HCkCertChain): PWideChar;
begin
  result := TCkCertChain__version(_map(22, 'CkCertChain__version'))
    (objHandle);
end;

function CkCertChain_CertAt (objHandle: HCkCertChain; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkCertChain_CertAt(_map(23, 'CkCertChain_CertAt'))
    (objHandle, index, cert);
end;

function CkCertChain_GetCert (objHandle: HCkCertChain; index: Integer): HCkCert;
begin
  result := TCkCertChain_GetCert(_map(24, 'CkCertChain_GetCert'))
    (objHandle, index);
end;

function CkCertChain_IsRootTrusted (objHandle: HCkCertChain; trustedRoots: HCkTrustedRoots): wordbool;
begin
  result := TCkCertChain_IsRootTrusted(_map(25, 'CkCertChain_IsRootTrusted'))
    (objHandle, trustedRoots);
end;

function CkCertChain_LoadX5C (objHandle: HCkCertChain; jwk: HCkJsonObject): wordbool;
begin
  result := TCkCertChain_LoadX5C(_map(26, 'CkCertChain_LoadX5C'))
    (objHandle, jwk);
end;

function CkCertChain_VerifyCertSignatures (objHandle: HCkCertChain): wordbool;
begin
  result := TCkCertChain_VerifyCertSignatures(_map(27, 'CkCertChain_VerifyCertSignatures'))
    (objHandle);
end;

function CkCertChain_X509PKIPathv1 (objHandle: HCkCertChain; outStr: HCkString): wordbool;
begin
  result := TCkCertChain_X509PKIPathv1(_map(28, 'CkCertChain_X509PKIPathv1'))
    (objHandle, outStr);
end;

function CkCertChain__x509PKIPathv1 (objHandle: HCkCertChain): PWideChar;
begin
  result := TCkCertChain__x509PKIPathv1(_map(29, 'CkCertChain__x509PKIPathv1'))
    (objHandle);
end;

end.
