unit CkByteData;

interface

type

HCkByteData = Pointer;
HCkString = Pointer;


function CkByteData_Create: HCkByteData;  stdcall;
procedure CkByteData_Dispose(handle: HCkByteData); stdcall;
function CkByteData_getSecureClear(objHandle: HCkByteData): wordbool;
procedure CkByteData_putSecureClear(objHandle: HCkByteData; newPropVal: wordbool);
procedure CkByteData_append(objHandle: HCkByteData; db: HCkByteData);
procedure CkByteData_appendChar(objHandle: HCkByteData; ch: Char);
procedure CkByteData_appendCharN(objHandle: HCkByteData; ch: Char; numTimes: Integer);
procedure CkByteData_appendEncoded(objHandle: HCkByteData; str: pbyte; encoding: pbyte);
procedure CkByteData_appendEncodedW(objHandle: HCkByteData; str: PWideChar; encoding: PWideChar);
function CkByteData_appendFile(objHandle: HCkByteData; path: pbyte): wordbool;
function CkByteData_appendFileW(objHandle: HCkByteData; path: PWideChar): wordbool;
procedure CkByteData_appendInt(objHandle: HCkByteData; intValue: Integer; littleEndian: wordbool);
procedure CkByteData_appendRandom(objHandle: HCkByteData; numBytes: Integer);
procedure CkByteData_appendRange(objHandle: HCkByteData; byteData: HCkByteData; index: LongWord; numBytes: LongWord);
procedure CkByteData_appendShort(objHandle: HCkByteData; shortValue: SmallInt; littleEndian: wordbool);
procedure CkByteData_appendStr(objHandle: HCkByteData; str: pbyte);
procedure CkByteData_appendStrW(objHandle: HCkByteData; str: PWideChar; charset: PWideChar);
function CkByteData_beginsWith(objHandle: HCkByteData; byteDataObj: HCkByteData): wordbool;
procedure CkByteData_byteSwap4321(objHandle: HCkByteData);
procedure CkByteData_clear(objHandle: HCkByteData);
procedure CkByteData_dropData(objHandle: HCkByteData);
procedure CkByteData_encode(objHandle: HCkByteData; encoding: pbyte; str: HCkString);
procedure CkByteData_encodeW(objHandle: HCkByteData; encoding: PWideChar; str: HCkString);
function CkByteData_ensureBuffer(objHandle: HCkByteData; expectedNumBytes: LongWord): wordbool;
function CkByteData_equals(objHandle: HCkByteData; compareBytes: HCkByteData): wordbool;
function CkByteData_findBytes(objHandle: HCkByteData; byteDataObj: HCkByteData): Integer;
function CkByteData_getByte(objHandle: HCkByteData; byteIndex: LongWord): Byte;
function CkByteData_getBytes(objHandle: HCkByteData): pbyte;
function CkByteData_getChar(objHandle: HCkByteData; byteIndex: LongWord): Char;
function CkByteData_getData(objHandle: HCkByteData): pbyte;
function CkByteData_getDataAt(objHandle: HCkByteData; byteIndex: LongWord): pbyte;
function CkByteData_getEncoded(objHandle: HCkByteData; encoding: pbyte): pbyte;
function CkByteData_getEncodedW(objHandle: HCkByteData; encoding: PWideChar): PWideChar;
function CkByteData_getInt(objHandle: HCkByteData; byteIndex: LongWord): Integer;
function CkByteData_getRange(objHandle: HCkByteData; byteIndex: LongWord; numBytes: LongWord): pbyte;
function CkByteData_getSize(objHandle: HCkByteData): LongWord;
function CkByteData_getUInt(objHandle: HCkByteData; byteIndex: LongWord): LongWord;
function CkByteData_is7bit(objHandle: HCkByteData): wordbool;
function CkByteData_loadFile(objHandle: HCkByteData; path: pbyte): wordbool;
function CkByteData_loadFileW(objHandle: HCkByteData; path: PWideChar): wordbool;
procedure CkByteData_pad(objHandle: HCkByteData; blockSize: Integer; paddingScheme: Integer);
function CkByteData_preAllocate(objHandle: HCkByteData; expectedNumBytes: LongWord): wordbool;
procedure CkByteData_removeChunk(objHandle: HCkByteData; startIndex: LongWord; numBytes: LongWord);
function CkByteData_removeData(objHandle: HCkByteData): pbyte;
procedure CkByteData_replaceChar(objHandle: HCkByteData; existingByteValue: Byte; replacementByteValue: Byte);
function CkByteData_saveFile(objHandle: HCkByteData; path: pbyte): wordbool;
function CkByteData_saveFileW(objHandle: HCkByteData; path: PWideChar): wordbool;
procedure CkByteData_shorten(objHandle: HCkByteData; numBytes: LongWord);
function CkByteData_to_ws(objHandle: HCkByteData; charset: pbyte): PWideChar;
procedure CkByteData_unpad(objHandle: HCkByteData; blockSize: Integer; paddingScheme: Integer);
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkByteData_Create = function : HCkByteData; stdcall;
  TCkByteData_Dispose = procedure (handle: HCkByteData); stdcall;
  TCkByteData_getSecureClear = function (objHandle: HCkByteData): wordbool; stdcall;
  TCkByteData_putSecureClear = procedure (objHandle: HCkByteData; newPropVal: wordbool); stdcall;
  TCkByteData_append = procedure (objHandle: HCkByteData; db: HCkByteData); stdcall;
  TCkByteData_appendChar = procedure (objHandle: HCkByteData; ch: Char); stdcall;
  TCkByteData_appendCharN = procedure (objHandle: HCkByteData; ch: Char; numTimes: Integer); stdcall;
  TCkByteData_appendEncoded = procedure (objHandle: HCkByteData; str: pbyte; encoding: pbyte); stdcall;
  TCkByteData_appendEncodedW = procedure (objHandle: HCkByteData; str: PWideChar; encoding: PWideChar); stdcall;
  TCkByteData_appendFile = function (objHandle: HCkByteData; path: pbyte): wordbool; stdcall;
  TCkByteData_appendFileW = function (objHandle: HCkByteData; path: PWideChar): wordbool; stdcall;
  TCkByteData_appendInt = procedure (objHandle: HCkByteData; intValue: Integer; littleEndian: wordbool); stdcall;
  TCkByteData_appendRandom = procedure (objHandle: HCkByteData; numBytes: Integer); stdcall;
  TCkByteData_appendRange = procedure (objHandle: HCkByteData; byteData: HCkByteData; index: LongWord; numBytes: LongWord); stdcall;
  TCkByteData_appendShort = procedure (objHandle: HCkByteData; shortValue: SmallInt; littleEndian: wordbool); stdcall;
  TCkByteData_appendStr = procedure (objHandle: HCkByteData; str: pbyte); stdcall;
  TCkByteData_appendStrW = procedure (objHandle: HCkByteData; str: PWideChar; charset: PWideChar); stdcall;
  TCkByteData_beginsWith = function (objHandle: HCkByteData; byteDataObj: HCkByteData): wordbool; stdcall;
  TCkByteData_byteSwap4321 = procedure (objHandle: HCkByteData); stdcall;
  TCkByteData_clear = procedure (objHandle: HCkByteData); stdcall;
  TCkByteData_dropData = procedure (objHandle: HCkByteData); stdcall;
  TCkByteData_encode = procedure (objHandle: HCkByteData; encoding: pbyte; str: HCkString); stdcall;
  TCkByteData_encodeW = procedure (objHandle: HCkByteData; encoding: PWideChar; str: HCkString); stdcall;
  TCkByteData_ensureBuffer = function (objHandle: HCkByteData; expectedNumBytes: LongWord): wordbool; stdcall;
  TCkByteData_equals = function (objHandle: HCkByteData; compareBytes: HCkByteData): wordbool; stdcall;
  TCkByteData_findBytes = function (objHandle: HCkByteData; byteDataObj: HCkByteData): Integer; stdcall;
  TCkByteData_getByte = function (objHandle: HCkByteData; byteIndex: LongWord): Byte; stdcall;
  TCkByteData_getBytes = function (objHandle: HCkByteData): pbyte; stdcall;
  TCkByteData_getChar = function (objHandle: HCkByteData; byteIndex: LongWord): Char; stdcall;
  TCkByteData_getData = function (objHandle: HCkByteData): pbyte; stdcall;
  TCkByteData_getDataAt = function (objHandle: HCkByteData; byteIndex: LongWord): pbyte; stdcall;
  TCkByteData_getEncoded = function (objHandle: HCkByteData; encoding: pbyte): pbyte; stdcall;
  TCkByteData_getEncodedW = function (objHandle: HCkByteData; encoding: PWideChar): PWideChar; stdcall;
  TCkByteData_getInt = function (objHandle: HCkByteData; byteIndex: LongWord): Integer; stdcall;
  TCkByteData_getRange = function (objHandle: HCkByteData; byteIndex: LongWord; numBytes: LongWord): pbyte; stdcall;
  TCkByteData_getSize = function (objHandle: HCkByteData): LongWord; stdcall;
  TCkByteData_getUInt = function (objHandle: HCkByteData; byteIndex: LongWord): LongWord; stdcall;
  TCkByteData_is7bit = function (objHandle: HCkByteData): wordbool; stdcall;
  TCkByteData_loadFile = function (objHandle: HCkByteData; path: pbyte): wordbool; stdcall;
  TCkByteData_loadFileW = function (objHandle: HCkByteData; path: PWideChar): wordbool; stdcall;
  TCkByteData_pad = procedure (objHandle: HCkByteData; blockSize: Integer; paddingScheme: Integer); stdcall;
  TCkByteData_preAllocate = function (objHandle: HCkByteData; expectedNumBytes: LongWord): wordbool; stdcall;
  TCkByteData_removeChunk = procedure (objHandle: HCkByteData; startIndex: LongWord; numBytes: LongWord); stdcall;
  TCkByteData_removeData = function (objHandle: HCkByteData): pbyte; stdcall;
  TCkByteData_replaceChar = procedure (objHandle: HCkByteData; existingByteValue: Byte; replacementByteValue: Byte); stdcall;
  TCkByteData_saveFile = function (objHandle: HCkByteData; path: pbyte): wordbool; stdcall;
  TCkByteData_saveFileW = function (objHandle: HCkByteData; path: PWideChar): wordbool; stdcall;
  TCkByteData_shorten = procedure (objHandle: HCkByteData; numBytes: LongWord); stdcall;
  TCkByteData_to_ws = function (objHandle: HCkByteData; charset: pbyte): PWideChar; stdcall;
  TCkByteData_unpad = procedure (objHandle: HCkByteData; blockSize: Integer; paddingScheme: Integer); stdcall;

var
  _fkt_ptr_arr:   array [0..49] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkByteData_Create : HCkByteData;
begin
  result := TCkByteData_Create(_map(0, 'CkByteData_Create'));
end;

procedure CkByteData_Dispose (handle: HCkByteData);
begin
  TCkByteData_Dispose(_map(1, 'CkByteData_Dispose'))
    (handle);
end;


function CkByteData_getSecureClear (objHandle: HCkByteData): wordbool;
begin
    result := TCkByteData_getSecureClear(_map(2, 'CkByteData_getSecureClear'))
    (objHandle);
end;

procedure CkByteData_putSecureClear (objHandle: HCkByteData; newPropVal: wordbool);
begin
  TCkByteData_putSecureClear(_map(3, 'CkByteData_putSecureClear'))
    (objHandle, newPropVal);
end;

procedure CkByteData_append (objHandle: HCkByteData; db: HCkByteData);
begin
  TCkByteData_append(_map(4, 'CkByteData_append'))
    (objHandle, db);
end;

procedure CkByteData_appendChar (objHandle: HCkByteData; ch: Char);
begin
  TCkByteData_appendChar(_map(5, 'CkByteData_appendChar'))
    (objHandle, ch);
end;

procedure CkByteData_appendCharN (objHandle: HCkByteData; ch: Char; numTimes: Integer);
begin
  TCkByteData_appendCharN(_map(6, 'CkByteData_appendCharN'))
    (objHandle, ch, numTimes);
end;

procedure CkByteData_appendEncoded (objHandle: HCkByteData; str: pbyte; encoding: pbyte);
begin
  TCkByteData_appendEncoded(_map(7, 'CkByteData_appendEncoded'))
    (objHandle, str, encoding);
end;

procedure CkByteData_appendEncodedW (objHandle: HCkByteData; str: PWideChar; encoding: PWideChar);
begin
  TCkByteData_appendEncodedW(_map(8, 'CkByteData_appendEncodedW'))
    (objHandle, str, encoding);
end;

function CkByteData_appendFile (objHandle: HCkByteData; path: pbyte): wordbool;
begin
  result := TCkByteData_appendFile(_map(9, 'CkByteData_appendFile'))
    (objHandle, path);
end;

function CkByteData_appendFileW (objHandle: HCkByteData; path: PWideChar): wordbool;
begin
  result := TCkByteData_appendFileW(_map(10, 'CkByteData_appendFileW'))
    (objHandle, path);
end;

procedure CkByteData_appendInt (objHandle: HCkByteData; intValue: Integer; littleEndian: wordbool);
begin
  TCkByteData_appendInt(_map(11, 'CkByteData_appendInt'))
    (objHandle, intValue, littleEndian);
end;

procedure CkByteData_appendRandom (objHandle: HCkByteData; numBytes: Integer);
begin
  TCkByteData_appendRandom(_map(12, 'CkByteData_appendRandom'))
    (objHandle, numBytes);
end;

procedure CkByteData_appendRange (objHandle: HCkByteData; byteData: HCkByteData; index: LongWord; numBytes: LongWord);
begin
  TCkByteData_appendRange(_map(13, 'CkByteData_appendRange'))
    (objHandle, byteData, index, numBytes);
end;

procedure CkByteData_appendShort (objHandle: HCkByteData; shortValue: SmallInt; littleEndian: wordbool);
begin
  TCkByteData_appendShort(_map(14, 'CkByteData_appendShort'))
    (objHandle, shortValue, littleEndian);
end;

procedure CkByteData_appendStr (objHandle: HCkByteData; str: pbyte);
begin
  TCkByteData_appendStr(_map(15, 'CkByteData_appendStr'))
    (objHandle, str);
end;

procedure CkByteData_appendStrW (objHandle: HCkByteData; str: PWideChar; charset: PWideChar);
begin
  TCkByteData_appendStrW(_map(16, 'CkByteData_appendStrW'))
    (objHandle, str, charset);
end;

function CkByteData_beginsWith (objHandle: HCkByteData; byteDataObj: HCkByteData): wordbool;
begin
  result := TCkByteData_beginsWith(_map(17, 'CkByteData_beginsWith'))
    (objHandle, byteDataObj);
end;

procedure CkByteData_byteSwap4321 (objHandle: HCkByteData);
begin
  TCkByteData_byteSwap4321(_map(18, 'CkByteData_byteSwap4321'))
    (objHandle);
end;

procedure CkByteData_clear (objHandle: HCkByteData);
begin
  TCkByteData_clear(_map(19, 'CkByteData_clear'))
    (objHandle);
end;

procedure CkByteData_dropData (objHandle: HCkByteData);
begin
  TCkByteData_dropData(_map(20, 'CkByteData_dropData'))
    (objHandle);
end;

procedure CkByteData_encode (objHandle: HCkByteData; encoding: pbyte; str: HCkString);
begin
  TCkByteData_encode(_map(21, 'CkByteData_encode'))
    (objHandle, encoding, str);
end;

procedure CkByteData_encodeW (objHandle: HCkByteData; encoding: PWideChar; str: HCkString);
begin
  TCkByteData_encodeW(_map(22, 'CkByteData_encodeW'))
    (objHandle, encoding, str);
end;

function CkByteData_ensureBuffer (objHandle: HCkByteData; expectedNumBytes: LongWord): wordbool;
begin
  result := TCkByteData_ensureBuffer(_map(23, 'CkByteData_ensureBuffer'))
    (objHandle, expectedNumBytes);
end;

function CkByteData_equals (objHandle: HCkByteData; compareBytes: HCkByteData): wordbool;
begin
  result := TCkByteData_equals(_map(24, 'CkByteData_equals'))
    (objHandle, compareBytes);
end;

function CkByteData_findBytes (objHandle: HCkByteData; byteDataObj: HCkByteData): Integer;
begin
  result := TCkByteData_findBytes(_map(25, 'CkByteData_findBytes'))
    (objHandle, byteDataObj);
end;

function CkByteData_getByte (objHandle: HCkByteData; byteIndex: LongWord): Byte;
begin
  result := TCkByteData_getByte(_map(26, 'CkByteData_getByte'))
    (objHandle, byteIndex);
end;

function CkByteData_getBytes (objHandle: HCkByteData): pbyte;
begin
  result := TCkByteData_getBytes(_map(27, 'CkByteData_getBytes'))
    (objHandle);
end;

function CkByteData_getChar (objHandle: HCkByteData; byteIndex: LongWord): Char;
begin
  result := TCkByteData_getChar(_map(28, 'CkByteData_getChar'))
    (objHandle, byteIndex);
end;

function CkByteData_getData (objHandle: HCkByteData): pbyte;
begin
  result := TCkByteData_getData(_map(29, 'CkByteData_getData'))
    (objHandle);
end;

function CkByteData_getDataAt (objHandle: HCkByteData; byteIndex: LongWord): pbyte;
begin
  result := TCkByteData_getDataAt(_map(30, 'CkByteData_getDataAt'))
    (objHandle, byteIndex);
end;

function CkByteData_getEncoded (objHandle: HCkByteData; encoding: pbyte): pbyte;
begin
  result := TCkByteData_getEncoded(_map(31, 'CkByteData_getEncoded'))
    (objHandle, encoding);
end;

function CkByteData_getEncodedW (objHandle: HCkByteData; encoding: PWideChar): PWideChar;
begin
  result := TCkByteData_getEncodedW(_map(32, 'CkByteData_getEncodedW'))
    (objHandle, encoding);
end;

function CkByteData_getInt (objHandle: HCkByteData; byteIndex: LongWord): Integer;
begin
  result := TCkByteData_getInt(_map(33, 'CkByteData_getInt'))
    (objHandle, byteIndex);
end;

function CkByteData_getRange (objHandle: HCkByteData; byteIndex: LongWord; numBytes: LongWord): pbyte;
begin
  result := TCkByteData_getRange(_map(34, 'CkByteData_getRange'))
    (objHandle, byteIndex, numBytes);
end;

function CkByteData_getSize (objHandle: HCkByteData): LongWord;
begin
  result := TCkByteData_getSize(_map(35, 'CkByteData_getSize'))
    (objHandle);
end;

function CkByteData_getUInt (objHandle: HCkByteData; byteIndex: LongWord): LongWord;
begin
  result := TCkByteData_getUInt(_map(36, 'CkByteData_getUInt'))
    (objHandle, byteIndex);
end;

function CkByteData_is7bit (objHandle: HCkByteData): wordbool;
begin
  result := TCkByteData_is7bit(_map(37, 'CkByteData_is7bit'))
    (objHandle);
end;

function CkByteData_loadFile (objHandle: HCkByteData; path: pbyte): wordbool;
begin
  result := TCkByteData_loadFile(_map(38, 'CkByteData_loadFile'))
    (objHandle, path);
end;

function CkByteData_loadFileW (objHandle: HCkByteData; path: PWideChar): wordbool;
begin
  result := TCkByteData_loadFileW(_map(39, 'CkByteData_loadFileW'))
    (objHandle, path);
end;

procedure CkByteData_pad (objHandle: HCkByteData; blockSize: Integer; paddingScheme: Integer);
begin
  TCkByteData_pad(_map(40, 'CkByteData_pad'))
    (objHandle, blockSize, paddingScheme);
end;

function CkByteData_preAllocate (objHandle: HCkByteData; expectedNumBytes: LongWord): wordbool;
begin
  result := TCkByteData_preAllocate(_map(41, 'CkByteData_preAllocate'))
    (objHandle, expectedNumBytes);
end;

procedure CkByteData_removeChunk (objHandle: HCkByteData; startIndex: LongWord; numBytes: LongWord);
begin
  TCkByteData_removeChunk(_map(42, 'CkByteData_removeChunk'))
    (objHandle, startIndex, numBytes);
end;

function CkByteData_removeData (objHandle: HCkByteData): pbyte;
begin
  result := TCkByteData_removeData(_map(43, 'CkByteData_removeData'))
    (objHandle);
end;

procedure CkByteData_replaceChar (objHandle: HCkByteData; existingByteValue: Byte; replacementByteValue: Byte);
begin
  TCkByteData_replaceChar(_map(44, 'CkByteData_replaceChar'))
    (objHandle, existingByteValue, replacementByteValue);
end;

function CkByteData_saveFile (objHandle: HCkByteData; path: pbyte): wordbool;
begin
  result := TCkByteData_saveFile(_map(45, 'CkByteData_saveFile'))
    (objHandle, path);
end;

function CkByteData_saveFileW (objHandle: HCkByteData; path: PWideChar): wordbool;
begin
  result := TCkByteData_saveFileW(_map(46, 'CkByteData_saveFileW'))
    (objHandle, path);
end;

procedure CkByteData_shorten (objHandle: HCkByteData; numBytes: LongWord);
begin
  TCkByteData_shorten(_map(47, 'CkByteData_shorten'))
    (objHandle, numBytes);
end;

function CkByteData_to_ws (objHandle: HCkByteData; charset: pbyte): PWideChar;
begin
  result := TCkByteData_to_ws(_map(48, 'CkByteData_to_ws'))
    (objHandle, charset);
end;

procedure CkByteData_unpad (objHandle: HCkByteData; blockSize: Integer; paddingScheme: Integer);
begin
  TCkByteData_unpad(_map(49, 'CkByteData_unpad'))
    (objHandle, blockSize, paddingScheme);
end;

end.
