unit CodeSign;

interface

type

HCkCodeSign = Pointer;
HCkCert = Pointer;
HCkTask = Pointer;
HCkJsonObject = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TCodeSignAbortCheck = function(): Integer; cdecl;
TCodeSignProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TCodeSignPercentDone = function(pctDone: Integer): Integer; cdecl;
TCodeSignTaskCompleted = procedure(task: HCkTask); cdecl;


function CkCodeSign_Create: HCkCodeSign;  stdcall;
procedure CkCodeSign_Dispose(handle: HCkCodeSign); stdcall;

procedure CkCodeSign_SetAbortCheck(objHandle: HCkCodeSign; fn: TCodeSignAbortCheck) stdcall;
procedure CkCodeSign_SetProgressInfo(objHandle: HCkCodeSign; fn: TCodeSignProgressInfo) stdcall;
procedure CkCodeSign_SetPercentDone(objHandle: HCkCodeSign; fn: TCodeSignPercentDone) stdcall;
procedure CkCodeSign_SetTaskCompleted(objHandle: HCkCodeSign; fn: TCodeSignTaskCompleted) stdcall;
procedure CkCodeSign_getDebugLogFilePath(objHandle: HCkCodeSign; outPropVal: HCkString);
procedure CkCodeSign_putDebugLogFilePath(objHandle: HCkCodeSign; newPropVal: PWideChar);
function CkCodeSign__debugLogFilePath(objHandle: HCkCodeSign): PWideChar;
function CkCodeSign_getHeartbeatMs(objHandle: HCkCodeSign): Integer;
procedure CkCodeSign_putHeartbeatMs(objHandle: HCkCodeSign; newPropVal: Integer);
procedure CkCodeSign_getLastErrorHtml(objHandle: HCkCodeSign; outPropVal: HCkString);
function CkCodeSign__lastErrorHtml(objHandle: HCkCodeSign): PWideChar;
procedure CkCodeSign_getLastErrorText(objHandle: HCkCodeSign; outPropVal: HCkString);
function CkCodeSign__lastErrorText(objHandle: HCkCodeSign): PWideChar;
procedure CkCodeSign_getLastErrorXml(objHandle: HCkCodeSign; outPropVal: HCkString);
function CkCodeSign__lastErrorXml(objHandle: HCkCodeSign): PWideChar;
function CkCodeSign_getLastMethodSuccess(objHandle: HCkCodeSign): wordbool;
procedure CkCodeSign_putLastMethodSuccess(objHandle: HCkCodeSign; newPropVal: wordbool);
procedure CkCodeSign_getUncommonOptions(objHandle: HCkCodeSign; outPropVal: HCkString);
procedure CkCodeSign_putUncommonOptions(objHandle: HCkCodeSign; newPropVal: PWideChar);
function CkCodeSign__uncommonOptions(objHandle: HCkCodeSign): PWideChar;
function CkCodeSign_getVerboseLogging(objHandle: HCkCodeSign): wordbool;
procedure CkCodeSign_putVerboseLogging(objHandle: HCkCodeSign; newPropVal: wordbool);
procedure CkCodeSign_getVersion(objHandle: HCkCodeSign; outPropVal: HCkString);
function CkCodeSign__version(objHandle: HCkCodeSign): PWideChar;
function CkCodeSign_AddSignature(objHandle: HCkCodeSign; path: PWideChar; cert: HCkCert; options: HCkJsonObject): wordbool;
function CkCodeSign_AddSignatureAsync(objHandle: HCkCodeSign; path: PWideChar; cert: HCkCert; options: HCkJsonObject): HCkTask;
function CkCodeSign_GetSignerCert(objHandle: HCkCodeSign; cert: HCkCert): wordbool;
function CkCodeSign_RemoveSignature(objHandle: HCkCodeSign; path: PWideChar): wordbool;
function CkCodeSign_VerifySignature(objHandle: HCkCodeSign; path: PWideChar; sigInfo: HCkJsonObject): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkCodeSign_Create = function : HCkCodeSign; stdcall;
  TCkCodeSign_Dispose = procedure (handle: HCkCodeSign); stdcall;
  TCkCodeSign_SetAbortCheck = procedure (objHandle: HCkCodeSign; fn: TCodeSignAbortCheck); stdcall;
  TCkCodeSign_SetProgressInfo = procedure (objHandle: HCkCodeSign; fn: TCodeSignProgressInfo); stdcall;
  TCkCodeSign_SetPercentDone = procedure (objHandle: HCkCodeSign; fn: TCodeSignPercentDone); stdcall;
  TCkCodeSign_SetTaskCompleted = procedure (objHandle: HCkCodeSign; fn: TCodeSignTaskCompleted); stdcall;
  TCkCodeSign_getDebugLogFilePath = procedure (objHandle: HCkCodeSign; outPropVal: HCkString); stdcall;
  TCkCodeSign_putDebugLogFilePath = procedure (objHandle: HCkCodeSign; newPropVal: PWideChar); stdcall;
  TCkCodeSign__debugLogFilePath = function (objHandle: HCkCodeSign): PWideChar; stdcall;
  TCkCodeSign_getHeartbeatMs = function (objHandle: HCkCodeSign): Integer; stdcall;
  TCkCodeSign_putHeartbeatMs = procedure (objHandle: HCkCodeSign; newPropVal: Integer); stdcall;
  TCkCodeSign_getLastErrorHtml = procedure (objHandle: HCkCodeSign; outPropVal: HCkString); stdcall;
  TCkCodeSign__lastErrorHtml = function (objHandle: HCkCodeSign): PWideChar; stdcall;
  TCkCodeSign_getLastErrorText = procedure (objHandle: HCkCodeSign; outPropVal: HCkString); stdcall;
  TCkCodeSign__lastErrorText = function (objHandle: HCkCodeSign): PWideChar; stdcall;
  TCkCodeSign_getLastErrorXml = procedure (objHandle: HCkCodeSign; outPropVal: HCkString); stdcall;
  TCkCodeSign__lastErrorXml = function (objHandle: HCkCodeSign): PWideChar; stdcall;
  TCkCodeSign_getLastMethodSuccess = function (objHandle: HCkCodeSign): wordbool; stdcall;
  TCkCodeSign_putLastMethodSuccess = procedure (objHandle: HCkCodeSign; newPropVal: wordbool); stdcall;
  TCkCodeSign_getUncommonOptions = procedure (objHandle: HCkCodeSign; outPropVal: HCkString); stdcall;
  TCkCodeSign_putUncommonOptions = procedure (objHandle: HCkCodeSign; newPropVal: PWideChar); stdcall;
  TCkCodeSign__uncommonOptions = function (objHandle: HCkCodeSign): PWideChar; stdcall;
  TCkCodeSign_getVerboseLogging = function (objHandle: HCkCodeSign): wordbool; stdcall;
  TCkCodeSign_putVerboseLogging = procedure (objHandle: HCkCodeSign; newPropVal: wordbool); stdcall;
  TCkCodeSign_getVersion = procedure (objHandle: HCkCodeSign; outPropVal: HCkString); stdcall;
  TCkCodeSign__version = function (objHandle: HCkCodeSign): PWideChar; stdcall;
  TCkCodeSign_AddSignature = function (objHandle: HCkCodeSign; path: PWideChar; cert: HCkCert; options: HCkJsonObject): wordbool; stdcall;
  TCkCodeSign_AddSignatureAsync = function (objHandle: HCkCodeSign; path: PWideChar; cert: HCkCert; options: HCkJsonObject): HCkTask; stdcall;
  TCkCodeSign_GetSignerCert = function (objHandle: HCkCodeSign; cert: HCkCert): wordbool; stdcall;
  TCkCodeSign_RemoveSignature = function (objHandle: HCkCodeSign; path: PWideChar): wordbool; stdcall;
  TCkCodeSign_VerifySignature = function (objHandle: HCkCodeSign; path: PWideChar; sigInfo: HCkJsonObject): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..30] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkCodeSign_Create : HCkCodeSign;
begin
  result := TCkCodeSign_Create(_map(0, 'CkCodeSign_Create'));
end;

procedure CkCodeSign_Dispose (handle: HCkCodeSign);
begin
  TCkCodeSign_Dispose(_map(1, 'CkCodeSign_Dispose'))
    (handle);
end;


procedure CkCodeSign_SetAbortCheck (objHandle: HCkCodeSign; fn: TCodeSignAbortCheck);
begin
    TCkCodeSign_SetAbortCheck(_map(2, 'CkCodeSign_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkCodeSign_SetProgressInfo (objHandle: HCkCodeSign; fn: TCodeSignProgressInfo);
begin
    TCkCodeSign_SetProgressInfo(_map(3, 'CkCodeSign_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkCodeSign_SetPercentDone (objHandle: HCkCodeSign; fn: TCodeSignPercentDone);
begin
    TCkCodeSign_SetPercentDone(_map(4, 'CkCodeSign_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkCodeSign_SetTaskCompleted (objHandle: HCkCodeSign; fn: TCodeSignTaskCompleted);
begin
    TCkCodeSign_SetTaskCompleted(_map(5, 'CkCodeSign_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkCodeSign_getDebugLogFilePath (objHandle: HCkCodeSign; outPropVal: HCkString);
begin
  TCkCodeSign_getDebugLogFilePath(_map(6, 'CkCodeSign_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkCodeSign_putDebugLogFilePath (objHandle: HCkCodeSign; newPropVal: PWideChar);
begin
  TCkCodeSign_putDebugLogFilePath(_map(7, 'CkCodeSign_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkCodeSign__debugLogFilePath (objHandle: HCkCodeSign): PWideChar;
begin
  result := TCkCodeSign__debugLogFilePath(_map(8, 'CkCodeSign__debugLogFilePath'))
    (objHandle);
end;

function CkCodeSign_getHeartbeatMs (objHandle: HCkCodeSign): Integer;
begin
    result := TCkCodeSign_getHeartbeatMs(_map(9, 'CkCodeSign_getHeartbeatMs'))
    (objHandle);
end;

procedure CkCodeSign_putHeartbeatMs (objHandle: HCkCodeSign; newPropVal: Integer);
begin
  TCkCodeSign_putHeartbeatMs(_map(10, 'CkCodeSign_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkCodeSign_getLastErrorHtml (objHandle: HCkCodeSign; outPropVal: HCkString);
begin
  TCkCodeSign_getLastErrorHtml(_map(11, 'CkCodeSign_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkCodeSign__lastErrorHtml (objHandle: HCkCodeSign): PWideChar;
begin
  result := TCkCodeSign__lastErrorHtml(_map(12, 'CkCodeSign__lastErrorHtml'))
    (objHandle);
end;

procedure CkCodeSign_getLastErrorText (objHandle: HCkCodeSign; outPropVal: HCkString);
begin
  TCkCodeSign_getLastErrorText(_map(13, 'CkCodeSign_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkCodeSign__lastErrorText (objHandle: HCkCodeSign): PWideChar;
begin
  result := TCkCodeSign__lastErrorText(_map(14, 'CkCodeSign__lastErrorText'))
    (objHandle);
end;

procedure CkCodeSign_getLastErrorXml (objHandle: HCkCodeSign; outPropVal: HCkString);
begin
  TCkCodeSign_getLastErrorXml(_map(15, 'CkCodeSign_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkCodeSign__lastErrorXml (objHandle: HCkCodeSign): PWideChar;
begin
  result := TCkCodeSign__lastErrorXml(_map(16, 'CkCodeSign__lastErrorXml'))
    (objHandle);
end;

function CkCodeSign_getLastMethodSuccess (objHandle: HCkCodeSign): wordbool;
begin
    result := TCkCodeSign_getLastMethodSuccess(_map(17, 'CkCodeSign_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkCodeSign_putLastMethodSuccess (objHandle: HCkCodeSign; newPropVal: wordbool);
begin
  TCkCodeSign_putLastMethodSuccess(_map(18, 'CkCodeSign_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkCodeSign_getUncommonOptions (objHandle: HCkCodeSign; outPropVal: HCkString);
begin
  TCkCodeSign_getUncommonOptions(_map(19, 'CkCodeSign_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkCodeSign_putUncommonOptions (objHandle: HCkCodeSign; newPropVal: PWideChar);
begin
  TCkCodeSign_putUncommonOptions(_map(20, 'CkCodeSign_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkCodeSign__uncommonOptions (objHandle: HCkCodeSign): PWideChar;
begin
  result := TCkCodeSign__uncommonOptions(_map(21, 'CkCodeSign__uncommonOptions'))
    (objHandle);
end;

function CkCodeSign_getVerboseLogging (objHandle: HCkCodeSign): wordbool;
begin
    result := TCkCodeSign_getVerboseLogging(_map(22, 'CkCodeSign_getVerboseLogging'))
    (objHandle);
end;

procedure CkCodeSign_putVerboseLogging (objHandle: HCkCodeSign; newPropVal: wordbool);
begin
  TCkCodeSign_putVerboseLogging(_map(23, 'CkCodeSign_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkCodeSign_getVersion (objHandle: HCkCodeSign; outPropVal: HCkString);
begin
  TCkCodeSign_getVersion(_map(24, 'CkCodeSign_getVersion'))
    (objHandle, outPropVal);
end;

function CkCodeSign__version (objHandle: HCkCodeSign): PWideChar;
begin
  result := TCkCodeSign__version(_map(25, 'CkCodeSign__version'))
    (objHandle);
end;

function CkCodeSign_AddSignature (objHandle: HCkCodeSign; path: PWideChar; cert: HCkCert; options: HCkJsonObject): wordbool;
begin
  result := TCkCodeSign_AddSignature(_map(26, 'CkCodeSign_AddSignature'))
    (objHandle, path, cert, options);
end;

function CkCodeSign_AddSignatureAsync (objHandle: HCkCodeSign; path: PWideChar; cert: HCkCert; options: HCkJsonObject): HCkTask;
begin
  result := TCkCodeSign_AddSignatureAsync(_map(27, 'CkCodeSign_AddSignatureAsync'))
    (objHandle, path, cert, options);
end;

function CkCodeSign_GetSignerCert (objHandle: HCkCodeSign; cert: HCkCert): wordbool;
begin
  result := TCkCodeSign_GetSignerCert(_map(28, 'CkCodeSign_GetSignerCert'))
    (objHandle, cert);
end;

function CkCodeSign_RemoveSignature (objHandle: HCkCodeSign; path: PWideChar): wordbool;
begin
  result := TCkCodeSign_RemoveSignature(_map(29, 'CkCodeSign_RemoveSignature'))
    (objHandle, path);
end;

function CkCodeSign_VerifySignature (objHandle: HCkCodeSign; path: PWideChar; sigInfo: HCkJsonObject): wordbool;
begin
  result := TCkCodeSign_VerifySignature(_map(30, 'CkCodeSign_VerifySignature'))
    (objHandle, path, sigInfo);
end;

end.
