unit Compression;

interface

type

HCkBinData = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkStream = Pointer;
HCkJsonObject = Pointer;
HCkTask = Pointer;
HCkCompression = Pointer;
HCkStringBuilder = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TCompressionAbortCheck = function(): Integer; cdecl;
TCompressionProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TCompressionPercentDone = function(pctDone: Integer): Integer; cdecl;
TCompressionTaskCompleted = procedure(task: HCkTask); cdecl;


function CkCompression_Create: HCkCompression;  stdcall;
procedure CkCompression_Dispose(handle: HCkCompression); stdcall;

procedure CkCompression_SetAbortCheck(objHandle: HCkCompression; fn: TCompressionAbortCheck) stdcall;
procedure CkCompression_SetProgressInfo(objHandle: HCkCompression; fn: TCompressionProgressInfo) stdcall;
procedure CkCompression_SetPercentDone(objHandle: HCkCompression; fn: TCompressionPercentDone) stdcall;
procedure CkCompression_SetTaskCompleted(objHandle: HCkCompression; fn: TCompressionTaskCompleted) stdcall;
procedure CkCompression_getAlgorithm(objHandle: HCkCompression; outPropVal: HCkString);
procedure CkCompression_putAlgorithm(objHandle: HCkCompression; newPropVal: PWideChar);
function CkCompression__algorithm(objHandle: HCkCompression): PWideChar;
procedure CkCompression_getCharset(objHandle: HCkCompression; outPropVal: HCkString);
procedure CkCompression_putCharset(objHandle: HCkCompression; newPropVal: PWideChar);
function CkCompression__charset(objHandle: HCkCompression): PWideChar;
procedure CkCompression_getDebugLogFilePath(objHandle: HCkCompression; outPropVal: HCkString);
procedure CkCompression_putDebugLogFilePath(objHandle: HCkCompression; newPropVal: PWideChar);
function CkCompression__debugLogFilePath(objHandle: HCkCompression): PWideChar;
function CkCompression_getDeflateLevel(objHandle: HCkCompression): Integer;
procedure CkCompression_putDeflateLevel(objHandle: HCkCompression; newPropVal: Integer);
procedure CkCompression_getEncodingMode(objHandle: HCkCompression; outPropVal: HCkString);
procedure CkCompression_putEncodingMode(objHandle: HCkCompression; newPropVal: PWideChar);
function CkCompression__encodingMode(objHandle: HCkCompression): PWideChar;
function CkCompression_getFirstChunk(objHandle: HCkCompression): wordbool;
procedure CkCompression_putFirstChunk(objHandle: HCkCompression; newPropVal: wordbool);
function CkCompression_getHeartbeatMs(objHandle: HCkCompression): Integer;
procedure CkCompression_putHeartbeatMs(objHandle: HCkCompression; newPropVal: Integer);
function CkCompression_getLastChunk(objHandle: HCkCompression): wordbool;
procedure CkCompression_putLastChunk(objHandle: HCkCompression; newPropVal: wordbool);
procedure CkCompression_getLastErrorHtml(objHandle: HCkCompression; outPropVal: HCkString);
function CkCompression__lastErrorHtml(objHandle: HCkCompression): PWideChar;
procedure CkCompression_getLastErrorText(objHandle: HCkCompression; outPropVal: HCkString);
function CkCompression__lastErrorText(objHandle: HCkCompression): PWideChar;
procedure CkCompression_getLastErrorXml(objHandle: HCkCompression; outPropVal: HCkString);
function CkCompression__lastErrorXml(objHandle: HCkCompression): PWideChar;
function CkCompression_getLastMethodSuccess(objHandle: HCkCompression): wordbool;
procedure CkCompression_putLastMethodSuccess(objHandle: HCkCompression; newPropVal: wordbool);
procedure CkCompression_getUncommonOptions(objHandle: HCkCompression; outPropVal: HCkString);
procedure CkCompression_putUncommonOptions(objHandle: HCkCompression; newPropVal: PWideChar);
function CkCompression__uncommonOptions(objHandle: HCkCompression): PWideChar;
function CkCompression_getVerboseLogging(objHandle: HCkCompression): wordbool;
procedure CkCompression_putVerboseLogging(objHandle: HCkCompression; newPropVal: wordbool);
procedure CkCompression_getVersion(objHandle: HCkCompression; outPropVal: HCkString);
function CkCompression__version(objHandle: HCkCompression): PWideChar;
function CkCompression_BeginCompressBytes(objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
function CkCompression_BeginCompressBytesENC(objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
function CkCompression__beginCompressBytesENC(objHandle: HCkCompression; data: HCkByteData): PWideChar;
function CkCompression_BeginCompressString(objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool;
function CkCompression_BeginCompressStringENC(objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool;
function CkCompression__beginCompressStringENC(objHandle: HCkCompression; str: PWideChar): PWideChar;
function CkCompression_BeginDecompressBytes(objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
function CkCompression_BeginDecompressBytesENC(objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool;
function CkCompression_BeginDecompressString(objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
function CkCompression__beginDecompressString(objHandle: HCkCompression; data: HCkByteData): PWideChar;
function CkCompression_BeginDecompressStringENC(objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool;
function CkCompression__beginDecompressStringENC(objHandle: HCkCompression; str: PWideChar): PWideChar;
function CkCompression_CompressBd(objHandle: HCkCompression; bd: HCkBinData): wordbool;
function CkCompression_CompressBdAsync(objHandle: HCkCompression; bd: HCkBinData): HCkTask;
function CkCompression_CompressBd2(objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): wordbool;
function CkCompression_CompressBd2Async(objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): HCkTask;
function CkCompression_CompressBytes(objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
function CkCompression_CompressBytesAsync(objHandle: HCkCompression; data: HCkByteData): HCkTask;
function CkCompression_CompressBytesENC(objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
function CkCompression__compressBytesENC(objHandle: HCkCompression; data: HCkByteData): PWideChar;
function CkCompression_CompressBytesENCAsync(objHandle: HCkCompression; data: HCkByteData): HCkTask;
function CkCompression_CompressEncryptFile(objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): wordbool;
function CkCompression_CompressEncryptFileAsync(objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): HCkTask;
function CkCompression_CompressFile(objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): wordbool;
function CkCompression_CompressFileAsync(objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): HCkTask;
function CkCompression_CompressSb(objHandle: HCkCompression; sb: HCkStringBuilder; binData: HCkBinData): wordbool;
function CkCompression_CompressSbAsync(objHandle: HCkCompression; sb: HCkStringBuilder; binData: HCkBinData): HCkTask;
function CkCompression_CompressStr(objHandle: HCkCompression; str: PWideChar; bd: HCkBinData): wordbool;
function CkCompression_CompressStrAsync(objHandle: HCkCompression; str: PWideChar; bd: HCkBinData): HCkTask;
function CkCompression_CompressStream(objHandle: HCkCompression; strm: HCkStream): wordbool;
function CkCompression_CompressStreamAsync(objHandle: HCkCompression; strm: HCkStream): HCkTask;
function CkCompression_CompressString(objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool;
function CkCompression_CompressStringAsync(objHandle: HCkCompression; str: PWideChar): HCkTask;
function CkCompression_CompressStringENC(objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool;
function CkCompression__compressStringENC(objHandle: HCkCompression; str: PWideChar): PWideChar;
function CkCompression_CompressStringENCAsync(objHandle: HCkCompression; str: PWideChar): HCkTask;
function CkCompression_DecompressBd(objHandle: HCkCompression; bd: HCkBinData): wordbool;
function CkCompression_DecompressBdAsync(objHandle: HCkCompression; bd: HCkBinData): HCkTask;
function CkCompression_DecompressBd2(objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): wordbool;
function CkCompression_DecompressBd2Async(objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): HCkTask;
function CkCompression_DecompressBytes(objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
function CkCompression_DecompressBytesAsync(objHandle: HCkCompression; data: HCkByteData): HCkTask;
function CkCompression_DecompressBytesENC(objHandle: HCkCompression; encodedCompressedData: PWideChar; outData: HCkByteData): wordbool;
function CkCompression_DecompressBytesENCAsync(objHandle: HCkCompression; encodedCompressedData: PWideChar): HCkTask;
function CkCompression_DecompressFile(objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): wordbool;
function CkCompression_DecompressFileAsync(objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): HCkTask;
function CkCompression_DecompressSb(objHandle: HCkCompression; binData: HCkBinData; sb: HCkStringBuilder): wordbool;
function CkCompression_DecompressSbAsync(objHandle: HCkCompression; binData: HCkBinData; sb: HCkStringBuilder): HCkTask;
function CkCompression_DecompressStream(objHandle: HCkCompression; strm: HCkStream): wordbool;
function CkCompression_DecompressStreamAsync(objHandle: HCkCompression; strm: HCkStream): HCkTask;
function CkCompression_DecompressString(objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
function CkCompression__decompressString(objHandle: HCkCompression; data: HCkByteData): PWideChar;
function CkCompression_DecompressStringENC(objHandle: HCkCompression; encodedCompressedData: PWideChar; outStr: HCkString): wordbool;
function CkCompression__decompressStringENC(objHandle: HCkCompression; encodedCompressedData: PWideChar): PWideChar;
function CkCompression_DecompressStringENCAsync(objHandle: HCkCompression; encodedCompressedData: PWideChar): HCkTask;
function CkCompression_DecryptDecompressFile(objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): wordbool;
function CkCompression_DecryptDecompressFileAsync(objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): HCkTask;
function CkCompression_EndCompressBytes(objHandle: HCkCompression; outData: HCkByteData): wordbool;
function CkCompression_EndCompressBytesENC(objHandle: HCkCompression; outStr: HCkString): wordbool;
function CkCompression__endCompressBytesENC(objHandle: HCkCompression): PWideChar;
function CkCompression_EndCompressString(objHandle: HCkCompression; outData: HCkByteData): wordbool;
function CkCompression_EndCompressStringENC(objHandle: HCkCompression; outStr: HCkString): wordbool;
function CkCompression__endCompressStringENC(objHandle: HCkCompression): PWideChar;
function CkCompression_EndDecompressBytes(objHandle: HCkCompression; outData: HCkByteData): wordbool;
function CkCompression_EndDecompressBytesENC(objHandle: HCkCompression; outData: HCkByteData): wordbool;
function CkCompression_EndDecompressString(objHandle: HCkCompression; outStr: HCkString): wordbool;
function CkCompression__endDecompressString(objHandle: HCkCompression): PWideChar;
function CkCompression_EndDecompressStringENC(objHandle: HCkCompression; outStr: HCkString): wordbool;
function CkCompression__endDecompressStringENC(objHandle: HCkCompression): PWideChar;
function CkCompression_LoadTaskCaller(objHandle: HCkCompression; task: HCkTask): wordbool;
function CkCompression_MoreCompressBytes(objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
function CkCompression_MoreCompressBytesENC(objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
function CkCompression__moreCompressBytesENC(objHandle: HCkCompression; data: HCkByteData): PWideChar;
function CkCompression_MoreCompressString(objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool;
function CkCompression_MoreCompressStringENC(objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool;
function CkCompression__moreCompressStringENC(objHandle: HCkCompression; str: PWideChar): PWideChar;
function CkCompression_MoreDecompressBytes(objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
function CkCompression_MoreDecompressBytesENC(objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool;
function CkCompression_MoreDecompressString(objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
function CkCompression__moreDecompressString(objHandle: HCkCompression; data: HCkByteData): PWideChar;
function CkCompression_MoreDecompressStringENC(objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool;
function CkCompression__moreDecompressStringENC(objHandle: HCkCompression; str: PWideChar): PWideChar;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkCompression_Create = function : HCkCompression; stdcall;
  TCkCompression_Dispose = procedure (handle: HCkCompression); stdcall;
  TCkCompression_SetAbortCheck = procedure (objHandle: HCkCompression; fn: TCompressionAbortCheck); stdcall;
  TCkCompression_SetProgressInfo = procedure (objHandle: HCkCompression; fn: TCompressionProgressInfo); stdcall;
  TCkCompression_SetPercentDone = procedure (objHandle: HCkCompression; fn: TCompressionPercentDone); stdcall;
  TCkCompression_SetTaskCompleted = procedure (objHandle: HCkCompression; fn: TCompressionTaskCompleted); stdcall;
  TCkCompression_getAlgorithm = procedure (objHandle: HCkCompression; outPropVal: HCkString); stdcall;
  TCkCompression_putAlgorithm = procedure (objHandle: HCkCompression; newPropVal: PWideChar); stdcall;
  TCkCompression__algorithm = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_getCharset = procedure (objHandle: HCkCompression; outPropVal: HCkString); stdcall;
  TCkCompression_putCharset = procedure (objHandle: HCkCompression; newPropVal: PWideChar); stdcall;
  TCkCompression__charset = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_getDebugLogFilePath = procedure (objHandle: HCkCompression; outPropVal: HCkString); stdcall;
  TCkCompression_putDebugLogFilePath = procedure (objHandle: HCkCompression; newPropVal: PWideChar); stdcall;
  TCkCompression__debugLogFilePath = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_getDeflateLevel = function (objHandle: HCkCompression): Integer; stdcall;
  TCkCompression_putDeflateLevel = procedure (objHandle: HCkCompression; newPropVal: Integer); stdcall;
  TCkCompression_getEncodingMode = procedure (objHandle: HCkCompression; outPropVal: HCkString); stdcall;
  TCkCompression_putEncodingMode = procedure (objHandle: HCkCompression; newPropVal: PWideChar); stdcall;
  TCkCompression__encodingMode = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_getFirstChunk = function (objHandle: HCkCompression): wordbool; stdcall;
  TCkCompression_putFirstChunk = procedure (objHandle: HCkCompression; newPropVal: wordbool); stdcall;
  TCkCompression_getHeartbeatMs = function (objHandle: HCkCompression): Integer; stdcall;
  TCkCompression_putHeartbeatMs = procedure (objHandle: HCkCompression; newPropVal: Integer); stdcall;
  TCkCompression_getLastChunk = function (objHandle: HCkCompression): wordbool; stdcall;
  TCkCompression_putLastChunk = procedure (objHandle: HCkCompression; newPropVal: wordbool); stdcall;
  TCkCompression_getLastErrorHtml = procedure (objHandle: HCkCompression; outPropVal: HCkString); stdcall;
  TCkCompression__lastErrorHtml = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_getLastErrorText = procedure (objHandle: HCkCompression; outPropVal: HCkString); stdcall;
  TCkCompression__lastErrorText = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_getLastErrorXml = procedure (objHandle: HCkCompression; outPropVal: HCkString); stdcall;
  TCkCompression__lastErrorXml = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_getLastMethodSuccess = function (objHandle: HCkCompression): wordbool; stdcall;
  TCkCompression_putLastMethodSuccess = procedure (objHandle: HCkCompression; newPropVal: wordbool); stdcall;
  TCkCompression_getUncommonOptions = procedure (objHandle: HCkCompression; outPropVal: HCkString); stdcall;
  TCkCompression_putUncommonOptions = procedure (objHandle: HCkCompression; newPropVal: PWideChar); stdcall;
  TCkCompression__uncommonOptions = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_getVerboseLogging = function (objHandle: HCkCompression): wordbool; stdcall;
  TCkCompression_putVerboseLogging = procedure (objHandle: HCkCompression; newPropVal: wordbool); stdcall;
  TCkCompression_getVersion = procedure (objHandle: HCkCompression; outPropVal: HCkString); stdcall;
  TCkCompression__version = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_BeginCompressBytes = function (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_BeginCompressBytesENC = function (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkCompression__beginCompressBytesENC = function (objHandle: HCkCompression; data: HCkByteData): PWideChar; stdcall;
  TCkCompression_BeginCompressString = function (objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_BeginCompressStringENC = function (objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCompression__beginCompressStringENC = function (objHandle: HCkCompression; str: PWideChar): PWideChar; stdcall;
  TCkCompression_BeginDecompressBytes = function (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_BeginDecompressBytesENC = function (objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_BeginDecompressString = function (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkCompression__beginDecompressString = function (objHandle: HCkCompression; data: HCkByteData): PWideChar; stdcall;
  TCkCompression_BeginDecompressStringENC = function (objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCompression__beginDecompressStringENC = function (objHandle: HCkCompression; str: PWideChar): PWideChar; stdcall;
  TCkCompression_CompressBd = function (objHandle: HCkCompression; bd: HCkBinData): wordbool; stdcall;
  TCkCompression_CompressBdAsync = function (objHandle: HCkCompression; bd: HCkBinData): HCkTask; stdcall;
  TCkCompression_CompressBd2 = function (objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): wordbool; stdcall;
  TCkCompression_CompressBd2Async = function (objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): HCkTask; stdcall;
  TCkCompression_CompressBytes = function (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_CompressBytesAsync = function (objHandle: HCkCompression; data: HCkByteData): HCkTask; stdcall;
  TCkCompression_CompressBytesENC = function (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkCompression__compressBytesENC = function (objHandle: HCkCompression; data: HCkByteData): PWideChar; stdcall;
  TCkCompression_CompressBytesENCAsync = function (objHandle: HCkCompression; data: HCkByteData): HCkTask; stdcall;
  TCkCompression_CompressEncryptFile = function (objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkCompression_CompressEncryptFileAsync = function (objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): HCkTask; stdcall;
  TCkCompression_CompressFile = function (objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkCompression_CompressFileAsync = function (objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): HCkTask; stdcall;
  TCkCompression_CompressSb = function (objHandle: HCkCompression; sb: HCkStringBuilder; binData: HCkBinData): wordbool; stdcall;
  TCkCompression_CompressSbAsync = function (objHandle: HCkCompression; sb: HCkStringBuilder; binData: HCkBinData): HCkTask; stdcall;
  TCkCompression_CompressStr = function (objHandle: HCkCompression; str: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkCompression_CompressStrAsync = function (objHandle: HCkCompression; str: PWideChar; bd: HCkBinData): HCkTask; stdcall;
  TCkCompression_CompressStream = function (objHandle: HCkCompression; strm: HCkStream): wordbool; stdcall;
  TCkCompression_CompressStreamAsync = function (objHandle: HCkCompression; strm: HCkStream): HCkTask; stdcall;
  TCkCompression_CompressString = function (objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_CompressStringAsync = function (objHandle: HCkCompression; str: PWideChar): HCkTask; stdcall;
  TCkCompression_CompressStringENC = function (objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCompression__compressStringENC = function (objHandle: HCkCompression; str: PWideChar): PWideChar; stdcall;
  TCkCompression_CompressStringENCAsync = function (objHandle: HCkCompression; str: PWideChar): HCkTask; stdcall;
  TCkCompression_DecompressBd = function (objHandle: HCkCompression; bd: HCkBinData): wordbool; stdcall;
  TCkCompression_DecompressBdAsync = function (objHandle: HCkCompression; bd: HCkBinData): HCkTask; stdcall;
  TCkCompression_DecompressBd2 = function (objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): wordbool; stdcall;
  TCkCompression_DecompressBd2Async = function (objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): HCkTask; stdcall;
  TCkCompression_DecompressBytes = function (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_DecompressBytesAsync = function (objHandle: HCkCompression; data: HCkByteData): HCkTask; stdcall;
  TCkCompression_DecompressBytesENC = function (objHandle: HCkCompression; encodedCompressedData: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_DecompressBytesENCAsync = function (objHandle: HCkCompression; encodedCompressedData: PWideChar): HCkTask; stdcall;
  TCkCompression_DecompressFile = function (objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkCompression_DecompressFileAsync = function (objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): HCkTask; stdcall;
  TCkCompression_DecompressSb = function (objHandle: HCkCompression; binData: HCkBinData; sb: HCkStringBuilder): wordbool; stdcall;
  TCkCompression_DecompressSbAsync = function (objHandle: HCkCompression; binData: HCkBinData; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkCompression_DecompressStream = function (objHandle: HCkCompression; strm: HCkStream): wordbool; stdcall;
  TCkCompression_DecompressStreamAsync = function (objHandle: HCkCompression; strm: HCkStream): HCkTask; stdcall;
  TCkCompression_DecompressString = function (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkCompression__decompressString = function (objHandle: HCkCompression; data: HCkByteData): PWideChar; stdcall;
  TCkCompression_DecompressStringENC = function (objHandle: HCkCompression; encodedCompressedData: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCompression__decompressStringENC = function (objHandle: HCkCompression; encodedCompressedData: PWideChar): PWideChar; stdcall;
  TCkCompression_DecompressStringENCAsync = function (objHandle: HCkCompression; encodedCompressedData: PWideChar): HCkTask; stdcall;
  TCkCompression_DecryptDecompressFile = function (objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkCompression_DecryptDecompressFileAsync = function (objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): HCkTask; stdcall;
  TCkCompression_EndCompressBytes = function (objHandle: HCkCompression; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_EndCompressBytesENC = function (objHandle: HCkCompression; outStr: HCkString): wordbool; stdcall;
  TCkCompression__endCompressBytesENC = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_EndCompressString = function (objHandle: HCkCompression; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_EndCompressStringENC = function (objHandle: HCkCompression; outStr: HCkString): wordbool; stdcall;
  TCkCompression__endCompressStringENC = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_EndDecompressBytes = function (objHandle: HCkCompression; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_EndDecompressBytesENC = function (objHandle: HCkCompression; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_EndDecompressString = function (objHandle: HCkCompression; outStr: HCkString): wordbool; stdcall;
  TCkCompression__endDecompressString = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_EndDecompressStringENC = function (objHandle: HCkCompression; outStr: HCkString): wordbool; stdcall;
  TCkCompression__endDecompressStringENC = function (objHandle: HCkCompression): PWideChar; stdcall;
  TCkCompression_LoadTaskCaller = function (objHandle: HCkCompression; task: HCkTask): wordbool; stdcall;
  TCkCompression_MoreCompressBytes = function (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_MoreCompressBytesENC = function (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkCompression__moreCompressBytesENC = function (objHandle: HCkCompression; data: HCkByteData): PWideChar; stdcall;
  TCkCompression_MoreCompressString = function (objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_MoreCompressStringENC = function (objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCompression__moreCompressStringENC = function (objHandle: HCkCompression; str: PWideChar): PWideChar; stdcall;
  TCkCompression_MoreDecompressBytes = function (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_MoreDecompressBytesENC = function (objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkCompression_MoreDecompressString = function (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool; stdcall;
  TCkCompression__moreDecompressString = function (objHandle: HCkCompression; data: HCkByteData): PWideChar; stdcall;
  TCkCompression_MoreDecompressStringENC = function (objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCompression__moreDecompressStringENC = function (objHandle: HCkCompression; str: PWideChar): PWideChar; stdcall;

var
  _fkt_ptr_arr:   array [0..122] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkCompression_Create : HCkCompression;
begin
  result := TCkCompression_Create(_map(0, 'CkCompression_Create'));
end;

procedure CkCompression_Dispose (handle: HCkCompression);
begin
  TCkCompression_Dispose(_map(1, 'CkCompression_Dispose'))
    (handle);
end;


procedure CkCompression_SetAbortCheck (objHandle: HCkCompression; fn: TCompressionAbortCheck);
begin
    TCkCompression_SetAbortCheck(_map(2, 'CkCompression_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkCompression_SetProgressInfo (objHandle: HCkCompression; fn: TCompressionProgressInfo);
begin
    TCkCompression_SetProgressInfo(_map(3, 'CkCompression_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkCompression_SetPercentDone (objHandle: HCkCompression; fn: TCompressionPercentDone);
begin
    TCkCompression_SetPercentDone(_map(4, 'CkCompression_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkCompression_SetTaskCompleted (objHandle: HCkCompression; fn: TCompressionTaskCompleted);
begin
    TCkCompression_SetTaskCompleted(_map(5, 'CkCompression_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkCompression_getAlgorithm (objHandle: HCkCompression; outPropVal: HCkString);
begin
  TCkCompression_getAlgorithm(_map(6, 'CkCompression_getAlgorithm'))
    (objHandle, outPropVal);
end;

procedure CkCompression_putAlgorithm (objHandle: HCkCompression; newPropVal: PWideChar);
begin
  TCkCompression_putAlgorithm(_map(7, 'CkCompression_putAlgorithm'))
    (objHandle, newPropVal);
end;

function CkCompression__algorithm (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__algorithm(_map(8, 'CkCompression__algorithm'))
    (objHandle);
end;

procedure CkCompression_getCharset (objHandle: HCkCompression; outPropVal: HCkString);
begin
  TCkCompression_getCharset(_map(9, 'CkCompression_getCharset'))
    (objHandle, outPropVal);
end;

procedure CkCompression_putCharset (objHandle: HCkCompression; newPropVal: PWideChar);
begin
  TCkCompression_putCharset(_map(10, 'CkCompression_putCharset'))
    (objHandle, newPropVal);
end;

function CkCompression__charset (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__charset(_map(11, 'CkCompression__charset'))
    (objHandle);
end;

procedure CkCompression_getDebugLogFilePath (objHandle: HCkCompression; outPropVal: HCkString);
begin
  TCkCompression_getDebugLogFilePath(_map(12, 'CkCompression_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkCompression_putDebugLogFilePath (objHandle: HCkCompression; newPropVal: PWideChar);
begin
  TCkCompression_putDebugLogFilePath(_map(13, 'CkCompression_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkCompression__debugLogFilePath (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__debugLogFilePath(_map(14, 'CkCompression__debugLogFilePath'))
    (objHandle);
end;

function CkCompression_getDeflateLevel (objHandle: HCkCompression): Integer;
begin
    result := TCkCompression_getDeflateLevel(_map(15, 'CkCompression_getDeflateLevel'))
    (objHandle);
end;

procedure CkCompression_putDeflateLevel (objHandle: HCkCompression; newPropVal: Integer);
begin
  TCkCompression_putDeflateLevel(_map(16, 'CkCompression_putDeflateLevel'))
    (objHandle, newPropVal);
end;

procedure CkCompression_getEncodingMode (objHandle: HCkCompression; outPropVal: HCkString);
begin
  TCkCompression_getEncodingMode(_map(17, 'CkCompression_getEncodingMode'))
    (objHandle, outPropVal);
end;

procedure CkCompression_putEncodingMode (objHandle: HCkCompression; newPropVal: PWideChar);
begin
  TCkCompression_putEncodingMode(_map(18, 'CkCompression_putEncodingMode'))
    (objHandle, newPropVal);
end;

function CkCompression__encodingMode (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__encodingMode(_map(19, 'CkCompression__encodingMode'))
    (objHandle);
end;

function CkCompression_getFirstChunk (objHandle: HCkCompression): wordbool;
begin
    result := TCkCompression_getFirstChunk(_map(20, 'CkCompression_getFirstChunk'))
    (objHandle);
end;

procedure CkCompression_putFirstChunk (objHandle: HCkCompression; newPropVal: wordbool);
begin
  TCkCompression_putFirstChunk(_map(21, 'CkCompression_putFirstChunk'))
    (objHandle, newPropVal);
end;

function CkCompression_getHeartbeatMs (objHandle: HCkCompression): Integer;
begin
    result := TCkCompression_getHeartbeatMs(_map(22, 'CkCompression_getHeartbeatMs'))
    (objHandle);
end;

procedure CkCompression_putHeartbeatMs (objHandle: HCkCompression; newPropVal: Integer);
begin
  TCkCompression_putHeartbeatMs(_map(23, 'CkCompression_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

function CkCompression_getLastChunk (objHandle: HCkCompression): wordbool;
begin
    result := TCkCompression_getLastChunk(_map(24, 'CkCompression_getLastChunk'))
    (objHandle);
end;

procedure CkCompression_putLastChunk (objHandle: HCkCompression; newPropVal: wordbool);
begin
  TCkCompression_putLastChunk(_map(25, 'CkCompression_putLastChunk'))
    (objHandle, newPropVal);
end;

procedure CkCompression_getLastErrorHtml (objHandle: HCkCompression; outPropVal: HCkString);
begin
  TCkCompression_getLastErrorHtml(_map(26, 'CkCompression_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkCompression__lastErrorHtml (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__lastErrorHtml(_map(27, 'CkCompression__lastErrorHtml'))
    (objHandle);
end;

procedure CkCompression_getLastErrorText (objHandle: HCkCompression; outPropVal: HCkString);
begin
  TCkCompression_getLastErrorText(_map(28, 'CkCompression_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkCompression__lastErrorText (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__lastErrorText(_map(29, 'CkCompression__lastErrorText'))
    (objHandle);
end;

procedure CkCompression_getLastErrorXml (objHandle: HCkCompression; outPropVal: HCkString);
begin
  TCkCompression_getLastErrorXml(_map(30, 'CkCompression_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkCompression__lastErrorXml (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__lastErrorXml(_map(31, 'CkCompression__lastErrorXml'))
    (objHandle);
end;

function CkCompression_getLastMethodSuccess (objHandle: HCkCompression): wordbool;
begin
    result := TCkCompression_getLastMethodSuccess(_map(32, 'CkCompression_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkCompression_putLastMethodSuccess (objHandle: HCkCompression; newPropVal: wordbool);
begin
  TCkCompression_putLastMethodSuccess(_map(33, 'CkCompression_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkCompression_getUncommonOptions (objHandle: HCkCompression; outPropVal: HCkString);
begin
  TCkCompression_getUncommonOptions(_map(34, 'CkCompression_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkCompression_putUncommonOptions (objHandle: HCkCompression; newPropVal: PWideChar);
begin
  TCkCompression_putUncommonOptions(_map(35, 'CkCompression_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkCompression__uncommonOptions (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__uncommonOptions(_map(36, 'CkCompression__uncommonOptions'))
    (objHandle);
end;

function CkCompression_getVerboseLogging (objHandle: HCkCompression): wordbool;
begin
    result := TCkCompression_getVerboseLogging(_map(37, 'CkCompression_getVerboseLogging'))
    (objHandle);
end;

procedure CkCompression_putVerboseLogging (objHandle: HCkCompression; newPropVal: wordbool);
begin
  TCkCompression_putVerboseLogging(_map(38, 'CkCompression_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkCompression_getVersion (objHandle: HCkCompression; outPropVal: HCkString);
begin
  TCkCompression_getVersion(_map(39, 'CkCompression_getVersion'))
    (objHandle, outPropVal);
end;

function CkCompression__version (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__version(_map(40, 'CkCompression__version'))
    (objHandle);
end;

function CkCompression_BeginCompressBytes (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_BeginCompressBytes(_map(41, 'CkCompression_BeginCompressBytes'))
    (objHandle, data, outData);
end;

function CkCompression_BeginCompressBytesENC (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkCompression_BeginCompressBytesENC(_map(42, 'CkCompression_BeginCompressBytesENC'))
    (objHandle, data, outStr);
end;

function CkCompression__beginCompressBytesENC (objHandle: HCkCompression; data: HCkByteData): PWideChar;
begin
  result := TCkCompression__beginCompressBytesENC(_map(43, 'CkCompression__beginCompressBytesENC'))
    (objHandle, data);
end;

function CkCompression_BeginCompressString (objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_BeginCompressString(_map(44, 'CkCompression_BeginCompressString'))
    (objHandle, str, outData);
end;

function CkCompression_BeginCompressStringENC (objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCompression_BeginCompressStringENC(_map(45, 'CkCompression_BeginCompressStringENC'))
    (objHandle, str, outStr);
end;

function CkCompression__beginCompressStringENC (objHandle: HCkCompression; str: PWideChar): PWideChar;
begin
  result := TCkCompression__beginCompressStringENC(_map(46, 'CkCompression__beginCompressStringENC'))
    (objHandle, str);
end;

function CkCompression_BeginDecompressBytes (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_BeginDecompressBytes(_map(47, 'CkCompression_BeginDecompressBytes'))
    (objHandle, data, outData);
end;

function CkCompression_BeginDecompressBytesENC (objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_BeginDecompressBytesENC(_map(48, 'CkCompression_BeginDecompressBytesENC'))
    (objHandle, str, outData);
end;

function CkCompression_BeginDecompressString (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkCompression_BeginDecompressString(_map(49, 'CkCompression_BeginDecompressString'))
    (objHandle, data, outStr);
end;

function CkCompression__beginDecompressString (objHandle: HCkCompression; data: HCkByteData): PWideChar;
begin
  result := TCkCompression__beginDecompressString(_map(50, 'CkCompression__beginDecompressString'))
    (objHandle, data);
end;

function CkCompression_BeginDecompressStringENC (objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCompression_BeginDecompressStringENC(_map(51, 'CkCompression_BeginDecompressStringENC'))
    (objHandle, str, outStr);
end;

function CkCompression__beginDecompressStringENC (objHandle: HCkCompression; str: PWideChar): PWideChar;
begin
  result := TCkCompression__beginDecompressStringENC(_map(52, 'CkCompression__beginDecompressStringENC'))
    (objHandle, str);
end;

function CkCompression_CompressBd (objHandle: HCkCompression; bd: HCkBinData): wordbool;
begin
  result := TCkCompression_CompressBd(_map(53, 'CkCompression_CompressBd'))
    (objHandle, bd);
end;

function CkCompression_CompressBdAsync (objHandle: HCkCompression; bd: HCkBinData): HCkTask;
begin
  result := TCkCompression_CompressBdAsync(_map(54, 'CkCompression_CompressBdAsync'))
    (objHandle, bd);
end;

function CkCompression_CompressBd2 (objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): wordbool;
begin
  result := TCkCompression_CompressBd2(_map(55, 'CkCompression_CompressBd2'))
    (objHandle, bdIn, bdOut);
end;

function CkCompression_CompressBd2Async (objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): HCkTask;
begin
  result := TCkCompression_CompressBd2Async(_map(56, 'CkCompression_CompressBd2Async'))
    (objHandle, bdIn, bdOut);
end;

function CkCompression_CompressBytes (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_CompressBytes(_map(57, 'CkCompression_CompressBytes'))
    (objHandle, data, outData);
end;

function CkCompression_CompressBytesAsync (objHandle: HCkCompression; data: HCkByteData): HCkTask;
begin
  result := TCkCompression_CompressBytesAsync(_map(58, 'CkCompression_CompressBytesAsync'))
    (objHandle, data);
end;

function CkCompression_CompressBytesENC (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkCompression_CompressBytesENC(_map(59, 'CkCompression_CompressBytesENC'))
    (objHandle, data, outStr);
end;

function CkCompression__compressBytesENC (objHandle: HCkCompression; data: HCkByteData): PWideChar;
begin
  result := TCkCompression__compressBytesENC(_map(60, 'CkCompression__compressBytesENC'))
    (objHandle, data);
end;

function CkCompression_CompressBytesENCAsync (objHandle: HCkCompression; data: HCkByteData): HCkTask;
begin
  result := TCkCompression_CompressBytesENCAsync(_map(61, 'CkCompression_CompressBytesENCAsync'))
    (objHandle, data);
end;

function CkCompression_CompressEncryptFile (objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkCompression_CompressEncryptFile(_map(62, 'CkCompression_CompressEncryptFile'))
    (objHandle, cryptParams, srcPath, destPath);
end;

function CkCompression_CompressEncryptFileAsync (objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): HCkTask;
begin
  result := TCkCompression_CompressEncryptFileAsync(_map(63, 'CkCompression_CompressEncryptFileAsync'))
    (objHandle, cryptParams, srcPath, destPath);
end;

function CkCompression_CompressFile (objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkCompression_CompressFile(_map(64, 'CkCompression_CompressFile'))
    (objHandle, srcPath, destPath);
end;

function CkCompression_CompressFileAsync (objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): HCkTask;
begin
  result := TCkCompression_CompressFileAsync(_map(65, 'CkCompression_CompressFileAsync'))
    (objHandle, srcPath, destPath);
end;

function CkCompression_CompressSb (objHandle: HCkCompression; sb: HCkStringBuilder; binData: HCkBinData): wordbool;
begin
  result := TCkCompression_CompressSb(_map(66, 'CkCompression_CompressSb'))
    (objHandle, sb, binData);
end;

function CkCompression_CompressSbAsync (objHandle: HCkCompression; sb: HCkStringBuilder; binData: HCkBinData): HCkTask;
begin
  result := TCkCompression_CompressSbAsync(_map(67, 'CkCompression_CompressSbAsync'))
    (objHandle, sb, binData);
end;

function CkCompression_CompressStr (objHandle: HCkCompression; str: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkCompression_CompressStr(_map(68, 'CkCompression_CompressStr'))
    (objHandle, str, bd);
end;

function CkCompression_CompressStrAsync (objHandle: HCkCompression; str: PWideChar; bd: HCkBinData): HCkTask;
begin
  result := TCkCompression_CompressStrAsync(_map(69, 'CkCompression_CompressStrAsync'))
    (objHandle, str, bd);
end;

function CkCompression_CompressStream (objHandle: HCkCompression; strm: HCkStream): wordbool;
begin
  result := TCkCompression_CompressStream(_map(70, 'CkCompression_CompressStream'))
    (objHandle, strm);
end;

function CkCompression_CompressStreamAsync (objHandle: HCkCompression; strm: HCkStream): HCkTask;
begin
  result := TCkCompression_CompressStreamAsync(_map(71, 'CkCompression_CompressStreamAsync'))
    (objHandle, strm);
end;

function CkCompression_CompressString (objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_CompressString(_map(72, 'CkCompression_CompressString'))
    (objHandle, str, outData);
end;

function CkCompression_CompressStringAsync (objHandle: HCkCompression; str: PWideChar): HCkTask;
begin
  result := TCkCompression_CompressStringAsync(_map(73, 'CkCompression_CompressStringAsync'))
    (objHandle, str);
end;

function CkCompression_CompressStringENC (objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCompression_CompressStringENC(_map(74, 'CkCompression_CompressStringENC'))
    (objHandle, str, outStr);
end;

function CkCompression__compressStringENC (objHandle: HCkCompression; str: PWideChar): PWideChar;
begin
  result := TCkCompression__compressStringENC(_map(75, 'CkCompression__compressStringENC'))
    (objHandle, str);
end;

function CkCompression_CompressStringENCAsync (objHandle: HCkCompression; str: PWideChar): HCkTask;
begin
  result := TCkCompression_CompressStringENCAsync(_map(76, 'CkCompression_CompressStringENCAsync'))
    (objHandle, str);
end;

function CkCompression_DecompressBd (objHandle: HCkCompression; bd: HCkBinData): wordbool;
begin
  result := TCkCompression_DecompressBd(_map(77, 'CkCompression_DecompressBd'))
    (objHandle, bd);
end;

function CkCompression_DecompressBdAsync (objHandle: HCkCompression; bd: HCkBinData): HCkTask;
begin
  result := TCkCompression_DecompressBdAsync(_map(78, 'CkCompression_DecompressBdAsync'))
    (objHandle, bd);
end;

function CkCompression_DecompressBd2 (objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): wordbool;
begin
  result := TCkCompression_DecompressBd2(_map(79, 'CkCompression_DecompressBd2'))
    (objHandle, bdIn, bdOut);
end;

function CkCompression_DecompressBd2Async (objHandle: HCkCompression; bdIn: HCkBinData; bdOut: HCkBinData): HCkTask;
begin
  result := TCkCompression_DecompressBd2Async(_map(80, 'CkCompression_DecompressBd2Async'))
    (objHandle, bdIn, bdOut);
end;

function CkCompression_DecompressBytes (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_DecompressBytes(_map(81, 'CkCompression_DecompressBytes'))
    (objHandle, data, outData);
end;

function CkCompression_DecompressBytesAsync (objHandle: HCkCompression; data: HCkByteData): HCkTask;
begin
  result := TCkCompression_DecompressBytesAsync(_map(82, 'CkCompression_DecompressBytesAsync'))
    (objHandle, data);
end;

function CkCompression_DecompressBytesENC (objHandle: HCkCompression; encodedCompressedData: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_DecompressBytesENC(_map(83, 'CkCompression_DecompressBytesENC'))
    (objHandle, encodedCompressedData, outData);
end;

function CkCompression_DecompressBytesENCAsync (objHandle: HCkCompression; encodedCompressedData: PWideChar): HCkTask;
begin
  result := TCkCompression_DecompressBytesENCAsync(_map(84, 'CkCompression_DecompressBytesENCAsync'))
    (objHandle, encodedCompressedData);
end;

function CkCompression_DecompressFile (objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkCompression_DecompressFile(_map(85, 'CkCompression_DecompressFile'))
    (objHandle, srcPath, destPath);
end;

function CkCompression_DecompressFileAsync (objHandle: HCkCompression; srcPath: PWideChar; destPath: PWideChar): HCkTask;
begin
  result := TCkCompression_DecompressFileAsync(_map(86, 'CkCompression_DecompressFileAsync'))
    (objHandle, srcPath, destPath);
end;

function CkCompression_DecompressSb (objHandle: HCkCompression; binData: HCkBinData; sb: HCkStringBuilder): wordbool;
begin
  result := TCkCompression_DecompressSb(_map(87, 'CkCompression_DecompressSb'))
    (objHandle, binData, sb);
end;

function CkCompression_DecompressSbAsync (objHandle: HCkCompression; binData: HCkBinData; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkCompression_DecompressSbAsync(_map(88, 'CkCompression_DecompressSbAsync'))
    (objHandle, binData, sb);
end;

function CkCompression_DecompressStream (objHandle: HCkCompression; strm: HCkStream): wordbool;
begin
  result := TCkCompression_DecompressStream(_map(89, 'CkCompression_DecompressStream'))
    (objHandle, strm);
end;

function CkCompression_DecompressStreamAsync (objHandle: HCkCompression; strm: HCkStream): HCkTask;
begin
  result := TCkCompression_DecompressStreamAsync(_map(90, 'CkCompression_DecompressStreamAsync'))
    (objHandle, strm);
end;

function CkCompression_DecompressString (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkCompression_DecompressString(_map(91, 'CkCompression_DecompressString'))
    (objHandle, data, outStr);
end;

function CkCompression__decompressString (objHandle: HCkCompression; data: HCkByteData): PWideChar;
begin
  result := TCkCompression__decompressString(_map(92, 'CkCompression__decompressString'))
    (objHandle, data);
end;

function CkCompression_DecompressStringENC (objHandle: HCkCompression; encodedCompressedData: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCompression_DecompressStringENC(_map(93, 'CkCompression_DecompressStringENC'))
    (objHandle, encodedCompressedData, outStr);
end;

function CkCompression__decompressStringENC (objHandle: HCkCompression; encodedCompressedData: PWideChar): PWideChar;
begin
  result := TCkCompression__decompressStringENC(_map(94, 'CkCompression__decompressStringENC'))
    (objHandle, encodedCompressedData);
end;

function CkCompression_DecompressStringENCAsync (objHandle: HCkCompression; encodedCompressedData: PWideChar): HCkTask;
begin
  result := TCkCompression_DecompressStringENCAsync(_map(95, 'CkCompression_DecompressStringENCAsync'))
    (objHandle, encodedCompressedData);
end;

function CkCompression_DecryptDecompressFile (objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkCompression_DecryptDecompressFile(_map(96, 'CkCompression_DecryptDecompressFile'))
    (objHandle, cryptParams, srcPath, destPath);
end;

function CkCompression_DecryptDecompressFileAsync (objHandle: HCkCompression; cryptParams: HCkJsonObject; srcPath: PWideChar; destPath: PWideChar): HCkTask;
begin
  result := TCkCompression_DecryptDecompressFileAsync(_map(97, 'CkCompression_DecryptDecompressFileAsync'))
    (objHandle, cryptParams, srcPath, destPath);
end;

function CkCompression_EndCompressBytes (objHandle: HCkCompression; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_EndCompressBytes(_map(98, 'CkCompression_EndCompressBytes'))
    (objHandle, outData);
end;

function CkCompression_EndCompressBytesENC (objHandle: HCkCompression; outStr: HCkString): wordbool;
begin
  result := TCkCompression_EndCompressBytesENC(_map(99, 'CkCompression_EndCompressBytesENC'))
    (objHandle, outStr);
end;

function CkCompression__endCompressBytesENC (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__endCompressBytesENC(_map(100, 'CkCompression__endCompressBytesENC'))
    (objHandle);
end;

function CkCompression_EndCompressString (objHandle: HCkCompression; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_EndCompressString(_map(101, 'CkCompression_EndCompressString'))
    (objHandle, outData);
end;

function CkCompression_EndCompressStringENC (objHandle: HCkCompression; outStr: HCkString): wordbool;
begin
  result := TCkCompression_EndCompressStringENC(_map(102, 'CkCompression_EndCompressStringENC'))
    (objHandle, outStr);
end;

function CkCompression__endCompressStringENC (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__endCompressStringENC(_map(103, 'CkCompression__endCompressStringENC'))
    (objHandle);
end;

function CkCompression_EndDecompressBytes (objHandle: HCkCompression; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_EndDecompressBytes(_map(104, 'CkCompression_EndDecompressBytes'))
    (objHandle, outData);
end;

function CkCompression_EndDecompressBytesENC (objHandle: HCkCompression; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_EndDecompressBytesENC(_map(105, 'CkCompression_EndDecompressBytesENC'))
    (objHandle, outData);
end;

function CkCompression_EndDecompressString (objHandle: HCkCompression; outStr: HCkString): wordbool;
begin
  result := TCkCompression_EndDecompressString(_map(106, 'CkCompression_EndDecompressString'))
    (objHandle, outStr);
end;

function CkCompression__endDecompressString (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__endDecompressString(_map(107, 'CkCompression__endDecompressString'))
    (objHandle);
end;

function CkCompression_EndDecompressStringENC (objHandle: HCkCompression; outStr: HCkString): wordbool;
begin
  result := TCkCompression_EndDecompressStringENC(_map(108, 'CkCompression_EndDecompressStringENC'))
    (objHandle, outStr);
end;

function CkCompression__endDecompressStringENC (objHandle: HCkCompression): PWideChar;
begin
  result := TCkCompression__endDecompressStringENC(_map(109, 'CkCompression__endDecompressStringENC'))
    (objHandle);
end;

function CkCompression_LoadTaskCaller (objHandle: HCkCompression; task: HCkTask): wordbool;
begin
  result := TCkCompression_LoadTaskCaller(_map(110, 'CkCompression_LoadTaskCaller'))
    (objHandle, task);
end;

function CkCompression_MoreCompressBytes (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_MoreCompressBytes(_map(111, 'CkCompression_MoreCompressBytes'))
    (objHandle, data, outData);
end;

function CkCompression_MoreCompressBytesENC (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkCompression_MoreCompressBytesENC(_map(112, 'CkCompression_MoreCompressBytesENC'))
    (objHandle, data, outStr);
end;

function CkCompression__moreCompressBytesENC (objHandle: HCkCompression; data: HCkByteData): PWideChar;
begin
  result := TCkCompression__moreCompressBytesENC(_map(113, 'CkCompression__moreCompressBytesENC'))
    (objHandle, data);
end;

function CkCompression_MoreCompressString (objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_MoreCompressString(_map(114, 'CkCompression_MoreCompressString'))
    (objHandle, str, outData);
end;

function CkCompression_MoreCompressStringENC (objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCompression_MoreCompressStringENC(_map(115, 'CkCompression_MoreCompressStringENC'))
    (objHandle, str, outStr);
end;

function CkCompression__moreCompressStringENC (objHandle: HCkCompression; str: PWideChar): PWideChar;
begin
  result := TCkCompression__moreCompressStringENC(_map(116, 'CkCompression__moreCompressStringENC'))
    (objHandle, str);
end;

function CkCompression_MoreDecompressBytes (objHandle: HCkCompression; data: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_MoreDecompressBytes(_map(117, 'CkCompression_MoreDecompressBytes'))
    (objHandle, data, outData);
end;

function CkCompression_MoreDecompressBytesENC (objHandle: HCkCompression; str: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkCompression_MoreDecompressBytesENC(_map(118, 'CkCompression_MoreDecompressBytesENC'))
    (objHandle, str, outData);
end;

function CkCompression_MoreDecompressString (objHandle: HCkCompression; data: HCkByteData; outStr: HCkString): wordbool;
begin
  result := TCkCompression_MoreDecompressString(_map(119, 'CkCompression_MoreDecompressString'))
    (objHandle, data, outStr);
end;

function CkCompression__moreDecompressString (objHandle: HCkCompression; data: HCkByteData): PWideChar;
begin
  result := TCkCompression__moreDecompressString(_map(120, 'CkCompression__moreDecompressString'))
    (objHandle, data);
end;

function CkCompression_MoreDecompressStringENC (objHandle: HCkCompression; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCompression_MoreDecompressStringENC(_map(121, 'CkCompression_MoreDecompressStringENC'))
    (objHandle, str, outStr);
end;

function CkCompression__moreDecompressStringENC (objHandle: HCkCompression; str: PWideChar): PWideChar;
begin
  result := TCkCompression__moreDecompressStringENC(_map(122, 'CkCompression__moreDecompressStringENC'))
    (objHandle, str);
end;

end.
