unit Csr;

interface

type

HCkPublicKey = Pointer;
HCkBinData = Pointer;
HCkPrivateKey = Pointer;
HCkXml = Pointer;
HCkString = Pointer;
HCkCsr = Pointer;
HCkStringTable = Pointer;


function CkCsr_Create: HCkCsr;  stdcall;
procedure CkCsr_Dispose(handle: HCkCsr); stdcall;
procedure CkCsr_getCommonName(objHandle: HCkCsr; outPropVal: HCkString);
procedure CkCsr_putCommonName(objHandle: HCkCsr; newPropVal: PWideChar);
function CkCsr__commonName(objHandle: HCkCsr): PWideChar;
procedure CkCsr_getCompany(objHandle: HCkCsr; outPropVal: HCkString);
procedure CkCsr_putCompany(objHandle: HCkCsr; newPropVal: PWideChar);
function CkCsr__company(objHandle: HCkCsr): PWideChar;
procedure CkCsr_getCompanyDivision(objHandle: HCkCsr; outPropVal: HCkString);
procedure CkCsr_putCompanyDivision(objHandle: HCkCsr; newPropVal: PWideChar);
function CkCsr__companyDivision(objHandle: HCkCsr): PWideChar;
procedure CkCsr_getCountry(objHandle: HCkCsr; outPropVal: HCkString);
procedure CkCsr_putCountry(objHandle: HCkCsr; newPropVal: PWideChar);
function CkCsr__country(objHandle: HCkCsr): PWideChar;
procedure CkCsr_getDebugLogFilePath(objHandle: HCkCsr; outPropVal: HCkString);
procedure CkCsr_putDebugLogFilePath(objHandle: HCkCsr; newPropVal: PWideChar);
function CkCsr__debugLogFilePath(objHandle: HCkCsr): PWideChar;
procedure CkCsr_getEmailAddress(objHandle: HCkCsr; outPropVal: HCkString);
procedure CkCsr_putEmailAddress(objHandle: HCkCsr; newPropVal: PWideChar);
function CkCsr__emailAddress(objHandle: HCkCsr): PWideChar;
procedure CkCsr_getHashAlgorithm(objHandle: HCkCsr; outPropVal: HCkString);
procedure CkCsr_putHashAlgorithm(objHandle: HCkCsr; newPropVal: PWideChar);
function CkCsr__hashAlgorithm(objHandle: HCkCsr): PWideChar;
procedure CkCsr_getLastErrorHtml(objHandle: HCkCsr; outPropVal: HCkString);
function CkCsr__lastErrorHtml(objHandle: HCkCsr): PWideChar;
procedure CkCsr_getLastErrorText(objHandle: HCkCsr; outPropVal: HCkString);
function CkCsr__lastErrorText(objHandle: HCkCsr): PWideChar;
procedure CkCsr_getLastErrorXml(objHandle: HCkCsr; outPropVal: HCkString);
function CkCsr__lastErrorXml(objHandle: HCkCsr): PWideChar;
function CkCsr_getLastMethodSuccess(objHandle: HCkCsr): wordbool;
procedure CkCsr_putLastMethodSuccess(objHandle: HCkCsr; newPropVal: wordbool);
procedure CkCsr_getLocality(objHandle: HCkCsr; outPropVal: HCkString);
procedure CkCsr_putLocality(objHandle: HCkCsr; newPropVal: PWideChar);
function CkCsr__locality(objHandle: HCkCsr): PWideChar;
procedure CkCsr_getMgfHashAlg(objHandle: HCkCsr; outPropVal: HCkString);
procedure CkCsr_putMgfHashAlg(objHandle: HCkCsr; newPropVal: PWideChar);
function CkCsr__mgfHashAlg(objHandle: HCkCsr): PWideChar;
function CkCsr_getPssPadding(objHandle: HCkCsr): wordbool;
procedure CkCsr_putPssPadding(objHandle: HCkCsr; newPropVal: wordbool);
procedure CkCsr_getState(objHandle: HCkCsr; outPropVal: HCkString);
procedure CkCsr_putState(objHandle: HCkCsr; newPropVal: PWideChar);
function CkCsr__state(objHandle: HCkCsr): PWideChar;
function CkCsr_getVerboseLogging(objHandle: HCkCsr): wordbool;
procedure CkCsr_putVerboseLogging(objHandle: HCkCsr; newPropVal: wordbool);
procedure CkCsr_getVersion(objHandle: HCkCsr; outPropVal: HCkString);
function CkCsr__version(objHandle: HCkCsr): PWideChar;
function CkCsr_AddSan(objHandle: HCkCsr; sanType: PWideChar; sanValue: PWideChar): wordbool;
function CkCsr_GenCsrBd(objHandle: HCkCsr; privKey: HCkPrivateKey; csrData: HCkBinData): wordbool;
function CkCsr_GenCsrPem(objHandle: HCkCsr; privKey: HCkPrivateKey; outStr: HCkString): wordbool;
function CkCsr__genCsrPem(objHandle: HCkCsr; privKey: HCkPrivateKey): PWideChar;
function CkCsr_GetExtensionRequest(objHandle: HCkCsr; extensionReqXml: HCkXml): wordbool;
function CkCsr_GetPublicKey(objHandle: HCkCsr; pubkey: HCkPublicKey): wordbool;
function CkCsr_GetSans(objHandle: HCkCsr; sans: HCkStringTable): wordbool;
function CkCsr_GetSubjectField(objHandle: HCkCsr; oid: PWideChar; outStr: HCkString): wordbool;
function CkCsr__getSubjectField(objHandle: HCkCsr; oid: PWideChar): PWideChar;
function CkCsr_LoadCsrPem(objHandle: HCkCsr; csrPemStr: PWideChar): wordbool;
function CkCsr_SetExtensionRequest(objHandle: HCkCsr; extensionReqXml: HCkXml): wordbool;
function CkCsr_SetSubjectField(objHandle: HCkCsr; oid: PWideChar; value: PWideChar; asnType: PWideChar): wordbool;
function CkCsr_VerifyCsr(objHandle: HCkCsr): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkCsr_Create = function : HCkCsr; stdcall;
  TCkCsr_Dispose = procedure (handle: HCkCsr); stdcall;
  TCkCsr_getCommonName = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr_putCommonName = procedure (objHandle: HCkCsr; newPropVal: PWideChar); stdcall;
  TCkCsr__commonName = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getCompany = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr_putCompany = procedure (objHandle: HCkCsr; newPropVal: PWideChar); stdcall;
  TCkCsr__company = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getCompanyDivision = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr_putCompanyDivision = procedure (objHandle: HCkCsr; newPropVal: PWideChar); stdcall;
  TCkCsr__companyDivision = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getCountry = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr_putCountry = procedure (objHandle: HCkCsr; newPropVal: PWideChar); stdcall;
  TCkCsr__country = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getDebugLogFilePath = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr_putDebugLogFilePath = procedure (objHandle: HCkCsr; newPropVal: PWideChar); stdcall;
  TCkCsr__debugLogFilePath = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getEmailAddress = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr_putEmailAddress = procedure (objHandle: HCkCsr; newPropVal: PWideChar); stdcall;
  TCkCsr__emailAddress = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getHashAlgorithm = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr_putHashAlgorithm = procedure (objHandle: HCkCsr; newPropVal: PWideChar); stdcall;
  TCkCsr__hashAlgorithm = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getLastErrorHtml = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr__lastErrorHtml = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getLastErrorText = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr__lastErrorText = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getLastErrorXml = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr__lastErrorXml = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getLastMethodSuccess = function (objHandle: HCkCsr): wordbool; stdcall;
  TCkCsr_putLastMethodSuccess = procedure (objHandle: HCkCsr; newPropVal: wordbool); stdcall;
  TCkCsr_getLocality = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr_putLocality = procedure (objHandle: HCkCsr; newPropVal: PWideChar); stdcall;
  TCkCsr__locality = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getMgfHashAlg = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr_putMgfHashAlg = procedure (objHandle: HCkCsr; newPropVal: PWideChar); stdcall;
  TCkCsr__mgfHashAlg = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getPssPadding = function (objHandle: HCkCsr): wordbool; stdcall;
  TCkCsr_putPssPadding = procedure (objHandle: HCkCsr; newPropVal: wordbool); stdcall;
  TCkCsr_getState = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr_putState = procedure (objHandle: HCkCsr; newPropVal: PWideChar); stdcall;
  TCkCsr__state = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_getVerboseLogging = function (objHandle: HCkCsr): wordbool; stdcall;
  TCkCsr_putVerboseLogging = procedure (objHandle: HCkCsr; newPropVal: wordbool); stdcall;
  TCkCsr_getVersion = procedure (objHandle: HCkCsr; outPropVal: HCkString); stdcall;
  TCkCsr__version = function (objHandle: HCkCsr): PWideChar; stdcall;
  TCkCsr_AddSan = function (objHandle: HCkCsr; sanType: PWideChar; sanValue: PWideChar): wordbool; stdcall;
  TCkCsr_GenCsrBd = function (objHandle: HCkCsr; privKey: HCkPrivateKey; csrData: HCkBinData): wordbool; stdcall;
  TCkCsr_GenCsrPem = function (objHandle: HCkCsr; privKey: HCkPrivateKey; outStr: HCkString): wordbool; stdcall;
  TCkCsr__genCsrPem = function (objHandle: HCkCsr; privKey: HCkPrivateKey): PWideChar; stdcall;
  TCkCsr_GetExtensionRequest = function (objHandle: HCkCsr; extensionReqXml: HCkXml): wordbool; stdcall;
  TCkCsr_GetPublicKey = function (objHandle: HCkCsr; pubkey: HCkPublicKey): wordbool; stdcall;
  TCkCsr_GetSans = function (objHandle: HCkCsr; sans: HCkStringTable): wordbool; stdcall;
  TCkCsr_GetSubjectField = function (objHandle: HCkCsr; oid: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkCsr__getSubjectField = function (objHandle: HCkCsr; oid: PWideChar): PWideChar; stdcall;
  TCkCsr_LoadCsrPem = function (objHandle: HCkCsr; csrPemStr: PWideChar): wordbool; stdcall;
  TCkCsr_SetExtensionRequest = function (objHandle: HCkCsr; extensionReqXml: HCkXml): wordbool; stdcall;
  TCkCsr_SetSubjectField = function (objHandle: HCkCsr; oid: PWideChar; value: PWideChar; asnType: PWideChar): wordbool; stdcall;
  TCkCsr_VerifyCsr = function (objHandle: HCkCsr): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..58] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkCsr_Create : HCkCsr;
begin
  result := TCkCsr_Create(_map(0, 'CkCsr_Create'));
end;

procedure CkCsr_Dispose (handle: HCkCsr);
begin
  TCkCsr_Dispose(_map(1, 'CkCsr_Dispose'))
    (handle);
end;


procedure CkCsr_getCommonName (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getCommonName(_map(2, 'CkCsr_getCommonName'))
    (objHandle, outPropVal);
end;

procedure CkCsr_putCommonName (objHandle: HCkCsr; newPropVal: PWideChar);
begin
  TCkCsr_putCommonName(_map(3, 'CkCsr_putCommonName'))
    (objHandle, newPropVal);
end;

function CkCsr__commonName (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__commonName(_map(4, 'CkCsr__commonName'))
    (objHandle);
end;

procedure CkCsr_getCompany (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getCompany(_map(5, 'CkCsr_getCompany'))
    (objHandle, outPropVal);
end;

procedure CkCsr_putCompany (objHandle: HCkCsr; newPropVal: PWideChar);
begin
  TCkCsr_putCompany(_map(6, 'CkCsr_putCompany'))
    (objHandle, newPropVal);
end;

function CkCsr__company (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__company(_map(7, 'CkCsr__company'))
    (objHandle);
end;

procedure CkCsr_getCompanyDivision (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getCompanyDivision(_map(8, 'CkCsr_getCompanyDivision'))
    (objHandle, outPropVal);
end;

procedure CkCsr_putCompanyDivision (objHandle: HCkCsr; newPropVal: PWideChar);
begin
  TCkCsr_putCompanyDivision(_map(9, 'CkCsr_putCompanyDivision'))
    (objHandle, newPropVal);
end;

function CkCsr__companyDivision (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__companyDivision(_map(10, 'CkCsr__companyDivision'))
    (objHandle);
end;

procedure CkCsr_getCountry (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getCountry(_map(11, 'CkCsr_getCountry'))
    (objHandle, outPropVal);
end;

procedure CkCsr_putCountry (objHandle: HCkCsr; newPropVal: PWideChar);
begin
  TCkCsr_putCountry(_map(12, 'CkCsr_putCountry'))
    (objHandle, newPropVal);
end;

function CkCsr__country (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__country(_map(13, 'CkCsr__country'))
    (objHandle);
end;

procedure CkCsr_getDebugLogFilePath (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getDebugLogFilePath(_map(14, 'CkCsr_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkCsr_putDebugLogFilePath (objHandle: HCkCsr; newPropVal: PWideChar);
begin
  TCkCsr_putDebugLogFilePath(_map(15, 'CkCsr_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkCsr__debugLogFilePath (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__debugLogFilePath(_map(16, 'CkCsr__debugLogFilePath'))
    (objHandle);
end;

procedure CkCsr_getEmailAddress (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getEmailAddress(_map(17, 'CkCsr_getEmailAddress'))
    (objHandle, outPropVal);
end;

procedure CkCsr_putEmailAddress (objHandle: HCkCsr; newPropVal: PWideChar);
begin
  TCkCsr_putEmailAddress(_map(18, 'CkCsr_putEmailAddress'))
    (objHandle, newPropVal);
end;

function CkCsr__emailAddress (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__emailAddress(_map(19, 'CkCsr__emailAddress'))
    (objHandle);
end;

procedure CkCsr_getHashAlgorithm (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getHashAlgorithm(_map(20, 'CkCsr_getHashAlgorithm'))
    (objHandle, outPropVal);
end;

procedure CkCsr_putHashAlgorithm (objHandle: HCkCsr; newPropVal: PWideChar);
begin
  TCkCsr_putHashAlgorithm(_map(21, 'CkCsr_putHashAlgorithm'))
    (objHandle, newPropVal);
end;

function CkCsr__hashAlgorithm (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__hashAlgorithm(_map(22, 'CkCsr__hashAlgorithm'))
    (objHandle);
end;

procedure CkCsr_getLastErrorHtml (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getLastErrorHtml(_map(23, 'CkCsr_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkCsr__lastErrorHtml (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__lastErrorHtml(_map(24, 'CkCsr__lastErrorHtml'))
    (objHandle);
end;

procedure CkCsr_getLastErrorText (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getLastErrorText(_map(25, 'CkCsr_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkCsr__lastErrorText (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__lastErrorText(_map(26, 'CkCsr__lastErrorText'))
    (objHandle);
end;

procedure CkCsr_getLastErrorXml (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getLastErrorXml(_map(27, 'CkCsr_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkCsr__lastErrorXml (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__lastErrorXml(_map(28, 'CkCsr__lastErrorXml'))
    (objHandle);
end;

function CkCsr_getLastMethodSuccess (objHandle: HCkCsr): wordbool;
begin
    result := TCkCsr_getLastMethodSuccess(_map(29, 'CkCsr_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkCsr_putLastMethodSuccess (objHandle: HCkCsr; newPropVal: wordbool);
begin
  TCkCsr_putLastMethodSuccess(_map(30, 'CkCsr_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkCsr_getLocality (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getLocality(_map(31, 'CkCsr_getLocality'))
    (objHandle, outPropVal);
end;

procedure CkCsr_putLocality (objHandle: HCkCsr; newPropVal: PWideChar);
begin
  TCkCsr_putLocality(_map(32, 'CkCsr_putLocality'))
    (objHandle, newPropVal);
end;

function CkCsr__locality (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__locality(_map(33, 'CkCsr__locality'))
    (objHandle);
end;

procedure CkCsr_getMgfHashAlg (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getMgfHashAlg(_map(34, 'CkCsr_getMgfHashAlg'))
    (objHandle, outPropVal);
end;

procedure CkCsr_putMgfHashAlg (objHandle: HCkCsr; newPropVal: PWideChar);
begin
  TCkCsr_putMgfHashAlg(_map(35, 'CkCsr_putMgfHashAlg'))
    (objHandle, newPropVal);
end;

function CkCsr__mgfHashAlg (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__mgfHashAlg(_map(36, 'CkCsr__mgfHashAlg'))
    (objHandle);
end;

function CkCsr_getPssPadding (objHandle: HCkCsr): wordbool;
begin
    result := TCkCsr_getPssPadding(_map(37, 'CkCsr_getPssPadding'))
    (objHandle);
end;

procedure CkCsr_putPssPadding (objHandle: HCkCsr; newPropVal: wordbool);
begin
  TCkCsr_putPssPadding(_map(38, 'CkCsr_putPssPadding'))
    (objHandle, newPropVal);
end;

procedure CkCsr_getState (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getState(_map(39, 'CkCsr_getState'))
    (objHandle, outPropVal);
end;

procedure CkCsr_putState (objHandle: HCkCsr; newPropVal: PWideChar);
begin
  TCkCsr_putState(_map(40, 'CkCsr_putState'))
    (objHandle, newPropVal);
end;

function CkCsr__state (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__state(_map(41, 'CkCsr__state'))
    (objHandle);
end;

function CkCsr_getVerboseLogging (objHandle: HCkCsr): wordbool;
begin
    result := TCkCsr_getVerboseLogging(_map(42, 'CkCsr_getVerboseLogging'))
    (objHandle);
end;

procedure CkCsr_putVerboseLogging (objHandle: HCkCsr; newPropVal: wordbool);
begin
  TCkCsr_putVerboseLogging(_map(43, 'CkCsr_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkCsr_getVersion (objHandle: HCkCsr; outPropVal: HCkString);
begin
  TCkCsr_getVersion(_map(44, 'CkCsr_getVersion'))
    (objHandle, outPropVal);
end;

function CkCsr__version (objHandle: HCkCsr): PWideChar;
begin
  result := TCkCsr__version(_map(45, 'CkCsr__version'))
    (objHandle);
end;

function CkCsr_AddSan (objHandle: HCkCsr; sanType: PWideChar; sanValue: PWideChar): wordbool;
begin
  result := TCkCsr_AddSan(_map(46, 'CkCsr_AddSan'))
    (objHandle, sanType, sanValue);
end;

function CkCsr_GenCsrBd (objHandle: HCkCsr; privKey: HCkPrivateKey; csrData: HCkBinData): wordbool;
begin
  result := TCkCsr_GenCsrBd(_map(47, 'CkCsr_GenCsrBd'))
    (objHandle, privKey, csrData);
end;

function CkCsr_GenCsrPem (objHandle: HCkCsr; privKey: HCkPrivateKey; outStr: HCkString): wordbool;
begin
  result := TCkCsr_GenCsrPem(_map(48, 'CkCsr_GenCsrPem'))
    (objHandle, privKey, outStr);
end;

function CkCsr__genCsrPem (objHandle: HCkCsr; privKey: HCkPrivateKey): PWideChar;
begin
  result := TCkCsr__genCsrPem(_map(49, 'CkCsr__genCsrPem'))
    (objHandle, privKey);
end;

function CkCsr_GetExtensionRequest (objHandle: HCkCsr; extensionReqXml: HCkXml): wordbool;
begin
  result := TCkCsr_GetExtensionRequest(_map(50, 'CkCsr_GetExtensionRequest'))
    (objHandle, extensionReqXml);
end;

function CkCsr_GetPublicKey (objHandle: HCkCsr; pubkey: HCkPublicKey): wordbool;
begin
  result := TCkCsr_GetPublicKey(_map(51, 'CkCsr_GetPublicKey'))
    (objHandle, pubkey);
end;

function CkCsr_GetSans (objHandle: HCkCsr; sans: HCkStringTable): wordbool;
begin
  result := TCkCsr_GetSans(_map(52, 'CkCsr_GetSans'))
    (objHandle, sans);
end;

function CkCsr_GetSubjectField (objHandle: HCkCsr; oid: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkCsr_GetSubjectField(_map(53, 'CkCsr_GetSubjectField'))
    (objHandle, oid, outStr);
end;

function CkCsr__getSubjectField (objHandle: HCkCsr; oid: PWideChar): PWideChar;
begin
  result := TCkCsr__getSubjectField(_map(54, 'CkCsr__getSubjectField'))
    (objHandle, oid);
end;

function CkCsr_LoadCsrPem (objHandle: HCkCsr; csrPemStr: PWideChar): wordbool;
begin
  result := TCkCsr_LoadCsrPem(_map(55, 'CkCsr_LoadCsrPem'))
    (objHandle, csrPemStr);
end;

function CkCsr_SetExtensionRequest (objHandle: HCkCsr; extensionReqXml: HCkXml): wordbool;
begin
  result := TCkCsr_SetExtensionRequest(_map(56, 'CkCsr_SetExtensionRequest'))
    (objHandle, extensionReqXml);
end;

function CkCsr_SetSubjectField (objHandle: HCkCsr; oid: PWideChar; value: PWideChar; asnType: PWideChar): wordbool;
begin
  result := TCkCsr_SetSubjectField(_map(57, 'CkCsr_SetSubjectField'))
    (objHandle, oid, value, asnType);
end;

function CkCsr_VerifyCsr (objHandle: HCkCsr): wordbool;
begin
  result := TCkCsr_VerifyCsr(_map(58, 'CkCsr_VerifyCsr'))
    (objHandle);
end;

end.
