unit Dh;

interface

type

HCkDh = Pointer;
HCkString = Pointer;


function CkDh_Create: HCkDh;  stdcall;
procedure CkDh_Dispose(handle: HCkDh); stdcall;
procedure CkDh_getDebugLogFilePath(objHandle: HCkDh; outPropVal: HCkString);
procedure CkDh_putDebugLogFilePath(objHandle: HCkDh; newPropVal: PWideChar);
function CkDh__debugLogFilePath(objHandle: HCkDh): PWideChar;
function CkDh_getG(objHandle: HCkDh): Integer;
procedure CkDh_getLastErrorHtml(objHandle: HCkDh; outPropVal: HCkString);
function CkDh__lastErrorHtml(objHandle: HCkDh): PWideChar;
procedure CkDh_getLastErrorText(objHandle: HCkDh; outPropVal: HCkString);
function CkDh__lastErrorText(objHandle: HCkDh): PWideChar;
procedure CkDh_getLastErrorXml(objHandle: HCkDh; outPropVal: HCkString);
function CkDh__lastErrorXml(objHandle: HCkDh): PWideChar;
function CkDh_getLastMethodSuccess(objHandle: HCkDh): wordbool;
procedure CkDh_putLastMethodSuccess(objHandle: HCkDh; newPropVal: wordbool);
procedure CkDh_getP(objHandle: HCkDh; outPropVal: HCkString);
function CkDh__p(objHandle: HCkDh): PWideChar;
function CkDh_getVerboseLogging(objHandle: HCkDh): wordbool;
procedure CkDh_putVerboseLogging(objHandle: HCkDh; newPropVal: wordbool);
procedure CkDh_getVersion(objHandle: HCkDh; outPropVal: HCkString);
function CkDh__version(objHandle: HCkDh): PWideChar;
function CkDh_CreateE(objHandle: HCkDh; numBits: Integer; outStr: HCkString): wordbool;
function CkDh__createE(objHandle: HCkDh; numBits: Integer): PWideChar;
function CkDh_FindK(objHandle: HCkDh; E: PWideChar; outStr: HCkString): wordbool;
function CkDh__findK(objHandle: HCkDh; E: PWideChar): PWideChar;
function CkDh_GenPG(objHandle: HCkDh; numBits: Integer; G: Integer): wordbool;
function CkDh_SetPG(objHandle: HCkDh; p: PWideChar; g: Integer): wordbool;
procedure CkDh_UseKnownPrime(objHandle: HCkDh; index: Integer);
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkDh_Create = function : HCkDh; stdcall;
  TCkDh_Dispose = procedure (handle: HCkDh); stdcall;
  TCkDh_getDebugLogFilePath = procedure (objHandle: HCkDh; outPropVal: HCkString); stdcall;
  TCkDh_putDebugLogFilePath = procedure (objHandle: HCkDh; newPropVal: PWideChar); stdcall;
  TCkDh__debugLogFilePath = function (objHandle: HCkDh): PWideChar; stdcall;
  TCkDh_getG = function (objHandle: HCkDh): Integer; stdcall;
  TCkDh_getLastErrorHtml = procedure (objHandle: HCkDh; outPropVal: HCkString); stdcall;
  TCkDh__lastErrorHtml = function (objHandle: HCkDh): PWideChar; stdcall;
  TCkDh_getLastErrorText = procedure (objHandle: HCkDh; outPropVal: HCkString); stdcall;
  TCkDh__lastErrorText = function (objHandle: HCkDh): PWideChar; stdcall;
  TCkDh_getLastErrorXml = procedure (objHandle: HCkDh; outPropVal: HCkString); stdcall;
  TCkDh__lastErrorXml = function (objHandle: HCkDh): PWideChar; stdcall;
  TCkDh_getLastMethodSuccess = function (objHandle: HCkDh): wordbool; stdcall;
  TCkDh_putLastMethodSuccess = procedure (objHandle: HCkDh; newPropVal: wordbool); stdcall;
  TCkDh_getP = procedure (objHandle: HCkDh; outPropVal: HCkString); stdcall;
  TCkDh__p = function (objHandle: HCkDh): PWideChar; stdcall;
  TCkDh_getVerboseLogging = function (objHandle: HCkDh): wordbool; stdcall;
  TCkDh_putVerboseLogging = procedure (objHandle: HCkDh; newPropVal: wordbool); stdcall;
  TCkDh_getVersion = procedure (objHandle: HCkDh; outPropVal: HCkString); stdcall;
  TCkDh__version = function (objHandle: HCkDh): PWideChar; stdcall;
  TCkDh_CreateE = function (objHandle: HCkDh; numBits: Integer; outStr: HCkString): wordbool; stdcall;
  TCkDh__createE = function (objHandle: HCkDh; numBits: Integer): PWideChar; stdcall;
  TCkDh_FindK = function (objHandle: HCkDh; E: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkDh__findK = function (objHandle: HCkDh; E: PWideChar): PWideChar; stdcall;
  TCkDh_GenPG = function (objHandle: HCkDh; numBits: Integer; G: Integer): wordbool; stdcall;
  TCkDh_SetPG = function (objHandle: HCkDh; p: PWideChar; g: Integer): wordbool; stdcall;
  TCkDh_UseKnownPrime = procedure (objHandle: HCkDh; index: Integer); stdcall;

var
  _fkt_ptr_arr:   array [0..26] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkDh_Create : HCkDh;
begin
  result := TCkDh_Create(_map(0, 'CkDh_Create'));
end;

procedure CkDh_Dispose (handle: HCkDh);
begin
  TCkDh_Dispose(_map(1, 'CkDh_Dispose'))
    (handle);
end;


procedure CkDh_getDebugLogFilePath (objHandle: HCkDh; outPropVal: HCkString);
begin
  TCkDh_getDebugLogFilePath(_map(2, 'CkDh_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkDh_putDebugLogFilePath (objHandle: HCkDh; newPropVal: PWideChar);
begin
  TCkDh_putDebugLogFilePath(_map(3, 'CkDh_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkDh__debugLogFilePath (objHandle: HCkDh): PWideChar;
begin
  result := TCkDh__debugLogFilePath(_map(4, 'CkDh__debugLogFilePath'))
    (objHandle);
end;

function CkDh_getG (objHandle: HCkDh): Integer;
begin
    result := TCkDh_getG(_map(5, 'CkDh_getG'))
    (objHandle);
end;

procedure CkDh_getLastErrorHtml (objHandle: HCkDh; outPropVal: HCkString);
begin
  TCkDh_getLastErrorHtml(_map(6, 'CkDh_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkDh__lastErrorHtml (objHandle: HCkDh): PWideChar;
begin
  result := TCkDh__lastErrorHtml(_map(7, 'CkDh__lastErrorHtml'))
    (objHandle);
end;

procedure CkDh_getLastErrorText (objHandle: HCkDh; outPropVal: HCkString);
begin
  TCkDh_getLastErrorText(_map(8, 'CkDh_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkDh__lastErrorText (objHandle: HCkDh): PWideChar;
begin
  result := TCkDh__lastErrorText(_map(9, 'CkDh__lastErrorText'))
    (objHandle);
end;

procedure CkDh_getLastErrorXml (objHandle: HCkDh; outPropVal: HCkString);
begin
  TCkDh_getLastErrorXml(_map(10, 'CkDh_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkDh__lastErrorXml (objHandle: HCkDh): PWideChar;
begin
  result := TCkDh__lastErrorXml(_map(11, 'CkDh__lastErrorXml'))
    (objHandle);
end;

function CkDh_getLastMethodSuccess (objHandle: HCkDh): wordbool;
begin
    result := TCkDh_getLastMethodSuccess(_map(12, 'CkDh_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkDh_putLastMethodSuccess (objHandle: HCkDh; newPropVal: wordbool);
begin
  TCkDh_putLastMethodSuccess(_map(13, 'CkDh_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkDh_getP (objHandle: HCkDh; outPropVal: HCkString);
begin
  TCkDh_getP(_map(14, 'CkDh_getP'))
    (objHandle, outPropVal);
end;

function CkDh__p (objHandle: HCkDh): PWideChar;
begin
  result := TCkDh__p(_map(15, 'CkDh__p'))
    (objHandle);
end;

function CkDh_getVerboseLogging (objHandle: HCkDh): wordbool;
begin
    result := TCkDh_getVerboseLogging(_map(16, 'CkDh_getVerboseLogging'))
    (objHandle);
end;

procedure CkDh_putVerboseLogging (objHandle: HCkDh; newPropVal: wordbool);
begin
  TCkDh_putVerboseLogging(_map(17, 'CkDh_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkDh_getVersion (objHandle: HCkDh; outPropVal: HCkString);
begin
  TCkDh_getVersion(_map(18, 'CkDh_getVersion'))
    (objHandle, outPropVal);
end;

function CkDh__version (objHandle: HCkDh): PWideChar;
begin
  result := TCkDh__version(_map(19, 'CkDh__version'))
    (objHandle);
end;

function CkDh_CreateE (objHandle: HCkDh; numBits: Integer; outStr: HCkString): wordbool;
begin
  result := TCkDh_CreateE(_map(20, 'CkDh_CreateE'))
    (objHandle, numBits, outStr);
end;

function CkDh__createE (objHandle: HCkDh; numBits: Integer): PWideChar;
begin
  result := TCkDh__createE(_map(21, 'CkDh__createE'))
    (objHandle, numBits);
end;

function CkDh_FindK (objHandle: HCkDh; E: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkDh_FindK(_map(22, 'CkDh_FindK'))
    (objHandle, E, outStr);
end;

function CkDh__findK (objHandle: HCkDh; E: PWideChar): PWideChar;
begin
  result := TCkDh__findK(_map(23, 'CkDh__findK'))
    (objHandle, E);
end;

function CkDh_GenPG (objHandle: HCkDh; numBits: Integer; G: Integer): wordbool;
begin
  result := TCkDh_GenPG(_map(24, 'CkDh_GenPG'))
    (objHandle, numBits, G);
end;

function CkDh_SetPG (objHandle: HCkDh; p: PWideChar; g: Integer): wordbool;
begin
  result := TCkDh_SetPG(_map(25, 'CkDh_SetPG'))
    (objHandle, p, g);
end;

procedure CkDh_UseKnownPrime (objHandle: HCkDh; index: Integer);
begin
  TCkDh_UseKnownPrime(_map(26, 'CkDh_UseKnownPrime'))
    (objHandle, index);
end;

end.
