unit DirTree;

interface

type

HCkDirTree = Pointer;
HCkString = Pointer;


function CkDirTree_Create: HCkDirTree;  stdcall;
procedure CkDirTree_Dispose(handle: HCkDirTree); stdcall;
procedure CkDirTree_getBaseDir(objHandle: HCkDirTree; outPropVal: HCkString);
procedure CkDirTree_putBaseDir(objHandle: HCkDirTree; newPropVal: PWideChar);
function CkDirTree__baseDir(objHandle: HCkDirTree): PWideChar;
procedure CkDirTree_getDebugLogFilePath(objHandle: HCkDirTree; outPropVal: HCkString);
procedure CkDirTree_putDebugLogFilePath(objHandle: HCkDirTree; newPropVal: PWideChar);
function CkDirTree__debugLogFilePath(objHandle: HCkDirTree): PWideChar;
function CkDirTree_getDoneIterating(objHandle: HCkDirTree): wordbool;
function CkDirTree_getFileSize32(objHandle: HCkDirTree): Integer;
function CkDirTree_getFileSize64(objHandle: HCkDirTree): Int64;
procedure CkDirTree_getFileSizeStr(objHandle: HCkDirTree; outPropVal: HCkString);
function CkDirTree__fileSizeStr(objHandle: HCkDirTree): PWideChar;
procedure CkDirTree_getFullPath(objHandle: HCkDirTree; outPropVal: HCkString);
function CkDirTree__fullPath(objHandle: HCkDirTree): PWideChar;
procedure CkDirTree_getFullUncPath(objHandle: HCkDirTree; outPropVal: HCkString);
function CkDirTree__fullUncPath(objHandle: HCkDirTree): PWideChar;
function CkDirTree_getIsDirectory(objHandle: HCkDirTree): wordbool;
procedure CkDirTree_getLastErrorHtml(objHandle: HCkDirTree; outPropVal: HCkString);
function CkDirTree__lastErrorHtml(objHandle: HCkDirTree): PWideChar;
procedure CkDirTree_getLastErrorText(objHandle: HCkDirTree; outPropVal: HCkString);
function CkDirTree__lastErrorText(objHandle: HCkDirTree): PWideChar;
procedure CkDirTree_getLastErrorXml(objHandle: HCkDirTree; outPropVal: HCkString);
function CkDirTree__lastErrorXml(objHandle: HCkDirTree): PWideChar;
function CkDirTree_getLastMethodSuccess(objHandle: HCkDirTree): wordbool;
procedure CkDirTree_putLastMethodSuccess(objHandle: HCkDirTree; newPropVal: wordbool);
function CkDirTree_getRecurse(objHandle: HCkDirTree): wordbool;
procedure CkDirTree_putRecurse(objHandle: HCkDirTree; newPropVal: wordbool);
procedure CkDirTree_getRelativePath(objHandle: HCkDirTree; outPropVal: HCkString);
function CkDirTree__relativePath(objHandle: HCkDirTree): PWideChar;
procedure CkDirTree_getUncommonOptions(objHandle: HCkDirTree; outPropVal: HCkString);
procedure CkDirTree_putUncommonOptions(objHandle: HCkDirTree; newPropVal: PWideChar);
function CkDirTree__uncommonOptions(objHandle: HCkDirTree): PWideChar;
function CkDirTree_getVerboseLogging(objHandle: HCkDirTree): wordbool;
procedure CkDirTree_putVerboseLogging(objHandle: HCkDirTree; newPropVal: wordbool);
procedure CkDirTree_getVersion(objHandle: HCkDirTree; outPropVal: HCkString);
function CkDirTree__version(objHandle: HCkDirTree): PWideChar;
function CkDirTree_AdvancePosition(objHandle: HCkDirTree): wordbool;
function CkDirTree_BeginIterate(objHandle: HCkDirTree): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkDirTree_Create = function : HCkDirTree; stdcall;
  TCkDirTree_Dispose = procedure (handle: HCkDirTree); stdcall;
  TCkDirTree_getBaseDir = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree_putBaseDir = procedure (objHandle: HCkDirTree; newPropVal: PWideChar); stdcall;
  TCkDirTree__baseDir = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_getDebugLogFilePath = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree_putDebugLogFilePath = procedure (objHandle: HCkDirTree; newPropVal: PWideChar); stdcall;
  TCkDirTree__debugLogFilePath = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_getDoneIterating = function (objHandle: HCkDirTree): wordbool; stdcall;
  TCkDirTree_getFileSize32 = function (objHandle: HCkDirTree): Integer; stdcall;
  TCkDirTree_getFileSize64 = function (objHandle: HCkDirTree): Int64; stdcall;
  TCkDirTree_getFileSizeStr = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree__fileSizeStr = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_getFullPath = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree__fullPath = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_getFullUncPath = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree__fullUncPath = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_getIsDirectory = function (objHandle: HCkDirTree): wordbool; stdcall;
  TCkDirTree_getLastErrorHtml = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree__lastErrorHtml = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_getLastErrorText = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree__lastErrorText = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_getLastErrorXml = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree__lastErrorXml = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_getLastMethodSuccess = function (objHandle: HCkDirTree): wordbool; stdcall;
  TCkDirTree_putLastMethodSuccess = procedure (objHandle: HCkDirTree; newPropVal: wordbool); stdcall;
  TCkDirTree_getRecurse = function (objHandle: HCkDirTree): wordbool; stdcall;
  TCkDirTree_putRecurse = procedure (objHandle: HCkDirTree; newPropVal: wordbool); stdcall;
  TCkDirTree_getRelativePath = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree__relativePath = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_getUncommonOptions = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree_putUncommonOptions = procedure (objHandle: HCkDirTree; newPropVal: PWideChar); stdcall;
  TCkDirTree__uncommonOptions = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_getVerboseLogging = function (objHandle: HCkDirTree): wordbool; stdcall;
  TCkDirTree_putVerboseLogging = procedure (objHandle: HCkDirTree; newPropVal: wordbool); stdcall;
  TCkDirTree_getVersion = procedure (objHandle: HCkDirTree; outPropVal: HCkString); stdcall;
  TCkDirTree__version = function (objHandle: HCkDirTree): PWideChar; stdcall;
  TCkDirTree_AdvancePosition = function (objHandle: HCkDirTree): wordbool; stdcall;
  TCkDirTree_BeginIterate = function (objHandle: HCkDirTree): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..38] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkDirTree_Create : HCkDirTree;
begin
  result := TCkDirTree_Create(_map(0, 'CkDirTree_Create'));
end;

procedure CkDirTree_Dispose (handle: HCkDirTree);
begin
  TCkDirTree_Dispose(_map(1, 'CkDirTree_Dispose'))
    (handle);
end;


procedure CkDirTree_getBaseDir (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getBaseDir(_map(2, 'CkDirTree_getBaseDir'))
    (objHandle, outPropVal);
end;

procedure CkDirTree_putBaseDir (objHandle: HCkDirTree; newPropVal: PWideChar);
begin
  TCkDirTree_putBaseDir(_map(3, 'CkDirTree_putBaseDir'))
    (objHandle, newPropVal);
end;

function CkDirTree__baseDir (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__baseDir(_map(4, 'CkDirTree__baseDir'))
    (objHandle);
end;

procedure CkDirTree_getDebugLogFilePath (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getDebugLogFilePath(_map(5, 'CkDirTree_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkDirTree_putDebugLogFilePath (objHandle: HCkDirTree; newPropVal: PWideChar);
begin
  TCkDirTree_putDebugLogFilePath(_map(6, 'CkDirTree_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkDirTree__debugLogFilePath (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__debugLogFilePath(_map(7, 'CkDirTree__debugLogFilePath'))
    (objHandle);
end;

function CkDirTree_getDoneIterating (objHandle: HCkDirTree): wordbool;
begin
    result := TCkDirTree_getDoneIterating(_map(8, 'CkDirTree_getDoneIterating'))
    (objHandle);
end;

function CkDirTree_getFileSize32 (objHandle: HCkDirTree): Integer;
begin
    result := TCkDirTree_getFileSize32(_map(9, 'CkDirTree_getFileSize32'))
    (objHandle);
end;

function CkDirTree_getFileSize64 (objHandle: HCkDirTree): Int64;
begin
    result := TCkDirTree_getFileSize64(_map(10, 'CkDirTree_getFileSize64'))
    (objHandle);
end;

procedure CkDirTree_getFileSizeStr (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getFileSizeStr(_map(11, 'CkDirTree_getFileSizeStr'))
    (objHandle, outPropVal);
end;

function CkDirTree__fileSizeStr (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__fileSizeStr(_map(12, 'CkDirTree__fileSizeStr'))
    (objHandle);
end;

procedure CkDirTree_getFullPath (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getFullPath(_map(13, 'CkDirTree_getFullPath'))
    (objHandle, outPropVal);
end;

function CkDirTree__fullPath (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__fullPath(_map(14, 'CkDirTree__fullPath'))
    (objHandle);
end;

procedure CkDirTree_getFullUncPath (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getFullUncPath(_map(15, 'CkDirTree_getFullUncPath'))
    (objHandle, outPropVal);
end;

function CkDirTree__fullUncPath (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__fullUncPath(_map(16, 'CkDirTree__fullUncPath'))
    (objHandle);
end;

function CkDirTree_getIsDirectory (objHandle: HCkDirTree): wordbool;
begin
    result := TCkDirTree_getIsDirectory(_map(17, 'CkDirTree_getIsDirectory'))
    (objHandle);
end;

procedure CkDirTree_getLastErrorHtml (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getLastErrorHtml(_map(18, 'CkDirTree_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkDirTree__lastErrorHtml (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__lastErrorHtml(_map(19, 'CkDirTree__lastErrorHtml'))
    (objHandle);
end;

procedure CkDirTree_getLastErrorText (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getLastErrorText(_map(20, 'CkDirTree_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkDirTree__lastErrorText (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__lastErrorText(_map(21, 'CkDirTree__lastErrorText'))
    (objHandle);
end;

procedure CkDirTree_getLastErrorXml (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getLastErrorXml(_map(22, 'CkDirTree_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkDirTree__lastErrorXml (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__lastErrorXml(_map(23, 'CkDirTree__lastErrorXml'))
    (objHandle);
end;

function CkDirTree_getLastMethodSuccess (objHandle: HCkDirTree): wordbool;
begin
    result := TCkDirTree_getLastMethodSuccess(_map(24, 'CkDirTree_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkDirTree_putLastMethodSuccess (objHandle: HCkDirTree; newPropVal: wordbool);
begin
  TCkDirTree_putLastMethodSuccess(_map(25, 'CkDirTree_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkDirTree_getRecurse (objHandle: HCkDirTree): wordbool;
begin
    result := TCkDirTree_getRecurse(_map(26, 'CkDirTree_getRecurse'))
    (objHandle);
end;

procedure CkDirTree_putRecurse (objHandle: HCkDirTree; newPropVal: wordbool);
begin
  TCkDirTree_putRecurse(_map(27, 'CkDirTree_putRecurse'))
    (objHandle, newPropVal);
end;

procedure CkDirTree_getRelativePath (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getRelativePath(_map(28, 'CkDirTree_getRelativePath'))
    (objHandle, outPropVal);
end;

function CkDirTree__relativePath (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__relativePath(_map(29, 'CkDirTree__relativePath'))
    (objHandle);
end;

procedure CkDirTree_getUncommonOptions (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getUncommonOptions(_map(30, 'CkDirTree_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkDirTree_putUncommonOptions (objHandle: HCkDirTree; newPropVal: PWideChar);
begin
  TCkDirTree_putUncommonOptions(_map(31, 'CkDirTree_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkDirTree__uncommonOptions (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__uncommonOptions(_map(32, 'CkDirTree__uncommonOptions'))
    (objHandle);
end;

function CkDirTree_getVerboseLogging (objHandle: HCkDirTree): wordbool;
begin
    result := TCkDirTree_getVerboseLogging(_map(33, 'CkDirTree_getVerboseLogging'))
    (objHandle);
end;

procedure CkDirTree_putVerboseLogging (objHandle: HCkDirTree; newPropVal: wordbool);
begin
  TCkDirTree_putVerboseLogging(_map(34, 'CkDirTree_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkDirTree_getVersion (objHandle: HCkDirTree; outPropVal: HCkString);
begin
  TCkDirTree_getVersion(_map(35, 'CkDirTree_getVersion'))
    (objHandle, outPropVal);
end;

function CkDirTree__version (objHandle: HCkDirTree): PWideChar;
begin
  result := TCkDirTree__version(_map(36, 'CkDirTree__version'))
    (objHandle);
end;

function CkDirTree_AdvancePosition (objHandle: HCkDirTree): wordbool;
begin
  result := TCkDirTree_AdvancePosition(_map(37, 'CkDirTree_AdvancePosition'))
    (objHandle);
end;

function CkDirTree_BeginIterate (objHandle: HCkDirTree): wordbool;
begin
  result := TCkDirTree_BeginIterate(_map(38, 'CkDirTree_BeginIterate'))
    (objHandle);
end;

end.
