unit Dns;

interface

type

HCkTask = Pointer;
HCkJsonObject = Pointer;
HCkDns = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TDnsAbortCheck = function(): Integer; cdecl;
TDnsProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TDnsPercentDone = function(pctDone: Integer): Integer; cdecl;
TDnsTaskCompleted = procedure(task: HCkTask); cdecl;


function CkDns_Create: HCkDns;  stdcall;
procedure CkDns_Dispose(handle: HCkDns); stdcall;

procedure CkDns_SetAbortCheck(objHandle: HCkDns; fn: TDnsAbortCheck) stdcall;
procedure CkDns_SetProgressInfo(objHandle: HCkDns; fn: TDnsProgressInfo) stdcall;
procedure CkDns_SetPercentDone(objHandle: HCkDns; fn: TDnsPercentDone) stdcall;
procedure CkDns_SetTaskCompleted(objHandle: HCkDns; fn: TDnsTaskCompleted) stdcall;
procedure CkDns_getDebugLogFilePath(objHandle: HCkDns; outPropVal: HCkString);
procedure CkDns_putDebugLogFilePath(objHandle: HCkDns; newPropVal: PWideChar);
function CkDns__debugLogFilePath(objHandle: HCkDns): PWideChar;
function CkDns_getHeartbeatMs(objHandle: HCkDns): Integer;
procedure CkDns_putHeartbeatMs(objHandle: HCkDns; newPropVal: Integer);
procedure CkDns_getLastErrorHtml(objHandle: HCkDns; outPropVal: HCkString);
function CkDns__lastErrorHtml(objHandle: HCkDns): PWideChar;
procedure CkDns_getLastErrorText(objHandle: HCkDns; outPropVal: HCkString);
function CkDns__lastErrorText(objHandle: HCkDns): PWideChar;
procedure CkDns_getLastErrorXml(objHandle: HCkDns; outPropVal: HCkString);
function CkDns__lastErrorXml(objHandle: HCkDns): PWideChar;
function CkDns_getLastMethodSuccess(objHandle: HCkDns): wordbool;
procedure CkDns_putLastMethodSuccess(objHandle: HCkDns; newPropVal: wordbool);
function CkDns_getMaxWaitMs(objHandle: HCkDns): Integer;
procedure CkDns_putMaxWaitMs(objHandle: HCkDns; newPropVal: Integer);
function CkDns_getNumNameservers(objHandle: HCkDns): Integer;
function CkDns_getTlsPref(objHandle: HCkDns): Integer;
procedure CkDns_putTlsPref(objHandle: HCkDns; newPropVal: Integer);
function CkDns_getVerboseLogging(objHandle: HCkDns): wordbool;
procedure CkDns_putVerboseLogging(objHandle: HCkDns; newPropVal: wordbool);
procedure CkDns_getVersion(objHandle: HCkDns; outPropVal: HCkString);
function CkDns__version(objHandle: HCkDns): PWideChar;
procedure CkDns_AddDefaultNameservers(objHandle: HCkDns);
procedure CkDns_AddNameserver(objHandle: HCkDns; ipAddr: PWideChar; supportsTls: wordbool);
function CkDns_GetNameserver(objHandle: HCkDns; index: Integer; outStr: HCkString): wordbool;
function CkDns__getNameserver(objHandle: HCkDns; index: Integer): PWideChar;
function CkDns_Query(objHandle: HCkDns; recordType: PWideChar; domain: PWideChar; answer: HCkJsonObject): wordbool;
function CkDns_QueryAsync(objHandle: HCkDns; recordType: PWideChar; domain: PWideChar; answer: HCkJsonObject): HCkTask;
procedure CkDns_RemoveAllNameservers(objHandle: HCkDns);
procedure CkDns_RemoveNameserver(objHandle: HCkDns; ipAddr: PWideChar);
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkDns_Create = function : HCkDns; stdcall;
  TCkDns_Dispose = procedure (handle: HCkDns); stdcall;
  TCkDns_SetAbortCheck = procedure (objHandle: HCkDns; fn: TDnsAbortCheck); stdcall;
  TCkDns_SetProgressInfo = procedure (objHandle: HCkDns; fn: TDnsProgressInfo); stdcall;
  TCkDns_SetPercentDone = procedure (objHandle: HCkDns; fn: TDnsPercentDone); stdcall;
  TCkDns_SetTaskCompleted = procedure (objHandle: HCkDns; fn: TDnsTaskCompleted); stdcall;
  TCkDns_getDebugLogFilePath = procedure (objHandle: HCkDns; outPropVal: HCkString); stdcall;
  TCkDns_putDebugLogFilePath = procedure (objHandle: HCkDns; newPropVal: PWideChar); stdcall;
  TCkDns__debugLogFilePath = function (objHandle: HCkDns): PWideChar; stdcall;
  TCkDns_getHeartbeatMs = function (objHandle: HCkDns): Integer; stdcall;
  TCkDns_putHeartbeatMs = procedure (objHandle: HCkDns; newPropVal: Integer); stdcall;
  TCkDns_getLastErrorHtml = procedure (objHandle: HCkDns; outPropVal: HCkString); stdcall;
  TCkDns__lastErrorHtml = function (objHandle: HCkDns): PWideChar; stdcall;
  TCkDns_getLastErrorText = procedure (objHandle: HCkDns; outPropVal: HCkString); stdcall;
  TCkDns__lastErrorText = function (objHandle: HCkDns): PWideChar; stdcall;
  TCkDns_getLastErrorXml = procedure (objHandle: HCkDns; outPropVal: HCkString); stdcall;
  TCkDns__lastErrorXml = function (objHandle: HCkDns): PWideChar; stdcall;
  TCkDns_getLastMethodSuccess = function (objHandle: HCkDns): wordbool; stdcall;
  TCkDns_putLastMethodSuccess = procedure (objHandle: HCkDns; newPropVal: wordbool); stdcall;
  TCkDns_getMaxWaitMs = function (objHandle: HCkDns): Integer; stdcall;
  TCkDns_putMaxWaitMs = procedure (objHandle: HCkDns; newPropVal: Integer); stdcall;
  TCkDns_getNumNameservers = function (objHandle: HCkDns): Integer; stdcall;
  TCkDns_getTlsPref = function (objHandle: HCkDns): Integer; stdcall;
  TCkDns_putTlsPref = procedure (objHandle: HCkDns; newPropVal: Integer); stdcall;
  TCkDns_getVerboseLogging = function (objHandle: HCkDns): wordbool; stdcall;
  TCkDns_putVerboseLogging = procedure (objHandle: HCkDns; newPropVal: wordbool); stdcall;
  TCkDns_getVersion = procedure (objHandle: HCkDns; outPropVal: HCkString); stdcall;
  TCkDns__version = function (objHandle: HCkDns): PWideChar; stdcall;
  TCkDns_AddDefaultNameservers = procedure (objHandle: HCkDns); stdcall;
  TCkDns_AddNameserver = procedure (objHandle: HCkDns; ipAddr: PWideChar; supportsTls: wordbool); stdcall;
  TCkDns_GetNameserver = function (objHandle: HCkDns; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkDns__getNameserver = function (objHandle: HCkDns; index: Integer): PWideChar; stdcall;
  TCkDns_Query = function (objHandle: HCkDns; recordType: PWideChar; domain: PWideChar; answer: HCkJsonObject): wordbool; stdcall;
  TCkDns_QueryAsync = function (objHandle: HCkDns; recordType: PWideChar; domain: PWideChar; answer: HCkJsonObject): HCkTask; stdcall;
  TCkDns_RemoveAllNameservers = procedure (objHandle: HCkDns); stdcall;
  TCkDns_RemoveNameserver = procedure (objHandle: HCkDns; ipAddr: PWideChar); stdcall;

var
  _fkt_ptr_arr:   array [0..35] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkDns_Create : HCkDns;
begin
  result := TCkDns_Create(_map(0, 'CkDns_Create'));
end;

procedure CkDns_Dispose (handle: HCkDns);
begin
  TCkDns_Dispose(_map(1, 'CkDns_Dispose'))
    (handle);
end;


procedure CkDns_SetAbortCheck (objHandle: HCkDns; fn: TDnsAbortCheck);
begin
    TCkDns_SetAbortCheck(_map(2, 'CkDns_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkDns_SetProgressInfo (objHandle: HCkDns; fn: TDnsProgressInfo);
begin
    TCkDns_SetProgressInfo(_map(3, 'CkDns_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkDns_SetPercentDone (objHandle: HCkDns; fn: TDnsPercentDone);
begin
    TCkDns_SetPercentDone(_map(4, 'CkDns_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkDns_SetTaskCompleted (objHandle: HCkDns; fn: TDnsTaskCompleted);
begin
    TCkDns_SetTaskCompleted(_map(5, 'CkDns_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkDns_getDebugLogFilePath (objHandle: HCkDns; outPropVal: HCkString);
begin
  TCkDns_getDebugLogFilePath(_map(6, 'CkDns_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkDns_putDebugLogFilePath (objHandle: HCkDns; newPropVal: PWideChar);
begin
  TCkDns_putDebugLogFilePath(_map(7, 'CkDns_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkDns__debugLogFilePath (objHandle: HCkDns): PWideChar;
begin
  result := TCkDns__debugLogFilePath(_map(8, 'CkDns__debugLogFilePath'))
    (objHandle);
end;

function CkDns_getHeartbeatMs (objHandle: HCkDns): Integer;
begin
    result := TCkDns_getHeartbeatMs(_map(9, 'CkDns_getHeartbeatMs'))
    (objHandle);
end;

procedure CkDns_putHeartbeatMs (objHandle: HCkDns; newPropVal: Integer);
begin
  TCkDns_putHeartbeatMs(_map(10, 'CkDns_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkDns_getLastErrorHtml (objHandle: HCkDns; outPropVal: HCkString);
begin
  TCkDns_getLastErrorHtml(_map(11, 'CkDns_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkDns__lastErrorHtml (objHandle: HCkDns): PWideChar;
begin
  result := TCkDns__lastErrorHtml(_map(12, 'CkDns__lastErrorHtml'))
    (objHandle);
end;

procedure CkDns_getLastErrorText (objHandle: HCkDns; outPropVal: HCkString);
begin
  TCkDns_getLastErrorText(_map(13, 'CkDns_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkDns__lastErrorText (objHandle: HCkDns): PWideChar;
begin
  result := TCkDns__lastErrorText(_map(14, 'CkDns__lastErrorText'))
    (objHandle);
end;

procedure CkDns_getLastErrorXml (objHandle: HCkDns; outPropVal: HCkString);
begin
  TCkDns_getLastErrorXml(_map(15, 'CkDns_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkDns__lastErrorXml (objHandle: HCkDns): PWideChar;
begin
  result := TCkDns__lastErrorXml(_map(16, 'CkDns__lastErrorXml'))
    (objHandle);
end;

function CkDns_getLastMethodSuccess (objHandle: HCkDns): wordbool;
begin
    result := TCkDns_getLastMethodSuccess(_map(17, 'CkDns_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkDns_putLastMethodSuccess (objHandle: HCkDns; newPropVal: wordbool);
begin
  TCkDns_putLastMethodSuccess(_map(18, 'CkDns_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkDns_getMaxWaitMs (objHandle: HCkDns): Integer;
begin
    result := TCkDns_getMaxWaitMs(_map(19, 'CkDns_getMaxWaitMs'))
    (objHandle);
end;

procedure CkDns_putMaxWaitMs (objHandle: HCkDns; newPropVal: Integer);
begin
  TCkDns_putMaxWaitMs(_map(20, 'CkDns_putMaxWaitMs'))
    (objHandle, newPropVal);
end;

function CkDns_getNumNameservers (objHandle: HCkDns): Integer;
begin
    result := TCkDns_getNumNameservers(_map(21, 'CkDns_getNumNameservers'))
    (objHandle);
end;

function CkDns_getTlsPref (objHandle: HCkDns): Integer;
begin
    result := TCkDns_getTlsPref(_map(22, 'CkDns_getTlsPref'))
    (objHandle);
end;

procedure CkDns_putTlsPref (objHandle: HCkDns; newPropVal: Integer);
begin
  TCkDns_putTlsPref(_map(23, 'CkDns_putTlsPref'))
    (objHandle, newPropVal);
end;

function CkDns_getVerboseLogging (objHandle: HCkDns): wordbool;
begin
    result := TCkDns_getVerboseLogging(_map(24, 'CkDns_getVerboseLogging'))
    (objHandle);
end;

procedure CkDns_putVerboseLogging (objHandle: HCkDns; newPropVal: wordbool);
begin
  TCkDns_putVerboseLogging(_map(25, 'CkDns_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkDns_getVersion (objHandle: HCkDns; outPropVal: HCkString);
begin
  TCkDns_getVersion(_map(26, 'CkDns_getVersion'))
    (objHandle, outPropVal);
end;

function CkDns__version (objHandle: HCkDns): PWideChar;
begin
  result := TCkDns__version(_map(27, 'CkDns__version'))
    (objHandle);
end;

procedure CkDns_AddDefaultNameservers (objHandle: HCkDns);
begin
  TCkDns_AddDefaultNameservers(_map(28, 'CkDns_AddDefaultNameservers'))
    (objHandle);
end;

procedure CkDns_AddNameserver (objHandle: HCkDns; ipAddr: PWideChar; supportsTls: wordbool);
begin
  TCkDns_AddNameserver(_map(29, 'CkDns_AddNameserver'))
    (objHandle, ipAddr, supportsTls);
end;

function CkDns_GetNameserver (objHandle: HCkDns; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkDns_GetNameserver(_map(30, 'CkDns_GetNameserver'))
    (objHandle, index, outStr);
end;

function CkDns__getNameserver (objHandle: HCkDns; index: Integer): PWideChar;
begin
  result := TCkDns__getNameserver(_map(31, 'CkDns__getNameserver'))
    (objHandle, index);
end;

function CkDns_Query (objHandle: HCkDns; recordType: PWideChar; domain: PWideChar; answer: HCkJsonObject): wordbool;
begin
  result := TCkDns_Query(_map(32, 'CkDns_Query'))
    (objHandle, recordType, domain, answer);
end;

function CkDns_QueryAsync (objHandle: HCkDns; recordType: PWideChar; domain: PWideChar; answer: HCkJsonObject): HCkTask;
begin
  result := TCkDns_QueryAsync(_map(33, 'CkDns_QueryAsync'))
    (objHandle, recordType, domain, answer);
end;

procedure CkDns_RemoveAllNameservers (objHandle: HCkDns);
begin
  TCkDns_RemoveAllNameservers(_map(34, 'CkDns_RemoveAllNameservers'))
    (objHandle);
end;

procedure CkDns_RemoveNameserver (objHandle: HCkDns; ipAddr: PWideChar);
begin
  TCkDns_RemoveNameserver(_map(35, 'CkDns_RemoveNameserver'))
    (objHandle, ipAddr);
end;

end.
