unit DtObj;

interface

type

HCkDtObj = Pointer;
HCkString = Pointer;


function CkDtObj_Create: HCkDtObj;  stdcall;
procedure CkDtObj_Dispose(handle: HCkDtObj); stdcall;
function CkDtObj_getDay(objHandle: HCkDtObj): Integer;
procedure CkDtObj_putDay(objHandle: HCkDtObj; newPropVal: Integer);
procedure CkDtObj_getDebugLogFilePath(objHandle: HCkDtObj; outPropVal: HCkString);
procedure CkDtObj_putDebugLogFilePath(objHandle: HCkDtObj; newPropVal: PWideChar);
function CkDtObj__debugLogFilePath(objHandle: HCkDtObj): PWideChar;
function CkDtObj_getHour(objHandle: HCkDtObj): Integer;
procedure CkDtObj_putHour(objHandle: HCkDtObj; newPropVal: Integer);
procedure CkDtObj_getLastErrorHtml(objHandle: HCkDtObj; outPropVal: HCkString);
function CkDtObj__lastErrorHtml(objHandle: HCkDtObj): PWideChar;
procedure CkDtObj_getLastErrorText(objHandle: HCkDtObj; outPropVal: HCkString);
function CkDtObj__lastErrorText(objHandle: HCkDtObj): PWideChar;
procedure CkDtObj_getLastErrorXml(objHandle: HCkDtObj; outPropVal: HCkString);
function CkDtObj__lastErrorXml(objHandle: HCkDtObj): PWideChar;
function CkDtObj_getLastMethodSuccess(objHandle: HCkDtObj): wordbool;
procedure CkDtObj_putLastMethodSuccess(objHandle: HCkDtObj; newPropVal: wordbool);
function CkDtObj_getMinute(objHandle: HCkDtObj): Integer;
procedure CkDtObj_putMinute(objHandle: HCkDtObj; newPropVal: Integer);
function CkDtObj_getMonth(objHandle: HCkDtObj): Integer;
procedure CkDtObj_putMonth(objHandle: HCkDtObj; newPropVal: Integer);
function CkDtObj_getSecond(objHandle: HCkDtObj): Integer;
procedure CkDtObj_putSecond(objHandle: HCkDtObj; newPropVal: Integer);
function CkDtObj_getStructTmMonth(objHandle: HCkDtObj): Integer;
procedure CkDtObj_putStructTmMonth(objHandle: HCkDtObj; newPropVal: Integer);
function CkDtObj_getStructTmYear(objHandle: HCkDtObj): Integer;
procedure CkDtObj_putStructTmYear(objHandle: HCkDtObj; newPropVal: Integer);
function CkDtObj_getUtc(objHandle: HCkDtObj): wordbool;
procedure CkDtObj_putUtc(objHandle: HCkDtObj; newPropVal: wordbool);
function CkDtObj_getVerboseLogging(objHandle: HCkDtObj): wordbool;
procedure CkDtObj_putVerboseLogging(objHandle: HCkDtObj; newPropVal: wordbool);
procedure CkDtObj_getVersion(objHandle: HCkDtObj; outPropVal: HCkString);
function CkDtObj__version(objHandle: HCkDtObj): PWideChar;
function CkDtObj_getYear(objHandle: HCkDtObj): Integer;
procedure CkDtObj_putYear(objHandle: HCkDtObj; newPropVal: Integer);
procedure CkDtObj_DeSerialize(objHandle: HCkDtObj; serializedDtObj: PWideChar);
function CkDtObj_Serialize(objHandle: HCkDtObj; outStr: HCkString): wordbool;
function CkDtObj__serialize(objHandle: HCkDtObj): PWideChar;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkDtObj_Create = function : HCkDtObj; stdcall;
  TCkDtObj_Dispose = procedure (handle: HCkDtObj); stdcall;
  TCkDtObj_getDay = function (objHandle: HCkDtObj): Integer; stdcall;
  TCkDtObj_putDay = procedure (objHandle: HCkDtObj; newPropVal: Integer); stdcall;
  TCkDtObj_getDebugLogFilePath = procedure (objHandle: HCkDtObj; outPropVal: HCkString); stdcall;
  TCkDtObj_putDebugLogFilePath = procedure (objHandle: HCkDtObj; newPropVal: PWideChar); stdcall;
  TCkDtObj__debugLogFilePath = function (objHandle: HCkDtObj): PWideChar; stdcall;
  TCkDtObj_getHour = function (objHandle: HCkDtObj): Integer; stdcall;
  TCkDtObj_putHour = procedure (objHandle: HCkDtObj; newPropVal: Integer); stdcall;
  TCkDtObj_getLastErrorHtml = procedure (objHandle: HCkDtObj; outPropVal: HCkString); stdcall;
  TCkDtObj__lastErrorHtml = function (objHandle: HCkDtObj): PWideChar; stdcall;
  TCkDtObj_getLastErrorText = procedure (objHandle: HCkDtObj; outPropVal: HCkString); stdcall;
  TCkDtObj__lastErrorText = function (objHandle: HCkDtObj): PWideChar; stdcall;
  TCkDtObj_getLastErrorXml = procedure (objHandle: HCkDtObj; outPropVal: HCkString); stdcall;
  TCkDtObj__lastErrorXml = function (objHandle: HCkDtObj): PWideChar; stdcall;
  TCkDtObj_getLastMethodSuccess = function (objHandle: HCkDtObj): wordbool; stdcall;
  TCkDtObj_putLastMethodSuccess = procedure (objHandle: HCkDtObj; newPropVal: wordbool); stdcall;
  TCkDtObj_getMinute = function (objHandle: HCkDtObj): Integer; stdcall;
  TCkDtObj_putMinute = procedure (objHandle: HCkDtObj; newPropVal: Integer); stdcall;
  TCkDtObj_getMonth = function (objHandle: HCkDtObj): Integer; stdcall;
  TCkDtObj_putMonth = procedure (objHandle: HCkDtObj; newPropVal: Integer); stdcall;
  TCkDtObj_getSecond = function (objHandle: HCkDtObj): Integer; stdcall;
  TCkDtObj_putSecond = procedure (objHandle: HCkDtObj; newPropVal: Integer); stdcall;
  TCkDtObj_getStructTmMonth = function (objHandle: HCkDtObj): Integer; stdcall;
  TCkDtObj_putStructTmMonth = procedure (objHandle: HCkDtObj; newPropVal: Integer); stdcall;
  TCkDtObj_getStructTmYear = function (objHandle: HCkDtObj): Integer; stdcall;
  TCkDtObj_putStructTmYear = procedure (objHandle: HCkDtObj; newPropVal: Integer); stdcall;
  TCkDtObj_getUtc = function (objHandle: HCkDtObj): wordbool; stdcall;
  TCkDtObj_putUtc = procedure (objHandle: HCkDtObj; newPropVal: wordbool); stdcall;
  TCkDtObj_getVerboseLogging = function (objHandle: HCkDtObj): wordbool; stdcall;
  TCkDtObj_putVerboseLogging = procedure (objHandle: HCkDtObj; newPropVal: wordbool); stdcall;
  TCkDtObj_getVersion = procedure (objHandle: HCkDtObj; outPropVal: HCkString); stdcall;
  TCkDtObj__version = function (objHandle: HCkDtObj): PWideChar; stdcall;
  TCkDtObj_getYear = function (objHandle: HCkDtObj): Integer; stdcall;
  TCkDtObj_putYear = procedure (objHandle: HCkDtObj; newPropVal: Integer); stdcall;
  TCkDtObj_DeSerialize = procedure (objHandle: HCkDtObj; serializedDtObj: PWideChar); stdcall;
  TCkDtObj_Serialize = function (objHandle: HCkDtObj; outStr: HCkString): wordbool; stdcall;
  TCkDtObj__serialize = function (objHandle: HCkDtObj): PWideChar; stdcall;

var
  _fkt_ptr_arr:   array [0..37] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkDtObj_Create : HCkDtObj;
begin
  result := TCkDtObj_Create(_map(0, 'CkDtObj_Create'));
end;

procedure CkDtObj_Dispose (handle: HCkDtObj);
begin
  TCkDtObj_Dispose(_map(1, 'CkDtObj_Dispose'))
    (handle);
end;


function CkDtObj_getDay (objHandle: HCkDtObj): Integer;
begin
    result := TCkDtObj_getDay(_map(2, 'CkDtObj_getDay'))
    (objHandle);
end;

procedure CkDtObj_putDay (objHandle: HCkDtObj; newPropVal: Integer);
begin
  TCkDtObj_putDay(_map(3, 'CkDtObj_putDay'))
    (objHandle, newPropVal);
end;

procedure CkDtObj_getDebugLogFilePath (objHandle: HCkDtObj; outPropVal: HCkString);
begin
  TCkDtObj_getDebugLogFilePath(_map(4, 'CkDtObj_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkDtObj_putDebugLogFilePath (objHandle: HCkDtObj; newPropVal: PWideChar);
begin
  TCkDtObj_putDebugLogFilePath(_map(5, 'CkDtObj_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkDtObj__debugLogFilePath (objHandle: HCkDtObj): PWideChar;
begin
  result := TCkDtObj__debugLogFilePath(_map(6, 'CkDtObj__debugLogFilePath'))
    (objHandle);
end;

function CkDtObj_getHour (objHandle: HCkDtObj): Integer;
begin
    result := TCkDtObj_getHour(_map(7, 'CkDtObj_getHour'))
    (objHandle);
end;

procedure CkDtObj_putHour (objHandle: HCkDtObj; newPropVal: Integer);
begin
  TCkDtObj_putHour(_map(8, 'CkDtObj_putHour'))
    (objHandle, newPropVal);
end;

procedure CkDtObj_getLastErrorHtml (objHandle: HCkDtObj; outPropVal: HCkString);
begin
  TCkDtObj_getLastErrorHtml(_map(9, 'CkDtObj_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkDtObj__lastErrorHtml (objHandle: HCkDtObj): PWideChar;
begin
  result := TCkDtObj__lastErrorHtml(_map(10, 'CkDtObj__lastErrorHtml'))
    (objHandle);
end;

procedure CkDtObj_getLastErrorText (objHandle: HCkDtObj; outPropVal: HCkString);
begin
  TCkDtObj_getLastErrorText(_map(11, 'CkDtObj_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkDtObj__lastErrorText (objHandle: HCkDtObj): PWideChar;
begin
  result := TCkDtObj__lastErrorText(_map(12, 'CkDtObj__lastErrorText'))
    (objHandle);
end;

procedure CkDtObj_getLastErrorXml (objHandle: HCkDtObj; outPropVal: HCkString);
begin
  TCkDtObj_getLastErrorXml(_map(13, 'CkDtObj_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkDtObj__lastErrorXml (objHandle: HCkDtObj): PWideChar;
begin
  result := TCkDtObj__lastErrorXml(_map(14, 'CkDtObj__lastErrorXml'))
    (objHandle);
end;

function CkDtObj_getLastMethodSuccess (objHandle: HCkDtObj): wordbool;
begin
    result := TCkDtObj_getLastMethodSuccess(_map(15, 'CkDtObj_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkDtObj_putLastMethodSuccess (objHandle: HCkDtObj; newPropVal: wordbool);
begin
  TCkDtObj_putLastMethodSuccess(_map(16, 'CkDtObj_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkDtObj_getMinute (objHandle: HCkDtObj): Integer;
begin
    result := TCkDtObj_getMinute(_map(17, 'CkDtObj_getMinute'))
    (objHandle);
end;

procedure CkDtObj_putMinute (objHandle: HCkDtObj; newPropVal: Integer);
begin
  TCkDtObj_putMinute(_map(18, 'CkDtObj_putMinute'))
    (objHandle, newPropVal);
end;

function CkDtObj_getMonth (objHandle: HCkDtObj): Integer;
begin
    result := TCkDtObj_getMonth(_map(19, 'CkDtObj_getMonth'))
    (objHandle);
end;

procedure CkDtObj_putMonth (objHandle: HCkDtObj; newPropVal: Integer);
begin
  TCkDtObj_putMonth(_map(20, 'CkDtObj_putMonth'))
    (objHandle, newPropVal);
end;

function CkDtObj_getSecond (objHandle: HCkDtObj): Integer;
begin
    result := TCkDtObj_getSecond(_map(21, 'CkDtObj_getSecond'))
    (objHandle);
end;

procedure CkDtObj_putSecond (objHandle: HCkDtObj; newPropVal: Integer);
begin
  TCkDtObj_putSecond(_map(22, 'CkDtObj_putSecond'))
    (objHandle, newPropVal);
end;

function CkDtObj_getStructTmMonth (objHandle: HCkDtObj): Integer;
begin
    result := TCkDtObj_getStructTmMonth(_map(23, 'CkDtObj_getStructTmMonth'))
    (objHandle);
end;

procedure CkDtObj_putStructTmMonth (objHandle: HCkDtObj; newPropVal: Integer);
begin
  TCkDtObj_putStructTmMonth(_map(24, 'CkDtObj_putStructTmMonth'))
    (objHandle, newPropVal);
end;

function CkDtObj_getStructTmYear (objHandle: HCkDtObj): Integer;
begin
    result := TCkDtObj_getStructTmYear(_map(25, 'CkDtObj_getStructTmYear'))
    (objHandle);
end;

procedure CkDtObj_putStructTmYear (objHandle: HCkDtObj; newPropVal: Integer);
begin
  TCkDtObj_putStructTmYear(_map(26, 'CkDtObj_putStructTmYear'))
    (objHandle, newPropVal);
end;

function CkDtObj_getUtc (objHandle: HCkDtObj): wordbool;
begin
    result := TCkDtObj_getUtc(_map(27, 'CkDtObj_getUtc'))
    (objHandle);
end;

procedure CkDtObj_putUtc (objHandle: HCkDtObj; newPropVal: wordbool);
begin
  TCkDtObj_putUtc(_map(28, 'CkDtObj_putUtc'))
    (objHandle, newPropVal);
end;

function CkDtObj_getVerboseLogging (objHandle: HCkDtObj): wordbool;
begin
    result := TCkDtObj_getVerboseLogging(_map(29, 'CkDtObj_getVerboseLogging'))
    (objHandle);
end;

procedure CkDtObj_putVerboseLogging (objHandle: HCkDtObj; newPropVal: wordbool);
begin
  TCkDtObj_putVerboseLogging(_map(30, 'CkDtObj_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkDtObj_getVersion (objHandle: HCkDtObj; outPropVal: HCkString);
begin
  TCkDtObj_getVersion(_map(31, 'CkDtObj_getVersion'))
    (objHandle, outPropVal);
end;

function CkDtObj__version (objHandle: HCkDtObj): PWideChar;
begin
  result := TCkDtObj__version(_map(32, 'CkDtObj__version'))
    (objHandle);
end;

function CkDtObj_getYear (objHandle: HCkDtObj): Integer;
begin
    result := TCkDtObj_getYear(_map(33, 'CkDtObj_getYear'))
    (objHandle);
end;

procedure CkDtObj_putYear (objHandle: HCkDtObj; newPropVal: Integer);
begin
  TCkDtObj_putYear(_map(34, 'CkDtObj_putYear'))
    (objHandle, newPropVal);
end;

procedure CkDtObj_DeSerialize (objHandle: HCkDtObj; serializedDtObj: PWideChar);
begin
  TCkDtObj_DeSerialize(_map(35, 'CkDtObj_DeSerialize'))
    (objHandle, serializedDtObj);
end;

function CkDtObj_Serialize (objHandle: HCkDtObj; outStr: HCkString): wordbool;
begin
  result := TCkDtObj_Serialize(_map(36, 'CkDtObj_Serialize'))
    (objHandle, outStr);
end;

function CkDtObj__serialize (objHandle: HCkDtObj): PWideChar;
begin
  result := TCkDtObj__serialize(_map(37, 'CkDtObj__serialize'))
    (objHandle);
end;

end.
