unit Ecc;

interface

type

HCkPublicKey = Pointer;
HCkBinData = Pointer;
HCkEcc = Pointer;
HCkPrivateKey = Pointer;
HCkPrng = Pointer;
HCkString = Pointer;
HCkCert = Pointer;


function CkEcc_Create: HCkEcc;  stdcall;
procedure CkEcc_Dispose(handle: HCkEcc); stdcall;
function CkEcc_getAsnFormat(objHandle: HCkEcc): wordbool;
procedure CkEcc_putAsnFormat(objHandle: HCkEcc; newPropVal: wordbool);
procedure CkEcc_getDebugLogFilePath(objHandle: HCkEcc; outPropVal: HCkString);
procedure CkEcc_putDebugLogFilePath(objHandle: HCkEcc; newPropVal: PWideChar);
function CkEcc__debugLogFilePath(objHandle: HCkEcc): PWideChar;
procedure CkEcc_getLastErrorHtml(objHandle: HCkEcc; outPropVal: HCkString);
function CkEcc__lastErrorHtml(objHandle: HCkEcc): PWideChar;
procedure CkEcc_getLastErrorText(objHandle: HCkEcc; outPropVal: HCkString);
function CkEcc__lastErrorText(objHandle: HCkEcc): PWideChar;
procedure CkEcc_getLastErrorXml(objHandle: HCkEcc; outPropVal: HCkString);
function CkEcc__lastErrorXml(objHandle: HCkEcc): PWideChar;
function CkEcc_getLastMethodSuccess(objHandle: HCkEcc): wordbool;
procedure CkEcc_putLastMethodSuccess(objHandle: HCkEcc; newPropVal: wordbool);
function CkEcc_getVerboseLogging(objHandle: HCkEcc): wordbool;
procedure CkEcc_putVerboseLogging(objHandle: HCkEcc; newPropVal: wordbool);
procedure CkEcc_getVersion(objHandle: HCkEcc; outPropVal: HCkString);
function CkEcc__version(objHandle: HCkEcc): PWideChar;
function CkEcc_GenEccKey(objHandle: HCkEcc; curveName: PWideChar; prng: HCkPrng): HCkPrivateKey;
function CkEcc_GenEccKey2(objHandle: HCkEcc; curveName: PWideChar; encodedK: PWideChar; encoding: PWideChar): HCkPrivateKey;
function CkEcc_GenKey(objHandle: HCkEcc; curveName: PWideChar; prng: HCkPrng; privKey: HCkPrivateKey): wordbool;
function CkEcc_GenKey2(objHandle: HCkEcc; curveName: PWideChar; encodedK: PWideChar; encoding: PWideChar; privKey: HCkPrivateKey): wordbool;
function CkEcc_SharedSecretENC(objHandle: HCkEcc; privKey: HCkPrivateKey; pubKey: HCkPublicKey; encoding: PWideChar; outStr: HCkString): wordbool;
function CkEcc__sharedSecretENC(objHandle: HCkEcc; privKey: HCkPrivateKey; pubKey: HCkPublicKey; encoding: PWideChar): PWideChar;
function CkEcc_SignBd(objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; privKey: HCkPrivateKey; prng: HCkPrng; outStr: HCkString): wordbool;
function CkEcc__signBd(objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; privKey: HCkPrivateKey; prng: HCkPrng): PWideChar;
function CkEcc_SignBdUsingCert(objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; cert: HCkCert; outStr: HCkString): wordbool;
function CkEcc__signBdUsingCert(objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; cert: HCkCert): PWideChar;
function CkEcc_SignHashENC(objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; privkey: HCkPrivateKey; prng: HCkPrng; outStr: HCkString): wordbool;
function CkEcc__signHashENC(objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; privkey: HCkPrivateKey; prng: HCkPrng): PWideChar;
function CkEcc_SignHashUsingCert(objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; cert: HCkCert; outStr: HCkString): wordbool;
function CkEcc__signHashUsingCert(objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; cert: HCkCert): PWideChar;
function CkEcc_VerifyBd(objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encodedSig: PWideChar; encoding: PWideChar; pubkey: HCkPublicKey): Integer;
function CkEcc_VerifyHashENC(objHandle: HCkEcc; encodedHash: PWideChar; encodedSig: PWideChar; encoding: PWideChar; pubkey: HCkPublicKey): Integer;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkEcc_Create = function : HCkEcc; stdcall;
  TCkEcc_Dispose = procedure (handle: HCkEcc); stdcall;
  TCkEcc_getAsnFormat = function (objHandle: HCkEcc): wordbool; stdcall;
  TCkEcc_putAsnFormat = procedure (objHandle: HCkEcc; newPropVal: wordbool); stdcall;
  TCkEcc_getDebugLogFilePath = procedure (objHandle: HCkEcc; outPropVal: HCkString); stdcall;
  TCkEcc_putDebugLogFilePath = procedure (objHandle: HCkEcc; newPropVal: PWideChar); stdcall;
  TCkEcc__debugLogFilePath = function (objHandle: HCkEcc): PWideChar; stdcall;
  TCkEcc_getLastErrorHtml = procedure (objHandle: HCkEcc; outPropVal: HCkString); stdcall;
  TCkEcc__lastErrorHtml = function (objHandle: HCkEcc): PWideChar; stdcall;
  TCkEcc_getLastErrorText = procedure (objHandle: HCkEcc; outPropVal: HCkString); stdcall;
  TCkEcc__lastErrorText = function (objHandle: HCkEcc): PWideChar; stdcall;
  TCkEcc_getLastErrorXml = procedure (objHandle: HCkEcc; outPropVal: HCkString); stdcall;
  TCkEcc__lastErrorXml = function (objHandle: HCkEcc): PWideChar; stdcall;
  TCkEcc_getLastMethodSuccess = function (objHandle: HCkEcc): wordbool; stdcall;
  TCkEcc_putLastMethodSuccess = procedure (objHandle: HCkEcc; newPropVal: wordbool); stdcall;
  TCkEcc_getVerboseLogging = function (objHandle: HCkEcc): wordbool; stdcall;
  TCkEcc_putVerboseLogging = procedure (objHandle: HCkEcc; newPropVal: wordbool); stdcall;
  TCkEcc_getVersion = procedure (objHandle: HCkEcc; outPropVal: HCkString); stdcall;
  TCkEcc__version = function (objHandle: HCkEcc): PWideChar; stdcall;
  TCkEcc_GenEccKey = function (objHandle: HCkEcc; curveName: PWideChar; prng: HCkPrng): HCkPrivateKey; stdcall;
  TCkEcc_GenEccKey2 = function (objHandle: HCkEcc; curveName: PWideChar; encodedK: PWideChar; encoding: PWideChar): HCkPrivateKey; stdcall;
  TCkEcc_GenKey = function (objHandle: HCkEcc; curveName: PWideChar; prng: HCkPrng; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkEcc_GenKey2 = function (objHandle: HCkEcc; curveName: PWideChar; encodedK: PWideChar; encoding: PWideChar; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkEcc_SharedSecretENC = function (objHandle: HCkEcc; privKey: HCkPrivateKey; pubKey: HCkPublicKey; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkEcc__sharedSecretENC = function (objHandle: HCkEcc; privKey: HCkPrivateKey; pubKey: HCkPublicKey; encoding: PWideChar): PWideChar; stdcall;
  TCkEcc_SignBd = function (objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; privKey: HCkPrivateKey; prng: HCkPrng; outStr: HCkString): wordbool; stdcall;
  TCkEcc__signBd = function (objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; privKey: HCkPrivateKey; prng: HCkPrng): PWideChar; stdcall;
  TCkEcc_SignBdUsingCert = function (objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; cert: HCkCert; outStr: HCkString): wordbool; stdcall;
  TCkEcc__signBdUsingCert = function (objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; cert: HCkCert): PWideChar; stdcall;
  TCkEcc_SignHashENC = function (objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; privkey: HCkPrivateKey; prng: HCkPrng; outStr: HCkString): wordbool; stdcall;
  TCkEcc__signHashENC = function (objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; privkey: HCkPrivateKey; prng: HCkPrng): PWideChar; stdcall;
  TCkEcc_SignHashUsingCert = function (objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; cert: HCkCert; outStr: HCkString): wordbool; stdcall;
  TCkEcc__signHashUsingCert = function (objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; cert: HCkCert): PWideChar; stdcall;
  TCkEcc_VerifyBd = function (objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encodedSig: PWideChar; encoding: PWideChar; pubkey: HCkPublicKey): Integer; stdcall;
  TCkEcc_VerifyHashENC = function (objHandle: HCkEcc; encodedHash: PWideChar; encodedSig: PWideChar; encoding: PWideChar; pubkey: HCkPublicKey): Integer; stdcall;

var
  _fkt_ptr_arr:   array [0..34] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkEcc_Create : HCkEcc;
begin
  result := TCkEcc_Create(_map(0, 'CkEcc_Create'));
end;

procedure CkEcc_Dispose (handle: HCkEcc);
begin
  TCkEcc_Dispose(_map(1, 'CkEcc_Dispose'))
    (handle);
end;


function CkEcc_getAsnFormat (objHandle: HCkEcc): wordbool;
begin
    result := TCkEcc_getAsnFormat(_map(2, 'CkEcc_getAsnFormat'))
    (objHandle);
end;

procedure CkEcc_putAsnFormat (objHandle: HCkEcc; newPropVal: wordbool);
begin
  TCkEcc_putAsnFormat(_map(3, 'CkEcc_putAsnFormat'))
    (objHandle, newPropVal);
end;

procedure CkEcc_getDebugLogFilePath (objHandle: HCkEcc; outPropVal: HCkString);
begin
  TCkEcc_getDebugLogFilePath(_map(4, 'CkEcc_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkEcc_putDebugLogFilePath (objHandle: HCkEcc; newPropVal: PWideChar);
begin
  TCkEcc_putDebugLogFilePath(_map(5, 'CkEcc_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkEcc__debugLogFilePath (objHandle: HCkEcc): PWideChar;
begin
  result := TCkEcc__debugLogFilePath(_map(6, 'CkEcc__debugLogFilePath'))
    (objHandle);
end;

procedure CkEcc_getLastErrorHtml (objHandle: HCkEcc; outPropVal: HCkString);
begin
  TCkEcc_getLastErrorHtml(_map(7, 'CkEcc_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkEcc__lastErrorHtml (objHandle: HCkEcc): PWideChar;
begin
  result := TCkEcc__lastErrorHtml(_map(8, 'CkEcc__lastErrorHtml'))
    (objHandle);
end;

procedure CkEcc_getLastErrorText (objHandle: HCkEcc; outPropVal: HCkString);
begin
  TCkEcc_getLastErrorText(_map(9, 'CkEcc_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkEcc__lastErrorText (objHandle: HCkEcc): PWideChar;
begin
  result := TCkEcc__lastErrorText(_map(10, 'CkEcc__lastErrorText'))
    (objHandle);
end;

procedure CkEcc_getLastErrorXml (objHandle: HCkEcc; outPropVal: HCkString);
begin
  TCkEcc_getLastErrorXml(_map(11, 'CkEcc_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkEcc__lastErrorXml (objHandle: HCkEcc): PWideChar;
begin
  result := TCkEcc__lastErrorXml(_map(12, 'CkEcc__lastErrorXml'))
    (objHandle);
end;

function CkEcc_getLastMethodSuccess (objHandle: HCkEcc): wordbool;
begin
    result := TCkEcc_getLastMethodSuccess(_map(13, 'CkEcc_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkEcc_putLastMethodSuccess (objHandle: HCkEcc; newPropVal: wordbool);
begin
  TCkEcc_putLastMethodSuccess(_map(14, 'CkEcc_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkEcc_getVerboseLogging (objHandle: HCkEcc): wordbool;
begin
    result := TCkEcc_getVerboseLogging(_map(15, 'CkEcc_getVerboseLogging'))
    (objHandle);
end;

procedure CkEcc_putVerboseLogging (objHandle: HCkEcc; newPropVal: wordbool);
begin
  TCkEcc_putVerboseLogging(_map(16, 'CkEcc_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkEcc_getVersion (objHandle: HCkEcc; outPropVal: HCkString);
begin
  TCkEcc_getVersion(_map(17, 'CkEcc_getVersion'))
    (objHandle, outPropVal);
end;

function CkEcc__version (objHandle: HCkEcc): PWideChar;
begin
  result := TCkEcc__version(_map(18, 'CkEcc__version'))
    (objHandle);
end;

function CkEcc_GenEccKey (objHandle: HCkEcc; curveName: PWideChar; prng: HCkPrng): HCkPrivateKey;
begin
  result := TCkEcc_GenEccKey(_map(19, 'CkEcc_GenEccKey'))
    (objHandle, curveName, prng);
end;

function CkEcc_GenEccKey2 (objHandle: HCkEcc; curveName: PWideChar; encodedK: PWideChar; encoding: PWideChar): HCkPrivateKey;
begin
  result := TCkEcc_GenEccKey2(_map(20, 'CkEcc_GenEccKey2'))
    (objHandle, curveName, encodedK, encoding);
end;

function CkEcc_GenKey (objHandle: HCkEcc; curveName: PWideChar; prng: HCkPrng; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkEcc_GenKey(_map(21, 'CkEcc_GenKey'))
    (objHandle, curveName, prng, privKey);
end;

function CkEcc_GenKey2 (objHandle: HCkEcc; curveName: PWideChar; encodedK: PWideChar; encoding: PWideChar; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkEcc_GenKey2(_map(22, 'CkEcc_GenKey2'))
    (objHandle, curveName, encodedK, encoding, privKey);
end;

function CkEcc_SharedSecretENC (objHandle: HCkEcc; privKey: HCkPrivateKey; pubKey: HCkPublicKey; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkEcc_SharedSecretENC(_map(23, 'CkEcc_SharedSecretENC'))
    (objHandle, privKey, pubKey, encoding, outStr);
end;

function CkEcc__sharedSecretENC (objHandle: HCkEcc; privKey: HCkPrivateKey; pubKey: HCkPublicKey; encoding: PWideChar): PWideChar;
begin
  result := TCkEcc__sharedSecretENC(_map(24, 'CkEcc__sharedSecretENC'))
    (objHandle, privKey, pubKey, encoding);
end;

function CkEcc_SignBd (objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; privKey: HCkPrivateKey; prng: HCkPrng; outStr: HCkString): wordbool;
begin
  result := TCkEcc_SignBd(_map(25, 'CkEcc_SignBd'))
    (objHandle, bdData, hashAlg, encoding, privKey, prng, outStr);
end;

function CkEcc__signBd (objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; privKey: HCkPrivateKey; prng: HCkPrng): PWideChar;
begin
  result := TCkEcc__signBd(_map(26, 'CkEcc__signBd'))
    (objHandle, bdData, hashAlg, encoding, privKey, prng);
end;

function CkEcc_SignBdUsingCert (objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; cert: HCkCert; outStr: HCkString): wordbool;
begin
  result := TCkEcc_SignBdUsingCert(_map(27, 'CkEcc_SignBdUsingCert'))
    (objHandle, bdData, hashAlg, encoding, cert, outStr);
end;

function CkEcc__signBdUsingCert (objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encoding: PWideChar; cert: HCkCert): PWideChar;
begin
  result := TCkEcc__signBdUsingCert(_map(28, 'CkEcc__signBdUsingCert'))
    (objHandle, bdData, hashAlg, encoding, cert);
end;

function CkEcc_SignHashENC (objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; privkey: HCkPrivateKey; prng: HCkPrng; outStr: HCkString): wordbool;
begin
  result := TCkEcc_SignHashENC(_map(29, 'CkEcc_SignHashENC'))
    (objHandle, encodedHash, encoding, privkey, prng, outStr);
end;

function CkEcc__signHashENC (objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; privkey: HCkPrivateKey; prng: HCkPrng): PWideChar;
begin
  result := TCkEcc__signHashENC(_map(30, 'CkEcc__signHashENC'))
    (objHandle, encodedHash, encoding, privkey, prng);
end;

function CkEcc_SignHashUsingCert (objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; cert: HCkCert; outStr: HCkString): wordbool;
begin
  result := TCkEcc_SignHashUsingCert(_map(31, 'CkEcc_SignHashUsingCert'))
    (objHandle, encodedHash, encoding, cert, outStr);
end;

function CkEcc__signHashUsingCert (objHandle: HCkEcc; encodedHash: PWideChar; encoding: PWideChar; cert: HCkCert): PWideChar;
begin
  result := TCkEcc__signHashUsingCert(_map(32, 'CkEcc__signHashUsingCert'))
    (objHandle, encodedHash, encoding, cert);
end;

function CkEcc_VerifyBd (objHandle: HCkEcc; bdData: HCkBinData; hashAlg: PWideChar; encodedSig: PWideChar; encoding: PWideChar; pubkey: HCkPublicKey): Integer;
begin
  result := TCkEcc_VerifyBd(_map(33, 'CkEcc_VerifyBd'))
    (objHandle, bdData, hashAlg, encodedSig, encoding, pubkey);
end;

function CkEcc_VerifyHashENC (objHandle: HCkEcc; encodedHash: PWideChar; encodedSig: PWideChar; encoding: PWideChar; pubkey: HCkPublicKey): Integer;
begin
  result := TCkEcc_VerifyHashENC(_map(34, 'CkEcc_VerifyHashENC'))
    (objHandle, encodedHash, encodedSig, encoding, pubkey);
end;

end.
