unit FileAccess;

interface

type

HCkBinData = Pointer;
HCkDateTime = Pointer;
HCkByteData = Pointer;
HCkFileAccess = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;


function CkFileAccess_Create: HCkFileAccess;  stdcall;
procedure CkFileAccess_Dispose(handle: HCkFileAccess); stdcall;
procedure CkFileAccess_getCurrentDir(objHandle: HCkFileAccess; outPropVal: HCkString);
function CkFileAccess__currentDir(objHandle: HCkFileAccess): PWideChar;
procedure CkFileAccess_getDebugLogFilePath(objHandle: HCkFileAccess; outPropVal: HCkString);
procedure CkFileAccess_putDebugLogFilePath(objHandle: HCkFileAccess; newPropVal: PWideChar);
function CkFileAccess__debugLogFilePath(objHandle: HCkFileAccess): PWideChar;
function CkFileAccess_getEndOfFile(objHandle: HCkFileAccess): wordbool;
function CkFileAccess_getFileOpenError(objHandle: HCkFileAccess): Integer;
procedure CkFileAccess_getFileOpenErrorMsg(objHandle: HCkFileAccess; outPropVal: HCkString);
function CkFileAccess__fileOpenErrorMsg(objHandle: HCkFileAccess): PWideChar;
procedure CkFileAccess_getLastErrorHtml(objHandle: HCkFileAccess; outPropVal: HCkString);
function CkFileAccess__lastErrorHtml(objHandle: HCkFileAccess): PWideChar;
procedure CkFileAccess_getLastErrorText(objHandle: HCkFileAccess; outPropVal: HCkString);
function CkFileAccess__lastErrorText(objHandle: HCkFileAccess): PWideChar;
procedure CkFileAccess_getLastErrorXml(objHandle: HCkFileAccess; outPropVal: HCkString);
function CkFileAccess__lastErrorXml(objHandle: HCkFileAccess): PWideChar;
function CkFileAccess_getLastMethodSuccess(objHandle: HCkFileAccess): wordbool;
procedure CkFileAccess_putLastMethodSuccess(objHandle: HCkFileAccess; newPropVal: wordbool);
function CkFileAccess_getLockFileOnOpen(objHandle: HCkFileAccess): wordbool;
procedure CkFileAccess_putLockFileOnOpen(objHandle: HCkFileAccess; newPropVal: wordbool);
function CkFileAccess_getVerboseLogging(objHandle: HCkFileAccess): wordbool;
procedure CkFileAccess_putVerboseLogging(objHandle: HCkFileAccess; newPropVal: wordbool);
procedure CkFileAccess_getVersion(objHandle: HCkFileAccess; outPropVal: HCkString);
function CkFileAccess__version(objHandle: HCkFileAccess): PWideChar;
function CkFileAccess_AppendAnsi(objHandle: HCkFileAccess; text: PWideChar): wordbool;
function CkFileAccess_AppendBd(objHandle: HCkFileAccess; bd: HCkBinData): wordbool;
function CkFileAccess_AppendSb(objHandle: HCkFileAccess; sb: HCkStringBuilder; charset: PWideChar): wordbool;
function CkFileAccess_AppendText(objHandle: HCkFileAccess; str: PWideChar; charset: PWideChar): wordbool;
function CkFileAccess_AppendUnicodeBOM(objHandle: HCkFileAccess): wordbool;
function CkFileAccess_AppendUtf8BOM(objHandle: HCkFileAccess): wordbool;
function CkFileAccess_DirAutoCreate(objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
function CkFileAccess_DirCreate(objHandle: HCkFileAccess; dirPath: PWideChar): wordbool;
function CkFileAccess_DirDelete(objHandle: HCkFileAccess; dirPath: PWideChar): wordbool;
function CkFileAccess_DirEnsureExists(objHandle: HCkFileAccess; dirPath: PWideChar): wordbool;
function CkFileAccess_DirExists(objHandle: HCkFileAccess; dirPath: PWideChar): wordbool;
procedure CkFileAccess_FileClose(objHandle: HCkFileAccess);
function CkFileAccess_FileContentsEqual(objHandle: HCkFileAccess; filePath1: PWideChar; filePath2: PWideChar): wordbool;
function CkFileAccess_FileCopy(objHandle: HCkFileAccess; existingFilepath: PWideChar; newFilepath: PWideChar; failIfExists: wordbool): wordbool;
function CkFileAccess_FileDelete(objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
function CkFileAccess_FileExists(objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
function CkFileAccess_FileExists3(objHandle: HCkFileAccess; path: PWideChar): Integer;
function CkFileAccess_FileOpen(objHandle: HCkFileAccess; filePath: PWideChar; accessMode: LongWord; shareMode: LongWord; createDisposition: LongWord; attributes: LongWord): wordbool;
function CkFileAccess_FileRead(objHandle: HCkFileAccess; maxNumBytes: Integer; outData: HCkByteData): wordbool;
function CkFileAccess_FileReadBd(objHandle: HCkFileAccess; maxNumBytes: Integer; binData: HCkBinData): wordbool;
function CkFileAccess_FileRename(objHandle: HCkFileAccess; existingFilepath: PWideChar; newFilepath: PWideChar): wordbool;
function CkFileAccess_FileSeek(objHandle: HCkFileAccess; offset: Integer; origin: Integer): wordbool;
function CkFileAccess_FileSize(objHandle: HCkFileAccess; filePath: PWideChar): Integer;
function CkFileAccess_FileSize64(objHandle: HCkFileAccess; filePath: PWideChar): Int64;
function CkFileAccess_FileSizeStr(objHandle: HCkFileAccess; filePath: PWideChar; outStr: HCkString): wordbool;
function CkFileAccess__fileSizeStr(objHandle: HCkFileAccess; filePath: PWideChar): PWideChar;
function CkFileAccess_FileType(objHandle: HCkFileAccess; path: PWideChar): Integer;
function CkFileAccess_FileWrite(objHandle: HCkFileAccess; data: HCkByteData): wordbool;
function CkFileAccess_FileWriteBd(objHandle: HCkFileAccess; binData: HCkBinData; offset: Integer; numBytes: Integer): wordbool;
function CkFileAccess_GenBlockId(objHandle: HCkFileAccess; index: Integer; length: Integer; encoding: PWideChar; outStr: HCkString): wordbool;
function CkFileAccess__genBlockId(objHandle: HCkFileAccess; index: Integer; length: Integer; encoding: PWideChar): PWideChar;
function CkFileAccess_GetDirectoryName(objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool;
function CkFileAccess__getDirectoryName(objHandle: HCkFileAccess; path: PWideChar): PWideChar;
function CkFileAccess_GetExtension(objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool;
function CkFileAccess__getExtension(objHandle: HCkFileAccess; path: PWideChar): PWideChar;
function CkFileAccess_GetFileName(objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool;
function CkFileAccess__getFileName(objHandle: HCkFileAccess; path: PWideChar): PWideChar;
function CkFileAccess_GetFileNameWithoutExtension(objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool;
function CkFileAccess__getFileNameWithoutExtension(objHandle: HCkFileAccess; path: PWideChar): PWideChar;
function CkFileAccess_GetFileTime(objHandle: HCkFileAccess; path: PWideChar; which: Integer): HCkDateTime;
function CkFileAccess_GetFileTimeStr(objHandle: HCkFileAccess; path: PWideChar; which: Integer; outStr: HCkString): wordbool;
function CkFileAccess__getFileTimeStr(objHandle: HCkFileAccess; path: PWideChar; which: Integer): PWideChar;
function CkFileAccess_GetLastModified(objHandle: HCkFileAccess; path: PWideChar): HCkDateTime;
function CkFileAccess_GetNumBlocks(objHandle: HCkFileAccess; blockSize: Integer): Integer;
function CkFileAccess_GetTempFilename(objHandle: HCkFileAccess; dirPath: PWideChar; prefix: PWideChar; outStr: HCkString): wordbool;
function CkFileAccess__getTempFilename(objHandle: HCkFileAccess; dirPath: PWideChar; prefix: PWideChar): PWideChar;
function CkFileAccess_OpenForAppend(objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
function CkFileAccess_OpenForRead(objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
function CkFileAccess_OpenForReadWrite(objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
function CkFileAccess_OpenForWrite(objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
function CkFileAccess_ReadBinaryToEncoded(objHandle: HCkFileAccess; filePath: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
function CkFileAccess__readBinaryToEncoded(objHandle: HCkFileAccess; filePath: PWideChar; encoding: PWideChar): PWideChar;
function CkFileAccess_ReadBlock(objHandle: HCkFileAccess; blockIndex: Integer; blockSize: Integer; outData: HCkByteData): wordbool;
function CkFileAccess_ReadBlockBd(objHandle: HCkFileAccess; blockIndex: Integer; blockSize: Integer; bd: HCkBinData): wordbool;
function CkFileAccess_ReadEntireFile(objHandle: HCkFileAccess; filePath: PWideChar; outData: HCkByteData): wordbool;
function CkFileAccess_ReadEntireTextFile(objHandle: HCkFileAccess; filePath: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkFileAccess__readEntireTextFile(objHandle: HCkFileAccess; filePath: PWideChar; charset: PWideChar): PWideChar;
function CkFileAccess_ReadNextFragment(objHandle: HCkFileAccess; startAtBeginning: wordbool; beginMarker: PWideChar; endMarker: PWideChar; charset: PWideChar; sb: HCkStringBuilder): Integer;
function CkFileAccess_ReassembleFile(objHandle: HCkFileAccess; partsDirPath: PWideChar; partPrefix: PWideChar; partExtension: PWideChar; reassembledFilename: PWideChar): wordbool;
function CkFileAccess_ReplaceStrings(objHandle: HCkFileAccess; filePath: PWideChar; charset: PWideChar; existingString: PWideChar; replacementString: PWideChar): Integer;
function CkFileAccess_SetCurrentDir(objHandle: HCkFileAccess; dirPath: PWideChar): wordbool;
function CkFileAccess_SetFileTimes(objHandle: HCkFileAccess; filePath: PWideChar; createTime: HCkDateTime; lastAccessTime: HCkDateTime; lastModTime: HCkDateTime): wordbool;
function CkFileAccess_SetLastModified(objHandle: HCkFileAccess; filePath: PWideChar; lastModified: HCkDateTime): wordbool;
function CkFileAccess_SplitFile(objHandle: HCkFileAccess; fileToSplit: PWideChar; partPrefix: PWideChar; partExtension: PWideChar; partSize: Integer; destDir: PWideChar): wordbool;
function CkFileAccess_SymlinkCreate(objHandle: HCkFileAccess; targetPath: PWideChar; linkPath: PWideChar): wordbool;
function CkFileAccess_SymlinkTarget(objHandle: HCkFileAccess; linkPath: PWideChar; outStr: HCkString): wordbool;
function CkFileAccess__symlinkTarget(objHandle: HCkFileAccess; linkPath: PWideChar): PWideChar;
function CkFileAccess_TreeDelete(objHandle: HCkFileAccess; path: PWideChar): wordbool;
function CkFileAccess_Truncate(objHandle: HCkFileAccess): wordbool;
function CkFileAccess_WriteEntireFile(objHandle: HCkFileAccess; filePath: PWideChar; fileData: HCkByteData): wordbool;
function CkFileAccess_WriteEntireTextFile(objHandle: HCkFileAccess; filePath: PWideChar; textData: PWideChar; charset: PWideChar; includedPreamble: wordbool): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkFileAccess_Create = function : HCkFileAccess; stdcall;
  TCkFileAccess_Dispose = procedure (handle: HCkFileAccess); stdcall;
  TCkFileAccess_getCurrentDir = procedure (objHandle: HCkFileAccess; outPropVal: HCkString); stdcall;
  TCkFileAccess__currentDir = function (objHandle: HCkFileAccess): PWideChar; stdcall;
  TCkFileAccess_getDebugLogFilePath = procedure (objHandle: HCkFileAccess; outPropVal: HCkString); stdcall;
  TCkFileAccess_putDebugLogFilePath = procedure (objHandle: HCkFileAccess; newPropVal: PWideChar); stdcall;
  TCkFileAccess__debugLogFilePath = function (objHandle: HCkFileAccess): PWideChar; stdcall;
  TCkFileAccess_getEndOfFile = function (objHandle: HCkFileAccess): wordbool; stdcall;
  TCkFileAccess_getFileOpenError = function (objHandle: HCkFileAccess): Integer; stdcall;
  TCkFileAccess_getFileOpenErrorMsg = procedure (objHandle: HCkFileAccess; outPropVal: HCkString); stdcall;
  TCkFileAccess__fileOpenErrorMsg = function (objHandle: HCkFileAccess): PWideChar; stdcall;
  TCkFileAccess_getLastErrorHtml = procedure (objHandle: HCkFileAccess; outPropVal: HCkString); stdcall;
  TCkFileAccess__lastErrorHtml = function (objHandle: HCkFileAccess): PWideChar; stdcall;
  TCkFileAccess_getLastErrorText = procedure (objHandle: HCkFileAccess; outPropVal: HCkString); stdcall;
  TCkFileAccess__lastErrorText = function (objHandle: HCkFileAccess): PWideChar; stdcall;
  TCkFileAccess_getLastErrorXml = procedure (objHandle: HCkFileAccess; outPropVal: HCkString); stdcall;
  TCkFileAccess__lastErrorXml = function (objHandle: HCkFileAccess): PWideChar; stdcall;
  TCkFileAccess_getLastMethodSuccess = function (objHandle: HCkFileAccess): wordbool; stdcall;
  TCkFileAccess_putLastMethodSuccess = procedure (objHandle: HCkFileAccess; newPropVal: wordbool); stdcall;
  TCkFileAccess_getLockFileOnOpen = function (objHandle: HCkFileAccess): wordbool; stdcall;
  TCkFileAccess_putLockFileOnOpen = procedure (objHandle: HCkFileAccess; newPropVal: wordbool); stdcall;
  TCkFileAccess_getVerboseLogging = function (objHandle: HCkFileAccess): wordbool; stdcall;
  TCkFileAccess_putVerboseLogging = procedure (objHandle: HCkFileAccess; newPropVal: wordbool); stdcall;
  TCkFileAccess_getVersion = procedure (objHandle: HCkFileAccess; outPropVal: HCkString); stdcall;
  TCkFileAccess__version = function (objHandle: HCkFileAccess): PWideChar; stdcall;
  TCkFileAccess_AppendAnsi = function (objHandle: HCkFileAccess; text: PWideChar): wordbool; stdcall;
  TCkFileAccess_AppendBd = function (objHandle: HCkFileAccess; bd: HCkBinData): wordbool; stdcall;
  TCkFileAccess_AppendSb = function (objHandle: HCkFileAccess; sb: HCkStringBuilder; charset: PWideChar): wordbool; stdcall;
  TCkFileAccess_AppendText = function (objHandle: HCkFileAccess; str: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkFileAccess_AppendUnicodeBOM = function (objHandle: HCkFileAccess): wordbool; stdcall;
  TCkFileAccess_AppendUtf8BOM = function (objHandle: HCkFileAccess): wordbool; stdcall;
  TCkFileAccess_DirAutoCreate = function (objHandle: HCkFileAccess; filePath: PWideChar): wordbool; stdcall;
  TCkFileAccess_DirCreate = function (objHandle: HCkFileAccess; dirPath: PWideChar): wordbool; stdcall;
  TCkFileAccess_DirDelete = function (objHandle: HCkFileAccess; dirPath: PWideChar): wordbool; stdcall;
  TCkFileAccess_DirEnsureExists = function (objHandle: HCkFileAccess; dirPath: PWideChar): wordbool; stdcall;
  TCkFileAccess_DirExists = function (objHandle: HCkFileAccess; dirPath: PWideChar): wordbool; stdcall;
  TCkFileAccess_FileClose = procedure (objHandle: HCkFileAccess); stdcall;
  TCkFileAccess_FileContentsEqual = function (objHandle: HCkFileAccess; filePath1: PWideChar; filePath2: PWideChar): wordbool; stdcall;
  TCkFileAccess_FileCopy = function (objHandle: HCkFileAccess; existingFilepath: PWideChar; newFilepath: PWideChar; failIfExists: wordbool): wordbool; stdcall;
  TCkFileAccess_FileDelete = function (objHandle: HCkFileAccess; filePath: PWideChar): wordbool; stdcall;
  TCkFileAccess_FileExists = function (objHandle: HCkFileAccess; filePath: PWideChar): wordbool; stdcall;
  TCkFileAccess_FileExists3 = function (objHandle: HCkFileAccess; path: PWideChar): Integer; stdcall;
  TCkFileAccess_FileOpen = function (objHandle: HCkFileAccess; filePath: PWideChar; accessMode: LongWord; shareMode: LongWord; createDisposition: LongWord; attributes: LongWord): wordbool; stdcall;
  TCkFileAccess_FileRead = function (objHandle: HCkFileAccess; maxNumBytes: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkFileAccess_FileReadBd = function (objHandle: HCkFileAccess; maxNumBytes: Integer; binData: HCkBinData): wordbool; stdcall;
  TCkFileAccess_FileRename = function (objHandle: HCkFileAccess; existingFilepath: PWideChar; newFilepath: PWideChar): wordbool; stdcall;
  TCkFileAccess_FileSeek = function (objHandle: HCkFileAccess; offset: Integer; origin: Integer): wordbool; stdcall;
  TCkFileAccess_FileSize = function (objHandle: HCkFileAccess; filePath: PWideChar): Integer; stdcall;
  TCkFileAccess_FileSize64 = function (objHandle: HCkFileAccess; filePath: PWideChar): Int64; stdcall;
  TCkFileAccess_FileSizeStr = function (objHandle: HCkFileAccess; filePath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__fileSizeStr = function (objHandle: HCkFileAccess; filePath: PWideChar): PWideChar; stdcall;
  TCkFileAccess_FileType = function (objHandle: HCkFileAccess; path: PWideChar): Integer; stdcall;
  TCkFileAccess_FileWrite = function (objHandle: HCkFileAccess; data: HCkByteData): wordbool; stdcall;
  TCkFileAccess_FileWriteBd = function (objHandle: HCkFileAccess; binData: HCkBinData; offset: Integer; numBytes: Integer): wordbool; stdcall;
  TCkFileAccess_GenBlockId = function (objHandle: HCkFileAccess; index: Integer; length: Integer; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__genBlockId = function (objHandle: HCkFileAccess; index: Integer; length: Integer; encoding: PWideChar): PWideChar; stdcall;
  TCkFileAccess_GetDirectoryName = function (objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__getDirectoryName = function (objHandle: HCkFileAccess; path: PWideChar): PWideChar; stdcall;
  TCkFileAccess_GetExtension = function (objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__getExtension = function (objHandle: HCkFileAccess; path: PWideChar): PWideChar; stdcall;
  TCkFileAccess_GetFileName = function (objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__getFileName = function (objHandle: HCkFileAccess; path: PWideChar): PWideChar; stdcall;
  TCkFileAccess_GetFileNameWithoutExtension = function (objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__getFileNameWithoutExtension = function (objHandle: HCkFileAccess; path: PWideChar): PWideChar; stdcall;
  TCkFileAccess_GetFileTime = function (objHandle: HCkFileAccess; path: PWideChar; which: Integer): HCkDateTime; stdcall;
  TCkFileAccess_GetFileTimeStr = function (objHandle: HCkFileAccess; path: PWideChar; which: Integer; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__getFileTimeStr = function (objHandle: HCkFileAccess; path: PWideChar; which: Integer): PWideChar; stdcall;
  TCkFileAccess_GetLastModified = function (objHandle: HCkFileAccess; path: PWideChar): HCkDateTime; stdcall;
  TCkFileAccess_GetNumBlocks = function (objHandle: HCkFileAccess; blockSize: Integer): Integer; stdcall;
  TCkFileAccess_GetTempFilename = function (objHandle: HCkFileAccess; dirPath: PWideChar; prefix: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__getTempFilename = function (objHandle: HCkFileAccess; dirPath: PWideChar; prefix: PWideChar): PWideChar; stdcall;
  TCkFileAccess_OpenForAppend = function (objHandle: HCkFileAccess; filePath: PWideChar): wordbool; stdcall;
  TCkFileAccess_OpenForRead = function (objHandle: HCkFileAccess; filePath: PWideChar): wordbool; stdcall;
  TCkFileAccess_OpenForReadWrite = function (objHandle: HCkFileAccess; filePath: PWideChar): wordbool; stdcall;
  TCkFileAccess_OpenForWrite = function (objHandle: HCkFileAccess; filePath: PWideChar): wordbool; stdcall;
  TCkFileAccess_ReadBinaryToEncoded = function (objHandle: HCkFileAccess; filePath: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__readBinaryToEncoded = function (objHandle: HCkFileAccess; filePath: PWideChar; encoding: PWideChar): PWideChar; stdcall;
  TCkFileAccess_ReadBlock = function (objHandle: HCkFileAccess; blockIndex: Integer; blockSize: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkFileAccess_ReadBlockBd = function (objHandle: HCkFileAccess; blockIndex: Integer; blockSize: Integer; bd: HCkBinData): wordbool; stdcall;
  TCkFileAccess_ReadEntireFile = function (objHandle: HCkFileAccess; filePath: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkFileAccess_ReadEntireTextFile = function (objHandle: HCkFileAccess; filePath: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__readEntireTextFile = function (objHandle: HCkFileAccess; filePath: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkFileAccess_ReadNextFragment = function (objHandle: HCkFileAccess; startAtBeginning: wordbool; beginMarker: PWideChar; endMarker: PWideChar; charset: PWideChar; sb: HCkStringBuilder): Integer; stdcall;
  TCkFileAccess_ReassembleFile = function (objHandle: HCkFileAccess; partsDirPath: PWideChar; partPrefix: PWideChar; partExtension: PWideChar; reassembledFilename: PWideChar): wordbool; stdcall;
  TCkFileAccess_ReplaceStrings = function (objHandle: HCkFileAccess; filePath: PWideChar; charset: PWideChar; existingString: PWideChar; replacementString: PWideChar): Integer; stdcall;
  TCkFileAccess_SetCurrentDir = function (objHandle: HCkFileAccess; dirPath: PWideChar): wordbool; stdcall;
  TCkFileAccess_SetFileTimes = function (objHandle: HCkFileAccess; filePath: PWideChar; createTime: HCkDateTime; lastAccessTime: HCkDateTime; lastModTime: HCkDateTime): wordbool; stdcall;
  TCkFileAccess_SetLastModified = function (objHandle: HCkFileAccess; filePath: PWideChar; lastModified: HCkDateTime): wordbool; stdcall;
  TCkFileAccess_SplitFile = function (objHandle: HCkFileAccess; fileToSplit: PWideChar; partPrefix: PWideChar; partExtension: PWideChar; partSize: Integer; destDir: PWideChar): wordbool; stdcall;
  TCkFileAccess_SymlinkCreate = function (objHandle: HCkFileAccess; targetPath: PWideChar; linkPath: PWideChar): wordbool; stdcall;
  TCkFileAccess_SymlinkTarget = function (objHandle: HCkFileAccess; linkPath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFileAccess__symlinkTarget = function (objHandle: HCkFileAccess; linkPath: PWideChar): PWideChar; stdcall;
  TCkFileAccess_TreeDelete = function (objHandle: HCkFileAccess; path: PWideChar): wordbool; stdcall;
  TCkFileAccess_Truncate = function (objHandle: HCkFileAccess): wordbool; stdcall;
  TCkFileAccess_WriteEntireFile = function (objHandle: HCkFileAccess; filePath: PWideChar; fileData: HCkByteData): wordbool; stdcall;
  TCkFileAccess_WriteEntireTextFile = function (objHandle: HCkFileAccess; filePath: PWideChar; textData: PWideChar; charset: PWideChar; includedPreamble: wordbool): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..95] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkFileAccess_Create : HCkFileAccess;
begin
  result := TCkFileAccess_Create(_map(0, 'CkFileAccess_Create'));
end;

procedure CkFileAccess_Dispose (handle: HCkFileAccess);
begin
  TCkFileAccess_Dispose(_map(1, 'CkFileAccess_Dispose'))
    (handle);
end;


procedure CkFileAccess_getCurrentDir (objHandle: HCkFileAccess; outPropVal: HCkString);
begin
  TCkFileAccess_getCurrentDir(_map(2, 'CkFileAccess_getCurrentDir'))
    (objHandle, outPropVal);
end;

function CkFileAccess__currentDir (objHandle: HCkFileAccess): PWideChar;
begin
  result := TCkFileAccess__currentDir(_map(3, 'CkFileAccess__currentDir'))
    (objHandle);
end;

procedure CkFileAccess_getDebugLogFilePath (objHandle: HCkFileAccess; outPropVal: HCkString);
begin
  TCkFileAccess_getDebugLogFilePath(_map(4, 'CkFileAccess_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkFileAccess_putDebugLogFilePath (objHandle: HCkFileAccess; newPropVal: PWideChar);
begin
  TCkFileAccess_putDebugLogFilePath(_map(5, 'CkFileAccess_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkFileAccess__debugLogFilePath (objHandle: HCkFileAccess): PWideChar;
begin
  result := TCkFileAccess__debugLogFilePath(_map(6, 'CkFileAccess__debugLogFilePath'))
    (objHandle);
end;

function CkFileAccess_getEndOfFile (objHandle: HCkFileAccess): wordbool;
begin
    result := TCkFileAccess_getEndOfFile(_map(7, 'CkFileAccess_getEndOfFile'))
    (objHandle);
end;

function CkFileAccess_getFileOpenError (objHandle: HCkFileAccess): Integer;
begin
    result := TCkFileAccess_getFileOpenError(_map(8, 'CkFileAccess_getFileOpenError'))
    (objHandle);
end;

procedure CkFileAccess_getFileOpenErrorMsg (objHandle: HCkFileAccess; outPropVal: HCkString);
begin
  TCkFileAccess_getFileOpenErrorMsg(_map(9, 'CkFileAccess_getFileOpenErrorMsg'))
    (objHandle, outPropVal);
end;

function CkFileAccess__fileOpenErrorMsg (objHandle: HCkFileAccess): PWideChar;
begin
  result := TCkFileAccess__fileOpenErrorMsg(_map(10, 'CkFileAccess__fileOpenErrorMsg'))
    (objHandle);
end;

procedure CkFileAccess_getLastErrorHtml (objHandle: HCkFileAccess; outPropVal: HCkString);
begin
  TCkFileAccess_getLastErrorHtml(_map(11, 'CkFileAccess_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkFileAccess__lastErrorHtml (objHandle: HCkFileAccess): PWideChar;
begin
  result := TCkFileAccess__lastErrorHtml(_map(12, 'CkFileAccess__lastErrorHtml'))
    (objHandle);
end;

procedure CkFileAccess_getLastErrorText (objHandle: HCkFileAccess; outPropVal: HCkString);
begin
  TCkFileAccess_getLastErrorText(_map(13, 'CkFileAccess_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkFileAccess__lastErrorText (objHandle: HCkFileAccess): PWideChar;
begin
  result := TCkFileAccess__lastErrorText(_map(14, 'CkFileAccess__lastErrorText'))
    (objHandle);
end;

procedure CkFileAccess_getLastErrorXml (objHandle: HCkFileAccess; outPropVal: HCkString);
begin
  TCkFileAccess_getLastErrorXml(_map(15, 'CkFileAccess_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkFileAccess__lastErrorXml (objHandle: HCkFileAccess): PWideChar;
begin
  result := TCkFileAccess__lastErrorXml(_map(16, 'CkFileAccess__lastErrorXml'))
    (objHandle);
end;

function CkFileAccess_getLastMethodSuccess (objHandle: HCkFileAccess): wordbool;
begin
    result := TCkFileAccess_getLastMethodSuccess(_map(17, 'CkFileAccess_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkFileAccess_putLastMethodSuccess (objHandle: HCkFileAccess; newPropVal: wordbool);
begin
  TCkFileAccess_putLastMethodSuccess(_map(18, 'CkFileAccess_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkFileAccess_getLockFileOnOpen (objHandle: HCkFileAccess): wordbool;
begin
    result := TCkFileAccess_getLockFileOnOpen(_map(19, 'CkFileAccess_getLockFileOnOpen'))
    (objHandle);
end;

procedure CkFileAccess_putLockFileOnOpen (objHandle: HCkFileAccess; newPropVal: wordbool);
begin
  TCkFileAccess_putLockFileOnOpen(_map(20, 'CkFileAccess_putLockFileOnOpen'))
    (objHandle, newPropVal);
end;

function CkFileAccess_getVerboseLogging (objHandle: HCkFileAccess): wordbool;
begin
    result := TCkFileAccess_getVerboseLogging(_map(21, 'CkFileAccess_getVerboseLogging'))
    (objHandle);
end;

procedure CkFileAccess_putVerboseLogging (objHandle: HCkFileAccess; newPropVal: wordbool);
begin
  TCkFileAccess_putVerboseLogging(_map(22, 'CkFileAccess_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkFileAccess_getVersion (objHandle: HCkFileAccess; outPropVal: HCkString);
begin
  TCkFileAccess_getVersion(_map(23, 'CkFileAccess_getVersion'))
    (objHandle, outPropVal);
end;

function CkFileAccess__version (objHandle: HCkFileAccess): PWideChar;
begin
  result := TCkFileAccess__version(_map(24, 'CkFileAccess__version'))
    (objHandle);
end;

function CkFileAccess_AppendAnsi (objHandle: HCkFileAccess; text: PWideChar): wordbool;
begin
  result := TCkFileAccess_AppendAnsi(_map(25, 'CkFileAccess_AppendAnsi'))
    (objHandle, text);
end;

function CkFileAccess_AppendBd (objHandle: HCkFileAccess; bd: HCkBinData): wordbool;
begin
  result := TCkFileAccess_AppendBd(_map(26, 'CkFileAccess_AppendBd'))
    (objHandle, bd);
end;

function CkFileAccess_AppendSb (objHandle: HCkFileAccess; sb: HCkStringBuilder; charset: PWideChar): wordbool;
begin
  result := TCkFileAccess_AppendSb(_map(27, 'CkFileAccess_AppendSb'))
    (objHandle, sb, charset);
end;

function CkFileAccess_AppendText (objHandle: HCkFileAccess; str: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkFileAccess_AppendText(_map(28, 'CkFileAccess_AppendText'))
    (objHandle, str, charset);
end;

function CkFileAccess_AppendUnicodeBOM (objHandle: HCkFileAccess): wordbool;
begin
  result := TCkFileAccess_AppendUnicodeBOM(_map(29, 'CkFileAccess_AppendUnicodeBOM'))
    (objHandle);
end;

function CkFileAccess_AppendUtf8BOM (objHandle: HCkFileAccess): wordbool;
begin
  result := TCkFileAccess_AppendUtf8BOM(_map(30, 'CkFileAccess_AppendUtf8BOM'))
    (objHandle);
end;

function CkFileAccess_DirAutoCreate (objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
begin
  result := TCkFileAccess_DirAutoCreate(_map(31, 'CkFileAccess_DirAutoCreate'))
    (objHandle, filePath);
end;

function CkFileAccess_DirCreate (objHandle: HCkFileAccess; dirPath: PWideChar): wordbool;
begin
  result := TCkFileAccess_DirCreate(_map(32, 'CkFileAccess_DirCreate'))
    (objHandle, dirPath);
end;

function CkFileAccess_DirDelete (objHandle: HCkFileAccess; dirPath: PWideChar): wordbool;
begin
  result := TCkFileAccess_DirDelete(_map(33, 'CkFileAccess_DirDelete'))
    (objHandle, dirPath);
end;

function CkFileAccess_DirEnsureExists (objHandle: HCkFileAccess; dirPath: PWideChar): wordbool;
begin
  result := TCkFileAccess_DirEnsureExists(_map(34, 'CkFileAccess_DirEnsureExists'))
    (objHandle, dirPath);
end;

function CkFileAccess_DirExists (objHandle: HCkFileAccess; dirPath: PWideChar): wordbool;
begin
  result := TCkFileAccess_DirExists(_map(35, 'CkFileAccess_DirExists'))
    (objHandle, dirPath);
end;

procedure CkFileAccess_FileClose (objHandle: HCkFileAccess);
begin
  TCkFileAccess_FileClose(_map(36, 'CkFileAccess_FileClose'))
    (objHandle);
end;

function CkFileAccess_FileContentsEqual (objHandle: HCkFileAccess; filePath1: PWideChar; filePath2: PWideChar): wordbool;
begin
  result := TCkFileAccess_FileContentsEqual(_map(37, 'CkFileAccess_FileContentsEqual'))
    (objHandle, filePath1, filePath2);
end;

function CkFileAccess_FileCopy (objHandle: HCkFileAccess; existingFilepath: PWideChar; newFilepath: PWideChar; failIfExists: wordbool): wordbool;
begin
  result := TCkFileAccess_FileCopy(_map(38, 'CkFileAccess_FileCopy'))
    (objHandle, existingFilepath, newFilepath, failIfExists);
end;

function CkFileAccess_FileDelete (objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
begin
  result := TCkFileAccess_FileDelete(_map(39, 'CkFileAccess_FileDelete'))
    (objHandle, filePath);
end;

function CkFileAccess_FileExists (objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
begin
  result := TCkFileAccess_FileExists(_map(40, 'CkFileAccess_FileExists'))
    (objHandle, filePath);
end;

function CkFileAccess_FileExists3 (objHandle: HCkFileAccess; path: PWideChar): Integer;
begin
  result := TCkFileAccess_FileExists3(_map(41, 'CkFileAccess_FileExists3'))
    (objHandle, path);
end;

function CkFileAccess_FileOpen (objHandle: HCkFileAccess; filePath: PWideChar; accessMode: LongWord; shareMode: LongWord; createDisposition: LongWord; attributes: LongWord): wordbool;
begin
  result := TCkFileAccess_FileOpen(_map(42, 'CkFileAccess_FileOpen'))
    (objHandle, filePath, accessMode, shareMode, createDisposition, attributes);
end;

function CkFileAccess_FileRead (objHandle: HCkFileAccess; maxNumBytes: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkFileAccess_FileRead(_map(43, 'CkFileAccess_FileRead'))
    (objHandle, maxNumBytes, outData);
end;

function CkFileAccess_FileReadBd (objHandle: HCkFileAccess; maxNumBytes: Integer; binData: HCkBinData): wordbool;
begin
  result := TCkFileAccess_FileReadBd(_map(44, 'CkFileAccess_FileReadBd'))
    (objHandle, maxNumBytes, binData);
end;

function CkFileAccess_FileRename (objHandle: HCkFileAccess; existingFilepath: PWideChar; newFilepath: PWideChar): wordbool;
begin
  result := TCkFileAccess_FileRename(_map(45, 'CkFileAccess_FileRename'))
    (objHandle, existingFilepath, newFilepath);
end;

function CkFileAccess_FileSeek (objHandle: HCkFileAccess; offset: Integer; origin: Integer): wordbool;
begin
  result := TCkFileAccess_FileSeek(_map(46, 'CkFileAccess_FileSeek'))
    (objHandle, offset, origin);
end;

function CkFileAccess_FileSize (objHandle: HCkFileAccess; filePath: PWideChar): Integer;
begin
  result := TCkFileAccess_FileSize(_map(47, 'CkFileAccess_FileSize'))
    (objHandle, filePath);
end;

function CkFileAccess_FileSize64 (objHandle: HCkFileAccess; filePath: PWideChar): Int64;
begin
  result := TCkFileAccess_FileSize64(_map(48, 'CkFileAccess_FileSize64'))
    (objHandle, filePath);
end;

function CkFileAccess_FileSizeStr (objHandle: HCkFileAccess; filePath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_FileSizeStr(_map(49, 'CkFileAccess_FileSizeStr'))
    (objHandle, filePath, outStr);
end;

function CkFileAccess__fileSizeStr (objHandle: HCkFileAccess; filePath: PWideChar): PWideChar;
begin
  result := TCkFileAccess__fileSizeStr(_map(50, 'CkFileAccess__fileSizeStr'))
    (objHandle, filePath);
end;

function CkFileAccess_FileType (objHandle: HCkFileAccess; path: PWideChar): Integer;
begin
  result := TCkFileAccess_FileType(_map(51, 'CkFileAccess_FileType'))
    (objHandle, path);
end;

function CkFileAccess_FileWrite (objHandle: HCkFileAccess; data: HCkByteData): wordbool;
begin
  result := TCkFileAccess_FileWrite(_map(52, 'CkFileAccess_FileWrite'))
    (objHandle, data);
end;

function CkFileAccess_FileWriteBd (objHandle: HCkFileAccess; binData: HCkBinData; offset: Integer; numBytes: Integer): wordbool;
begin
  result := TCkFileAccess_FileWriteBd(_map(53, 'CkFileAccess_FileWriteBd'))
    (objHandle, binData, offset, numBytes);
end;

function CkFileAccess_GenBlockId (objHandle: HCkFileAccess; index: Integer; length: Integer; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_GenBlockId(_map(54, 'CkFileAccess_GenBlockId'))
    (objHandle, index, length, encoding, outStr);
end;

function CkFileAccess__genBlockId (objHandle: HCkFileAccess; index: Integer; length: Integer; encoding: PWideChar): PWideChar;
begin
  result := TCkFileAccess__genBlockId(_map(55, 'CkFileAccess__genBlockId'))
    (objHandle, index, length, encoding);
end;

function CkFileAccess_GetDirectoryName (objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_GetDirectoryName(_map(56, 'CkFileAccess_GetDirectoryName'))
    (objHandle, path, outStr);
end;

function CkFileAccess__getDirectoryName (objHandle: HCkFileAccess; path: PWideChar): PWideChar;
begin
  result := TCkFileAccess__getDirectoryName(_map(57, 'CkFileAccess__getDirectoryName'))
    (objHandle, path);
end;

function CkFileAccess_GetExtension (objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_GetExtension(_map(58, 'CkFileAccess_GetExtension'))
    (objHandle, path, outStr);
end;

function CkFileAccess__getExtension (objHandle: HCkFileAccess; path: PWideChar): PWideChar;
begin
  result := TCkFileAccess__getExtension(_map(59, 'CkFileAccess__getExtension'))
    (objHandle, path);
end;

function CkFileAccess_GetFileName (objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_GetFileName(_map(60, 'CkFileAccess_GetFileName'))
    (objHandle, path, outStr);
end;

function CkFileAccess__getFileName (objHandle: HCkFileAccess; path: PWideChar): PWideChar;
begin
  result := TCkFileAccess__getFileName(_map(61, 'CkFileAccess__getFileName'))
    (objHandle, path);
end;

function CkFileAccess_GetFileNameWithoutExtension (objHandle: HCkFileAccess; path: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_GetFileNameWithoutExtension(_map(62, 'CkFileAccess_GetFileNameWithoutExtension'))
    (objHandle, path, outStr);
end;

function CkFileAccess__getFileNameWithoutExtension (objHandle: HCkFileAccess; path: PWideChar): PWideChar;
begin
  result := TCkFileAccess__getFileNameWithoutExtension(_map(63, 'CkFileAccess__getFileNameWithoutExtension'))
    (objHandle, path);
end;

function CkFileAccess_GetFileTime (objHandle: HCkFileAccess; path: PWideChar; which: Integer): HCkDateTime;
begin
  result := TCkFileAccess_GetFileTime(_map(64, 'CkFileAccess_GetFileTime'))
    (objHandle, path, which);
end;

function CkFileAccess_GetFileTimeStr (objHandle: HCkFileAccess; path: PWideChar; which: Integer; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_GetFileTimeStr(_map(65, 'CkFileAccess_GetFileTimeStr'))
    (objHandle, path, which, outStr);
end;

function CkFileAccess__getFileTimeStr (objHandle: HCkFileAccess; path: PWideChar; which: Integer): PWideChar;
begin
  result := TCkFileAccess__getFileTimeStr(_map(66, 'CkFileAccess__getFileTimeStr'))
    (objHandle, path, which);
end;

function CkFileAccess_GetLastModified (objHandle: HCkFileAccess; path: PWideChar): HCkDateTime;
begin
  result := TCkFileAccess_GetLastModified(_map(67, 'CkFileAccess_GetLastModified'))
    (objHandle, path);
end;

function CkFileAccess_GetNumBlocks (objHandle: HCkFileAccess; blockSize: Integer): Integer;
begin
  result := TCkFileAccess_GetNumBlocks(_map(68, 'CkFileAccess_GetNumBlocks'))
    (objHandle, blockSize);
end;

function CkFileAccess_GetTempFilename (objHandle: HCkFileAccess; dirPath: PWideChar; prefix: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_GetTempFilename(_map(69, 'CkFileAccess_GetTempFilename'))
    (objHandle, dirPath, prefix, outStr);
end;

function CkFileAccess__getTempFilename (objHandle: HCkFileAccess; dirPath: PWideChar; prefix: PWideChar): PWideChar;
begin
  result := TCkFileAccess__getTempFilename(_map(70, 'CkFileAccess__getTempFilename'))
    (objHandle, dirPath, prefix);
end;

function CkFileAccess_OpenForAppend (objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
begin
  result := TCkFileAccess_OpenForAppend(_map(71, 'CkFileAccess_OpenForAppend'))
    (objHandle, filePath);
end;

function CkFileAccess_OpenForRead (objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
begin
  result := TCkFileAccess_OpenForRead(_map(72, 'CkFileAccess_OpenForRead'))
    (objHandle, filePath);
end;

function CkFileAccess_OpenForReadWrite (objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
begin
  result := TCkFileAccess_OpenForReadWrite(_map(73, 'CkFileAccess_OpenForReadWrite'))
    (objHandle, filePath);
end;

function CkFileAccess_OpenForWrite (objHandle: HCkFileAccess; filePath: PWideChar): wordbool;
begin
  result := TCkFileAccess_OpenForWrite(_map(74, 'CkFileAccess_OpenForWrite'))
    (objHandle, filePath);
end;

function CkFileAccess_ReadBinaryToEncoded (objHandle: HCkFileAccess; filePath: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_ReadBinaryToEncoded(_map(75, 'CkFileAccess_ReadBinaryToEncoded'))
    (objHandle, filePath, encoding, outStr);
end;

function CkFileAccess__readBinaryToEncoded (objHandle: HCkFileAccess; filePath: PWideChar; encoding: PWideChar): PWideChar;
begin
  result := TCkFileAccess__readBinaryToEncoded(_map(76, 'CkFileAccess__readBinaryToEncoded'))
    (objHandle, filePath, encoding);
end;

function CkFileAccess_ReadBlock (objHandle: HCkFileAccess; blockIndex: Integer; blockSize: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkFileAccess_ReadBlock(_map(77, 'CkFileAccess_ReadBlock'))
    (objHandle, blockIndex, blockSize, outData);
end;

function CkFileAccess_ReadBlockBd (objHandle: HCkFileAccess; blockIndex: Integer; blockSize: Integer; bd: HCkBinData): wordbool;
begin
  result := TCkFileAccess_ReadBlockBd(_map(78, 'CkFileAccess_ReadBlockBd'))
    (objHandle, blockIndex, blockSize, bd);
end;

function CkFileAccess_ReadEntireFile (objHandle: HCkFileAccess; filePath: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkFileAccess_ReadEntireFile(_map(79, 'CkFileAccess_ReadEntireFile'))
    (objHandle, filePath, outData);
end;

function CkFileAccess_ReadEntireTextFile (objHandle: HCkFileAccess; filePath: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_ReadEntireTextFile(_map(80, 'CkFileAccess_ReadEntireTextFile'))
    (objHandle, filePath, charset, outStr);
end;

function CkFileAccess__readEntireTextFile (objHandle: HCkFileAccess; filePath: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkFileAccess__readEntireTextFile(_map(81, 'CkFileAccess__readEntireTextFile'))
    (objHandle, filePath, charset);
end;

function CkFileAccess_ReadNextFragment (objHandle: HCkFileAccess; startAtBeginning: wordbool; beginMarker: PWideChar; endMarker: PWideChar; charset: PWideChar; sb: HCkStringBuilder): Integer;
begin
  result := TCkFileAccess_ReadNextFragment(_map(82, 'CkFileAccess_ReadNextFragment'))
    (objHandle, startAtBeginning, beginMarker, endMarker, charset, sb);
end;

function CkFileAccess_ReassembleFile (objHandle: HCkFileAccess; partsDirPath: PWideChar; partPrefix: PWideChar; partExtension: PWideChar; reassembledFilename: PWideChar): wordbool;
begin
  result := TCkFileAccess_ReassembleFile(_map(83, 'CkFileAccess_ReassembleFile'))
    (objHandle, partsDirPath, partPrefix, partExtension, reassembledFilename);
end;

function CkFileAccess_ReplaceStrings (objHandle: HCkFileAccess; filePath: PWideChar; charset: PWideChar; existingString: PWideChar; replacementString: PWideChar): Integer;
begin
  result := TCkFileAccess_ReplaceStrings(_map(84, 'CkFileAccess_ReplaceStrings'))
    (objHandle, filePath, charset, existingString, replacementString);
end;

function CkFileAccess_SetCurrentDir (objHandle: HCkFileAccess; dirPath: PWideChar): wordbool;
begin
  result := TCkFileAccess_SetCurrentDir(_map(85, 'CkFileAccess_SetCurrentDir'))
    (objHandle, dirPath);
end;

function CkFileAccess_SetFileTimes (objHandle: HCkFileAccess; filePath: PWideChar; createTime: HCkDateTime; lastAccessTime: HCkDateTime; lastModTime: HCkDateTime): wordbool;
begin
  result := TCkFileAccess_SetFileTimes(_map(86, 'CkFileAccess_SetFileTimes'))
    (objHandle, filePath, createTime, lastAccessTime, lastModTime);
end;

function CkFileAccess_SetLastModified (objHandle: HCkFileAccess; filePath: PWideChar; lastModified: HCkDateTime): wordbool;
begin
  result := TCkFileAccess_SetLastModified(_map(87, 'CkFileAccess_SetLastModified'))
    (objHandle, filePath, lastModified);
end;

function CkFileAccess_SplitFile (objHandle: HCkFileAccess; fileToSplit: PWideChar; partPrefix: PWideChar; partExtension: PWideChar; partSize: Integer; destDir: PWideChar): wordbool;
begin
  result := TCkFileAccess_SplitFile(_map(88, 'CkFileAccess_SplitFile'))
    (objHandle, fileToSplit, partPrefix, partExtension, partSize, destDir);
end;

function CkFileAccess_SymlinkCreate (objHandle: HCkFileAccess; targetPath: PWideChar; linkPath: PWideChar): wordbool;
begin
  result := TCkFileAccess_SymlinkCreate(_map(89, 'CkFileAccess_SymlinkCreate'))
    (objHandle, targetPath, linkPath);
end;

function CkFileAccess_SymlinkTarget (objHandle: HCkFileAccess; linkPath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFileAccess_SymlinkTarget(_map(90, 'CkFileAccess_SymlinkTarget'))
    (objHandle, linkPath, outStr);
end;

function CkFileAccess__symlinkTarget (objHandle: HCkFileAccess; linkPath: PWideChar): PWideChar;
begin
  result := TCkFileAccess__symlinkTarget(_map(91, 'CkFileAccess__symlinkTarget'))
    (objHandle, linkPath);
end;

function CkFileAccess_TreeDelete (objHandle: HCkFileAccess; path: PWideChar): wordbool;
begin
  result := TCkFileAccess_TreeDelete(_map(92, 'CkFileAccess_TreeDelete'))
    (objHandle, path);
end;

function CkFileAccess_Truncate (objHandle: HCkFileAccess): wordbool;
begin
  result := TCkFileAccess_Truncate(_map(93, 'CkFileAccess_Truncate'))
    (objHandle);
end;

function CkFileAccess_WriteEntireFile (objHandle: HCkFileAccess; filePath: PWideChar; fileData: HCkByteData): wordbool;
begin
  result := TCkFileAccess_WriteEntireFile(_map(94, 'CkFileAccess_WriteEntireFile'))
    (objHandle, filePath, fileData);
end;

function CkFileAccess_WriteEntireTextFile (objHandle: HCkFileAccess; filePath: PWideChar; textData: PWideChar; charset: PWideChar; includedPreamble: wordbool): wordbool;
begin
  result := TCkFileAccess_WriteEntireTextFile(_map(95, 'CkFileAccess_WriteEntireTextFile'))
    (objHandle, filePath, textData, charset, includedPreamble);
end;

end.
