unit Ftp2;

interface

type

HCkSecureString = Pointer;
HCkBinData = Pointer;
HCkDateTime = Pointer;
HCkCert = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkStream = Pointer;
HCkStringBuilder = Pointer;
HCkFtp2 = Pointer;
HCkTask = Pointer;
HCkStringTable = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TFtp2AbortCheck = function(): Integer; cdecl;
TFtp2ProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TFtp2PercentDone = function(pctDone: Integer): Integer; cdecl;
TFtp2TaskCompleted = procedure(task: HCkTask); cdecl;


function CkFtp2_Create: HCkFtp2;  stdcall;
procedure CkFtp2_Dispose(handle: HCkFtp2); stdcall;

procedure CkFtp2_SetAbortCheck(objHandle: HCkFtp2; fn: TFtp2AbortCheck) stdcall;
procedure CkFtp2_SetProgressInfo(objHandle: HCkFtp2; fn: TFtp2ProgressInfo) stdcall;
procedure CkFtp2_SetPercentDone(objHandle: HCkFtp2; fn: TFtp2PercentDone) stdcall;
procedure CkFtp2_SetTaskCompleted(objHandle: HCkFtp2; fn: TFtp2TaskCompleted) stdcall;
function CkFtp2_getAbortCurrent(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAbortCurrent(objHandle: HCkFtp2; newPropVal: wordbool);
procedure CkFtp2_getAccount(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putAccount(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__account(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getActivePortRangeEnd(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putActivePortRangeEnd(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getActivePortRangeStart(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putActivePortRangeStart(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getAllocateSize(objHandle: HCkFtp2): LongWord;
procedure CkFtp2_putAllocateSize(objHandle: HCkFtp2; newPropVal: LongWord);
function CkFtp2_getAllowMlsd(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAllowMlsd(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getAsyncBytesReceived(objHandle: HCkFtp2): LongWord;
function CkFtp2_getAsyncBytesReceived64(objHandle: HCkFtp2): Int64;
procedure CkFtp2_getAsyncBytesReceivedStr(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__asyncBytesReceivedStr(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getAsyncBytesSent(objHandle: HCkFtp2): LongWord;
function CkFtp2_getAsyncBytesSent64(objHandle: HCkFtp2): Int64;
procedure CkFtp2_getAsyncBytesSentStr(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__asyncBytesSentStr(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getAuthSsl(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAuthSsl(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getAuthTls(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAuthTls(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getAutoFeat(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAutoFeat(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getAutoFix(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAutoFix(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getAutoGetSizeForProgress(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAutoGetSizeForProgress(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getAutoOptsUtf8(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAutoOptsUtf8(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getAutoSetUseEpsv(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAutoSetUseEpsv(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getAutoSyst(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAutoSyst(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getAutoXcrc(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putAutoXcrc(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getBandwidthThrottleDown(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putBandwidthThrottleDown(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getBandwidthThrottleUp(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putBandwidthThrottleUp(objHandle: HCkFtp2; newPropVal: Integer);
procedure CkFtp2_getClientIpAddress(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putClientIpAddress(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__clientIpAddress(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getCommandCharset(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putCommandCharset(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__commandCharset(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getConnectFailReason(objHandle: HCkFtp2): Integer;
function CkFtp2_getConnectTimeout(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putConnectTimeout(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getConnectVerified(objHandle: HCkFtp2): wordbool;
function CkFtp2_getCrlfMode(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putCrlfMode(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getCurBytesReceived(objHandle: HCkFtp2): LongWord;
function CkFtp2_getCurBytesReceived64(objHandle: HCkFtp2): Int64;
procedure CkFtp2_getCurBytesReceivedStr(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__curBytesReceivedStr(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getCurBytesSent(objHandle: HCkFtp2): LongWord;
function CkFtp2_getCurBytesSent64(objHandle: HCkFtp2): Int64;
procedure CkFtp2_getCurBytesSentStr(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__curBytesSentStr(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getDataProtection(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putDataProtection(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__dataProtection(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getDebugLogFilePath(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putDebugLogFilePath(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__debugLogFilePath(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getDirListingCharset(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putDirListingCharset(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__dirListingCharset(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getDownloadTransferRate(objHandle: HCkFtp2): Integer;
procedure CkFtp2_getForcePortIpAddress(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putForcePortIpAddress(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__forcePortIpAddress(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getGreeting(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__greeting(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getHasModeZ(objHandle: HCkFtp2): wordbool;
function CkFtp2_getHeartbeatMs(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putHeartbeatMs(objHandle: HCkFtp2; newPropVal: Integer);
procedure CkFtp2_getHostname(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putHostname(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__hostname(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getHttpProxyAuthMethod(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putHttpProxyAuthMethod(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__httpProxyAuthMethod(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getHttpProxyDomain(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putHttpProxyDomain(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__httpProxyDomain(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getHttpProxyHostname(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putHttpProxyHostname(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__httpProxyHostname(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getHttpProxyPassword(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putHttpProxyPassword(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__httpProxyPassword(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getHttpProxyPort(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putHttpProxyPort(objHandle: HCkFtp2; newPropVal: Integer);
procedure CkFtp2_getHttpProxyUsername(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putHttpProxyUsername(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__httpProxyUsername(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getIdleTimeoutMs(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putIdleTimeoutMs(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getIsConnected(objHandle: HCkFtp2): wordbool;
function CkFtp2_getKeepSessionLog(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putKeepSessionLog(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getLargeFileMeasures(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putLargeFileMeasures(objHandle: HCkFtp2; newPropVal: wordbool);
procedure CkFtp2_getLastErrorHtml(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__lastErrorHtml(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getLastErrorText(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__lastErrorText(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getLastErrorXml(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__lastErrorXml(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getLastMethodSuccess(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putLastMethodSuccess(objHandle: HCkFtp2; newPropVal: wordbool);
procedure CkFtp2_getLastReply(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__lastReply(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getListPattern(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putListPattern(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__listPattern(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getLoginVerified(objHandle: HCkFtp2): wordbool;
function CkFtp2_getPartialTransfer(objHandle: HCkFtp2): wordbool;
function CkFtp2_getPassive(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putPassive(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getPassiveUseHostAddr(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putPassiveUseHostAddr(objHandle: HCkFtp2; newPropVal: wordbool);
procedure CkFtp2_getPassword(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putPassword(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__password(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getPercentDoneScale(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putPercentDoneScale(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getPort(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putPort(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getPreferIpv6(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putPreferIpv6(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getPreferNlst(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putPreferNlst(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getProgressMonSize(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putProgressMonSize(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getProgressMonSize64(objHandle: HCkFtp2): Int64;
procedure CkFtp2_putProgressMonSize64(objHandle: HCkFtp2; newPropVal: Int64);
procedure CkFtp2_getProxyHostname(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putProxyHostname(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__proxyHostname(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getProxyMethod(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putProxyMethod(objHandle: HCkFtp2; newPropVal: Integer);
procedure CkFtp2_getProxyPassword(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putProxyPassword(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__proxyPassword(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getProxyPort(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putProxyPort(objHandle: HCkFtp2; newPropVal: Integer);
procedure CkFtp2_getProxyUsername(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putProxyUsername(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__proxyUsername(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getReadTimeout(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putReadTimeout(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getRequireSslCertVerify(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putRequireSslCertVerify(objHandle: HCkFtp2; newPropVal: wordbool);
function CkFtp2_getRestartNext(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putRestartNext(objHandle: HCkFtp2; newPropVal: wordbool);
procedure CkFtp2_getSessionLog(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__sessionLog(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getSocksHostname(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putSocksHostname(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__socksHostname(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getSocksPassword(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putSocksPassword(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__socksPassword(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getSocksPort(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putSocksPort(objHandle: HCkFtp2; newPropVal: Integer);
procedure CkFtp2_getSocksUsername(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putSocksUsername(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__socksUsername(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getSocksVersion(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putSocksVersion(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getSoRcvBuf(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putSoRcvBuf(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getSoSndBuf(objHandle: HCkFtp2): Integer;
procedure CkFtp2_putSoSndBuf(objHandle: HCkFtp2; newPropVal: Integer);
function CkFtp2_getSsl(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putSsl(objHandle: HCkFtp2; newPropVal: wordbool);
procedure CkFtp2_getSslAllowedCiphers(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putSslAllowedCiphers(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__sslAllowedCiphers(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getSslProtocol(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putSslProtocol(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__sslProtocol(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getSslServerCertVerified(objHandle: HCkFtp2): wordbool;
function CkFtp2_getSyncCreateAllLocalDirs(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putSyncCreateAllLocalDirs(objHandle: HCkFtp2; newPropVal: wordbool);
procedure CkFtp2_getSyncMustMatch(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putSyncMustMatch(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__syncMustMatch(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getSyncMustMatchDir(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putSyncMustMatchDir(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__syncMustMatchDir(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getSyncMustNotMatch(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putSyncMustNotMatch(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__syncMustNotMatch(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getSyncMustNotMatchDir(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putSyncMustNotMatchDir(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__syncMustNotMatchDir(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getSyncPreview(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__syncPreview(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getTlsCipherSuite(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__tlsCipherSuite(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getTlsPinSet(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putTlsPinSet(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__tlsPinSet(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getTlsVersion(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__tlsVersion(objHandle: HCkFtp2): PWideChar;
procedure CkFtp2_getUncommonOptions(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putUncommonOptions(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__uncommonOptions(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getUploadTransferRate(objHandle: HCkFtp2): Integer;
function CkFtp2_getUseEpsv(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putUseEpsv(objHandle: HCkFtp2; newPropVal: wordbool);
procedure CkFtp2_getUsername(objHandle: HCkFtp2; outPropVal: HCkString);
procedure CkFtp2_putUsername(objHandle: HCkFtp2; newPropVal: PWideChar);
function CkFtp2__username(objHandle: HCkFtp2): PWideChar;
function CkFtp2_getVerboseLogging(objHandle: HCkFtp2): wordbool;
procedure CkFtp2_putVerboseLogging(objHandle: HCkFtp2; newPropVal: wordbool);
procedure CkFtp2_getVersion(objHandle: HCkFtp2; outPropVal: HCkString);
function CkFtp2__version(objHandle: HCkFtp2): PWideChar;
function CkFtp2_AppendFile(objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): wordbool;
function CkFtp2_AppendFileAsync(objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): HCkTask;
function CkFtp2_AppendFileBd(objHandle: HCkFtp2; remoteFilename: PWideChar; bd: HCkBinData): wordbool;
function CkFtp2_AppendFileBdAsync(objHandle: HCkFtp2; remoteFilename: PWideChar; bd: HCkBinData): HCkTask;
function CkFtp2_AppendFileFromBinaryData(objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): wordbool;
function CkFtp2_AppendFileFromBinaryDataAsync(objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): HCkTask;
function CkFtp2_AppendFileFromTextData(objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): wordbool;
function CkFtp2_AppendFileFromTextDataAsync(objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): HCkTask;
function CkFtp2_AppendFileSb(objHandle: HCkFtp2; remoteFilename: PWideChar; sb: HCkStringBuilder; charset: PWideChar): wordbool;
function CkFtp2_AppendFileSbAsync(objHandle: HCkFtp2; remoteFilename: PWideChar; sb: HCkStringBuilder; charset: PWideChar): HCkTask;
function CkFtp2_ChangeRemoteDir(objHandle: HCkFtp2; remoteDirPath: PWideChar): wordbool;
function CkFtp2_ChangeRemoteDirAsync(objHandle: HCkFtp2; remoteDirPath: PWideChar): HCkTask;
function CkFtp2_CheckConnection(objHandle: HCkFtp2): wordbool;
function CkFtp2_CheckConnectionAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_ClearControlChannel(objHandle: HCkFtp2): wordbool;
function CkFtp2_ClearControlChannelAsync(objHandle: HCkFtp2): HCkTask;
procedure CkFtp2_ClearDirCache(objHandle: HCkFtp2);
procedure CkFtp2_ClearSessionLog(objHandle: HCkFtp2);
function CkFtp2_Connect(objHandle: HCkFtp2): wordbool;
function CkFtp2_ConnectAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_ConnectOnly(objHandle: HCkFtp2): wordbool;
function CkFtp2_ConnectOnlyAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_ConvertToTls(objHandle: HCkFtp2): wordbool;
function CkFtp2_ConvertToTlsAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_CreatePlan(objHandle: HCkFtp2; localDir: PWideChar; outStr: HCkString): wordbool;
function CkFtp2__createPlan(objHandle: HCkFtp2; localDir: PWideChar): PWideChar;
function CkFtp2_CreatePlanAsync(objHandle: HCkFtp2; localDir: PWideChar): HCkTask;
function CkFtp2_CreateRemoteDir(objHandle: HCkFtp2; remoteDirPath: PWideChar): wordbool;
function CkFtp2_CreateRemoteDirAsync(objHandle: HCkFtp2; remoteDirPath: PWideChar): HCkTask;
function CkFtp2_DeleteMatching(objHandle: HCkFtp2; remotePattern: PWideChar): Integer;
function CkFtp2_DeleteMatchingAsync(objHandle: HCkFtp2; remotePattern: PWideChar): HCkTask;
function CkFtp2_DeleteRemoteFile(objHandle: HCkFtp2; remoteFilePath: PWideChar): wordbool;
function CkFtp2_DeleteRemoteFileAsync(objHandle: HCkFtp2; remoteFilePath: PWideChar): HCkTask;
function CkFtp2_DeleteTree(objHandle: HCkFtp2): wordbool;
function CkFtp2_DeleteTreeAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_DetermineProxyMethod(objHandle: HCkFtp2): Integer;
function CkFtp2_DetermineProxyMethodAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_DetermineSettings(objHandle: HCkFtp2; outStr: HCkString): wordbool;
function CkFtp2__determineSettings(objHandle: HCkFtp2): PWideChar;
function CkFtp2_DetermineSettingsAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_DirTreeXml(objHandle: HCkFtp2; outStr: HCkString): wordbool;
function CkFtp2__dirTreeXml(objHandle: HCkFtp2): PWideChar;
function CkFtp2_DirTreeXmlAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_Disconnect(objHandle: HCkFtp2): wordbool;
function CkFtp2_DisconnectAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_DownloadTree(objHandle: HCkFtp2; localRoot: PWideChar): wordbool;
function CkFtp2_DownloadTreeAsync(objHandle: HCkFtp2; localRoot: PWideChar): HCkTask;
function CkFtp2_Feat(objHandle: HCkFtp2; outStr: HCkString): wordbool;
function CkFtp2__feat(objHandle: HCkFtp2): PWideChar;
function CkFtp2_FeatAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_GetCreateDt(objHandle: HCkFtp2; index: Integer): HCkDateTime;
function CkFtp2_GetCreateDtAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetCreateDtByName(objHandle: HCkFtp2; filename: PWideChar): HCkDateTime;
function CkFtp2_GetCreateDtByNameAsync(objHandle: HCkFtp2; filename: PWideChar): HCkTask;
function CkFtp2_GetCreateTimeByNameStr(objHandle: HCkFtp2; filename: PWideChar; outStr: HCkString): wordbool;
function CkFtp2__getCreateTimeByNameStr(objHandle: HCkFtp2; filename: PWideChar): PWideChar;
function CkFtp2_GetCreateTimeByNameStrAsync(objHandle: HCkFtp2; filename: PWideChar): HCkTask;
function CkFtp2_GetCreateTimeStr(objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
function CkFtp2__getCreateTimeStr(objHandle: HCkFtp2; index: Integer): PWideChar;
function CkFtp2_GetCreateTimeStrAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetCurrentRemoteDir(objHandle: HCkFtp2; outStr: HCkString): wordbool;
function CkFtp2__getCurrentRemoteDir(objHandle: HCkFtp2): PWideChar;
function CkFtp2_GetCurrentRemoteDirAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_GetDirCount(objHandle: HCkFtp2): Integer;
function CkFtp2_GetDirCountAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_GetFile(objHandle: HCkFtp2; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool;
function CkFtp2_GetFileAsync(objHandle: HCkFtp2; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask;
function CkFtp2_GetFileBd(objHandle: HCkFtp2; remoteFilePath: PWideChar; binData: HCkBinData): wordbool;
function CkFtp2_GetFileBdAsync(objHandle: HCkFtp2; remoteFilePath: PWideChar; binData: HCkBinData): HCkTask;
function CkFtp2_GetFilename(objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
function CkFtp2__getFilename(objHandle: HCkFtp2; index: Integer): PWideChar;
function CkFtp2_GetFilenameAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetFileSb(objHandle: HCkFtp2; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): wordbool;
function CkFtp2_GetFileSbAsync(objHandle: HCkFtp2; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): HCkTask;
function CkFtp2_GetFileToStream(objHandle: HCkFtp2; remoteFilePath: PWideChar; toStream: HCkStream): wordbool;
function CkFtp2_GetFileToStreamAsync(objHandle: HCkFtp2; remoteFilePath: PWideChar; toStream: HCkStream): HCkTask;
function CkFtp2_GetGroup(objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
function CkFtp2__getGroup(objHandle: HCkFtp2; index: Integer): PWideChar;
function CkFtp2_GetGroupAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetIsDirectory(objHandle: HCkFtp2; index: Integer): wordbool;
function CkFtp2_GetIsDirectoryAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetIsSymbolicLink(objHandle: HCkFtp2; index: Integer): wordbool;
function CkFtp2_GetIsSymbolicLinkAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetLastModDt(objHandle: HCkFtp2; index: Integer): HCkDateTime;
function CkFtp2_GetLastModDtAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetLastModDtByName(objHandle: HCkFtp2; filename: PWideChar): HCkDateTime;
function CkFtp2_GetLastModDtByNameAsync(objHandle: HCkFtp2; filename: PWideChar): HCkTask;
function CkFtp2_GetLastModifiedTimeByNameStr(objHandle: HCkFtp2; filename: PWideChar; outStr: HCkString): wordbool;
function CkFtp2__getLastModifiedTimeByNameStr(objHandle: HCkFtp2; filename: PWideChar): PWideChar;
function CkFtp2_GetLastModifiedTimeByNameStrAsync(objHandle: HCkFtp2; filename: PWideChar): HCkTask;
function CkFtp2_GetLastModifiedTimeStr(objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
function CkFtp2__getLastModifiedTimeStr(objHandle: HCkFtp2; index: Integer): PWideChar;
function CkFtp2_GetLastModifiedTimeStrAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetOwner(objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
function CkFtp2__getOwner(objHandle: HCkFtp2; index: Integer): PWideChar;
function CkFtp2_GetOwnerAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetPermissions(objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
function CkFtp2__getPermissions(objHandle: HCkFtp2; index: Integer): PWideChar;
function CkFtp2_GetPermissionsAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetPermType(objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
function CkFtp2__getPermType(objHandle: HCkFtp2; index: Integer): PWideChar;
function CkFtp2_GetPermTypeAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetRemoteFileBinaryData(objHandle: HCkFtp2; remoteFilename: PWideChar; outData: HCkByteData): wordbool;
function CkFtp2_GetRemoteFileBinaryDataAsync(objHandle: HCkFtp2; remoteFilename: PWideChar): HCkTask;
function CkFtp2_GetRemoteFileTextC(objHandle: HCkFtp2; remoteFilename: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkFtp2__getRemoteFileTextC(objHandle: HCkFtp2; remoteFilename: PWideChar; charset: PWideChar): PWideChar;
function CkFtp2_GetRemoteFileTextCAsync(objHandle: HCkFtp2; remoteFilename: PWideChar; charset: PWideChar): HCkTask;
function CkFtp2_GetRemoteFileTextData(objHandle: HCkFtp2; remoteFilename: PWideChar; outStr: HCkString): wordbool;
function CkFtp2__getRemoteFileTextData(objHandle: HCkFtp2; remoteFilename: PWideChar): PWideChar;
function CkFtp2_GetRemoteFileTextDataAsync(objHandle: HCkFtp2; remoteFilename: PWideChar): HCkTask;
function CkFtp2_GetServerCert(objHandle: HCkFtp2; cert: HCkCert): wordbool;
function CkFtp2_GetSize(objHandle: HCkFtp2; index: Integer): Integer;
function CkFtp2_GetSizeAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetSize64(objHandle: HCkFtp2; index: Integer): Int64;
function CkFtp2_GetSize64Async(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetSizeByName(objHandle: HCkFtp2; filename: PWideChar): Integer;
function CkFtp2_GetSizeByNameAsync(objHandle: HCkFtp2; filename: PWideChar): HCkTask;
function CkFtp2_GetSizeByName64(objHandle: HCkFtp2; filename: PWideChar): Int64;
function CkFtp2_GetSizeByName64Async(objHandle: HCkFtp2; filename: PWideChar): HCkTask;
function CkFtp2_GetSizeStr(objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
function CkFtp2__getSizeStr(objHandle: HCkFtp2; index: Integer): PWideChar;
function CkFtp2_GetSizeStrAsync(objHandle: HCkFtp2; index: Integer): HCkTask;
function CkFtp2_GetSizeStrByName(objHandle: HCkFtp2; filename: PWideChar; outStr: HCkString): wordbool;
function CkFtp2__getSizeStrByName(objHandle: HCkFtp2; filename: PWideChar): PWideChar;
function CkFtp2_GetSizeStrByNameAsync(objHandle: HCkFtp2; filename: PWideChar): HCkTask;
function CkFtp2_GetSslServerCert(objHandle: HCkFtp2): HCkCert;
procedure CkFtp2_GetSyncedFiles(objHandle: HCkFtp2; strTable: HCkStringTable);
function CkFtp2_GetTextDirListing(objHandle: HCkFtp2; pattern: PWideChar; outStr: HCkString): wordbool;
function CkFtp2__getTextDirListing(objHandle: HCkFtp2; pattern: PWideChar): PWideChar;
function CkFtp2_GetTextDirListingAsync(objHandle: HCkFtp2; pattern: PWideChar): HCkTask;
function CkFtp2_GetXmlDirListing(objHandle: HCkFtp2; pattern: PWideChar; outStr: HCkString): wordbool;
function CkFtp2__getXmlDirListing(objHandle: HCkFtp2; pattern: PWideChar): PWideChar;
function CkFtp2_GetXmlDirListingAsync(objHandle: HCkFtp2; pattern: PWideChar): HCkTask;
function CkFtp2_LargeFileUpload(objHandle: HCkFtp2; localPath: PWideChar; remotePath: PWideChar; chunkSize: Integer): wordbool;
function CkFtp2_LargeFileUploadAsync(objHandle: HCkFtp2; localPath: PWideChar; remotePath: PWideChar; chunkSize: Integer): HCkTask;
function CkFtp2_LoadTaskCaller(objHandle: HCkFtp2; task: HCkTask): wordbool;
function CkFtp2_LoginAfterConnectOnly(objHandle: HCkFtp2): wordbool;
function CkFtp2_LoginAfterConnectOnlyAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_MGetFiles(objHandle: HCkFtp2; remotePattern: PWideChar; localDir: PWideChar): Integer;
function CkFtp2_MGetFilesAsync(objHandle: HCkFtp2; remotePattern: PWideChar; localDir: PWideChar): HCkTask;
function CkFtp2_MPutFiles(objHandle: HCkFtp2; pattern: PWideChar): Integer;
function CkFtp2_MPutFilesAsync(objHandle: HCkFtp2; pattern: PWideChar): HCkTask;
function CkFtp2_NlstXml(objHandle: HCkFtp2; remoteDirPattern: PWideChar; outStr: HCkString): wordbool;
function CkFtp2__nlstXml(objHandle: HCkFtp2; remoteDirPattern: PWideChar): PWideChar;
function CkFtp2_NlstXmlAsync(objHandle: HCkFtp2; remoteDirPattern: PWideChar): HCkTask;
function CkFtp2_Noop(objHandle: HCkFtp2): wordbool;
function CkFtp2_NoopAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_PutFile(objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): wordbool;
function CkFtp2_PutFileAsync(objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): HCkTask;
function CkFtp2_PutFileBd(objHandle: HCkFtp2; binData: HCkBinData; remoteFilePath: PWideChar): wordbool;
function CkFtp2_PutFileBdAsync(objHandle: HCkFtp2; binData: HCkBinData; remoteFilePath: PWideChar): HCkTask;
function CkFtp2_PutFileFromBinaryData(objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): wordbool;
function CkFtp2_PutFileFromBinaryDataAsync(objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): HCkTask;
function CkFtp2_PutFileFromTextData(objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): wordbool;
function CkFtp2_PutFileFromTextDataAsync(objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): HCkTask;
function CkFtp2_PutFileSb(objHandle: HCkFtp2; sb: HCkStringBuilder; charset: PWideChar; includeBom: wordbool; remoteFilePath: PWideChar): wordbool;
function CkFtp2_PutFileSbAsync(objHandle: HCkFtp2; sb: HCkStringBuilder; charset: PWideChar; includeBom: wordbool; remoteFilePath: PWideChar): HCkTask;
function CkFtp2_PutPlan(objHandle: HCkFtp2; plan: PWideChar; alreadyDoneFilename: PWideChar): wordbool;
function CkFtp2_PutPlanAsync(objHandle: HCkFtp2; plan: PWideChar; alreadyDoneFilename: PWideChar): HCkTask;
function CkFtp2_PutTree(objHandle: HCkFtp2; localDir: PWideChar): wordbool;
function CkFtp2_PutTreeAsync(objHandle: HCkFtp2; localDir: PWideChar): HCkTask;
function CkFtp2_Quote(objHandle: HCkFtp2; cmd: PWideChar): wordbool;
function CkFtp2_QuoteAsync(objHandle: HCkFtp2; cmd: PWideChar): HCkTask;
function CkFtp2_RemoveRemoteDir(objHandle: HCkFtp2; remoteDirPath: PWideChar): wordbool;
function CkFtp2_RemoveRemoteDirAsync(objHandle: HCkFtp2; remoteDirPath: PWideChar): HCkTask;
function CkFtp2_RenameRemoteFile(objHandle: HCkFtp2; existingRemoteFilePath: PWideChar; newRemoteFilePath: PWideChar): wordbool;
function CkFtp2_RenameRemoteFileAsync(objHandle: HCkFtp2; existingRemoteFilePath: PWideChar; newRemoteFilePath: PWideChar): HCkTask;
function CkFtp2_SendCommand(objHandle: HCkFtp2; cmd: PWideChar; outStr: HCkString): wordbool;
function CkFtp2__sendCommand(objHandle: HCkFtp2; cmd: PWideChar): PWideChar;
function CkFtp2_SendCommandAsync(objHandle: HCkFtp2; cmd: PWideChar): HCkTask;
function CkFtp2_SetModeZ(objHandle: HCkFtp2): wordbool;
function CkFtp2_SetModeZAsync(objHandle: HCkFtp2): HCkTask;
procedure CkFtp2_SetOldestDateStr(objHandle: HCkFtp2; oldestDateTimeStr: PWideChar);
function CkFtp2_SetOption(objHandle: HCkFtp2; option: PWideChar): wordbool;
function CkFtp2_SetPassword(objHandle: HCkFtp2; password: HCkSecureString): wordbool;
function CkFtp2_SetRemoteFileDateTimeStr(objHandle: HCkFtp2; dateTimeStr: PWideChar; remoteFilename: PWideChar): wordbool;
function CkFtp2_SetRemoteFileDateTimeStrAsync(objHandle: HCkFtp2; dateTimeStr: PWideChar; remoteFilename: PWideChar): HCkTask;
function CkFtp2_SetRemoteFileDt(objHandle: HCkFtp2; dt: HCkDateTime; remoteFilename: PWideChar): wordbool;
function CkFtp2_SetRemoteFileDtAsync(objHandle: HCkFtp2; dt: HCkDateTime; remoteFilename: PWideChar): HCkTask;
function CkFtp2_SetSecurePassword(objHandle: HCkFtp2; password: HCkSecureString): wordbool;
procedure CkFtp2_SetSslCertRequirement(objHandle: HCkFtp2; reqName: PWideChar; reqValue: PWideChar);
function CkFtp2_SetSslClientCert(objHandle: HCkFtp2; cert: HCkCert): wordbool;
function CkFtp2_SetSslClientCertPem(objHandle: HCkFtp2; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool;
function CkFtp2_SetSslClientCertPfx(objHandle: HCkFtp2; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool;
function CkFtp2_SetTypeAscii(objHandle: HCkFtp2): wordbool;
function CkFtp2_SetTypeAsciiAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_SetTypeBinary(objHandle: HCkFtp2): wordbool;
function CkFtp2_SetTypeBinaryAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_Site(objHandle: HCkFtp2; siteCommand: PWideChar): wordbool;
function CkFtp2_SiteAsync(objHandle: HCkFtp2; siteCommand: PWideChar): HCkTask;
procedure CkFtp2_SleepMs(objHandle: HCkFtp2; millisec: Integer);
function CkFtp2_Stat(objHandle: HCkFtp2; outStr: HCkString): wordbool;
function CkFtp2__stat(objHandle: HCkFtp2): PWideChar;
function CkFtp2_StatAsync(objHandle: HCkFtp2): HCkTask;
function CkFtp2_SyncDeleteRemote(objHandle: HCkFtp2; localRoot: PWideChar): wordbool;
function CkFtp2_SyncDeleteRemoteAsync(objHandle: HCkFtp2; localRoot: PWideChar): HCkTask;
function CkFtp2_SyncLocalDir(objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): wordbool;
function CkFtp2_SyncLocalDirAsync(objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): HCkTask;
function CkFtp2_SyncLocalTree(objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): wordbool;
function CkFtp2_SyncLocalTreeAsync(objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): HCkTask;
function CkFtp2_SyncRemoteTree(objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): wordbool;
function CkFtp2_SyncRemoteTreeAsync(objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): HCkTask;
function CkFtp2_SyncRemoteTree2(objHandle: HCkFtp2; localDirPath: PWideChar; mode: Integer; bDescend: wordbool; bPreviewOnly: wordbool): wordbool;
function CkFtp2_SyncRemoteTree2Async(objHandle: HCkFtp2; localDirPath: PWideChar; mode: Integer; bDescend: wordbool; bPreviewOnly: wordbool): HCkTask;
function CkFtp2_Syst(objHandle: HCkFtp2; outStr: HCkString): wordbool;
function CkFtp2__syst(objHandle: HCkFtp2): PWideChar;
function CkFtp2_SystAsync(objHandle: HCkFtp2): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkFtp2_Create = function : HCkFtp2; stdcall;
  TCkFtp2_Dispose = procedure (handle: HCkFtp2); stdcall;
  TCkFtp2_SetAbortCheck = procedure (objHandle: HCkFtp2; fn: TFtp2AbortCheck); stdcall;
  TCkFtp2_SetProgressInfo = procedure (objHandle: HCkFtp2; fn: TFtp2ProgressInfo); stdcall;
  TCkFtp2_SetPercentDone = procedure (objHandle: HCkFtp2; fn: TFtp2PercentDone); stdcall;
  TCkFtp2_SetTaskCompleted = procedure (objHandle: HCkFtp2; fn: TFtp2TaskCompleted); stdcall;
  TCkFtp2_getAbortCurrent = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAbortCurrent = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getAccount = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putAccount = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__account = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getActivePortRangeEnd = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putActivePortRangeEnd = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getActivePortRangeStart = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putActivePortRangeStart = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getAllocateSize = function (objHandle: HCkFtp2): LongWord; stdcall;
  TCkFtp2_putAllocateSize = procedure (objHandle: HCkFtp2; newPropVal: LongWord); stdcall;
  TCkFtp2_getAllowMlsd = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAllowMlsd = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getAsyncBytesReceived = function (objHandle: HCkFtp2): LongWord; stdcall;
  TCkFtp2_getAsyncBytesReceived64 = function (objHandle: HCkFtp2): Int64; stdcall;
  TCkFtp2_getAsyncBytesReceivedStr = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__asyncBytesReceivedStr = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getAsyncBytesSent = function (objHandle: HCkFtp2): LongWord; stdcall;
  TCkFtp2_getAsyncBytesSent64 = function (objHandle: HCkFtp2): Int64; stdcall;
  TCkFtp2_getAsyncBytesSentStr = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__asyncBytesSentStr = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getAuthSsl = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAuthSsl = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getAuthTls = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAuthTls = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getAutoFeat = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAutoFeat = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getAutoFix = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAutoFix = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getAutoGetSizeForProgress = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAutoGetSizeForProgress = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getAutoOptsUtf8 = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAutoOptsUtf8 = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getAutoSetUseEpsv = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAutoSetUseEpsv = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getAutoSyst = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAutoSyst = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getAutoXcrc = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putAutoXcrc = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getBandwidthThrottleDown = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putBandwidthThrottleDown = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getBandwidthThrottleUp = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putBandwidthThrottleUp = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getClientIpAddress = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putClientIpAddress = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__clientIpAddress = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getCommandCharset = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putCommandCharset = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__commandCharset = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getConnectFailReason = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_getConnectTimeout = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putConnectTimeout = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getConnectVerified = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_getCrlfMode = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putCrlfMode = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getCurBytesReceived = function (objHandle: HCkFtp2): LongWord; stdcall;
  TCkFtp2_getCurBytesReceived64 = function (objHandle: HCkFtp2): Int64; stdcall;
  TCkFtp2_getCurBytesReceivedStr = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__curBytesReceivedStr = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getCurBytesSent = function (objHandle: HCkFtp2): LongWord; stdcall;
  TCkFtp2_getCurBytesSent64 = function (objHandle: HCkFtp2): Int64; stdcall;
  TCkFtp2_getCurBytesSentStr = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__curBytesSentStr = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getDataProtection = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putDataProtection = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__dataProtection = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getDebugLogFilePath = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putDebugLogFilePath = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__debugLogFilePath = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getDirListingCharset = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putDirListingCharset = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__dirListingCharset = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getDownloadTransferRate = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_getForcePortIpAddress = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putForcePortIpAddress = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__forcePortIpAddress = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getGreeting = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__greeting = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getHasModeZ = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_getHeartbeatMs = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putHeartbeatMs = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getHostname = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putHostname = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__hostname = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getHttpProxyAuthMethod = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putHttpProxyAuthMethod = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__httpProxyAuthMethod = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getHttpProxyDomain = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putHttpProxyDomain = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__httpProxyDomain = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getHttpProxyHostname = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putHttpProxyHostname = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__httpProxyHostname = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getHttpProxyPassword = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putHttpProxyPassword = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__httpProxyPassword = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getHttpProxyPort = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putHttpProxyPort = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getHttpProxyUsername = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putHttpProxyUsername = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__httpProxyUsername = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getIdleTimeoutMs = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putIdleTimeoutMs = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getIsConnected = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_getKeepSessionLog = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putKeepSessionLog = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getLargeFileMeasures = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putLargeFileMeasures = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getLastErrorHtml = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__lastErrorHtml = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getLastErrorText = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__lastErrorText = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getLastErrorXml = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__lastErrorXml = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getLastMethodSuccess = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putLastMethodSuccess = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getLastReply = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__lastReply = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getListPattern = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putListPattern = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__listPattern = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getLoginVerified = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_getPartialTransfer = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_getPassive = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putPassive = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getPassiveUseHostAddr = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putPassiveUseHostAddr = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getPassword = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putPassword = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__password = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getPercentDoneScale = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putPercentDoneScale = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getPort = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putPort = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getPreferIpv6 = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putPreferIpv6 = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getPreferNlst = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putPreferNlst = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getProgressMonSize = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putProgressMonSize = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getProgressMonSize64 = function (objHandle: HCkFtp2): Int64; stdcall;
  TCkFtp2_putProgressMonSize64 = procedure (objHandle: HCkFtp2; newPropVal: Int64); stdcall;
  TCkFtp2_getProxyHostname = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putProxyHostname = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__proxyHostname = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getProxyMethod = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putProxyMethod = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getProxyPassword = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putProxyPassword = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__proxyPassword = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getProxyPort = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putProxyPort = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getProxyUsername = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putProxyUsername = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__proxyUsername = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getReadTimeout = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putReadTimeout = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getRequireSslCertVerify = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putRequireSslCertVerify = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getRestartNext = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putRestartNext = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getSessionLog = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__sessionLog = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getSocksHostname = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putSocksHostname = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__socksHostname = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getSocksPassword = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putSocksPassword = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__socksPassword = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getSocksPort = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putSocksPort = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getSocksUsername = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putSocksUsername = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__socksUsername = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getSocksVersion = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putSocksVersion = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getSoRcvBuf = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putSoRcvBuf = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getSoSndBuf = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_putSoSndBuf = procedure (objHandle: HCkFtp2; newPropVal: Integer); stdcall;
  TCkFtp2_getSsl = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putSsl = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getSslAllowedCiphers = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putSslAllowedCiphers = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__sslAllowedCiphers = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getSslProtocol = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putSslProtocol = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__sslProtocol = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getSslServerCertVerified = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_getSyncCreateAllLocalDirs = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putSyncCreateAllLocalDirs = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getSyncMustMatch = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putSyncMustMatch = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__syncMustMatch = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getSyncMustMatchDir = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putSyncMustMatchDir = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__syncMustMatchDir = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getSyncMustNotMatch = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putSyncMustNotMatch = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__syncMustNotMatch = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getSyncMustNotMatchDir = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putSyncMustNotMatchDir = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__syncMustNotMatchDir = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getSyncPreview = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__syncPreview = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getTlsCipherSuite = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__tlsCipherSuite = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getTlsPinSet = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putTlsPinSet = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__tlsPinSet = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getTlsVersion = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__tlsVersion = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getUncommonOptions = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putUncommonOptions = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__uncommonOptions = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getUploadTransferRate = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_getUseEpsv = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putUseEpsv = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getUsername = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2_putUsername = procedure (objHandle: HCkFtp2; newPropVal: PWideChar); stdcall;
  TCkFtp2__username = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_getVerboseLogging = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_putVerboseLogging = procedure (objHandle: HCkFtp2; newPropVal: wordbool); stdcall;
  TCkFtp2_getVersion = procedure (objHandle: HCkFtp2; outPropVal: HCkString); stdcall;
  TCkFtp2__version = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_AppendFile = function (objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): wordbool; stdcall;
  TCkFtp2_AppendFileAsync = function (objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): HCkTask; stdcall;
  TCkFtp2_AppendFileBd = function (objHandle: HCkFtp2; remoteFilename: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkFtp2_AppendFileBdAsync = function (objHandle: HCkFtp2; remoteFilename: PWideChar; bd: HCkBinData): HCkTask; stdcall;
  TCkFtp2_AppendFileFromBinaryData = function (objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): wordbool; stdcall;
  TCkFtp2_AppendFileFromBinaryDataAsync = function (objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): HCkTask; stdcall;
  TCkFtp2_AppendFileFromTextData = function (objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkFtp2_AppendFileFromTextDataAsync = function (objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkFtp2_AppendFileSb = function (objHandle: HCkFtp2; remoteFilename: PWideChar; sb: HCkStringBuilder; charset: PWideChar): wordbool; stdcall;
  TCkFtp2_AppendFileSbAsync = function (objHandle: HCkFtp2; remoteFilename: PWideChar; sb: HCkStringBuilder; charset: PWideChar): HCkTask; stdcall;
  TCkFtp2_ChangeRemoteDir = function (objHandle: HCkFtp2; remoteDirPath: PWideChar): wordbool; stdcall;
  TCkFtp2_ChangeRemoteDirAsync = function (objHandle: HCkFtp2; remoteDirPath: PWideChar): HCkTask; stdcall;
  TCkFtp2_CheckConnection = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_CheckConnectionAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_ClearControlChannel = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_ClearControlChannelAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_ClearDirCache = procedure (objHandle: HCkFtp2); stdcall;
  TCkFtp2_ClearSessionLog = procedure (objHandle: HCkFtp2); stdcall;
  TCkFtp2_Connect = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_ConnectAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_ConnectOnly = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_ConnectOnlyAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_ConvertToTls = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_ConvertToTlsAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_CreatePlan = function (objHandle: HCkFtp2; localDir: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__createPlan = function (objHandle: HCkFtp2; localDir: PWideChar): PWideChar; stdcall;
  TCkFtp2_CreatePlanAsync = function (objHandle: HCkFtp2; localDir: PWideChar): HCkTask; stdcall;
  TCkFtp2_CreateRemoteDir = function (objHandle: HCkFtp2; remoteDirPath: PWideChar): wordbool; stdcall;
  TCkFtp2_CreateRemoteDirAsync = function (objHandle: HCkFtp2; remoteDirPath: PWideChar): HCkTask; stdcall;
  TCkFtp2_DeleteMatching = function (objHandle: HCkFtp2; remotePattern: PWideChar): Integer; stdcall;
  TCkFtp2_DeleteMatchingAsync = function (objHandle: HCkFtp2; remotePattern: PWideChar): HCkTask; stdcall;
  TCkFtp2_DeleteRemoteFile = function (objHandle: HCkFtp2; remoteFilePath: PWideChar): wordbool; stdcall;
  TCkFtp2_DeleteRemoteFileAsync = function (objHandle: HCkFtp2; remoteFilePath: PWideChar): HCkTask; stdcall;
  TCkFtp2_DeleteTree = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_DeleteTreeAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_DetermineProxyMethod = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_DetermineProxyMethodAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_DetermineSettings = function (objHandle: HCkFtp2; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__determineSettings = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_DetermineSettingsAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_DirTreeXml = function (objHandle: HCkFtp2; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__dirTreeXml = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_DirTreeXmlAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_Disconnect = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_DisconnectAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_DownloadTree = function (objHandle: HCkFtp2; localRoot: PWideChar): wordbool; stdcall;
  TCkFtp2_DownloadTreeAsync = function (objHandle: HCkFtp2; localRoot: PWideChar): HCkTask; stdcall;
  TCkFtp2_Feat = function (objHandle: HCkFtp2; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__feat = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_FeatAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_GetCreateDt = function (objHandle: HCkFtp2; index: Integer): HCkDateTime; stdcall;
  TCkFtp2_GetCreateDtAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetCreateDtByName = function (objHandle: HCkFtp2; filename: PWideChar): HCkDateTime; stdcall;
  TCkFtp2_GetCreateDtByNameAsync = function (objHandle: HCkFtp2; filename: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetCreateTimeByNameStr = function (objHandle: HCkFtp2; filename: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getCreateTimeByNameStr = function (objHandle: HCkFtp2; filename: PWideChar): PWideChar; stdcall;
  TCkFtp2_GetCreateTimeByNameStrAsync = function (objHandle: HCkFtp2; filename: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetCreateTimeStr = function (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getCreateTimeStr = function (objHandle: HCkFtp2; index: Integer): PWideChar; stdcall;
  TCkFtp2_GetCreateTimeStrAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetCurrentRemoteDir = function (objHandle: HCkFtp2; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getCurrentRemoteDir = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_GetCurrentRemoteDirAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_GetDirCount = function (objHandle: HCkFtp2): Integer; stdcall;
  TCkFtp2_GetDirCountAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_GetFile = function (objHandle: HCkFtp2; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool; stdcall;
  TCkFtp2_GetFileAsync = function (objHandle: HCkFtp2; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetFileBd = function (objHandle: HCkFtp2; remoteFilePath: PWideChar; binData: HCkBinData): wordbool; stdcall;
  TCkFtp2_GetFileBdAsync = function (objHandle: HCkFtp2; remoteFilePath: PWideChar; binData: HCkBinData): HCkTask; stdcall;
  TCkFtp2_GetFilename = function (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getFilename = function (objHandle: HCkFtp2; index: Integer): PWideChar; stdcall;
  TCkFtp2_GetFilenameAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetFileSb = function (objHandle: HCkFtp2; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): wordbool; stdcall;
  TCkFtp2_GetFileSbAsync = function (objHandle: HCkFtp2; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkFtp2_GetFileToStream = function (objHandle: HCkFtp2; remoteFilePath: PWideChar; toStream: HCkStream): wordbool; stdcall;
  TCkFtp2_GetFileToStreamAsync = function (objHandle: HCkFtp2; remoteFilePath: PWideChar; toStream: HCkStream): HCkTask; stdcall;
  TCkFtp2_GetGroup = function (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getGroup = function (objHandle: HCkFtp2; index: Integer): PWideChar; stdcall;
  TCkFtp2_GetGroupAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetIsDirectory = function (objHandle: HCkFtp2; index: Integer): wordbool; stdcall;
  TCkFtp2_GetIsDirectoryAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetIsSymbolicLink = function (objHandle: HCkFtp2; index: Integer): wordbool; stdcall;
  TCkFtp2_GetIsSymbolicLinkAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetLastModDt = function (objHandle: HCkFtp2; index: Integer): HCkDateTime; stdcall;
  TCkFtp2_GetLastModDtAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetLastModDtByName = function (objHandle: HCkFtp2; filename: PWideChar): HCkDateTime; stdcall;
  TCkFtp2_GetLastModDtByNameAsync = function (objHandle: HCkFtp2; filename: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetLastModifiedTimeByNameStr = function (objHandle: HCkFtp2; filename: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getLastModifiedTimeByNameStr = function (objHandle: HCkFtp2; filename: PWideChar): PWideChar; stdcall;
  TCkFtp2_GetLastModifiedTimeByNameStrAsync = function (objHandle: HCkFtp2; filename: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetLastModifiedTimeStr = function (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getLastModifiedTimeStr = function (objHandle: HCkFtp2; index: Integer): PWideChar; stdcall;
  TCkFtp2_GetLastModifiedTimeStrAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetOwner = function (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getOwner = function (objHandle: HCkFtp2; index: Integer): PWideChar; stdcall;
  TCkFtp2_GetOwnerAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetPermissions = function (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getPermissions = function (objHandle: HCkFtp2; index: Integer): PWideChar; stdcall;
  TCkFtp2_GetPermissionsAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetPermType = function (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getPermType = function (objHandle: HCkFtp2; index: Integer): PWideChar; stdcall;
  TCkFtp2_GetPermTypeAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetRemoteFileBinaryData = function (objHandle: HCkFtp2; remoteFilename: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkFtp2_GetRemoteFileBinaryDataAsync = function (objHandle: HCkFtp2; remoteFilename: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetRemoteFileTextC = function (objHandle: HCkFtp2; remoteFilename: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getRemoteFileTextC = function (objHandle: HCkFtp2; remoteFilename: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkFtp2_GetRemoteFileTextCAsync = function (objHandle: HCkFtp2; remoteFilename: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetRemoteFileTextData = function (objHandle: HCkFtp2; remoteFilename: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getRemoteFileTextData = function (objHandle: HCkFtp2; remoteFilename: PWideChar): PWideChar; stdcall;
  TCkFtp2_GetRemoteFileTextDataAsync = function (objHandle: HCkFtp2; remoteFilename: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetServerCert = function (objHandle: HCkFtp2; cert: HCkCert): wordbool; stdcall;
  TCkFtp2_GetSize = function (objHandle: HCkFtp2; index: Integer): Integer; stdcall;
  TCkFtp2_GetSizeAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetSize64 = function (objHandle: HCkFtp2; index: Integer): Int64; stdcall;
  TCkFtp2_GetSize64Async = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetSizeByName = function (objHandle: HCkFtp2; filename: PWideChar): Integer; stdcall;
  TCkFtp2_GetSizeByNameAsync = function (objHandle: HCkFtp2; filename: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetSizeByName64 = function (objHandle: HCkFtp2; filename: PWideChar): Int64; stdcall;
  TCkFtp2_GetSizeByName64Async = function (objHandle: HCkFtp2; filename: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetSizeStr = function (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getSizeStr = function (objHandle: HCkFtp2; index: Integer): PWideChar; stdcall;
  TCkFtp2_GetSizeStrAsync = function (objHandle: HCkFtp2; index: Integer): HCkTask; stdcall;
  TCkFtp2_GetSizeStrByName = function (objHandle: HCkFtp2; filename: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getSizeStrByName = function (objHandle: HCkFtp2; filename: PWideChar): PWideChar; stdcall;
  TCkFtp2_GetSizeStrByNameAsync = function (objHandle: HCkFtp2; filename: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetSslServerCert = function (objHandle: HCkFtp2): HCkCert; stdcall;
  TCkFtp2_GetSyncedFiles = procedure (objHandle: HCkFtp2; strTable: HCkStringTable); stdcall;
  TCkFtp2_GetTextDirListing = function (objHandle: HCkFtp2; pattern: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getTextDirListing = function (objHandle: HCkFtp2; pattern: PWideChar): PWideChar; stdcall;
  TCkFtp2_GetTextDirListingAsync = function (objHandle: HCkFtp2; pattern: PWideChar): HCkTask; stdcall;
  TCkFtp2_GetXmlDirListing = function (objHandle: HCkFtp2; pattern: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__getXmlDirListing = function (objHandle: HCkFtp2; pattern: PWideChar): PWideChar; stdcall;
  TCkFtp2_GetXmlDirListingAsync = function (objHandle: HCkFtp2; pattern: PWideChar): HCkTask; stdcall;
  TCkFtp2_LargeFileUpload = function (objHandle: HCkFtp2; localPath: PWideChar; remotePath: PWideChar; chunkSize: Integer): wordbool; stdcall;
  TCkFtp2_LargeFileUploadAsync = function (objHandle: HCkFtp2; localPath: PWideChar; remotePath: PWideChar; chunkSize: Integer): HCkTask; stdcall;
  TCkFtp2_LoadTaskCaller = function (objHandle: HCkFtp2; task: HCkTask): wordbool; stdcall;
  TCkFtp2_LoginAfterConnectOnly = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_LoginAfterConnectOnlyAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_MGetFiles = function (objHandle: HCkFtp2; remotePattern: PWideChar; localDir: PWideChar): Integer; stdcall;
  TCkFtp2_MGetFilesAsync = function (objHandle: HCkFtp2; remotePattern: PWideChar; localDir: PWideChar): HCkTask; stdcall;
  TCkFtp2_MPutFiles = function (objHandle: HCkFtp2; pattern: PWideChar): Integer; stdcall;
  TCkFtp2_MPutFilesAsync = function (objHandle: HCkFtp2; pattern: PWideChar): HCkTask; stdcall;
  TCkFtp2_NlstXml = function (objHandle: HCkFtp2; remoteDirPattern: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__nlstXml = function (objHandle: HCkFtp2; remoteDirPattern: PWideChar): PWideChar; stdcall;
  TCkFtp2_NlstXmlAsync = function (objHandle: HCkFtp2; remoteDirPattern: PWideChar): HCkTask; stdcall;
  TCkFtp2_Noop = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_NoopAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_PutFile = function (objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): wordbool; stdcall;
  TCkFtp2_PutFileAsync = function (objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): HCkTask; stdcall;
  TCkFtp2_PutFileBd = function (objHandle: HCkFtp2; binData: HCkBinData; remoteFilePath: PWideChar): wordbool; stdcall;
  TCkFtp2_PutFileBdAsync = function (objHandle: HCkFtp2; binData: HCkBinData; remoteFilePath: PWideChar): HCkTask; stdcall;
  TCkFtp2_PutFileFromBinaryData = function (objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): wordbool; stdcall;
  TCkFtp2_PutFileFromBinaryDataAsync = function (objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): HCkTask; stdcall;
  TCkFtp2_PutFileFromTextData = function (objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkFtp2_PutFileFromTextDataAsync = function (objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkFtp2_PutFileSb = function (objHandle: HCkFtp2; sb: HCkStringBuilder; charset: PWideChar; includeBom: wordbool; remoteFilePath: PWideChar): wordbool; stdcall;
  TCkFtp2_PutFileSbAsync = function (objHandle: HCkFtp2; sb: HCkStringBuilder; charset: PWideChar; includeBom: wordbool; remoteFilePath: PWideChar): HCkTask; stdcall;
  TCkFtp2_PutPlan = function (objHandle: HCkFtp2; plan: PWideChar; alreadyDoneFilename: PWideChar): wordbool; stdcall;
  TCkFtp2_PutPlanAsync = function (objHandle: HCkFtp2; plan: PWideChar; alreadyDoneFilename: PWideChar): HCkTask; stdcall;
  TCkFtp2_PutTree = function (objHandle: HCkFtp2; localDir: PWideChar): wordbool; stdcall;
  TCkFtp2_PutTreeAsync = function (objHandle: HCkFtp2; localDir: PWideChar): HCkTask; stdcall;
  TCkFtp2_Quote = function (objHandle: HCkFtp2; cmd: PWideChar): wordbool; stdcall;
  TCkFtp2_QuoteAsync = function (objHandle: HCkFtp2; cmd: PWideChar): HCkTask; stdcall;
  TCkFtp2_RemoveRemoteDir = function (objHandle: HCkFtp2; remoteDirPath: PWideChar): wordbool; stdcall;
  TCkFtp2_RemoveRemoteDirAsync = function (objHandle: HCkFtp2; remoteDirPath: PWideChar): HCkTask; stdcall;
  TCkFtp2_RenameRemoteFile = function (objHandle: HCkFtp2; existingRemoteFilePath: PWideChar; newRemoteFilePath: PWideChar): wordbool; stdcall;
  TCkFtp2_RenameRemoteFileAsync = function (objHandle: HCkFtp2; existingRemoteFilePath: PWideChar; newRemoteFilePath: PWideChar): HCkTask; stdcall;
  TCkFtp2_SendCommand = function (objHandle: HCkFtp2; cmd: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__sendCommand = function (objHandle: HCkFtp2; cmd: PWideChar): PWideChar; stdcall;
  TCkFtp2_SendCommandAsync = function (objHandle: HCkFtp2; cmd: PWideChar): HCkTask; stdcall;
  TCkFtp2_SetModeZ = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_SetModeZAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_SetOldestDateStr = procedure (objHandle: HCkFtp2; oldestDateTimeStr: PWideChar); stdcall;
  TCkFtp2_SetOption = function (objHandle: HCkFtp2; option: PWideChar): wordbool; stdcall;
  TCkFtp2_SetPassword = function (objHandle: HCkFtp2; password: HCkSecureString): wordbool; stdcall;
  TCkFtp2_SetRemoteFileDateTimeStr = function (objHandle: HCkFtp2; dateTimeStr: PWideChar; remoteFilename: PWideChar): wordbool; stdcall;
  TCkFtp2_SetRemoteFileDateTimeStrAsync = function (objHandle: HCkFtp2; dateTimeStr: PWideChar; remoteFilename: PWideChar): HCkTask; stdcall;
  TCkFtp2_SetRemoteFileDt = function (objHandle: HCkFtp2; dt: HCkDateTime; remoteFilename: PWideChar): wordbool; stdcall;
  TCkFtp2_SetRemoteFileDtAsync = function (objHandle: HCkFtp2; dt: HCkDateTime; remoteFilename: PWideChar): HCkTask; stdcall;
  TCkFtp2_SetSecurePassword = function (objHandle: HCkFtp2; password: HCkSecureString): wordbool; stdcall;
  TCkFtp2_SetSslCertRequirement = procedure (objHandle: HCkFtp2; reqName: PWideChar; reqValue: PWideChar); stdcall;
  TCkFtp2_SetSslClientCert = function (objHandle: HCkFtp2; cert: HCkCert): wordbool; stdcall;
  TCkFtp2_SetSslClientCertPem = function (objHandle: HCkFtp2; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool; stdcall;
  TCkFtp2_SetSslClientCertPfx = function (objHandle: HCkFtp2; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool; stdcall;
  TCkFtp2_SetTypeAscii = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_SetTypeAsciiAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_SetTypeBinary = function (objHandle: HCkFtp2): wordbool; stdcall;
  TCkFtp2_SetTypeBinaryAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_Site = function (objHandle: HCkFtp2; siteCommand: PWideChar): wordbool; stdcall;
  TCkFtp2_SiteAsync = function (objHandle: HCkFtp2; siteCommand: PWideChar): HCkTask; stdcall;
  TCkFtp2_SleepMs = procedure (objHandle: HCkFtp2; millisec: Integer); stdcall;
  TCkFtp2_Stat = function (objHandle: HCkFtp2; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__stat = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_StatAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;
  TCkFtp2_SyncDeleteRemote = function (objHandle: HCkFtp2; localRoot: PWideChar): wordbool; stdcall;
  TCkFtp2_SyncDeleteRemoteAsync = function (objHandle: HCkFtp2; localRoot: PWideChar): HCkTask; stdcall;
  TCkFtp2_SyncLocalDir = function (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): wordbool; stdcall;
  TCkFtp2_SyncLocalDirAsync = function (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): HCkTask; stdcall;
  TCkFtp2_SyncLocalTree = function (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): wordbool; stdcall;
  TCkFtp2_SyncLocalTreeAsync = function (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): HCkTask; stdcall;
  TCkFtp2_SyncRemoteTree = function (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): wordbool; stdcall;
  TCkFtp2_SyncRemoteTreeAsync = function (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): HCkTask; stdcall;
  TCkFtp2_SyncRemoteTree2 = function (objHandle: HCkFtp2; localDirPath: PWideChar; mode: Integer; bDescend: wordbool; bPreviewOnly: wordbool): wordbool; stdcall;
  TCkFtp2_SyncRemoteTree2Async = function (objHandle: HCkFtp2; localDirPath: PWideChar; mode: Integer; bDescend: wordbool; bPreviewOnly: wordbool): HCkTask; stdcall;
  TCkFtp2_Syst = function (objHandle: HCkFtp2; outStr: HCkString): wordbool; stdcall;
  TCkFtp2__syst = function (objHandle: HCkFtp2): PWideChar; stdcall;
  TCkFtp2_SystAsync = function (objHandle: HCkFtp2): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..437] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkFtp2_Create : HCkFtp2;
begin
  result := TCkFtp2_Create(_map(0, 'CkFtp2_Create'));
end;

procedure CkFtp2_Dispose (handle: HCkFtp2);
begin
  TCkFtp2_Dispose(_map(1, 'CkFtp2_Dispose'))
    (handle);
end;


procedure CkFtp2_SetAbortCheck (objHandle: HCkFtp2; fn: TFtp2AbortCheck);
begin
    TCkFtp2_SetAbortCheck(_map(2, 'CkFtp2_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkFtp2_SetProgressInfo (objHandle: HCkFtp2; fn: TFtp2ProgressInfo);
begin
    TCkFtp2_SetProgressInfo(_map(3, 'CkFtp2_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkFtp2_SetPercentDone (objHandle: HCkFtp2; fn: TFtp2PercentDone);
begin
    TCkFtp2_SetPercentDone(_map(4, 'CkFtp2_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkFtp2_SetTaskCompleted (objHandle: HCkFtp2; fn: TFtp2TaskCompleted);
begin
    TCkFtp2_SetTaskCompleted(_map(5, 'CkFtp2_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkFtp2_getAbortCurrent (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAbortCurrent(_map(6, 'CkFtp2_getAbortCurrent'))
    (objHandle);
end;

procedure CkFtp2_putAbortCurrent (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAbortCurrent(_map(7, 'CkFtp2_putAbortCurrent'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getAccount (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getAccount(_map(8, 'CkFtp2_getAccount'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putAccount (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putAccount(_map(9, 'CkFtp2_putAccount'))
    (objHandle, newPropVal);
end;

function CkFtp2__account (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__account(_map(10, 'CkFtp2__account'))
    (objHandle);
end;

function CkFtp2_getActivePortRangeEnd (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getActivePortRangeEnd(_map(11, 'CkFtp2_getActivePortRangeEnd'))
    (objHandle);
end;

procedure CkFtp2_putActivePortRangeEnd (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putActivePortRangeEnd(_map(12, 'CkFtp2_putActivePortRangeEnd'))
    (objHandle, newPropVal);
end;

function CkFtp2_getActivePortRangeStart (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getActivePortRangeStart(_map(13, 'CkFtp2_getActivePortRangeStart'))
    (objHandle);
end;

procedure CkFtp2_putActivePortRangeStart (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putActivePortRangeStart(_map(14, 'CkFtp2_putActivePortRangeStart'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAllocateSize (objHandle: HCkFtp2): LongWord;
begin
    result := TCkFtp2_getAllocateSize(_map(15, 'CkFtp2_getAllocateSize'))
    (objHandle);
end;

procedure CkFtp2_putAllocateSize (objHandle: HCkFtp2; newPropVal: LongWord);
begin
  TCkFtp2_putAllocateSize(_map(16, 'CkFtp2_putAllocateSize'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAllowMlsd (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAllowMlsd(_map(17, 'CkFtp2_getAllowMlsd'))
    (objHandle);
end;

procedure CkFtp2_putAllowMlsd (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAllowMlsd(_map(18, 'CkFtp2_putAllowMlsd'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAsyncBytesReceived (objHandle: HCkFtp2): LongWord;
begin
    result := TCkFtp2_getAsyncBytesReceived(_map(19, 'CkFtp2_getAsyncBytesReceived'))
    (objHandle);
end;

function CkFtp2_getAsyncBytesReceived64 (objHandle: HCkFtp2): Int64;
begin
    result := TCkFtp2_getAsyncBytesReceived64(_map(20, 'CkFtp2_getAsyncBytesReceived64'))
    (objHandle);
end;

procedure CkFtp2_getAsyncBytesReceivedStr (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getAsyncBytesReceivedStr(_map(21, 'CkFtp2_getAsyncBytesReceivedStr'))
    (objHandle, outPropVal);
end;

function CkFtp2__asyncBytesReceivedStr (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__asyncBytesReceivedStr(_map(22, 'CkFtp2__asyncBytesReceivedStr'))
    (objHandle);
end;

function CkFtp2_getAsyncBytesSent (objHandle: HCkFtp2): LongWord;
begin
    result := TCkFtp2_getAsyncBytesSent(_map(23, 'CkFtp2_getAsyncBytesSent'))
    (objHandle);
end;

function CkFtp2_getAsyncBytesSent64 (objHandle: HCkFtp2): Int64;
begin
    result := TCkFtp2_getAsyncBytesSent64(_map(24, 'CkFtp2_getAsyncBytesSent64'))
    (objHandle);
end;

procedure CkFtp2_getAsyncBytesSentStr (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getAsyncBytesSentStr(_map(25, 'CkFtp2_getAsyncBytesSentStr'))
    (objHandle, outPropVal);
end;

function CkFtp2__asyncBytesSentStr (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__asyncBytesSentStr(_map(26, 'CkFtp2__asyncBytesSentStr'))
    (objHandle);
end;

function CkFtp2_getAuthSsl (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAuthSsl(_map(27, 'CkFtp2_getAuthSsl'))
    (objHandle);
end;

procedure CkFtp2_putAuthSsl (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAuthSsl(_map(28, 'CkFtp2_putAuthSsl'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAuthTls (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAuthTls(_map(29, 'CkFtp2_getAuthTls'))
    (objHandle);
end;

procedure CkFtp2_putAuthTls (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAuthTls(_map(30, 'CkFtp2_putAuthTls'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAutoFeat (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAutoFeat(_map(31, 'CkFtp2_getAutoFeat'))
    (objHandle);
end;

procedure CkFtp2_putAutoFeat (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAutoFeat(_map(32, 'CkFtp2_putAutoFeat'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAutoFix (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAutoFix(_map(33, 'CkFtp2_getAutoFix'))
    (objHandle);
end;

procedure CkFtp2_putAutoFix (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAutoFix(_map(34, 'CkFtp2_putAutoFix'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAutoGetSizeForProgress (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAutoGetSizeForProgress(_map(35, 'CkFtp2_getAutoGetSizeForProgress'))
    (objHandle);
end;

procedure CkFtp2_putAutoGetSizeForProgress (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAutoGetSizeForProgress(_map(36, 'CkFtp2_putAutoGetSizeForProgress'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAutoOptsUtf8 (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAutoOptsUtf8(_map(37, 'CkFtp2_getAutoOptsUtf8'))
    (objHandle);
end;

procedure CkFtp2_putAutoOptsUtf8 (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAutoOptsUtf8(_map(38, 'CkFtp2_putAutoOptsUtf8'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAutoSetUseEpsv (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAutoSetUseEpsv(_map(39, 'CkFtp2_getAutoSetUseEpsv'))
    (objHandle);
end;

procedure CkFtp2_putAutoSetUseEpsv (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAutoSetUseEpsv(_map(40, 'CkFtp2_putAutoSetUseEpsv'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAutoSyst (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAutoSyst(_map(41, 'CkFtp2_getAutoSyst'))
    (objHandle);
end;

procedure CkFtp2_putAutoSyst (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAutoSyst(_map(42, 'CkFtp2_putAutoSyst'))
    (objHandle, newPropVal);
end;

function CkFtp2_getAutoXcrc (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getAutoXcrc(_map(43, 'CkFtp2_getAutoXcrc'))
    (objHandle);
end;

procedure CkFtp2_putAutoXcrc (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putAutoXcrc(_map(44, 'CkFtp2_putAutoXcrc'))
    (objHandle, newPropVal);
end;

function CkFtp2_getBandwidthThrottleDown (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getBandwidthThrottleDown(_map(45, 'CkFtp2_getBandwidthThrottleDown'))
    (objHandle);
end;

procedure CkFtp2_putBandwidthThrottleDown (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putBandwidthThrottleDown(_map(46, 'CkFtp2_putBandwidthThrottleDown'))
    (objHandle, newPropVal);
end;

function CkFtp2_getBandwidthThrottleUp (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getBandwidthThrottleUp(_map(47, 'CkFtp2_getBandwidthThrottleUp'))
    (objHandle);
end;

procedure CkFtp2_putBandwidthThrottleUp (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putBandwidthThrottleUp(_map(48, 'CkFtp2_putBandwidthThrottleUp'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getClientIpAddress (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getClientIpAddress(_map(49, 'CkFtp2_getClientIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putClientIpAddress (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putClientIpAddress(_map(50, 'CkFtp2_putClientIpAddress'))
    (objHandle, newPropVal);
end;

function CkFtp2__clientIpAddress (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__clientIpAddress(_map(51, 'CkFtp2__clientIpAddress'))
    (objHandle);
end;

procedure CkFtp2_getCommandCharset (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getCommandCharset(_map(52, 'CkFtp2_getCommandCharset'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putCommandCharset (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putCommandCharset(_map(53, 'CkFtp2_putCommandCharset'))
    (objHandle, newPropVal);
end;

function CkFtp2__commandCharset (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__commandCharset(_map(54, 'CkFtp2__commandCharset'))
    (objHandle);
end;

function CkFtp2_getConnectFailReason (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getConnectFailReason(_map(55, 'CkFtp2_getConnectFailReason'))
    (objHandle);
end;

function CkFtp2_getConnectTimeout (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getConnectTimeout(_map(56, 'CkFtp2_getConnectTimeout'))
    (objHandle);
end;

procedure CkFtp2_putConnectTimeout (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putConnectTimeout(_map(57, 'CkFtp2_putConnectTimeout'))
    (objHandle, newPropVal);
end;

function CkFtp2_getConnectVerified (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getConnectVerified(_map(58, 'CkFtp2_getConnectVerified'))
    (objHandle);
end;

function CkFtp2_getCrlfMode (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getCrlfMode(_map(59, 'CkFtp2_getCrlfMode'))
    (objHandle);
end;

procedure CkFtp2_putCrlfMode (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putCrlfMode(_map(60, 'CkFtp2_putCrlfMode'))
    (objHandle, newPropVal);
end;

function CkFtp2_getCurBytesReceived (objHandle: HCkFtp2): LongWord;
begin
    result := TCkFtp2_getCurBytesReceived(_map(61, 'CkFtp2_getCurBytesReceived'))
    (objHandle);
end;

function CkFtp2_getCurBytesReceived64 (objHandle: HCkFtp2): Int64;
begin
    result := TCkFtp2_getCurBytesReceived64(_map(62, 'CkFtp2_getCurBytesReceived64'))
    (objHandle);
end;

procedure CkFtp2_getCurBytesReceivedStr (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getCurBytesReceivedStr(_map(63, 'CkFtp2_getCurBytesReceivedStr'))
    (objHandle, outPropVal);
end;

function CkFtp2__curBytesReceivedStr (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__curBytesReceivedStr(_map(64, 'CkFtp2__curBytesReceivedStr'))
    (objHandle);
end;

function CkFtp2_getCurBytesSent (objHandle: HCkFtp2): LongWord;
begin
    result := TCkFtp2_getCurBytesSent(_map(65, 'CkFtp2_getCurBytesSent'))
    (objHandle);
end;

function CkFtp2_getCurBytesSent64 (objHandle: HCkFtp2): Int64;
begin
    result := TCkFtp2_getCurBytesSent64(_map(66, 'CkFtp2_getCurBytesSent64'))
    (objHandle);
end;

procedure CkFtp2_getCurBytesSentStr (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getCurBytesSentStr(_map(67, 'CkFtp2_getCurBytesSentStr'))
    (objHandle, outPropVal);
end;

function CkFtp2__curBytesSentStr (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__curBytesSentStr(_map(68, 'CkFtp2__curBytesSentStr'))
    (objHandle);
end;

procedure CkFtp2_getDataProtection (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getDataProtection(_map(69, 'CkFtp2_getDataProtection'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putDataProtection (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putDataProtection(_map(70, 'CkFtp2_putDataProtection'))
    (objHandle, newPropVal);
end;

function CkFtp2__dataProtection (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__dataProtection(_map(71, 'CkFtp2__dataProtection'))
    (objHandle);
end;

procedure CkFtp2_getDebugLogFilePath (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getDebugLogFilePath(_map(72, 'CkFtp2_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putDebugLogFilePath (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putDebugLogFilePath(_map(73, 'CkFtp2_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkFtp2__debugLogFilePath (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__debugLogFilePath(_map(74, 'CkFtp2__debugLogFilePath'))
    (objHandle);
end;

procedure CkFtp2_getDirListingCharset (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getDirListingCharset(_map(75, 'CkFtp2_getDirListingCharset'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putDirListingCharset (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putDirListingCharset(_map(76, 'CkFtp2_putDirListingCharset'))
    (objHandle, newPropVal);
end;

function CkFtp2__dirListingCharset (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__dirListingCharset(_map(77, 'CkFtp2__dirListingCharset'))
    (objHandle);
end;

function CkFtp2_getDownloadTransferRate (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getDownloadTransferRate(_map(78, 'CkFtp2_getDownloadTransferRate'))
    (objHandle);
end;

procedure CkFtp2_getForcePortIpAddress (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getForcePortIpAddress(_map(79, 'CkFtp2_getForcePortIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putForcePortIpAddress (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putForcePortIpAddress(_map(80, 'CkFtp2_putForcePortIpAddress'))
    (objHandle, newPropVal);
end;

function CkFtp2__forcePortIpAddress (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__forcePortIpAddress(_map(81, 'CkFtp2__forcePortIpAddress'))
    (objHandle);
end;

procedure CkFtp2_getGreeting (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getGreeting(_map(82, 'CkFtp2_getGreeting'))
    (objHandle, outPropVal);
end;

function CkFtp2__greeting (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__greeting(_map(83, 'CkFtp2__greeting'))
    (objHandle);
end;

function CkFtp2_getHasModeZ (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getHasModeZ(_map(84, 'CkFtp2_getHasModeZ'))
    (objHandle);
end;

function CkFtp2_getHeartbeatMs (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getHeartbeatMs(_map(85, 'CkFtp2_getHeartbeatMs'))
    (objHandle);
end;

procedure CkFtp2_putHeartbeatMs (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putHeartbeatMs(_map(86, 'CkFtp2_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getHostname (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getHostname(_map(87, 'CkFtp2_getHostname'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putHostname (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putHostname(_map(88, 'CkFtp2_putHostname'))
    (objHandle, newPropVal);
end;

function CkFtp2__hostname (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__hostname(_map(89, 'CkFtp2__hostname'))
    (objHandle);
end;

procedure CkFtp2_getHttpProxyAuthMethod (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getHttpProxyAuthMethod(_map(90, 'CkFtp2_getHttpProxyAuthMethod'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putHttpProxyAuthMethod (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putHttpProxyAuthMethod(_map(91, 'CkFtp2_putHttpProxyAuthMethod'))
    (objHandle, newPropVal);
end;

function CkFtp2__httpProxyAuthMethod (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__httpProxyAuthMethod(_map(92, 'CkFtp2__httpProxyAuthMethod'))
    (objHandle);
end;

procedure CkFtp2_getHttpProxyDomain (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getHttpProxyDomain(_map(93, 'CkFtp2_getHttpProxyDomain'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putHttpProxyDomain (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putHttpProxyDomain(_map(94, 'CkFtp2_putHttpProxyDomain'))
    (objHandle, newPropVal);
end;

function CkFtp2__httpProxyDomain (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__httpProxyDomain(_map(95, 'CkFtp2__httpProxyDomain'))
    (objHandle);
end;

procedure CkFtp2_getHttpProxyHostname (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getHttpProxyHostname(_map(96, 'CkFtp2_getHttpProxyHostname'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putHttpProxyHostname (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putHttpProxyHostname(_map(97, 'CkFtp2_putHttpProxyHostname'))
    (objHandle, newPropVal);
end;

function CkFtp2__httpProxyHostname (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__httpProxyHostname(_map(98, 'CkFtp2__httpProxyHostname'))
    (objHandle);
end;

procedure CkFtp2_getHttpProxyPassword (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getHttpProxyPassword(_map(99, 'CkFtp2_getHttpProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putHttpProxyPassword (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putHttpProxyPassword(_map(100, 'CkFtp2_putHttpProxyPassword'))
    (objHandle, newPropVal);
end;

function CkFtp2__httpProxyPassword (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__httpProxyPassword(_map(101, 'CkFtp2__httpProxyPassword'))
    (objHandle);
end;

function CkFtp2_getHttpProxyPort (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getHttpProxyPort(_map(102, 'CkFtp2_getHttpProxyPort'))
    (objHandle);
end;

procedure CkFtp2_putHttpProxyPort (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putHttpProxyPort(_map(103, 'CkFtp2_putHttpProxyPort'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getHttpProxyUsername (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getHttpProxyUsername(_map(104, 'CkFtp2_getHttpProxyUsername'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putHttpProxyUsername (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putHttpProxyUsername(_map(105, 'CkFtp2_putHttpProxyUsername'))
    (objHandle, newPropVal);
end;

function CkFtp2__httpProxyUsername (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__httpProxyUsername(_map(106, 'CkFtp2__httpProxyUsername'))
    (objHandle);
end;

function CkFtp2_getIdleTimeoutMs (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getIdleTimeoutMs(_map(107, 'CkFtp2_getIdleTimeoutMs'))
    (objHandle);
end;

procedure CkFtp2_putIdleTimeoutMs (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putIdleTimeoutMs(_map(108, 'CkFtp2_putIdleTimeoutMs'))
    (objHandle, newPropVal);
end;

function CkFtp2_getIsConnected (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getIsConnected(_map(109, 'CkFtp2_getIsConnected'))
    (objHandle);
end;

function CkFtp2_getKeepSessionLog (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getKeepSessionLog(_map(110, 'CkFtp2_getKeepSessionLog'))
    (objHandle);
end;

procedure CkFtp2_putKeepSessionLog (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putKeepSessionLog(_map(111, 'CkFtp2_putKeepSessionLog'))
    (objHandle, newPropVal);
end;

function CkFtp2_getLargeFileMeasures (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getLargeFileMeasures(_map(112, 'CkFtp2_getLargeFileMeasures'))
    (objHandle);
end;

procedure CkFtp2_putLargeFileMeasures (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putLargeFileMeasures(_map(113, 'CkFtp2_putLargeFileMeasures'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getLastErrorHtml (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getLastErrorHtml(_map(114, 'CkFtp2_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkFtp2__lastErrorHtml (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__lastErrorHtml(_map(115, 'CkFtp2__lastErrorHtml'))
    (objHandle);
end;

procedure CkFtp2_getLastErrorText (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getLastErrorText(_map(116, 'CkFtp2_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkFtp2__lastErrorText (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__lastErrorText(_map(117, 'CkFtp2__lastErrorText'))
    (objHandle);
end;

procedure CkFtp2_getLastErrorXml (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getLastErrorXml(_map(118, 'CkFtp2_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkFtp2__lastErrorXml (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__lastErrorXml(_map(119, 'CkFtp2__lastErrorXml'))
    (objHandle);
end;

function CkFtp2_getLastMethodSuccess (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getLastMethodSuccess(_map(120, 'CkFtp2_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkFtp2_putLastMethodSuccess (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putLastMethodSuccess(_map(121, 'CkFtp2_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getLastReply (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getLastReply(_map(122, 'CkFtp2_getLastReply'))
    (objHandle, outPropVal);
end;

function CkFtp2__lastReply (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__lastReply(_map(123, 'CkFtp2__lastReply'))
    (objHandle);
end;

procedure CkFtp2_getListPattern (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getListPattern(_map(124, 'CkFtp2_getListPattern'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putListPattern (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putListPattern(_map(125, 'CkFtp2_putListPattern'))
    (objHandle, newPropVal);
end;

function CkFtp2__listPattern (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__listPattern(_map(126, 'CkFtp2__listPattern'))
    (objHandle);
end;

function CkFtp2_getLoginVerified (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getLoginVerified(_map(127, 'CkFtp2_getLoginVerified'))
    (objHandle);
end;

function CkFtp2_getPartialTransfer (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getPartialTransfer(_map(128, 'CkFtp2_getPartialTransfer'))
    (objHandle);
end;

function CkFtp2_getPassive (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getPassive(_map(129, 'CkFtp2_getPassive'))
    (objHandle);
end;

procedure CkFtp2_putPassive (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putPassive(_map(130, 'CkFtp2_putPassive'))
    (objHandle, newPropVal);
end;

function CkFtp2_getPassiveUseHostAddr (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getPassiveUseHostAddr(_map(131, 'CkFtp2_getPassiveUseHostAddr'))
    (objHandle);
end;

procedure CkFtp2_putPassiveUseHostAddr (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putPassiveUseHostAddr(_map(132, 'CkFtp2_putPassiveUseHostAddr'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getPassword (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getPassword(_map(133, 'CkFtp2_getPassword'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putPassword (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putPassword(_map(134, 'CkFtp2_putPassword'))
    (objHandle, newPropVal);
end;

function CkFtp2__password (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__password(_map(135, 'CkFtp2__password'))
    (objHandle);
end;

function CkFtp2_getPercentDoneScale (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getPercentDoneScale(_map(136, 'CkFtp2_getPercentDoneScale'))
    (objHandle);
end;

procedure CkFtp2_putPercentDoneScale (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putPercentDoneScale(_map(137, 'CkFtp2_putPercentDoneScale'))
    (objHandle, newPropVal);
end;

function CkFtp2_getPort (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getPort(_map(138, 'CkFtp2_getPort'))
    (objHandle);
end;

procedure CkFtp2_putPort (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putPort(_map(139, 'CkFtp2_putPort'))
    (objHandle, newPropVal);
end;

function CkFtp2_getPreferIpv6 (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getPreferIpv6(_map(140, 'CkFtp2_getPreferIpv6'))
    (objHandle);
end;

procedure CkFtp2_putPreferIpv6 (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putPreferIpv6(_map(141, 'CkFtp2_putPreferIpv6'))
    (objHandle, newPropVal);
end;

function CkFtp2_getPreferNlst (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getPreferNlst(_map(142, 'CkFtp2_getPreferNlst'))
    (objHandle);
end;

procedure CkFtp2_putPreferNlst (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putPreferNlst(_map(143, 'CkFtp2_putPreferNlst'))
    (objHandle, newPropVal);
end;

function CkFtp2_getProgressMonSize (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getProgressMonSize(_map(144, 'CkFtp2_getProgressMonSize'))
    (objHandle);
end;

procedure CkFtp2_putProgressMonSize (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putProgressMonSize(_map(145, 'CkFtp2_putProgressMonSize'))
    (objHandle, newPropVal);
end;

function CkFtp2_getProgressMonSize64 (objHandle: HCkFtp2): Int64;
begin
    result := TCkFtp2_getProgressMonSize64(_map(146, 'CkFtp2_getProgressMonSize64'))
    (objHandle);
end;

procedure CkFtp2_putProgressMonSize64 (objHandle: HCkFtp2; newPropVal: Int64);
begin
  TCkFtp2_putProgressMonSize64(_map(147, 'CkFtp2_putProgressMonSize64'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getProxyHostname (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getProxyHostname(_map(148, 'CkFtp2_getProxyHostname'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putProxyHostname (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putProxyHostname(_map(149, 'CkFtp2_putProxyHostname'))
    (objHandle, newPropVal);
end;

function CkFtp2__proxyHostname (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__proxyHostname(_map(150, 'CkFtp2__proxyHostname'))
    (objHandle);
end;

function CkFtp2_getProxyMethod (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getProxyMethod(_map(151, 'CkFtp2_getProxyMethod'))
    (objHandle);
end;

procedure CkFtp2_putProxyMethod (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putProxyMethod(_map(152, 'CkFtp2_putProxyMethod'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getProxyPassword (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getProxyPassword(_map(153, 'CkFtp2_getProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putProxyPassword (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putProxyPassword(_map(154, 'CkFtp2_putProxyPassword'))
    (objHandle, newPropVal);
end;

function CkFtp2__proxyPassword (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__proxyPassword(_map(155, 'CkFtp2__proxyPassword'))
    (objHandle);
end;

function CkFtp2_getProxyPort (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getProxyPort(_map(156, 'CkFtp2_getProxyPort'))
    (objHandle);
end;

procedure CkFtp2_putProxyPort (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putProxyPort(_map(157, 'CkFtp2_putProxyPort'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getProxyUsername (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getProxyUsername(_map(158, 'CkFtp2_getProxyUsername'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putProxyUsername (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putProxyUsername(_map(159, 'CkFtp2_putProxyUsername'))
    (objHandle, newPropVal);
end;

function CkFtp2__proxyUsername (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__proxyUsername(_map(160, 'CkFtp2__proxyUsername'))
    (objHandle);
end;

function CkFtp2_getReadTimeout (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getReadTimeout(_map(161, 'CkFtp2_getReadTimeout'))
    (objHandle);
end;

procedure CkFtp2_putReadTimeout (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putReadTimeout(_map(162, 'CkFtp2_putReadTimeout'))
    (objHandle, newPropVal);
end;

function CkFtp2_getRequireSslCertVerify (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getRequireSslCertVerify(_map(163, 'CkFtp2_getRequireSslCertVerify'))
    (objHandle);
end;

procedure CkFtp2_putRequireSslCertVerify (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putRequireSslCertVerify(_map(164, 'CkFtp2_putRequireSslCertVerify'))
    (objHandle, newPropVal);
end;

function CkFtp2_getRestartNext (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getRestartNext(_map(165, 'CkFtp2_getRestartNext'))
    (objHandle);
end;

procedure CkFtp2_putRestartNext (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putRestartNext(_map(166, 'CkFtp2_putRestartNext'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getSessionLog (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSessionLog(_map(167, 'CkFtp2_getSessionLog'))
    (objHandle, outPropVal);
end;

function CkFtp2__sessionLog (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__sessionLog(_map(168, 'CkFtp2__sessionLog'))
    (objHandle);
end;

procedure CkFtp2_getSocksHostname (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSocksHostname(_map(169, 'CkFtp2_getSocksHostname'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putSocksHostname (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putSocksHostname(_map(170, 'CkFtp2_putSocksHostname'))
    (objHandle, newPropVal);
end;

function CkFtp2__socksHostname (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__socksHostname(_map(171, 'CkFtp2__socksHostname'))
    (objHandle);
end;

procedure CkFtp2_getSocksPassword (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSocksPassword(_map(172, 'CkFtp2_getSocksPassword'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putSocksPassword (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putSocksPassword(_map(173, 'CkFtp2_putSocksPassword'))
    (objHandle, newPropVal);
end;

function CkFtp2__socksPassword (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__socksPassword(_map(174, 'CkFtp2__socksPassword'))
    (objHandle);
end;

function CkFtp2_getSocksPort (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getSocksPort(_map(175, 'CkFtp2_getSocksPort'))
    (objHandle);
end;

procedure CkFtp2_putSocksPort (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putSocksPort(_map(176, 'CkFtp2_putSocksPort'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getSocksUsername (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSocksUsername(_map(177, 'CkFtp2_getSocksUsername'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putSocksUsername (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putSocksUsername(_map(178, 'CkFtp2_putSocksUsername'))
    (objHandle, newPropVal);
end;

function CkFtp2__socksUsername (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__socksUsername(_map(179, 'CkFtp2__socksUsername'))
    (objHandle);
end;

function CkFtp2_getSocksVersion (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getSocksVersion(_map(180, 'CkFtp2_getSocksVersion'))
    (objHandle);
end;

procedure CkFtp2_putSocksVersion (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putSocksVersion(_map(181, 'CkFtp2_putSocksVersion'))
    (objHandle, newPropVal);
end;

function CkFtp2_getSoRcvBuf (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getSoRcvBuf(_map(182, 'CkFtp2_getSoRcvBuf'))
    (objHandle);
end;

procedure CkFtp2_putSoRcvBuf (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putSoRcvBuf(_map(183, 'CkFtp2_putSoRcvBuf'))
    (objHandle, newPropVal);
end;

function CkFtp2_getSoSndBuf (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getSoSndBuf(_map(184, 'CkFtp2_getSoSndBuf'))
    (objHandle);
end;

procedure CkFtp2_putSoSndBuf (objHandle: HCkFtp2; newPropVal: Integer);
begin
  TCkFtp2_putSoSndBuf(_map(185, 'CkFtp2_putSoSndBuf'))
    (objHandle, newPropVal);
end;

function CkFtp2_getSsl (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getSsl(_map(186, 'CkFtp2_getSsl'))
    (objHandle);
end;

procedure CkFtp2_putSsl (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putSsl(_map(187, 'CkFtp2_putSsl'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getSslAllowedCiphers (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSslAllowedCiphers(_map(188, 'CkFtp2_getSslAllowedCiphers'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putSslAllowedCiphers (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putSslAllowedCiphers(_map(189, 'CkFtp2_putSslAllowedCiphers'))
    (objHandle, newPropVal);
end;

function CkFtp2__sslAllowedCiphers (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__sslAllowedCiphers(_map(190, 'CkFtp2__sslAllowedCiphers'))
    (objHandle);
end;

procedure CkFtp2_getSslProtocol (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSslProtocol(_map(191, 'CkFtp2_getSslProtocol'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putSslProtocol (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putSslProtocol(_map(192, 'CkFtp2_putSslProtocol'))
    (objHandle, newPropVal);
end;

function CkFtp2__sslProtocol (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__sslProtocol(_map(193, 'CkFtp2__sslProtocol'))
    (objHandle);
end;

function CkFtp2_getSslServerCertVerified (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getSslServerCertVerified(_map(194, 'CkFtp2_getSslServerCertVerified'))
    (objHandle);
end;

function CkFtp2_getSyncCreateAllLocalDirs (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getSyncCreateAllLocalDirs(_map(195, 'CkFtp2_getSyncCreateAllLocalDirs'))
    (objHandle);
end;

procedure CkFtp2_putSyncCreateAllLocalDirs (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putSyncCreateAllLocalDirs(_map(196, 'CkFtp2_putSyncCreateAllLocalDirs'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getSyncMustMatch (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSyncMustMatch(_map(197, 'CkFtp2_getSyncMustMatch'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putSyncMustMatch (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putSyncMustMatch(_map(198, 'CkFtp2_putSyncMustMatch'))
    (objHandle, newPropVal);
end;

function CkFtp2__syncMustMatch (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__syncMustMatch(_map(199, 'CkFtp2__syncMustMatch'))
    (objHandle);
end;

procedure CkFtp2_getSyncMustMatchDir (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSyncMustMatchDir(_map(200, 'CkFtp2_getSyncMustMatchDir'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putSyncMustMatchDir (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putSyncMustMatchDir(_map(201, 'CkFtp2_putSyncMustMatchDir'))
    (objHandle, newPropVal);
end;

function CkFtp2__syncMustMatchDir (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__syncMustMatchDir(_map(202, 'CkFtp2__syncMustMatchDir'))
    (objHandle);
end;

procedure CkFtp2_getSyncMustNotMatch (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSyncMustNotMatch(_map(203, 'CkFtp2_getSyncMustNotMatch'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putSyncMustNotMatch (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putSyncMustNotMatch(_map(204, 'CkFtp2_putSyncMustNotMatch'))
    (objHandle, newPropVal);
end;

function CkFtp2__syncMustNotMatch (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__syncMustNotMatch(_map(205, 'CkFtp2__syncMustNotMatch'))
    (objHandle);
end;

procedure CkFtp2_getSyncMustNotMatchDir (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSyncMustNotMatchDir(_map(206, 'CkFtp2_getSyncMustNotMatchDir'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putSyncMustNotMatchDir (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putSyncMustNotMatchDir(_map(207, 'CkFtp2_putSyncMustNotMatchDir'))
    (objHandle, newPropVal);
end;

function CkFtp2__syncMustNotMatchDir (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__syncMustNotMatchDir(_map(208, 'CkFtp2__syncMustNotMatchDir'))
    (objHandle);
end;

procedure CkFtp2_getSyncPreview (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getSyncPreview(_map(209, 'CkFtp2_getSyncPreview'))
    (objHandle, outPropVal);
end;

function CkFtp2__syncPreview (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__syncPreview(_map(210, 'CkFtp2__syncPreview'))
    (objHandle);
end;

procedure CkFtp2_getTlsCipherSuite (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getTlsCipherSuite(_map(211, 'CkFtp2_getTlsCipherSuite'))
    (objHandle, outPropVal);
end;

function CkFtp2__tlsCipherSuite (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__tlsCipherSuite(_map(212, 'CkFtp2__tlsCipherSuite'))
    (objHandle);
end;

procedure CkFtp2_getTlsPinSet (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getTlsPinSet(_map(213, 'CkFtp2_getTlsPinSet'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putTlsPinSet (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putTlsPinSet(_map(214, 'CkFtp2_putTlsPinSet'))
    (objHandle, newPropVal);
end;

function CkFtp2__tlsPinSet (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__tlsPinSet(_map(215, 'CkFtp2__tlsPinSet'))
    (objHandle);
end;

procedure CkFtp2_getTlsVersion (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getTlsVersion(_map(216, 'CkFtp2_getTlsVersion'))
    (objHandle, outPropVal);
end;

function CkFtp2__tlsVersion (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__tlsVersion(_map(217, 'CkFtp2__tlsVersion'))
    (objHandle);
end;

procedure CkFtp2_getUncommonOptions (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getUncommonOptions(_map(218, 'CkFtp2_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putUncommonOptions (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putUncommonOptions(_map(219, 'CkFtp2_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkFtp2__uncommonOptions (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__uncommonOptions(_map(220, 'CkFtp2__uncommonOptions'))
    (objHandle);
end;

function CkFtp2_getUploadTransferRate (objHandle: HCkFtp2): Integer;
begin
    result := TCkFtp2_getUploadTransferRate(_map(221, 'CkFtp2_getUploadTransferRate'))
    (objHandle);
end;

function CkFtp2_getUseEpsv (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getUseEpsv(_map(222, 'CkFtp2_getUseEpsv'))
    (objHandle);
end;

procedure CkFtp2_putUseEpsv (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putUseEpsv(_map(223, 'CkFtp2_putUseEpsv'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getUsername (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getUsername(_map(224, 'CkFtp2_getUsername'))
    (objHandle, outPropVal);
end;

procedure CkFtp2_putUsername (objHandle: HCkFtp2; newPropVal: PWideChar);
begin
  TCkFtp2_putUsername(_map(225, 'CkFtp2_putUsername'))
    (objHandle, newPropVal);
end;

function CkFtp2__username (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__username(_map(226, 'CkFtp2__username'))
    (objHandle);
end;

function CkFtp2_getVerboseLogging (objHandle: HCkFtp2): wordbool;
begin
    result := TCkFtp2_getVerboseLogging(_map(227, 'CkFtp2_getVerboseLogging'))
    (objHandle);
end;

procedure CkFtp2_putVerboseLogging (objHandle: HCkFtp2; newPropVal: wordbool);
begin
  TCkFtp2_putVerboseLogging(_map(228, 'CkFtp2_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkFtp2_getVersion (objHandle: HCkFtp2; outPropVal: HCkString);
begin
  TCkFtp2_getVersion(_map(229, 'CkFtp2_getVersion'))
    (objHandle, outPropVal);
end;

function CkFtp2__version (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__version(_map(230, 'CkFtp2__version'))
    (objHandle);
end;

function CkFtp2_AppendFile (objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): wordbool;
begin
  result := TCkFtp2_AppendFile(_map(231, 'CkFtp2_AppendFile'))
    (objHandle, localFilePath, remoteFilePath);
end;

function CkFtp2_AppendFileAsync (objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): HCkTask;
begin
  result := TCkFtp2_AppendFileAsync(_map(232, 'CkFtp2_AppendFileAsync'))
    (objHandle, localFilePath, remoteFilePath);
end;

function CkFtp2_AppendFileBd (objHandle: HCkFtp2; remoteFilename: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkFtp2_AppendFileBd(_map(233, 'CkFtp2_AppendFileBd'))
    (objHandle, remoteFilename, bd);
end;

function CkFtp2_AppendFileBdAsync (objHandle: HCkFtp2; remoteFilename: PWideChar; bd: HCkBinData): HCkTask;
begin
  result := TCkFtp2_AppendFileBdAsync(_map(234, 'CkFtp2_AppendFileBdAsync'))
    (objHandle, remoteFilename, bd);
end;

function CkFtp2_AppendFileFromBinaryData (objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): wordbool;
begin
  result := TCkFtp2_AppendFileFromBinaryData(_map(235, 'CkFtp2_AppendFileFromBinaryData'))
    (objHandle, remoteFilename, content);
end;

function CkFtp2_AppendFileFromBinaryDataAsync (objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): HCkTask;
begin
  result := TCkFtp2_AppendFileFromBinaryDataAsync(_map(236, 'CkFtp2_AppendFileFromBinaryDataAsync'))
    (objHandle, remoteFilename, content);
end;

function CkFtp2_AppendFileFromTextData (objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkFtp2_AppendFileFromTextData(_map(237, 'CkFtp2_AppendFileFromTextData'))
    (objHandle, remoteFilename, textData, charset);
end;

function CkFtp2_AppendFileFromTextDataAsync (objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkFtp2_AppendFileFromTextDataAsync(_map(238, 'CkFtp2_AppendFileFromTextDataAsync'))
    (objHandle, remoteFilename, textData, charset);
end;

function CkFtp2_AppendFileSb (objHandle: HCkFtp2; remoteFilename: PWideChar; sb: HCkStringBuilder; charset: PWideChar): wordbool;
begin
  result := TCkFtp2_AppendFileSb(_map(239, 'CkFtp2_AppendFileSb'))
    (objHandle, remoteFilename, sb, charset);
end;

function CkFtp2_AppendFileSbAsync (objHandle: HCkFtp2; remoteFilename: PWideChar; sb: HCkStringBuilder; charset: PWideChar): HCkTask;
begin
  result := TCkFtp2_AppendFileSbAsync(_map(240, 'CkFtp2_AppendFileSbAsync'))
    (objHandle, remoteFilename, sb, charset);
end;

function CkFtp2_ChangeRemoteDir (objHandle: HCkFtp2; remoteDirPath: PWideChar): wordbool;
begin
  result := TCkFtp2_ChangeRemoteDir(_map(241, 'CkFtp2_ChangeRemoteDir'))
    (objHandle, remoteDirPath);
end;

function CkFtp2_ChangeRemoteDirAsync (objHandle: HCkFtp2; remoteDirPath: PWideChar): HCkTask;
begin
  result := TCkFtp2_ChangeRemoteDirAsync(_map(242, 'CkFtp2_ChangeRemoteDirAsync'))
    (objHandle, remoteDirPath);
end;

function CkFtp2_CheckConnection (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_CheckConnection(_map(243, 'CkFtp2_CheckConnection'))
    (objHandle);
end;

function CkFtp2_CheckConnectionAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_CheckConnectionAsync(_map(244, 'CkFtp2_CheckConnectionAsync'))
    (objHandle);
end;

function CkFtp2_ClearControlChannel (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_ClearControlChannel(_map(245, 'CkFtp2_ClearControlChannel'))
    (objHandle);
end;

function CkFtp2_ClearControlChannelAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_ClearControlChannelAsync(_map(246, 'CkFtp2_ClearControlChannelAsync'))
    (objHandle);
end;

procedure CkFtp2_ClearDirCache (objHandle: HCkFtp2);
begin
  TCkFtp2_ClearDirCache(_map(247, 'CkFtp2_ClearDirCache'))
    (objHandle);
end;

procedure CkFtp2_ClearSessionLog (objHandle: HCkFtp2);
begin
  TCkFtp2_ClearSessionLog(_map(248, 'CkFtp2_ClearSessionLog'))
    (objHandle);
end;

function CkFtp2_Connect (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_Connect(_map(249, 'CkFtp2_Connect'))
    (objHandle);
end;

function CkFtp2_ConnectAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_ConnectAsync(_map(250, 'CkFtp2_ConnectAsync'))
    (objHandle);
end;

function CkFtp2_ConnectOnly (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_ConnectOnly(_map(251, 'CkFtp2_ConnectOnly'))
    (objHandle);
end;

function CkFtp2_ConnectOnlyAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_ConnectOnlyAsync(_map(252, 'CkFtp2_ConnectOnlyAsync'))
    (objHandle);
end;

function CkFtp2_ConvertToTls (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_ConvertToTls(_map(253, 'CkFtp2_ConvertToTls'))
    (objHandle);
end;

function CkFtp2_ConvertToTlsAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_ConvertToTlsAsync(_map(254, 'CkFtp2_ConvertToTlsAsync'))
    (objHandle);
end;

function CkFtp2_CreatePlan (objHandle: HCkFtp2; localDir: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_CreatePlan(_map(255, 'CkFtp2_CreatePlan'))
    (objHandle, localDir, outStr);
end;

function CkFtp2__createPlan (objHandle: HCkFtp2; localDir: PWideChar): PWideChar;
begin
  result := TCkFtp2__createPlan(_map(256, 'CkFtp2__createPlan'))
    (objHandle, localDir);
end;

function CkFtp2_CreatePlanAsync (objHandle: HCkFtp2; localDir: PWideChar): HCkTask;
begin
  result := TCkFtp2_CreatePlanAsync(_map(257, 'CkFtp2_CreatePlanAsync'))
    (objHandle, localDir);
end;

function CkFtp2_CreateRemoteDir (objHandle: HCkFtp2; remoteDirPath: PWideChar): wordbool;
begin
  result := TCkFtp2_CreateRemoteDir(_map(258, 'CkFtp2_CreateRemoteDir'))
    (objHandle, remoteDirPath);
end;

function CkFtp2_CreateRemoteDirAsync (objHandle: HCkFtp2; remoteDirPath: PWideChar): HCkTask;
begin
  result := TCkFtp2_CreateRemoteDirAsync(_map(259, 'CkFtp2_CreateRemoteDirAsync'))
    (objHandle, remoteDirPath);
end;

function CkFtp2_DeleteMatching (objHandle: HCkFtp2; remotePattern: PWideChar): Integer;
begin
  result := TCkFtp2_DeleteMatching(_map(260, 'CkFtp2_DeleteMatching'))
    (objHandle, remotePattern);
end;

function CkFtp2_DeleteMatchingAsync (objHandle: HCkFtp2; remotePattern: PWideChar): HCkTask;
begin
  result := TCkFtp2_DeleteMatchingAsync(_map(261, 'CkFtp2_DeleteMatchingAsync'))
    (objHandle, remotePattern);
end;

function CkFtp2_DeleteRemoteFile (objHandle: HCkFtp2; remoteFilePath: PWideChar): wordbool;
begin
  result := TCkFtp2_DeleteRemoteFile(_map(262, 'CkFtp2_DeleteRemoteFile'))
    (objHandle, remoteFilePath);
end;

function CkFtp2_DeleteRemoteFileAsync (objHandle: HCkFtp2; remoteFilePath: PWideChar): HCkTask;
begin
  result := TCkFtp2_DeleteRemoteFileAsync(_map(263, 'CkFtp2_DeleteRemoteFileAsync'))
    (objHandle, remoteFilePath);
end;

function CkFtp2_DeleteTree (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_DeleteTree(_map(264, 'CkFtp2_DeleteTree'))
    (objHandle);
end;

function CkFtp2_DeleteTreeAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_DeleteTreeAsync(_map(265, 'CkFtp2_DeleteTreeAsync'))
    (objHandle);
end;

function CkFtp2_DetermineProxyMethod (objHandle: HCkFtp2): Integer;
begin
  result := TCkFtp2_DetermineProxyMethod(_map(266, 'CkFtp2_DetermineProxyMethod'))
    (objHandle);
end;

function CkFtp2_DetermineProxyMethodAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_DetermineProxyMethodAsync(_map(267, 'CkFtp2_DetermineProxyMethodAsync'))
    (objHandle);
end;

function CkFtp2_DetermineSettings (objHandle: HCkFtp2; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_DetermineSettings(_map(268, 'CkFtp2_DetermineSettings'))
    (objHandle, outStr);
end;

function CkFtp2__determineSettings (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__determineSettings(_map(269, 'CkFtp2__determineSettings'))
    (objHandle);
end;

function CkFtp2_DetermineSettingsAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_DetermineSettingsAsync(_map(270, 'CkFtp2_DetermineSettingsAsync'))
    (objHandle);
end;

function CkFtp2_DirTreeXml (objHandle: HCkFtp2; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_DirTreeXml(_map(271, 'CkFtp2_DirTreeXml'))
    (objHandle, outStr);
end;

function CkFtp2__dirTreeXml (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__dirTreeXml(_map(272, 'CkFtp2__dirTreeXml'))
    (objHandle);
end;

function CkFtp2_DirTreeXmlAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_DirTreeXmlAsync(_map(273, 'CkFtp2_DirTreeXmlAsync'))
    (objHandle);
end;

function CkFtp2_Disconnect (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_Disconnect(_map(274, 'CkFtp2_Disconnect'))
    (objHandle);
end;

function CkFtp2_DisconnectAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_DisconnectAsync(_map(275, 'CkFtp2_DisconnectAsync'))
    (objHandle);
end;

function CkFtp2_DownloadTree (objHandle: HCkFtp2; localRoot: PWideChar): wordbool;
begin
  result := TCkFtp2_DownloadTree(_map(276, 'CkFtp2_DownloadTree'))
    (objHandle, localRoot);
end;

function CkFtp2_DownloadTreeAsync (objHandle: HCkFtp2; localRoot: PWideChar): HCkTask;
begin
  result := TCkFtp2_DownloadTreeAsync(_map(277, 'CkFtp2_DownloadTreeAsync'))
    (objHandle, localRoot);
end;

function CkFtp2_Feat (objHandle: HCkFtp2; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_Feat(_map(278, 'CkFtp2_Feat'))
    (objHandle, outStr);
end;

function CkFtp2__feat (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__feat(_map(279, 'CkFtp2__feat'))
    (objHandle);
end;

function CkFtp2_FeatAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_FeatAsync(_map(280, 'CkFtp2_FeatAsync'))
    (objHandle);
end;

function CkFtp2_GetCreateDt (objHandle: HCkFtp2; index: Integer): HCkDateTime;
begin
  result := TCkFtp2_GetCreateDt(_map(281, 'CkFtp2_GetCreateDt'))
    (objHandle, index);
end;

function CkFtp2_GetCreateDtAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetCreateDtAsync(_map(282, 'CkFtp2_GetCreateDtAsync'))
    (objHandle, index);
end;

function CkFtp2_GetCreateDtByName (objHandle: HCkFtp2; filename: PWideChar): HCkDateTime;
begin
  result := TCkFtp2_GetCreateDtByName(_map(283, 'CkFtp2_GetCreateDtByName'))
    (objHandle, filename);
end;

function CkFtp2_GetCreateDtByNameAsync (objHandle: HCkFtp2; filename: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetCreateDtByNameAsync(_map(284, 'CkFtp2_GetCreateDtByNameAsync'))
    (objHandle, filename);
end;

function CkFtp2_GetCreateTimeByNameStr (objHandle: HCkFtp2; filename: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetCreateTimeByNameStr(_map(285, 'CkFtp2_GetCreateTimeByNameStr'))
    (objHandle, filename, outStr);
end;

function CkFtp2__getCreateTimeByNameStr (objHandle: HCkFtp2; filename: PWideChar): PWideChar;
begin
  result := TCkFtp2__getCreateTimeByNameStr(_map(286, 'CkFtp2__getCreateTimeByNameStr'))
    (objHandle, filename);
end;

function CkFtp2_GetCreateTimeByNameStrAsync (objHandle: HCkFtp2; filename: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetCreateTimeByNameStrAsync(_map(287, 'CkFtp2_GetCreateTimeByNameStrAsync'))
    (objHandle, filename);
end;

function CkFtp2_GetCreateTimeStr (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetCreateTimeStr(_map(288, 'CkFtp2_GetCreateTimeStr'))
    (objHandle, index, outStr);
end;

function CkFtp2__getCreateTimeStr (objHandle: HCkFtp2; index: Integer): PWideChar;
begin
  result := TCkFtp2__getCreateTimeStr(_map(289, 'CkFtp2__getCreateTimeStr'))
    (objHandle, index);
end;

function CkFtp2_GetCreateTimeStrAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetCreateTimeStrAsync(_map(290, 'CkFtp2_GetCreateTimeStrAsync'))
    (objHandle, index);
end;

function CkFtp2_GetCurrentRemoteDir (objHandle: HCkFtp2; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetCurrentRemoteDir(_map(291, 'CkFtp2_GetCurrentRemoteDir'))
    (objHandle, outStr);
end;

function CkFtp2__getCurrentRemoteDir (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__getCurrentRemoteDir(_map(292, 'CkFtp2__getCurrentRemoteDir'))
    (objHandle);
end;

function CkFtp2_GetCurrentRemoteDirAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_GetCurrentRemoteDirAsync(_map(293, 'CkFtp2_GetCurrentRemoteDirAsync'))
    (objHandle);
end;

function CkFtp2_GetDirCount (objHandle: HCkFtp2): Integer;
begin
  result := TCkFtp2_GetDirCount(_map(294, 'CkFtp2_GetDirCount'))
    (objHandle);
end;

function CkFtp2_GetDirCountAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_GetDirCountAsync(_map(295, 'CkFtp2_GetDirCountAsync'))
    (objHandle);
end;

function CkFtp2_GetFile (objHandle: HCkFtp2; remoteFilePath: PWideChar; localFilePath: PWideChar): wordbool;
begin
  result := TCkFtp2_GetFile(_map(296, 'CkFtp2_GetFile'))
    (objHandle, remoteFilePath, localFilePath);
end;

function CkFtp2_GetFileAsync (objHandle: HCkFtp2; remoteFilePath: PWideChar; localFilePath: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetFileAsync(_map(297, 'CkFtp2_GetFileAsync'))
    (objHandle, remoteFilePath, localFilePath);
end;

function CkFtp2_GetFileBd (objHandle: HCkFtp2; remoteFilePath: PWideChar; binData: HCkBinData): wordbool;
begin
  result := TCkFtp2_GetFileBd(_map(298, 'CkFtp2_GetFileBd'))
    (objHandle, remoteFilePath, binData);
end;

function CkFtp2_GetFileBdAsync (objHandle: HCkFtp2; remoteFilePath: PWideChar; binData: HCkBinData): HCkTask;
begin
  result := TCkFtp2_GetFileBdAsync(_map(299, 'CkFtp2_GetFileBdAsync'))
    (objHandle, remoteFilePath, binData);
end;

function CkFtp2_GetFilename (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetFilename(_map(300, 'CkFtp2_GetFilename'))
    (objHandle, index, outStr);
end;

function CkFtp2__getFilename (objHandle: HCkFtp2; index: Integer): PWideChar;
begin
  result := TCkFtp2__getFilename(_map(301, 'CkFtp2__getFilename'))
    (objHandle, index);
end;

function CkFtp2_GetFilenameAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetFilenameAsync(_map(302, 'CkFtp2_GetFilenameAsync'))
    (objHandle, index);
end;

function CkFtp2_GetFileSb (objHandle: HCkFtp2; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): wordbool;
begin
  result := TCkFtp2_GetFileSb(_map(303, 'CkFtp2_GetFileSb'))
    (objHandle, remoteFilePath, charset, sb);
end;

function CkFtp2_GetFileSbAsync (objHandle: HCkFtp2; remoteFilePath: PWideChar; charset: PWideChar; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkFtp2_GetFileSbAsync(_map(304, 'CkFtp2_GetFileSbAsync'))
    (objHandle, remoteFilePath, charset, sb);
end;

function CkFtp2_GetFileToStream (objHandle: HCkFtp2; remoteFilePath: PWideChar; toStream: HCkStream): wordbool;
begin
  result := TCkFtp2_GetFileToStream(_map(305, 'CkFtp2_GetFileToStream'))
    (objHandle, remoteFilePath, toStream);
end;

function CkFtp2_GetFileToStreamAsync (objHandle: HCkFtp2; remoteFilePath: PWideChar; toStream: HCkStream): HCkTask;
begin
  result := TCkFtp2_GetFileToStreamAsync(_map(306, 'CkFtp2_GetFileToStreamAsync'))
    (objHandle, remoteFilePath, toStream);
end;

function CkFtp2_GetGroup (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetGroup(_map(307, 'CkFtp2_GetGroup'))
    (objHandle, index, outStr);
end;

function CkFtp2__getGroup (objHandle: HCkFtp2; index: Integer): PWideChar;
begin
  result := TCkFtp2__getGroup(_map(308, 'CkFtp2__getGroup'))
    (objHandle, index);
end;

function CkFtp2_GetGroupAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetGroupAsync(_map(309, 'CkFtp2_GetGroupAsync'))
    (objHandle, index);
end;

function CkFtp2_GetIsDirectory (objHandle: HCkFtp2; index: Integer): wordbool;
begin
  result := TCkFtp2_GetIsDirectory(_map(310, 'CkFtp2_GetIsDirectory'))
    (objHandle, index);
end;

function CkFtp2_GetIsDirectoryAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetIsDirectoryAsync(_map(311, 'CkFtp2_GetIsDirectoryAsync'))
    (objHandle, index);
end;

function CkFtp2_GetIsSymbolicLink (objHandle: HCkFtp2; index: Integer): wordbool;
begin
  result := TCkFtp2_GetIsSymbolicLink(_map(312, 'CkFtp2_GetIsSymbolicLink'))
    (objHandle, index);
end;

function CkFtp2_GetIsSymbolicLinkAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetIsSymbolicLinkAsync(_map(313, 'CkFtp2_GetIsSymbolicLinkAsync'))
    (objHandle, index);
end;

function CkFtp2_GetLastModDt (objHandle: HCkFtp2; index: Integer): HCkDateTime;
begin
  result := TCkFtp2_GetLastModDt(_map(314, 'CkFtp2_GetLastModDt'))
    (objHandle, index);
end;

function CkFtp2_GetLastModDtAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetLastModDtAsync(_map(315, 'CkFtp2_GetLastModDtAsync'))
    (objHandle, index);
end;

function CkFtp2_GetLastModDtByName (objHandle: HCkFtp2; filename: PWideChar): HCkDateTime;
begin
  result := TCkFtp2_GetLastModDtByName(_map(316, 'CkFtp2_GetLastModDtByName'))
    (objHandle, filename);
end;

function CkFtp2_GetLastModDtByNameAsync (objHandle: HCkFtp2; filename: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetLastModDtByNameAsync(_map(317, 'CkFtp2_GetLastModDtByNameAsync'))
    (objHandle, filename);
end;

function CkFtp2_GetLastModifiedTimeByNameStr (objHandle: HCkFtp2; filename: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetLastModifiedTimeByNameStr(_map(318, 'CkFtp2_GetLastModifiedTimeByNameStr'))
    (objHandle, filename, outStr);
end;

function CkFtp2__getLastModifiedTimeByNameStr (objHandle: HCkFtp2; filename: PWideChar): PWideChar;
begin
  result := TCkFtp2__getLastModifiedTimeByNameStr(_map(319, 'CkFtp2__getLastModifiedTimeByNameStr'))
    (objHandle, filename);
end;

function CkFtp2_GetLastModifiedTimeByNameStrAsync (objHandle: HCkFtp2; filename: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetLastModifiedTimeByNameStrAsync(_map(320, 'CkFtp2_GetLastModifiedTimeByNameStrAsync'))
    (objHandle, filename);
end;

function CkFtp2_GetLastModifiedTimeStr (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetLastModifiedTimeStr(_map(321, 'CkFtp2_GetLastModifiedTimeStr'))
    (objHandle, index, outStr);
end;

function CkFtp2__getLastModifiedTimeStr (objHandle: HCkFtp2; index: Integer): PWideChar;
begin
  result := TCkFtp2__getLastModifiedTimeStr(_map(322, 'CkFtp2__getLastModifiedTimeStr'))
    (objHandle, index);
end;

function CkFtp2_GetLastModifiedTimeStrAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetLastModifiedTimeStrAsync(_map(323, 'CkFtp2_GetLastModifiedTimeStrAsync'))
    (objHandle, index);
end;

function CkFtp2_GetOwner (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetOwner(_map(324, 'CkFtp2_GetOwner'))
    (objHandle, index, outStr);
end;

function CkFtp2__getOwner (objHandle: HCkFtp2; index: Integer): PWideChar;
begin
  result := TCkFtp2__getOwner(_map(325, 'CkFtp2__getOwner'))
    (objHandle, index);
end;

function CkFtp2_GetOwnerAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetOwnerAsync(_map(326, 'CkFtp2_GetOwnerAsync'))
    (objHandle, index);
end;

function CkFtp2_GetPermissions (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetPermissions(_map(327, 'CkFtp2_GetPermissions'))
    (objHandle, index, outStr);
end;

function CkFtp2__getPermissions (objHandle: HCkFtp2; index: Integer): PWideChar;
begin
  result := TCkFtp2__getPermissions(_map(328, 'CkFtp2__getPermissions'))
    (objHandle, index);
end;

function CkFtp2_GetPermissionsAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetPermissionsAsync(_map(329, 'CkFtp2_GetPermissionsAsync'))
    (objHandle, index);
end;

function CkFtp2_GetPermType (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetPermType(_map(330, 'CkFtp2_GetPermType'))
    (objHandle, index, outStr);
end;

function CkFtp2__getPermType (objHandle: HCkFtp2; index: Integer): PWideChar;
begin
  result := TCkFtp2__getPermType(_map(331, 'CkFtp2__getPermType'))
    (objHandle, index);
end;

function CkFtp2_GetPermTypeAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetPermTypeAsync(_map(332, 'CkFtp2_GetPermTypeAsync'))
    (objHandle, index);
end;

function CkFtp2_GetRemoteFileBinaryData (objHandle: HCkFtp2; remoteFilename: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkFtp2_GetRemoteFileBinaryData(_map(333, 'CkFtp2_GetRemoteFileBinaryData'))
    (objHandle, remoteFilename, outData);
end;

function CkFtp2_GetRemoteFileBinaryDataAsync (objHandle: HCkFtp2; remoteFilename: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetRemoteFileBinaryDataAsync(_map(334, 'CkFtp2_GetRemoteFileBinaryDataAsync'))
    (objHandle, remoteFilename);
end;

function CkFtp2_GetRemoteFileTextC (objHandle: HCkFtp2; remoteFilename: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetRemoteFileTextC(_map(335, 'CkFtp2_GetRemoteFileTextC'))
    (objHandle, remoteFilename, charset, outStr);
end;

function CkFtp2__getRemoteFileTextC (objHandle: HCkFtp2; remoteFilename: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkFtp2__getRemoteFileTextC(_map(336, 'CkFtp2__getRemoteFileTextC'))
    (objHandle, remoteFilename, charset);
end;

function CkFtp2_GetRemoteFileTextCAsync (objHandle: HCkFtp2; remoteFilename: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetRemoteFileTextCAsync(_map(337, 'CkFtp2_GetRemoteFileTextCAsync'))
    (objHandle, remoteFilename, charset);
end;

function CkFtp2_GetRemoteFileTextData (objHandle: HCkFtp2; remoteFilename: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetRemoteFileTextData(_map(338, 'CkFtp2_GetRemoteFileTextData'))
    (objHandle, remoteFilename, outStr);
end;

function CkFtp2__getRemoteFileTextData (objHandle: HCkFtp2; remoteFilename: PWideChar): PWideChar;
begin
  result := TCkFtp2__getRemoteFileTextData(_map(339, 'CkFtp2__getRemoteFileTextData'))
    (objHandle, remoteFilename);
end;

function CkFtp2_GetRemoteFileTextDataAsync (objHandle: HCkFtp2; remoteFilename: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetRemoteFileTextDataAsync(_map(340, 'CkFtp2_GetRemoteFileTextDataAsync'))
    (objHandle, remoteFilename);
end;

function CkFtp2_GetServerCert (objHandle: HCkFtp2; cert: HCkCert): wordbool;
begin
  result := TCkFtp2_GetServerCert(_map(341, 'CkFtp2_GetServerCert'))
    (objHandle, cert);
end;

function CkFtp2_GetSize (objHandle: HCkFtp2; index: Integer): Integer;
begin
  result := TCkFtp2_GetSize(_map(342, 'CkFtp2_GetSize'))
    (objHandle, index);
end;

function CkFtp2_GetSizeAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetSizeAsync(_map(343, 'CkFtp2_GetSizeAsync'))
    (objHandle, index);
end;

function CkFtp2_GetSize64 (objHandle: HCkFtp2; index: Integer): Int64;
begin
  result := TCkFtp2_GetSize64(_map(344, 'CkFtp2_GetSize64'))
    (objHandle, index);
end;

function CkFtp2_GetSize64Async (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetSize64Async(_map(345, 'CkFtp2_GetSize64Async'))
    (objHandle, index);
end;

function CkFtp2_GetSizeByName (objHandle: HCkFtp2; filename: PWideChar): Integer;
begin
  result := TCkFtp2_GetSizeByName(_map(346, 'CkFtp2_GetSizeByName'))
    (objHandle, filename);
end;

function CkFtp2_GetSizeByNameAsync (objHandle: HCkFtp2; filename: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetSizeByNameAsync(_map(347, 'CkFtp2_GetSizeByNameAsync'))
    (objHandle, filename);
end;

function CkFtp2_GetSizeByName64 (objHandle: HCkFtp2; filename: PWideChar): Int64;
begin
  result := TCkFtp2_GetSizeByName64(_map(348, 'CkFtp2_GetSizeByName64'))
    (objHandle, filename);
end;

function CkFtp2_GetSizeByName64Async (objHandle: HCkFtp2; filename: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetSizeByName64Async(_map(349, 'CkFtp2_GetSizeByName64Async'))
    (objHandle, filename);
end;

function CkFtp2_GetSizeStr (objHandle: HCkFtp2; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetSizeStr(_map(350, 'CkFtp2_GetSizeStr'))
    (objHandle, index, outStr);
end;

function CkFtp2__getSizeStr (objHandle: HCkFtp2; index: Integer): PWideChar;
begin
  result := TCkFtp2__getSizeStr(_map(351, 'CkFtp2__getSizeStr'))
    (objHandle, index);
end;

function CkFtp2_GetSizeStrAsync (objHandle: HCkFtp2; index: Integer): HCkTask;
begin
  result := TCkFtp2_GetSizeStrAsync(_map(352, 'CkFtp2_GetSizeStrAsync'))
    (objHandle, index);
end;

function CkFtp2_GetSizeStrByName (objHandle: HCkFtp2; filename: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetSizeStrByName(_map(353, 'CkFtp2_GetSizeStrByName'))
    (objHandle, filename, outStr);
end;

function CkFtp2__getSizeStrByName (objHandle: HCkFtp2; filename: PWideChar): PWideChar;
begin
  result := TCkFtp2__getSizeStrByName(_map(354, 'CkFtp2__getSizeStrByName'))
    (objHandle, filename);
end;

function CkFtp2_GetSizeStrByNameAsync (objHandle: HCkFtp2; filename: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetSizeStrByNameAsync(_map(355, 'CkFtp2_GetSizeStrByNameAsync'))
    (objHandle, filename);
end;

function CkFtp2_GetSslServerCert (objHandle: HCkFtp2): HCkCert;
begin
  result := TCkFtp2_GetSslServerCert(_map(356, 'CkFtp2_GetSslServerCert'))
    (objHandle);
end;

procedure CkFtp2_GetSyncedFiles (objHandle: HCkFtp2; strTable: HCkStringTable);
begin
  TCkFtp2_GetSyncedFiles(_map(357, 'CkFtp2_GetSyncedFiles'))
    (objHandle, strTable);
end;

function CkFtp2_GetTextDirListing (objHandle: HCkFtp2; pattern: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetTextDirListing(_map(358, 'CkFtp2_GetTextDirListing'))
    (objHandle, pattern, outStr);
end;

function CkFtp2__getTextDirListing (objHandle: HCkFtp2; pattern: PWideChar): PWideChar;
begin
  result := TCkFtp2__getTextDirListing(_map(359, 'CkFtp2__getTextDirListing'))
    (objHandle, pattern);
end;

function CkFtp2_GetTextDirListingAsync (objHandle: HCkFtp2; pattern: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetTextDirListingAsync(_map(360, 'CkFtp2_GetTextDirListingAsync'))
    (objHandle, pattern);
end;

function CkFtp2_GetXmlDirListing (objHandle: HCkFtp2; pattern: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_GetXmlDirListing(_map(361, 'CkFtp2_GetXmlDirListing'))
    (objHandle, pattern, outStr);
end;

function CkFtp2__getXmlDirListing (objHandle: HCkFtp2; pattern: PWideChar): PWideChar;
begin
  result := TCkFtp2__getXmlDirListing(_map(362, 'CkFtp2__getXmlDirListing'))
    (objHandle, pattern);
end;

function CkFtp2_GetXmlDirListingAsync (objHandle: HCkFtp2; pattern: PWideChar): HCkTask;
begin
  result := TCkFtp2_GetXmlDirListingAsync(_map(363, 'CkFtp2_GetXmlDirListingAsync'))
    (objHandle, pattern);
end;

function CkFtp2_LargeFileUpload (objHandle: HCkFtp2; localPath: PWideChar; remotePath: PWideChar; chunkSize: Integer): wordbool;
begin
  result := TCkFtp2_LargeFileUpload(_map(364, 'CkFtp2_LargeFileUpload'))
    (objHandle, localPath, remotePath, chunkSize);
end;

function CkFtp2_LargeFileUploadAsync (objHandle: HCkFtp2; localPath: PWideChar; remotePath: PWideChar; chunkSize: Integer): HCkTask;
begin
  result := TCkFtp2_LargeFileUploadAsync(_map(365, 'CkFtp2_LargeFileUploadAsync'))
    (objHandle, localPath, remotePath, chunkSize);
end;

function CkFtp2_LoadTaskCaller (objHandle: HCkFtp2; task: HCkTask): wordbool;
begin
  result := TCkFtp2_LoadTaskCaller(_map(366, 'CkFtp2_LoadTaskCaller'))
    (objHandle, task);
end;

function CkFtp2_LoginAfterConnectOnly (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_LoginAfterConnectOnly(_map(367, 'CkFtp2_LoginAfterConnectOnly'))
    (objHandle);
end;

function CkFtp2_LoginAfterConnectOnlyAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_LoginAfterConnectOnlyAsync(_map(368, 'CkFtp2_LoginAfterConnectOnlyAsync'))
    (objHandle);
end;

function CkFtp2_MGetFiles (objHandle: HCkFtp2; remotePattern: PWideChar; localDir: PWideChar): Integer;
begin
  result := TCkFtp2_MGetFiles(_map(369, 'CkFtp2_MGetFiles'))
    (objHandle, remotePattern, localDir);
end;

function CkFtp2_MGetFilesAsync (objHandle: HCkFtp2; remotePattern: PWideChar; localDir: PWideChar): HCkTask;
begin
  result := TCkFtp2_MGetFilesAsync(_map(370, 'CkFtp2_MGetFilesAsync'))
    (objHandle, remotePattern, localDir);
end;

function CkFtp2_MPutFiles (objHandle: HCkFtp2; pattern: PWideChar): Integer;
begin
  result := TCkFtp2_MPutFiles(_map(371, 'CkFtp2_MPutFiles'))
    (objHandle, pattern);
end;

function CkFtp2_MPutFilesAsync (objHandle: HCkFtp2; pattern: PWideChar): HCkTask;
begin
  result := TCkFtp2_MPutFilesAsync(_map(372, 'CkFtp2_MPutFilesAsync'))
    (objHandle, pattern);
end;

function CkFtp2_NlstXml (objHandle: HCkFtp2; remoteDirPattern: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_NlstXml(_map(373, 'CkFtp2_NlstXml'))
    (objHandle, remoteDirPattern, outStr);
end;

function CkFtp2__nlstXml (objHandle: HCkFtp2; remoteDirPattern: PWideChar): PWideChar;
begin
  result := TCkFtp2__nlstXml(_map(374, 'CkFtp2__nlstXml'))
    (objHandle, remoteDirPattern);
end;

function CkFtp2_NlstXmlAsync (objHandle: HCkFtp2; remoteDirPattern: PWideChar): HCkTask;
begin
  result := TCkFtp2_NlstXmlAsync(_map(375, 'CkFtp2_NlstXmlAsync'))
    (objHandle, remoteDirPattern);
end;

function CkFtp2_Noop (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_Noop(_map(376, 'CkFtp2_Noop'))
    (objHandle);
end;

function CkFtp2_NoopAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_NoopAsync(_map(377, 'CkFtp2_NoopAsync'))
    (objHandle);
end;

function CkFtp2_PutFile (objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): wordbool;
begin
  result := TCkFtp2_PutFile(_map(378, 'CkFtp2_PutFile'))
    (objHandle, localFilePath, remoteFilePath);
end;

function CkFtp2_PutFileAsync (objHandle: HCkFtp2; localFilePath: PWideChar; remoteFilePath: PWideChar): HCkTask;
begin
  result := TCkFtp2_PutFileAsync(_map(379, 'CkFtp2_PutFileAsync'))
    (objHandle, localFilePath, remoteFilePath);
end;

function CkFtp2_PutFileBd (objHandle: HCkFtp2; binData: HCkBinData; remoteFilePath: PWideChar): wordbool;
begin
  result := TCkFtp2_PutFileBd(_map(380, 'CkFtp2_PutFileBd'))
    (objHandle, binData, remoteFilePath);
end;

function CkFtp2_PutFileBdAsync (objHandle: HCkFtp2; binData: HCkBinData; remoteFilePath: PWideChar): HCkTask;
begin
  result := TCkFtp2_PutFileBdAsync(_map(381, 'CkFtp2_PutFileBdAsync'))
    (objHandle, binData, remoteFilePath);
end;

function CkFtp2_PutFileFromBinaryData (objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): wordbool;
begin
  result := TCkFtp2_PutFileFromBinaryData(_map(382, 'CkFtp2_PutFileFromBinaryData'))
    (objHandle, remoteFilename, content);
end;

function CkFtp2_PutFileFromBinaryDataAsync (objHandle: HCkFtp2; remoteFilename: PWideChar; content: HCkByteData): HCkTask;
begin
  result := TCkFtp2_PutFileFromBinaryDataAsync(_map(383, 'CkFtp2_PutFileFromBinaryDataAsync'))
    (objHandle, remoteFilename, content);
end;

function CkFtp2_PutFileFromTextData (objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkFtp2_PutFileFromTextData(_map(384, 'CkFtp2_PutFileFromTextData'))
    (objHandle, remoteFilename, textData, charset);
end;

function CkFtp2_PutFileFromTextDataAsync (objHandle: HCkFtp2; remoteFilename: PWideChar; textData: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkFtp2_PutFileFromTextDataAsync(_map(385, 'CkFtp2_PutFileFromTextDataAsync'))
    (objHandle, remoteFilename, textData, charset);
end;

function CkFtp2_PutFileSb (objHandle: HCkFtp2; sb: HCkStringBuilder; charset: PWideChar; includeBom: wordbool; remoteFilePath: PWideChar): wordbool;
begin
  result := TCkFtp2_PutFileSb(_map(386, 'CkFtp2_PutFileSb'))
    (objHandle, sb, charset, includeBom, remoteFilePath);
end;

function CkFtp2_PutFileSbAsync (objHandle: HCkFtp2; sb: HCkStringBuilder; charset: PWideChar; includeBom: wordbool; remoteFilePath: PWideChar): HCkTask;
begin
  result := TCkFtp2_PutFileSbAsync(_map(387, 'CkFtp2_PutFileSbAsync'))
    (objHandle, sb, charset, includeBom, remoteFilePath);
end;

function CkFtp2_PutPlan (objHandle: HCkFtp2; plan: PWideChar; alreadyDoneFilename: PWideChar): wordbool;
begin
  result := TCkFtp2_PutPlan(_map(388, 'CkFtp2_PutPlan'))
    (objHandle, plan, alreadyDoneFilename);
end;

function CkFtp2_PutPlanAsync (objHandle: HCkFtp2; plan: PWideChar; alreadyDoneFilename: PWideChar): HCkTask;
begin
  result := TCkFtp2_PutPlanAsync(_map(389, 'CkFtp2_PutPlanAsync'))
    (objHandle, plan, alreadyDoneFilename);
end;

function CkFtp2_PutTree (objHandle: HCkFtp2; localDir: PWideChar): wordbool;
begin
  result := TCkFtp2_PutTree(_map(390, 'CkFtp2_PutTree'))
    (objHandle, localDir);
end;

function CkFtp2_PutTreeAsync (objHandle: HCkFtp2; localDir: PWideChar): HCkTask;
begin
  result := TCkFtp2_PutTreeAsync(_map(391, 'CkFtp2_PutTreeAsync'))
    (objHandle, localDir);
end;

function CkFtp2_Quote (objHandle: HCkFtp2; cmd: PWideChar): wordbool;
begin
  result := TCkFtp2_Quote(_map(392, 'CkFtp2_Quote'))
    (objHandle, cmd);
end;

function CkFtp2_QuoteAsync (objHandle: HCkFtp2; cmd: PWideChar): HCkTask;
begin
  result := TCkFtp2_QuoteAsync(_map(393, 'CkFtp2_QuoteAsync'))
    (objHandle, cmd);
end;

function CkFtp2_RemoveRemoteDir (objHandle: HCkFtp2; remoteDirPath: PWideChar): wordbool;
begin
  result := TCkFtp2_RemoveRemoteDir(_map(394, 'CkFtp2_RemoveRemoteDir'))
    (objHandle, remoteDirPath);
end;

function CkFtp2_RemoveRemoteDirAsync (objHandle: HCkFtp2; remoteDirPath: PWideChar): HCkTask;
begin
  result := TCkFtp2_RemoveRemoteDirAsync(_map(395, 'CkFtp2_RemoveRemoteDirAsync'))
    (objHandle, remoteDirPath);
end;

function CkFtp2_RenameRemoteFile (objHandle: HCkFtp2; existingRemoteFilePath: PWideChar; newRemoteFilePath: PWideChar): wordbool;
begin
  result := TCkFtp2_RenameRemoteFile(_map(396, 'CkFtp2_RenameRemoteFile'))
    (objHandle, existingRemoteFilePath, newRemoteFilePath);
end;

function CkFtp2_RenameRemoteFileAsync (objHandle: HCkFtp2; existingRemoteFilePath: PWideChar; newRemoteFilePath: PWideChar): HCkTask;
begin
  result := TCkFtp2_RenameRemoteFileAsync(_map(397, 'CkFtp2_RenameRemoteFileAsync'))
    (objHandle, existingRemoteFilePath, newRemoteFilePath);
end;

function CkFtp2_SendCommand (objHandle: HCkFtp2; cmd: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_SendCommand(_map(398, 'CkFtp2_SendCommand'))
    (objHandle, cmd, outStr);
end;

function CkFtp2__sendCommand (objHandle: HCkFtp2; cmd: PWideChar): PWideChar;
begin
  result := TCkFtp2__sendCommand(_map(399, 'CkFtp2__sendCommand'))
    (objHandle, cmd);
end;

function CkFtp2_SendCommandAsync (objHandle: HCkFtp2; cmd: PWideChar): HCkTask;
begin
  result := TCkFtp2_SendCommandAsync(_map(400, 'CkFtp2_SendCommandAsync'))
    (objHandle, cmd);
end;

function CkFtp2_SetModeZ (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_SetModeZ(_map(401, 'CkFtp2_SetModeZ'))
    (objHandle);
end;

function CkFtp2_SetModeZAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_SetModeZAsync(_map(402, 'CkFtp2_SetModeZAsync'))
    (objHandle);
end;

procedure CkFtp2_SetOldestDateStr (objHandle: HCkFtp2; oldestDateTimeStr: PWideChar);
begin
  TCkFtp2_SetOldestDateStr(_map(403, 'CkFtp2_SetOldestDateStr'))
    (objHandle, oldestDateTimeStr);
end;

function CkFtp2_SetOption (objHandle: HCkFtp2; option: PWideChar): wordbool;
begin
  result := TCkFtp2_SetOption(_map(404, 'CkFtp2_SetOption'))
    (objHandle, option);
end;

function CkFtp2_SetPassword (objHandle: HCkFtp2; password: HCkSecureString): wordbool;
begin
  result := TCkFtp2_SetPassword(_map(405, 'CkFtp2_SetPassword'))
    (objHandle, password);
end;

function CkFtp2_SetRemoteFileDateTimeStr (objHandle: HCkFtp2; dateTimeStr: PWideChar; remoteFilename: PWideChar): wordbool;
begin
  result := TCkFtp2_SetRemoteFileDateTimeStr(_map(406, 'CkFtp2_SetRemoteFileDateTimeStr'))
    (objHandle, dateTimeStr, remoteFilename);
end;

function CkFtp2_SetRemoteFileDateTimeStrAsync (objHandle: HCkFtp2; dateTimeStr: PWideChar; remoteFilename: PWideChar): HCkTask;
begin
  result := TCkFtp2_SetRemoteFileDateTimeStrAsync(_map(407, 'CkFtp2_SetRemoteFileDateTimeStrAsync'))
    (objHandle, dateTimeStr, remoteFilename);
end;

function CkFtp2_SetRemoteFileDt (objHandle: HCkFtp2; dt: HCkDateTime; remoteFilename: PWideChar): wordbool;
begin
  result := TCkFtp2_SetRemoteFileDt(_map(408, 'CkFtp2_SetRemoteFileDt'))
    (objHandle, dt, remoteFilename);
end;

function CkFtp2_SetRemoteFileDtAsync (objHandle: HCkFtp2; dt: HCkDateTime; remoteFilename: PWideChar): HCkTask;
begin
  result := TCkFtp2_SetRemoteFileDtAsync(_map(409, 'CkFtp2_SetRemoteFileDtAsync'))
    (objHandle, dt, remoteFilename);
end;

function CkFtp2_SetSecurePassword (objHandle: HCkFtp2; password: HCkSecureString): wordbool;
begin
  result := TCkFtp2_SetSecurePassword(_map(410, 'CkFtp2_SetSecurePassword'))
    (objHandle, password);
end;

procedure CkFtp2_SetSslCertRequirement (objHandle: HCkFtp2; reqName: PWideChar; reqValue: PWideChar);
begin
  TCkFtp2_SetSslCertRequirement(_map(411, 'CkFtp2_SetSslCertRequirement'))
    (objHandle, reqName, reqValue);
end;

function CkFtp2_SetSslClientCert (objHandle: HCkFtp2; cert: HCkCert): wordbool;
begin
  result := TCkFtp2_SetSslClientCert(_map(412, 'CkFtp2_SetSslClientCert'))
    (objHandle, cert);
end;

function CkFtp2_SetSslClientCertPem (objHandle: HCkFtp2; pemDataOrFilename: PWideChar; pemPassword: PWideChar): wordbool;
begin
  result := TCkFtp2_SetSslClientCertPem(_map(413, 'CkFtp2_SetSslClientCertPem'))
    (objHandle, pemDataOrFilename, pemPassword);
end;

function CkFtp2_SetSslClientCertPfx (objHandle: HCkFtp2; pfxFilename: PWideChar; pfxPassword: PWideChar): wordbool;
begin
  result := TCkFtp2_SetSslClientCertPfx(_map(414, 'CkFtp2_SetSslClientCertPfx'))
    (objHandle, pfxFilename, pfxPassword);
end;

function CkFtp2_SetTypeAscii (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_SetTypeAscii(_map(415, 'CkFtp2_SetTypeAscii'))
    (objHandle);
end;

function CkFtp2_SetTypeAsciiAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_SetTypeAsciiAsync(_map(416, 'CkFtp2_SetTypeAsciiAsync'))
    (objHandle);
end;

function CkFtp2_SetTypeBinary (objHandle: HCkFtp2): wordbool;
begin
  result := TCkFtp2_SetTypeBinary(_map(417, 'CkFtp2_SetTypeBinary'))
    (objHandle);
end;

function CkFtp2_SetTypeBinaryAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_SetTypeBinaryAsync(_map(418, 'CkFtp2_SetTypeBinaryAsync'))
    (objHandle);
end;

function CkFtp2_Site (objHandle: HCkFtp2; siteCommand: PWideChar): wordbool;
begin
  result := TCkFtp2_Site(_map(419, 'CkFtp2_Site'))
    (objHandle, siteCommand);
end;

function CkFtp2_SiteAsync (objHandle: HCkFtp2; siteCommand: PWideChar): HCkTask;
begin
  result := TCkFtp2_SiteAsync(_map(420, 'CkFtp2_SiteAsync'))
    (objHandle, siteCommand);
end;

procedure CkFtp2_SleepMs (objHandle: HCkFtp2; millisec: Integer);
begin
  TCkFtp2_SleepMs(_map(421, 'CkFtp2_SleepMs'))
    (objHandle, millisec);
end;

function CkFtp2_Stat (objHandle: HCkFtp2; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_Stat(_map(422, 'CkFtp2_Stat'))
    (objHandle, outStr);
end;

function CkFtp2__stat (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__stat(_map(423, 'CkFtp2__stat'))
    (objHandle);
end;

function CkFtp2_StatAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_StatAsync(_map(424, 'CkFtp2_StatAsync'))
    (objHandle);
end;

function CkFtp2_SyncDeleteRemote (objHandle: HCkFtp2; localRoot: PWideChar): wordbool;
begin
  result := TCkFtp2_SyncDeleteRemote(_map(425, 'CkFtp2_SyncDeleteRemote'))
    (objHandle, localRoot);
end;

function CkFtp2_SyncDeleteRemoteAsync (objHandle: HCkFtp2; localRoot: PWideChar): HCkTask;
begin
  result := TCkFtp2_SyncDeleteRemoteAsync(_map(426, 'CkFtp2_SyncDeleteRemoteAsync'))
    (objHandle, localRoot);
end;

function CkFtp2_SyncLocalDir (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): wordbool;
begin
  result := TCkFtp2_SyncLocalDir(_map(427, 'CkFtp2_SyncLocalDir'))
    (objHandle, localRoot, mode);
end;

function CkFtp2_SyncLocalDirAsync (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): HCkTask;
begin
  result := TCkFtp2_SyncLocalDirAsync(_map(428, 'CkFtp2_SyncLocalDirAsync'))
    (objHandle, localRoot, mode);
end;

function CkFtp2_SyncLocalTree (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): wordbool;
begin
  result := TCkFtp2_SyncLocalTree(_map(429, 'CkFtp2_SyncLocalTree'))
    (objHandle, localRoot, mode);
end;

function CkFtp2_SyncLocalTreeAsync (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): HCkTask;
begin
  result := TCkFtp2_SyncLocalTreeAsync(_map(430, 'CkFtp2_SyncLocalTreeAsync'))
    (objHandle, localRoot, mode);
end;

function CkFtp2_SyncRemoteTree (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): wordbool;
begin
  result := TCkFtp2_SyncRemoteTree(_map(431, 'CkFtp2_SyncRemoteTree'))
    (objHandle, localRoot, mode);
end;

function CkFtp2_SyncRemoteTreeAsync (objHandle: HCkFtp2; localRoot: PWideChar; mode: Integer): HCkTask;
begin
  result := TCkFtp2_SyncRemoteTreeAsync(_map(432, 'CkFtp2_SyncRemoteTreeAsync'))
    (objHandle, localRoot, mode);
end;

function CkFtp2_SyncRemoteTree2 (objHandle: HCkFtp2; localDirPath: PWideChar; mode: Integer; bDescend: wordbool; bPreviewOnly: wordbool): wordbool;
begin
  result := TCkFtp2_SyncRemoteTree2(_map(433, 'CkFtp2_SyncRemoteTree2'))
    (objHandle, localDirPath, mode, bDescend, bPreviewOnly);
end;

function CkFtp2_SyncRemoteTree2Async (objHandle: HCkFtp2; localDirPath: PWideChar; mode: Integer; bDescend: wordbool; bPreviewOnly: wordbool): HCkTask;
begin
  result := TCkFtp2_SyncRemoteTree2Async(_map(434, 'CkFtp2_SyncRemoteTree2Async'))
    (objHandle, localDirPath, mode, bDescend, bPreviewOnly);
end;

function CkFtp2_Syst (objHandle: HCkFtp2; outStr: HCkString): wordbool;
begin
  result := TCkFtp2_Syst(_map(435, 'CkFtp2_Syst'))
    (objHandle, outStr);
end;

function CkFtp2__syst (objHandle: HCkFtp2): PWideChar;
begin
  result := TCkFtp2__syst(_map(436, 'CkFtp2__syst'))
    (objHandle);
end;

function CkFtp2_SystAsync (objHandle: HCkFtp2): HCkTask;
begin
  result := TCkFtp2_SystAsync(_map(437, 'CkFtp2_SystAsync'))
    (objHandle);
end;

end.
