unit Global;

interface

type

HCkGlobal = Pointer;
HCkString = Pointer;


function CkGlobal_Create: HCkGlobal;  stdcall;
procedure CkGlobal_Dispose(handle: HCkGlobal); stdcall;
function CkGlobal_getAnsiCodePage(objHandle: HCkGlobal): Integer;
procedure CkGlobal_putAnsiCodePage(objHandle: HCkGlobal; newPropVal: Integer);
function CkGlobal_getAutoQBDecode(objHandle: HCkGlobal): wordbool;
procedure CkGlobal_putAutoQBDecode(objHandle: HCkGlobal; newPropVal: wordbool);
procedure CkGlobal_getDebugLogFilePath(objHandle: HCkGlobal; outPropVal: HCkString);
procedure CkGlobal_putDebugLogFilePath(objHandle: HCkGlobal; newPropVal: PWideChar);
function CkGlobal__debugLogFilePath(objHandle: HCkGlobal): PWideChar;
function CkGlobal_getDefaultNtlmVersion(objHandle: HCkGlobal): Integer;
procedure CkGlobal_putDefaultNtlmVersion(objHandle: HCkGlobal; newPropVal: Integer);
function CkGlobal_getDnsTimeToLive(objHandle: HCkGlobal): Integer;
procedure CkGlobal_putDnsTimeToLive(objHandle: HCkGlobal; newPropVal: Integer);
function CkGlobal_getEnableDnsCaching(objHandle: HCkGlobal): wordbool;
procedure CkGlobal_putEnableDnsCaching(objHandle: HCkGlobal; newPropVal: wordbool);
procedure CkGlobal_getLastErrorHtml(objHandle: HCkGlobal; outPropVal: HCkString);
function CkGlobal__lastErrorHtml(objHandle: HCkGlobal): PWideChar;
procedure CkGlobal_getLastErrorText(objHandle: HCkGlobal; outPropVal: HCkString);
function CkGlobal__lastErrorText(objHandle: HCkGlobal): PWideChar;
procedure CkGlobal_getLastErrorXml(objHandle: HCkGlobal; outPropVal: HCkString);
function CkGlobal__lastErrorXml(objHandle: HCkGlobal): PWideChar;
function CkGlobal_getLastMethodSuccess(objHandle: HCkGlobal): wordbool;
procedure CkGlobal_putLastMethodSuccess(objHandle: HCkGlobal; newPropVal: wordbool);
function CkGlobal_getMaxThreads(objHandle: HCkGlobal): Integer;
procedure CkGlobal_putMaxThreads(objHandle: HCkGlobal; newPropVal: Integer);
function CkGlobal_getPreferIpv6(objHandle: HCkGlobal): wordbool;
procedure CkGlobal_putPreferIpv6(objHandle: HCkGlobal; newPropVal: wordbool);
procedure CkGlobal_getThreadPoolLogPath(objHandle: HCkGlobal; outPropVal: HCkString);
procedure CkGlobal_putThreadPoolLogPath(objHandle: HCkGlobal; newPropVal: PWideChar);
function CkGlobal__threadPoolLogPath(objHandle: HCkGlobal): PWideChar;
procedure CkGlobal_getUncommonOptions(objHandle: HCkGlobal; outPropVal: HCkString);
procedure CkGlobal_putUncommonOptions(objHandle: HCkGlobal; newPropVal: PWideChar);
function CkGlobal__uncommonOptions(objHandle: HCkGlobal): PWideChar;
function CkGlobal_getUnlockStatus(objHandle: HCkGlobal): Integer;
function CkGlobal_getUsePkcsConstructedEncoding(objHandle: HCkGlobal): wordbool;
procedure CkGlobal_putUsePkcsConstructedEncoding(objHandle: HCkGlobal; newPropVal: wordbool);
function CkGlobal_getVerboseLogging(objHandle: HCkGlobal): wordbool;
procedure CkGlobal_putVerboseLogging(objHandle: HCkGlobal; newPropVal: wordbool);
function CkGlobal_getVerboseTls(objHandle: HCkGlobal): wordbool;
procedure CkGlobal_putVerboseTls(objHandle: HCkGlobal; newPropVal: wordbool);
procedure CkGlobal_getVersion(objHandle: HCkGlobal; outPropVal: HCkString);
function CkGlobal__version(objHandle: HCkGlobal): PWideChar;
function CkGlobal_DnsClearCache(objHandle: HCkGlobal): wordbool;
function CkGlobal_FinalizeThreadPool(objHandle: HCkGlobal): wordbool;
function CkGlobal_ThreadPoolLogLine(objHandle: HCkGlobal; str: PWideChar): wordbool;
function CkGlobal_UnlockBundle(objHandle: HCkGlobal; bundleUnlockCode: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkGlobal_Create = function : HCkGlobal; stdcall;
  TCkGlobal_Dispose = procedure (handle: HCkGlobal); stdcall;
  TCkGlobal_getAnsiCodePage = function (objHandle: HCkGlobal): Integer; stdcall;
  TCkGlobal_putAnsiCodePage = procedure (objHandle: HCkGlobal; newPropVal: Integer); stdcall;
  TCkGlobal_getAutoQBDecode = function (objHandle: HCkGlobal): wordbool; stdcall;
  TCkGlobal_putAutoQBDecode = procedure (objHandle: HCkGlobal; newPropVal: wordbool); stdcall;
  TCkGlobal_getDebugLogFilePath = procedure (objHandle: HCkGlobal; outPropVal: HCkString); stdcall;
  TCkGlobal_putDebugLogFilePath = procedure (objHandle: HCkGlobal; newPropVal: PWideChar); stdcall;
  TCkGlobal__debugLogFilePath = function (objHandle: HCkGlobal): PWideChar; stdcall;
  TCkGlobal_getDefaultNtlmVersion = function (objHandle: HCkGlobal): Integer; stdcall;
  TCkGlobal_putDefaultNtlmVersion = procedure (objHandle: HCkGlobal; newPropVal: Integer); stdcall;
  TCkGlobal_getDnsTimeToLive = function (objHandle: HCkGlobal): Integer; stdcall;
  TCkGlobal_putDnsTimeToLive = procedure (objHandle: HCkGlobal; newPropVal: Integer); stdcall;
  TCkGlobal_getEnableDnsCaching = function (objHandle: HCkGlobal): wordbool; stdcall;
  TCkGlobal_putEnableDnsCaching = procedure (objHandle: HCkGlobal; newPropVal: wordbool); stdcall;
  TCkGlobal_getLastErrorHtml = procedure (objHandle: HCkGlobal; outPropVal: HCkString); stdcall;
  TCkGlobal__lastErrorHtml = function (objHandle: HCkGlobal): PWideChar; stdcall;
  TCkGlobal_getLastErrorText = procedure (objHandle: HCkGlobal; outPropVal: HCkString); stdcall;
  TCkGlobal__lastErrorText = function (objHandle: HCkGlobal): PWideChar; stdcall;
  TCkGlobal_getLastErrorXml = procedure (objHandle: HCkGlobal; outPropVal: HCkString); stdcall;
  TCkGlobal__lastErrorXml = function (objHandle: HCkGlobal): PWideChar; stdcall;
  TCkGlobal_getLastMethodSuccess = function (objHandle: HCkGlobal): wordbool; stdcall;
  TCkGlobal_putLastMethodSuccess = procedure (objHandle: HCkGlobal; newPropVal: wordbool); stdcall;
  TCkGlobal_getMaxThreads = function (objHandle: HCkGlobal): Integer; stdcall;
  TCkGlobal_putMaxThreads = procedure (objHandle: HCkGlobal; newPropVal: Integer); stdcall;
  TCkGlobal_getPreferIpv6 = function (objHandle: HCkGlobal): wordbool; stdcall;
  TCkGlobal_putPreferIpv6 = procedure (objHandle: HCkGlobal; newPropVal: wordbool); stdcall;
  TCkGlobal_getThreadPoolLogPath = procedure (objHandle: HCkGlobal; outPropVal: HCkString); stdcall;
  TCkGlobal_putThreadPoolLogPath = procedure (objHandle: HCkGlobal; newPropVal: PWideChar); stdcall;
  TCkGlobal__threadPoolLogPath = function (objHandle: HCkGlobal): PWideChar; stdcall;
  TCkGlobal_getUncommonOptions = procedure (objHandle: HCkGlobal; outPropVal: HCkString); stdcall;
  TCkGlobal_putUncommonOptions = procedure (objHandle: HCkGlobal; newPropVal: PWideChar); stdcall;
  TCkGlobal__uncommonOptions = function (objHandle: HCkGlobal): PWideChar; stdcall;
  TCkGlobal_getUnlockStatus = function (objHandle: HCkGlobal): Integer; stdcall;
  TCkGlobal_getUsePkcsConstructedEncoding = function (objHandle: HCkGlobal): wordbool; stdcall;
  TCkGlobal_putUsePkcsConstructedEncoding = procedure (objHandle: HCkGlobal; newPropVal: wordbool); stdcall;
  TCkGlobal_getVerboseLogging = function (objHandle: HCkGlobal): wordbool; stdcall;
  TCkGlobal_putVerboseLogging = procedure (objHandle: HCkGlobal; newPropVal: wordbool); stdcall;
  TCkGlobal_getVerboseTls = function (objHandle: HCkGlobal): wordbool; stdcall;
  TCkGlobal_putVerboseTls = procedure (objHandle: HCkGlobal; newPropVal: wordbool); stdcall;
  TCkGlobal_getVersion = procedure (objHandle: HCkGlobal; outPropVal: HCkString); stdcall;
  TCkGlobal__version = function (objHandle: HCkGlobal): PWideChar; stdcall;
  TCkGlobal_DnsClearCache = function (objHandle: HCkGlobal): wordbool; stdcall;
  TCkGlobal_FinalizeThreadPool = function (objHandle: HCkGlobal): wordbool; stdcall;
  TCkGlobal_ThreadPoolLogLine = function (objHandle: HCkGlobal; str: PWideChar): wordbool; stdcall;
  TCkGlobal_UnlockBundle = function (objHandle: HCkGlobal; bundleUnlockCode: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..45] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkGlobal_Create : HCkGlobal;
begin
  result := TCkGlobal_Create(_map(0, 'CkGlobal_Create'));
end;

procedure CkGlobal_Dispose (handle: HCkGlobal);
begin
  TCkGlobal_Dispose(_map(1, 'CkGlobal_Dispose'))
    (handle);
end;


function CkGlobal_getAnsiCodePage (objHandle: HCkGlobal): Integer;
begin
    result := TCkGlobal_getAnsiCodePage(_map(2, 'CkGlobal_getAnsiCodePage'))
    (objHandle);
end;

procedure CkGlobal_putAnsiCodePage (objHandle: HCkGlobal; newPropVal: Integer);
begin
  TCkGlobal_putAnsiCodePage(_map(3, 'CkGlobal_putAnsiCodePage'))
    (objHandle, newPropVal);
end;

function CkGlobal_getAutoQBDecode (objHandle: HCkGlobal): wordbool;
begin
    result := TCkGlobal_getAutoQBDecode(_map(4, 'CkGlobal_getAutoQBDecode'))
    (objHandle);
end;

procedure CkGlobal_putAutoQBDecode (objHandle: HCkGlobal; newPropVal: wordbool);
begin
  TCkGlobal_putAutoQBDecode(_map(5, 'CkGlobal_putAutoQBDecode'))
    (objHandle, newPropVal);
end;

procedure CkGlobal_getDebugLogFilePath (objHandle: HCkGlobal; outPropVal: HCkString);
begin
  TCkGlobal_getDebugLogFilePath(_map(6, 'CkGlobal_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkGlobal_putDebugLogFilePath (objHandle: HCkGlobal; newPropVal: PWideChar);
begin
  TCkGlobal_putDebugLogFilePath(_map(7, 'CkGlobal_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkGlobal__debugLogFilePath (objHandle: HCkGlobal): PWideChar;
begin
  result := TCkGlobal__debugLogFilePath(_map(8, 'CkGlobal__debugLogFilePath'))
    (objHandle);
end;

function CkGlobal_getDefaultNtlmVersion (objHandle: HCkGlobal): Integer;
begin
    result := TCkGlobal_getDefaultNtlmVersion(_map(9, 'CkGlobal_getDefaultNtlmVersion'))
    (objHandle);
end;

procedure CkGlobal_putDefaultNtlmVersion (objHandle: HCkGlobal; newPropVal: Integer);
begin
  TCkGlobal_putDefaultNtlmVersion(_map(10, 'CkGlobal_putDefaultNtlmVersion'))
    (objHandle, newPropVal);
end;

function CkGlobal_getDnsTimeToLive (objHandle: HCkGlobal): Integer;
begin
    result := TCkGlobal_getDnsTimeToLive(_map(11, 'CkGlobal_getDnsTimeToLive'))
    (objHandle);
end;

procedure CkGlobal_putDnsTimeToLive (objHandle: HCkGlobal; newPropVal: Integer);
begin
  TCkGlobal_putDnsTimeToLive(_map(12, 'CkGlobal_putDnsTimeToLive'))
    (objHandle, newPropVal);
end;

function CkGlobal_getEnableDnsCaching (objHandle: HCkGlobal): wordbool;
begin
    result := TCkGlobal_getEnableDnsCaching(_map(13, 'CkGlobal_getEnableDnsCaching'))
    (objHandle);
end;

procedure CkGlobal_putEnableDnsCaching (objHandle: HCkGlobal; newPropVal: wordbool);
begin
  TCkGlobal_putEnableDnsCaching(_map(14, 'CkGlobal_putEnableDnsCaching'))
    (objHandle, newPropVal);
end;

procedure CkGlobal_getLastErrorHtml (objHandle: HCkGlobal; outPropVal: HCkString);
begin
  TCkGlobal_getLastErrorHtml(_map(15, 'CkGlobal_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkGlobal__lastErrorHtml (objHandle: HCkGlobal): PWideChar;
begin
  result := TCkGlobal__lastErrorHtml(_map(16, 'CkGlobal__lastErrorHtml'))
    (objHandle);
end;

procedure CkGlobal_getLastErrorText (objHandle: HCkGlobal; outPropVal: HCkString);
begin
  TCkGlobal_getLastErrorText(_map(17, 'CkGlobal_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkGlobal__lastErrorText (objHandle: HCkGlobal): PWideChar;
begin
  result := TCkGlobal__lastErrorText(_map(18, 'CkGlobal__lastErrorText'))
    (objHandle);
end;

procedure CkGlobal_getLastErrorXml (objHandle: HCkGlobal; outPropVal: HCkString);
begin
  TCkGlobal_getLastErrorXml(_map(19, 'CkGlobal_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkGlobal__lastErrorXml (objHandle: HCkGlobal): PWideChar;
begin
  result := TCkGlobal__lastErrorXml(_map(20, 'CkGlobal__lastErrorXml'))
    (objHandle);
end;

function CkGlobal_getLastMethodSuccess (objHandle: HCkGlobal): wordbool;
begin
    result := TCkGlobal_getLastMethodSuccess(_map(21, 'CkGlobal_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkGlobal_putLastMethodSuccess (objHandle: HCkGlobal; newPropVal: wordbool);
begin
  TCkGlobal_putLastMethodSuccess(_map(22, 'CkGlobal_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkGlobal_getMaxThreads (objHandle: HCkGlobal): Integer;
begin
    result := TCkGlobal_getMaxThreads(_map(23, 'CkGlobal_getMaxThreads'))
    (objHandle);
end;

procedure CkGlobal_putMaxThreads (objHandle: HCkGlobal; newPropVal: Integer);
begin
  TCkGlobal_putMaxThreads(_map(24, 'CkGlobal_putMaxThreads'))
    (objHandle, newPropVal);
end;

function CkGlobal_getPreferIpv6 (objHandle: HCkGlobal): wordbool;
begin
    result := TCkGlobal_getPreferIpv6(_map(25, 'CkGlobal_getPreferIpv6'))
    (objHandle);
end;

procedure CkGlobal_putPreferIpv6 (objHandle: HCkGlobal; newPropVal: wordbool);
begin
  TCkGlobal_putPreferIpv6(_map(26, 'CkGlobal_putPreferIpv6'))
    (objHandle, newPropVal);
end;

procedure CkGlobal_getThreadPoolLogPath (objHandle: HCkGlobal; outPropVal: HCkString);
begin
  TCkGlobal_getThreadPoolLogPath(_map(27, 'CkGlobal_getThreadPoolLogPath'))
    (objHandle, outPropVal);
end;

procedure CkGlobal_putThreadPoolLogPath (objHandle: HCkGlobal; newPropVal: PWideChar);
begin
  TCkGlobal_putThreadPoolLogPath(_map(28, 'CkGlobal_putThreadPoolLogPath'))
    (objHandle, newPropVal);
end;

function CkGlobal__threadPoolLogPath (objHandle: HCkGlobal): PWideChar;
begin
  result := TCkGlobal__threadPoolLogPath(_map(29, 'CkGlobal__threadPoolLogPath'))
    (objHandle);
end;

procedure CkGlobal_getUncommonOptions (objHandle: HCkGlobal; outPropVal: HCkString);
begin
  TCkGlobal_getUncommonOptions(_map(30, 'CkGlobal_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkGlobal_putUncommonOptions (objHandle: HCkGlobal; newPropVal: PWideChar);
begin
  TCkGlobal_putUncommonOptions(_map(31, 'CkGlobal_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkGlobal__uncommonOptions (objHandle: HCkGlobal): PWideChar;
begin
  result := TCkGlobal__uncommonOptions(_map(32, 'CkGlobal__uncommonOptions'))
    (objHandle);
end;

function CkGlobal_getUnlockStatus (objHandle: HCkGlobal): Integer;
begin
    result := TCkGlobal_getUnlockStatus(_map(33, 'CkGlobal_getUnlockStatus'))
    (objHandle);
end;

function CkGlobal_getUsePkcsConstructedEncoding (objHandle: HCkGlobal): wordbool;
begin
    result := TCkGlobal_getUsePkcsConstructedEncoding(_map(34, 'CkGlobal_getUsePkcsConstructedEncoding'))
    (objHandle);
end;

procedure CkGlobal_putUsePkcsConstructedEncoding (objHandle: HCkGlobal; newPropVal: wordbool);
begin
  TCkGlobal_putUsePkcsConstructedEncoding(_map(35, 'CkGlobal_putUsePkcsConstructedEncoding'))
    (objHandle, newPropVal);
end;

function CkGlobal_getVerboseLogging (objHandle: HCkGlobal): wordbool;
begin
    result := TCkGlobal_getVerboseLogging(_map(36, 'CkGlobal_getVerboseLogging'))
    (objHandle);
end;

procedure CkGlobal_putVerboseLogging (objHandle: HCkGlobal; newPropVal: wordbool);
begin
  TCkGlobal_putVerboseLogging(_map(37, 'CkGlobal_putVerboseLogging'))
    (objHandle, newPropVal);
end;

function CkGlobal_getVerboseTls (objHandle: HCkGlobal): wordbool;
begin
    result := TCkGlobal_getVerboseTls(_map(38, 'CkGlobal_getVerboseTls'))
    (objHandle);
end;

procedure CkGlobal_putVerboseTls (objHandle: HCkGlobal; newPropVal: wordbool);
begin
  TCkGlobal_putVerboseTls(_map(39, 'CkGlobal_putVerboseTls'))
    (objHandle, newPropVal);
end;

procedure CkGlobal_getVersion (objHandle: HCkGlobal; outPropVal: HCkString);
begin
  TCkGlobal_getVersion(_map(40, 'CkGlobal_getVersion'))
    (objHandle, outPropVal);
end;

function CkGlobal__version (objHandle: HCkGlobal): PWideChar;
begin
  result := TCkGlobal__version(_map(41, 'CkGlobal__version'))
    (objHandle);
end;

function CkGlobal_DnsClearCache (objHandle: HCkGlobal): wordbool;
begin
  result := TCkGlobal_DnsClearCache(_map(42, 'CkGlobal_DnsClearCache'))
    (objHandle);
end;

function CkGlobal_FinalizeThreadPool (objHandle: HCkGlobal): wordbool;
begin
  result := TCkGlobal_FinalizeThreadPool(_map(43, 'CkGlobal_FinalizeThreadPool'))
    (objHandle);
end;

function CkGlobal_ThreadPoolLogLine (objHandle: HCkGlobal; str: PWideChar): wordbool;
begin
  result := TCkGlobal_ThreadPoolLogLine(_map(44, 'CkGlobal_ThreadPoolLogLine'))
    (objHandle, str);
end;

function CkGlobal_UnlockBundle (objHandle: HCkGlobal; bundleUnlockCode: PWideChar): wordbool;
begin
  result := TCkGlobal_UnlockBundle(_map(45, 'CkGlobal_UnlockBundle'))
    (objHandle, bundleUnlockCode);
end;

end.
