unit Gzip;

interface

type

HCkBinData = Pointer;
HCkDateTime = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkGzip = Pointer;
HCkStringBuilder = Pointer;
HCkTask = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TGzipAbortCheck = function(): Integer; cdecl;
TGzipProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TGzipPercentDone = function(pctDone: Integer): Integer; cdecl;
TGzipTaskCompleted = procedure(task: HCkTask); cdecl;


function CkGzip_Create: HCkGzip;  stdcall;
procedure CkGzip_Dispose(handle: HCkGzip); stdcall;

procedure CkGzip_SetAbortCheck(objHandle: HCkGzip; fn: TGzipAbortCheck) stdcall;
procedure CkGzip_SetProgressInfo(objHandle: HCkGzip; fn: TGzipProgressInfo) stdcall;
procedure CkGzip_SetPercentDone(objHandle: HCkGzip; fn: TGzipPercentDone) stdcall;
procedure CkGzip_SetTaskCompleted(objHandle: HCkGzip; fn: TGzipTaskCompleted) stdcall;
function CkGzip_getAbortCurrent(objHandle: HCkGzip): wordbool;
procedure CkGzip_putAbortCurrent(objHandle: HCkGzip; newPropVal: wordbool);
procedure CkGzip_getComment(objHandle: HCkGzip; outPropVal: HCkString);
procedure CkGzip_putComment(objHandle: HCkGzip; newPropVal: PWideChar);
function CkGzip__comment(objHandle: HCkGzip): PWideChar;
function CkGzip_getCompressionLevel(objHandle: HCkGzip): Integer;
procedure CkGzip_putCompressionLevel(objHandle: HCkGzip; newPropVal: Integer);
procedure CkGzip_getDebugLogFilePath(objHandle: HCkGzip; outPropVal: HCkString);
procedure CkGzip_putDebugLogFilePath(objHandle: HCkGzip; newPropVal: PWideChar);
function CkGzip__debugLogFilePath(objHandle: HCkGzip): PWideChar;
procedure CkGzip_getFilename(objHandle: HCkGzip; outPropVal: HCkString);
procedure CkGzip_putFilename(objHandle: HCkGzip; newPropVal: PWideChar);
function CkGzip__filename(objHandle: HCkGzip): PWideChar;
function CkGzip_getHeartbeatMs(objHandle: HCkGzip): Integer;
procedure CkGzip_putHeartbeatMs(objHandle: HCkGzip; newPropVal: Integer);
procedure CkGzip_getLastErrorHtml(objHandle: HCkGzip; outPropVal: HCkString);
function CkGzip__lastErrorHtml(objHandle: HCkGzip): PWideChar;
procedure CkGzip_getLastErrorText(objHandle: HCkGzip; outPropVal: HCkString);
function CkGzip__lastErrorText(objHandle: HCkGzip): PWideChar;
procedure CkGzip_getLastErrorXml(objHandle: HCkGzip; outPropVal: HCkString);
function CkGzip__lastErrorXml(objHandle: HCkGzip): PWideChar;
function CkGzip_getLastMethodSuccess(objHandle: HCkGzip): wordbool;
procedure CkGzip_putLastMethodSuccess(objHandle: HCkGzip; newPropVal: wordbool);
procedure CkGzip_getLastModStr(objHandle: HCkGzip; outPropVal: HCkString);
procedure CkGzip_putLastModStr(objHandle: HCkGzip; newPropVal: PWideChar);
function CkGzip__lastModStr(objHandle: HCkGzip): PWideChar;
function CkGzip_getUseCurrentDate(objHandle: HCkGzip): wordbool;
procedure CkGzip_putUseCurrentDate(objHandle: HCkGzip; newPropVal: wordbool);
function CkGzip_getVerboseLogging(objHandle: HCkGzip): wordbool;
procedure CkGzip_putVerboseLogging(objHandle: HCkGzip; newPropVal: wordbool);
procedure CkGzip_getVersion(objHandle: HCkGzip; outPropVal: HCkString);
function CkGzip__version(objHandle: HCkGzip): PWideChar;
function CkGzip_CompressBd(objHandle: HCkGzip; binDat: HCkBinData): wordbool;
function CkGzip_CompressBdAsync(objHandle: HCkGzip; binDat: HCkBinData): HCkTask;
function CkGzip_CompressFile(objHandle: HCkGzip; inFilename: PWideChar; destPath: PWideChar): wordbool;
function CkGzip_CompressFileAsync(objHandle: HCkGzip; inFilename: PWideChar; destPath: PWideChar): HCkTask;
function CkGzip_CompressFile2(objHandle: HCkGzip; inFilename: PWideChar; embeddedFilename: PWideChar; destPath: PWideChar): wordbool;
function CkGzip_CompressFile2Async(objHandle: HCkGzip; inFilename: PWideChar; embeddedFilename: PWideChar; destPath: PWideChar): HCkTask;
function CkGzip_CompressFileBd(objHandle: HCkGzip; filePath: PWideChar; bd: HCkBinData): wordbool;
function CkGzip_CompressFileBdAsync(objHandle: HCkGzip; filePath: PWideChar; bd: HCkBinData): HCkTask;
function CkGzip_CompressFileToMem(objHandle: HCkGzip; inFilename: PWideChar; outData: HCkByteData): wordbool;
function CkGzip_CompressFileToMemAsync(objHandle: HCkGzip; inFilename: PWideChar): HCkTask;
function CkGzip_CompressMemory(objHandle: HCkGzip; inData: HCkByteData; outData: HCkByteData): wordbool;
function CkGzip_CompressMemoryAsync(objHandle: HCkGzip; inData: HCkByteData): HCkTask;
function CkGzip_CompressMemToFile(objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): wordbool;
function CkGzip_CompressMemToFileAsync(objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): HCkTask;
function CkGzip_CompressSb(objHandle: HCkGzip; sb: HCkStringBuilder; charset: PWideChar; bd: HCkBinData): wordbool;
function CkGzip_CompressSbAsync(objHandle: HCkGzip; sb: HCkStringBuilder; charset: PWideChar; bd: HCkBinData): HCkTask;
function CkGzip_CompressString(objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar; outData: HCkByteData): wordbool;
function CkGzip_CompressStringAsync(objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar): HCkTask;
function CkGzip_CompressStringENC(objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
function CkGzip__compressStringENC(objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar): PWideChar;
function CkGzip_CompressStringToFile(objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar; destPath: PWideChar): wordbool;
function CkGzip_CompressStringToFileAsync(objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar; destPath: PWideChar): HCkTask;
function CkGzip_Decode(objHandle: HCkGzip; encodedStr: PWideChar; encoding: PWideChar; outData: HCkByteData): wordbool;
function CkGzip_DeflateStringENC(objHandle: HCkGzip; inString: PWideChar; charsetName: PWideChar; outputEncoding: PWideChar; outStr: HCkString): wordbool;
function CkGzip__deflateStringENC(objHandle: HCkGzip; inString: PWideChar; charsetName: PWideChar; outputEncoding: PWideChar): PWideChar;
function CkGzip_Encode(objHandle: HCkGzip; byteData: HCkByteData; encoding: PWideChar; outStr: HCkString): wordbool;
function CkGzip__encode(objHandle: HCkGzip; byteData: HCkByteData; encoding: PWideChar): PWideChar;
function CkGzip_ExamineFile(objHandle: HCkGzip; inGzFilename: PWideChar): wordbool;
function CkGzip_ExamineMemory(objHandle: HCkGzip; inGzData: HCkByteData): wordbool;
function CkGzip_GetDt(objHandle: HCkGzip): HCkDateTime;
function CkGzip_InflateStringENC(objHandle: HCkGzip; inString: PWideChar; convertFromCharset: PWideChar; inputEncoding: PWideChar; outStr: HCkString): wordbool;
function CkGzip__inflateStringENC(objHandle: HCkGzip; inString: PWideChar; convertFromCharset: PWideChar; inputEncoding: PWideChar): PWideChar;
function CkGzip_IsGzip(objHandle: HCkGzip; bd: HCkBinData): wordbool;
function CkGzip_LoadTaskCaller(objHandle: HCkGzip; task: HCkTask): wordbool;
function CkGzip_ReadFile(objHandle: HCkGzip; path: PWideChar; outData: HCkByteData): wordbool;
function CkGzip_SetDt(objHandle: HCkGzip; dt: HCkDateTime): wordbool;
function CkGzip_SetExtraData(objHandle: HCkGzip; encodedData: PWideChar; encoding: PWideChar): wordbool;
function CkGzip_UncompressBd(objHandle: HCkGzip; binDat: HCkBinData): wordbool;
function CkGzip_UncompressBdAsync(objHandle: HCkGzip; binDat: HCkBinData): HCkTask;
function CkGzip_UncompressBdToFile(objHandle: HCkGzip; bd: HCkBinData; filePath: PWideChar): wordbool;
function CkGzip_UncompressBdToFileAsync(objHandle: HCkGzip; bd: HCkBinData; filePath: PWideChar): HCkTask;
function CkGzip_UncompressFile(objHandle: HCkGzip; srcPath: PWideChar; destPath: PWideChar): wordbool;
function CkGzip_UncompressFileAsync(objHandle: HCkGzip; srcPath: PWideChar; destPath: PWideChar): HCkTask;
function CkGzip_UncompressFileToMem(objHandle: HCkGzip; inFilename: PWideChar; outData: HCkByteData): wordbool;
function CkGzip_UncompressFileToMemAsync(objHandle: HCkGzip; inFilename: PWideChar): HCkTask;
function CkGzip_UncompressFileToString(objHandle: HCkGzip; gzFilename: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkGzip__uncompressFileToString(objHandle: HCkGzip; gzFilename: PWideChar; charset: PWideChar): PWideChar;
function CkGzip_UncompressFileToStringAsync(objHandle: HCkGzip; gzFilename: PWideChar; charset: PWideChar): HCkTask;
function CkGzip_UncompressMemory(objHandle: HCkGzip; inData: HCkByteData; outData: HCkByteData): wordbool;
function CkGzip_UncompressMemoryAsync(objHandle: HCkGzip; inData: HCkByteData): HCkTask;
function CkGzip_UncompressMemToFile(objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): wordbool;
function CkGzip_UncompressMemToFileAsync(objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): HCkTask;
function CkGzip_UncompressString(objHandle: HCkGzip; inData: HCkByteData; inCharset: PWideChar; outStr: HCkString): wordbool;
function CkGzip__uncompressString(objHandle: HCkGzip; inData: HCkByteData; inCharset: PWideChar): PWideChar;
function CkGzip_UncompressStringAsync(objHandle: HCkGzip; inData: HCkByteData; inCharset: PWideChar): HCkTask;
function CkGzip_UncompressStringENC(objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
function CkGzip__uncompressStringENC(objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar): PWideChar;
function CkGzip_UnTarGz(objHandle: HCkGzip; tgzFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): wordbool;
function CkGzip_UnTarGzAsync(objHandle: HCkGzip; tgzFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): HCkTask;
function CkGzip_WriteFile(objHandle: HCkGzip; path: PWideChar; binaryData: HCkByteData): wordbool;
function CkGzip_XfdlToXml(objHandle: HCkGzip; xfldData: PWideChar; outStr: HCkString): wordbool;
function CkGzip__xfdlToXml(objHandle: HCkGzip; xfldData: PWideChar): PWideChar;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkGzip_Create = function : HCkGzip; stdcall;
  TCkGzip_Dispose = procedure (handle: HCkGzip); stdcall;
  TCkGzip_SetAbortCheck = procedure (objHandle: HCkGzip; fn: TGzipAbortCheck); stdcall;
  TCkGzip_SetProgressInfo = procedure (objHandle: HCkGzip; fn: TGzipProgressInfo); stdcall;
  TCkGzip_SetPercentDone = procedure (objHandle: HCkGzip; fn: TGzipPercentDone); stdcall;
  TCkGzip_SetTaskCompleted = procedure (objHandle: HCkGzip; fn: TGzipTaskCompleted); stdcall;
  TCkGzip_getAbortCurrent = function (objHandle: HCkGzip): wordbool; stdcall;
  TCkGzip_putAbortCurrent = procedure (objHandle: HCkGzip; newPropVal: wordbool); stdcall;
  TCkGzip_getComment = procedure (objHandle: HCkGzip; outPropVal: HCkString); stdcall;
  TCkGzip_putComment = procedure (objHandle: HCkGzip; newPropVal: PWideChar); stdcall;
  TCkGzip__comment = function (objHandle: HCkGzip): PWideChar; stdcall;
  TCkGzip_getCompressionLevel = function (objHandle: HCkGzip): Integer; stdcall;
  TCkGzip_putCompressionLevel = procedure (objHandle: HCkGzip; newPropVal: Integer); stdcall;
  TCkGzip_getDebugLogFilePath = procedure (objHandle: HCkGzip; outPropVal: HCkString); stdcall;
  TCkGzip_putDebugLogFilePath = procedure (objHandle: HCkGzip; newPropVal: PWideChar); stdcall;
  TCkGzip__debugLogFilePath = function (objHandle: HCkGzip): PWideChar; stdcall;
  TCkGzip_getFilename = procedure (objHandle: HCkGzip; outPropVal: HCkString); stdcall;
  TCkGzip_putFilename = procedure (objHandle: HCkGzip; newPropVal: PWideChar); stdcall;
  TCkGzip__filename = function (objHandle: HCkGzip): PWideChar; stdcall;
  TCkGzip_getHeartbeatMs = function (objHandle: HCkGzip): Integer; stdcall;
  TCkGzip_putHeartbeatMs = procedure (objHandle: HCkGzip; newPropVal: Integer); stdcall;
  TCkGzip_getLastErrorHtml = procedure (objHandle: HCkGzip; outPropVal: HCkString); stdcall;
  TCkGzip__lastErrorHtml = function (objHandle: HCkGzip): PWideChar; stdcall;
  TCkGzip_getLastErrorText = procedure (objHandle: HCkGzip; outPropVal: HCkString); stdcall;
  TCkGzip__lastErrorText = function (objHandle: HCkGzip): PWideChar; stdcall;
  TCkGzip_getLastErrorXml = procedure (objHandle: HCkGzip; outPropVal: HCkString); stdcall;
  TCkGzip__lastErrorXml = function (objHandle: HCkGzip): PWideChar; stdcall;
  TCkGzip_getLastMethodSuccess = function (objHandle: HCkGzip): wordbool; stdcall;
  TCkGzip_putLastMethodSuccess = procedure (objHandle: HCkGzip; newPropVal: wordbool); stdcall;
  TCkGzip_getLastModStr = procedure (objHandle: HCkGzip; outPropVal: HCkString); stdcall;
  TCkGzip_putLastModStr = procedure (objHandle: HCkGzip; newPropVal: PWideChar); stdcall;
  TCkGzip__lastModStr = function (objHandle: HCkGzip): PWideChar; stdcall;
  TCkGzip_getUseCurrentDate = function (objHandle: HCkGzip): wordbool; stdcall;
  TCkGzip_putUseCurrentDate = procedure (objHandle: HCkGzip; newPropVal: wordbool); stdcall;
  TCkGzip_getVerboseLogging = function (objHandle: HCkGzip): wordbool; stdcall;
  TCkGzip_putVerboseLogging = procedure (objHandle: HCkGzip; newPropVal: wordbool); stdcall;
  TCkGzip_getVersion = procedure (objHandle: HCkGzip; outPropVal: HCkString); stdcall;
  TCkGzip__version = function (objHandle: HCkGzip): PWideChar; stdcall;
  TCkGzip_CompressBd = function (objHandle: HCkGzip; binDat: HCkBinData): wordbool; stdcall;
  TCkGzip_CompressBdAsync = function (objHandle: HCkGzip; binDat: HCkBinData): HCkTask; stdcall;
  TCkGzip_CompressFile = function (objHandle: HCkGzip; inFilename: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkGzip_CompressFileAsync = function (objHandle: HCkGzip; inFilename: PWideChar; destPath: PWideChar): HCkTask; stdcall;
  TCkGzip_CompressFile2 = function (objHandle: HCkGzip; inFilename: PWideChar; embeddedFilename: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkGzip_CompressFile2Async = function (objHandle: HCkGzip; inFilename: PWideChar; embeddedFilename: PWideChar; destPath: PWideChar): HCkTask; stdcall;
  TCkGzip_CompressFileBd = function (objHandle: HCkGzip; filePath: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkGzip_CompressFileBdAsync = function (objHandle: HCkGzip; filePath: PWideChar; bd: HCkBinData): HCkTask; stdcall;
  TCkGzip_CompressFileToMem = function (objHandle: HCkGzip; inFilename: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkGzip_CompressFileToMemAsync = function (objHandle: HCkGzip; inFilename: PWideChar): HCkTask; stdcall;
  TCkGzip_CompressMemory = function (objHandle: HCkGzip; inData: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkGzip_CompressMemoryAsync = function (objHandle: HCkGzip; inData: HCkByteData): HCkTask; stdcall;
  TCkGzip_CompressMemToFile = function (objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): wordbool; stdcall;
  TCkGzip_CompressMemToFileAsync = function (objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): HCkTask; stdcall;
  TCkGzip_CompressSb = function (objHandle: HCkGzip; sb: HCkStringBuilder; charset: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkGzip_CompressSbAsync = function (objHandle: HCkGzip; sb: HCkStringBuilder; charset: PWideChar; bd: HCkBinData): HCkTask; stdcall;
  TCkGzip_CompressString = function (objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkGzip_CompressStringAsync = function (objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar): HCkTask; stdcall;
  TCkGzip_CompressStringENC = function (objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkGzip__compressStringENC = function (objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar): PWideChar; stdcall;
  TCkGzip_CompressStringToFile = function (objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkGzip_CompressStringToFileAsync = function (objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar; destPath: PWideChar): HCkTask; stdcall;
  TCkGzip_Decode = function (objHandle: HCkGzip; encodedStr: PWideChar; encoding: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkGzip_DeflateStringENC = function (objHandle: HCkGzip; inString: PWideChar; charsetName: PWideChar; outputEncoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkGzip__deflateStringENC = function (objHandle: HCkGzip; inString: PWideChar; charsetName: PWideChar; outputEncoding: PWideChar): PWideChar; stdcall;
  TCkGzip_Encode = function (objHandle: HCkGzip; byteData: HCkByteData; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkGzip__encode = function (objHandle: HCkGzip; byteData: HCkByteData; encoding: PWideChar): PWideChar; stdcall;
  TCkGzip_ExamineFile = function (objHandle: HCkGzip; inGzFilename: PWideChar): wordbool; stdcall;
  TCkGzip_ExamineMemory = function (objHandle: HCkGzip; inGzData: HCkByteData): wordbool; stdcall;
  TCkGzip_GetDt = function (objHandle: HCkGzip): HCkDateTime; stdcall;
  TCkGzip_InflateStringENC = function (objHandle: HCkGzip; inString: PWideChar; convertFromCharset: PWideChar; inputEncoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkGzip__inflateStringENC = function (objHandle: HCkGzip; inString: PWideChar; convertFromCharset: PWideChar; inputEncoding: PWideChar): PWideChar; stdcall;
  TCkGzip_IsGzip = function (objHandle: HCkGzip; bd: HCkBinData): wordbool; stdcall;
  TCkGzip_LoadTaskCaller = function (objHandle: HCkGzip; task: HCkTask): wordbool; stdcall;
  TCkGzip_ReadFile = function (objHandle: HCkGzip; path: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkGzip_SetDt = function (objHandle: HCkGzip; dt: HCkDateTime): wordbool; stdcall;
  TCkGzip_SetExtraData = function (objHandle: HCkGzip; encodedData: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkGzip_UncompressBd = function (objHandle: HCkGzip; binDat: HCkBinData): wordbool; stdcall;
  TCkGzip_UncompressBdAsync = function (objHandle: HCkGzip; binDat: HCkBinData): HCkTask; stdcall;
  TCkGzip_UncompressBdToFile = function (objHandle: HCkGzip; bd: HCkBinData; filePath: PWideChar): wordbool; stdcall;
  TCkGzip_UncompressBdToFileAsync = function (objHandle: HCkGzip; bd: HCkBinData; filePath: PWideChar): HCkTask; stdcall;
  TCkGzip_UncompressFile = function (objHandle: HCkGzip; srcPath: PWideChar; destPath: PWideChar): wordbool; stdcall;
  TCkGzip_UncompressFileAsync = function (objHandle: HCkGzip; srcPath: PWideChar; destPath: PWideChar): HCkTask; stdcall;
  TCkGzip_UncompressFileToMem = function (objHandle: HCkGzip; inFilename: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkGzip_UncompressFileToMemAsync = function (objHandle: HCkGzip; inFilename: PWideChar): HCkTask; stdcall;
  TCkGzip_UncompressFileToString = function (objHandle: HCkGzip; gzFilename: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkGzip__uncompressFileToString = function (objHandle: HCkGzip; gzFilename: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkGzip_UncompressFileToStringAsync = function (objHandle: HCkGzip; gzFilename: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkGzip_UncompressMemory = function (objHandle: HCkGzip; inData: HCkByteData; outData: HCkByteData): wordbool; stdcall;
  TCkGzip_UncompressMemoryAsync = function (objHandle: HCkGzip; inData: HCkByteData): HCkTask; stdcall;
  TCkGzip_UncompressMemToFile = function (objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): wordbool; stdcall;
  TCkGzip_UncompressMemToFileAsync = function (objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): HCkTask; stdcall;
  TCkGzip_UncompressString = function (objHandle: HCkGzip; inData: HCkByteData; inCharset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkGzip__uncompressString = function (objHandle: HCkGzip; inData: HCkByteData; inCharset: PWideChar): PWideChar; stdcall;
  TCkGzip_UncompressStringAsync = function (objHandle: HCkGzip; inData: HCkByteData; inCharset: PWideChar): HCkTask; stdcall;
  TCkGzip_UncompressStringENC = function (objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkGzip__uncompressStringENC = function (objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar): PWideChar; stdcall;
  TCkGzip_UnTarGz = function (objHandle: HCkGzip; tgzFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): wordbool; stdcall;
  TCkGzip_UnTarGzAsync = function (objHandle: HCkGzip; tgzFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): HCkTask; stdcall;
  TCkGzip_WriteFile = function (objHandle: HCkGzip; path: PWideChar; binaryData: HCkByteData): wordbool; stdcall;
  TCkGzip_XfdlToXml = function (objHandle: HCkGzip; xfldData: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkGzip__xfdlToXml = function (objHandle: HCkGzip; xfldData: PWideChar): PWideChar; stdcall;

var
  _fkt_ptr_arr:   array [0..99] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkGzip_Create : HCkGzip;
begin
  result := TCkGzip_Create(_map(0, 'CkGzip_Create'));
end;

procedure CkGzip_Dispose (handle: HCkGzip);
begin
  TCkGzip_Dispose(_map(1, 'CkGzip_Dispose'))
    (handle);
end;


procedure CkGzip_SetAbortCheck (objHandle: HCkGzip; fn: TGzipAbortCheck);
begin
    TCkGzip_SetAbortCheck(_map(2, 'CkGzip_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkGzip_SetProgressInfo (objHandle: HCkGzip; fn: TGzipProgressInfo);
begin
    TCkGzip_SetProgressInfo(_map(3, 'CkGzip_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkGzip_SetPercentDone (objHandle: HCkGzip; fn: TGzipPercentDone);
begin
    TCkGzip_SetPercentDone(_map(4, 'CkGzip_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkGzip_SetTaskCompleted (objHandle: HCkGzip; fn: TGzipTaskCompleted);
begin
    TCkGzip_SetTaskCompleted(_map(5, 'CkGzip_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkGzip_getAbortCurrent (objHandle: HCkGzip): wordbool;
begin
    result := TCkGzip_getAbortCurrent(_map(6, 'CkGzip_getAbortCurrent'))
    (objHandle);
end;

procedure CkGzip_putAbortCurrent (objHandle: HCkGzip; newPropVal: wordbool);
begin
  TCkGzip_putAbortCurrent(_map(7, 'CkGzip_putAbortCurrent'))
    (objHandle, newPropVal);
end;

procedure CkGzip_getComment (objHandle: HCkGzip; outPropVal: HCkString);
begin
  TCkGzip_getComment(_map(8, 'CkGzip_getComment'))
    (objHandle, outPropVal);
end;

procedure CkGzip_putComment (objHandle: HCkGzip; newPropVal: PWideChar);
begin
  TCkGzip_putComment(_map(9, 'CkGzip_putComment'))
    (objHandle, newPropVal);
end;

function CkGzip__comment (objHandle: HCkGzip): PWideChar;
begin
  result := TCkGzip__comment(_map(10, 'CkGzip__comment'))
    (objHandle);
end;

function CkGzip_getCompressionLevel (objHandle: HCkGzip): Integer;
begin
    result := TCkGzip_getCompressionLevel(_map(11, 'CkGzip_getCompressionLevel'))
    (objHandle);
end;

procedure CkGzip_putCompressionLevel (objHandle: HCkGzip; newPropVal: Integer);
begin
  TCkGzip_putCompressionLevel(_map(12, 'CkGzip_putCompressionLevel'))
    (objHandle, newPropVal);
end;

procedure CkGzip_getDebugLogFilePath (objHandle: HCkGzip; outPropVal: HCkString);
begin
  TCkGzip_getDebugLogFilePath(_map(13, 'CkGzip_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkGzip_putDebugLogFilePath (objHandle: HCkGzip; newPropVal: PWideChar);
begin
  TCkGzip_putDebugLogFilePath(_map(14, 'CkGzip_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkGzip__debugLogFilePath (objHandle: HCkGzip): PWideChar;
begin
  result := TCkGzip__debugLogFilePath(_map(15, 'CkGzip__debugLogFilePath'))
    (objHandle);
end;

procedure CkGzip_getFilename (objHandle: HCkGzip; outPropVal: HCkString);
begin
  TCkGzip_getFilename(_map(16, 'CkGzip_getFilename'))
    (objHandle, outPropVal);
end;

procedure CkGzip_putFilename (objHandle: HCkGzip; newPropVal: PWideChar);
begin
  TCkGzip_putFilename(_map(17, 'CkGzip_putFilename'))
    (objHandle, newPropVal);
end;

function CkGzip__filename (objHandle: HCkGzip): PWideChar;
begin
  result := TCkGzip__filename(_map(18, 'CkGzip__filename'))
    (objHandle);
end;

function CkGzip_getHeartbeatMs (objHandle: HCkGzip): Integer;
begin
    result := TCkGzip_getHeartbeatMs(_map(19, 'CkGzip_getHeartbeatMs'))
    (objHandle);
end;

procedure CkGzip_putHeartbeatMs (objHandle: HCkGzip; newPropVal: Integer);
begin
  TCkGzip_putHeartbeatMs(_map(20, 'CkGzip_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkGzip_getLastErrorHtml (objHandle: HCkGzip; outPropVal: HCkString);
begin
  TCkGzip_getLastErrorHtml(_map(21, 'CkGzip_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkGzip__lastErrorHtml (objHandle: HCkGzip): PWideChar;
begin
  result := TCkGzip__lastErrorHtml(_map(22, 'CkGzip__lastErrorHtml'))
    (objHandle);
end;

procedure CkGzip_getLastErrorText (objHandle: HCkGzip; outPropVal: HCkString);
begin
  TCkGzip_getLastErrorText(_map(23, 'CkGzip_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkGzip__lastErrorText (objHandle: HCkGzip): PWideChar;
begin
  result := TCkGzip__lastErrorText(_map(24, 'CkGzip__lastErrorText'))
    (objHandle);
end;

procedure CkGzip_getLastErrorXml (objHandle: HCkGzip; outPropVal: HCkString);
begin
  TCkGzip_getLastErrorXml(_map(25, 'CkGzip_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkGzip__lastErrorXml (objHandle: HCkGzip): PWideChar;
begin
  result := TCkGzip__lastErrorXml(_map(26, 'CkGzip__lastErrorXml'))
    (objHandle);
end;

function CkGzip_getLastMethodSuccess (objHandle: HCkGzip): wordbool;
begin
    result := TCkGzip_getLastMethodSuccess(_map(27, 'CkGzip_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkGzip_putLastMethodSuccess (objHandle: HCkGzip; newPropVal: wordbool);
begin
  TCkGzip_putLastMethodSuccess(_map(28, 'CkGzip_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkGzip_getLastModStr (objHandle: HCkGzip; outPropVal: HCkString);
begin
  TCkGzip_getLastModStr(_map(29, 'CkGzip_getLastModStr'))
    (objHandle, outPropVal);
end;

procedure CkGzip_putLastModStr (objHandle: HCkGzip; newPropVal: PWideChar);
begin
  TCkGzip_putLastModStr(_map(30, 'CkGzip_putLastModStr'))
    (objHandle, newPropVal);
end;

function CkGzip__lastModStr (objHandle: HCkGzip): PWideChar;
begin
  result := TCkGzip__lastModStr(_map(31, 'CkGzip__lastModStr'))
    (objHandle);
end;

function CkGzip_getUseCurrentDate (objHandle: HCkGzip): wordbool;
begin
    result := TCkGzip_getUseCurrentDate(_map(32, 'CkGzip_getUseCurrentDate'))
    (objHandle);
end;

procedure CkGzip_putUseCurrentDate (objHandle: HCkGzip; newPropVal: wordbool);
begin
  TCkGzip_putUseCurrentDate(_map(33, 'CkGzip_putUseCurrentDate'))
    (objHandle, newPropVal);
end;

function CkGzip_getVerboseLogging (objHandle: HCkGzip): wordbool;
begin
    result := TCkGzip_getVerboseLogging(_map(34, 'CkGzip_getVerboseLogging'))
    (objHandle);
end;

procedure CkGzip_putVerboseLogging (objHandle: HCkGzip; newPropVal: wordbool);
begin
  TCkGzip_putVerboseLogging(_map(35, 'CkGzip_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkGzip_getVersion (objHandle: HCkGzip; outPropVal: HCkString);
begin
  TCkGzip_getVersion(_map(36, 'CkGzip_getVersion'))
    (objHandle, outPropVal);
end;

function CkGzip__version (objHandle: HCkGzip): PWideChar;
begin
  result := TCkGzip__version(_map(37, 'CkGzip__version'))
    (objHandle);
end;

function CkGzip_CompressBd (objHandle: HCkGzip; binDat: HCkBinData): wordbool;
begin
  result := TCkGzip_CompressBd(_map(38, 'CkGzip_CompressBd'))
    (objHandle, binDat);
end;

function CkGzip_CompressBdAsync (objHandle: HCkGzip; binDat: HCkBinData): HCkTask;
begin
  result := TCkGzip_CompressBdAsync(_map(39, 'CkGzip_CompressBdAsync'))
    (objHandle, binDat);
end;

function CkGzip_CompressFile (objHandle: HCkGzip; inFilename: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkGzip_CompressFile(_map(40, 'CkGzip_CompressFile'))
    (objHandle, inFilename, destPath);
end;

function CkGzip_CompressFileAsync (objHandle: HCkGzip; inFilename: PWideChar; destPath: PWideChar): HCkTask;
begin
  result := TCkGzip_CompressFileAsync(_map(41, 'CkGzip_CompressFileAsync'))
    (objHandle, inFilename, destPath);
end;

function CkGzip_CompressFile2 (objHandle: HCkGzip; inFilename: PWideChar; embeddedFilename: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkGzip_CompressFile2(_map(42, 'CkGzip_CompressFile2'))
    (objHandle, inFilename, embeddedFilename, destPath);
end;

function CkGzip_CompressFile2Async (objHandle: HCkGzip; inFilename: PWideChar; embeddedFilename: PWideChar; destPath: PWideChar): HCkTask;
begin
  result := TCkGzip_CompressFile2Async(_map(43, 'CkGzip_CompressFile2Async'))
    (objHandle, inFilename, embeddedFilename, destPath);
end;

function CkGzip_CompressFileBd (objHandle: HCkGzip; filePath: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkGzip_CompressFileBd(_map(44, 'CkGzip_CompressFileBd'))
    (objHandle, filePath, bd);
end;

function CkGzip_CompressFileBdAsync (objHandle: HCkGzip; filePath: PWideChar; bd: HCkBinData): HCkTask;
begin
  result := TCkGzip_CompressFileBdAsync(_map(45, 'CkGzip_CompressFileBdAsync'))
    (objHandle, filePath, bd);
end;

function CkGzip_CompressFileToMem (objHandle: HCkGzip; inFilename: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkGzip_CompressFileToMem(_map(46, 'CkGzip_CompressFileToMem'))
    (objHandle, inFilename, outData);
end;

function CkGzip_CompressFileToMemAsync (objHandle: HCkGzip; inFilename: PWideChar): HCkTask;
begin
  result := TCkGzip_CompressFileToMemAsync(_map(47, 'CkGzip_CompressFileToMemAsync'))
    (objHandle, inFilename);
end;

function CkGzip_CompressMemory (objHandle: HCkGzip; inData: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkGzip_CompressMemory(_map(48, 'CkGzip_CompressMemory'))
    (objHandle, inData, outData);
end;

function CkGzip_CompressMemoryAsync (objHandle: HCkGzip; inData: HCkByteData): HCkTask;
begin
  result := TCkGzip_CompressMemoryAsync(_map(49, 'CkGzip_CompressMemoryAsync'))
    (objHandle, inData);
end;

function CkGzip_CompressMemToFile (objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): wordbool;
begin
  result := TCkGzip_CompressMemToFile(_map(50, 'CkGzip_CompressMemToFile'))
    (objHandle, inData, destPath);
end;

function CkGzip_CompressMemToFileAsync (objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): HCkTask;
begin
  result := TCkGzip_CompressMemToFileAsync(_map(51, 'CkGzip_CompressMemToFileAsync'))
    (objHandle, inData, destPath);
end;

function CkGzip_CompressSb (objHandle: HCkGzip; sb: HCkStringBuilder; charset: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkGzip_CompressSb(_map(52, 'CkGzip_CompressSb'))
    (objHandle, sb, charset, bd);
end;

function CkGzip_CompressSbAsync (objHandle: HCkGzip; sb: HCkStringBuilder; charset: PWideChar; bd: HCkBinData): HCkTask;
begin
  result := TCkGzip_CompressSbAsync(_map(53, 'CkGzip_CompressSbAsync'))
    (objHandle, sb, charset, bd);
end;

function CkGzip_CompressString (objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkGzip_CompressString(_map(54, 'CkGzip_CompressString'))
    (objHandle, inStr, destCharset, outData);
end;

function CkGzip_CompressStringAsync (objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar): HCkTask;
begin
  result := TCkGzip_CompressStringAsync(_map(55, 'CkGzip_CompressStringAsync'))
    (objHandle, inStr, destCharset);
end;

function CkGzip_CompressStringENC (objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkGzip_CompressStringENC(_map(56, 'CkGzip_CompressStringENC'))
    (objHandle, inStr, charset, encoding, outStr);
end;

function CkGzip__compressStringENC (objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar): PWideChar;
begin
  result := TCkGzip__compressStringENC(_map(57, 'CkGzip__compressStringENC'))
    (objHandle, inStr, charset, encoding);
end;

function CkGzip_CompressStringToFile (objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkGzip_CompressStringToFile(_map(58, 'CkGzip_CompressStringToFile'))
    (objHandle, inStr, destCharset, destPath);
end;

function CkGzip_CompressStringToFileAsync (objHandle: HCkGzip; inStr: PWideChar; destCharset: PWideChar; destPath: PWideChar): HCkTask;
begin
  result := TCkGzip_CompressStringToFileAsync(_map(59, 'CkGzip_CompressStringToFileAsync'))
    (objHandle, inStr, destCharset, destPath);
end;

function CkGzip_Decode (objHandle: HCkGzip; encodedStr: PWideChar; encoding: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkGzip_Decode(_map(60, 'CkGzip_Decode'))
    (objHandle, encodedStr, encoding, outData);
end;

function CkGzip_DeflateStringENC (objHandle: HCkGzip; inString: PWideChar; charsetName: PWideChar; outputEncoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkGzip_DeflateStringENC(_map(61, 'CkGzip_DeflateStringENC'))
    (objHandle, inString, charsetName, outputEncoding, outStr);
end;

function CkGzip__deflateStringENC (objHandle: HCkGzip; inString: PWideChar; charsetName: PWideChar; outputEncoding: PWideChar): PWideChar;
begin
  result := TCkGzip__deflateStringENC(_map(62, 'CkGzip__deflateStringENC'))
    (objHandle, inString, charsetName, outputEncoding);
end;

function CkGzip_Encode (objHandle: HCkGzip; byteData: HCkByteData; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkGzip_Encode(_map(63, 'CkGzip_Encode'))
    (objHandle, byteData, encoding, outStr);
end;

function CkGzip__encode (objHandle: HCkGzip; byteData: HCkByteData; encoding: PWideChar): PWideChar;
begin
  result := TCkGzip__encode(_map(64, 'CkGzip__encode'))
    (objHandle, byteData, encoding);
end;

function CkGzip_ExamineFile (objHandle: HCkGzip; inGzFilename: PWideChar): wordbool;
begin
  result := TCkGzip_ExamineFile(_map(65, 'CkGzip_ExamineFile'))
    (objHandle, inGzFilename);
end;

function CkGzip_ExamineMemory (objHandle: HCkGzip; inGzData: HCkByteData): wordbool;
begin
  result := TCkGzip_ExamineMemory(_map(66, 'CkGzip_ExamineMemory'))
    (objHandle, inGzData);
end;

function CkGzip_GetDt (objHandle: HCkGzip): HCkDateTime;
begin
  result := TCkGzip_GetDt(_map(67, 'CkGzip_GetDt'))
    (objHandle);
end;

function CkGzip_InflateStringENC (objHandle: HCkGzip; inString: PWideChar; convertFromCharset: PWideChar; inputEncoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkGzip_InflateStringENC(_map(68, 'CkGzip_InflateStringENC'))
    (objHandle, inString, convertFromCharset, inputEncoding, outStr);
end;

function CkGzip__inflateStringENC (objHandle: HCkGzip; inString: PWideChar; convertFromCharset: PWideChar; inputEncoding: PWideChar): PWideChar;
begin
  result := TCkGzip__inflateStringENC(_map(69, 'CkGzip__inflateStringENC'))
    (objHandle, inString, convertFromCharset, inputEncoding);
end;

function CkGzip_IsGzip (objHandle: HCkGzip; bd: HCkBinData): wordbool;
begin
  result := TCkGzip_IsGzip(_map(70, 'CkGzip_IsGzip'))
    (objHandle, bd);
end;

function CkGzip_LoadTaskCaller (objHandle: HCkGzip; task: HCkTask): wordbool;
begin
  result := TCkGzip_LoadTaskCaller(_map(71, 'CkGzip_LoadTaskCaller'))
    (objHandle, task);
end;

function CkGzip_ReadFile (objHandle: HCkGzip; path: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkGzip_ReadFile(_map(72, 'CkGzip_ReadFile'))
    (objHandle, path, outData);
end;

function CkGzip_SetDt (objHandle: HCkGzip; dt: HCkDateTime): wordbool;
begin
  result := TCkGzip_SetDt(_map(73, 'CkGzip_SetDt'))
    (objHandle, dt);
end;

function CkGzip_SetExtraData (objHandle: HCkGzip; encodedData: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkGzip_SetExtraData(_map(74, 'CkGzip_SetExtraData'))
    (objHandle, encodedData, encoding);
end;

function CkGzip_UncompressBd (objHandle: HCkGzip; binDat: HCkBinData): wordbool;
begin
  result := TCkGzip_UncompressBd(_map(75, 'CkGzip_UncompressBd'))
    (objHandle, binDat);
end;

function CkGzip_UncompressBdAsync (objHandle: HCkGzip; binDat: HCkBinData): HCkTask;
begin
  result := TCkGzip_UncompressBdAsync(_map(76, 'CkGzip_UncompressBdAsync'))
    (objHandle, binDat);
end;

function CkGzip_UncompressBdToFile (objHandle: HCkGzip; bd: HCkBinData; filePath: PWideChar): wordbool;
begin
  result := TCkGzip_UncompressBdToFile(_map(77, 'CkGzip_UncompressBdToFile'))
    (objHandle, bd, filePath);
end;

function CkGzip_UncompressBdToFileAsync (objHandle: HCkGzip; bd: HCkBinData; filePath: PWideChar): HCkTask;
begin
  result := TCkGzip_UncompressBdToFileAsync(_map(78, 'CkGzip_UncompressBdToFileAsync'))
    (objHandle, bd, filePath);
end;

function CkGzip_UncompressFile (objHandle: HCkGzip; srcPath: PWideChar; destPath: PWideChar): wordbool;
begin
  result := TCkGzip_UncompressFile(_map(79, 'CkGzip_UncompressFile'))
    (objHandle, srcPath, destPath);
end;

function CkGzip_UncompressFileAsync (objHandle: HCkGzip; srcPath: PWideChar; destPath: PWideChar): HCkTask;
begin
  result := TCkGzip_UncompressFileAsync(_map(80, 'CkGzip_UncompressFileAsync'))
    (objHandle, srcPath, destPath);
end;

function CkGzip_UncompressFileToMem (objHandle: HCkGzip; inFilename: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkGzip_UncompressFileToMem(_map(81, 'CkGzip_UncompressFileToMem'))
    (objHandle, inFilename, outData);
end;

function CkGzip_UncompressFileToMemAsync (objHandle: HCkGzip; inFilename: PWideChar): HCkTask;
begin
  result := TCkGzip_UncompressFileToMemAsync(_map(82, 'CkGzip_UncompressFileToMemAsync'))
    (objHandle, inFilename);
end;

function CkGzip_UncompressFileToString (objHandle: HCkGzip; gzFilename: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkGzip_UncompressFileToString(_map(83, 'CkGzip_UncompressFileToString'))
    (objHandle, gzFilename, charset, outStr);
end;

function CkGzip__uncompressFileToString (objHandle: HCkGzip; gzFilename: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkGzip__uncompressFileToString(_map(84, 'CkGzip__uncompressFileToString'))
    (objHandle, gzFilename, charset);
end;

function CkGzip_UncompressFileToStringAsync (objHandle: HCkGzip; gzFilename: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkGzip_UncompressFileToStringAsync(_map(85, 'CkGzip_UncompressFileToStringAsync'))
    (objHandle, gzFilename, charset);
end;

function CkGzip_UncompressMemory (objHandle: HCkGzip; inData: HCkByteData; outData: HCkByteData): wordbool;
begin
  result := TCkGzip_UncompressMemory(_map(86, 'CkGzip_UncompressMemory'))
    (objHandle, inData, outData);
end;

function CkGzip_UncompressMemoryAsync (objHandle: HCkGzip; inData: HCkByteData): HCkTask;
begin
  result := TCkGzip_UncompressMemoryAsync(_map(87, 'CkGzip_UncompressMemoryAsync'))
    (objHandle, inData);
end;

function CkGzip_UncompressMemToFile (objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): wordbool;
begin
  result := TCkGzip_UncompressMemToFile(_map(88, 'CkGzip_UncompressMemToFile'))
    (objHandle, inData, destPath);
end;

function CkGzip_UncompressMemToFileAsync (objHandle: HCkGzip; inData: HCkByteData; destPath: PWideChar): HCkTask;
begin
  result := TCkGzip_UncompressMemToFileAsync(_map(89, 'CkGzip_UncompressMemToFileAsync'))
    (objHandle, inData, destPath);
end;

function CkGzip_UncompressString (objHandle: HCkGzip; inData: HCkByteData; inCharset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkGzip_UncompressString(_map(90, 'CkGzip_UncompressString'))
    (objHandle, inData, inCharset, outStr);
end;

function CkGzip__uncompressString (objHandle: HCkGzip; inData: HCkByteData; inCharset: PWideChar): PWideChar;
begin
  result := TCkGzip__uncompressString(_map(91, 'CkGzip__uncompressString'))
    (objHandle, inData, inCharset);
end;

function CkGzip_UncompressStringAsync (objHandle: HCkGzip; inData: HCkByteData; inCharset: PWideChar): HCkTask;
begin
  result := TCkGzip_UncompressStringAsync(_map(92, 'CkGzip_UncompressStringAsync'))
    (objHandle, inData, inCharset);
end;

function CkGzip_UncompressStringENC (objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkGzip_UncompressStringENC(_map(93, 'CkGzip_UncompressStringENC'))
    (objHandle, inStr, charset, encoding, outStr);
end;

function CkGzip__uncompressStringENC (objHandle: HCkGzip; inStr: PWideChar; charset: PWideChar; encoding: PWideChar): PWideChar;
begin
  result := TCkGzip__uncompressStringENC(_map(94, 'CkGzip__uncompressStringENC'))
    (objHandle, inStr, charset, encoding);
end;

function CkGzip_UnTarGz (objHandle: HCkGzip; tgzFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): wordbool;
begin
  result := TCkGzip_UnTarGz(_map(95, 'CkGzip_UnTarGz'))
    (objHandle, tgzFilename, destDir, bNoAbsolute);
end;

function CkGzip_UnTarGzAsync (objHandle: HCkGzip; tgzFilename: PWideChar; destDir: PWideChar; bNoAbsolute: wordbool): HCkTask;
begin
  result := TCkGzip_UnTarGzAsync(_map(96, 'CkGzip_UnTarGzAsync'))
    (objHandle, tgzFilename, destDir, bNoAbsolute);
end;

function CkGzip_WriteFile (objHandle: HCkGzip; path: PWideChar; binaryData: HCkByteData): wordbool;
begin
  result := TCkGzip_WriteFile(_map(97, 'CkGzip_WriteFile'))
    (objHandle, path, binaryData);
end;

function CkGzip_XfdlToXml (objHandle: HCkGzip; xfldData: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkGzip_XfdlToXml(_map(98, 'CkGzip_XfdlToXml'))
    (objHandle, xfldData, outStr);
end;

function CkGzip__xfdlToXml (objHandle: HCkGzip; xfldData: PWideChar): PWideChar;
begin
  result := TCkGzip__xfdlToXml(_map(99, 'CkGzip__xfdlToXml'))
    (objHandle, xfldData);
end;

end.
