unit HtmlToXml;

interface

type

HCkBinData = Pointer;
HCkStringBuilder = Pointer;
HCkByteData = Pointer;
HCkHtmlToXml = Pointer;
HCkString = Pointer;


function CkHtmlToXml_Create: HCkHtmlToXml;  stdcall;
procedure CkHtmlToXml_Dispose(handle: HCkHtmlToXml); stdcall;
procedure CkHtmlToXml_getDebugLogFilePath(objHandle: HCkHtmlToXml; outPropVal: HCkString);
procedure CkHtmlToXml_putDebugLogFilePath(objHandle: HCkHtmlToXml; newPropVal: PWideChar);
function CkHtmlToXml__debugLogFilePath(objHandle: HCkHtmlToXml): PWideChar;
function CkHtmlToXml_getDropCustomTags(objHandle: HCkHtmlToXml): wordbool;
procedure CkHtmlToXml_putDropCustomTags(objHandle: HCkHtmlToXml; newPropVal: wordbool);
procedure CkHtmlToXml_getHtml(objHandle: HCkHtmlToXml; outPropVal: HCkString);
procedure CkHtmlToXml_putHtml(objHandle: HCkHtmlToXml; newPropVal: PWideChar);
function CkHtmlToXml__html(objHandle: HCkHtmlToXml): PWideChar;
procedure CkHtmlToXml_getLastErrorHtml(objHandle: HCkHtmlToXml; outPropVal: HCkString);
function CkHtmlToXml__lastErrorHtml(objHandle: HCkHtmlToXml): PWideChar;
procedure CkHtmlToXml_getLastErrorText(objHandle: HCkHtmlToXml; outPropVal: HCkString);
function CkHtmlToXml__lastErrorText(objHandle: HCkHtmlToXml): PWideChar;
procedure CkHtmlToXml_getLastErrorXml(objHandle: HCkHtmlToXml; outPropVal: HCkString);
function CkHtmlToXml__lastErrorXml(objHandle: HCkHtmlToXml): PWideChar;
function CkHtmlToXml_getLastMethodSuccess(objHandle: HCkHtmlToXml): wordbool;
procedure CkHtmlToXml_putLastMethodSuccess(objHandle: HCkHtmlToXml; newPropVal: wordbool);
function CkHtmlToXml_getNbsp(objHandle: HCkHtmlToXml): Integer;
procedure CkHtmlToXml_putNbsp(objHandle: HCkHtmlToXml; newPropVal: Integer);
function CkHtmlToXml_getVerboseLogging(objHandle: HCkHtmlToXml): wordbool;
procedure CkHtmlToXml_putVerboseLogging(objHandle: HCkHtmlToXml; newPropVal: wordbool);
procedure CkHtmlToXml_getVersion(objHandle: HCkHtmlToXml; outPropVal: HCkString);
function CkHtmlToXml__version(objHandle: HCkHtmlToXml): PWideChar;
procedure CkHtmlToXml_getXmlCharset(objHandle: HCkHtmlToXml; outPropVal: HCkString);
procedure CkHtmlToXml_putXmlCharset(objHandle: HCkHtmlToXml; newPropVal: PWideChar);
function CkHtmlToXml__xmlCharset(objHandle: HCkHtmlToXml): PWideChar;
function CkHtmlToXml_ConvertFile(objHandle: HCkHtmlToXml; inHtmlPath: PWideChar; destXmlPath: PWideChar): wordbool;
procedure CkHtmlToXml_DropTagType(objHandle: HCkHtmlToXml; tagName: PWideChar);
procedure CkHtmlToXml_DropTextFormattingTags(objHandle: HCkHtmlToXml);
function CkHtmlToXml_ReadFile(objHandle: HCkHtmlToXml; path: PWideChar; outData: HCkByteData): wordbool;
function CkHtmlToXml_ReadFileToString(objHandle: HCkHtmlToXml; filename: PWideChar; srcCharset: PWideChar; outStr: HCkString): wordbool;
function CkHtmlToXml__readFileToString(objHandle: HCkHtmlToXml; filename: PWideChar; srcCharset: PWideChar): PWideChar;
function CkHtmlToXml_SetHtmlBd(objHandle: HCkHtmlToXml; bd: HCkBinData): wordbool;
procedure CkHtmlToXml_SetHtmlBytes(objHandle: HCkHtmlToXml; inData: HCkByteData);
function CkHtmlToXml_SetHtmlFromFile(objHandle: HCkHtmlToXml; filename: PWideChar): wordbool;
function CkHtmlToXml_SetHtmlSb(objHandle: HCkHtmlToXml; sb: HCkStringBuilder): wordbool;
function CkHtmlToXml_ToXml(objHandle: HCkHtmlToXml; outStr: HCkString): wordbool;
function CkHtmlToXml__toXml(objHandle: HCkHtmlToXml): PWideChar;
function CkHtmlToXml_ToXmlSb(objHandle: HCkHtmlToXml; sb: HCkStringBuilder): wordbool;
procedure CkHtmlToXml_UndropTagType(objHandle: HCkHtmlToXml; tagName: PWideChar);
procedure CkHtmlToXml_UndropTextFormattingTags(objHandle: HCkHtmlToXml);
function CkHtmlToXml_WriteFile(objHandle: HCkHtmlToXml; path: PWideChar; fileData: HCkByteData): wordbool;
function CkHtmlToXml_WriteStringToFile(objHandle: HCkHtmlToXml; stringToWrite: PWideChar; filename: PWideChar; charset: PWideChar): wordbool;
function CkHtmlToXml_Xml(objHandle: HCkHtmlToXml; outStr: HCkString): wordbool;
function CkHtmlToXml__xml(objHandle: HCkHtmlToXml): PWideChar;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkHtmlToXml_Create = function : HCkHtmlToXml; stdcall;
  TCkHtmlToXml_Dispose = procedure (handle: HCkHtmlToXml); stdcall;
  TCkHtmlToXml_getDebugLogFilePath = procedure (objHandle: HCkHtmlToXml; outPropVal: HCkString); stdcall;
  TCkHtmlToXml_putDebugLogFilePath = procedure (objHandle: HCkHtmlToXml; newPropVal: PWideChar); stdcall;
  TCkHtmlToXml__debugLogFilePath = function (objHandle: HCkHtmlToXml): PWideChar; stdcall;
  TCkHtmlToXml_getDropCustomTags = function (objHandle: HCkHtmlToXml): wordbool; stdcall;
  TCkHtmlToXml_putDropCustomTags = procedure (objHandle: HCkHtmlToXml; newPropVal: wordbool); stdcall;
  TCkHtmlToXml_getHtml = procedure (objHandle: HCkHtmlToXml; outPropVal: HCkString); stdcall;
  TCkHtmlToXml_putHtml = procedure (objHandle: HCkHtmlToXml; newPropVal: PWideChar); stdcall;
  TCkHtmlToXml__html = function (objHandle: HCkHtmlToXml): PWideChar; stdcall;
  TCkHtmlToXml_getLastErrorHtml = procedure (objHandle: HCkHtmlToXml; outPropVal: HCkString); stdcall;
  TCkHtmlToXml__lastErrorHtml = function (objHandle: HCkHtmlToXml): PWideChar; stdcall;
  TCkHtmlToXml_getLastErrorText = procedure (objHandle: HCkHtmlToXml; outPropVal: HCkString); stdcall;
  TCkHtmlToXml__lastErrorText = function (objHandle: HCkHtmlToXml): PWideChar; stdcall;
  TCkHtmlToXml_getLastErrorXml = procedure (objHandle: HCkHtmlToXml; outPropVal: HCkString); stdcall;
  TCkHtmlToXml__lastErrorXml = function (objHandle: HCkHtmlToXml): PWideChar; stdcall;
  TCkHtmlToXml_getLastMethodSuccess = function (objHandle: HCkHtmlToXml): wordbool; stdcall;
  TCkHtmlToXml_putLastMethodSuccess = procedure (objHandle: HCkHtmlToXml; newPropVal: wordbool); stdcall;
  TCkHtmlToXml_getNbsp = function (objHandle: HCkHtmlToXml): Integer; stdcall;
  TCkHtmlToXml_putNbsp = procedure (objHandle: HCkHtmlToXml; newPropVal: Integer); stdcall;
  TCkHtmlToXml_getVerboseLogging = function (objHandle: HCkHtmlToXml): wordbool; stdcall;
  TCkHtmlToXml_putVerboseLogging = procedure (objHandle: HCkHtmlToXml; newPropVal: wordbool); stdcall;
  TCkHtmlToXml_getVersion = procedure (objHandle: HCkHtmlToXml; outPropVal: HCkString); stdcall;
  TCkHtmlToXml__version = function (objHandle: HCkHtmlToXml): PWideChar; stdcall;
  TCkHtmlToXml_getXmlCharset = procedure (objHandle: HCkHtmlToXml; outPropVal: HCkString); stdcall;
  TCkHtmlToXml_putXmlCharset = procedure (objHandle: HCkHtmlToXml; newPropVal: PWideChar); stdcall;
  TCkHtmlToXml__xmlCharset = function (objHandle: HCkHtmlToXml): PWideChar; stdcall;
  TCkHtmlToXml_ConvertFile = function (objHandle: HCkHtmlToXml; inHtmlPath: PWideChar; destXmlPath: PWideChar): wordbool; stdcall;
  TCkHtmlToXml_DropTagType = procedure (objHandle: HCkHtmlToXml; tagName: PWideChar); stdcall;
  TCkHtmlToXml_DropTextFormattingTags = procedure (objHandle: HCkHtmlToXml); stdcall;
  TCkHtmlToXml_ReadFile = function (objHandle: HCkHtmlToXml; path: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkHtmlToXml_ReadFileToString = function (objHandle: HCkHtmlToXml; filename: PWideChar; srcCharset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHtmlToXml__readFileToString = function (objHandle: HCkHtmlToXml; filename: PWideChar; srcCharset: PWideChar): PWideChar; stdcall;
  TCkHtmlToXml_SetHtmlBd = function (objHandle: HCkHtmlToXml; bd: HCkBinData): wordbool; stdcall;
  TCkHtmlToXml_SetHtmlBytes = procedure (objHandle: HCkHtmlToXml; inData: HCkByteData); stdcall;
  TCkHtmlToXml_SetHtmlFromFile = function (objHandle: HCkHtmlToXml; filename: PWideChar): wordbool; stdcall;
  TCkHtmlToXml_SetHtmlSb = function (objHandle: HCkHtmlToXml; sb: HCkStringBuilder): wordbool; stdcall;
  TCkHtmlToXml_ToXml = function (objHandle: HCkHtmlToXml; outStr: HCkString): wordbool; stdcall;
  TCkHtmlToXml__toXml = function (objHandle: HCkHtmlToXml): PWideChar; stdcall;
  TCkHtmlToXml_ToXmlSb = function (objHandle: HCkHtmlToXml; sb: HCkStringBuilder): wordbool; stdcall;
  TCkHtmlToXml_UndropTagType = procedure (objHandle: HCkHtmlToXml; tagName: PWideChar); stdcall;
  TCkHtmlToXml_UndropTextFormattingTags = procedure (objHandle: HCkHtmlToXml); stdcall;
  TCkHtmlToXml_WriteFile = function (objHandle: HCkHtmlToXml; path: PWideChar; fileData: HCkByteData): wordbool; stdcall;
  TCkHtmlToXml_WriteStringToFile = function (objHandle: HCkHtmlToXml; stringToWrite: PWideChar; filename: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkHtmlToXml_Xml = function (objHandle: HCkHtmlToXml; outStr: HCkString): wordbool; stdcall;
  TCkHtmlToXml__xml = function (objHandle: HCkHtmlToXml): PWideChar; stdcall;

var
  _fkt_ptr_arr:   array [0..45] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkHtmlToXml_Create : HCkHtmlToXml;
begin
  result := TCkHtmlToXml_Create(_map(0, 'CkHtmlToXml_Create'));
end;

procedure CkHtmlToXml_Dispose (handle: HCkHtmlToXml);
begin
  TCkHtmlToXml_Dispose(_map(1, 'CkHtmlToXml_Dispose'))
    (handle);
end;


procedure CkHtmlToXml_getDebugLogFilePath (objHandle: HCkHtmlToXml; outPropVal: HCkString);
begin
  TCkHtmlToXml_getDebugLogFilePath(_map(2, 'CkHtmlToXml_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkHtmlToXml_putDebugLogFilePath (objHandle: HCkHtmlToXml; newPropVal: PWideChar);
begin
  TCkHtmlToXml_putDebugLogFilePath(_map(3, 'CkHtmlToXml_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkHtmlToXml__debugLogFilePath (objHandle: HCkHtmlToXml): PWideChar;
begin
  result := TCkHtmlToXml__debugLogFilePath(_map(4, 'CkHtmlToXml__debugLogFilePath'))
    (objHandle);
end;

function CkHtmlToXml_getDropCustomTags (objHandle: HCkHtmlToXml): wordbool;
begin
    result := TCkHtmlToXml_getDropCustomTags(_map(5, 'CkHtmlToXml_getDropCustomTags'))
    (objHandle);
end;

procedure CkHtmlToXml_putDropCustomTags (objHandle: HCkHtmlToXml; newPropVal: wordbool);
begin
  TCkHtmlToXml_putDropCustomTags(_map(6, 'CkHtmlToXml_putDropCustomTags'))
    (objHandle, newPropVal);
end;

procedure CkHtmlToXml_getHtml (objHandle: HCkHtmlToXml; outPropVal: HCkString);
begin
  TCkHtmlToXml_getHtml(_map(7, 'CkHtmlToXml_getHtml'))
    (objHandle, outPropVal);
end;

procedure CkHtmlToXml_putHtml (objHandle: HCkHtmlToXml; newPropVal: PWideChar);
begin
  TCkHtmlToXml_putHtml(_map(8, 'CkHtmlToXml_putHtml'))
    (objHandle, newPropVal);
end;

function CkHtmlToXml__html (objHandle: HCkHtmlToXml): PWideChar;
begin
  result := TCkHtmlToXml__html(_map(9, 'CkHtmlToXml__html'))
    (objHandle);
end;

procedure CkHtmlToXml_getLastErrorHtml (objHandle: HCkHtmlToXml; outPropVal: HCkString);
begin
  TCkHtmlToXml_getLastErrorHtml(_map(10, 'CkHtmlToXml_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkHtmlToXml__lastErrorHtml (objHandle: HCkHtmlToXml): PWideChar;
begin
  result := TCkHtmlToXml__lastErrorHtml(_map(11, 'CkHtmlToXml__lastErrorHtml'))
    (objHandle);
end;

procedure CkHtmlToXml_getLastErrorText (objHandle: HCkHtmlToXml; outPropVal: HCkString);
begin
  TCkHtmlToXml_getLastErrorText(_map(12, 'CkHtmlToXml_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkHtmlToXml__lastErrorText (objHandle: HCkHtmlToXml): PWideChar;
begin
  result := TCkHtmlToXml__lastErrorText(_map(13, 'CkHtmlToXml__lastErrorText'))
    (objHandle);
end;

procedure CkHtmlToXml_getLastErrorXml (objHandle: HCkHtmlToXml; outPropVal: HCkString);
begin
  TCkHtmlToXml_getLastErrorXml(_map(14, 'CkHtmlToXml_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkHtmlToXml__lastErrorXml (objHandle: HCkHtmlToXml): PWideChar;
begin
  result := TCkHtmlToXml__lastErrorXml(_map(15, 'CkHtmlToXml__lastErrorXml'))
    (objHandle);
end;

function CkHtmlToXml_getLastMethodSuccess (objHandle: HCkHtmlToXml): wordbool;
begin
    result := TCkHtmlToXml_getLastMethodSuccess(_map(16, 'CkHtmlToXml_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkHtmlToXml_putLastMethodSuccess (objHandle: HCkHtmlToXml; newPropVal: wordbool);
begin
  TCkHtmlToXml_putLastMethodSuccess(_map(17, 'CkHtmlToXml_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkHtmlToXml_getNbsp (objHandle: HCkHtmlToXml): Integer;
begin
    result := TCkHtmlToXml_getNbsp(_map(18, 'CkHtmlToXml_getNbsp'))
    (objHandle);
end;

procedure CkHtmlToXml_putNbsp (objHandle: HCkHtmlToXml; newPropVal: Integer);
begin
  TCkHtmlToXml_putNbsp(_map(19, 'CkHtmlToXml_putNbsp'))
    (objHandle, newPropVal);
end;

function CkHtmlToXml_getVerboseLogging (objHandle: HCkHtmlToXml): wordbool;
begin
    result := TCkHtmlToXml_getVerboseLogging(_map(20, 'CkHtmlToXml_getVerboseLogging'))
    (objHandle);
end;

procedure CkHtmlToXml_putVerboseLogging (objHandle: HCkHtmlToXml; newPropVal: wordbool);
begin
  TCkHtmlToXml_putVerboseLogging(_map(21, 'CkHtmlToXml_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkHtmlToXml_getVersion (objHandle: HCkHtmlToXml; outPropVal: HCkString);
begin
  TCkHtmlToXml_getVersion(_map(22, 'CkHtmlToXml_getVersion'))
    (objHandle, outPropVal);
end;

function CkHtmlToXml__version (objHandle: HCkHtmlToXml): PWideChar;
begin
  result := TCkHtmlToXml__version(_map(23, 'CkHtmlToXml__version'))
    (objHandle);
end;

procedure CkHtmlToXml_getXmlCharset (objHandle: HCkHtmlToXml; outPropVal: HCkString);
begin
  TCkHtmlToXml_getXmlCharset(_map(24, 'CkHtmlToXml_getXmlCharset'))
    (objHandle, outPropVal);
end;

procedure CkHtmlToXml_putXmlCharset (objHandle: HCkHtmlToXml; newPropVal: PWideChar);
begin
  TCkHtmlToXml_putXmlCharset(_map(25, 'CkHtmlToXml_putXmlCharset'))
    (objHandle, newPropVal);
end;

function CkHtmlToXml__xmlCharset (objHandle: HCkHtmlToXml): PWideChar;
begin
  result := TCkHtmlToXml__xmlCharset(_map(26, 'CkHtmlToXml__xmlCharset'))
    (objHandle);
end;

function CkHtmlToXml_ConvertFile (objHandle: HCkHtmlToXml; inHtmlPath: PWideChar; destXmlPath: PWideChar): wordbool;
begin
  result := TCkHtmlToXml_ConvertFile(_map(27, 'CkHtmlToXml_ConvertFile'))
    (objHandle, inHtmlPath, destXmlPath);
end;

procedure CkHtmlToXml_DropTagType (objHandle: HCkHtmlToXml; tagName: PWideChar);
begin
  TCkHtmlToXml_DropTagType(_map(28, 'CkHtmlToXml_DropTagType'))
    (objHandle, tagName);
end;

procedure CkHtmlToXml_DropTextFormattingTags (objHandle: HCkHtmlToXml);
begin
  TCkHtmlToXml_DropTextFormattingTags(_map(29, 'CkHtmlToXml_DropTextFormattingTags'))
    (objHandle);
end;

function CkHtmlToXml_ReadFile (objHandle: HCkHtmlToXml; path: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkHtmlToXml_ReadFile(_map(30, 'CkHtmlToXml_ReadFile'))
    (objHandle, path, outData);
end;

function CkHtmlToXml_ReadFileToString (objHandle: HCkHtmlToXml; filename: PWideChar; srcCharset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHtmlToXml_ReadFileToString(_map(31, 'CkHtmlToXml_ReadFileToString'))
    (objHandle, filename, srcCharset, outStr);
end;

function CkHtmlToXml__readFileToString (objHandle: HCkHtmlToXml; filename: PWideChar; srcCharset: PWideChar): PWideChar;
begin
  result := TCkHtmlToXml__readFileToString(_map(32, 'CkHtmlToXml__readFileToString'))
    (objHandle, filename, srcCharset);
end;

function CkHtmlToXml_SetHtmlBd (objHandle: HCkHtmlToXml; bd: HCkBinData): wordbool;
begin
  result := TCkHtmlToXml_SetHtmlBd(_map(33, 'CkHtmlToXml_SetHtmlBd'))
    (objHandle, bd);
end;

procedure CkHtmlToXml_SetHtmlBytes (objHandle: HCkHtmlToXml; inData: HCkByteData);
begin
  TCkHtmlToXml_SetHtmlBytes(_map(34, 'CkHtmlToXml_SetHtmlBytes'))
    (objHandle, inData);
end;

function CkHtmlToXml_SetHtmlFromFile (objHandle: HCkHtmlToXml; filename: PWideChar): wordbool;
begin
  result := TCkHtmlToXml_SetHtmlFromFile(_map(35, 'CkHtmlToXml_SetHtmlFromFile'))
    (objHandle, filename);
end;

function CkHtmlToXml_SetHtmlSb (objHandle: HCkHtmlToXml; sb: HCkStringBuilder): wordbool;
begin
  result := TCkHtmlToXml_SetHtmlSb(_map(36, 'CkHtmlToXml_SetHtmlSb'))
    (objHandle, sb);
end;

function CkHtmlToXml_ToXml (objHandle: HCkHtmlToXml; outStr: HCkString): wordbool;
begin
  result := TCkHtmlToXml_ToXml(_map(37, 'CkHtmlToXml_ToXml'))
    (objHandle, outStr);
end;

function CkHtmlToXml__toXml (objHandle: HCkHtmlToXml): PWideChar;
begin
  result := TCkHtmlToXml__toXml(_map(38, 'CkHtmlToXml__toXml'))
    (objHandle);
end;

function CkHtmlToXml_ToXmlSb (objHandle: HCkHtmlToXml; sb: HCkStringBuilder): wordbool;
begin
  result := TCkHtmlToXml_ToXmlSb(_map(39, 'CkHtmlToXml_ToXmlSb'))
    (objHandle, sb);
end;

procedure CkHtmlToXml_UndropTagType (objHandle: HCkHtmlToXml; tagName: PWideChar);
begin
  TCkHtmlToXml_UndropTagType(_map(40, 'CkHtmlToXml_UndropTagType'))
    (objHandle, tagName);
end;

procedure CkHtmlToXml_UndropTextFormattingTags (objHandle: HCkHtmlToXml);
begin
  TCkHtmlToXml_UndropTextFormattingTags(_map(41, 'CkHtmlToXml_UndropTextFormattingTags'))
    (objHandle);
end;

function CkHtmlToXml_WriteFile (objHandle: HCkHtmlToXml; path: PWideChar; fileData: HCkByteData): wordbool;
begin
  result := TCkHtmlToXml_WriteFile(_map(42, 'CkHtmlToXml_WriteFile'))
    (objHandle, path, fileData);
end;

function CkHtmlToXml_WriteStringToFile (objHandle: HCkHtmlToXml; stringToWrite: PWideChar; filename: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkHtmlToXml_WriteStringToFile(_map(43, 'CkHtmlToXml_WriteStringToFile'))
    (objHandle, stringToWrite, filename, charset);
end;

function CkHtmlToXml_Xml (objHandle: HCkHtmlToXml; outStr: HCkString): wordbool;
begin
  result := TCkHtmlToXml_Xml(_map(44, 'CkHtmlToXml_Xml'))
    (objHandle, outStr);
end;

function CkHtmlToXml__xml (objHandle: HCkHtmlToXml): PWideChar;
begin
  result := TCkHtmlToXml__xml(_map(45, 'CkHtmlToXml__xml'))
    (objHandle);
end;

end.
