unit HttpResponse;

interface

type

HCkJsonObject = Pointer;
HCkJsonArray = Pointer;
HCkXml = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;
HCkHttpResponse = Pointer;
HCkTask = Pointer;
HCkBinData = Pointer;


function CkHttpResponse_Create: HCkHttpResponse;  stdcall;
procedure CkHttpResponse_Dispose(handle: HCkHttpResponse); stdcall;
procedure CkHttpResponse_getBodyQP(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__bodyQP(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getBodyStr(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__bodyStr(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getCharset(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__charset(objHandle: HCkHttpResponse): PWideChar;
function CkHttpResponse_getContentLength(objHandle: HCkHttpResponse): LongWord;
function CkHttpResponse_getContentLength64(objHandle: HCkHttpResponse): Int64;
procedure CkHttpResponse_getDateStr(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__dateStr(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getDebugLogFilePath(objHandle: HCkHttpResponse; outPropVal: HCkString);
procedure CkHttpResponse_putDebugLogFilePath(objHandle: HCkHttpResponse; newPropVal: PWideChar);
function CkHttpResponse__debugLogFilePath(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getDomain(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__domain(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getFinalRedirectUrl(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__finalRedirectUrl(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getFullMime(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__fullMime(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getHeader(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__header(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getLastErrorHtml(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__lastErrorHtml(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getLastErrorText(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__lastErrorText(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getLastErrorXml(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__lastErrorXml(objHandle: HCkHttpResponse): PWideChar;
function CkHttpResponse_getLastMethodSuccess(objHandle: HCkHttpResponse): wordbool;
procedure CkHttpResponse_putLastMethodSuccess(objHandle: HCkHttpResponse; newPropVal: wordbool);
function CkHttpResponse_getNumCookies(objHandle: HCkHttpResponse): Integer;
function CkHttpResponse_getNumHeaderFields(objHandle: HCkHttpResponse): Integer;
function CkHttpResponse_getStatusCode(objHandle: HCkHttpResponse): Integer;
procedure CkHttpResponse_getStatusLine(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__statusLine(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getStatusText(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__statusText(objHandle: HCkHttpResponse): PWideChar;
procedure CkHttpResponse_getUncommonOptions(objHandle: HCkHttpResponse; outPropVal: HCkString);
procedure CkHttpResponse_putUncommonOptions(objHandle: HCkHttpResponse; newPropVal: PWideChar);
function CkHttpResponse__uncommonOptions(objHandle: HCkHttpResponse): PWideChar;
function CkHttpResponse_getVerboseLogging(objHandle: HCkHttpResponse): wordbool;
procedure CkHttpResponse_putVerboseLogging(objHandle: HCkHttpResponse; newPropVal: wordbool);
procedure CkHttpResponse_getVersion(objHandle: HCkHttpResponse; outPropVal: HCkString);
function CkHttpResponse__version(objHandle: HCkHttpResponse): PWideChar;
function CkHttpResponse_GetBodyBd(objHandle: HCkHttpResponse; binData: HCkBinData): wordbool;
function CkHttpResponse_GetBodyJarr(objHandle: HCkHttpResponse; jarr: HCkJsonArray): wordbool;
function CkHttpResponse_GetBodyJson(objHandle: HCkHttpResponse; json: HCkJsonObject): wordbool;
function CkHttpResponse_GetBodySb(objHandle: HCkHttpResponse; sb: HCkStringBuilder): wordbool;
function CkHttpResponse_GetBodyXml(objHandle: HCkHttpResponse; xml: HCkXml): wordbool;
function CkHttpResponse_GetCookieDomain(objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
function CkHttpResponse__getCookieDomain(objHandle: HCkHttpResponse; index: Integer): PWideChar;
function CkHttpResponse_GetCookieExpiresStr(objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
function CkHttpResponse__getCookieExpiresStr(objHandle: HCkHttpResponse; index: Integer): PWideChar;
function CkHttpResponse_GetCookieName(objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
function CkHttpResponse__getCookieName(objHandle: HCkHttpResponse; index: Integer): PWideChar;
function CkHttpResponse_GetCookiePath(objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
function CkHttpResponse__getCookiePath(objHandle: HCkHttpResponse; index: Integer): PWideChar;
function CkHttpResponse_GetCookieValue(objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
function CkHttpResponse__getCookieValue(objHandle: HCkHttpResponse; index: Integer): PWideChar;
function CkHttpResponse_GetHeaderField(objHandle: HCkHttpResponse; fieldName: PWideChar; outStr: HCkString): wordbool;
function CkHttpResponse__getHeaderField(objHandle: HCkHttpResponse; fieldName: PWideChar): PWideChar;
function CkHttpResponse_GetHeaderFieldAttr(objHandle: HCkHttpResponse; fieldName: PWideChar; attrName: PWideChar; outStr: HCkString): wordbool;
function CkHttpResponse__getHeaderFieldAttr(objHandle: HCkHttpResponse; fieldName: PWideChar; attrName: PWideChar): PWideChar;
function CkHttpResponse_GetHeaderName(objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
function CkHttpResponse__getHeaderName(objHandle: HCkHttpResponse; index: Integer): PWideChar;
function CkHttpResponse_GetHeaderValue(objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
function CkHttpResponse__getHeaderValue(objHandle: HCkHttpResponse; index: Integer): PWideChar;
function CkHttpResponse_LoadTaskResult(objHandle: HCkHttpResponse; task: HCkTask): wordbool;
function CkHttpResponse_SaveBodyBinary(objHandle: HCkHttpResponse; path: PWideChar): wordbool;
function CkHttpResponse_SaveBodyText(objHandle: HCkHttpResponse; bCrlf: wordbool; path: PWideChar): wordbool;
function CkHttpResponse_UrlEncParamValue(objHandle: HCkHttpResponse; encodedParamString: PWideChar; paramName: PWideChar; outStr: HCkString): wordbool;
function CkHttpResponse__urlEncParamValue(objHandle: HCkHttpResponse; encodedParamString: PWideChar; paramName: PWideChar): PWideChar;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkHttpResponse_Create = function : HCkHttpResponse; stdcall;
  TCkHttpResponse_Dispose = procedure (handle: HCkHttpResponse); stdcall;
  TCkHttpResponse_getBodyQP = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__bodyQP = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getBodyStr = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__bodyStr = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getCharset = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__charset = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getContentLength = function (objHandle: HCkHttpResponse): LongWord; stdcall;
  TCkHttpResponse_getContentLength64 = function (objHandle: HCkHttpResponse): Int64; stdcall;
  TCkHttpResponse_getDateStr = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__dateStr = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getDebugLogFilePath = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse_putDebugLogFilePath = procedure (objHandle: HCkHttpResponse; newPropVal: PWideChar); stdcall;
  TCkHttpResponse__debugLogFilePath = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getDomain = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__domain = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getFinalRedirectUrl = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__finalRedirectUrl = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getFullMime = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__fullMime = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getHeader = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__header = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getLastErrorHtml = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__lastErrorHtml = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getLastErrorText = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__lastErrorText = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getLastErrorXml = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__lastErrorXml = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getLastMethodSuccess = function (objHandle: HCkHttpResponse): wordbool; stdcall;
  TCkHttpResponse_putLastMethodSuccess = procedure (objHandle: HCkHttpResponse; newPropVal: wordbool); stdcall;
  TCkHttpResponse_getNumCookies = function (objHandle: HCkHttpResponse): Integer; stdcall;
  TCkHttpResponse_getNumHeaderFields = function (objHandle: HCkHttpResponse): Integer; stdcall;
  TCkHttpResponse_getStatusCode = function (objHandle: HCkHttpResponse): Integer; stdcall;
  TCkHttpResponse_getStatusLine = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__statusLine = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getStatusText = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__statusText = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getUncommonOptions = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse_putUncommonOptions = procedure (objHandle: HCkHttpResponse; newPropVal: PWideChar); stdcall;
  TCkHttpResponse__uncommonOptions = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_getVerboseLogging = function (objHandle: HCkHttpResponse): wordbool; stdcall;
  TCkHttpResponse_putVerboseLogging = procedure (objHandle: HCkHttpResponse; newPropVal: wordbool); stdcall;
  TCkHttpResponse_getVersion = procedure (objHandle: HCkHttpResponse; outPropVal: HCkString); stdcall;
  TCkHttpResponse__version = function (objHandle: HCkHttpResponse): PWideChar; stdcall;
  TCkHttpResponse_GetBodyBd = function (objHandle: HCkHttpResponse; binData: HCkBinData): wordbool; stdcall;
  TCkHttpResponse_GetBodyJarr = function (objHandle: HCkHttpResponse; jarr: HCkJsonArray): wordbool; stdcall;
  TCkHttpResponse_GetBodyJson = function (objHandle: HCkHttpResponse; json: HCkJsonObject): wordbool; stdcall;
  TCkHttpResponse_GetBodySb = function (objHandle: HCkHttpResponse; sb: HCkStringBuilder): wordbool; stdcall;
  TCkHttpResponse_GetBodyXml = function (objHandle: HCkHttpResponse; xml: HCkXml): wordbool; stdcall;
  TCkHttpResponse_GetCookieDomain = function (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpResponse__getCookieDomain = function (objHandle: HCkHttpResponse; index: Integer): PWideChar; stdcall;
  TCkHttpResponse_GetCookieExpiresStr = function (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpResponse__getCookieExpiresStr = function (objHandle: HCkHttpResponse; index: Integer): PWideChar; stdcall;
  TCkHttpResponse_GetCookieName = function (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpResponse__getCookieName = function (objHandle: HCkHttpResponse; index: Integer): PWideChar; stdcall;
  TCkHttpResponse_GetCookiePath = function (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpResponse__getCookiePath = function (objHandle: HCkHttpResponse; index: Integer): PWideChar; stdcall;
  TCkHttpResponse_GetCookieValue = function (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpResponse__getCookieValue = function (objHandle: HCkHttpResponse; index: Integer): PWideChar; stdcall;
  TCkHttpResponse_GetHeaderField = function (objHandle: HCkHttpResponse; fieldName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttpResponse__getHeaderField = function (objHandle: HCkHttpResponse; fieldName: PWideChar): PWideChar; stdcall;
  TCkHttpResponse_GetHeaderFieldAttr = function (objHandle: HCkHttpResponse; fieldName: PWideChar; attrName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttpResponse__getHeaderFieldAttr = function (objHandle: HCkHttpResponse; fieldName: PWideChar; attrName: PWideChar): PWideChar; stdcall;
  TCkHttpResponse_GetHeaderName = function (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpResponse__getHeaderName = function (objHandle: HCkHttpResponse; index: Integer): PWideChar; stdcall;
  TCkHttpResponse_GetHeaderValue = function (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkHttpResponse__getHeaderValue = function (objHandle: HCkHttpResponse; index: Integer): PWideChar; stdcall;
  TCkHttpResponse_LoadTaskResult = function (objHandle: HCkHttpResponse; task: HCkTask): wordbool; stdcall;
  TCkHttpResponse_SaveBodyBinary = function (objHandle: HCkHttpResponse; path: PWideChar): wordbool; stdcall;
  TCkHttpResponse_SaveBodyText = function (objHandle: HCkHttpResponse; bCrlf: wordbool; path: PWideChar): wordbool; stdcall;
  TCkHttpResponse_UrlEncParamValue = function (objHandle: HCkHttpResponse; encodedParamString: PWideChar; paramName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkHttpResponse__urlEncParamValue = function (objHandle: HCkHttpResponse; encodedParamString: PWideChar; paramName: PWideChar): PWideChar; stdcall;

var
  _fkt_ptr_arr:   array [0..72] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkHttpResponse_Create : HCkHttpResponse;
begin
  result := TCkHttpResponse_Create(_map(0, 'CkHttpResponse_Create'));
end;

procedure CkHttpResponse_Dispose (handle: HCkHttpResponse);
begin
  TCkHttpResponse_Dispose(_map(1, 'CkHttpResponse_Dispose'))
    (handle);
end;


procedure CkHttpResponse_getBodyQP (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getBodyQP(_map(2, 'CkHttpResponse_getBodyQP'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__bodyQP (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__bodyQP(_map(3, 'CkHttpResponse__bodyQP'))
    (objHandle);
end;

procedure CkHttpResponse_getBodyStr (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getBodyStr(_map(4, 'CkHttpResponse_getBodyStr'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__bodyStr (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__bodyStr(_map(5, 'CkHttpResponse__bodyStr'))
    (objHandle);
end;

procedure CkHttpResponse_getCharset (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getCharset(_map(6, 'CkHttpResponse_getCharset'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__charset (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__charset(_map(7, 'CkHttpResponse__charset'))
    (objHandle);
end;

function CkHttpResponse_getContentLength (objHandle: HCkHttpResponse): LongWord;
begin
    result := TCkHttpResponse_getContentLength(_map(8, 'CkHttpResponse_getContentLength'))
    (objHandle);
end;

function CkHttpResponse_getContentLength64 (objHandle: HCkHttpResponse): Int64;
begin
    result := TCkHttpResponse_getContentLength64(_map(9, 'CkHttpResponse_getContentLength64'))
    (objHandle);
end;

procedure CkHttpResponse_getDateStr (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getDateStr(_map(10, 'CkHttpResponse_getDateStr'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__dateStr (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__dateStr(_map(11, 'CkHttpResponse__dateStr'))
    (objHandle);
end;

procedure CkHttpResponse_getDebugLogFilePath (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getDebugLogFilePath(_map(12, 'CkHttpResponse_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkHttpResponse_putDebugLogFilePath (objHandle: HCkHttpResponse; newPropVal: PWideChar);
begin
  TCkHttpResponse_putDebugLogFilePath(_map(13, 'CkHttpResponse_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkHttpResponse__debugLogFilePath (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__debugLogFilePath(_map(14, 'CkHttpResponse__debugLogFilePath'))
    (objHandle);
end;

procedure CkHttpResponse_getDomain (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getDomain(_map(15, 'CkHttpResponse_getDomain'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__domain (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__domain(_map(16, 'CkHttpResponse__domain'))
    (objHandle);
end;

procedure CkHttpResponse_getFinalRedirectUrl (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getFinalRedirectUrl(_map(17, 'CkHttpResponse_getFinalRedirectUrl'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__finalRedirectUrl (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__finalRedirectUrl(_map(18, 'CkHttpResponse__finalRedirectUrl'))
    (objHandle);
end;

procedure CkHttpResponse_getFullMime (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getFullMime(_map(19, 'CkHttpResponse_getFullMime'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__fullMime (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__fullMime(_map(20, 'CkHttpResponse__fullMime'))
    (objHandle);
end;

procedure CkHttpResponse_getHeader (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getHeader(_map(21, 'CkHttpResponse_getHeader'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__header (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__header(_map(22, 'CkHttpResponse__header'))
    (objHandle);
end;

procedure CkHttpResponse_getLastErrorHtml (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getLastErrorHtml(_map(23, 'CkHttpResponse_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__lastErrorHtml (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__lastErrorHtml(_map(24, 'CkHttpResponse__lastErrorHtml'))
    (objHandle);
end;

procedure CkHttpResponse_getLastErrorText (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getLastErrorText(_map(25, 'CkHttpResponse_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__lastErrorText (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__lastErrorText(_map(26, 'CkHttpResponse__lastErrorText'))
    (objHandle);
end;

procedure CkHttpResponse_getLastErrorXml (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getLastErrorXml(_map(27, 'CkHttpResponse_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__lastErrorXml (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__lastErrorXml(_map(28, 'CkHttpResponse__lastErrorXml'))
    (objHandle);
end;

function CkHttpResponse_getLastMethodSuccess (objHandle: HCkHttpResponse): wordbool;
begin
    result := TCkHttpResponse_getLastMethodSuccess(_map(29, 'CkHttpResponse_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkHttpResponse_putLastMethodSuccess (objHandle: HCkHttpResponse; newPropVal: wordbool);
begin
  TCkHttpResponse_putLastMethodSuccess(_map(30, 'CkHttpResponse_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkHttpResponse_getNumCookies (objHandle: HCkHttpResponse): Integer;
begin
    result := TCkHttpResponse_getNumCookies(_map(31, 'CkHttpResponse_getNumCookies'))
    (objHandle);
end;

function CkHttpResponse_getNumHeaderFields (objHandle: HCkHttpResponse): Integer;
begin
    result := TCkHttpResponse_getNumHeaderFields(_map(32, 'CkHttpResponse_getNumHeaderFields'))
    (objHandle);
end;

function CkHttpResponse_getStatusCode (objHandle: HCkHttpResponse): Integer;
begin
    result := TCkHttpResponse_getStatusCode(_map(33, 'CkHttpResponse_getStatusCode'))
    (objHandle);
end;

procedure CkHttpResponse_getStatusLine (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getStatusLine(_map(34, 'CkHttpResponse_getStatusLine'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__statusLine (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__statusLine(_map(35, 'CkHttpResponse__statusLine'))
    (objHandle);
end;

procedure CkHttpResponse_getStatusText (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getStatusText(_map(36, 'CkHttpResponse_getStatusText'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__statusText (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__statusText(_map(37, 'CkHttpResponse__statusText'))
    (objHandle);
end;

procedure CkHttpResponse_getUncommonOptions (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getUncommonOptions(_map(38, 'CkHttpResponse_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkHttpResponse_putUncommonOptions (objHandle: HCkHttpResponse; newPropVal: PWideChar);
begin
  TCkHttpResponse_putUncommonOptions(_map(39, 'CkHttpResponse_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkHttpResponse__uncommonOptions (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__uncommonOptions(_map(40, 'CkHttpResponse__uncommonOptions'))
    (objHandle);
end;

function CkHttpResponse_getVerboseLogging (objHandle: HCkHttpResponse): wordbool;
begin
    result := TCkHttpResponse_getVerboseLogging(_map(41, 'CkHttpResponse_getVerboseLogging'))
    (objHandle);
end;

procedure CkHttpResponse_putVerboseLogging (objHandle: HCkHttpResponse; newPropVal: wordbool);
begin
  TCkHttpResponse_putVerboseLogging(_map(42, 'CkHttpResponse_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkHttpResponse_getVersion (objHandle: HCkHttpResponse; outPropVal: HCkString);
begin
  TCkHttpResponse_getVersion(_map(43, 'CkHttpResponse_getVersion'))
    (objHandle, outPropVal);
end;

function CkHttpResponse__version (objHandle: HCkHttpResponse): PWideChar;
begin
  result := TCkHttpResponse__version(_map(44, 'CkHttpResponse__version'))
    (objHandle);
end;

function CkHttpResponse_GetBodyBd (objHandle: HCkHttpResponse; binData: HCkBinData): wordbool;
begin
  result := TCkHttpResponse_GetBodyBd(_map(45, 'CkHttpResponse_GetBodyBd'))
    (objHandle, binData);
end;

function CkHttpResponse_GetBodyJarr (objHandle: HCkHttpResponse; jarr: HCkJsonArray): wordbool;
begin
  result := TCkHttpResponse_GetBodyJarr(_map(46, 'CkHttpResponse_GetBodyJarr'))
    (objHandle, jarr);
end;

function CkHttpResponse_GetBodyJson (objHandle: HCkHttpResponse; json: HCkJsonObject): wordbool;
begin
  result := TCkHttpResponse_GetBodyJson(_map(47, 'CkHttpResponse_GetBodyJson'))
    (objHandle, json);
end;

function CkHttpResponse_GetBodySb (objHandle: HCkHttpResponse; sb: HCkStringBuilder): wordbool;
begin
  result := TCkHttpResponse_GetBodySb(_map(48, 'CkHttpResponse_GetBodySb'))
    (objHandle, sb);
end;

function CkHttpResponse_GetBodyXml (objHandle: HCkHttpResponse; xml: HCkXml): wordbool;
begin
  result := TCkHttpResponse_GetBodyXml(_map(49, 'CkHttpResponse_GetBodyXml'))
    (objHandle, xml);
end;

function CkHttpResponse_GetCookieDomain (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpResponse_GetCookieDomain(_map(50, 'CkHttpResponse_GetCookieDomain'))
    (objHandle, index, outStr);
end;

function CkHttpResponse__getCookieDomain (objHandle: HCkHttpResponse; index: Integer): PWideChar;
begin
  result := TCkHttpResponse__getCookieDomain(_map(51, 'CkHttpResponse__getCookieDomain'))
    (objHandle, index);
end;

function CkHttpResponse_GetCookieExpiresStr (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpResponse_GetCookieExpiresStr(_map(52, 'CkHttpResponse_GetCookieExpiresStr'))
    (objHandle, index, outStr);
end;

function CkHttpResponse__getCookieExpiresStr (objHandle: HCkHttpResponse; index: Integer): PWideChar;
begin
  result := TCkHttpResponse__getCookieExpiresStr(_map(53, 'CkHttpResponse__getCookieExpiresStr'))
    (objHandle, index);
end;

function CkHttpResponse_GetCookieName (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpResponse_GetCookieName(_map(54, 'CkHttpResponse_GetCookieName'))
    (objHandle, index, outStr);
end;

function CkHttpResponse__getCookieName (objHandle: HCkHttpResponse; index: Integer): PWideChar;
begin
  result := TCkHttpResponse__getCookieName(_map(55, 'CkHttpResponse__getCookieName'))
    (objHandle, index);
end;

function CkHttpResponse_GetCookiePath (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpResponse_GetCookiePath(_map(56, 'CkHttpResponse_GetCookiePath'))
    (objHandle, index, outStr);
end;

function CkHttpResponse__getCookiePath (objHandle: HCkHttpResponse; index: Integer): PWideChar;
begin
  result := TCkHttpResponse__getCookiePath(_map(57, 'CkHttpResponse__getCookiePath'))
    (objHandle, index);
end;

function CkHttpResponse_GetCookieValue (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpResponse_GetCookieValue(_map(58, 'CkHttpResponse_GetCookieValue'))
    (objHandle, index, outStr);
end;

function CkHttpResponse__getCookieValue (objHandle: HCkHttpResponse; index: Integer): PWideChar;
begin
  result := TCkHttpResponse__getCookieValue(_map(59, 'CkHttpResponse__getCookieValue'))
    (objHandle, index);
end;

function CkHttpResponse_GetHeaderField (objHandle: HCkHttpResponse; fieldName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttpResponse_GetHeaderField(_map(60, 'CkHttpResponse_GetHeaderField'))
    (objHandle, fieldName, outStr);
end;

function CkHttpResponse__getHeaderField (objHandle: HCkHttpResponse; fieldName: PWideChar): PWideChar;
begin
  result := TCkHttpResponse__getHeaderField(_map(61, 'CkHttpResponse__getHeaderField'))
    (objHandle, fieldName);
end;

function CkHttpResponse_GetHeaderFieldAttr (objHandle: HCkHttpResponse; fieldName: PWideChar; attrName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttpResponse_GetHeaderFieldAttr(_map(62, 'CkHttpResponse_GetHeaderFieldAttr'))
    (objHandle, fieldName, attrName, outStr);
end;

function CkHttpResponse__getHeaderFieldAttr (objHandle: HCkHttpResponse; fieldName: PWideChar; attrName: PWideChar): PWideChar;
begin
  result := TCkHttpResponse__getHeaderFieldAttr(_map(63, 'CkHttpResponse__getHeaderFieldAttr'))
    (objHandle, fieldName, attrName);
end;

function CkHttpResponse_GetHeaderName (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpResponse_GetHeaderName(_map(64, 'CkHttpResponse_GetHeaderName'))
    (objHandle, index, outStr);
end;

function CkHttpResponse__getHeaderName (objHandle: HCkHttpResponse; index: Integer): PWideChar;
begin
  result := TCkHttpResponse__getHeaderName(_map(65, 'CkHttpResponse__getHeaderName'))
    (objHandle, index);
end;

function CkHttpResponse_GetHeaderValue (objHandle: HCkHttpResponse; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkHttpResponse_GetHeaderValue(_map(66, 'CkHttpResponse_GetHeaderValue'))
    (objHandle, index, outStr);
end;

function CkHttpResponse__getHeaderValue (objHandle: HCkHttpResponse; index: Integer): PWideChar;
begin
  result := TCkHttpResponse__getHeaderValue(_map(67, 'CkHttpResponse__getHeaderValue'))
    (objHandle, index);
end;

function CkHttpResponse_LoadTaskResult (objHandle: HCkHttpResponse; task: HCkTask): wordbool;
begin
  result := TCkHttpResponse_LoadTaskResult(_map(68, 'CkHttpResponse_LoadTaskResult'))
    (objHandle, task);
end;

function CkHttpResponse_SaveBodyBinary (objHandle: HCkHttpResponse; path: PWideChar): wordbool;
begin
  result := TCkHttpResponse_SaveBodyBinary(_map(69, 'CkHttpResponse_SaveBodyBinary'))
    (objHandle, path);
end;

function CkHttpResponse_SaveBodyText (objHandle: HCkHttpResponse; bCrlf: wordbool; path: PWideChar): wordbool;
begin
  result := TCkHttpResponse_SaveBodyText(_map(70, 'CkHttpResponse_SaveBodyText'))
    (objHandle, bCrlf, path);
end;

function CkHttpResponse_UrlEncParamValue (objHandle: HCkHttpResponse; encodedParamString: PWideChar; paramName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkHttpResponse_UrlEncParamValue(_map(71, 'CkHttpResponse_UrlEncParamValue'))
    (objHandle, encodedParamString, paramName, outStr);
end;

function CkHttpResponse__urlEncParamValue (objHandle: HCkHttpResponse; encodedParamString: PWideChar; paramName: PWideChar): PWideChar;
begin
  result := TCkHttpResponse__urlEncParamValue(_map(72, 'CkHttpResponse__urlEncParamValue'))
    (objHandle, encodedParamString, paramName);
end;

end.
