unit Jwt;

interface

type

HCkCert = Pointer;
HCkJwt = Pointer;
HCkPrivateKey = Pointer;
HCkPublicKey = Pointer;
HCkString = Pointer;


function CkJwt_Create: HCkJwt;  stdcall;
procedure CkJwt_Dispose(handle: HCkJwt); stdcall;
function CkJwt_getAutoCompact(objHandle: HCkJwt): wordbool;
procedure CkJwt_putAutoCompact(objHandle: HCkJwt; newPropVal: wordbool);
procedure CkJwt_getDebugLogFilePath(objHandle: HCkJwt; outPropVal: HCkString);
procedure CkJwt_putDebugLogFilePath(objHandle: HCkJwt; newPropVal: PWideChar);
function CkJwt__debugLogFilePath(objHandle: HCkJwt): PWideChar;
procedure CkJwt_getLastErrorHtml(objHandle: HCkJwt; outPropVal: HCkString);
function CkJwt__lastErrorHtml(objHandle: HCkJwt): PWideChar;
procedure CkJwt_getLastErrorText(objHandle: HCkJwt; outPropVal: HCkString);
function CkJwt__lastErrorText(objHandle: HCkJwt): PWideChar;
procedure CkJwt_getLastErrorXml(objHandle: HCkJwt; outPropVal: HCkString);
function CkJwt__lastErrorXml(objHandle: HCkJwt): PWideChar;
function CkJwt_getLastMethodSuccess(objHandle: HCkJwt): wordbool;
procedure CkJwt_putLastMethodSuccess(objHandle: HCkJwt; newPropVal: wordbool);
procedure CkJwt_getUncommonOptions(objHandle: HCkJwt; outPropVal: HCkString);
procedure CkJwt_putUncommonOptions(objHandle: HCkJwt; newPropVal: PWideChar);
function CkJwt__uncommonOptions(objHandle: HCkJwt): PWideChar;
function CkJwt_getVerboseLogging(objHandle: HCkJwt): wordbool;
procedure CkJwt_putVerboseLogging(objHandle: HCkJwt; newPropVal: wordbool);
procedure CkJwt_getVersion(objHandle: HCkJwt; outPropVal: HCkString);
function CkJwt__version(objHandle: HCkJwt): PWideChar;
function CkJwt_CreateJwt(objHandle: HCkJwt; header: PWideChar; payload: PWideChar; password: PWideChar; outStr: HCkString): wordbool;
function CkJwt__createJwt(objHandle: HCkJwt; header: PWideChar; payload: PWideChar; password: PWideChar): PWideChar;
function CkJwt_CreateJwtCert(objHandle: HCkJwt; header: PWideChar; payload: PWideChar; cert: HCkCert; outStr: HCkString): wordbool;
function CkJwt__createJwtCert(objHandle: HCkJwt; header: PWideChar; payload: PWideChar; cert: HCkCert): PWideChar;
function CkJwt_CreateJwtPk(objHandle: HCkJwt; header: PWideChar; payload: PWideChar; key: HCkPrivateKey; outStr: HCkString): wordbool;
function CkJwt__createJwtPk(objHandle: HCkJwt; header: PWideChar; payload: PWideChar; key: HCkPrivateKey): PWideChar;
function CkJwt_GenNumericDate(objHandle: HCkJwt; numSecOffset: Integer): Integer;
function CkJwt_GetHeader(objHandle: HCkJwt; token: PWideChar; outStr: HCkString): wordbool;
function CkJwt__getHeader(objHandle: HCkJwt; token: PWideChar): PWideChar;
function CkJwt_GetPayload(objHandle: HCkJwt; token: PWideChar; outStr: HCkString): wordbool;
function CkJwt__getPayload(objHandle: HCkJwt; token: PWideChar): PWideChar;
function CkJwt_IsTimeValid(objHandle: HCkJwt; jwt: PWideChar; leeway: Integer): wordbool;
function CkJwt_VerifyJwt(objHandle: HCkJwt; token: PWideChar; password: PWideChar): wordbool;
function CkJwt_VerifyJwtPk(objHandle: HCkJwt; token: PWideChar; key: HCkPublicKey): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkJwt_Create = function : HCkJwt; stdcall;
  TCkJwt_Dispose = procedure (handle: HCkJwt); stdcall;
  TCkJwt_getAutoCompact = function (objHandle: HCkJwt): wordbool; stdcall;
  TCkJwt_putAutoCompact = procedure (objHandle: HCkJwt; newPropVal: wordbool); stdcall;
  TCkJwt_getDebugLogFilePath = procedure (objHandle: HCkJwt; outPropVal: HCkString); stdcall;
  TCkJwt_putDebugLogFilePath = procedure (objHandle: HCkJwt; newPropVal: PWideChar); stdcall;
  TCkJwt__debugLogFilePath = function (objHandle: HCkJwt): PWideChar; stdcall;
  TCkJwt_getLastErrorHtml = procedure (objHandle: HCkJwt; outPropVal: HCkString); stdcall;
  TCkJwt__lastErrorHtml = function (objHandle: HCkJwt): PWideChar; stdcall;
  TCkJwt_getLastErrorText = procedure (objHandle: HCkJwt; outPropVal: HCkString); stdcall;
  TCkJwt__lastErrorText = function (objHandle: HCkJwt): PWideChar; stdcall;
  TCkJwt_getLastErrorXml = procedure (objHandle: HCkJwt; outPropVal: HCkString); stdcall;
  TCkJwt__lastErrorXml = function (objHandle: HCkJwt): PWideChar; stdcall;
  TCkJwt_getLastMethodSuccess = function (objHandle: HCkJwt): wordbool; stdcall;
  TCkJwt_putLastMethodSuccess = procedure (objHandle: HCkJwt; newPropVal: wordbool); stdcall;
  TCkJwt_getUncommonOptions = procedure (objHandle: HCkJwt; outPropVal: HCkString); stdcall;
  TCkJwt_putUncommonOptions = procedure (objHandle: HCkJwt; newPropVal: PWideChar); stdcall;
  TCkJwt__uncommonOptions = function (objHandle: HCkJwt): PWideChar; stdcall;
  TCkJwt_getVerboseLogging = function (objHandle: HCkJwt): wordbool; stdcall;
  TCkJwt_putVerboseLogging = procedure (objHandle: HCkJwt; newPropVal: wordbool); stdcall;
  TCkJwt_getVersion = procedure (objHandle: HCkJwt; outPropVal: HCkString); stdcall;
  TCkJwt__version = function (objHandle: HCkJwt): PWideChar; stdcall;
  TCkJwt_CreateJwt = function (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; password: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkJwt__createJwt = function (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; password: PWideChar): PWideChar; stdcall;
  TCkJwt_CreateJwtCert = function (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; cert: HCkCert; outStr: HCkString): wordbool; stdcall;
  TCkJwt__createJwtCert = function (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; cert: HCkCert): PWideChar; stdcall;
  TCkJwt_CreateJwtPk = function (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; key: HCkPrivateKey; outStr: HCkString): wordbool; stdcall;
  TCkJwt__createJwtPk = function (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; key: HCkPrivateKey): PWideChar; stdcall;
  TCkJwt_GenNumericDate = function (objHandle: HCkJwt; numSecOffset: Integer): Integer; stdcall;
  TCkJwt_GetHeader = function (objHandle: HCkJwt; token: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkJwt__getHeader = function (objHandle: HCkJwt; token: PWideChar): PWideChar; stdcall;
  TCkJwt_GetPayload = function (objHandle: HCkJwt; token: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkJwt__getPayload = function (objHandle: HCkJwt; token: PWideChar): PWideChar; stdcall;
  TCkJwt_IsTimeValid = function (objHandle: HCkJwt; jwt: PWideChar; leeway: Integer): wordbool; stdcall;
  TCkJwt_VerifyJwt = function (objHandle: HCkJwt; token: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkJwt_VerifyJwtPk = function (objHandle: HCkJwt; token: PWideChar; key: HCkPublicKey): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..35] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkJwt_Create : HCkJwt;
begin
  result := TCkJwt_Create(_map(0, 'CkJwt_Create'));
end;

procedure CkJwt_Dispose (handle: HCkJwt);
begin
  TCkJwt_Dispose(_map(1, 'CkJwt_Dispose'))
    (handle);
end;


function CkJwt_getAutoCompact (objHandle: HCkJwt): wordbool;
begin
    result := TCkJwt_getAutoCompact(_map(2, 'CkJwt_getAutoCompact'))
    (objHandle);
end;

procedure CkJwt_putAutoCompact (objHandle: HCkJwt; newPropVal: wordbool);
begin
  TCkJwt_putAutoCompact(_map(3, 'CkJwt_putAutoCompact'))
    (objHandle, newPropVal);
end;

procedure CkJwt_getDebugLogFilePath (objHandle: HCkJwt; outPropVal: HCkString);
begin
  TCkJwt_getDebugLogFilePath(_map(4, 'CkJwt_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkJwt_putDebugLogFilePath (objHandle: HCkJwt; newPropVal: PWideChar);
begin
  TCkJwt_putDebugLogFilePath(_map(5, 'CkJwt_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkJwt__debugLogFilePath (objHandle: HCkJwt): PWideChar;
begin
  result := TCkJwt__debugLogFilePath(_map(6, 'CkJwt__debugLogFilePath'))
    (objHandle);
end;

procedure CkJwt_getLastErrorHtml (objHandle: HCkJwt; outPropVal: HCkString);
begin
  TCkJwt_getLastErrorHtml(_map(7, 'CkJwt_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkJwt__lastErrorHtml (objHandle: HCkJwt): PWideChar;
begin
  result := TCkJwt__lastErrorHtml(_map(8, 'CkJwt__lastErrorHtml'))
    (objHandle);
end;

procedure CkJwt_getLastErrorText (objHandle: HCkJwt; outPropVal: HCkString);
begin
  TCkJwt_getLastErrorText(_map(9, 'CkJwt_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkJwt__lastErrorText (objHandle: HCkJwt): PWideChar;
begin
  result := TCkJwt__lastErrorText(_map(10, 'CkJwt__lastErrorText'))
    (objHandle);
end;

procedure CkJwt_getLastErrorXml (objHandle: HCkJwt; outPropVal: HCkString);
begin
  TCkJwt_getLastErrorXml(_map(11, 'CkJwt_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkJwt__lastErrorXml (objHandle: HCkJwt): PWideChar;
begin
  result := TCkJwt__lastErrorXml(_map(12, 'CkJwt__lastErrorXml'))
    (objHandle);
end;

function CkJwt_getLastMethodSuccess (objHandle: HCkJwt): wordbool;
begin
    result := TCkJwt_getLastMethodSuccess(_map(13, 'CkJwt_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkJwt_putLastMethodSuccess (objHandle: HCkJwt; newPropVal: wordbool);
begin
  TCkJwt_putLastMethodSuccess(_map(14, 'CkJwt_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkJwt_getUncommonOptions (objHandle: HCkJwt; outPropVal: HCkString);
begin
  TCkJwt_getUncommonOptions(_map(15, 'CkJwt_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkJwt_putUncommonOptions (objHandle: HCkJwt; newPropVal: PWideChar);
begin
  TCkJwt_putUncommonOptions(_map(16, 'CkJwt_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkJwt__uncommonOptions (objHandle: HCkJwt): PWideChar;
begin
  result := TCkJwt__uncommonOptions(_map(17, 'CkJwt__uncommonOptions'))
    (objHandle);
end;

function CkJwt_getVerboseLogging (objHandle: HCkJwt): wordbool;
begin
    result := TCkJwt_getVerboseLogging(_map(18, 'CkJwt_getVerboseLogging'))
    (objHandle);
end;

procedure CkJwt_putVerboseLogging (objHandle: HCkJwt; newPropVal: wordbool);
begin
  TCkJwt_putVerboseLogging(_map(19, 'CkJwt_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkJwt_getVersion (objHandle: HCkJwt; outPropVal: HCkString);
begin
  TCkJwt_getVersion(_map(20, 'CkJwt_getVersion'))
    (objHandle, outPropVal);
end;

function CkJwt__version (objHandle: HCkJwt): PWideChar;
begin
  result := TCkJwt__version(_map(21, 'CkJwt__version'))
    (objHandle);
end;

function CkJwt_CreateJwt (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; password: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkJwt_CreateJwt(_map(22, 'CkJwt_CreateJwt'))
    (objHandle, header, payload, password, outStr);
end;

function CkJwt__createJwt (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; password: PWideChar): PWideChar;
begin
  result := TCkJwt__createJwt(_map(23, 'CkJwt__createJwt'))
    (objHandle, header, payload, password);
end;

function CkJwt_CreateJwtCert (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; cert: HCkCert; outStr: HCkString): wordbool;
begin
  result := TCkJwt_CreateJwtCert(_map(24, 'CkJwt_CreateJwtCert'))
    (objHandle, header, payload, cert, outStr);
end;

function CkJwt__createJwtCert (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; cert: HCkCert): PWideChar;
begin
  result := TCkJwt__createJwtCert(_map(25, 'CkJwt__createJwtCert'))
    (objHandle, header, payload, cert);
end;

function CkJwt_CreateJwtPk (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; key: HCkPrivateKey; outStr: HCkString): wordbool;
begin
  result := TCkJwt_CreateJwtPk(_map(26, 'CkJwt_CreateJwtPk'))
    (objHandle, header, payload, key, outStr);
end;

function CkJwt__createJwtPk (objHandle: HCkJwt; header: PWideChar; payload: PWideChar; key: HCkPrivateKey): PWideChar;
begin
  result := TCkJwt__createJwtPk(_map(27, 'CkJwt__createJwtPk'))
    (objHandle, header, payload, key);
end;

function CkJwt_GenNumericDate (objHandle: HCkJwt; numSecOffset: Integer): Integer;
begin
  result := TCkJwt_GenNumericDate(_map(28, 'CkJwt_GenNumericDate'))
    (objHandle, numSecOffset);
end;

function CkJwt_GetHeader (objHandle: HCkJwt; token: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkJwt_GetHeader(_map(29, 'CkJwt_GetHeader'))
    (objHandle, token, outStr);
end;

function CkJwt__getHeader (objHandle: HCkJwt; token: PWideChar): PWideChar;
begin
  result := TCkJwt__getHeader(_map(30, 'CkJwt__getHeader'))
    (objHandle, token);
end;

function CkJwt_GetPayload (objHandle: HCkJwt; token: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkJwt_GetPayload(_map(31, 'CkJwt_GetPayload'))
    (objHandle, token, outStr);
end;

function CkJwt__getPayload (objHandle: HCkJwt; token: PWideChar): PWideChar;
begin
  result := TCkJwt__getPayload(_map(32, 'CkJwt__getPayload'))
    (objHandle, token);
end;

function CkJwt_IsTimeValid (objHandle: HCkJwt; jwt: PWideChar; leeway: Integer): wordbool;
begin
  result := TCkJwt_IsTimeValid(_map(33, 'CkJwt_IsTimeValid'))
    (objHandle, jwt, leeway);
end;

function CkJwt_VerifyJwt (objHandle: HCkJwt; token: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkJwt_VerifyJwt(_map(34, 'CkJwt_VerifyJwt'))
    (objHandle, token, password);
end;

function CkJwt_VerifyJwtPk (objHandle: HCkJwt; token: PWideChar; key: HCkPublicKey): wordbool;
begin
  result := TCkJwt_VerifyJwtPk(_map(35, 'CkJwt_VerifyJwtPk'))
    (objHandle, token, key);
end;

end.
