unit Log;

interface

type

HCkLog = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;


function CkLog_Create: HCkLog;  stdcall;
procedure CkLog_Dispose(handle: HCkLog); stdcall;
procedure CkLog_getDebugLogFilePath(objHandle: HCkLog; outPropVal: HCkString);
procedure CkLog_putDebugLogFilePath(objHandle: HCkLog; newPropVal: PWideChar);
function CkLog__debugLogFilePath(objHandle: HCkLog): PWideChar;
procedure CkLog_getLastErrorHtml(objHandle: HCkLog; outPropVal: HCkString);
function CkLog__lastErrorHtml(objHandle: HCkLog): PWideChar;
procedure CkLog_getLastErrorText(objHandle: HCkLog; outPropVal: HCkString);
function CkLog__lastErrorText(objHandle: HCkLog): PWideChar;
procedure CkLog_getLastErrorXml(objHandle: HCkLog; outPropVal: HCkString);
function CkLog__lastErrorXml(objHandle: HCkLog): PWideChar;
function CkLog_getLastMethodSuccess(objHandle: HCkLog): wordbool;
procedure CkLog_putLastMethodSuccess(objHandle: HCkLog; newPropVal: wordbool);
function CkLog_getVerboseLogging(objHandle: HCkLog): wordbool;
procedure CkLog_putVerboseLogging(objHandle: HCkLog; newPropVal: wordbool);
procedure CkLog_getVersion(objHandle: HCkLog; outPropVal: HCkString);
function CkLog__version(objHandle: HCkLog): PWideChar;
procedure CkLog_Clear(objHandle: HCkLog; initialTag: PWideChar);
procedure CkLog_EnterContext(objHandle: HCkLog; tag: PWideChar);
procedure CkLog_LeaveContext(objHandle: HCkLog);
procedure CkLog_LogData(objHandle: HCkLog; tag: PWideChar; message: PWideChar);
procedure CkLog_LogDataBase64(objHandle: HCkLog; tag: PWideChar; data: HCkByteData);
procedure CkLog_LogDataHex(objHandle: HCkLog; tag: PWideChar; data: HCkByteData);
procedure CkLog_LogDataMax(objHandle: HCkLog; tag: PWideChar; message: PWideChar; maxNumChars: Integer);
procedure CkLog_LogDateTime(objHandle: HCkLog; tag: PWideChar; gmt: wordbool);
procedure CkLog_LogError(objHandle: HCkLog; message: PWideChar);
procedure CkLog_LogInfo(objHandle: HCkLog; message: PWideChar);
procedure CkLog_LogInt(objHandle: HCkLog; tag: PWideChar; value: Integer);
procedure CkLog_LogInt64(objHandle: HCkLog; tag: PWideChar; value: Int64);
procedure CkLog_LogTimestamp(objHandle: HCkLog; tag: PWideChar);
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkLog_Create = function : HCkLog; stdcall;
  TCkLog_Dispose = procedure (handle: HCkLog); stdcall;
  TCkLog_getDebugLogFilePath = procedure (objHandle: HCkLog; outPropVal: HCkString); stdcall;
  TCkLog_putDebugLogFilePath = procedure (objHandle: HCkLog; newPropVal: PWideChar); stdcall;
  TCkLog__debugLogFilePath = function (objHandle: HCkLog): PWideChar; stdcall;
  TCkLog_getLastErrorHtml = procedure (objHandle: HCkLog; outPropVal: HCkString); stdcall;
  TCkLog__lastErrorHtml = function (objHandle: HCkLog): PWideChar; stdcall;
  TCkLog_getLastErrorText = procedure (objHandle: HCkLog; outPropVal: HCkString); stdcall;
  TCkLog__lastErrorText = function (objHandle: HCkLog): PWideChar; stdcall;
  TCkLog_getLastErrorXml = procedure (objHandle: HCkLog; outPropVal: HCkString); stdcall;
  TCkLog__lastErrorXml = function (objHandle: HCkLog): PWideChar; stdcall;
  TCkLog_getLastMethodSuccess = function (objHandle: HCkLog): wordbool; stdcall;
  TCkLog_putLastMethodSuccess = procedure (objHandle: HCkLog; newPropVal: wordbool); stdcall;
  TCkLog_getVerboseLogging = function (objHandle: HCkLog): wordbool; stdcall;
  TCkLog_putVerboseLogging = procedure (objHandle: HCkLog; newPropVal: wordbool); stdcall;
  TCkLog_getVersion = procedure (objHandle: HCkLog; outPropVal: HCkString); stdcall;
  TCkLog__version = function (objHandle: HCkLog): PWideChar; stdcall;
  TCkLog_Clear = procedure (objHandle: HCkLog; initialTag: PWideChar); stdcall;
  TCkLog_EnterContext = procedure (objHandle: HCkLog; tag: PWideChar); stdcall;
  TCkLog_LeaveContext = procedure (objHandle: HCkLog); stdcall;
  TCkLog_LogData = procedure (objHandle: HCkLog; tag: PWideChar; message: PWideChar); stdcall;
  TCkLog_LogDataBase64 = procedure (objHandle: HCkLog; tag: PWideChar; data: HCkByteData); stdcall;
  TCkLog_LogDataHex = procedure (objHandle: HCkLog; tag: PWideChar; data: HCkByteData); stdcall;
  TCkLog_LogDataMax = procedure (objHandle: HCkLog; tag: PWideChar; message: PWideChar; maxNumChars: Integer); stdcall;
  TCkLog_LogDateTime = procedure (objHandle: HCkLog; tag: PWideChar; gmt: wordbool); stdcall;
  TCkLog_LogError = procedure (objHandle: HCkLog; message: PWideChar); stdcall;
  TCkLog_LogInfo = procedure (objHandle: HCkLog; message: PWideChar); stdcall;
  TCkLog_LogInt = procedure (objHandle: HCkLog; tag: PWideChar; value: Integer); stdcall;
  TCkLog_LogInt64 = procedure (objHandle: HCkLog; tag: PWideChar; value: Int64); stdcall;
  TCkLog_LogTimestamp = procedure (objHandle: HCkLog; tag: PWideChar); stdcall;

var
  _fkt_ptr_arr:   array [0..29] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkLog_Create : HCkLog;
begin
  result := TCkLog_Create(_map(0, 'CkLog_Create'));
end;

procedure CkLog_Dispose (handle: HCkLog);
begin
  TCkLog_Dispose(_map(1, 'CkLog_Dispose'))
    (handle);
end;


procedure CkLog_getDebugLogFilePath (objHandle: HCkLog; outPropVal: HCkString);
begin
  TCkLog_getDebugLogFilePath(_map(2, 'CkLog_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkLog_putDebugLogFilePath (objHandle: HCkLog; newPropVal: PWideChar);
begin
  TCkLog_putDebugLogFilePath(_map(3, 'CkLog_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkLog__debugLogFilePath (objHandle: HCkLog): PWideChar;
begin
  result := TCkLog__debugLogFilePath(_map(4, 'CkLog__debugLogFilePath'))
    (objHandle);
end;

procedure CkLog_getLastErrorHtml (objHandle: HCkLog; outPropVal: HCkString);
begin
  TCkLog_getLastErrorHtml(_map(5, 'CkLog_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkLog__lastErrorHtml (objHandle: HCkLog): PWideChar;
begin
  result := TCkLog__lastErrorHtml(_map(6, 'CkLog__lastErrorHtml'))
    (objHandle);
end;

procedure CkLog_getLastErrorText (objHandle: HCkLog; outPropVal: HCkString);
begin
  TCkLog_getLastErrorText(_map(7, 'CkLog_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkLog__lastErrorText (objHandle: HCkLog): PWideChar;
begin
  result := TCkLog__lastErrorText(_map(8, 'CkLog__lastErrorText'))
    (objHandle);
end;

procedure CkLog_getLastErrorXml (objHandle: HCkLog; outPropVal: HCkString);
begin
  TCkLog_getLastErrorXml(_map(9, 'CkLog_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkLog__lastErrorXml (objHandle: HCkLog): PWideChar;
begin
  result := TCkLog__lastErrorXml(_map(10, 'CkLog__lastErrorXml'))
    (objHandle);
end;

function CkLog_getLastMethodSuccess (objHandle: HCkLog): wordbool;
begin
    result := TCkLog_getLastMethodSuccess(_map(11, 'CkLog_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkLog_putLastMethodSuccess (objHandle: HCkLog; newPropVal: wordbool);
begin
  TCkLog_putLastMethodSuccess(_map(12, 'CkLog_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkLog_getVerboseLogging (objHandle: HCkLog): wordbool;
begin
    result := TCkLog_getVerboseLogging(_map(13, 'CkLog_getVerboseLogging'))
    (objHandle);
end;

procedure CkLog_putVerboseLogging (objHandle: HCkLog; newPropVal: wordbool);
begin
  TCkLog_putVerboseLogging(_map(14, 'CkLog_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkLog_getVersion (objHandle: HCkLog; outPropVal: HCkString);
begin
  TCkLog_getVersion(_map(15, 'CkLog_getVersion'))
    (objHandle, outPropVal);
end;

function CkLog__version (objHandle: HCkLog): PWideChar;
begin
  result := TCkLog__version(_map(16, 'CkLog__version'))
    (objHandle);
end;

procedure CkLog_Clear (objHandle: HCkLog; initialTag: PWideChar);
begin
  TCkLog_Clear(_map(17, 'CkLog_Clear'))
    (objHandle, initialTag);
end;

procedure CkLog_EnterContext (objHandle: HCkLog; tag: PWideChar);
begin
  TCkLog_EnterContext(_map(18, 'CkLog_EnterContext'))
    (objHandle, tag);
end;

procedure CkLog_LeaveContext (objHandle: HCkLog);
begin
  TCkLog_LeaveContext(_map(19, 'CkLog_LeaveContext'))
    (objHandle);
end;

procedure CkLog_LogData (objHandle: HCkLog; tag: PWideChar; message: PWideChar);
begin
  TCkLog_LogData(_map(20, 'CkLog_LogData'))
    (objHandle, tag, message);
end;

procedure CkLog_LogDataBase64 (objHandle: HCkLog; tag: PWideChar; data: HCkByteData);
begin
  TCkLog_LogDataBase64(_map(21, 'CkLog_LogDataBase64'))
    (objHandle, tag, data);
end;

procedure CkLog_LogDataHex (objHandle: HCkLog; tag: PWideChar; data: HCkByteData);
begin
  TCkLog_LogDataHex(_map(22, 'CkLog_LogDataHex'))
    (objHandle, tag, data);
end;

procedure CkLog_LogDataMax (objHandle: HCkLog; tag: PWideChar; message: PWideChar; maxNumChars: Integer);
begin
  TCkLog_LogDataMax(_map(23, 'CkLog_LogDataMax'))
    (objHandle, tag, message, maxNumChars);
end;

procedure CkLog_LogDateTime (objHandle: HCkLog; tag: PWideChar; gmt: wordbool);
begin
  TCkLog_LogDateTime(_map(24, 'CkLog_LogDateTime'))
    (objHandle, tag, gmt);
end;

procedure CkLog_LogError (objHandle: HCkLog; message: PWideChar);
begin
  TCkLog_LogError(_map(25, 'CkLog_LogError'))
    (objHandle, message);
end;

procedure CkLog_LogInfo (objHandle: HCkLog; message: PWideChar);
begin
  TCkLog_LogInfo(_map(26, 'CkLog_LogInfo'))
    (objHandle, message);
end;

procedure CkLog_LogInt (objHandle: HCkLog; tag: PWideChar; value: Integer);
begin
  TCkLog_LogInt(_map(27, 'CkLog_LogInt'))
    (objHandle, tag, value);
end;

procedure CkLog_LogInt64 (objHandle: HCkLog; tag: PWideChar; value: Int64);
begin
  TCkLog_LogInt64(_map(28, 'CkLog_LogInt64'))
    (objHandle, tag, value);
end;

procedure CkLog_LogTimestamp (objHandle: HCkLog; tag: PWideChar);
begin
  TCkLog_LogTimestamp(_map(29, 'CkLog_LogTimestamp'))
    (objHandle, tag);
end;

end.
