unit Ntlm;

interface

type

HCkNtlm = Pointer;
HCkString = Pointer;


function CkNtlm_Create: HCkNtlm;  stdcall;
procedure CkNtlm_Dispose(handle: HCkNtlm); stdcall;
procedure CkNtlm_getClientChallenge(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putClientChallenge(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__clientChallenge(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getDebugLogFilePath(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putDebugLogFilePath(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__debugLogFilePath(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getDnsComputerName(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putDnsComputerName(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__dnsComputerName(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getDnsDomainName(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putDnsDomainName(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__dnsDomainName(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getDomain(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putDomain(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__domain(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getEncodingMode(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putEncodingMode(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__encodingMode(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getFlags(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putFlags(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__flags(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getLastErrorHtml(objHandle: HCkNtlm; outPropVal: HCkString);
function CkNtlm__lastErrorHtml(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getLastErrorText(objHandle: HCkNtlm; outPropVal: HCkString);
function CkNtlm__lastErrorText(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getLastErrorXml(objHandle: HCkNtlm; outPropVal: HCkString);
function CkNtlm__lastErrorXml(objHandle: HCkNtlm): PWideChar;
function CkNtlm_getLastMethodSuccess(objHandle: HCkNtlm): wordbool;
procedure CkNtlm_putLastMethodSuccess(objHandle: HCkNtlm; newPropVal: wordbool);
procedure CkNtlm_getNetBiosComputerName(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putNetBiosComputerName(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__netBiosComputerName(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getNetBiosDomainName(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putNetBiosDomainName(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__netBiosDomainName(objHandle: HCkNtlm): PWideChar;
function CkNtlm_getNtlmVersion(objHandle: HCkNtlm): Integer;
procedure CkNtlm_putNtlmVersion(objHandle: HCkNtlm; newPropVal: Integer);
function CkNtlm_getOemCodePage(objHandle: HCkNtlm): Integer;
procedure CkNtlm_putOemCodePage(objHandle: HCkNtlm; newPropVal: Integer);
procedure CkNtlm_getPassword(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putPassword(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__password(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getServerChallenge(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putServerChallenge(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__serverChallenge(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getTargetName(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putTargetName(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__targetName(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getUserName(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putUserName(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__userName(objHandle: HCkNtlm): PWideChar;
function CkNtlm_getVerboseLogging(objHandle: HCkNtlm): wordbool;
procedure CkNtlm_putVerboseLogging(objHandle: HCkNtlm; newPropVal: wordbool);
procedure CkNtlm_getVersion(objHandle: HCkNtlm; outPropVal: HCkString);
function CkNtlm__version(objHandle: HCkNtlm): PWideChar;
procedure CkNtlm_getWorkstation(objHandle: HCkNtlm; outPropVal: HCkString);
procedure CkNtlm_putWorkstation(objHandle: HCkNtlm; newPropVal: PWideChar);
function CkNtlm__workstation(objHandle: HCkNtlm): PWideChar;
function CkNtlm_CompareType3(objHandle: HCkNtlm; msg1: PWideChar; msg2: PWideChar): wordbool;
function CkNtlm_GenType1(objHandle: HCkNtlm; outStr: HCkString): wordbool;
function CkNtlm__genType1(objHandle: HCkNtlm): PWideChar;
function CkNtlm_GenType2(objHandle: HCkNtlm; type1Msg: PWideChar; outStr: HCkString): wordbool;
function CkNtlm__genType2(objHandle: HCkNtlm; type1Msg: PWideChar): PWideChar;
function CkNtlm_GenType3(objHandle: HCkNtlm; type2Msg: PWideChar; outStr: HCkString): wordbool;
function CkNtlm__genType3(objHandle: HCkNtlm; type2Msg: PWideChar): PWideChar;
function CkNtlm_LoadType3(objHandle: HCkNtlm; type3Msg: PWideChar): wordbool;
function CkNtlm_ParseType1(objHandle: HCkNtlm; type1Msg: PWideChar; outStr: HCkString): wordbool;
function CkNtlm__parseType1(objHandle: HCkNtlm; type1Msg: PWideChar): PWideChar;
function CkNtlm_ParseType2(objHandle: HCkNtlm; type2Msg: PWideChar; outStr: HCkString): wordbool;
function CkNtlm__parseType2(objHandle: HCkNtlm; type2Msg: PWideChar): PWideChar;
function CkNtlm_ParseType3(objHandle: HCkNtlm; type3Msg: PWideChar; outStr: HCkString): wordbool;
function CkNtlm__parseType3(objHandle: HCkNtlm; type3Msg: PWideChar): PWideChar;
function CkNtlm_SetFlag(objHandle: HCkNtlm; flagLetter: PWideChar; onOrOff: wordbool): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkNtlm_Create = function : HCkNtlm; stdcall;
  TCkNtlm_Dispose = procedure (handle: HCkNtlm); stdcall;
  TCkNtlm_getClientChallenge = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putClientChallenge = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__clientChallenge = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getDebugLogFilePath = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putDebugLogFilePath = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__debugLogFilePath = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getDnsComputerName = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putDnsComputerName = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__dnsComputerName = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getDnsDomainName = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putDnsDomainName = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__dnsDomainName = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getDomain = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putDomain = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__domain = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getEncodingMode = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putEncodingMode = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__encodingMode = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getFlags = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putFlags = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__flags = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getLastErrorHtml = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm__lastErrorHtml = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getLastErrorText = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm__lastErrorText = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getLastErrorXml = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm__lastErrorXml = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getLastMethodSuccess = function (objHandle: HCkNtlm): wordbool; stdcall;
  TCkNtlm_putLastMethodSuccess = procedure (objHandle: HCkNtlm; newPropVal: wordbool); stdcall;
  TCkNtlm_getNetBiosComputerName = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putNetBiosComputerName = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__netBiosComputerName = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getNetBiosDomainName = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putNetBiosDomainName = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__netBiosDomainName = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getNtlmVersion = function (objHandle: HCkNtlm): Integer; stdcall;
  TCkNtlm_putNtlmVersion = procedure (objHandle: HCkNtlm; newPropVal: Integer); stdcall;
  TCkNtlm_getOemCodePage = function (objHandle: HCkNtlm): Integer; stdcall;
  TCkNtlm_putOemCodePage = procedure (objHandle: HCkNtlm; newPropVal: Integer); stdcall;
  TCkNtlm_getPassword = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putPassword = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__password = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getServerChallenge = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putServerChallenge = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__serverChallenge = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getTargetName = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putTargetName = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__targetName = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getUserName = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putUserName = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__userName = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getVerboseLogging = function (objHandle: HCkNtlm): wordbool; stdcall;
  TCkNtlm_putVerboseLogging = procedure (objHandle: HCkNtlm; newPropVal: wordbool); stdcall;
  TCkNtlm_getVersion = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm__version = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_getWorkstation = procedure (objHandle: HCkNtlm; outPropVal: HCkString); stdcall;
  TCkNtlm_putWorkstation = procedure (objHandle: HCkNtlm; newPropVal: PWideChar); stdcall;
  TCkNtlm__workstation = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_CompareType3 = function (objHandle: HCkNtlm; msg1: PWideChar; msg2: PWideChar): wordbool; stdcall;
  TCkNtlm_GenType1 = function (objHandle: HCkNtlm; outStr: HCkString): wordbool; stdcall;
  TCkNtlm__genType1 = function (objHandle: HCkNtlm): PWideChar; stdcall;
  TCkNtlm_GenType2 = function (objHandle: HCkNtlm; type1Msg: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkNtlm__genType2 = function (objHandle: HCkNtlm; type1Msg: PWideChar): PWideChar; stdcall;
  TCkNtlm_GenType3 = function (objHandle: HCkNtlm; type2Msg: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkNtlm__genType3 = function (objHandle: HCkNtlm; type2Msg: PWideChar): PWideChar; stdcall;
  TCkNtlm_LoadType3 = function (objHandle: HCkNtlm; type3Msg: PWideChar): wordbool; stdcall;
  TCkNtlm_ParseType1 = function (objHandle: HCkNtlm; type1Msg: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkNtlm__parseType1 = function (objHandle: HCkNtlm; type1Msg: PWideChar): PWideChar; stdcall;
  TCkNtlm_ParseType2 = function (objHandle: HCkNtlm; type2Msg: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkNtlm__parseType2 = function (objHandle: HCkNtlm; type2Msg: PWideChar): PWideChar; stdcall;
  TCkNtlm_ParseType3 = function (objHandle: HCkNtlm; type3Msg: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkNtlm__parseType3 = function (objHandle: HCkNtlm; type3Msg: PWideChar): PWideChar; stdcall;
  TCkNtlm_SetFlag = function (objHandle: HCkNtlm; flagLetter: PWideChar; onOrOff: wordbool): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..74] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkNtlm_Create : HCkNtlm;
begin
  result := TCkNtlm_Create(_map(0, 'CkNtlm_Create'));
end;

procedure CkNtlm_Dispose (handle: HCkNtlm);
begin
  TCkNtlm_Dispose(_map(1, 'CkNtlm_Dispose'))
    (handle);
end;


procedure CkNtlm_getClientChallenge (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getClientChallenge(_map(2, 'CkNtlm_getClientChallenge'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putClientChallenge (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putClientChallenge(_map(3, 'CkNtlm_putClientChallenge'))
    (objHandle, newPropVal);
end;

function CkNtlm__clientChallenge (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__clientChallenge(_map(4, 'CkNtlm__clientChallenge'))
    (objHandle);
end;

procedure CkNtlm_getDebugLogFilePath (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getDebugLogFilePath(_map(5, 'CkNtlm_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putDebugLogFilePath (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putDebugLogFilePath(_map(6, 'CkNtlm_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkNtlm__debugLogFilePath (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__debugLogFilePath(_map(7, 'CkNtlm__debugLogFilePath'))
    (objHandle);
end;

procedure CkNtlm_getDnsComputerName (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getDnsComputerName(_map(8, 'CkNtlm_getDnsComputerName'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putDnsComputerName (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putDnsComputerName(_map(9, 'CkNtlm_putDnsComputerName'))
    (objHandle, newPropVal);
end;

function CkNtlm__dnsComputerName (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__dnsComputerName(_map(10, 'CkNtlm__dnsComputerName'))
    (objHandle);
end;

procedure CkNtlm_getDnsDomainName (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getDnsDomainName(_map(11, 'CkNtlm_getDnsDomainName'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putDnsDomainName (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putDnsDomainName(_map(12, 'CkNtlm_putDnsDomainName'))
    (objHandle, newPropVal);
end;

function CkNtlm__dnsDomainName (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__dnsDomainName(_map(13, 'CkNtlm__dnsDomainName'))
    (objHandle);
end;

procedure CkNtlm_getDomain (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getDomain(_map(14, 'CkNtlm_getDomain'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putDomain (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putDomain(_map(15, 'CkNtlm_putDomain'))
    (objHandle, newPropVal);
end;

function CkNtlm__domain (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__domain(_map(16, 'CkNtlm__domain'))
    (objHandle);
end;

procedure CkNtlm_getEncodingMode (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getEncodingMode(_map(17, 'CkNtlm_getEncodingMode'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putEncodingMode (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putEncodingMode(_map(18, 'CkNtlm_putEncodingMode'))
    (objHandle, newPropVal);
end;

function CkNtlm__encodingMode (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__encodingMode(_map(19, 'CkNtlm__encodingMode'))
    (objHandle);
end;

procedure CkNtlm_getFlags (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getFlags(_map(20, 'CkNtlm_getFlags'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putFlags (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putFlags(_map(21, 'CkNtlm_putFlags'))
    (objHandle, newPropVal);
end;

function CkNtlm__flags (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__flags(_map(22, 'CkNtlm__flags'))
    (objHandle);
end;

procedure CkNtlm_getLastErrorHtml (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getLastErrorHtml(_map(23, 'CkNtlm_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkNtlm__lastErrorHtml (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__lastErrorHtml(_map(24, 'CkNtlm__lastErrorHtml'))
    (objHandle);
end;

procedure CkNtlm_getLastErrorText (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getLastErrorText(_map(25, 'CkNtlm_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkNtlm__lastErrorText (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__lastErrorText(_map(26, 'CkNtlm__lastErrorText'))
    (objHandle);
end;

procedure CkNtlm_getLastErrorXml (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getLastErrorXml(_map(27, 'CkNtlm_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkNtlm__lastErrorXml (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__lastErrorXml(_map(28, 'CkNtlm__lastErrorXml'))
    (objHandle);
end;

function CkNtlm_getLastMethodSuccess (objHandle: HCkNtlm): wordbool;
begin
    result := TCkNtlm_getLastMethodSuccess(_map(29, 'CkNtlm_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkNtlm_putLastMethodSuccess (objHandle: HCkNtlm; newPropVal: wordbool);
begin
  TCkNtlm_putLastMethodSuccess(_map(30, 'CkNtlm_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkNtlm_getNetBiosComputerName (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getNetBiosComputerName(_map(31, 'CkNtlm_getNetBiosComputerName'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putNetBiosComputerName (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putNetBiosComputerName(_map(32, 'CkNtlm_putNetBiosComputerName'))
    (objHandle, newPropVal);
end;

function CkNtlm__netBiosComputerName (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__netBiosComputerName(_map(33, 'CkNtlm__netBiosComputerName'))
    (objHandle);
end;

procedure CkNtlm_getNetBiosDomainName (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getNetBiosDomainName(_map(34, 'CkNtlm_getNetBiosDomainName'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putNetBiosDomainName (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putNetBiosDomainName(_map(35, 'CkNtlm_putNetBiosDomainName'))
    (objHandle, newPropVal);
end;

function CkNtlm__netBiosDomainName (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__netBiosDomainName(_map(36, 'CkNtlm__netBiosDomainName'))
    (objHandle);
end;

function CkNtlm_getNtlmVersion (objHandle: HCkNtlm): Integer;
begin
    result := TCkNtlm_getNtlmVersion(_map(37, 'CkNtlm_getNtlmVersion'))
    (objHandle);
end;

procedure CkNtlm_putNtlmVersion (objHandle: HCkNtlm; newPropVal: Integer);
begin
  TCkNtlm_putNtlmVersion(_map(38, 'CkNtlm_putNtlmVersion'))
    (objHandle, newPropVal);
end;

function CkNtlm_getOemCodePage (objHandle: HCkNtlm): Integer;
begin
    result := TCkNtlm_getOemCodePage(_map(39, 'CkNtlm_getOemCodePage'))
    (objHandle);
end;

procedure CkNtlm_putOemCodePage (objHandle: HCkNtlm; newPropVal: Integer);
begin
  TCkNtlm_putOemCodePage(_map(40, 'CkNtlm_putOemCodePage'))
    (objHandle, newPropVal);
end;

procedure CkNtlm_getPassword (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getPassword(_map(41, 'CkNtlm_getPassword'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putPassword (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putPassword(_map(42, 'CkNtlm_putPassword'))
    (objHandle, newPropVal);
end;

function CkNtlm__password (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__password(_map(43, 'CkNtlm__password'))
    (objHandle);
end;

procedure CkNtlm_getServerChallenge (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getServerChallenge(_map(44, 'CkNtlm_getServerChallenge'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putServerChallenge (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putServerChallenge(_map(45, 'CkNtlm_putServerChallenge'))
    (objHandle, newPropVal);
end;

function CkNtlm__serverChallenge (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__serverChallenge(_map(46, 'CkNtlm__serverChallenge'))
    (objHandle);
end;

procedure CkNtlm_getTargetName (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getTargetName(_map(47, 'CkNtlm_getTargetName'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putTargetName (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putTargetName(_map(48, 'CkNtlm_putTargetName'))
    (objHandle, newPropVal);
end;

function CkNtlm__targetName (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__targetName(_map(49, 'CkNtlm__targetName'))
    (objHandle);
end;

procedure CkNtlm_getUserName (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getUserName(_map(50, 'CkNtlm_getUserName'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putUserName (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putUserName(_map(51, 'CkNtlm_putUserName'))
    (objHandle, newPropVal);
end;

function CkNtlm__userName (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__userName(_map(52, 'CkNtlm__userName'))
    (objHandle);
end;

function CkNtlm_getVerboseLogging (objHandle: HCkNtlm): wordbool;
begin
    result := TCkNtlm_getVerboseLogging(_map(53, 'CkNtlm_getVerboseLogging'))
    (objHandle);
end;

procedure CkNtlm_putVerboseLogging (objHandle: HCkNtlm; newPropVal: wordbool);
begin
  TCkNtlm_putVerboseLogging(_map(54, 'CkNtlm_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkNtlm_getVersion (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getVersion(_map(55, 'CkNtlm_getVersion'))
    (objHandle, outPropVal);
end;

function CkNtlm__version (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__version(_map(56, 'CkNtlm__version'))
    (objHandle);
end;

procedure CkNtlm_getWorkstation (objHandle: HCkNtlm; outPropVal: HCkString);
begin
  TCkNtlm_getWorkstation(_map(57, 'CkNtlm_getWorkstation'))
    (objHandle, outPropVal);
end;

procedure CkNtlm_putWorkstation (objHandle: HCkNtlm; newPropVal: PWideChar);
begin
  TCkNtlm_putWorkstation(_map(58, 'CkNtlm_putWorkstation'))
    (objHandle, newPropVal);
end;

function CkNtlm__workstation (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__workstation(_map(59, 'CkNtlm__workstation'))
    (objHandle);
end;

function CkNtlm_CompareType3 (objHandle: HCkNtlm; msg1: PWideChar; msg2: PWideChar): wordbool;
begin
  result := TCkNtlm_CompareType3(_map(60, 'CkNtlm_CompareType3'))
    (objHandle, msg1, msg2);
end;

function CkNtlm_GenType1 (objHandle: HCkNtlm; outStr: HCkString): wordbool;
begin
  result := TCkNtlm_GenType1(_map(61, 'CkNtlm_GenType1'))
    (objHandle, outStr);
end;

function CkNtlm__genType1 (objHandle: HCkNtlm): PWideChar;
begin
  result := TCkNtlm__genType1(_map(62, 'CkNtlm__genType1'))
    (objHandle);
end;

function CkNtlm_GenType2 (objHandle: HCkNtlm; type1Msg: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkNtlm_GenType2(_map(63, 'CkNtlm_GenType2'))
    (objHandle, type1Msg, outStr);
end;

function CkNtlm__genType2 (objHandle: HCkNtlm; type1Msg: PWideChar): PWideChar;
begin
  result := TCkNtlm__genType2(_map(64, 'CkNtlm__genType2'))
    (objHandle, type1Msg);
end;

function CkNtlm_GenType3 (objHandle: HCkNtlm; type2Msg: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkNtlm_GenType3(_map(65, 'CkNtlm_GenType3'))
    (objHandle, type2Msg, outStr);
end;

function CkNtlm__genType3 (objHandle: HCkNtlm; type2Msg: PWideChar): PWideChar;
begin
  result := TCkNtlm__genType3(_map(66, 'CkNtlm__genType3'))
    (objHandle, type2Msg);
end;

function CkNtlm_LoadType3 (objHandle: HCkNtlm; type3Msg: PWideChar): wordbool;
begin
  result := TCkNtlm_LoadType3(_map(67, 'CkNtlm_LoadType3'))
    (objHandle, type3Msg);
end;

function CkNtlm_ParseType1 (objHandle: HCkNtlm; type1Msg: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkNtlm_ParseType1(_map(68, 'CkNtlm_ParseType1'))
    (objHandle, type1Msg, outStr);
end;

function CkNtlm__parseType1 (objHandle: HCkNtlm; type1Msg: PWideChar): PWideChar;
begin
  result := TCkNtlm__parseType1(_map(69, 'CkNtlm__parseType1'))
    (objHandle, type1Msg);
end;

function CkNtlm_ParseType2 (objHandle: HCkNtlm; type2Msg: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkNtlm_ParseType2(_map(70, 'CkNtlm_ParseType2'))
    (objHandle, type2Msg, outStr);
end;

function CkNtlm__parseType2 (objHandle: HCkNtlm; type2Msg: PWideChar): PWideChar;
begin
  result := TCkNtlm__parseType2(_map(71, 'CkNtlm__parseType2'))
    (objHandle, type2Msg);
end;

function CkNtlm_ParseType3 (objHandle: HCkNtlm; type3Msg: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkNtlm_ParseType3(_map(72, 'CkNtlm_ParseType3'))
    (objHandle, type3Msg, outStr);
end;

function CkNtlm__parseType3 (objHandle: HCkNtlm; type3Msg: PWideChar): PWideChar;
begin
  result := TCkNtlm__parseType3(_map(73, 'CkNtlm__parseType3'))
    (objHandle, type3Msg);
end;

function CkNtlm_SetFlag (objHandle: HCkNtlm; flagLetter: PWideChar; onOrOff: wordbool): wordbool;
begin
  result := TCkNtlm_SetFlag(_map(74, 'CkNtlm_SetFlag'))
    (objHandle, flagLetter, onOrOff);
end;

end.
