unit Pdf;

interface

type

HCkPrivateKey = Pointer;
HCkJsonObject = Pointer;
HCkHttp = Pointer;
HCkTask = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;
HCkCert = Pointer;
HCkPdf = Pointer;
HCkBinData = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TPdfAbortCheck = function(): Integer; cdecl;
TPdfProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TPdfPercentDone = function(pctDone: Integer): Integer; cdecl;
TPdfTaskCompleted = procedure(task: HCkTask); cdecl;


function CkPdf_Create: HCkPdf;  stdcall;
procedure CkPdf_Dispose(handle: HCkPdf); stdcall;

procedure CkPdf_SetAbortCheck(objHandle: HCkPdf; fn: TPdfAbortCheck) stdcall;
procedure CkPdf_SetProgressInfo(objHandle: HCkPdf; fn: TPdfProgressInfo) stdcall;
procedure CkPdf_SetPercentDone(objHandle: HCkPdf; fn: TPdfPercentDone) stdcall;
procedure CkPdf_SetTaskCompleted(objHandle: HCkPdf; fn: TPdfTaskCompleted) stdcall;
procedure CkPdf_getDebugLogFilePath(objHandle: HCkPdf; outPropVal: HCkString);
procedure CkPdf_putDebugLogFilePath(objHandle: HCkPdf; newPropVal: PWideChar);
function CkPdf__debugLogFilePath(objHandle: HCkPdf): PWideChar;
function CkPdf_getHasCertificationSig(objHandle: HCkPdf): wordbool;
procedure CkPdf_getLastErrorHtml(objHandle: HCkPdf; outPropVal: HCkString);
function CkPdf__lastErrorHtml(objHandle: HCkPdf): PWideChar;
procedure CkPdf_getLastErrorText(objHandle: HCkPdf; outPropVal: HCkString);
function CkPdf__lastErrorText(objHandle: HCkPdf): PWideChar;
procedure CkPdf_getLastErrorXml(objHandle: HCkPdf; outPropVal: HCkString);
function CkPdf__lastErrorXml(objHandle: HCkPdf): PWideChar;
function CkPdf_getLastMethodSuccess(objHandle: HCkPdf): wordbool;
procedure CkPdf_putLastMethodSuccess(objHandle: HCkPdf; newPropVal: wordbool);
function CkPdf_getNumEmbeddedFiles(objHandle: HCkPdf): Integer;
function CkPdf_getNumPages(objHandle: HCkPdf): Integer;
function CkPdf_getNumSignatures(objHandle: HCkPdf): Integer;
procedure CkPdf_getOwnerPassword(objHandle: HCkPdf; outPropVal: HCkString);
procedure CkPdf_putOwnerPassword(objHandle: HCkPdf; newPropVal: PWideChar);
function CkPdf__ownerPassword(objHandle: HCkPdf): PWideChar;
function CkPdf_getSigAllocateSize(objHandle: HCkPdf): Integer;
procedure CkPdf_putSigAllocateSize(objHandle: HCkPdf; newPropVal: Integer);
procedure CkPdf_getUncommonOptions(objHandle: HCkPdf; outPropVal: HCkString);
procedure CkPdf_putUncommonOptions(objHandle: HCkPdf; newPropVal: PWideChar);
function CkPdf__uncommonOptions(objHandle: HCkPdf): PWideChar;
procedure CkPdf_getUserPassword(objHandle: HCkPdf; outPropVal: HCkString);
procedure CkPdf_putUserPassword(objHandle: HCkPdf; newPropVal: PWideChar);
function CkPdf__userPassword(objHandle: HCkPdf): PWideChar;
function CkPdf_getVerboseLogging(objHandle: HCkPdf): wordbool;
procedure CkPdf_putVerboseLogging(objHandle: HCkPdf; newPropVal: wordbool);
procedure CkPdf_getVersion(objHandle: HCkPdf; outPropVal: HCkString);
function CkPdf__version(objHandle: HCkPdf): PWideChar;
function CkPdf_AddEmbeddedFiles(objHandle: HCkPdf; json: HCkJsonObject; outFilePath: PWideChar): wordbool;
function CkPdf_AddEmbeddedFilesBd(objHandle: HCkPdf; json: HCkJsonObject; bd: HCkBinData): wordbool;
function CkPdf_AddSigningCert(objHandle: HCkPdf; cert: HCkCert): wordbool;
function CkPdf_AddVerificationInfo(objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): wordbool;
function CkPdf_AddVerificationInfoAsync(objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): HCkTask;
function CkPdf_GetDss(objHandle: HCkPdf; json: HCkJsonObject): wordbool;
function CkPdf_GetEmbeddedFileBd(objHandle: HCkPdf; index: Integer; bd: HCkBinData): wordbool;
function CkPdf_GetEmbeddedFileInfo(objHandle: HCkPdf; index: Integer; json: HCkJsonObject): wordbool;
procedure CkPdf_GetLastJsonData(objHandle: HCkPdf; json: HCkJsonObject);
function CkPdf_GetMetadata(objHandle: HCkPdf; sb: HCkStringBuilder): wordbool;
function CkPdf_GetSignatureContent(objHandle: HCkPdf; index: Integer; bd: HCkBinData): wordbool;
function CkPdf_GetSignerCert(objHandle: HCkPdf; index: Integer; cert: HCkCert): wordbool;
function CkPdf_GetUnsignedSigFields(objHandle: HCkPdf; json: HCkJsonObject): wordbool;
function CkPdf_LastJsonData(objHandle: HCkPdf): HCkJsonObject;
function CkPdf_LoadBd(objHandle: HCkPdf; pdfData: HCkBinData): wordbool;
function CkPdf_LoadFile(objHandle: HCkPdf; filePath: PWideChar): wordbool;
procedure CkPdf_SetHttpObj(objHandle: HCkPdf; http: HCkHttp);
function CkPdf_SetSignatureJpeg(objHandle: HCkPdf; jpgData: HCkBinData): wordbool;
function CkPdf_SetSigningCert(objHandle: HCkPdf; cert: HCkCert): wordbool;
function CkPdf_SetSigningCert2(objHandle: HCkPdf; cert: HCkCert; privateKey: HCkPrivateKey): wordbool;
function CkPdf_SignPdf(objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): wordbool;
function CkPdf_SignPdfAsync(objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): HCkTask;
function CkPdf_SignPdfBd(objHandle: HCkPdf; jsonOptions: HCkJsonObject; bd: HCkBinData): wordbool;
function CkPdf_SignPdfBdAsync(objHandle: HCkPdf; jsonOptions: HCkJsonObject; bd: HCkBinData): HCkTask;
function CkPdf_UpdateMetadata(objHandle: HCkPdf; sb: HCkStringBuilder; outFilePath: PWideChar): wordbool;
function CkPdf_UpdateMetadataBd(objHandle: HCkPdf; sb: HCkStringBuilder; bd: HCkBinData): wordbool;
function CkPdf_VerifySignature(objHandle: HCkPdf; index: Integer; sigInfo: HCkJsonObject): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkPdf_Create = function : HCkPdf; stdcall;
  TCkPdf_Dispose = procedure (handle: HCkPdf); stdcall;
  TCkPdf_SetAbortCheck = procedure (objHandle: HCkPdf; fn: TPdfAbortCheck); stdcall;
  TCkPdf_SetProgressInfo = procedure (objHandle: HCkPdf; fn: TPdfProgressInfo); stdcall;
  TCkPdf_SetPercentDone = procedure (objHandle: HCkPdf; fn: TPdfPercentDone); stdcall;
  TCkPdf_SetTaskCompleted = procedure (objHandle: HCkPdf; fn: TPdfTaskCompleted); stdcall;
  TCkPdf_getDebugLogFilePath = procedure (objHandle: HCkPdf; outPropVal: HCkString); stdcall;
  TCkPdf_putDebugLogFilePath = procedure (objHandle: HCkPdf; newPropVal: PWideChar); stdcall;
  TCkPdf__debugLogFilePath = function (objHandle: HCkPdf): PWideChar; stdcall;
  TCkPdf_getHasCertificationSig = function (objHandle: HCkPdf): wordbool; stdcall;
  TCkPdf_getLastErrorHtml = procedure (objHandle: HCkPdf; outPropVal: HCkString); stdcall;
  TCkPdf__lastErrorHtml = function (objHandle: HCkPdf): PWideChar; stdcall;
  TCkPdf_getLastErrorText = procedure (objHandle: HCkPdf; outPropVal: HCkString); stdcall;
  TCkPdf__lastErrorText = function (objHandle: HCkPdf): PWideChar; stdcall;
  TCkPdf_getLastErrorXml = procedure (objHandle: HCkPdf; outPropVal: HCkString); stdcall;
  TCkPdf__lastErrorXml = function (objHandle: HCkPdf): PWideChar; stdcall;
  TCkPdf_getLastMethodSuccess = function (objHandle: HCkPdf): wordbool; stdcall;
  TCkPdf_putLastMethodSuccess = procedure (objHandle: HCkPdf; newPropVal: wordbool); stdcall;
  TCkPdf_getNumEmbeddedFiles = function (objHandle: HCkPdf): Integer; stdcall;
  TCkPdf_getNumPages = function (objHandle: HCkPdf): Integer; stdcall;
  TCkPdf_getNumSignatures = function (objHandle: HCkPdf): Integer; stdcall;
  TCkPdf_getOwnerPassword = procedure (objHandle: HCkPdf; outPropVal: HCkString); stdcall;
  TCkPdf_putOwnerPassword = procedure (objHandle: HCkPdf; newPropVal: PWideChar); stdcall;
  TCkPdf__ownerPassword = function (objHandle: HCkPdf): PWideChar; stdcall;
  TCkPdf_getSigAllocateSize = function (objHandle: HCkPdf): Integer; stdcall;
  TCkPdf_putSigAllocateSize = procedure (objHandle: HCkPdf; newPropVal: Integer); stdcall;
  TCkPdf_getUncommonOptions = procedure (objHandle: HCkPdf; outPropVal: HCkString); stdcall;
  TCkPdf_putUncommonOptions = procedure (objHandle: HCkPdf; newPropVal: PWideChar); stdcall;
  TCkPdf__uncommonOptions = function (objHandle: HCkPdf): PWideChar; stdcall;
  TCkPdf_getUserPassword = procedure (objHandle: HCkPdf; outPropVal: HCkString); stdcall;
  TCkPdf_putUserPassword = procedure (objHandle: HCkPdf; newPropVal: PWideChar); stdcall;
  TCkPdf__userPassword = function (objHandle: HCkPdf): PWideChar; stdcall;
  TCkPdf_getVerboseLogging = function (objHandle: HCkPdf): wordbool; stdcall;
  TCkPdf_putVerboseLogging = procedure (objHandle: HCkPdf; newPropVal: wordbool); stdcall;
  TCkPdf_getVersion = procedure (objHandle: HCkPdf; outPropVal: HCkString); stdcall;
  TCkPdf__version = function (objHandle: HCkPdf): PWideChar; stdcall;
  TCkPdf_AddEmbeddedFiles = function (objHandle: HCkPdf; json: HCkJsonObject; outFilePath: PWideChar): wordbool; stdcall;
  TCkPdf_AddEmbeddedFilesBd = function (objHandle: HCkPdf; json: HCkJsonObject; bd: HCkBinData): wordbool; stdcall;
  TCkPdf_AddSigningCert = function (objHandle: HCkPdf; cert: HCkCert): wordbool; stdcall;
  TCkPdf_AddVerificationInfo = function (objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): wordbool; stdcall;
  TCkPdf_AddVerificationInfoAsync = function (objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): HCkTask; stdcall;
  TCkPdf_GetDss = function (objHandle: HCkPdf; json: HCkJsonObject): wordbool; stdcall;
  TCkPdf_GetEmbeddedFileBd = function (objHandle: HCkPdf; index: Integer; bd: HCkBinData): wordbool; stdcall;
  TCkPdf_GetEmbeddedFileInfo = function (objHandle: HCkPdf; index: Integer; json: HCkJsonObject): wordbool; stdcall;
  TCkPdf_GetLastJsonData = procedure (objHandle: HCkPdf; json: HCkJsonObject); stdcall;
  TCkPdf_GetMetadata = function (objHandle: HCkPdf; sb: HCkStringBuilder): wordbool; stdcall;
  TCkPdf_GetSignatureContent = function (objHandle: HCkPdf; index: Integer; bd: HCkBinData): wordbool; stdcall;
  TCkPdf_GetSignerCert = function (objHandle: HCkPdf; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkPdf_GetUnsignedSigFields = function (objHandle: HCkPdf; json: HCkJsonObject): wordbool; stdcall;
  TCkPdf_LastJsonData = function (objHandle: HCkPdf): HCkJsonObject; stdcall;
  TCkPdf_LoadBd = function (objHandle: HCkPdf; pdfData: HCkBinData): wordbool; stdcall;
  TCkPdf_LoadFile = function (objHandle: HCkPdf; filePath: PWideChar): wordbool; stdcall;
  TCkPdf_SetHttpObj = procedure (objHandle: HCkPdf; http: HCkHttp); stdcall;
  TCkPdf_SetSignatureJpeg = function (objHandle: HCkPdf; jpgData: HCkBinData): wordbool; stdcall;
  TCkPdf_SetSigningCert = function (objHandle: HCkPdf; cert: HCkCert): wordbool; stdcall;
  TCkPdf_SetSigningCert2 = function (objHandle: HCkPdf; cert: HCkCert; privateKey: HCkPrivateKey): wordbool; stdcall;
  TCkPdf_SignPdf = function (objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): wordbool; stdcall;
  TCkPdf_SignPdfAsync = function (objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): HCkTask; stdcall;
  TCkPdf_SignPdfBd = function (objHandle: HCkPdf; jsonOptions: HCkJsonObject; bd: HCkBinData): wordbool; stdcall;
  TCkPdf_SignPdfBdAsync = function (objHandle: HCkPdf; jsonOptions: HCkJsonObject; bd: HCkBinData): HCkTask; stdcall;
  TCkPdf_UpdateMetadata = function (objHandle: HCkPdf; sb: HCkStringBuilder; outFilePath: PWideChar): wordbool; stdcall;
  TCkPdf_UpdateMetadataBd = function (objHandle: HCkPdf; sb: HCkStringBuilder; bd: HCkBinData): wordbool; stdcall;
  TCkPdf_VerifySignature = function (objHandle: HCkPdf; index: Integer; sigInfo: HCkJsonObject): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..62] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkPdf_Create : HCkPdf;
begin
  result := TCkPdf_Create(_map(0, 'CkPdf_Create'));
end;

procedure CkPdf_Dispose (handle: HCkPdf);
begin
  TCkPdf_Dispose(_map(1, 'CkPdf_Dispose'))
    (handle);
end;


procedure CkPdf_SetAbortCheck (objHandle: HCkPdf; fn: TPdfAbortCheck);
begin
    TCkPdf_SetAbortCheck(_map(2, 'CkPdf_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkPdf_SetProgressInfo (objHandle: HCkPdf; fn: TPdfProgressInfo);
begin
    TCkPdf_SetProgressInfo(_map(3, 'CkPdf_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkPdf_SetPercentDone (objHandle: HCkPdf; fn: TPdfPercentDone);
begin
    TCkPdf_SetPercentDone(_map(4, 'CkPdf_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkPdf_SetTaskCompleted (objHandle: HCkPdf; fn: TPdfTaskCompleted);
begin
    TCkPdf_SetTaskCompleted(_map(5, 'CkPdf_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkPdf_getDebugLogFilePath (objHandle: HCkPdf; outPropVal: HCkString);
begin
  TCkPdf_getDebugLogFilePath(_map(6, 'CkPdf_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkPdf_putDebugLogFilePath (objHandle: HCkPdf; newPropVal: PWideChar);
begin
  TCkPdf_putDebugLogFilePath(_map(7, 'CkPdf_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkPdf__debugLogFilePath (objHandle: HCkPdf): PWideChar;
begin
  result := TCkPdf__debugLogFilePath(_map(8, 'CkPdf__debugLogFilePath'))
    (objHandle);
end;

function CkPdf_getHasCertificationSig (objHandle: HCkPdf): wordbool;
begin
    result := TCkPdf_getHasCertificationSig(_map(9, 'CkPdf_getHasCertificationSig'))
    (objHandle);
end;

procedure CkPdf_getLastErrorHtml (objHandle: HCkPdf; outPropVal: HCkString);
begin
  TCkPdf_getLastErrorHtml(_map(10, 'CkPdf_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkPdf__lastErrorHtml (objHandle: HCkPdf): PWideChar;
begin
  result := TCkPdf__lastErrorHtml(_map(11, 'CkPdf__lastErrorHtml'))
    (objHandle);
end;

procedure CkPdf_getLastErrorText (objHandle: HCkPdf; outPropVal: HCkString);
begin
  TCkPdf_getLastErrorText(_map(12, 'CkPdf_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkPdf__lastErrorText (objHandle: HCkPdf): PWideChar;
begin
  result := TCkPdf__lastErrorText(_map(13, 'CkPdf__lastErrorText'))
    (objHandle);
end;

procedure CkPdf_getLastErrorXml (objHandle: HCkPdf; outPropVal: HCkString);
begin
  TCkPdf_getLastErrorXml(_map(14, 'CkPdf_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkPdf__lastErrorXml (objHandle: HCkPdf): PWideChar;
begin
  result := TCkPdf__lastErrorXml(_map(15, 'CkPdf__lastErrorXml'))
    (objHandle);
end;

function CkPdf_getLastMethodSuccess (objHandle: HCkPdf): wordbool;
begin
    result := TCkPdf_getLastMethodSuccess(_map(16, 'CkPdf_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkPdf_putLastMethodSuccess (objHandle: HCkPdf; newPropVal: wordbool);
begin
  TCkPdf_putLastMethodSuccess(_map(17, 'CkPdf_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkPdf_getNumEmbeddedFiles (objHandle: HCkPdf): Integer;
begin
    result := TCkPdf_getNumEmbeddedFiles(_map(18, 'CkPdf_getNumEmbeddedFiles'))
    (objHandle);
end;

function CkPdf_getNumPages (objHandle: HCkPdf): Integer;
begin
    result := TCkPdf_getNumPages(_map(19, 'CkPdf_getNumPages'))
    (objHandle);
end;

function CkPdf_getNumSignatures (objHandle: HCkPdf): Integer;
begin
    result := TCkPdf_getNumSignatures(_map(20, 'CkPdf_getNumSignatures'))
    (objHandle);
end;

procedure CkPdf_getOwnerPassword (objHandle: HCkPdf; outPropVal: HCkString);
begin
  TCkPdf_getOwnerPassword(_map(21, 'CkPdf_getOwnerPassword'))
    (objHandle, outPropVal);
end;

procedure CkPdf_putOwnerPassword (objHandle: HCkPdf; newPropVal: PWideChar);
begin
  TCkPdf_putOwnerPassword(_map(22, 'CkPdf_putOwnerPassword'))
    (objHandle, newPropVal);
end;

function CkPdf__ownerPassword (objHandle: HCkPdf): PWideChar;
begin
  result := TCkPdf__ownerPassword(_map(23, 'CkPdf__ownerPassword'))
    (objHandle);
end;

function CkPdf_getSigAllocateSize (objHandle: HCkPdf): Integer;
begin
    result := TCkPdf_getSigAllocateSize(_map(24, 'CkPdf_getSigAllocateSize'))
    (objHandle);
end;

procedure CkPdf_putSigAllocateSize (objHandle: HCkPdf; newPropVal: Integer);
begin
  TCkPdf_putSigAllocateSize(_map(25, 'CkPdf_putSigAllocateSize'))
    (objHandle, newPropVal);
end;

procedure CkPdf_getUncommonOptions (objHandle: HCkPdf; outPropVal: HCkString);
begin
  TCkPdf_getUncommonOptions(_map(26, 'CkPdf_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkPdf_putUncommonOptions (objHandle: HCkPdf; newPropVal: PWideChar);
begin
  TCkPdf_putUncommonOptions(_map(27, 'CkPdf_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkPdf__uncommonOptions (objHandle: HCkPdf): PWideChar;
begin
  result := TCkPdf__uncommonOptions(_map(28, 'CkPdf__uncommonOptions'))
    (objHandle);
end;

procedure CkPdf_getUserPassword (objHandle: HCkPdf; outPropVal: HCkString);
begin
  TCkPdf_getUserPassword(_map(29, 'CkPdf_getUserPassword'))
    (objHandle, outPropVal);
end;

procedure CkPdf_putUserPassword (objHandle: HCkPdf; newPropVal: PWideChar);
begin
  TCkPdf_putUserPassword(_map(30, 'CkPdf_putUserPassword'))
    (objHandle, newPropVal);
end;

function CkPdf__userPassword (objHandle: HCkPdf): PWideChar;
begin
  result := TCkPdf__userPassword(_map(31, 'CkPdf__userPassword'))
    (objHandle);
end;

function CkPdf_getVerboseLogging (objHandle: HCkPdf): wordbool;
begin
    result := TCkPdf_getVerboseLogging(_map(32, 'CkPdf_getVerboseLogging'))
    (objHandle);
end;

procedure CkPdf_putVerboseLogging (objHandle: HCkPdf; newPropVal: wordbool);
begin
  TCkPdf_putVerboseLogging(_map(33, 'CkPdf_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkPdf_getVersion (objHandle: HCkPdf; outPropVal: HCkString);
begin
  TCkPdf_getVersion(_map(34, 'CkPdf_getVersion'))
    (objHandle, outPropVal);
end;

function CkPdf__version (objHandle: HCkPdf): PWideChar;
begin
  result := TCkPdf__version(_map(35, 'CkPdf__version'))
    (objHandle);
end;

function CkPdf_AddEmbeddedFiles (objHandle: HCkPdf; json: HCkJsonObject; outFilePath: PWideChar): wordbool;
begin
  result := TCkPdf_AddEmbeddedFiles(_map(36, 'CkPdf_AddEmbeddedFiles'))
    (objHandle, json, outFilePath);
end;

function CkPdf_AddEmbeddedFilesBd (objHandle: HCkPdf; json: HCkJsonObject; bd: HCkBinData): wordbool;
begin
  result := TCkPdf_AddEmbeddedFilesBd(_map(37, 'CkPdf_AddEmbeddedFilesBd'))
    (objHandle, json, bd);
end;

function CkPdf_AddSigningCert (objHandle: HCkPdf; cert: HCkCert): wordbool;
begin
  result := TCkPdf_AddSigningCert(_map(38, 'CkPdf_AddSigningCert'))
    (objHandle, cert);
end;

function CkPdf_AddVerificationInfo (objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): wordbool;
begin
  result := TCkPdf_AddVerificationInfo(_map(39, 'CkPdf_AddVerificationInfo'))
    (objHandle, jsonOptions, outFilePath);
end;

function CkPdf_AddVerificationInfoAsync (objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): HCkTask;
begin
  result := TCkPdf_AddVerificationInfoAsync(_map(40, 'CkPdf_AddVerificationInfoAsync'))
    (objHandle, jsonOptions, outFilePath);
end;

function CkPdf_GetDss (objHandle: HCkPdf; json: HCkJsonObject): wordbool;
begin
  result := TCkPdf_GetDss(_map(41, 'CkPdf_GetDss'))
    (objHandle, json);
end;

function CkPdf_GetEmbeddedFileBd (objHandle: HCkPdf; index: Integer; bd: HCkBinData): wordbool;
begin
  result := TCkPdf_GetEmbeddedFileBd(_map(42, 'CkPdf_GetEmbeddedFileBd'))
    (objHandle, index, bd);
end;

function CkPdf_GetEmbeddedFileInfo (objHandle: HCkPdf; index: Integer; json: HCkJsonObject): wordbool;
begin
  result := TCkPdf_GetEmbeddedFileInfo(_map(43, 'CkPdf_GetEmbeddedFileInfo'))
    (objHandle, index, json);
end;

procedure CkPdf_GetLastJsonData (objHandle: HCkPdf; json: HCkJsonObject);
begin
  TCkPdf_GetLastJsonData(_map(44, 'CkPdf_GetLastJsonData'))
    (objHandle, json);
end;

function CkPdf_GetMetadata (objHandle: HCkPdf; sb: HCkStringBuilder): wordbool;
begin
  result := TCkPdf_GetMetadata(_map(45, 'CkPdf_GetMetadata'))
    (objHandle, sb);
end;

function CkPdf_GetSignatureContent (objHandle: HCkPdf; index: Integer; bd: HCkBinData): wordbool;
begin
  result := TCkPdf_GetSignatureContent(_map(46, 'CkPdf_GetSignatureContent'))
    (objHandle, index, bd);
end;

function CkPdf_GetSignerCert (objHandle: HCkPdf; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkPdf_GetSignerCert(_map(47, 'CkPdf_GetSignerCert'))
    (objHandle, index, cert);
end;

function CkPdf_GetUnsignedSigFields (objHandle: HCkPdf; json: HCkJsonObject): wordbool;
begin
  result := TCkPdf_GetUnsignedSigFields(_map(48, 'CkPdf_GetUnsignedSigFields'))
    (objHandle, json);
end;

function CkPdf_LastJsonData (objHandle: HCkPdf): HCkJsonObject;
begin
  result := TCkPdf_LastJsonData(_map(49, 'CkPdf_LastJsonData'))
    (objHandle);
end;

function CkPdf_LoadBd (objHandle: HCkPdf; pdfData: HCkBinData): wordbool;
begin
  result := TCkPdf_LoadBd(_map(50, 'CkPdf_LoadBd'))
    (objHandle, pdfData);
end;

function CkPdf_LoadFile (objHandle: HCkPdf; filePath: PWideChar): wordbool;
begin
  result := TCkPdf_LoadFile(_map(51, 'CkPdf_LoadFile'))
    (objHandle, filePath);
end;

procedure CkPdf_SetHttpObj (objHandle: HCkPdf; http: HCkHttp);
begin
  TCkPdf_SetHttpObj(_map(52, 'CkPdf_SetHttpObj'))
    (objHandle, http);
end;

function CkPdf_SetSignatureJpeg (objHandle: HCkPdf; jpgData: HCkBinData): wordbool;
begin
  result := TCkPdf_SetSignatureJpeg(_map(53, 'CkPdf_SetSignatureJpeg'))
    (objHandle, jpgData);
end;

function CkPdf_SetSigningCert (objHandle: HCkPdf; cert: HCkCert): wordbool;
begin
  result := TCkPdf_SetSigningCert(_map(54, 'CkPdf_SetSigningCert'))
    (objHandle, cert);
end;

function CkPdf_SetSigningCert2 (objHandle: HCkPdf; cert: HCkCert; privateKey: HCkPrivateKey): wordbool;
begin
  result := TCkPdf_SetSigningCert2(_map(55, 'CkPdf_SetSigningCert2'))
    (objHandle, cert, privateKey);
end;

function CkPdf_SignPdf (objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): wordbool;
begin
  result := TCkPdf_SignPdf(_map(56, 'CkPdf_SignPdf'))
    (objHandle, jsonOptions, outFilePath);
end;

function CkPdf_SignPdfAsync (objHandle: HCkPdf; jsonOptions: HCkJsonObject; outFilePath: PWideChar): HCkTask;
begin
  result := TCkPdf_SignPdfAsync(_map(57, 'CkPdf_SignPdfAsync'))
    (objHandle, jsonOptions, outFilePath);
end;

function CkPdf_SignPdfBd (objHandle: HCkPdf; jsonOptions: HCkJsonObject; bd: HCkBinData): wordbool;
begin
  result := TCkPdf_SignPdfBd(_map(58, 'CkPdf_SignPdfBd'))
    (objHandle, jsonOptions, bd);
end;

function CkPdf_SignPdfBdAsync (objHandle: HCkPdf; jsonOptions: HCkJsonObject; bd: HCkBinData): HCkTask;
begin
  result := TCkPdf_SignPdfBdAsync(_map(59, 'CkPdf_SignPdfBdAsync'))
    (objHandle, jsonOptions, bd);
end;

function CkPdf_UpdateMetadata (objHandle: HCkPdf; sb: HCkStringBuilder; outFilePath: PWideChar): wordbool;
begin
  result := TCkPdf_UpdateMetadata(_map(60, 'CkPdf_UpdateMetadata'))
    (objHandle, sb, outFilePath);
end;

function CkPdf_UpdateMetadataBd (objHandle: HCkPdf; sb: HCkStringBuilder; bd: HCkBinData): wordbool;
begin
  result := TCkPdf_UpdateMetadataBd(_map(61, 'CkPdf_UpdateMetadataBd'))
    (objHandle, sb, bd);
end;

function CkPdf_VerifySignature (objHandle: HCkPdf; index: Integer; sigInfo: HCkJsonObject): wordbool;
begin
  result := TCkPdf_VerifySignature(_map(62, 'CkPdf_VerifySignature'))
    (objHandle, index, sigInfo);
end;

end.
