unit Pem;

interface

type

HCkPem = Pointer;
HCkBinData = Pointer;
HCkPrivateKey = Pointer;
HCkTask = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkJavaKeyStore = Pointer;
HCkPublicKey = Pointer;
HCkCertChain = Pointer;
HCkCert = Pointer;
HCkPfx = Pointer;


function CkPem_Create: HCkPem;  stdcall;
procedure CkPem_Dispose(handle: HCkPem); stdcall;
function CkPem_getAppendMode(objHandle: HCkPem): wordbool;
procedure CkPem_putAppendMode(objHandle: HCkPem; newPropVal: wordbool);
procedure CkPem_getDebugLogFilePath(objHandle: HCkPem; outPropVal: HCkString);
procedure CkPem_putDebugLogFilePath(objHandle: HCkPem; newPropVal: PWideChar);
function CkPem__debugLogFilePath(objHandle: HCkPem): PWideChar;
function CkPem_getHeartbeatMs(objHandle: HCkPem): Integer;
procedure CkPem_putHeartbeatMs(objHandle: HCkPem; newPropVal: Integer);
procedure CkPem_getLastErrorHtml(objHandle: HCkPem; outPropVal: HCkString);
function CkPem__lastErrorHtml(objHandle: HCkPem): PWideChar;
procedure CkPem_getLastErrorText(objHandle: HCkPem; outPropVal: HCkString);
function CkPem__lastErrorText(objHandle: HCkPem): PWideChar;
procedure CkPem_getLastErrorXml(objHandle: HCkPem; outPropVal: HCkString);
function CkPem__lastErrorXml(objHandle: HCkPem): PWideChar;
function CkPem_getLastMethodSuccess(objHandle: HCkPem): wordbool;
procedure CkPem_putLastMethodSuccess(objHandle: HCkPem; newPropVal: wordbool);
function CkPem_getNumCerts(objHandle: HCkPem): Integer;
function CkPem_getNumCrls(objHandle: HCkPem): Integer;
function CkPem_getNumCsrs(objHandle: HCkPem): Integer;
function CkPem_getNumPrivateKeys(objHandle: HCkPem): Integer;
function CkPem_getNumPublicKeys(objHandle: HCkPem): Integer;
procedure CkPem_getPrivateKeyFormat(objHandle: HCkPem; outPropVal: HCkString);
procedure CkPem_putPrivateKeyFormat(objHandle: HCkPem; newPropVal: PWideChar);
function CkPem__privateKeyFormat(objHandle: HCkPem): PWideChar;
procedure CkPem_getPublicKeyFormat(objHandle: HCkPem; outPropVal: HCkString);
procedure CkPem_putPublicKeyFormat(objHandle: HCkPem; newPropVal: PWideChar);
function CkPem__publicKeyFormat(objHandle: HCkPem): PWideChar;
function CkPem_getVerboseLogging(objHandle: HCkPem): wordbool;
procedure CkPem_putVerboseLogging(objHandle: HCkPem; newPropVal: wordbool);
procedure CkPem_getVersion(objHandle: HCkPem; outPropVal: HCkString);
function CkPem__version(objHandle: HCkPem): PWideChar;
function CkPem_AddCert(objHandle: HCkPem; cert: HCkCert; includeChain: wordbool): wordbool;
function CkPem_AddItem(objHandle: HCkPem; itemType: PWideChar; encoding: PWideChar; itemData: PWideChar): wordbool;
function CkPem_AddP7b(objHandle: HCkPem; bd: HCkBinData): wordbool;
function CkPem_AddPrivateKey(objHandle: HCkPem; privateKey: HCkPrivateKey): wordbool;
function CkPem_AddPrivateKey2(objHandle: HCkPem; privKey: HCkPrivateKey; certChain: HCkCertChain): wordbool;
function CkPem_AddPublicKey(objHandle: HCkPem; pubkey: HCkPublicKey): wordbool;
function CkPem_CertAt(objHandle: HCkPem; index: Integer; cert: HCkCert): wordbool;
function CkPem_Clear(objHandle: HCkPem): wordbool;
function CkPem_GetCert(objHandle: HCkPem; index: Integer): HCkCert;
function CkPem_GetEncodedItem(objHandle: HCkPem; itemType: PWideChar; itemSubType: PWideChar; encoding: PWideChar; index: Integer; outStr: HCkString): wordbool;
function CkPem__getEncodedItem(objHandle: HCkPem; itemType: PWideChar; itemSubType: PWideChar; encoding: PWideChar; index: Integer): PWideChar;
function CkPem_GetPrivateKey(objHandle: HCkPem; index: Integer): HCkPrivateKey;
function CkPem_GetPublicKey(objHandle: HCkPem; index: Integer): HCkPublicKey;
function CkPem_LoadP7b(objHandle: HCkPem; p7bData: HCkByteData): wordbool;
function CkPem_LoadP7bFile(objHandle: HCkPem; path: PWideChar): wordbool;
function CkPem_LoadPem(objHandle: HCkPem; pemContent: PWideChar; password: PWideChar): wordbool;
function CkPem_LoadPemFile(objHandle: HCkPem; path: PWideChar; password: PWideChar): wordbool;
function CkPem_LoadTaskCaller(objHandle: HCkPem; task: HCkTask): wordbool;
function CkPem_PrivateKeyAt(objHandle: HCkPem; index: Integer; privKey: HCkPrivateKey): wordbool;
function CkPem_PublicKeyAt(objHandle: HCkPem; index: Integer; pubKey: HCkPublicKey): wordbool;
function CkPem_RemoveCert(objHandle: HCkPem; index: Integer): wordbool;
function CkPem_RemovePrivateKey(objHandle: HCkPem; index: Integer): wordbool;
function CkPem_ToJks(objHandle: HCkPem; alias: PWideChar; password: PWideChar): HCkJavaKeyStore;
function CkPem_ToJksObj(objHandle: HCkPem; alias: PWideChar; password: PWideChar; jksObj: HCkJavaKeyStore): wordbool;
function CkPem_ToPem(objHandle: HCkPem; outStr: HCkString): wordbool;
function CkPem__toPem(objHandle: HCkPem): PWideChar;
function CkPem_ToPemEx(objHandle: HCkPem; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar; outStr: HCkString): wordbool;
function CkPem__toPemEx(objHandle: HCkPem; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar): PWideChar;
function CkPem_ToPfx(objHandle: HCkPem): HCkPfx;
function CkPem_ToPfxObj(objHandle: HCkPem; pfxObj: HCkPfx): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkPem_Create = function : HCkPem; stdcall;
  TCkPem_Dispose = procedure (handle: HCkPem); stdcall;
  TCkPem_getAppendMode = function (objHandle: HCkPem): wordbool; stdcall;
  TCkPem_putAppendMode = procedure (objHandle: HCkPem; newPropVal: wordbool); stdcall;
  TCkPem_getDebugLogFilePath = procedure (objHandle: HCkPem; outPropVal: HCkString); stdcall;
  TCkPem_putDebugLogFilePath = procedure (objHandle: HCkPem; newPropVal: PWideChar); stdcall;
  TCkPem__debugLogFilePath = function (objHandle: HCkPem): PWideChar; stdcall;
  TCkPem_getHeartbeatMs = function (objHandle: HCkPem): Integer; stdcall;
  TCkPem_putHeartbeatMs = procedure (objHandle: HCkPem; newPropVal: Integer); stdcall;
  TCkPem_getLastErrorHtml = procedure (objHandle: HCkPem; outPropVal: HCkString); stdcall;
  TCkPem__lastErrorHtml = function (objHandle: HCkPem): PWideChar; stdcall;
  TCkPem_getLastErrorText = procedure (objHandle: HCkPem; outPropVal: HCkString); stdcall;
  TCkPem__lastErrorText = function (objHandle: HCkPem): PWideChar; stdcall;
  TCkPem_getLastErrorXml = procedure (objHandle: HCkPem; outPropVal: HCkString); stdcall;
  TCkPem__lastErrorXml = function (objHandle: HCkPem): PWideChar; stdcall;
  TCkPem_getLastMethodSuccess = function (objHandle: HCkPem): wordbool; stdcall;
  TCkPem_putLastMethodSuccess = procedure (objHandle: HCkPem; newPropVal: wordbool); stdcall;
  TCkPem_getNumCerts = function (objHandle: HCkPem): Integer; stdcall;
  TCkPem_getNumCrls = function (objHandle: HCkPem): Integer; stdcall;
  TCkPem_getNumCsrs = function (objHandle: HCkPem): Integer; stdcall;
  TCkPem_getNumPrivateKeys = function (objHandle: HCkPem): Integer; stdcall;
  TCkPem_getNumPublicKeys = function (objHandle: HCkPem): Integer; stdcall;
  TCkPem_getPrivateKeyFormat = procedure (objHandle: HCkPem; outPropVal: HCkString); stdcall;
  TCkPem_putPrivateKeyFormat = procedure (objHandle: HCkPem; newPropVal: PWideChar); stdcall;
  TCkPem__privateKeyFormat = function (objHandle: HCkPem): PWideChar; stdcall;
  TCkPem_getPublicKeyFormat = procedure (objHandle: HCkPem; outPropVal: HCkString); stdcall;
  TCkPem_putPublicKeyFormat = procedure (objHandle: HCkPem; newPropVal: PWideChar); stdcall;
  TCkPem__publicKeyFormat = function (objHandle: HCkPem): PWideChar; stdcall;
  TCkPem_getVerboseLogging = function (objHandle: HCkPem): wordbool; stdcall;
  TCkPem_putVerboseLogging = procedure (objHandle: HCkPem; newPropVal: wordbool); stdcall;
  TCkPem_getVersion = procedure (objHandle: HCkPem; outPropVal: HCkString); stdcall;
  TCkPem__version = function (objHandle: HCkPem): PWideChar; stdcall;
  TCkPem_AddCert = function (objHandle: HCkPem; cert: HCkCert; includeChain: wordbool): wordbool; stdcall;
  TCkPem_AddItem = function (objHandle: HCkPem; itemType: PWideChar; encoding: PWideChar; itemData: PWideChar): wordbool; stdcall;
  TCkPem_AddP7b = function (objHandle: HCkPem; bd: HCkBinData): wordbool; stdcall;
  TCkPem_AddPrivateKey = function (objHandle: HCkPem; privateKey: HCkPrivateKey): wordbool; stdcall;
  TCkPem_AddPrivateKey2 = function (objHandle: HCkPem; privKey: HCkPrivateKey; certChain: HCkCertChain): wordbool; stdcall;
  TCkPem_AddPublicKey = function (objHandle: HCkPem; pubkey: HCkPublicKey): wordbool; stdcall;
  TCkPem_CertAt = function (objHandle: HCkPem; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkPem_Clear = function (objHandle: HCkPem): wordbool; stdcall;
  TCkPem_GetCert = function (objHandle: HCkPem; index: Integer): HCkCert; stdcall;
  TCkPem_GetEncodedItem = function (objHandle: HCkPem; itemType: PWideChar; itemSubType: PWideChar; encoding: PWideChar; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkPem__getEncodedItem = function (objHandle: HCkPem; itemType: PWideChar; itemSubType: PWideChar; encoding: PWideChar; index: Integer): PWideChar; stdcall;
  TCkPem_GetPrivateKey = function (objHandle: HCkPem; index: Integer): HCkPrivateKey; stdcall;
  TCkPem_GetPublicKey = function (objHandle: HCkPem; index: Integer): HCkPublicKey; stdcall;
  TCkPem_LoadP7b = function (objHandle: HCkPem; p7bData: HCkByteData): wordbool; stdcall;
  TCkPem_LoadP7bFile = function (objHandle: HCkPem; path: PWideChar): wordbool; stdcall;
  TCkPem_LoadPem = function (objHandle: HCkPem; pemContent: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkPem_LoadPemFile = function (objHandle: HCkPem; path: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkPem_LoadTaskCaller = function (objHandle: HCkPem; task: HCkTask): wordbool; stdcall;
  TCkPem_PrivateKeyAt = function (objHandle: HCkPem; index: Integer; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkPem_PublicKeyAt = function (objHandle: HCkPem; index: Integer; pubKey: HCkPublicKey): wordbool; stdcall;
  TCkPem_RemoveCert = function (objHandle: HCkPem; index: Integer): wordbool; stdcall;
  TCkPem_RemovePrivateKey = function (objHandle: HCkPem; index: Integer): wordbool; stdcall;
  TCkPem_ToJks = function (objHandle: HCkPem; alias: PWideChar; password: PWideChar): HCkJavaKeyStore; stdcall;
  TCkPem_ToJksObj = function (objHandle: HCkPem; alias: PWideChar; password: PWideChar; jksObj: HCkJavaKeyStore): wordbool; stdcall;
  TCkPem_ToPem = function (objHandle: HCkPem; outStr: HCkString): wordbool; stdcall;
  TCkPem__toPem = function (objHandle: HCkPem): PWideChar; stdcall;
  TCkPem_ToPemEx = function (objHandle: HCkPem; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPem__toPemEx = function (objHandle: HCkPem; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar): PWideChar; stdcall;
  TCkPem_ToPfx = function (objHandle: HCkPem): HCkPfx; stdcall;
  TCkPem_ToPfxObj = function (objHandle: HCkPem; pfxObj: HCkPfx): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..61] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkPem_Create : HCkPem;
begin
  result := TCkPem_Create(_map(0, 'CkPem_Create'));
end;

procedure CkPem_Dispose (handle: HCkPem);
begin
  TCkPem_Dispose(_map(1, 'CkPem_Dispose'))
    (handle);
end;


function CkPem_getAppendMode (objHandle: HCkPem): wordbool;
begin
    result := TCkPem_getAppendMode(_map(2, 'CkPem_getAppendMode'))
    (objHandle);
end;

procedure CkPem_putAppendMode (objHandle: HCkPem; newPropVal: wordbool);
begin
  TCkPem_putAppendMode(_map(3, 'CkPem_putAppendMode'))
    (objHandle, newPropVal);
end;

procedure CkPem_getDebugLogFilePath (objHandle: HCkPem; outPropVal: HCkString);
begin
  TCkPem_getDebugLogFilePath(_map(4, 'CkPem_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkPem_putDebugLogFilePath (objHandle: HCkPem; newPropVal: PWideChar);
begin
  TCkPem_putDebugLogFilePath(_map(5, 'CkPem_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkPem__debugLogFilePath (objHandle: HCkPem): PWideChar;
begin
  result := TCkPem__debugLogFilePath(_map(6, 'CkPem__debugLogFilePath'))
    (objHandle);
end;

function CkPem_getHeartbeatMs (objHandle: HCkPem): Integer;
begin
    result := TCkPem_getHeartbeatMs(_map(7, 'CkPem_getHeartbeatMs'))
    (objHandle);
end;

procedure CkPem_putHeartbeatMs (objHandle: HCkPem; newPropVal: Integer);
begin
  TCkPem_putHeartbeatMs(_map(8, 'CkPem_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkPem_getLastErrorHtml (objHandle: HCkPem; outPropVal: HCkString);
begin
  TCkPem_getLastErrorHtml(_map(9, 'CkPem_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkPem__lastErrorHtml (objHandle: HCkPem): PWideChar;
begin
  result := TCkPem__lastErrorHtml(_map(10, 'CkPem__lastErrorHtml'))
    (objHandle);
end;

procedure CkPem_getLastErrorText (objHandle: HCkPem; outPropVal: HCkString);
begin
  TCkPem_getLastErrorText(_map(11, 'CkPem_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkPem__lastErrorText (objHandle: HCkPem): PWideChar;
begin
  result := TCkPem__lastErrorText(_map(12, 'CkPem__lastErrorText'))
    (objHandle);
end;

procedure CkPem_getLastErrorXml (objHandle: HCkPem; outPropVal: HCkString);
begin
  TCkPem_getLastErrorXml(_map(13, 'CkPem_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkPem__lastErrorXml (objHandle: HCkPem): PWideChar;
begin
  result := TCkPem__lastErrorXml(_map(14, 'CkPem__lastErrorXml'))
    (objHandle);
end;

function CkPem_getLastMethodSuccess (objHandle: HCkPem): wordbool;
begin
    result := TCkPem_getLastMethodSuccess(_map(15, 'CkPem_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkPem_putLastMethodSuccess (objHandle: HCkPem; newPropVal: wordbool);
begin
  TCkPem_putLastMethodSuccess(_map(16, 'CkPem_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkPem_getNumCerts (objHandle: HCkPem): Integer;
begin
    result := TCkPem_getNumCerts(_map(17, 'CkPem_getNumCerts'))
    (objHandle);
end;

function CkPem_getNumCrls (objHandle: HCkPem): Integer;
begin
    result := TCkPem_getNumCrls(_map(18, 'CkPem_getNumCrls'))
    (objHandle);
end;

function CkPem_getNumCsrs (objHandle: HCkPem): Integer;
begin
    result := TCkPem_getNumCsrs(_map(19, 'CkPem_getNumCsrs'))
    (objHandle);
end;

function CkPem_getNumPrivateKeys (objHandle: HCkPem): Integer;
begin
    result := TCkPem_getNumPrivateKeys(_map(20, 'CkPem_getNumPrivateKeys'))
    (objHandle);
end;

function CkPem_getNumPublicKeys (objHandle: HCkPem): Integer;
begin
    result := TCkPem_getNumPublicKeys(_map(21, 'CkPem_getNumPublicKeys'))
    (objHandle);
end;

procedure CkPem_getPrivateKeyFormat (objHandle: HCkPem; outPropVal: HCkString);
begin
  TCkPem_getPrivateKeyFormat(_map(22, 'CkPem_getPrivateKeyFormat'))
    (objHandle, outPropVal);
end;

procedure CkPem_putPrivateKeyFormat (objHandle: HCkPem; newPropVal: PWideChar);
begin
  TCkPem_putPrivateKeyFormat(_map(23, 'CkPem_putPrivateKeyFormat'))
    (objHandle, newPropVal);
end;

function CkPem__privateKeyFormat (objHandle: HCkPem): PWideChar;
begin
  result := TCkPem__privateKeyFormat(_map(24, 'CkPem__privateKeyFormat'))
    (objHandle);
end;

procedure CkPem_getPublicKeyFormat (objHandle: HCkPem; outPropVal: HCkString);
begin
  TCkPem_getPublicKeyFormat(_map(25, 'CkPem_getPublicKeyFormat'))
    (objHandle, outPropVal);
end;

procedure CkPem_putPublicKeyFormat (objHandle: HCkPem; newPropVal: PWideChar);
begin
  TCkPem_putPublicKeyFormat(_map(26, 'CkPem_putPublicKeyFormat'))
    (objHandle, newPropVal);
end;

function CkPem__publicKeyFormat (objHandle: HCkPem): PWideChar;
begin
  result := TCkPem__publicKeyFormat(_map(27, 'CkPem__publicKeyFormat'))
    (objHandle);
end;

function CkPem_getVerboseLogging (objHandle: HCkPem): wordbool;
begin
    result := TCkPem_getVerboseLogging(_map(28, 'CkPem_getVerboseLogging'))
    (objHandle);
end;

procedure CkPem_putVerboseLogging (objHandle: HCkPem; newPropVal: wordbool);
begin
  TCkPem_putVerboseLogging(_map(29, 'CkPem_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkPem_getVersion (objHandle: HCkPem; outPropVal: HCkString);
begin
  TCkPem_getVersion(_map(30, 'CkPem_getVersion'))
    (objHandle, outPropVal);
end;

function CkPem__version (objHandle: HCkPem): PWideChar;
begin
  result := TCkPem__version(_map(31, 'CkPem__version'))
    (objHandle);
end;

function CkPem_AddCert (objHandle: HCkPem; cert: HCkCert; includeChain: wordbool): wordbool;
begin
  result := TCkPem_AddCert(_map(32, 'CkPem_AddCert'))
    (objHandle, cert, includeChain);
end;

function CkPem_AddItem (objHandle: HCkPem; itemType: PWideChar; encoding: PWideChar; itemData: PWideChar): wordbool;
begin
  result := TCkPem_AddItem(_map(33, 'CkPem_AddItem'))
    (objHandle, itemType, encoding, itemData);
end;

function CkPem_AddP7b (objHandle: HCkPem; bd: HCkBinData): wordbool;
begin
  result := TCkPem_AddP7b(_map(34, 'CkPem_AddP7b'))
    (objHandle, bd);
end;

function CkPem_AddPrivateKey (objHandle: HCkPem; privateKey: HCkPrivateKey): wordbool;
begin
  result := TCkPem_AddPrivateKey(_map(35, 'CkPem_AddPrivateKey'))
    (objHandle, privateKey);
end;

function CkPem_AddPrivateKey2 (objHandle: HCkPem; privKey: HCkPrivateKey; certChain: HCkCertChain): wordbool;
begin
  result := TCkPem_AddPrivateKey2(_map(36, 'CkPem_AddPrivateKey2'))
    (objHandle, privKey, certChain);
end;

function CkPem_AddPublicKey (objHandle: HCkPem; pubkey: HCkPublicKey): wordbool;
begin
  result := TCkPem_AddPublicKey(_map(37, 'CkPem_AddPublicKey'))
    (objHandle, pubkey);
end;

function CkPem_CertAt (objHandle: HCkPem; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkPem_CertAt(_map(38, 'CkPem_CertAt'))
    (objHandle, index, cert);
end;

function CkPem_Clear (objHandle: HCkPem): wordbool;
begin
  result := TCkPem_Clear(_map(39, 'CkPem_Clear'))
    (objHandle);
end;

function CkPem_GetCert (objHandle: HCkPem; index: Integer): HCkCert;
begin
  result := TCkPem_GetCert(_map(40, 'CkPem_GetCert'))
    (objHandle, index);
end;

function CkPem_GetEncodedItem (objHandle: HCkPem; itemType: PWideChar; itemSubType: PWideChar; encoding: PWideChar; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkPem_GetEncodedItem(_map(41, 'CkPem_GetEncodedItem'))
    (objHandle, itemType, itemSubType, encoding, index, outStr);
end;

function CkPem__getEncodedItem (objHandle: HCkPem; itemType: PWideChar; itemSubType: PWideChar; encoding: PWideChar; index: Integer): PWideChar;
begin
  result := TCkPem__getEncodedItem(_map(42, 'CkPem__getEncodedItem'))
    (objHandle, itemType, itemSubType, encoding, index);
end;

function CkPem_GetPrivateKey (objHandle: HCkPem; index: Integer): HCkPrivateKey;
begin
  result := TCkPem_GetPrivateKey(_map(43, 'CkPem_GetPrivateKey'))
    (objHandle, index);
end;

function CkPem_GetPublicKey (objHandle: HCkPem; index: Integer): HCkPublicKey;
begin
  result := TCkPem_GetPublicKey(_map(44, 'CkPem_GetPublicKey'))
    (objHandle, index);
end;

function CkPem_LoadP7b (objHandle: HCkPem; p7bData: HCkByteData): wordbool;
begin
  result := TCkPem_LoadP7b(_map(45, 'CkPem_LoadP7b'))
    (objHandle, p7bData);
end;

function CkPem_LoadP7bFile (objHandle: HCkPem; path: PWideChar): wordbool;
begin
  result := TCkPem_LoadP7bFile(_map(46, 'CkPem_LoadP7bFile'))
    (objHandle, path);
end;

function CkPem_LoadPem (objHandle: HCkPem; pemContent: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkPem_LoadPem(_map(47, 'CkPem_LoadPem'))
    (objHandle, pemContent, password);
end;

function CkPem_LoadPemFile (objHandle: HCkPem; path: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkPem_LoadPemFile(_map(48, 'CkPem_LoadPemFile'))
    (objHandle, path, password);
end;

function CkPem_LoadTaskCaller (objHandle: HCkPem; task: HCkTask): wordbool;
begin
  result := TCkPem_LoadTaskCaller(_map(49, 'CkPem_LoadTaskCaller'))
    (objHandle, task);
end;

function CkPem_PrivateKeyAt (objHandle: HCkPem; index: Integer; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkPem_PrivateKeyAt(_map(50, 'CkPem_PrivateKeyAt'))
    (objHandle, index, privKey);
end;

function CkPem_PublicKeyAt (objHandle: HCkPem; index: Integer; pubKey: HCkPublicKey): wordbool;
begin
  result := TCkPem_PublicKeyAt(_map(51, 'CkPem_PublicKeyAt'))
    (objHandle, index, pubKey);
end;

function CkPem_RemoveCert (objHandle: HCkPem; index: Integer): wordbool;
begin
  result := TCkPem_RemoveCert(_map(52, 'CkPem_RemoveCert'))
    (objHandle, index);
end;

function CkPem_RemovePrivateKey (objHandle: HCkPem; index: Integer): wordbool;
begin
  result := TCkPem_RemovePrivateKey(_map(53, 'CkPem_RemovePrivateKey'))
    (objHandle, index);
end;

function CkPem_ToJks (objHandle: HCkPem; alias: PWideChar; password: PWideChar): HCkJavaKeyStore;
begin
  result := TCkPem_ToJks(_map(54, 'CkPem_ToJks'))
    (objHandle, alias, password);
end;

function CkPem_ToJksObj (objHandle: HCkPem; alias: PWideChar; password: PWideChar; jksObj: HCkJavaKeyStore): wordbool;
begin
  result := TCkPem_ToJksObj(_map(55, 'CkPem_ToJksObj'))
    (objHandle, alias, password, jksObj);
end;

function CkPem_ToPem (objHandle: HCkPem; outStr: HCkString): wordbool;
begin
  result := TCkPem_ToPem(_map(56, 'CkPem_ToPem'))
    (objHandle, outStr);
end;

function CkPem__toPem (objHandle: HCkPem): PWideChar;
begin
  result := TCkPem__toPem(_map(57, 'CkPem__toPem'))
    (objHandle);
end;

function CkPem_ToPemEx (objHandle: HCkPem; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPem_ToPemEx(_map(58, 'CkPem_ToPemEx'))
    (objHandle, extendedAttrs, noKeys, noCerts, noCaCerts, encryptAlg, password, outStr);
end;

function CkPem__toPemEx (objHandle: HCkPem; extendedAttrs: wordbool; noKeys: wordbool; noCerts: wordbool; noCaCerts: wordbool; encryptAlg: PWideChar; password: PWideChar): PWideChar;
begin
  result := TCkPem__toPemEx(_map(59, 'CkPem__toPemEx'))
    (objHandle, extendedAttrs, noKeys, noCerts, noCaCerts, encryptAlg, password);
end;

function CkPem_ToPfx (objHandle: HCkPem): HCkPfx;
begin
  result := TCkPem_ToPfx(_map(60, 'CkPem_ToPfx'))
    (objHandle);
end;

function CkPem_ToPfxObj (objHandle: HCkPem; pfxObj: HCkPfx): wordbool;
begin
  result := TCkPem_ToPfxObj(_map(61, 'CkPem_ToPfxObj'))
    (objHandle, pfxObj);
end;

end.
