unit Pkcs11;

interface

type

HCkPublicKey = Pointer;
HCkJsonObject = Pointer;
HCkPkcs11 = Pointer;
HCkPrivateKey = Pointer;
HCkSshKey = Pointer;
HCkString = Pointer;
HCkCert = Pointer;


function CkPkcs11_Create: HCkPkcs11;  stdcall;
procedure CkPkcs11_Dispose(handle: HCkPkcs11); stdcall;
procedure CkPkcs11_getDebugLogFilePath(objHandle: HCkPkcs11; outPropVal: HCkString);
procedure CkPkcs11_putDebugLogFilePath(objHandle: HCkPkcs11; newPropVal: PWideChar);
function CkPkcs11__debugLogFilePath(objHandle: HCkPkcs11): PWideChar;
procedure CkPkcs11_getLastErrorHtml(objHandle: HCkPkcs11; outPropVal: HCkString);
function CkPkcs11__lastErrorHtml(objHandle: HCkPkcs11): PWideChar;
procedure CkPkcs11_getLastErrorText(objHandle: HCkPkcs11; outPropVal: HCkString);
function CkPkcs11__lastErrorText(objHandle: HCkPkcs11): PWideChar;
procedure CkPkcs11_getLastErrorXml(objHandle: HCkPkcs11; outPropVal: HCkString);
function CkPkcs11__lastErrorXml(objHandle: HCkPkcs11): PWideChar;
function CkPkcs11_getLastMethodSuccess(objHandle: HCkPkcs11): wordbool;
procedure CkPkcs11_putLastMethodSuccess(objHandle: HCkPkcs11; newPropVal: wordbool);
function CkPkcs11_getNumCerts(objHandle: HCkPkcs11): Integer;
procedure CkPkcs11_getSharedLibPath(objHandle: HCkPkcs11; outPropVal: HCkString);
procedure CkPkcs11_putSharedLibPath(objHandle: HCkPkcs11; newPropVal: PWideChar);
function CkPkcs11__sharedLibPath(objHandle: HCkPkcs11): PWideChar;
procedure CkPkcs11_getSigContextPin(objHandle: HCkPkcs11; outPropVal: HCkString);
procedure CkPkcs11_putSigContextPin(objHandle: HCkPkcs11; newPropVal: PWideChar);
function CkPkcs11__sigContextPin(objHandle: HCkPkcs11): PWideChar;
procedure CkPkcs11_getUncommonOptions(objHandle: HCkPkcs11; outPropVal: HCkString);
procedure CkPkcs11_putUncommonOptions(objHandle: HCkPkcs11; newPropVal: PWideChar);
function CkPkcs11__uncommonOptions(objHandle: HCkPkcs11): PWideChar;
function CkPkcs11_getVerboseLogging(objHandle: HCkPkcs11): wordbool;
procedure CkPkcs11_putVerboseLogging(objHandle: HCkPkcs11; newPropVal: wordbool);
procedure CkPkcs11_getVersion(objHandle: HCkPkcs11; outPropVal: HCkString);
function CkPkcs11__version(objHandle: HCkPkcs11): PWideChar;
function CkPkcs11_CloseSession(objHandle: HCkPkcs11): wordbool;
function CkPkcs11_CreatePkcs11Object(objHandle: HCkPkcs11; attrs: HCkJsonObject): LongWord;
function CkPkcs11_DestroyObject(objHandle: HCkPkcs11; hObject: LongWord): wordbool;
function CkPkcs11_Discover(objHandle: HCkPkcs11; onlyTokensPresent: wordbool; json: HCkJsonObject): wordbool;
function CkPkcs11_ExportPublicKey(objHandle: HCkPkcs11; keyHandle: LongWord; pubKey: HCkPublicKey): wordbool;
function CkPkcs11_FindAllCerts(objHandle: HCkPkcs11): wordbool;
function CkPkcs11_FindAllKeys(objHandle: HCkPkcs11; keyClass: PWideChar; json: HCkJsonObject): wordbool;
function CkPkcs11_FindCert(objHandle: HCkPkcs11; certPart: PWideChar; partValue: PWideChar; cert: HCkCert): wordbool;
function CkPkcs11_FindObject(objHandle: HCkPkcs11; jsonTemplate: HCkJsonObject): LongWord;
function CkPkcs11_GenEcKey(objHandle: HCkPkcs11; publicAttrs: HCkJsonObject; privateAttrs: HCkJsonObject; jsonOut: HCkJsonObject; pubKey: HCkPublicKey): wordbool;
function CkPkcs11_GenRsaKey(objHandle: HCkPkcs11; publicAttrs: HCkJsonObject; privateAttrs: HCkJsonObject; jsonOut: HCkJsonObject; pubKey: HCkPublicKey): wordbool;
function CkPkcs11_GenSecretKey(objHandle: HCkPkcs11; keyType: PWideChar; jsonTemplate: HCkJsonObject): LongWord;
function CkPkcs11_GetCert(objHandle: HCkPkcs11; index: Integer; cert: HCkCert): wordbool;
function CkPkcs11_ImportPrivateKey(objHandle: HCkPkcs11; privKey: HCkPrivateKey; jsonTemplate: HCkJsonObject): LongWord;
function CkPkcs11_ImportSshKey(objHandle: HCkPkcs11; sshKey: HCkSshKey; jsonTemplate: HCkJsonObject): LongWord;
function CkPkcs11_Initialize(objHandle: HCkPkcs11): wordbool;
function CkPkcs11_InitPin(objHandle: HCkPkcs11; pin: PWideChar): wordbool;
function CkPkcs11_InitToken(objHandle: HCkPkcs11; slotId: Integer; pin: PWideChar; tokenLabel: PWideChar): wordbool;
function CkPkcs11_Login(objHandle: HCkPkcs11; userType: Integer; pin: PWideChar): wordbool;
function CkPkcs11_Logout(objHandle: HCkPkcs11): wordbool;
function CkPkcs11_OpenSession(objHandle: HCkPkcs11; slotId: Integer; readWrite: wordbool): wordbool;
function CkPkcs11_QuickSession(objHandle: HCkPkcs11; userType: Integer; pin: PWideChar): wordbool;
function CkPkcs11_SetPin(objHandle: HCkPkcs11; oldPin: PWideChar; newPin: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkPkcs11_Create = function : HCkPkcs11; stdcall;
  TCkPkcs11_Dispose = procedure (handle: HCkPkcs11); stdcall;
  TCkPkcs11_getDebugLogFilePath = procedure (objHandle: HCkPkcs11; outPropVal: HCkString); stdcall;
  TCkPkcs11_putDebugLogFilePath = procedure (objHandle: HCkPkcs11; newPropVal: PWideChar); stdcall;
  TCkPkcs11__debugLogFilePath = function (objHandle: HCkPkcs11): PWideChar; stdcall;
  TCkPkcs11_getLastErrorHtml = procedure (objHandle: HCkPkcs11; outPropVal: HCkString); stdcall;
  TCkPkcs11__lastErrorHtml = function (objHandle: HCkPkcs11): PWideChar; stdcall;
  TCkPkcs11_getLastErrorText = procedure (objHandle: HCkPkcs11; outPropVal: HCkString); stdcall;
  TCkPkcs11__lastErrorText = function (objHandle: HCkPkcs11): PWideChar; stdcall;
  TCkPkcs11_getLastErrorXml = procedure (objHandle: HCkPkcs11; outPropVal: HCkString); stdcall;
  TCkPkcs11__lastErrorXml = function (objHandle: HCkPkcs11): PWideChar; stdcall;
  TCkPkcs11_getLastMethodSuccess = function (objHandle: HCkPkcs11): wordbool; stdcall;
  TCkPkcs11_putLastMethodSuccess = procedure (objHandle: HCkPkcs11; newPropVal: wordbool); stdcall;
  TCkPkcs11_getNumCerts = function (objHandle: HCkPkcs11): Integer; stdcall;
  TCkPkcs11_getSharedLibPath = procedure (objHandle: HCkPkcs11; outPropVal: HCkString); stdcall;
  TCkPkcs11_putSharedLibPath = procedure (objHandle: HCkPkcs11; newPropVal: PWideChar); stdcall;
  TCkPkcs11__sharedLibPath = function (objHandle: HCkPkcs11): PWideChar; stdcall;
  TCkPkcs11_getSigContextPin = procedure (objHandle: HCkPkcs11; outPropVal: HCkString); stdcall;
  TCkPkcs11_putSigContextPin = procedure (objHandle: HCkPkcs11; newPropVal: PWideChar); stdcall;
  TCkPkcs11__sigContextPin = function (objHandle: HCkPkcs11): PWideChar; stdcall;
  TCkPkcs11_getUncommonOptions = procedure (objHandle: HCkPkcs11; outPropVal: HCkString); stdcall;
  TCkPkcs11_putUncommonOptions = procedure (objHandle: HCkPkcs11; newPropVal: PWideChar); stdcall;
  TCkPkcs11__uncommonOptions = function (objHandle: HCkPkcs11): PWideChar; stdcall;
  TCkPkcs11_getVerboseLogging = function (objHandle: HCkPkcs11): wordbool; stdcall;
  TCkPkcs11_putVerboseLogging = procedure (objHandle: HCkPkcs11; newPropVal: wordbool); stdcall;
  TCkPkcs11_getVersion = procedure (objHandle: HCkPkcs11; outPropVal: HCkString); stdcall;
  TCkPkcs11__version = function (objHandle: HCkPkcs11): PWideChar; stdcall;
  TCkPkcs11_CloseSession = function (objHandle: HCkPkcs11): wordbool; stdcall;
  TCkPkcs11_CreatePkcs11Object = function (objHandle: HCkPkcs11; attrs: HCkJsonObject): LongWord; stdcall;
  TCkPkcs11_DestroyObject = function (objHandle: HCkPkcs11; hObject: LongWord): wordbool; stdcall;
  TCkPkcs11_Discover = function (objHandle: HCkPkcs11; onlyTokensPresent: wordbool; json: HCkJsonObject): wordbool; stdcall;
  TCkPkcs11_ExportPublicKey = function (objHandle: HCkPkcs11; keyHandle: LongWord; pubKey: HCkPublicKey): wordbool; stdcall;
  TCkPkcs11_FindAllCerts = function (objHandle: HCkPkcs11): wordbool; stdcall;
  TCkPkcs11_FindAllKeys = function (objHandle: HCkPkcs11; keyClass: PWideChar; json: HCkJsonObject): wordbool; stdcall;
  TCkPkcs11_FindCert = function (objHandle: HCkPkcs11; certPart: PWideChar; partValue: PWideChar; cert: HCkCert): wordbool; stdcall;
  TCkPkcs11_FindObject = function (objHandle: HCkPkcs11; jsonTemplate: HCkJsonObject): LongWord; stdcall;
  TCkPkcs11_GenEcKey = function (objHandle: HCkPkcs11; publicAttrs: HCkJsonObject; privateAttrs: HCkJsonObject; jsonOut: HCkJsonObject; pubKey: HCkPublicKey): wordbool; stdcall;
  TCkPkcs11_GenRsaKey = function (objHandle: HCkPkcs11; publicAttrs: HCkJsonObject; privateAttrs: HCkJsonObject; jsonOut: HCkJsonObject; pubKey: HCkPublicKey): wordbool; stdcall;
  TCkPkcs11_GenSecretKey = function (objHandle: HCkPkcs11; keyType: PWideChar; jsonTemplate: HCkJsonObject): LongWord; stdcall;
  TCkPkcs11_GetCert = function (objHandle: HCkPkcs11; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkPkcs11_ImportPrivateKey = function (objHandle: HCkPkcs11; privKey: HCkPrivateKey; jsonTemplate: HCkJsonObject): LongWord; stdcall;
  TCkPkcs11_ImportSshKey = function (objHandle: HCkPkcs11; sshKey: HCkSshKey; jsonTemplate: HCkJsonObject): LongWord; stdcall;
  TCkPkcs11_Initialize = function (objHandle: HCkPkcs11): wordbool; stdcall;
  TCkPkcs11_InitPin = function (objHandle: HCkPkcs11; pin: PWideChar): wordbool; stdcall;
  TCkPkcs11_InitToken = function (objHandle: HCkPkcs11; slotId: Integer; pin: PWideChar; tokenLabel: PWideChar): wordbool; stdcall;
  TCkPkcs11_Login = function (objHandle: HCkPkcs11; userType: Integer; pin: PWideChar): wordbool; stdcall;
  TCkPkcs11_Logout = function (objHandle: HCkPkcs11): wordbool; stdcall;
  TCkPkcs11_OpenSession = function (objHandle: HCkPkcs11; slotId: Integer; readWrite: wordbool): wordbool; stdcall;
  TCkPkcs11_QuickSession = function (objHandle: HCkPkcs11; userType: Integer; pin: PWideChar): wordbool; stdcall;
  TCkPkcs11_SetPin = function (objHandle: HCkPkcs11; oldPin: PWideChar; newPin: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..49] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkPkcs11_Create : HCkPkcs11;
begin
  result := TCkPkcs11_Create(_map(0, 'CkPkcs11_Create'));
end;

procedure CkPkcs11_Dispose (handle: HCkPkcs11);
begin
  TCkPkcs11_Dispose(_map(1, 'CkPkcs11_Dispose'))
    (handle);
end;


procedure CkPkcs11_getDebugLogFilePath (objHandle: HCkPkcs11; outPropVal: HCkString);
begin
  TCkPkcs11_getDebugLogFilePath(_map(2, 'CkPkcs11_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkPkcs11_putDebugLogFilePath (objHandle: HCkPkcs11; newPropVal: PWideChar);
begin
  TCkPkcs11_putDebugLogFilePath(_map(3, 'CkPkcs11_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkPkcs11__debugLogFilePath (objHandle: HCkPkcs11): PWideChar;
begin
  result := TCkPkcs11__debugLogFilePath(_map(4, 'CkPkcs11__debugLogFilePath'))
    (objHandle);
end;

procedure CkPkcs11_getLastErrorHtml (objHandle: HCkPkcs11; outPropVal: HCkString);
begin
  TCkPkcs11_getLastErrorHtml(_map(5, 'CkPkcs11_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkPkcs11__lastErrorHtml (objHandle: HCkPkcs11): PWideChar;
begin
  result := TCkPkcs11__lastErrorHtml(_map(6, 'CkPkcs11__lastErrorHtml'))
    (objHandle);
end;

procedure CkPkcs11_getLastErrorText (objHandle: HCkPkcs11; outPropVal: HCkString);
begin
  TCkPkcs11_getLastErrorText(_map(7, 'CkPkcs11_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkPkcs11__lastErrorText (objHandle: HCkPkcs11): PWideChar;
begin
  result := TCkPkcs11__lastErrorText(_map(8, 'CkPkcs11__lastErrorText'))
    (objHandle);
end;

procedure CkPkcs11_getLastErrorXml (objHandle: HCkPkcs11; outPropVal: HCkString);
begin
  TCkPkcs11_getLastErrorXml(_map(9, 'CkPkcs11_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkPkcs11__lastErrorXml (objHandle: HCkPkcs11): PWideChar;
begin
  result := TCkPkcs11__lastErrorXml(_map(10, 'CkPkcs11__lastErrorXml'))
    (objHandle);
end;

function CkPkcs11_getLastMethodSuccess (objHandle: HCkPkcs11): wordbool;
begin
    result := TCkPkcs11_getLastMethodSuccess(_map(11, 'CkPkcs11_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkPkcs11_putLastMethodSuccess (objHandle: HCkPkcs11; newPropVal: wordbool);
begin
  TCkPkcs11_putLastMethodSuccess(_map(12, 'CkPkcs11_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkPkcs11_getNumCerts (objHandle: HCkPkcs11): Integer;
begin
    result := TCkPkcs11_getNumCerts(_map(13, 'CkPkcs11_getNumCerts'))
    (objHandle);
end;

procedure CkPkcs11_getSharedLibPath (objHandle: HCkPkcs11; outPropVal: HCkString);
begin
  TCkPkcs11_getSharedLibPath(_map(14, 'CkPkcs11_getSharedLibPath'))
    (objHandle, outPropVal);
end;

procedure CkPkcs11_putSharedLibPath (objHandle: HCkPkcs11; newPropVal: PWideChar);
begin
  TCkPkcs11_putSharedLibPath(_map(15, 'CkPkcs11_putSharedLibPath'))
    (objHandle, newPropVal);
end;

function CkPkcs11__sharedLibPath (objHandle: HCkPkcs11): PWideChar;
begin
  result := TCkPkcs11__sharedLibPath(_map(16, 'CkPkcs11__sharedLibPath'))
    (objHandle);
end;

procedure CkPkcs11_getSigContextPin (objHandle: HCkPkcs11; outPropVal: HCkString);
begin
  TCkPkcs11_getSigContextPin(_map(17, 'CkPkcs11_getSigContextPin'))
    (objHandle, outPropVal);
end;

procedure CkPkcs11_putSigContextPin (objHandle: HCkPkcs11; newPropVal: PWideChar);
begin
  TCkPkcs11_putSigContextPin(_map(18, 'CkPkcs11_putSigContextPin'))
    (objHandle, newPropVal);
end;

function CkPkcs11__sigContextPin (objHandle: HCkPkcs11): PWideChar;
begin
  result := TCkPkcs11__sigContextPin(_map(19, 'CkPkcs11__sigContextPin'))
    (objHandle);
end;

procedure CkPkcs11_getUncommonOptions (objHandle: HCkPkcs11; outPropVal: HCkString);
begin
  TCkPkcs11_getUncommonOptions(_map(20, 'CkPkcs11_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkPkcs11_putUncommonOptions (objHandle: HCkPkcs11; newPropVal: PWideChar);
begin
  TCkPkcs11_putUncommonOptions(_map(21, 'CkPkcs11_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkPkcs11__uncommonOptions (objHandle: HCkPkcs11): PWideChar;
begin
  result := TCkPkcs11__uncommonOptions(_map(22, 'CkPkcs11__uncommonOptions'))
    (objHandle);
end;

function CkPkcs11_getVerboseLogging (objHandle: HCkPkcs11): wordbool;
begin
    result := TCkPkcs11_getVerboseLogging(_map(23, 'CkPkcs11_getVerboseLogging'))
    (objHandle);
end;

procedure CkPkcs11_putVerboseLogging (objHandle: HCkPkcs11; newPropVal: wordbool);
begin
  TCkPkcs11_putVerboseLogging(_map(24, 'CkPkcs11_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkPkcs11_getVersion (objHandle: HCkPkcs11; outPropVal: HCkString);
begin
  TCkPkcs11_getVersion(_map(25, 'CkPkcs11_getVersion'))
    (objHandle, outPropVal);
end;

function CkPkcs11__version (objHandle: HCkPkcs11): PWideChar;
begin
  result := TCkPkcs11__version(_map(26, 'CkPkcs11__version'))
    (objHandle);
end;

function CkPkcs11_CloseSession (objHandle: HCkPkcs11): wordbool;
begin
  result := TCkPkcs11_CloseSession(_map(27, 'CkPkcs11_CloseSession'))
    (objHandle);
end;

function CkPkcs11_CreatePkcs11Object (objHandle: HCkPkcs11; attrs: HCkJsonObject): LongWord;
begin
  result := TCkPkcs11_CreatePkcs11Object(_map(28, 'CkPkcs11_CreatePkcs11Object'))
    (objHandle, attrs);
end;

function CkPkcs11_DestroyObject (objHandle: HCkPkcs11; hObject: LongWord): wordbool;
begin
  result := TCkPkcs11_DestroyObject(_map(29, 'CkPkcs11_DestroyObject'))
    (objHandle, hObject);
end;

function CkPkcs11_Discover (objHandle: HCkPkcs11; onlyTokensPresent: wordbool; json: HCkJsonObject): wordbool;
begin
  result := TCkPkcs11_Discover(_map(30, 'CkPkcs11_Discover'))
    (objHandle, onlyTokensPresent, json);
end;

function CkPkcs11_ExportPublicKey (objHandle: HCkPkcs11; keyHandle: LongWord; pubKey: HCkPublicKey): wordbool;
begin
  result := TCkPkcs11_ExportPublicKey(_map(31, 'CkPkcs11_ExportPublicKey'))
    (objHandle, keyHandle, pubKey);
end;

function CkPkcs11_FindAllCerts (objHandle: HCkPkcs11): wordbool;
begin
  result := TCkPkcs11_FindAllCerts(_map(32, 'CkPkcs11_FindAllCerts'))
    (objHandle);
end;

function CkPkcs11_FindAllKeys (objHandle: HCkPkcs11; keyClass: PWideChar; json: HCkJsonObject): wordbool;
begin
  result := TCkPkcs11_FindAllKeys(_map(33, 'CkPkcs11_FindAllKeys'))
    (objHandle, keyClass, json);
end;

function CkPkcs11_FindCert (objHandle: HCkPkcs11; certPart: PWideChar; partValue: PWideChar; cert: HCkCert): wordbool;
begin
  result := TCkPkcs11_FindCert(_map(34, 'CkPkcs11_FindCert'))
    (objHandle, certPart, partValue, cert);
end;

function CkPkcs11_FindObject (objHandle: HCkPkcs11; jsonTemplate: HCkJsonObject): LongWord;
begin
  result := TCkPkcs11_FindObject(_map(35, 'CkPkcs11_FindObject'))
    (objHandle, jsonTemplate);
end;

function CkPkcs11_GenEcKey (objHandle: HCkPkcs11; publicAttrs: HCkJsonObject; privateAttrs: HCkJsonObject; jsonOut: HCkJsonObject; pubKey: HCkPublicKey): wordbool;
begin
  result := TCkPkcs11_GenEcKey(_map(36, 'CkPkcs11_GenEcKey'))
    (objHandle, publicAttrs, privateAttrs, jsonOut, pubKey);
end;

function CkPkcs11_GenRsaKey (objHandle: HCkPkcs11; publicAttrs: HCkJsonObject; privateAttrs: HCkJsonObject; jsonOut: HCkJsonObject; pubKey: HCkPublicKey): wordbool;
begin
  result := TCkPkcs11_GenRsaKey(_map(37, 'CkPkcs11_GenRsaKey'))
    (objHandle, publicAttrs, privateAttrs, jsonOut, pubKey);
end;

function CkPkcs11_GenSecretKey (objHandle: HCkPkcs11; keyType: PWideChar; jsonTemplate: HCkJsonObject): LongWord;
begin
  result := TCkPkcs11_GenSecretKey(_map(38, 'CkPkcs11_GenSecretKey'))
    (objHandle, keyType, jsonTemplate);
end;

function CkPkcs11_GetCert (objHandle: HCkPkcs11; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkPkcs11_GetCert(_map(39, 'CkPkcs11_GetCert'))
    (objHandle, index, cert);
end;

function CkPkcs11_ImportPrivateKey (objHandle: HCkPkcs11; privKey: HCkPrivateKey; jsonTemplate: HCkJsonObject): LongWord;
begin
  result := TCkPkcs11_ImportPrivateKey(_map(40, 'CkPkcs11_ImportPrivateKey'))
    (objHandle, privKey, jsonTemplate);
end;

function CkPkcs11_ImportSshKey (objHandle: HCkPkcs11; sshKey: HCkSshKey; jsonTemplate: HCkJsonObject): LongWord;
begin
  result := TCkPkcs11_ImportSshKey(_map(41, 'CkPkcs11_ImportSshKey'))
    (objHandle, sshKey, jsonTemplate);
end;

function CkPkcs11_Initialize (objHandle: HCkPkcs11): wordbool;
begin
  result := TCkPkcs11_Initialize(_map(42, 'CkPkcs11_Initialize'))
    (objHandle);
end;

function CkPkcs11_InitPin (objHandle: HCkPkcs11; pin: PWideChar): wordbool;
begin
  result := TCkPkcs11_InitPin(_map(43, 'CkPkcs11_InitPin'))
    (objHandle, pin);
end;

function CkPkcs11_InitToken (objHandle: HCkPkcs11; slotId: Integer; pin: PWideChar; tokenLabel: PWideChar): wordbool;
begin
  result := TCkPkcs11_InitToken(_map(44, 'CkPkcs11_InitToken'))
    (objHandle, slotId, pin, tokenLabel);
end;

function CkPkcs11_Login (objHandle: HCkPkcs11; userType: Integer; pin: PWideChar): wordbool;
begin
  result := TCkPkcs11_Login(_map(45, 'CkPkcs11_Login'))
    (objHandle, userType, pin);
end;

function CkPkcs11_Logout (objHandle: HCkPkcs11): wordbool;
begin
  result := TCkPkcs11_Logout(_map(46, 'CkPkcs11_Logout'))
    (objHandle);
end;

function CkPkcs11_OpenSession (objHandle: HCkPkcs11; slotId: Integer; readWrite: wordbool): wordbool;
begin
  result := TCkPkcs11_OpenSession(_map(47, 'CkPkcs11_OpenSession'))
    (objHandle, slotId, readWrite);
end;

function CkPkcs11_QuickSession (objHandle: HCkPkcs11; userType: Integer; pin: PWideChar): wordbool;
begin
  result := TCkPkcs11_QuickSession(_map(48, 'CkPkcs11_QuickSession'))
    (objHandle, userType, pin);
end;

function CkPkcs11_SetPin (objHandle: HCkPkcs11; oldPin: PWideChar; newPin: PWideChar): wordbool;
begin
  result := TCkPkcs11_SetPin(_map(49, 'CkPkcs11_SetPin'))
    (objHandle, oldPin, newPin);
end;

end.
