unit PrivateKey;

interface

type

HCkPublicKey = Pointer;
HCkBinData = Pointer;
HCkPrivateKey = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;
HCkTask = Pointer;
HCkJsonObject = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TPrivateKeyAbortCheck = function(): Integer; cdecl;
TPrivateKeyProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TPrivateKeyPercentDone = function(pctDone: Integer): Integer; cdecl;
TPrivateKeyTaskCompleted = procedure(task: HCkTask); cdecl;


function CkPrivateKey_Create: HCkPrivateKey;  stdcall;
procedure CkPrivateKey_Dispose(handle: HCkPrivateKey); stdcall;

procedure CkPrivateKey_SetAbortCheck(objHandle: HCkPrivateKey; fn: TPrivateKeyAbortCheck) stdcall;
procedure CkPrivateKey_SetProgressInfo(objHandle: HCkPrivateKey; fn: TPrivateKeyProgressInfo) stdcall;
procedure CkPrivateKey_SetPercentDone(objHandle: HCkPrivateKey; fn: TPrivateKeyPercentDone) stdcall;
procedure CkPrivateKey_SetTaskCompleted(objHandle: HCkPrivateKey; fn: TPrivateKeyTaskCompleted) stdcall;
function CkPrivateKey_getBitLength(objHandle: HCkPrivateKey): Integer;
procedure CkPrivateKey_getDebugLogFilePath(objHandle: HCkPrivateKey; outPropVal: HCkString);
procedure CkPrivateKey_putDebugLogFilePath(objHandle: HCkPrivateKey; newPropVal: PWideChar);
function CkPrivateKey__debugLogFilePath(objHandle: HCkPrivateKey): PWideChar;
procedure CkPrivateKey_getKeyType(objHandle: HCkPrivateKey; outPropVal: HCkString);
function CkPrivateKey__keyType(objHandle: HCkPrivateKey): PWideChar;
procedure CkPrivateKey_getLastErrorHtml(objHandle: HCkPrivateKey; outPropVal: HCkString);
function CkPrivateKey__lastErrorHtml(objHandle: HCkPrivateKey): PWideChar;
procedure CkPrivateKey_getLastErrorText(objHandle: HCkPrivateKey; outPropVal: HCkString);
function CkPrivateKey__lastErrorText(objHandle: HCkPrivateKey): PWideChar;
procedure CkPrivateKey_getLastErrorXml(objHandle: HCkPrivateKey; outPropVal: HCkString);
function CkPrivateKey__lastErrorXml(objHandle: HCkPrivateKey): PWideChar;
function CkPrivateKey_getLastMethodSuccess(objHandle: HCkPrivateKey): wordbool;
procedure CkPrivateKey_putLastMethodSuccess(objHandle: HCkPrivateKey; newPropVal: wordbool);
procedure CkPrivateKey_getPkcs8EncryptAlg(objHandle: HCkPrivateKey; outPropVal: HCkString);
procedure CkPrivateKey_putPkcs8EncryptAlg(objHandle: HCkPrivateKey; newPropVal: PWideChar);
function CkPrivateKey__pkcs8EncryptAlg(objHandle: HCkPrivateKey): PWideChar;
procedure CkPrivateKey_getUncommonOptions(objHandle: HCkPrivateKey; outPropVal: HCkString);
procedure CkPrivateKey_putUncommonOptions(objHandle: HCkPrivateKey; newPropVal: PWideChar);
function CkPrivateKey__uncommonOptions(objHandle: HCkPrivateKey): PWideChar;
function CkPrivateKey_getVerboseLogging(objHandle: HCkPrivateKey): wordbool;
procedure CkPrivateKey_putVerboseLogging(objHandle: HCkPrivateKey; newPropVal: wordbool);
procedure CkPrivateKey_getVersion(objHandle: HCkPrivateKey; outPropVal: HCkString);
function CkPrivateKey__version(objHandle: HCkPrivateKey): PWideChar;
function CkPrivateKey_GetJwk(objHandle: HCkPrivateKey; outStr: HCkString): wordbool;
function CkPrivateKey__getJwk(objHandle: HCkPrivateKey): PWideChar;
function CkPrivateKey_GetJwkThumbprint(objHandle: HCkPrivateKey; hashAlg: PWideChar; outStr: HCkString): wordbool;
function CkPrivateKey__getJwkThumbprint(objHandle: HCkPrivateKey; hashAlg: PWideChar): PWideChar;
function CkPrivateKey_GetPkcs1(objHandle: HCkPrivateKey; outData: HCkByteData): wordbool;
function CkPrivateKey_GetPkcs1ENC(objHandle: HCkPrivateKey; encoding: PWideChar; outStr: HCkString): wordbool;
function CkPrivateKey__getPkcs1ENC(objHandle: HCkPrivateKey; encoding: PWideChar): PWideChar;
function CkPrivateKey_GetPkcs1Pem(objHandle: HCkPrivateKey; outStr: HCkString): wordbool;
function CkPrivateKey__getPkcs1Pem(objHandle: HCkPrivateKey): PWideChar;
function CkPrivateKey_GetPkcs8(objHandle: HCkPrivateKey; outData: HCkByteData): wordbool;
function CkPrivateKey_GetPkcs8ENC(objHandle: HCkPrivateKey; encoding: PWideChar; outStr: HCkString): wordbool;
function CkPrivateKey__getPkcs8ENC(objHandle: HCkPrivateKey; encoding: PWideChar): PWideChar;
function CkPrivateKey_GetPkcs8Encrypted(objHandle: HCkPrivateKey; password: PWideChar; outData: HCkByteData): wordbool;
function CkPrivateKey_GetPkcs8EncryptedENC(objHandle: HCkPrivateKey; encoding: PWideChar; password: PWideChar; outStr: HCkString): wordbool;
function CkPrivateKey__getPkcs8EncryptedENC(objHandle: HCkPrivateKey; encoding: PWideChar; password: PWideChar): PWideChar;
function CkPrivateKey_GetPkcs8EncryptedPem(objHandle: HCkPrivateKey; password: PWideChar; outStr: HCkString): wordbool;
function CkPrivateKey__getPkcs8EncryptedPem(objHandle: HCkPrivateKey; password: PWideChar): PWideChar;
function CkPrivateKey_GetPkcs8Pem(objHandle: HCkPrivateKey; outStr: HCkString): wordbool;
function CkPrivateKey__getPkcs8Pem(objHandle: HCkPrivateKey): PWideChar;
function CkPrivateKey_GetPkcsBd(objHandle: HCkPrivateKey; pkcs1: wordbool; password: PWideChar; bd: HCkBinData): wordbool;
function CkPrivateKey_GetPublicKey(objHandle: HCkPrivateKey): HCkPublicKey;
function CkPrivateKey_GetRawHex(objHandle: HCkPrivateKey; pubKey: HCkStringBuilder; outStr: HCkString): wordbool;
function CkPrivateKey__getRawHex(objHandle: HCkPrivateKey; pubKey: HCkStringBuilder): PWideChar;
function CkPrivateKey_GetXml(objHandle: HCkPrivateKey; outStr: HCkString): wordbool;
function CkPrivateKey__getXml(objHandle: HCkPrivateKey): PWideChar;
function CkPrivateKey_LoadAnyFormat(objHandle: HCkPrivateKey; privKeyData: HCkBinData; password: PWideChar): wordbool;
function CkPrivateKey_LoadAnyFormatFile(objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool;
function CkPrivateKey_LoadEd25519(objHandle: HCkPrivateKey; privKey: PWideChar; pubKey: PWideChar): wordbool;
function CkPrivateKey_LoadEncryptedPem(objHandle: HCkPrivateKey; pemStr: PWideChar; password: PWideChar): wordbool;
function CkPrivateKey_LoadEncryptedPemFile(objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool;
function CkPrivateKey_LoadJwk(objHandle: HCkPrivateKey; jsonStr: PWideChar): wordbool;
function CkPrivateKey_LoadPem(objHandle: HCkPrivateKey; str: PWideChar): wordbool;
function CkPrivateKey_LoadPemFile(objHandle: HCkPrivateKey; path: PWideChar): wordbool;
function CkPrivateKey_LoadPkcs1(objHandle: HCkPrivateKey; data: HCkByteData): wordbool;
function CkPrivateKey_LoadPkcs1File(objHandle: HCkPrivateKey; path: PWideChar): wordbool;
function CkPrivateKey_LoadPkcs8(objHandle: HCkPrivateKey; data: HCkByteData): wordbool;
function CkPrivateKey_LoadPkcs8Encrypted(objHandle: HCkPrivateKey; data: HCkByteData; password: PWideChar): wordbool;
function CkPrivateKey_LoadPkcs8EncryptedFile(objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool;
function CkPrivateKey_LoadPkcs8File(objHandle: HCkPrivateKey; path: PWideChar): wordbool;
function CkPrivateKey_LoadPvk(objHandle: HCkPrivateKey; data: HCkByteData; password: PWideChar): wordbool;
function CkPrivateKey_LoadPvkFile(objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool;
function CkPrivateKey_LoadXml(objHandle: HCkPrivateKey; xml: PWideChar): wordbool;
function CkPrivateKey_LoadXmlFile(objHandle: HCkPrivateKey; path: PWideChar): wordbool;
function CkPrivateKey_SavePemFile(objHandle: HCkPrivateKey; path: PWideChar): wordbool;
function CkPrivateKey_SavePkcs1File(objHandle: HCkPrivateKey; path: PWideChar): wordbool;
function CkPrivateKey_SavePkcs8EncryptedFile(objHandle: HCkPrivateKey; password: PWideChar; path: PWideChar): wordbool;
function CkPrivateKey_SavePkcs8EncryptedPemFile(objHandle: HCkPrivateKey; password: PWideChar; path: PWideChar): wordbool;
function CkPrivateKey_SavePkcs8File(objHandle: HCkPrivateKey; path: PWideChar): wordbool;
function CkPrivateKey_SavePkcs8PemFile(objHandle: HCkPrivateKey; path: PWideChar): wordbool;
function CkPrivateKey_SaveXmlFile(objHandle: HCkPrivateKey; path: PWideChar): wordbool;
function CkPrivateKey_ToPublicKey(objHandle: HCkPrivateKey; pubKey: HCkPublicKey): wordbool;
function CkPrivateKey_UploadToCloud(objHandle: HCkPrivateKey; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): wordbool;
function CkPrivateKey_UploadToCloudAsync(objHandle: HCkPrivateKey; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkPrivateKey_Create = function : HCkPrivateKey; stdcall;
  TCkPrivateKey_Dispose = procedure (handle: HCkPrivateKey); stdcall;
  TCkPrivateKey_SetAbortCheck = procedure (objHandle: HCkPrivateKey; fn: TPrivateKeyAbortCheck); stdcall;
  TCkPrivateKey_SetProgressInfo = procedure (objHandle: HCkPrivateKey; fn: TPrivateKeyProgressInfo); stdcall;
  TCkPrivateKey_SetPercentDone = procedure (objHandle: HCkPrivateKey; fn: TPrivateKeyPercentDone); stdcall;
  TCkPrivateKey_SetTaskCompleted = procedure (objHandle: HCkPrivateKey; fn: TPrivateKeyTaskCompleted); stdcall;
  TCkPrivateKey_getBitLength = function (objHandle: HCkPrivateKey): Integer; stdcall;
  TCkPrivateKey_getDebugLogFilePath = procedure (objHandle: HCkPrivateKey; outPropVal: HCkString); stdcall;
  TCkPrivateKey_putDebugLogFilePath = procedure (objHandle: HCkPrivateKey; newPropVal: PWideChar); stdcall;
  TCkPrivateKey__debugLogFilePath = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_getKeyType = procedure (objHandle: HCkPrivateKey; outPropVal: HCkString); stdcall;
  TCkPrivateKey__keyType = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_getLastErrorHtml = procedure (objHandle: HCkPrivateKey; outPropVal: HCkString); stdcall;
  TCkPrivateKey__lastErrorHtml = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_getLastErrorText = procedure (objHandle: HCkPrivateKey; outPropVal: HCkString); stdcall;
  TCkPrivateKey__lastErrorText = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_getLastErrorXml = procedure (objHandle: HCkPrivateKey; outPropVal: HCkString); stdcall;
  TCkPrivateKey__lastErrorXml = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_getLastMethodSuccess = function (objHandle: HCkPrivateKey): wordbool; stdcall;
  TCkPrivateKey_putLastMethodSuccess = procedure (objHandle: HCkPrivateKey; newPropVal: wordbool); stdcall;
  TCkPrivateKey_getPkcs8EncryptAlg = procedure (objHandle: HCkPrivateKey; outPropVal: HCkString); stdcall;
  TCkPrivateKey_putPkcs8EncryptAlg = procedure (objHandle: HCkPrivateKey; newPropVal: PWideChar); stdcall;
  TCkPrivateKey__pkcs8EncryptAlg = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_getUncommonOptions = procedure (objHandle: HCkPrivateKey; outPropVal: HCkString); stdcall;
  TCkPrivateKey_putUncommonOptions = procedure (objHandle: HCkPrivateKey; newPropVal: PWideChar); stdcall;
  TCkPrivateKey__uncommonOptions = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_getVerboseLogging = function (objHandle: HCkPrivateKey): wordbool; stdcall;
  TCkPrivateKey_putVerboseLogging = procedure (objHandle: HCkPrivateKey; newPropVal: wordbool); stdcall;
  TCkPrivateKey_getVersion = procedure (objHandle: HCkPrivateKey; outPropVal: HCkString); stdcall;
  TCkPrivateKey__version = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_GetJwk = function (objHandle: HCkPrivateKey; outStr: HCkString): wordbool; stdcall;
  TCkPrivateKey__getJwk = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_GetJwkThumbprint = function (objHandle: HCkPrivateKey; hashAlg: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPrivateKey__getJwkThumbprint = function (objHandle: HCkPrivateKey; hashAlg: PWideChar): PWideChar; stdcall;
  TCkPrivateKey_GetPkcs1 = function (objHandle: HCkPrivateKey; outData: HCkByteData): wordbool; stdcall;
  TCkPrivateKey_GetPkcs1ENC = function (objHandle: HCkPrivateKey; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPrivateKey__getPkcs1ENC = function (objHandle: HCkPrivateKey; encoding: PWideChar): PWideChar; stdcall;
  TCkPrivateKey_GetPkcs1Pem = function (objHandle: HCkPrivateKey; outStr: HCkString): wordbool; stdcall;
  TCkPrivateKey__getPkcs1Pem = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_GetPkcs8 = function (objHandle: HCkPrivateKey; outData: HCkByteData): wordbool; stdcall;
  TCkPrivateKey_GetPkcs8ENC = function (objHandle: HCkPrivateKey; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPrivateKey__getPkcs8ENC = function (objHandle: HCkPrivateKey; encoding: PWideChar): PWideChar; stdcall;
  TCkPrivateKey_GetPkcs8Encrypted = function (objHandle: HCkPrivateKey; password: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkPrivateKey_GetPkcs8EncryptedENC = function (objHandle: HCkPrivateKey; encoding: PWideChar; password: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPrivateKey__getPkcs8EncryptedENC = function (objHandle: HCkPrivateKey; encoding: PWideChar; password: PWideChar): PWideChar; stdcall;
  TCkPrivateKey_GetPkcs8EncryptedPem = function (objHandle: HCkPrivateKey; password: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPrivateKey__getPkcs8EncryptedPem = function (objHandle: HCkPrivateKey; password: PWideChar): PWideChar; stdcall;
  TCkPrivateKey_GetPkcs8Pem = function (objHandle: HCkPrivateKey; outStr: HCkString): wordbool; stdcall;
  TCkPrivateKey__getPkcs8Pem = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_GetPkcsBd = function (objHandle: HCkPrivateKey; pkcs1: wordbool; password: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkPrivateKey_GetPublicKey = function (objHandle: HCkPrivateKey): HCkPublicKey; stdcall;
  TCkPrivateKey_GetRawHex = function (objHandle: HCkPrivateKey; pubKey: HCkStringBuilder; outStr: HCkString): wordbool; stdcall;
  TCkPrivateKey__getRawHex = function (objHandle: HCkPrivateKey; pubKey: HCkStringBuilder): PWideChar; stdcall;
  TCkPrivateKey_GetXml = function (objHandle: HCkPrivateKey; outStr: HCkString): wordbool; stdcall;
  TCkPrivateKey__getXml = function (objHandle: HCkPrivateKey): PWideChar; stdcall;
  TCkPrivateKey_LoadAnyFormat = function (objHandle: HCkPrivateKey; privKeyData: HCkBinData; password: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadAnyFormatFile = function (objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadEd25519 = function (objHandle: HCkPrivateKey; privKey: PWideChar; pubKey: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadEncryptedPem = function (objHandle: HCkPrivateKey; pemStr: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadEncryptedPemFile = function (objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadJwk = function (objHandle: HCkPrivateKey; jsonStr: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadPem = function (objHandle: HCkPrivateKey; str: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadPemFile = function (objHandle: HCkPrivateKey; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadPkcs1 = function (objHandle: HCkPrivateKey; data: HCkByteData): wordbool; stdcall;
  TCkPrivateKey_LoadPkcs1File = function (objHandle: HCkPrivateKey; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadPkcs8 = function (objHandle: HCkPrivateKey; data: HCkByteData): wordbool; stdcall;
  TCkPrivateKey_LoadPkcs8Encrypted = function (objHandle: HCkPrivateKey; data: HCkByteData; password: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadPkcs8EncryptedFile = function (objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadPkcs8File = function (objHandle: HCkPrivateKey; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadPvk = function (objHandle: HCkPrivateKey; data: HCkByteData; password: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadPvkFile = function (objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadXml = function (objHandle: HCkPrivateKey; xml: PWideChar): wordbool; stdcall;
  TCkPrivateKey_LoadXmlFile = function (objHandle: HCkPrivateKey; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_SavePemFile = function (objHandle: HCkPrivateKey; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_SavePkcs1File = function (objHandle: HCkPrivateKey; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_SavePkcs8EncryptedFile = function (objHandle: HCkPrivateKey; password: PWideChar; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_SavePkcs8EncryptedPemFile = function (objHandle: HCkPrivateKey; password: PWideChar; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_SavePkcs8File = function (objHandle: HCkPrivateKey; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_SavePkcs8PemFile = function (objHandle: HCkPrivateKey; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_SaveXmlFile = function (objHandle: HCkPrivateKey; path: PWideChar): wordbool; stdcall;
  TCkPrivateKey_ToPublicKey = function (objHandle: HCkPrivateKey; pubKey: HCkPublicKey): wordbool; stdcall;
  TCkPrivateKey_UploadToCloud = function (objHandle: HCkPrivateKey; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): wordbool; stdcall;
  TCkPrivateKey_UploadToCloudAsync = function (objHandle: HCkPrivateKey; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..82] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkPrivateKey_Create : HCkPrivateKey;
begin
  result := TCkPrivateKey_Create(_map(0, 'CkPrivateKey_Create'));
end;

procedure CkPrivateKey_Dispose (handle: HCkPrivateKey);
begin
  TCkPrivateKey_Dispose(_map(1, 'CkPrivateKey_Dispose'))
    (handle);
end;


procedure CkPrivateKey_SetAbortCheck (objHandle: HCkPrivateKey; fn: TPrivateKeyAbortCheck);
begin
    TCkPrivateKey_SetAbortCheck(_map(2, 'CkPrivateKey_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkPrivateKey_SetProgressInfo (objHandle: HCkPrivateKey; fn: TPrivateKeyProgressInfo);
begin
    TCkPrivateKey_SetProgressInfo(_map(3, 'CkPrivateKey_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkPrivateKey_SetPercentDone (objHandle: HCkPrivateKey; fn: TPrivateKeyPercentDone);
begin
    TCkPrivateKey_SetPercentDone(_map(4, 'CkPrivateKey_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkPrivateKey_SetTaskCompleted (objHandle: HCkPrivateKey; fn: TPrivateKeyTaskCompleted);
begin
    TCkPrivateKey_SetTaskCompleted(_map(5, 'CkPrivateKey_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkPrivateKey_getBitLength (objHandle: HCkPrivateKey): Integer;
begin
    result := TCkPrivateKey_getBitLength(_map(6, 'CkPrivateKey_getBitLength'))
    (objHandle);
end;

procedure CkPrivateKey_getDebugLogFilePath (objHandle: HCkPrivateKey; outPropVal: HCkString);
begin
  TCkPrivateKey_getDebugLogFilePath(_map(7, 'CkPrivateKey_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkPrivateKey_putDebugLogFilePath (objHandle: HCkPrivateKey; newPropVal: PWideChar);
begin
  TCkPrivateKey_putDebugLogFilePath(_map(8, 'CkPrivateKey_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkPrivateKey__debugLogFilePath (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__debugLogFilePath(_map(9, 'CkPrivateKey__debugLogFilePath'))
    (objHandle);
end;

procedure CkPrivateKey_getKeyType (objHandle: HCkPrivateKey; outPropVal: HCkString);
begin
  TCkPrivateKey_getKeyType(_map(10, 'CkPrivateKey_getKeyType'))
    (objHandle, outPropVal);
end;

function CkPrivateKey__keyType (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__keyType(_map(11, 'CkPrivateKey__keyType'))
    (objHandle);
end;

procedure CkPrivateKey_getLastErrorHtml (objHandle: HCkPrivateKey; outPropVal: HCkString);
begin
  TCkPrivateKey_getLastErrorHtml(_map(12, 'CkPrivateKey_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkPrivateKey__lastErrorHtml (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__lastErrorHtml(_map(13, 'CkPrivateKey__lastErrorHtml'))
    (objHandle);
end;

procedure CkPrivateKey_getLastErrorText (objHandle: HCkPrivateKey; outPropVal: HCkString);
begin
  TCkPrivateKey_getLastErrorText(_map(14, 'CkPrivateKey_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkPrivateKey__lastErrorText (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__lastErrorText(_map(15, 'CkPrivateKey__lastErrorText'))
    (objHandle);
end;

procedure CkPrivateKey_getLastErrorXml (objHandle: HCkPrivateKey; outPropVal: HCkString);
begin
  TCkPrivateKey_getLastErrorXml(_map(16, 'CkPrivateKey_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkPrivateKey__lastErrorXml (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__lastErrorXml(_map(17, 'CkPrivateKey__lastErrorXml'))
    (objHandle);
end;

function CkPrivateKey_getLastMethodSuccess (objHandle: HCkPrivateKey): wordbool;
begin
    result := TCkPrivateKey_getLastMethodSuccess(_map(18, 'CkPrivateKey_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkPrivateKey_putLastMethodSuccess (objHandle: HCkPrivateKey; newPropVal: wordbool);
begin
  TCkPrivateKey_putLastMethodSuccess(_map(19, 'CkPrivateKey_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkPrivateKey_getPkcs8EncryptAlg (objHandle: HCkPrivateKey; outPropVal: HCkString);
begin
  TCkPrivateKey_getPkcs8EncryptAlg(_map(20, 'CkPrivateKey_getPkcs8EncryptAlg'))
    (objHandle, outPropVal);
end;

procedure CkPrivateKey_putPkcs8EncryptAlg (objHandle: HCkPrivateKey; newPropVal: PWideChar);
begin
  TCkPrivateKey_putPkcs8EncryptAlg(_map(21, 'CkPrivateKey_putPkcs8EncryptAlg'))
    (objHandle, newPropVal);
end;

function CkPrivateKey__pkcs8EncryptAlg (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__pkcs8EncryptAlg(_map(22, 'CkPrivateKey__pkcs8EncryptAlg'))
    (objHandle);
end;

procedure CkPrivateKey_getUncommonOptions (objHandle: HCkPrivateKey; outPropVal: HCkString);
begin
  TCkPrivateKey_getUncommonOptions(_map(23, 'CkPrivateKey_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkPrivateKey_putUncommonOptions (objHandle: HCkPrivateKey; newPropVal: PWideChar);
begin
  TCkPrivateKey_putUncommonOptions(_map(24, 'CkPrivateKey_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkPrivateKey__uncommonOptions (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__uncommonOptions(_map(25, 'CkPrivateKey__uncommonOptions'))
    (objHandle);
end;

function CkPrivateKey_getVerboseLogging (objHandle: HCkPrivateKey): wordbool;
begin
    result := TCkPrivateKey_getVerboseLogging(_map(26, 'CkPrivateKey_getVerboseLogging'))
    (objHandle);
end;

procedure CkPrivateKey_putVerboseLogging (objHandle: HCkPrivateKey; newPropVal: wordbool);
begin
  TCkPrivateKey_putVerboseLogging(_map(27, 'CkPrivateKey_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkPrivateKey_getVersion (objHandle: HCkPrivateKey; outPropVal: HCkString);
begin
  TCkPrivateKey_getVersion(_map(28, 'CkPrivateKey_getVersion'))
    (objHandle, outPropVal);
end;

function CkPrivateKey__version (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__version(_map(29, 'CkPrivateKey__version'))
    (objHandle);
end;

function CkPrivateKey_GetJwk (objHandle: HCkPrivateKey; outStr: HCkString): wordbool;
begin
  result := TCkPrivateKey_GetJwk(_map(30, 'CkPrivateKey_GetJwk'))
    (objHandle, outStr);
end;

function CkPrivateKey__getJwk (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__getJwk(_map(31, 'CkPrivateKey__getJwk'))
    (objHandle);
end;

function CkPrivateKey_GetJwkThumbprint (objHandle: HCkPrivateKey; hashAlg: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPrivateKey_GetJwkThumbprint(_map(32, 'CkPrivateKey_GetJwkThumbprint'))
    (objHandle, hashAlg, outStr);
end;

function CkPrivateKey__getJwkThumbprint (objHandle: HCkPrivateKey; hashAlg: PWideChar): PWideChar;
begin
  result := TCkPrivateKey__getJwkThumbprint(_map(33, 'CkPrivateKey__getJwkThumbprint'))
    (objHandle, hashAlg);
end;

function CkPrivateKey_GetPkcs1 (objHandle: HCkPrivateKey; outData: HCkByteData): wordbool;
begin
  result := TCkPrivateKey_GetPkcs1(_map(34, 'CkPrivateKey_GetPkcs1'))
    (objHandle, outData);
end;

function CkPrivateKey_GetPkcs1ENC (objHandle: HCkPrivateKey; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPrivateKey_GetPkcs1ENC(_map(35, 'CkPrivateKey_GetPkcs1ENC'))
    (objHandle, encoding, outStr);
end;

function CkPrivateKey__getPkcs1ENC (objHandle: HCkPrivateKey; encoding: PWideChar): PWideChar;
begin
  result := TCkPrivateKey__getPkcs1ENC(_map(36, 'CkPrivateKey__getPkcs1ENC'))
    (objHandle, encoding);
end;

function CkPrivateKey_GetPkcs1Pem (objHandle: HCkPrivateKey; outStr: HCkString): wordbool;
begin
  result := TCkPrivateKey_GetPkcs1Pem(_map(37, 'CkPrivateKey_GetPkcs1Pem'))
    (objHandle, outStr);
end;

function CkPrivateKey__getPkcs1Pem (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__getPkcs1Pem(_map(38, 'CkPrivateKey__getPkcs1Pem'))
    (objHandle);
end;

function CkPrivateKey_GetPkcs8 (objHandle: HCkPrivateKey; outData: HCkByteData): wordbool;
begin
  result := TCkPrivateKey_GetPkcs8(_map(39, 'CkPrivateKey_GetPkcs8'))
    (objHandle, outData);
end;

function CkPrivateKey_GetPkcs8ENC (objHandle: HCkPrivateKey; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPrivateKey_GetPkcs8ENC(_map(40, 'CkPrivateKey_GetPkcs8ENC'))
    (objHandle, encoding, outStr);
end;

function CkPrivateKey__getPkcs8ENC (objHandle: HCkPrivateKey; encoding: PWideChar): PWideChar;
begin
  result := TCkPrivateKey__getPkcs8ENC(_map(41, 'CkPrivateKey__getPkcs8ENC'))
    (objHandle, encoding);
end;

function CkPrivateKey_GetPkcs8Encrypted (objHandle: HCkPrivateKey; password: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkPrivateKey_GetPkcs8Encrypted(_map(42, 'CkPrivateKey_GetPkcs8Encrypted'))
    (objHandle, password, outData);
end;

function CkPrivateKey_GetPkcs8EncryptedENC (objHandle: HCkPrivateKey; encoding: PWideChar; password: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPrivateKey_GetPkcs8EncryptedENC(_map(43, 'CkPrivateKey_GetPkcs8EncryptedENC'))
    (objHandle, encoding, password, outStr);
end;

function CkPrivateKey__getPkcs8EncryptedENC (objHandle: HCkPrivateKey; encoding: PWideChar; password: PWideChar): PWideChar;
begin
  result := TCkPrivateKey__getPkcs8EncryptedENC(_map(44, 'CkPrivateKey__getPkcs8EncryptedENC'))
    (objHandle, encoding, password);
end;

function CkPrivateKey_GetPkcs8EncryptedPem (objHandle: HCkPrivateKey; password: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPrivateKey_GetPkcs8EncryptedPem(_map(45, 'CkPrivateKey_GetPkcs8EncryptedPem'))
    (objHandle, password, outStr);
end;

function CkPrivateKey__getPkcs8EncryptedPem (objHandle: HCkPrivateKey; password: PWideChar): PWideChar;
begin
  result := TCkPrivateKey__getPkcs8EncryptedPem(_map(46, 'CkPrivateKey__getPkcs8EncryptedPem'))
    (objHandle, password);
end;

function CkPrivateKey_GetPkcs8Pem (objHandle: HCkPrivateKey; outStr: HCkString): wordbool;
begin
  result := TCkPrivateKey_GetPkcs8Pem(_map(47, 'CkPrivateKey_GetPkcs8Pem'))
    (objHandle, outStr);
end;

function CkPrivateKey__getPkcs8Pem (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__getPkcs8Pem(_map(48, 'CkPrivateKey__getPkcs8Pem'))
    (objHandle);
end;

function CkPrivateKey_GetPkcsBd (objHandle: HCkPrivateKey; pkcs1: wordbool; password: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkPrivateKey_GetPkcsBd(_map(49, 'CkPrivateKey_GetPkcsBd'))
    (objHandle, pkcs1, password, bd);
end;

function CkPrivateKey_GetPublicKey (objHandle: HCkPrivateKey): HCkPublicKey;
begin
  result := TCkPrivateKey_GetPublicKey(_map(50, 'CkPrivateKey_GetPublicKey'))
    (objHandle);
end;

function CkPrivateKey_GetRawHex (objHandle: HCkPrivateKey; pubKey: HCkStringBuilder; outStr: HCkString): wordbool;
begin
  result := TCkPrivateKey_GetRawHex(_map(51, 'CkPrivateKey_GetRawHex'))
    (objHandle, pubKey, outStr);
end;

function CkPrivateKey__getRawHex (objHandle: HCkPrivateKey; pubKey: HCkStringBuilder): PWideChar;
begin
  result := TCkPrivateKey__getRawHex(_map(52, 'CkPrivateKey__getRawHex'))
    (objHandle, pubKey);
end;

function CkPrivateKey_GetXml (objHandle: HCkPrivateKey; outStr: HCkString): wordbool;
begin
  result := TCkPrivateKey_GetXml(_map(53, 'CkPrivateKey_GetXml'))
    (objHandle, outStr);
end;

function CkPrivateKey__getXml (objHandle: HCkPrivateKey): PWideChar;
begin
  result := TCkPrivateKey__getXml(_map(54, 'CkPrivateKey__getXml'))
    (objHandle);
end;

function CkPrivateKey_LoadAnyFormat (objHandle: HCkPrivateKey; privKeyData: HCkBinData; password: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadAnyFormat(_map(55, 'CkPrivateKey_LoadAnyFormat'))
    (objHandle, privKeyData, password);
end;

function CkPrivateKey_LoadAnyFormatFile (objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadAnyFormatFile(_map(56, 'CkPrivateKey_LoadAnyFormatFile'))
    (objHandle, path, password);
end;

function CkPrivateKey_LoadEd25519 (objHandle: HCkPrivateKey; privKey: PWideChar; pubKey: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadEd25519(_map(57, 'CkPrivateKey_LoadEd25519'))
    (objHandle, privKey, pubKey);
end;

function CkPrivateKey_LoadEncryptedPem (objHandle: HCkPrivateKey; pemStr: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadEncryptedPem(_map(58, 'CkPrivateKey_LoadEncryptedPem'))
    (objHandle, pemStr, password);
end;

function CkPrivateKey_LoadEncryptedPemFile (objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadEncryptedPemFile(_map(59, 'CkPrivateKey_LoadEncryptedPemFile'))
    (objHandle, path, password);
end;

function CkPrivateKey_LoadJwk (objHandle: HCkPrivateKey; jsonStr: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadJwk(_map(60, 'CkPrivateKey_LoadJwk'))
    (objHandle, jsonStr);
end;

function CkPrivateKey_LoadPem (objHandle: HCkPrivateKey; str: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadPem(_map(61, 'CkPrivateKey_LoadPem'))
    (objHandle, str);
end;

function CkPrivateKey_LoadPemFile (objHandle: HCkPrivateKey; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadPemFile(_map(62, 'CkPrivateKey_LoadPemFile'))
    (objHandle, path);
end;

function CkPrivateKey_LoadPkcs1 (objHandle: HCkPrivateKey; data: HCkByteData): wordbool;
begin
  result := TCkPrivateKey_LoadPkcs1(_map(63, 'CkPrivateKey_LoadPkcs1'))
    (objHandle, data);
end;

function CkPrivateKey_LoadPkcs1File (objHandle: HCkPrivateKey; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadPkcs1File(_map(64, 'CkPrivateKey_LoadPkcs1File'))
    (objHandle, path);
end;

function CkPrivateKey_LoadPkcs8 (objHandle: HCkPrivateKey; data: HCkByteData): wordbool;
begin
  result := TCkPrivateKey_LoadPkcs8(_map(65, 'CkPrivateKey_LoadPkcs8'))
    (objHandle, data);
end;

function CkPrivateKey_LoadPkcs8Encrypted (objHandle: HCkPrivateKey; data: HCkByteData; password: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadPkcs8Encrypted(_map(66, 'CkPrivateKey_LoadPkcs8Encrypted'))
    (objHandle, data, password);
end;

function CkPrivateKey_LoadPkcs8EncryptedFile (objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadPkcs8EncryptedFile(_map(67, 'CkPrivateKey_LoadPkcs8EncryptedFile'))
    (objHandle, path, password);
end;

function CkPrivateKey_LoadPkcs8File (objHandle: HCkPrivateKey; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadPkcs8File(_map(68, 'CkPrivateKey_LoadPkcs8File'))
    (objHandle, path);
end;

function CkPrivateKey_LoadPvk (objHandle: HCkPrivateKey; data: HCkByteData; password: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadPvk(_map(69, 'CkPrivateKey_LoadPvk'))
    (objHandle, data, password);
end;

function CkPrivateKey_LoadPvkFile (objHandle: HCkPrivateKey; path: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadPvkFile(_map(70, 'CkPrivateKey_LoadPvkFile'))
    (objHandle, path, password);
end;

function CkPrivateKey_LoadXml (objHandle: HCkPrivateKey; xml: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadXml(_map(71, 'CkPrivateKey_LoadXml'))
    (objHandle, xml);
end;

function CkPrivateKey_LoadXmlFile (objHandle: HCkPrivateKey; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_LoadXmlFile(_map(72, 'CkPrivateKey_LoadXmlFile'))
    (objHandle, path);
end;

function CkPrivateKey_SavePemFile (objHandle: HCkPrivateKey; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_SavePemFile(_map(73, 'CkPrivateKey_SavePemFile'))
    (objHandle, path);
end;

function CkPrivateKey_SavePkcs1File (objHandle: HCkPrivateKey; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_SavePkcs1File(_map(74, 'CkPrivateKey_SavePkcs1File'))
    (objHandle, path);
end;

function CkPrivateKey_SavePkcs8EncryptedFile (objHandle: HCkPrivateKey; password: PWideChar; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_SavePkcs8EncryptedFile(_map(75, 'CkPrivateKey_SavePkcs8EncryptedFile'))
    (objHandle, password, path);
end;

function CkPrivateKey_SavePkcs8EncryptedPemFile (objHandle: HCkPrivateKey; password: PWideChar; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_SavePkcs8EncryptedPemFile(_map(76, 'CkPrivateKey_SavePkcs8EncryptedPemFile'))
    (objHandle, password, path);
end;

function CkPrivateKey_SavePkcs8File (objHandle: HCkPrivateKey; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_SavePkcs8File(_map(77, 'CkPrivateKey_SavePkcs8File'))
    (objHandle, path);
end;

function CkPrivateKey_SavePkcs8PemFile (objHandle: HCkPrivateKey; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_SavePkcs8PemFile(_map(78, 'CkPrivateKey_SavePkcs8PemFile'))
    (objHandle, path);
end;

function CkPrivateKey_SaveXmlFile (objHandle: HCkPrivateKey; path: PWideChar): wordbool;
begin
  result := TCkPrivateKey_SaveXmlFile(_map(79, 'CkPrivateKey_SaveXmlFile'))
    (objHandle, path);
end;

function CkPrivateKey_ToPublicKey (objHandle: HCkPrivateKey; pubKey: HCkPublicKey): wordbool;
begin
  result := TCkPrivateKey_ToPublicKey(_map(80, 'CkPrivateKey_ToPublicKey'))
    (objHandle, pubKey);
end;

function CkPrivateKey_UploadToCloud (objHandle: HCkPrivateKey; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): wordbool;
begin
  result := TCkPrivateKey_UploadToCloud(_map(81, 'CkPrivateKey_UploadToCloud'))
    (objHandle, jsonIn, jsonOut);
end;

function CkPrivateKey_UploadToCloudAsync (objHandle: HCkPrivateKey; jsonIn: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask;
begin
  result := TCkPrivateKey_UploadToCloudAsync(_map(82, 'CkPrivateKey_UploadToCloudAsync'))
    (objHandle, jsonIn, jsonOut);
end;

end.
