unit PublicKey;

interface

type

HCkBinData = Pointer;
HCkByteData = Pointer;
HCkPublicKey = Pointer;
HCkString = Pointer;


function CkPublicKey_Create: HCkPublicKey;  stdcall;
procedure CkPublicKey_Dispose(handle: HCkPublicKey); stdcall;
procedure CkPublicKey_getDebugLogFilePath(objHandle: HCkPublicKey; outPropVal: HCkString);
procedure CkPublicKey_putDebugLogFilePath(objHandle: HCkPublicKey; newPropVal: PWideChar);
function CkPublicKey__debugLogFilePath(objHandle: HCkPublicKey): PWideChar;
function CkPublicKey_getEmpty(objHandle: HCkPublicKey): wordbool;
function CkPublicKey_getKeySize(objHandle: HCkPublicKey): Integer;
procedure CkPublicKey_getKeyType(objHandle: HCkPublicKey; outPropVal: HCkString);
function CkPublicKey__keyType(objHandle: HCkPublicKey): PWideChar;
procedure CkPublicKey_getLastErrorHtml(objHandle: HCkPublicKey; outPropVal: HCkString);
function CkPublicKey__lastErrorHtml(objHandle: HCkPublicKey): PWideChar;
procedure CkPublicKey_getLastErrorText(objHandle: HCkPublicKey; outPropVal: HCkString);
function CkPublicKey__lastErrorText(objHandle: HCkPublicKey): PWideChar;
procedure CkPublicKey_getLastErrorXml(objHandle: HCkPublicKey; outPropVal: HCkString);
function CkPublicKey__lastErrorXml(objHandle: HCkPublicKey): PWideChar;
function CkPublicKey_getLastMethodSuccess(objHandle: HCkPublicKey): wordbool;
procedure CkPublicKey_putLastMethodSuccess(objHandle: HCkPublicKey; newPropVal: wordbool);
function CkPublicKey_getVerboseLogging(objHandle: HCkPublicKey): wordbool;
procedure CkPublicKey_putVerboseLogging(objHandle: HCkPublicKey; newPropVal: wordbool);
procedure CkPublicKey_getVersion(objHandle: HCkPublicKey; outPropVal: HCkString);
function CkPublicKey__version(objHandle: HCkPublicKey): PWideChar;
function CkPublicKey_GetDer(objHandle: HCkPublicKey; preferPkcs1: wordbool; outData: HCkByteData): wordbool;
function CkPublicKey_GetDerBd(objHandle: HCkPublicKey; preferPkcs1: wordbool; bd: HCkBinData): wordbool;
function CkPublicKey_GetEncoded(objHandle: HCkPublicKey; preferPkcs1: wordbool; encoding: PWideChar; outStr: HCkString): wordbool;
function CkPublicKey__getEncoded(objHandle: HCkPublicKey; preferPkcs1: wordbool; encoding: PWideChar): PWideChar;
function CkPublicKey_GetJwk(objHandle: HCkPublicKey; outStr: HCkString): wordbool;
function CkPublicKey__getJwk(objHandle: HCkPublicKey): PWideChar;
function CkPublicKey_GetJwkThumbprint(objHandle: HCkPublicKey; hashAlg: PWideChar; outStr: HCkString): wordbool;
function CkPublicKey__getJwkThumbprint(objHandle: HCkPublicKey; hashAlg: PWideChar): PWideChar;
function CkPublicKey_GetPem(objHandle: HCkPublicKey; preferPkcs1: wordbool; outStr: HCkString): wordbool;
function CkPublicKey__getPem(objHandle: HCkPublicKey; preferPkcs1: wordbool): PWideChar;
function CkPublicKey_GetXml(objHandle: HCkPublicKey; outStr: HCkString): wordbool;
function CkPublicKey__getXml(objHandle: HCkPublicKey): PWideChar;
function CkPublicKey_LoadBase64(objHandle: HCkPublicKey; keyStr: PWideChar): wordbool;
function CkPublicKey_LoadBd(objHandle: HCkPublicKey; bd: HCkBinData): wordbool;
function CkPublicKey_LoadEcdsa(objHandle: HCkPublicKey; curveName: PWideChar; Qx: PWideChar; Qy: PWideChar): wordbool;
function CkPublicKey_LoadEd25519(objHandle: HCkPublicKey; pubKey: PWideChar): wordbool;
function CkPublicKey_LoadFromBinary(objHandle: HCkPublicKey; keyBytes: HCkByteData): wordbool;
function CkPublicKey_LoadFromFile(objHandle: HCkPublicKey; path: PWideChar): wordbool;
function CkPublicKey_LoadFromString(objHandle: HCkPublicKey; keyString: PWideChar): wordbool;
function CkPublicKey_SaveDerFile(objHandle: HCkPublicKey; preferPkcs1: wordbool; path: PWideChar): wordbool;
function CkPublicKey_SavePemFile(objHandle: HCkPublicKey; preferPkcs1: wordbool; path: PWideChar): wordbool;
function CkPublicKey_SaveXmlFile(objHandle: HCkPublicKey; path: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkPublicKey_Create = function : HCkPublicKey; stdcall;
  TCkPublicKey_Dispose = procedure (handle: HCkPublicKey); stdcall;
  TCkPublicKey_getDebugLogFilePath = procedure (objHandle: HCkPublicKey; outPropVal: HCkString); stdcall;
  TCkPublicKey_putDebugLogFilePath = procedure (objHandle: HCkPublicKey; newPropVal: PWideChar); stdcall;
  TCkPublicKey__debugLogFilePath = function (objHandle: HCkPublicKey): PWideChar; stdcall;
  TCkPublicKey_getEmpty = function (objHandle: HCkPublicKey): wordbool; stdcall;
  TCkPublicKey_getKeySize = function (objHandle: HCkPublicKey): Integer; stdcall;
  TCkPublicKey_getKeyType = procedure (objHandle: HCkPublicKey; outPropVal: HCkString); stdcall;
  TCkPublicKey__keyType = function (objHandle: HCkPublicKey): PWideChar; stdcall;
  TCkPublicKey_getLastErrorHtml = procedure (objHandle: HCkPublicKey; outPropVal: HCkString); stdcall;
  TCkPublicKey__lastErrorHtml = function (objHandle: HCkPublicKey): PWideChar; stdcall;
  TCkPublicKey_getLastErrorText = procedure (objHandle: HCkPublicKey; outPropVal: HCkString); stdcall;
  TCkPublicKey__lastErrorText = function (objHandle: HCkPublicKey): PWideChar; stdcall;
  TCkPublicKey_getLastErrorXml = procedure (objHandle: HCkPublicKey; outPropVal: HCkString); stdcall;
  TCkPublicKey__lastErrorXml = function (objHandle: HCkPublicKey): PWideChar; stdcall;
  TCkPublicKey_getLastMethodSuccess = function (objHandle: HCkPublicKey): wordbool; stdcall;
  TCkPublicKey_putLastMethodSuccess = procedure (objHandle: HCkPublicKey; newPropVal: wordbool); stdcall;
  TCkPublicKey_getVerboseLogging = function (objHandle: HCkPublicKey): wordbool; stdcall;
  TCkPublicKey_putVerboseLogging = procedure (objHandle: HCkPublicKey; newPropVal: wordbool); stdcall;
  TCkPublicKey_getVersion = procedure (objHandle: HCkPublicKey; outPropVal: HCkString); stdcall;
  TCkPublicKey__version = function (objHandle: HCkPublicKey): PWideChar; stdcall;
  TCkPublicKey_GetDer = function (objHandle: HCkPublicKey; preferPkcs1: wordbool; outData: HCkByteData): wordbool; stdcall;
  TCkPublicKey_GetDerBd = function (objHandle: HCkPublicKey; preferPkcs1: wordbool; bd: HCkBinData): wordbool; stdcall;
  TCkPublicKey_GetEncoded = function (objHandle: HCkPublicKey; preferPkcs1: wordbool; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPublicKey__getEncoded = function (objHandle: HCkPublicKey; preferPkcs1: wordbool; encoding: PWideChar): PWideChar; stdcall;
  TCkPublicKey_GetJwk = function (objHandle: HCkPublicKey; outStr: HCkString): wordbool; stdcall;
  TCkPublicKey__getJwk = function (objHandle: HCkPublicKey): PWideChar; stdcall;
  TCkPublicKey_GetJwkThumbprint = function (objHandle: HCkPublicKey; hashAlg: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkPublicKey__getJwkThumbprint = function (objHandle: HCkPublicKey; hashAlg: PWideChar): PWideChar; stdcall;
  TCkPublicKey_GetPem = function (objHandle: HCkPublicKey; preferPkcs1: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkPublicKey__getPem = function (objHandle: HCkPublicKey; preferPkcs1: wordbool): PWideChar; stdcall;
  TCkPublicKey_GetXml = function (objHandle: HCkPublicKey; outStr: HCkString): wordbool; stdcall;
  TCkPublicKey__getXml = function (objHandle: HCkPublicKey): PWideChar; stdcall;
  TCkPublicKey_LoadBase64 = function (objHandle: HCkPublicKey; keyStr: PWideChar): wordbool; stdcall;
  TCkPublicKey_LoadBd = function (objHandle: HCkPublicKey; bd: HCkBinData): wordbool; stdcall;
  TCkPublicKey_LoadEcdsa = function (objHandle: HCkPublicKey; curveName: PWideChar; Qx: PWideChar; Qy: PWideChar): wordbool; stdcall;
  TCkPublicKey_LoadEd25519 = function (objHandle: HCkPublicKey; pubKey: PWideChar): wordbool; stdcall;
  TCkPublicKey_LoadFromBinary = function (objHandle: HCkPublicKey; keyBytes: HCkByteData): wordbool; stdcall;
  TCkPublicKey_LoadFromFile = function (objHandle: HCkPublicKey; path: PWideChar): wordbool; stdcall;
  TCkPublicKey_LoadFromString = function (objHandle: HCkPublicKey; keyString: PWideChar): wordbool; stdcall;
  TCkPublicKey_SaveDerFile = function (objHandle: HCkPublicKey; preferPkcs1: wordbool; path: PWideChar): wordbool; stdcall;
  TCkPublicKey_SavePemFile = function (objHandle: HCkPublicKey; preferPkcs1: wordbool; path: PWideChar): wordbool; stdcall;
  TCkPublicKey_SaveXmlFile = function (objHandle: HCkPublicKey; path: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..42] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkPublicKey_Create : HCkPublicKey;
begin
  result := TCkPublicKey_Create(_map(0, 'CkPublicKey_Create'));
end;

procedure CkPublicKey_Dispose (handle: HCkPublicKey);
begin
  TCkPublicKey_Dispose(_map(1, 'CkPublicKey_Dispose'))
    (handle);
end;


procedure CkPublicKey_getDebugLogFilePath (objHandle: HCkPublicKey; outPropVal: HCkString);
begin
  TCkPublicKey_getDebugLogFilePath(_map(2, 'CkPublicKey_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkPublicKey_putDebugLogFilePath (objHandle: HCkPublicKey; newPropVal: PWideChar);
begin
  TCkPublicKey_putDebugLogFilePath(_map(3, 'CkPublicKey_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkPublicKey__debugLogFilePath (objHandle: HCkPublicKey): PWideChar;
begin
  result := TCkPublicKey__debugLogFilePath(_map(4, 'CkPublicKey__debugLogFilePath'))
    (objHandle);
end;

function CkPublicKey_getEmpty (objHandle: HCkPublicKey): wordbool;
begin
    result := TCkPublicKey_getEmpty(_map(5, 'CkPublicKey_getEmpty'))
    (objHandle);
end;

function CkPublicKey_getKeySize (objHandle: HCkPublicKey): Integer;
begin
    result := TCkPublicKey_getKeySize(_map(6, 'CkPublicKey_getKeySize'))
    (objHandle);
end;

procedure CkPublicKey_getKeyType (objHandle: HCkPublicKey; outPropVal: HCkString);
begin
  TCkPublicKey_getKeyType(_map(7, 'CkPublicKey_getKeyType'))
    (objHandle, outPropVal);
end;

function CkPublicKey__keyType (objHandle: HCkPublicKey): PWideChar;
begin
  result := TCkPublicKey__keyType(_map(8, 'CkPublicKey__keyType'))
    (objHandle);
end;

procedure CkPublicKey_getLastErrorHtml (objHandle: HCkPublicKey; outPropVal: HCkString);
begin
  TCkPublicKey_getLastErrorHtml(_map(9, 'CkPublicKey_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkPublicKey__lastErrorHtml (objHandle: HCkPublicKey): PWideChar;
begin
  result := TCkPublicKey__lastErrorHtml(_map(10, 'CkPublicKey__lastErrorHtml'))
    (objHandle);
end;

procedure CkPublicKey_getLastErrorText (objHandle: HCkPublicKey; outPropVal: HCkString);
begin
  TCkPublicKey_getLastErrorText(_map(11, 'CkPublicKey_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkPublicKey__lastErrorText (objHandle: HCkPublicKey): PWideChar;
begin
  result := TCkPublicKey__lastErrorText(_map(12, 'CkPublicKey__lastErrorText'))
    (objHandle);
end;

procedure CkPublicKey_getLastErrorXml (objHandle: HCkPublicKey; outPropVal: HCkString);
begin
  TCkPublicKey_getLastErrorXml(_map(13, 'CkPublicKey_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkPublicKey__lastErrorXml (objHandle: HCkPublicKey): PWideChar;
begin
  result := TCkPublicKey__lastErrorXml(_map(14, 'CkPublicKey__lastErrorXml'))
    (objHandle);
end;

function CkPublicKey_getLastMethodSuccess (objHandle: HCkPublicKey): wordbool;
begin
    result := TCkPublicKey_getLastMethodSuccess(_map(15, 'CkPublicKey_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkPublicKey_putLastMethodSuccess (objHandle: HCkPublicKey; newPropVal: wordbool);
begin
  TCkPublicKey_putLastMethodSuccess(_map(16, 'CkPublicKey_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkPublicKey_getVerboseLogging (objHandle: HCkPublicKey): wordbool;
begin
    result := TCkPublicKey_getVerboseLogging(_map(17, 'CkPublicKey_getVerboseLogging'))
    (objHandle);
end;

procedure CkPublicKey_putVerboseLogging (objHandle: HCkPublicKey; newPropVal: wordbool);
begin
  TCkPublicKey_putVerboseLogging(_map(18, 'CkPublicKey_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkPublicKey_getVersion (objHandle: HCkPublicKey; outPropVal: HCkString);
begin
  TCkPublicKey_getVersion(_map(19, 'CkPublicKey_getVersion'))
    (objHandle, outPropVal);
end;

function CkPublicKey__version (objHandle: HCkPublicKey): PWideChar;
begin
  result := TCkPublicKey__version(_map(20, 'CkPublicKey__version'))
    (objHandle);
end;

function CkPublicKey_GetDer (objHandle: HCkPublicKey; preferPkcs1: wordbool; outData: HCkByteData): wordbool;
begin
  result := TCkPublicKey_GetDer(_map(21, 'CkPublicKey_GetDer'))
    (objHandle, preferPkcs1, outData);
end;

function CkPublicKey_GetDerBd (objHandle: HCkPublicKey; preferPkcs1: wordbool; bd: HCkBinData): wordbool;
begin
  result := TCkPublicKey_GetDerBd(_map(22, 'CkPublicKey_GetDerBd'))
    (objHandle, preferPkcs1, bd);
end;

function CkPublicKey_GetEncoded (objHandle: HCkPublicKey; preferPkcs1: wordbool; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPublicKey_GetEncoded(_map(23, 'CkPublicKey_GetEncoded'))
    (objHandle, preferPkcs1, encoding, outStr);
end;

function CkPublicKey__getEncoded (objHandle: HCkPublicKey; preferPkcs1: wordbool; encoding: PWideChar): PWideChar;
begin
  result := TCkPublicKey__getEncoded(_map(24, 'CkPublicKey__getEncoded'))
    (objHandle, preferPkcs1, encoding);
end;

function CkPublicKey_GetJwk (objHandle: HCkPublicKey; outStr: HCkString): wordbool;
begin
  result := TCkPublicKey_GetJwk(_map(25, 'CkPublicKey_GetJwk'))
    (objHandle, outStr);
end;

function CkPublicKey__getJwk (objHandle: HCkPublicKey): PWideChar;
begin
  result := TCkPublicKey__getJwk(_map(26, 'CkPublicKey__getJwk'))
    (objHandle);
end;

function CkPublicKey_GetJwkThumbprint (objHandle: HCkPublicKey; hashAlg: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkPublicKey_GetJwkThumbprint(_map(27, 'CkPublicKey_GetJwkThumbprint'))
    (objHandle, hashAlg, outStr);
end;

function CkPublicKey__getJwkThumbprint (objHandle: HCkPublicKey; hashAlg: PWideChar): PWideChar;
begin
  result := TCkPublicKey__getJwkThumbprint(_map(28, 'CkPublicKey__getJwkThumbprint'))
    (objHandle, hashAlg);
end;

function CkPublicKey_GetPem (objHandle: HCkPublicKey; preferPkcs1: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkPublicKey_GetPem(_map(29, 'CkPublicKey_GetPem'))
    (objHandle, preferPkcs1, outStr);
end;

function CkPublicKey__getPem (objHandle: HCkPublicKey; preferPkcs1: wordbool): PWideChar;
begin
  result := TCkPublicKey__getPem(_map(30, 'CkPublicKey__getPem'))
    (objHandle, preferPkcs1);
end;

function CkPublicKey_GetXml (objHandle: HCkPublicKey; outStr: HCkString): wordbool;
begin
  result := TCkPublicKey_GetXml(_map(31, 'CkPublicKey_GetXml'))
    (objHandle, outStr);
end;

function CkPublicKey__getXml (objHandle: HCkPublicKey): PWideChar;
begin
  result := TCkPublicKey__getXml(_map(32, 'CkPublicKey__getXml'))
    (objHandle);
end;

function CkPublicKey_LoadBase64 (objHandle: HCkPublicKey; keyStr: PWideChar): wordbool;
begin
  result := TCkPublicKey_LoadBase64(_map(33, 'CkPublicKey_LoadBase64'))
    (objHandle, keyStr);
end;

function CkPublicKey_LoadBd (objHandle: HCkPublicKey; bd: HCkBinData): wordbool;
begin
  result := TCkPublicKey_LoadBd(_map(34, 'CkPublicKey_LoadBd'))
    (objHandle, bd);
end;

function CkPublicKey_LoadEcdsa (objHandle: HCkPublicKey; curveName: PWideChar; Qx: PWideChar; Qy: PWideChar): wordbool;
begin
  result := TCkPublicKey_LoadEcdsa(_map(35, 'CkPublicKey_LoadEcdsa'))
    (objHandle, curveName, Qx, Qy);
end;

function CkPublicKey_LoadEd25519 (objHandle: HCkPublicKey; pubKey: PWideChar): wordbool;
begin
  result := TCkPublicKey_LoadEd25519(_map(36, 'CkPublicKey_LoadEd25519'))
    (objHandle, pubKey);
end;

function CkPublicKey_LoadFromBinary (objHandle: HCkPublicKey; keyBytes: HCkByteData): wordbool;
begin
  result := TCkPublicKey_LoadFromBinary(_map(37, 'CkPublicKey_LoadFromBinary'))
    (objHandle, keyBytes);
end;

function CkPublicKey_LoadFromFile (objHandle: HCkPublicKey; path: PWideChar): wordbool;
begin
  result := TCkPublicKey_LoadFromFile(_map(38, 'CkPublicKey_LoadFromFile'))
    (objHandle, path);
end;

function CkPublicKey_LoadFromString (objHandle: HCkPublicKey; keyString: PWideChar): wordbool;
begin
  result := TCkPublicKey_LoadFromString(_map(39, 'CkPublicKey_LoadFromString'))
    (objHandle, keyString);
end;

function CkPublicKey_SaveDerFile (objHandle: HCkPublicKey; preferPkcs1: wordbool; path: PWideChar): wordbool;
begin
  result := TCkPublicKey_SaveDerFile(_map(40, 'CkPublicKey_SaveDerFile'))
    (objHandle, preferPkcs1, path);
end;

function CkPublicKey_SavePemFile (objHandle: HCkPublicKey; preferPkcs1: wordbool; path: PWideChar): wordbool;
begin
  result := TCkPublicKey_SavePemFile(_map(41, 'CkPublicKey_SavePemFile'))
    (objHandle, preferPkcs1, path);
end;

function CkPublicKey_SaveXmlFile (objHandle: HCkPublicKey; path: PWideChar): wordbool;
begin
  result := TCkPublicKey_SaveXmlFile(_map(42, 'CkPublicKey_SaveXmlFile'))
    (objHandle, path);
end;

end.
