unit SCard;

interface

type

HCkJsonObject = Pointer;
HCkSCard = Pointer;
HCkString = Pointer;
HCkTask = Pointer;
HCkStringTable = Pointer;
HCkBinData = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TSCardAbortCheck = function(): Integer; cdecl;
TSCardProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TSCardPercentDone = function(pctDone: Integer): Integer; cdecl;
TSCardTaskCompleted = procedure(task: HCkTask); cdecl;


function CkSCard_Create: HCkSCard;  stdcall;
procedure CkSCard_Dispose(handle: HCkSCard); stdcall;

procedure CkSCard_SetAbortCheck(objHandle: HCkSCard; fn: TSCardAbortCheck) stdcall;
procedure CkSCard_SetProgressInfo(objHandle: HCkSCard; fn: TSCardProgressInfo) stdcall;
procedure CkSCard_SetPercentDone(objHandle: HCkSCard; fn: TSCardPercentDone) stdcall;
procedure CkSCard_SetTaskCompleted(objHandle: HCkSCard; fn: TSCardTaskCompleted) stdcall;
procedure CkSCard_getActiveProtocol(objHandle: HCkSCard; outPropVal: HCkString);
function CkSCard__activeProtocol(objHandle: HCkSCard): PWideChar;
procedure CkSCard_getCardAtr(objHandle: HCkSCard; outPropVal: HCkString);
function CkSCard__cardAtr(objHandle: HCkSCard): PWideChar;
procedure CkSCard_getConnectedReader(objHandle: HCkSCard; outPropVal: HCkString);
function CkSCard__connectedReader(objHandle: HCkSCard): PWideChar;
procedure CkSCard_getContext(objHandle: HCkSCard; outPropVal: HCkString);
function CkSCard__context(objHandle: HCkSCard): PWideChar;
procedure CkSCard_getDebugLogFilePath(objHandle: HCkSCard; outPropVal: HCkString);
procedure CkSCard_putDebugLogFilePath(objHandle: HCkSCard; newPropVal: PWideChar);
function CkSCard__debugLogFilePath(objHandle: HCkSCard): PWideChar;
procedure CkSCard_getLastErrorHtml(objHandle: HCkSCard; outPropVal: HCkString);
function CkSCard__lastErrorHtml(objHandle: HCkSCard): PWideChar;
procedure CkSCard_getLastErrorText(objHandle: HCkSCard; outPropVal: HCkString);
function CkSCard__lastErrorText(objHandle: HCkSCard): PWideChar;
procedure CkSCard_getLastErrorXml(objHandle: HCkSCard; outPropVal: HCkString);
function CkSCard__lastErrorXml(objHandle: HCkSCard): PWideChar;
function CkSCard_getLastMethodSuccess(objHandle: HCkSCard): wordbool;
procedure CkSCard_putLastMethodSuccess(objHandle: HCkSCard; newPropVal: wordbool);
procedure CkSCard_getPcscLibPath(objHandle: HCkSCard; outPropVal: HCkString);
procedure CkSCard_putPcscLibPath(objHandle: HCkSCard; newPropVal: PWideChar);
function CkSCard__pcscLibPath(objHandle: HCkSCard): PWideChar;
procedure CkSCard_getReaderStatus(objHandle: HCkSCard; outPropVal: HCkString);
function CkSCard__readerStatus(objHandle: HCkSCard): PWideChar;
procedure CkSCard_getScardError(objHandle: HCkSCard; outPropVal: HCkString);
function CkSCard__scardError(objHandle: HCkSCard): PWideChar;
function CkSCard_getVerboseLogging(objHandle: HCkSCard): wordbool;
procedure CkSCard_putVerboseLogging(objHandle: HCkSCard; newPropVal: wordbool);
procedure CkSCard_getVersion(objHandle: HCkSCard; outPropVal: HCkString);
function CkSCard__version(objHandle: HCkSCard): PWideChar;
function CkSCard_BeginTransaction(objHandle: HCkSCard): wordbool;
function CkSCard_CheckStatus(objHandle: HCkSCard): wordbool;
function CkSCard_Connect(objHandle: HCkSCard; reader: PWideChar; shareMode: PWideChar; preferredProtocol: PWideChar): wordbool;
function CkSCard_Disconnect(objHandle: HCkSCard; disposition: PWideChar): wordbool;
function CkSCard_EndTransaction(objHandle: HCkSCard; disposition: PWideChar): wordbool;
function CkSCard_EstablishContext(objHandle: HCkSCard; scope: PWideChar): wordbool;
function CkSCard_FindSmartcards(objHandle: HCkSCard; json: HCkJsonObject): wordbool;
function CkSCard_GetAttrib(objHandle: HCkSCard; attr: PWideChar; bd: HCkBinData): wordbool;
function CkSCard_GetAttribStr(objHandle: HCkSCard; attr: PWideChar; outStr: HCkString): wordbool;
function CkSCard__getAttribStr(objHandle: HCkSCard; attr: PWideChar): PWideChar;
function CkSCard_GetAttribUint(objHandle: HCkSCard; attr: PWideChar): LongWord;
function CkSCard_GetStatusChange(objHandle: HCkSCard; maxWaitMs: Integer; stReaderNames: HCkStringTable; json: HCkJsonObject): wordbool;
function CkSCard_GetStatusChangeAsync(objHandle: HCkSCard; maxWaitMs: Integer; stReaderNames: HCkStringTable; json: HCkJsonObject): HCkTask;
function CkSCard_GetStatusChangeCancel(objHandle: HCkSCard): wordbool;
function CkSCard_ListReaderGroups(objHandle: HCkSCard; readerGroups: HCkStringTable): wordbool;
function CkSCard_ListReaders(objHandle: HCkSCard; st: HCkStringTable): wordbool;
function CkSCard_Reconnect(objHandle: HCkSCard; shareMode: PWideChar; preferredProtocol: PWideChar; action: PWideChar): wordbool;
function CkSCard_ReleaseContext(objHandle: HCkSCard): wordbool;
function CkSCard_SendControl(objHandle: HCkSCard; controlCode: LongWord; bdSend: HCkBinData; bdRecv: HCkBinData): wordbool;
function CkSCard_SendControlHex(objHandle: HCkSCard; controlCode: LongWord; sendData: PWideChar; bdRecv: HCkBinData): wordbool;
function CkSCard_Transmit(objHandle: HCkSCard; protocol: PWideChar; bdSend: HCkBinData; bdRecv: HCkBinData; maxRecvLen: Integer): wordbool;
function CkSCard_TransmitHex(objHandle: HCkSCard; protocol: PWideChar; apduHex: PWideChar; bdRecv: HCkBinData; maxRecvLen: Integer): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkSCard_Create = function : HCkSCard; stdcall;
  TCkSCard_Dispose = procedure (handle: HCkSCard); stdcall;
  TCkSCard_SetAbortCheck = procedure (objHandle: HCkSCard; fn: TSCardAbortCheck); stdcall;
  TCkSCard_SetProgressInfo = procedure (objHandle: HCkSCard; fn: TSCardProgressInfo); stdcall;
  TCkSCard_SetPercentDone = procedure (objHandle: HCkSCard; fn: TSCardPercentDone); stdcall;
  TCkSCard_SetTaskCompleted = procedure (objHandle: HCkSCard; fn: TSCardTaskCompleted); stdcall;
  TCkSCard_getActiveProtocol = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard__activeProtocol = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getCardAtr = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard__cardAtr = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getConnectedReader = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard__connectedReader = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getContext = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard__context = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getDebugLogFilePath = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard_putDebugLogFilePath = procedure (objHandle: HCkSCard; newPropVal: PWideChar); stdcall;
  TCkSCard__debugLogFilePath = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getLastErrorHtml = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard__lastErrorHtml = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getLastErrorText = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard__lastErrorText = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getLastErrorXml = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard__lastErrorXml = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getLastMethodSuccess = function (objHandle: HCkSCard): wordbool; stdcall;
  TCkSCard_putLastMethodSuccess = procedure (objHandle: HCkSCard; newPropVal: wordbool); stdcall;
  TCkSCard_getPcscLibPath = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard_putPcscLibPath = procedure (objHandle: HCkSCard; newPropVal: PWideChar); stdcall;
  TCkSCard__pcscLibPath = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getReaderStatus = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard__readerStatus = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getScardError = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard__scardError = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_getVerboseLogging = function (objHandle: HCkSCard): wordbool; stdcall;
  TCkSCard_putVerboseLogging = procedure (objHandle: HCkSCard; newPropVal: wordbool); stdcall;
  TCkSCard_getVersion = procedure (objHandle: HCkSCard; outPropVal: HCkString); stdcall;
  TCkSCard__version = function (objHandle: HCkSCard): PWideChar; stdcall;
  TCkSCard_BeginTransaction = function (objHandle: HCkSCard): wordbool; stdcall;
  TCkSCard_CheckStatus = function (objHandle: HCkSCard): wordbool; stdcall;
  TCkSCard_Connect = function (objHandle: HCkSCard; reader: PWideChar; shareMode: PWideChar; preferredProtocol: PWideChar): wordbool; stdcall;
  TCkSCard_Disconnect = function (objHandle: HCkSCard; disposition: PWideChar): wordbool; stdcall;
  TCkSCard_EndTransaction = function (objHandle: HCkSCard; disposition: PWideChar): wordbool; stdcall;
  TCkSCard_EstablishContext = function (objHandle: HCkSCard; scope: PWideChar): wordbool; stdcall;
  TCkSCard_FindSmartcards = function (objHandle: HCkSCard; json: HCkJsonObject): wordbool; stdcall;
  TCkSCard_GetAttrib = function (objHandle: HCkSCard; attr: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkSCard_GetAttribStr = function (objHandle: HCkSCard; attr: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSCard__getAttribStr = function (objHandle: HCkSCard; attr: PWideChar): PWideChar; stdcall;
  TCkSCard_GetAttribUint = function (objHandle: HCkSCard; attr: PWideChar): LongWord; stdcall;
  TCkSCard_GetStatusChange = function (objHandle: HCkSCard; maxWaitMs: Integer; stReaderNames: HCkStringTable; json: HCkJsonObject): wordbool; stdcall;
  TCkSCard_GetStatusChangeAsync = function (objHandle: HCkSCard; maxWaitMs: Integer; stReaderNames: HCkStringTable; json: HCkJsonObject): HCkTask; stdcall;
  TCkSCard_GetStatusChangeCancel = function (objHandle: HCkSCard): wordbool; stdcall;
  TCkSCard_ListReaderGroups = function (objHandle: HCkSCard; readerGroups: HCkStringTable): wordbool; stdcall;
  TCkSCard_ListReaders = function (objHandle: HCkSCard; st: HCkStringTable): wordbool; stdcall;
  TCkSCard_Reconnect = function (objHandle: HCkSCard; shareMode: PWideChar; preferredProtocol: PWideChar; action: PWideChar): wordbool; stdcall;
  TCkSCard_ReleaseContext = function (objHandle: HCkSCard): wordbool; stdcall;
  TCkSCard_SendControl = function (objHandle: HCkSCard; controlCode: LongWord; bdSend: HCkBinData; bdRecv: HCkBinData): wordbool; stdcall;
  TCkSCard_SendControlHex = function (objHandle: HCkSCard; controlCode: LongWord; sendData: PWideChar; bdRecv: HCkBinData): wordbool; stdcall;
  TCkSCard_Transmit = function (objHandle: HCkSCard; protocol: PWideChar; bdSend: HCkBinData; bdRecv: HCkBinData; maxRecvLen: Integer): wordbool; stdcall;
  TCkSCard_TransmitHex = function (objHandle: HCkSCard; protocol: PWideChar; apduHex: PWideChar; bdRecv: HCkBinData; maxRecvLen: Integer): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..57] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkSCard_Create : HCkSCard;
begin
  result := TCkSCard_Create(_map(0, 'CkSCard_Create'));
end;

procedure CkSCard_Dispose (handle: HCkSCard);
begin
  TCkSCard_Dispose(_map(1, 'CkSCard_Dispose'))
    (handle);
end;


procedure CkSCard_SetAbortCheck (objHandle: HCkSCard; fn: TSCardAbortCheck);
begin
    TCkSCard_SetAbortCheck(_map(2, 'CkSCard_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkSCard_SetProgressInfo (objHandle: HCkSCard; fn: TSCardProgressInfo);
begin
    TCkSCard_SetProgressInfo(_map(3, 'CkSCard_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkSCard_SetPercentDone (objHandle: HCkSCard; fn: TSCardPercentDone);
begin
    TCkSCard_SetPercentDone(_map(4, 'CkSCard_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkSCard_SetTaskCompleted (objHandle: HCkSCard; fn: TSCardTaskCompleted);
begin
    TCkSCard_SetTaskCompleted(_map(5, 'CkSCard_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkSCard_getActiveProtocol (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getActiveProtocol(_map(6, 'CkSCard_getActiveProtocol'))
    (objHandle, outPropVal);
end;

function CkSCard__activeProtocol (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__activeProtocol(_map(7, 'CkSCard__activeProtocol'))
    (objHandle);
end;

procedure CkSCard_getCardAtr (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getCardAtr(_map(8, 'CkSCard_getCardAtr'))
    (objHandle, outPropVal);
end;

function CkSCard__cardAtr (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__cardAtr(_map(9, 'CkSCard__cardAtr'))
    (objHandle);
end;

procedure CkSCard_getConnectedReader (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getConnectedReader(_map(10, 'CkSCard_getConnectedReader'))
    (objHandle, outPropVal);
end;

function CkSCard__connectedReader (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__connectedReader(_map(11, 'CkSCard__connectedReader'))
    (objHandle);
end;

procedure CkSCard_getContext (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getContext(_map(12, 'CkSCard_getContext'))
    (objHandle, outPropVal);
end;

function CkSCard__context (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__context(_map(13, 'CkSCard__context'))
    (objHandle);
end;

procedure CkSCard_getDebugLogFilePath (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getDebugLogFilePath(_map(14, 'CkSCard_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkSCard_putDebugLogFilePath (objHandle: HCkSCard; newPropVal: PWideChar);
begin
  TCkSCard_putDebugLogFilePath(_map(15, 'CkSCard_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkSCard__debugLogFilePath (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__debugLogFilePath(_map(16, 'CkSCard__debugLogFilePath'))
    (objHandle);
end;

procedure CkSCard_getLastErrorHtml (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getLastErrorHtml(_map(17, 'CkSCard_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkSCard__lastErrorHtml (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__lastErrorHtml(_map(18, 'CkSCard__lastErrorHtml'))
    (objHandle);
end;

procedure CkSCard_getLastErrorText (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getLastErrorText(_map(19, 'CkSCard_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkSCard__lastErrorText (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__lastErrorText(_map(20, 'CkSCard__lastErrorText'))
    (objHandle);
end;

procedure CkSCard_getLastErrorXml (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getLastErrorXml(_map(21, 'CkSCard_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkSCard__lastErrorXml (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__lastErrorXml(_map(22, 'CkSCard__lastErrorXml'))
    (objHandle);
end;

function CkSCard_getLastMethodSuccess (objHandle: HCkSCard): wordbool;
begin
    result := TCkSCard_getLastMethodSuccess(_map(23, 'CkSCard_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkSCard_putLastMethodSuccess (objHandle: HCkSCard; newPropVal: wordbool);
begin
  TCkSCard_putLastMethodSuccess(_map(24, 'CkSCard_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkSCard_getPcscLibPath (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getPcscLibPath(_map(25, 'CkSCard_getPcscLibPath'))
    (objHandle, outPropVal);
end;

procedure CkSCard_putPcscLibPath (objHandle: HCkSCard; newPropVal: PWideChar);
begin
  TCkSCard_putPcscLibPath(_map(26, 'CkSCard_putPcscLibPath'))
    (objHandle, newPropVal);
end;

function CkSCard__pcscLibPath (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__pcscLibPath(_map(27, 'CkSCard__pcscLibPath'))
    (objHandle);
end;

procedure CkSCard_getReaderStatus (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getReaderStatus(_map(28, 'CkSCard_getReaderStatus'))
    (objHandle, outPropVal);
end;

function CkSCard__readerStatus (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__readerStatus(_map(29, 'CkSCard__readerStatus'))
    (objHandle);
end;

procedure CkSCard_getScardError (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getScardError(_map(30, 'CkSCard_getScardError'))
    (objHandle, outPropVal);
end;

function CkSCard__scardError (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__scardError(_map(31, 'CkSCard__scardError'))
    (objHandle);
end;

function CkSCard_getVerboseLogging (objHandle: HCkSCard): wordbool;
begin
    result := TCkSCard_getVerboseLogging(_map(32, 'CkSCard_getVerboseLogging'))
    (objHandle);
end;

procedure CkSCard_putVerboseLogging (objHandle: HCkSCard; newPropVal: wordbool);
begin
  TCkSCard_putVerboseLogging(_map(33, 'CkSCard_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkSCard_getVersion (objHandle: HCkSCard; outPropVal: HCkString);
begin
  TCkSCard_getVersion(_map(34, 'CkSCard_getVersion'))
    (objHandle, outPropVal);
end;

function CkSCard__version (objHandle: HCkSCard): PWideChar;
begin
  result := TCkSCard__version(_map(35, 'CkSCard__version'))
    (objHandle);
end;

function CkSCard_BeginTransaction (objHandle: HCkSCard): wordbool;
begin
  result := TCkSCard_BeginTransaction(_map(36, 'CkSCard_BeginTransaction'))
    (objHandle);
end;

function CkSCard_CheckStatus (objHandle: HCkSCard): wordbool;
begin
  result := TCkSCard_CheckStatus(_map(37, 'CkSCard_CheckStatus'))
    (objHandle);
end;

function CkSCard_Connect (objHandle: HCkSCard; reader: PWideChar; shareMode: PWideChar; preferredProtocol: PWideChar): wordbool;
begin
  result := TCkSCard_Connect(_map(38, 'CkSCard_Connect'))
    (objHandle, reader, shareMode, preferredProtocol);
end;

function CkSCard_Disconnect (objHandle: HCkSCard; disposition: PWideChar): wordbool;
begin
  result := TCkSCard_Disconnect(_map(39, 'CkSCard_Disconnect'))
    (objHandle, disposition);
end;

function CkSCard_EndTransaction (objHandle: HCkSCard; disposition: PWideChar): wordbool;
begin
  result := TCkSCard_EndTransaction(_map(40, 'CkSCard_EndTransaction'))
    (objHandle, disposition);
end;

function CkSCard_EstablishContext (objHandle: HCkSCard; scope: PWideChar): wordbool;
begin
  result := TCkSCard_EstablishContext(_map(41, 'CkSCard_EstablishContext'))
    (objHandle, scope);
end;

function CkSCard_FindSmartcards (objHandle: HCkSCard; json: HCkJsonObject): wordbool;
begin
  result := TCkSCard_FindSmartcards(_map(42, 'CkSCard_FindSmartcards'))
    (objHandle, json);
end;

function CkSCard_GetAttrib (objHandle: HCkSCard; attr: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkSCard_GetAttrib(_map(43, 'CkSCard_GetAttrib'))
    (objHandle, attr, bd);
end;

function CkSCard_GetAttribStr (objHandle: HCkSCard; attr: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSCard_GetAttribStr(_map(44, 'CkSCard_GetAttribStr'))
    (objHandle, attr, outStr);
end;

function CkSCard__getAttribStr (objHandle: HCkSCard; attr: PWideChar): PWideChar;
begin
  result := TCkSCard__getAttribStr(_map(45, 'CkSCard__getAttribStr'))
    (objHandle, attr);
end;

function CkSCard_GetAttribUint (objHandle: HCkSCard; attr: PWideChar): LongWord;
begin
  result := TCkSCard_GetAttribUint(_map(46, 'CkSCard_GetAttribUint'))
    (objHandle, attr);
end;

function CkSCard_GetStatusChange (objHandle: HCkSCard; maxWaitMs: Integer; stReaderNames: HCkStringTable; json: HCkJsonObject): wordbool;
begin
  result := TCkSCard_GetStatusChange(_map(47, 'CkSCard_GetStatusChange'))
    (objHandle, maxWaitMs, stReaderNames, json);
end;

function CkSCard_GetStatusChangeAsync (objHandle: HCkSCard; maxWaitMs: Integer; stReaderNames: HCkStringTable; json: HCkJsonObject): HCkTask;
begin
  result := TCkSCard_GetStatusChangeAsync(_map(48, 'CkSCard_GetStatusChangeAsync'))
    (objHandle, maxWaitMs, stReaderNames, json);
end;

function CkSCard_GetStatusChangeCancel (objHandle: HCkSCard): wordbool;
begin
  result := TCkSCard_GetStatusChangeCancel(_map(49, 'CkSCard_GetStatusChangeCancel'))
    (objHandle);
end;

function CkSCard_ListReaderGroups (objHandle: HCkSCard; readerGroups: HCkStringTable): wordbool;
begin
  result := TCkSCard_ListReaderGroups(_map(50, 'CkSCard_ListReaderGroups'))
    (objHandle, readerGroups);
end;

function CkSCard_ListReaders (objHandle: HCkSCard; st: HCkStringTable): wordbool;
begin
  result := TCkSCard_ListReaders(_map(51, 'CkSCard_ListReaders'))
    (objHandle, st);
end;

function CkSCard_Reconnect (objHandle: HCkSCard; shareMode: PWideChar; preferredProtocol: PWideChar; action: PWideChar): wordbool;
begin
  result := TCkSCard_Reconnect(_map(52, 'CkSCard_Reconnect'))
    (objHandle, shareMode, preferredProtocol, action);
end;

function CkSCard_ReleaseContext (objHandle: HCkSCard): wordbool;
begin
  result := TCkSCard_ReleaseContext(_map(53, 'CkSCard_ReleaseContext'))
    (objHandle);
end;

function CkSCard_SendControl (objHandle: HCkSCard; controlCode: LongWord; bdSend: HCkBinData; bdRecv: HCkBinData): wordbool;
begin
  result := TCkSCard_SendControl(_map(54, 'CkSCard_SendControl'))
    (objHandle, controlCode, bdSend, bdRecv);
end;

function CkSCard_SendControlHex (objHandle: HCkSCard; controlCode: LongWord; sendData: PWideChar; bdRecv: HCkBinData): wordbool;
begin
  result := TCkSCard_SendControlHex(_map(55, 'CkSCard_SendControlHex'))
    (objHandle, controlCode, sendData, bdRecv);
end;

function CkSCard_Transmit (objHandle: HCkSCard; protocol: PWideChar; bdSend: HCkBinData; bdRecv: HCkBinData; maxRecvLen: Integer): wordbool;
begin
  result := TCkSCard_Transmit(_map(56, 'CkSCard_Transmit'))
    (objHandle, protocol, bdSend, bdRecv, maxRecvLen);
end;

function CkSCard_TransmitHex (objHandle: HCkSCard; protocol: PWideChar; apduHex: PWideChar; bdRecv: HCkBinData; maxRecvLen: Integer): wordbool;
begin
  result := TCkSCard_TransmitHex(_map(57, 'CkSCard_TransmitHex'))
    (objHandle, protocol, apduHex, bdRecv, maxRecvLen);
end;

end.
