unit ScMinidriver;

interface

type

HCkPublicKey = Pointer;
HCkJsonObject = Pointer;
HCkPrivateKey = Pointer;
HCkString = Pointer;
HCkStringTable = Pointer;
HCkCert = Pointer;
HCkScMinidriver = Pointer;
HCkBinData = Pointer;


function CkScMinidriver_Create: HCkScMinidriver;  stdcall;
procedure CkScMinidriver_Dispose(handle: HCkScMinidriver); stdcall;
procedure CkScMinidriver_getAtr(objHandle: HCkScMinidriver; outPropVal: HCkString);
function CkScMinidriver__atr(objHandle: HCkScMinidriver): PWideChar;
procedure CkScMinidriver_getCardName(objHandle: HCkScMinidriver; outPropVal: HCkString);
function CkScMinidriver__cardName(objHandle: HCkScMinidriver): PWideChar;
procedure CkScMinidriver_getDebugLogFilePath(objHandle: HCkScMinidriver; outPropVal: HCkString);
procedure CkScMinidriver_putDebugLogFilePath(objHandle: HCkScMinidriver; newPropVal: PWideChar);
function CkScMinidriver__debugLogFilePath(objHandle: HCkScMinidriver): PWideChar;
procedure CkScMinidriver_getLastErrorHtml(objHandle: HCkScMinidriver; outPropVal: HCkString);
function CkScMinidriver__lastErrorHtml(objHandle: HCkScMinidriver): PWideChar;
procedure CkScMinidriver_getLastErrorText(objHandle: HCkScMinidriver; outPropVal: HCkString);
function CkScMinidriver__lastErrorText(objHandle: HCkScMinidriver): PWideChar;
procedure CkScMinidriver_getLastErrorXml(objHandle: HCkScMinidriver; outPropVal: HCkString);
function CkScMinidriver__lastErrorXml(objHandle: HCkScMinidriver): PWideChar;
function CkScMinidriver_getLastMethodSuccess(objHandle: HCkScMinidriver): wordbool;
procedure CkScMinidriver_putLastMethodSuccess(objHandle: HCkScMinidriver; newPropVal: wordbool);
function CkScMinidriver_getMaxContainers(objHandle: HCkScMinidriver): Integer;
procedure CkScMinidriver_getRsaPaddingHash(objHandle: HCkScMinidriver; outPropVal: HCkString);
procedure CkScMinidriver_putRsaPaddingHash(objHandle: HCkScMinidriver; newPropVal: PWideChar);
function CkScMinidriver__rsaPaddingHash(objHandle: HCkScMinidriver): PWideChar;
procedure CkScMinidriver_getRsaPaddingScheme(objHandle: HCkScMinidriver; outPropVal: HCkString);
procedure CkScMinidriver_putRsaPaddingScheme(objHandle: HCkScMinidriver; newPropVal: PWideChar);
function CkScMinidriver__rsaPaddingScheme(objHandle: HCkScMinidriver): PWideChar;
procedure CkScMinidriver_getUncommonOptions(objHandle: HCkScMinidriver; outPropVal: HCkString);
procedure CkScMinidriver_putUncommonOptions(objHandle: HCkScMinidriver; newPropVal: PWideChar);
function CkScMinidriver__uncommonOptions(objHandle: HCkScMinidriver): PWideChar;
function CkScMinidriver_getVerboseLogging(objHandle: HCkScMinidriver): wordbool;
procedure CkScMinidriver_putVerboseLogging(objHandle: HCkScMinidriver; newPropVal: wordbool);
procedure CkScMinidriver_getVersion(objHandle: HCkScMinidriver; outPropVal: HCkString);
function CkScMinidriver__version(objHandle: HCkScMinidriver): PWideChar;
function CkScMinidriver_AcquireContext(objHandle: HCkScMinidriver; readerName: PWideChar): wordbool;
function CkScMinidriver_CardDeleteFile(objHandle: HCkScMinidriver; dirName: PWideChar; fileName: PWideChar): wordbool;
function CkScMinidriver_DeleteCert(objHandle: HCkScMinidriver; cert: HCkCert; delPrivKey: wordbool): wordbool;
function CkScMinidriver_DeleteContext(objHandle: HCkScMinidriver): wordbool;
function CkScMinidriver_DeleteKeyContainer(objHandle: HCkScMinidriver; containerIndex: Integer): wordbool;
function CkScMinidriver_EnumFiles(objHandle: HCkScMinidriver; dirName: PWideChar; st: HCkStringTable): wordbool;
function CkScMinidriver_FindCert(objHandle: HCkScMinidriver; certPart: PWideChar; partValue: PWideChar; cert: HCkCert): wordbool;
function CkScMinidriver_GenerateKey(objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; keyType: PWideChar; keySize: Integer; pinId: PWideChar): wordbool;
function CkScMinidriver_GetCardProperties(objHandle: HCkScMinidriver; json: HCkJsonObject): wordbool;
function CkScMinidriver_GetCert(objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; cert: HCkCert): wordbool;
function CkScMinidriver_GetContainerKeys(objHandle: HCkScMinidriver; containerIndex: Integer; sigKey: HCkPublicKey; kexKey: HCkPublicKey): wordbool;
function CkScMinidriver_GetCspContainerMap(objHandle: HCkScMinidriver; json: HCkJsonObject): wordbool;
function CkScMinidriver_ImportCert(objHandle: HCkScMinidriver; cert: HCkCert; containerIndex: Integer; keySpec: PWideChar; pinId: PWideChar): wordbool;
function CkScMinidriver_ImportKey(objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; privKey: HCkPrivateKey; pinId: PWideChar): wordbool;
function CkScMinidriver_ListCerts(objHandle: HCkScMinidriver; certPart: PWideChar; st: HCkStringTable): wordbool;
function CkScMinidriver_PinAuthenticate(objHandle: HCkScMinidriver; pinId: PWideChar; pin: PWideChar): Integer;
function CkScMinidriver_PinAuthenticateHex(objHandle: HCkScMinidriver; pinId: PWideChar; pin: PWideChar): Integer;
function CkScMinidriver_PinChange(objHandle: HCkScMinidriver; pinId: PWideChar; currentPin: PWideChar; newPin: PWideChar): Integer;
function CkScMinidriver_PinDeauthenticate(objHandle: HCkScMinidriver; pinId: PWideChar): wordbool;
function CkScMinidriver_ReadFile(objHandle: HCkScMinidriver; dirName: PWideChar; fileName: PWideChar; bd: HCkBinData): wordbool;
function CkScMinidriver_SignData(objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; hashDataAlg: PWideChar; bdData: HCkBinData; bdSignedData: HCkBinData): wordbool;
function CkScMinidriver_WriteFile(objHandle: HCkScMinidriver; dirName: PWideChar; fileName: PWideChar; bd: HCkBinData): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkScMinidriver_Create = function : HCkScMinidriver; stdcall;
  TCkScMinidriver_Dispose = procedure (handle: HCkScMinidriver); stdcall;
  TCkScMinidriver_getAtr = procedure (objHandle: HCkScMinidriver; outPropVal: HCkString); stdcall;
  TCkScMinidriver__atr = function (objHandle: HCkScMinidriver): PWideChar; stdcall;
  TCkScMinidriver_getCardName = procedure (objHandle: HCkScMinidriver; outPropVal: HCkString); stdcall;
  TCkScMinidriver__cardName = function (objHandle: HCkScMinidriver): PWideChar; stdcall;
  TCkScMinidriver_getDebugLogFilePath = procedure (objHandle: HCkScMinidriver; outPropVal: HCkString); stdcall;
  TCkScMinidriver_putDebugLogFilePath = procedure (objHandle: HCkScMinidriver; newPropVal: PWideChar); stdcall;
  TCkScMinidriver__debugLogFilePath = function (objHandle: HCkScMinidriver): PWideChar; stdcall;
  TCkScMinidriver_getLastErrorHtml = procedure (objHandle: HCkScMinidriver; outPropVal: HCkString); stdcall;
  TCkScMinidriver__lastErrorHtml = function (objHandle: HCkScMinidriver): PWideChar; stdcall;
  TCkScMinidriver_getLastErrorText = procedure (objHandle: HCkScMinidriver; outPropVal: HCkString); stdcall;
  TCkScMinidriver__lastErrorText = function (objHandle: HCkScMinidriver): PWideChar; stdcall;
  TCkScMinidriver_getLastErrorXml = procedure (objHandle: HCkScMinidriver; outPropVal: HCkString); stdcall;
  TCkScMinidriver__lastErrorXml = function (objHandle: HCkScMinidriver): PWideChar; stdcall;
  TCkScMinidriver_getLastMethodSuccess = function (objHandle: HCkScMinidriver): wordbool; stdcall;
  TCkScMinidriver_putLastMethodSuccess = procedure (objHandle: HCkScMinidriver; newPropVal: wordbool); stdcall;
  TCkScMinidriver_getMaxContainers = function (objHandle: HCkScMinidriver): Integer; stdcall;
  TCkScMinidriver_getRsaPaddingHash = procedure (objHandle: HCkScMinidriver; outPropVal: HCkString); stdcall;
  TCkScMinidriver_putRsaPaddingHash = procedure (objHandle: HCkScMinidriver; newPropVal: PWideChar); stdcall;
  TCkScMinidriver__rsaPaddingHash = function (objHandle: HCkScMinidriver): PWideChar; stdcall;
  TCkScMinidriver_getRsaPaddingScheme = procedure (objHandle: HCkScMinidriver; outPropVal: HCkString); stdcall;
  TCkScMinidriver_putRsaPaddingScheme = procedure (objHandle: HCkScMinidriver; newPropVal: PWideChar); stdcall;
  TCkScMinidriver__rsaPaddingScheme = function (objHandle: HCkScMinidriver): PWideChar; stdcall;
  TCkScMinidriver_getUncommonOptions = procedure (objHandle: HCkScMinidriver; outPropVal: HCkString); stdcall;
  TCkScMinidriver_putUncommonOptions = procedure (objHandle: HCkScMinidriver; newPropVal: PWideChar); stdcall;
  TCkScMinidriver__uncommonOptions = function (objHandle: HCkScMinidriver): PWideChar; stdcall;
  TCkScMinidriver_getVerboseLogging = function (objHandle: HCkScMinidriver): wordbool; stdcall;
  TCkScMinidriver_putVerboseLogging = procedure (objHandle: HCkScMinidriver; newPropVal: wordbool); stdcall;
  TCkScMinidriver_getVersion = procedure (objHandle: HCkScMinidriver; outPropVal: HCkString); stdcall;
  TCkScMinidriver__version = function (objHandle: HCkScMinidriver): PWideChar; stdcall;
  TCkScMinidriver_AcquireContext = function (objHandle: HCkScMinidriver; readerName: PWideChar): wordbool; stdcall;
  TCkScMinidriver_CardDeleteFile = function (objHandle: HCkScMinidriver; dirName: PWideChar; fileName: PWideChar): wordbool; stdcall;
  TCkScMinidriver_DeleteCert = function (objHandle: HCkScMinidriver; cert: HCkCert; delPrivKey: wordbool): wordbool; stdcall;
  TCkScMinidriver_DeleteContext = function (objHandle: HCkScMinidriver): wordbool; stdcall;
  TCkScMinidriver_DeleteKeyContainer = function (objHandle: HCkScMinidriver; containerIndex: Integer): wordbool; stdcall;
  TCkScMinidriver_EnumFiles = function (objHandle: HCkScMinidriver; dirName: PWideChar; st: HCkStringTable): wordbool; stdcall;
  TCkScMinidriver_FindCert = function (objHandle: HCkScMinidriver; certPart: PWideChar; partValue: PWideChar; cert: HCkCert): wordbool; stdcall;
  TCkScMinidriver_GenerateKey = function (objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; keyType: PWideChar; keySize: Integer; pinId: PWideChar): wordbool; stdcall;
  TCkScMinidriver_GetCardProperties = function (objHandle: HCkScMinidriver; json: HCkJsonObject): wordbool; stdcall;
  TCkScMinidriver_GetCert = function (objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; cert: HCkCert): wordbool; stdcall;
  TCkScMinidriver_GetContainerKeys = function (objHandle: HCkScMinidriver; containerIndex: Integer; sigKey: HCkPublicKey; kexKey: HCkPublicKey): wordbool; stdcall;
  TCkScMinidriver_GetCspContainerMap = function (objHandle: HCkScMinidriver; json: HCkJsonObject): wordbool; stdcall;
  TCkScMinidriver_ImportCert = function (objHandle: HCkScMinidriver; cert: HCkCert; containerIndex: Integer; keySpec: PWideChar; pinId: PWideChar): wordbool; stdcall;
  TCkScMinidriver_ImportKey = function (objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; privKey: HCkPrivateKey; pinId: PWideChar): wordbool; stdcall;
  TCkScMinidriver_ListCerts = function (objHandle: HCkScMinidriver; certPart: PWideChar; st: HCkStringTable): wordbool; stdcall;
  TCkScMinidriver_PinAuthenticate = function (objHandle: HCkScMinidriver; pinId: PWideChar; pin: PWideChar): Integer; stdcall;
  TCkScMinidriver_PinAuthenticateHex = function (objHandle: HCkScMinidriver; pinId: PWideChar; pin: PWideChar): Integer; stdcall;
  TCkScMinidriver_PinChange = function (objHandle: HCkScMinidriver; pinId: PWideChar; currentPin: PWideChar; newPin: PWideChar): Integer; stdcall;
  TCkScMinidriver_PinDeauthenticate = function (objHandle: HCkScMinidriver; pinId: PWideChar): wordbool; stdcall;
  TCkScMinidriver_ReadFile = function (objHandle: HCkScMinidriver; dirName: PWideChar; fileName: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkScMinidriver_SignData = function (objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; hashDataAlg: PWideChar; bdData: HCkBinData; bdSignedData: HCkBinData): wordbool; stdcall;
  TCkScMinidriver_WriteFile = function (objHandle: HCkScMinidriver; dirName: PWideChar; fileName: PWideChar; bd: HCkBinData): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..52] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkScMinidriver_Create : HCkScMinidriver;
begin
  result := TCkScMinidriver_Create(_map(0, 'CkScMinidriver_Create'));
end;

procedure CkScMinidriver_Dispose (handle: HCkScMinidriver);
begin
  TCkScMinidriver_Dispose(_map(1, 'CkScMinidriver_Dispose'))
    (handle);
end;


procedure CkScMinidriver_getAtr (objHandle: HCkScMinidriver; outPropVal: HCkString);
begin
  TCkScMinidriver_getAtr(_map(2, 'CkScMinidriver_getAtr'))
    (objHandle, outPropVal);
end;

function CkScMinidriver__atr (objHandle: HCkScMinidriver): PWideChar;
begin
  result := TCkScMinidriver__atr(_map(3, 'CkScMinidriver__atr'))
    (objHandle);
end;

procedure CkScMinidriver_getCardName (objHandle: HCkScMinidriver; outPropVal: HCkString);
begin
  TCkScMinidriver_getCardName(_map(4, 'CkScMinidriver_getCardName'))
    (objHandle, outPropVal);
end;

function CkScMinidriver__cardName (objHandle: HCkScMinidriver): PWideChar;
begin
  result := TCkScMinidriver__cardName(_map(5, 'CkScMinidriver__cardName'))
    (objHandle);
end;

procedure CkScMinidriver_getDebugLogFilePath (objHandle: HCkScMinidriver; outPropVal: HCkString);
begin
  TCkScMinidriver_getDebugLogFilePath(_map(6, 'CkScMinidriver_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkScMinidriver_putDebugLogFilePath (objHandle: HCkScMinidriver; newPropVal: PWideChar);
begin
  TCkScMinidriver_putDebugLogFilePath(_map(7, 'CkScMinidriver_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkScMinidriver__debugLogFilePath (objHandle: HCkScMinidriver): PWideChar;
begin
  result := TCkScMinidriver__debugLogFilePath(_map(8, 'CkScMinidriver__debugLogFilePath'))
    (objHandle);
end;

procedure CkScMinidriver_getLastErrorHtml (objHandle: HCkScMinidriver; outPropVal: HCkString);
begin
  TCkScMinidriver_getLastErrorHtml(_map(9, 'CkScMinidriver_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkScMinidriver__lastErrorHtml (objHandle: HCkScMinidriver): PWideChar;
begin
  result := TCkScMinidriver__lastErrorHtml(_map(10, 'CkScMinidriver__lastErrorHtml'))
    (objHandle);
end;

procedure CkScMinidriver_getLastErrorText (objHandle: HCkScMinidriver; outPropVal: HCkString);
begin
  TCkScMinidriver_getLastErrorText(_map(11, 'CkScMinidriver_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkScMinidriver__lastErrorText (objHandle: HCkScMinidriver): PWideChar;
begin
  result := TCkScMinidriver__lastErrorText(_map(12, 'CkScMinidriver__lastErrorText'))
    (objHandle);
end;

procedure CkScMinidriver_getLastErrorXml (objHandle: HCkScMinidriver; outPropVal: HCkString);
begin
  TCkScMinidriver_getLastErrorXml(_map(13, 'CkScMinidriver_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkScMinidriver__lastErrorXml (objHandle: HCkScMinidriver): PWideChar;
begin
  result := TCkScMinidriver__lastErrorXml(_map(14, 'CkScMinidriver__lastErrorXml'))
    (objHandle);
end;

function CkScMinidriver_getLastMethodSuccess (objHandle: HCkScMinidriver): wordbool;
begin
    result := TCkScMinidriver_getLastMethodSuccess(_map(15, 'CkScMinidriver_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkScMinidriver_putLastMethodSuccess (objHandle: HCkScMinidriver; newPropVal: wordbool);
begin
  TCkScMinidriver_putLastMethodSuccess(_map(16, 'CkScMinidriver_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkScMinidriver_getMaxContainers (objHandle: HCkScMinidriver): Integer;
begin
    result := TCkScMinidriver_getMaxContainers(_map(17, 'CkScMinidriver_getMaxContainers'))
    (objHandle);
end;

procedure CkScMinidriver_getRsaPaddingHash (objHandle: HCkScMinidriver; outPropVal: HCkString);
begin
  TCkScMinidriver_getRsaPaddingHash(_map(18, 'CkScMinidriver_getRsaPaddingHash'))
    (objHandle, outPropVal);
end;

procedure CkScMinidriver_putRsaPaddingHash (objHandle: HCkScMinidriver; newPropVal: PWideChar);
begin
  TCkScMinidriver_putRsaPaddingHash(_map(19, 'CkScMinidriver_putRsaPaddingHash'))
    (objHandle, newPropVal);
end;

function CkScMinidriver__rsaPaddingHash (objHandle: HCkScMinidriver): PWideChar;
begin
  result := TCkScMinidriver__rsaPaddingHash(_map(20, 'CkScMinidriver__rsaPaddingHash'))
    (objHandle);
end;

procedure CkScMinidriver_getRsaPaddingScheme (objHandle: HCkScMinidriver; outPropVal: HCkString);
begin
  TCkScMinidriver_getRsaPaddingScheme(_map(21, 'CkScMinidriver_getRsaPaddingScheme'))
    (objHandle, outPropVal);
end;

procedure CkScMinidriver_putRsaPaddingScheme (objHandle: HCkScMinidriver; newPropVal: PWideChar);
begin
  TCkScMinidriver_putRsaPaddingScheme(_map(22, 'CkScMinidriver_putRsaPaddingScheme'))
    (objHandle, newPropVal);
end;

function CkScMinidriver__rsaPaddingScheme (objHandle: HCkScMinidriver): PWideChar;
begin
  result := TCkScMinidriver__rsaPaddingScheme(_map(23, 'CkScMinidriver__rsaPaddingScheme'))
    (objHandle);
end;

procedure CkScMinidriver_getUncommonOptions (objHandle: HCkScMinidriver; outPropVal: HCkString);
begin
  TCkScMinidriver_getUncommonOptions(_map(24, 'CkScMinidriver_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkScMinidriver_putUncommonOptions (objHandle: HCkScMinidriver; newPropVal: PWideChar);
begin
  TCkScMinidriver_putUncommonOptions(_map(25, 'CkScMinidriver_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkScMinidriver__uncommonOptions (objHandle: HCkScMinidriver): PWideChar;
begin
  result := TCkScMinidriver__uncommonOptions(_map(26, 'CkScMinidriver__uncommonOptions'))
    (objHandle);
end;

function CkScMinidriver_getVerboseLogging (objHandle: HCkScMinidriver): wordbool;
begin
    result := TCkScMinidriver_getVerboseLogging(_map(27, 'CkScMinidriver_getVerboseLogging'))
    (objHandle);
end;

procedure CkScMinidriver_putVerboseLogging (objHandle: HCkScMinidriver; newPropVal: wordbool);
begin
  TCkScMinidriver_putVerboseLogging(_map(28, 'CkScMinidriver_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkScMinidriver_getVersion (objHandle: HCkScMinidriver; outPropVal: HCkString);
begin
  TCkScMinidriver_getVersion(_map(29, 'CkScMinidriver_getVersion'))
    (objHandle, outPropVal);
end;

function CkScMinidriver__version (objHandle: HCkScMinidriver): PWideChar;
begin
  result := TCkScMinidriver__version(_map(30, 'CkScMinidriver__version'))
    (objHandle);
end;

function CkScMinidriver_AcquireContext (objHandle: HCkScMinidriver; readerName: PWideChar): wordbool;
begin
  result := TCkScMinidriver_AcquireContext(_map(31, 'CkScMinidriver_AcquireContext'))
    (objHandle, readerName);
end;

function CkScMinidriver_CardDeleteFile (objHandle: HCkScMinidriver; dirName: PWideChar; fileName: PWideChar): wordbool;
begin
  result := TCkScMinidriver_CardDeleteFile(_map(32, 'CkScMinidriver_CardDeleteFile'))
    (objHandle, dirName, fileName);
end;

function CkScMinidriver_DeleteCert (objHandle: HCkScMinidriver; cert: HCkCert; delPrivKey: wordbool): wordbool;
begin
  result := TCkScMinidriver_DeleteCert(_map(33, 'CkScMinidriver_DeleteCert'))
    (objHandle, cert, delPrivKey);
end;

function CkScMinidriver_DeleteContext (objHandle: HCkScMinidriver): wordbool;
begin
  result := TCkScMinidriver_DeleteContext(_map(34, 'CkScMinidriver_DeleteContext'))
    (objHandle);
end;

function CkScMinidriver_DeleteKeyContainer (objHandle: HCkScMinidriver; containerIndex: Integer): wordbool;
begin
  result := TCkScMinidriver_DeleteKeyContainer(_map(35, 'CkScMinidriver_DeleteKeyContainer'))
    (objHandle, containerIndex);
end;

function CkScMinidriver_EnumFiles (objHandle: HCkScMinidriver; dirName: PWideChar; st: HCkStringTable): wordbool;
begin
  result := TCkScMinidriver_EnumFiles(_map(36, 'CkScMinidriver_EnumFiles'))
    (objHandle, dirName, st);
end;

function CkScMinidriver_FindCert (objHandle: HCkScMinidriver; certPart: PWideChar; partValue: PWideChar; cert: HCkCert): wordbool;
begin
  result := TCkScMinidriver_FindCert(_map(37, 'CkScMinidriver_FindCert'))
    (objHandle, certPart, partValue, cert);
end;

function CkScMinidriver_GenerateKey (objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; keyType: PWideChar; keySize: Integer; pinId: PWideChar): wordbool;
begin
  result := TCkScMinidriver_GenerateKey(_map(38, 'CkScMinidriver_GenerateKey'))
    (objHandle, containerIndex, keySpec, keyType, keySize, pinId);
end;

function CkScMinidriver_GetCardProperties (objHandle: HCkScMinidriver; json: HCkJsonObject): wordbool;
begin
  result := TCkScMinidriver_GetCardProperties(_map(39, 'CkScMinidriver_GetCardProperties'))
    (objHandle, json);
end;

function CkScMinidriver_GetCert (objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; cert: HCkCert): wordbool;
begin
  result := TCkScMinidriver_GetCert(_map(40, 'CkScMinidriver_GetCert'))
    (objHandle, containerIndex, keySpec, cert);
end;

function CkScMinidriver_GetContainerKeys (objHandle: HCkScMinidriver; containerIndex: Integer; sigKey: HCkPublicKey; kexKey: HCkPublicKey): wordbool;
begin
  result := TCkScMinidriver_GetContainerKeys(_map(41, 'CkScMinidriver_GetContainerKeys'))
    (objHandle, containerIndex, sigKey, kexKey);
end;

function CkScMinidriver_GetCspContainerMap (objHandle: HCkScMinidriver; json: HCkJsonObject): wordbool;
begin
  result := TCkScMinidriver_GetCspContainerMap(_map(42, 'CkScMinidriver_GetCspContainerMap'))
    (objHandle, json);
end;

function CkScMinidriver_ImportCert (objHandle: HCkScMinidriver; cert: HCkCert; containerIndex: Integer; keySpec: PWideChar; pinId: PWideChar): wordbool;
begin
  result := TCkScMinidriver_ImportCert(_map(43, 'CkScMinidriver_ImportCert'))
    (objHandle, cert, containerIndex, keySpec, pinId);
end;

function CkScMinidriver_ImportKey (objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; privKey: HCkPrivateKey; pinId: PWideChar): wordbool;
begin
  result := TCkScMinidriver_ImportKey(_map(44, 'CkScMinidriver_ImportKey'))
    (objHandle, containerIndex, keySpec, privKey, pinId);
end;

function CkScMinidriver_ListCerts (objHandle: HCkScMinidriver; certPart: PWideChar; st: HCkStringTable): wordbool;
begin
  result := TCkScMinidriver_ListCerts(_map(45, 'CkScMinidriver_ListCerts'))
    (objHandle, certPart, st);
end;

function CkScMinidriver_PinAuthenticate (objHandle: HCkScMinidriver; pinId: PWideChar; pin: PWideChar): Integer;
begin
  result := TCkScMinidriver_PinAuthenticate(_map(46, 'CkScMinidriver_PinAuthenticate'))
    (objHandle, pinId, pin);
end;

function CkScMinidriver_PinAuthenticateHex (objHandle: HCkScMinidriver; pinId: PWideChar; pin: PWideChar): Integer;
begin
  result := TCkScMinidriver_PinAuthenticateHex(_map(47, 'CkScMinidriver_PinAuthenticateHex'))
    (objHandle, pinId, pin);
end;

function CkScMinidriver_PinChange (objHandle: HCkScMinidriver; pinId: PWideChar; currentPin: PWideChar; newPin: PWideChar): Integer;
begin
  result := TCkScMinidriver_PinChange(_map(48, 'CkScMinidriver_PinChange'))
    (objHandle, pinId, currentPin, newPin);
end;

function CkScMinidriver_PinDeauthenticate (objHandle: HCkScMinidriver; pinId: PWideChar): wordbool;
begin
  result := TCkScMinidriver_PinDeauthenticate(_map(49, 'CkScMinidriver_PinDeauthenticate'))
    (objHandle, pinId);
end;

function CkScMinidriver_ReadFile (objHandle: HCkScMinidriver; dirName: PWideChar; fileName: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkScMinidriver_ReadFile(_map(50, 'CkScMinidriver_ReadFile'))
    (objHandle, dirName, fileName, bd);
end;

function CkScMinidriver_SignData (objHandle: HCkScMinidriver; containerIndex: Integer; keySpec: PWideChar; hashDataAlg: PWideChar; bdData: HCkBinData; bdSignedData: HCkBinData): wordbool;
begin
  result := TCkScMinidriver_SignData(_map(51, 'CkScMinidriver_SignData'))
    (objHandle, containerIndex, keySpec, hashDataAlg, bdData, bdSignedData);
end;

function CkScMinidriver_WriteFile (objHandle: HCkScMinidriver; dirName: PWideChar; fileName: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkScMinidriver_WriteFile(_map(52, 'CkScMinidriver_WriteFile'))
    (objHandle, dirName, fileName, bd);
end;

end.
