unit Secrets;

interface

type

HCkJsonObject = Pointer;
HCkString = Pointer;
HCkSecrets = Pointer;
HCkStringBuilder = Pointer;
HCkTask = Pointer;
HCkBinData = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TSecretsAbortCheck = function(): Integer; cdecl;
TSecretsProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TSecretsPercentDone = function(pctDone: Integer): Integer; cdecl;
TSecretsTaskCompleted = procedure(task: HCkTask); cdecl;


function CkSecrets_Create: HCkSecrets;  stdcall;
procedure CkSecrets_Dispose(handle: HCkSecrets); stdcall;

procedure CkSecrets_SetAbortCheck(objHandle: HCkSecrets; fn: TSecretsAbortCheck) stdcall;
procedure CkSecrets_SetProgressInfo(objHandle: HCkSecrets; fn: TSecretsProgressInfo) stdcall;
procedure CkSecrets_SetPercentDone(objHandle: HCkSecrets; fn: TSecretsPercentDone) stdcall;
procedure CkSecrets_SetTaskCompleted(objHandle: HCkSecrets; fn: TSecretsTaskCompleted) stdcall;
function CkSecrets_getAutoSplit(objHandle: HCkSecrets): wordbool;
procedure CkSecrets_putAutoSplit(objHandle: HCkSecrets; newPropVal: wordbool);
function CkSecrets_getCompression(objHandle: HCkSecrets): wordbool;
procedure CkSecrets_putCompression(objHandle: HCkSecrets; newPropVal: wordbool);
procedure CkSecrets_getDebugLogFilePath(objHandle: HCkSecrets; outPropVal: HCkString);
procedure CkSecrets_putDebugLogFilePath(objHandle: HCkSecrets; newPropVal: PWideChar);
function CkSecrets__debugLogFilePath(objHandle: HCkSecrets): PWideChar;
procedure CkSecrets_getLastErrorHtml(objHandle: HCkSecrets; outPropVal: HCkString);
function CkSecrets__lastErrorHtml(objHandle: HCkSecrets): PWideChar;
procedure CkSecrets_getLastErrorText(objHandle: HCkSecrets; outPropVal: HCkString);
function CkSecrets__lastErrorText(objHandle: HCkSecrets): PWideChar;
procedure CkSecrets_getLastErrorXml(objHandle: HCkSecrets; outPropVal: HCkString);
function CkSecrets__lastErrorXml(objHandle: HCkSecrets): PWideChar;
function CkSecrets_getLastMethodSuccess(objHandle: HCkSecrets): wordbool;
procedure CkSecrets_putLastMethodSuccess(objHandle: HCkSecrets; newPropVal: wordbool);
procedure CkSecrets_getLocation(objHandle: HCkSecrets; outPropVal: HCkString);
procedure CkSecrets_putLocation(objHandle: HCkSecrets; newPropVal: PWideChar);
function CkSecrets__location(objHandle: HCkSecrets): PWideChar;
procedure CkSecrets_getUncommonOptions(objHandle: HCkSecrets; outPropVal: HCkString);
procedure CkSecrets_putUncommonOptions(objHandle: HCkSecrets; newPropVal: PWideChar);
function CkSecrets__uncommonOptions(objHandle: HCkSecrets): PWideChar;
function CkSecrets_getVerboseLogging(objHandle: HCkSecrets): wordbool;
procedure CkSecrets_putVerboseLogging(objHandle: HCkSecrets; newPropVal: wordbool);
procedure CkSecrets_getVersion(objHandle: HCkSecrets; outPropVal: HCkString);
function CkSecrets__version(objHandle: HCkSecrets): PWideChar;
function CkSecrets_DeleteSecret(objHandle: HCkSecrets; jsonId: HCkJsonObject): wordbool;
function CkSecrets_DeleteSecretAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject): HCkTask;
function CkSecrets_GetSecretBd(objHandle: HCkSecrets; jsonId: HCkJsonObject; bd: HCkBinData): wordbool;
function CkSecrets_GetSecretBdAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; bd: HCkBinData): HCkTask;
function CkSecrets_GetSecretJson(objHandle: HCkSecrets; jsonId: HCkJsonObject; jsonOut: HCkJsonObject): wordbool;
function CkSecrets_GetSecretJsonAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask;
function CkSecrets_GetSecretSb(objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): wordbool;
function CkSecrets_GetSecretSbAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): HCkTask;
function CkSecrets_GetSecretStr(objHandle: HCkSecrets; jsonId: HCkJsonObject; outStr: HCkString): wordbool;
function CkSecrets__getSecretStr(objHandle: HCkSecrets; jsonId: HCkJsonObject): PWideChar;
function CkSecrets_GetSecretStrAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject): HCkTask;
function CkSecrets_ListSecrets(objHandle: HCkSecrets; json: HCkJsonObject; jsonOut: HCkJsonObject): wordbool;
function CkSecrets_ListSecretsAsync(objHandle: HCkSecrets; json: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask;
function CkSecrets_SetBootstrapSecret(objHandle: HCkSecrets; jsonId: HCkJsonObject; secretContent: HCkSecrets): wordbool;
function CkSecrets_UpdateSecretBd(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkBinData): wordbool;
function CkSecrets_UpdateSecretBdAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkBinData): HCkTask;
function CkSecrets_UpdateSecretJson(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkJsonObject): wordbool;
function CkSecrets_UpdateSecretJsonAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkJsonObject): HCkTask;
function CkSecrets_UpdateSecretSb(objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): wordbool;
function CkSecrets_UpdateSecretSbAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): HCkTask;
function CkSecrets_UpdateSecretStr(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: PWideChar): wordbool;
function CkSecrets_UpdateSecretStrAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: PWideChar): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkSecrets_Create = function : HCkSecrets; stdcall;
  TCkSecrets_Dispose = procedure (handle: HCkSecrets); stdcall;
  TCkSecrets_SetAbortCheck = procedure (objHandle: HCkSecrets; fn: TSecretsAbortCheck); stdcall;
  TCkSecrets_SetProgressInfo = procedure (objHandle: HCkSecrets; fn: TSecretsProgressInfo); stdcall;
  TCkSecrets_SetPercentDone = procedure (objHandle: HCkSecrets; fn: TSecretsPercentDone); stdcall;
  TCkSecrets_SetTaskCompleted = procedure (objHandle: HCkSecrets; fn: TSecretsTaskCompleted); stdcall;
  TCkSecrets_getAutoSplit = function (objHandle: HCkSecrets): wordbool; stdcall;
  TCkSecrets_putAutoSplit = procedure (objHandle: HCkSecrets; newPropVal: wordbool); stdcall;
  TCkSecrets_getCompression = function (objHandle: HCkSecrets): wordbool; stdcall;
  TCkSecrets_putCompression = procedure (objHandle: HCkSecrets; newPropVal: wordbool); stdcall;
  TCkSecrets_getDebugLogFilePath = procedure (objHandle: HCkSecrets; outPropVal: HCkString); stdcall;
  TCkSecrets_putDebugLogFilePath = procedure (objHandle: HCkSecrets; newPropVal: PWideChar); stdcall;
  TCkSecrets__debugLogFilePath = function (objHandle: HCkSecrets): PWideChar; stdcall;
  TCkSecrets_getLastErrorHtml = procedure (objHandle: HCkSecrets; outPropVal: HCkString); stdcall;
  TCkSecrets__lastErrorHtml = function (objHandle: HCkSecrets): PWideChar; stdcall;
  TCkSecrets_getLastErrorText = procedure (objHandle: HCkSecrets; outPropVal: HCkString); stdcall;
  TCkSecrets__lastErrorText = function (objHandle: HCkSecrets): PWideChar; stdcall;
  TCkSecrets_getLastErrorXml = procedure (objHandle: HCkSecrets; outPropVal: HCkString); stdcall;
  TCkSecrets__lastErrorXml = function (objHandle: HCkSecrets): PWideChar; stdcall;
  TCkSecrets_getLastMethodSuccess = function (objHandle: HCkSecrets): wordbool; stdcall;
  TCkSecrets_putLastMethodSuccess = procedure (objHandle: HCkSecrets; newPropVal: wordbool); stdcall;
  TCkSecrets_getLocation = procedure (objHandle: HCkSecrets; outPropVal: HCkString); stdcall;
  TCkSecrets_putLocation = procedure (objHandle: HCkSecrets; newPropVal: PWideChar); stdcall;
  TCkSecrets__location = function (objHandle: HCkSecrets): PWideChar; stdcall;
  TCkSecrets_getUncommonOptions = procedure (objHandle: HCkSecrets; outPropVal: HCkString); stdcall;
  TCkSecrets_putUncommonOptions = procedure (objHandle: HCkSecrets; newPropVal: PWideChar); stdcall;
  TCkSecrets__uncommonOptions = function (objHandle: HCkSecrets): PWideChar; stdcall;
  TCkSecrets_getVerboseLogging = function (objHandle: HCkSecrets): wordbool; stdcall;
  TCkSecrets_putVerboseLogging = procedure (objHandle: HCkSecrets; newPropVal: wordbool); stdcall;
  TCkSecrets_getVersion = procedure (objHandle: HCkSecrets; outPropVal: HCkString); stdcall;
  TCkSecrets__version = function (objHandle: HCkSecrets): PWideChar; stdcall;
  TCkSecrets_DeleteSecret = function (objHandle: HCkSecrets; jsonId: HCkJsonObject): wordbool; stdcall;
  TCkSecrets_DeleteSecretAsync = function (objHandle: HCkSecrets; jsonId: HCkJsonObject): HCkTask; stdcall;
  TCkSecrets_GetSecretBd = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; bd: HCkBinData): wordbool; stdcall;
  TCkSecrets_GetSecretBdAsync = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; bd: HCkBinData): HCkTask; stdcall;
  TCkSecrets_GetSecretJson = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; jsonOut: HCkJsonObject): wordbool; stdcall;
  TCkSecrets_GetSecretJsonAsync = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask; stdcall;
  TCkSecrets_GetSecretSb = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): wordbool; stdcall;
  TCkSecrets_GetSecretSbAsync = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkSecrets_GetSecretStr = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; outStr: HCkString): wordbool; stdcall;
  TCkSecrets__getSecretStr = function (objHandle: HCkSecrets; jsonId: HCkJsonObject): PWideChar; stdcall;
  TCkSecrets_GetSecretStrAsync = function (objHandle: HCkSecrets; jsonId: HCkJsonObject): HCkTask; stdcall;
  TCkSecrets_ListSecrets = function (objHandle: HCkSecrets; json: HCkJsonObject; jsonOut: HCkJsonObject): wordbool; stdcall;
  TCkSecrets_ListSecretsAsync = function (objHandle: HCkSecrets; json: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask; stdcall;
  TCkSecrets_SetBootstrapSecret = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; secretContent: HCkSecrets): wordbool; stdcall;
  TCkSecrets_UpdateSecretBd = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkBinData): wordbool; stdcall;
  TCkSecrets_UpdateSecretBdAsync = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkBinData): HCkTask; stdcall;
  TCkSecrets_UpdateSecretJson = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkJsonObject): wordbool; stdcall;
  TCkSecrets_UpdateSecretJsonAsync = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkJsonObject): HCkTask; stdcall;
  TCkSecrets_UpdateSecretSb = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): wordbool; stdcall;
  TCkSecrets_UpdateSecretSbAsync = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkSecrets_UpdateSecretStr = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: PWideChar): wordbool; stdcall;
  TCkSecrets_UpdateSecretStrAsync = function (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: PWideChar): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..52] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkSecrets_Create : HCkSecrets;
begin
  result := TCkSecrets_Create(_map(0, 'CkSecrets_Create'));
end;

procedure CkSecrets_Dispose (handle: HCkSecrets);
begin
  TCkSecrets_Dispose(_map(1, 'CkSecrets_Dispose'))
    (handle);
end;


procedure CkSecrets_SetAbortCheck (objHandle: HCkSecrets; fn: TSecretsAbortCheck);
begin
    TCkSecrets_SetAbortCheck(_map(2, 'CkSecrets_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkSecrets_SetProgressInfo (objHandle: HCkSecrets; fn: TSecretsProgressInfo);
begin
    TCkSecrets_SetProgressInfo(_map(3, 'CkSecrets_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkSecrets_SetPercentDone (objHandle: HCkSecrets; fn: TSecretsPercentDone);
begin
    TCkSecrets_SetPercentDone(_map(4, 'CkSecrets_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkSecrets_SetTaskCompleted (objHandle: HCkSecrets; fn: TSecretsTaskCompleted);
begin
    TCkSecrets_SetTaskCompleted(_map(5, 'CkSecrets_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkSecrets_getAutoSplit (objHandle: HCkSecrets): wordbool;
begin
    result := TCkSecrets_getAutoSplit(_map(6, 'CkSecrets_getAutoSplit'))
    (objHandle);
end;

procedure CkSecrets_putAutoSplit (objHandle: HCkSecrets; newPropVal: wordbool);
begin
  TCkSecrets_putAutoSplit(_map(7, 'CkSecrets_putAutoSplit'))
    (objHandle, newPropVal);
end;

function CkSecrets_getCompression (objHandle: HCkSecrets): wordbool;
begin
    result := TCkSecrets_getCompression(_map(8, 'CkSecrets_getCompression'))
    (objHandle);
end;

procedure CkSecrets_putCompression (objHandle: HCkSecrets; newPropVal: wordbool);
begin
  TCkSecrets_putCompression(_map(9, 'CkSecrets_putCompression'))
    (objHandle, newPropVal);
end;

procedure CkSecrets_getDebugLogFilePath (objHandle: HCkSecrets; outPropVal: HCkString);
begin
  TCkSecrets_getDebugLogFilePath(_map(10, 'CkSecrets_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkSecrets_putDebugLogFilePath (objHandle: HCkSecrets; newPropVal: PWideChar);
begin
  TCkSecrets_putDebugLogFilePath(_map(11, 'CkSecrets_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkSecrets__debugLogFilePath (objHandle: HCkSecrets): PWideChar;
begin
  result := TCkSecrets__debugLogFilePath(_map(12, 'CkSecrets__debugLogFilePath'))
    (objHandle);
end;

procedure CkSecrets_getLastErrorHtml (objHandle: HCkSecrets; outPropVal: HCkString);
begin
  TCkSecrets_getLastErrorHtml(_map(13, 'CkSecrets_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkSecrets__lastErrorHtml (objHandle: HCkSecrets): PWideChar;
begin
  result := TCkSecrets__lastErrorHtml(_map(14, 'CkSecrets__lastErrorHtml'))
    (objHandle);
end;

procedure CkSecrets_getLastErrorText (objHandle: HCkSecrets; outPropVal: HCkString);
begin
  TCkSecrets_getLastErrorText(_map(15, 'CkSecrets_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkSecrets__lastErrorText (objHandle: HCkSecrets): PWideChar;
begin
  result := TCkSecrets__lastErrorText(_map(16, 'CkSecrets__lastErrorText'))
    (objHandle);
end;

procedure CkSecrets_getLastErrorXml (objHandle: HCkSecrets; outPropVal: HCkString);
begin
  TCkSecrets_getLastErrorXml(_map(17, 'CkSecrets_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkSecrets__lastErrorXml (objHandle: HCkSecrets): PWideChar;
begin
  result := TCkSecrets__lastErrorXml(_map(18, 'CkSecrets__lastErrorXml'))
    (objHandle);
end;

function CkSecrets_getLastMethodSuccess (objHandle: HCkSecrets): wordbool;
begin
    result := TCkSecrets_getLastMethodSuccess(_map(19, 'CkSecrets_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkSecrets_putLastMethodSuccess (objHandle: HCkSecrets; newPropVal: wordbool);
begin
  TCkSecrets_putLastMethodSuccess(_map(20, 'CkSecrets_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkSecrets_getLocation (objHandle: HCkSecrets; outPropVal: HCkString);
begin
  TCkSecrets_getLocation(_map(21, 'CkSecrets_getLocation'))
    (objHandle, outPropVal);
end;

procedure CkSecrets_putLocation (objHandle: HCkSecrets; newPropVal: PWideChar);
begin
  TCkSecrets_putLocation(_map(22, 'CkSecrets_putLocation'))
    (objHandle, newPropVal);
end;

function CkSecrets__location (objHandle: HCkSecrets): PWideChar;
begin
  result := TCkSecrets__location(_map(23, 'CkSecrets__location'))
    (objHandle);
end;

procedure CkSecrets_getUncommonOptions (objHandle: HCkSecrets; outPropVal: HCkString);
begin
  TCkSecrets_getUncommonOptions(_map(24, 'CkSecrets_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkSecrets_putUncommonOptions (objHandle: HCkSecrets; newPropVal: PWideChar);
begin
  TCkSecrets_putUncommonOptions(_map(25, 'CkSecrets_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkSecrets__uncommonOptions (objHandle: HCkSecrets): PWideChar;
begin
  result := TCkSecrets__uncommonOptions(_map(26, 'CkSecrets__uncommonOptions'))
    (objHandle);
end;

function CkSecrets_getVerboseLogging (objHandle: HCkSecrets): wordbool;
begin
    result := TCkSecrets_getVerboseLogging(_map(27, 'CkSecrets_getVerboseLogging'))
    (objHandle);
end;

procedure CkSecrets_putVerboseLogging (objHandle: HCkSecrets; newPropVal: wordbool);
begin
  TCkSecrets_putVerboseLogging(_map(28, 'CkSecrets_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkSecrets_getVersion (objHandle: HCkSecrets; outPropVal: HCkString);
begin
  TCkSecrets_getVersion(_map(29, 'CkSecrets_getVersion'))
    (objHandle, outPropVal);
end;

function CkSecrets__version (objHandle: HCkSecrets): PWideChar;
begin
  result := TCkSecrets__version(_map(30, 'CkSecrets__version'))
    (objHandle);
end;

function CkSecrets_DeleteSecret (objHandle: HCkSecrets; jsonId: HCkJsonObject): wordbool;
begin
  result := TCkSecrets_DeleteSecret(_map(31, 'CkSecrets_DeleteSecret'))
    (objHandle, jsonId);
end;

function CkSecrets_DeleteSecretAsync (objHandle: HCkSecrets; jsonId: HCkJsonObject): HCkTask;
begin
  result := TCkSecrets_DeleteSecretAsync(_map(32, 'CkSecrets_DeleteSecretAsync'))
    (objHandle, jsonId);
end;

function CkSecrets_GetSecretBd (objHandle: HCkSecrets; jsonId: HCkJsonObject; bd: HCkBinData): wordbool;
begin
  result := TCkSecrets_GetSecretBd(_map(33, 'CkSecrets_GetSecretBd'))
    (objHandle, jsonId, bd);
end;

function CkSecrets_GetSecretBdAsync (objHandle: HCkSecrets; jsonId: HCkJsonObject; bd: HCkBinData): HCkTask;
begin
  result := TCkSecrets_GetSecretBdAsync(_map(34, 'CkSecrets_GetSecretBdAsync'))
    (objHandle, jsonId, bd);
end;

function CkSecrets_GetSecretJson (objHandle: HCkSecrets; jsonId: HCkJsonObject; jsonOut: HCkJsonObject): wordbool;
begin
  result := TCkSecrets_GetSecretJson(_map(35, 'CkSecrets_GetSecretJson'))
    (objHandle, jsonId, jsonOut);
end;

function CkSecrets_GetSecretJsonAsync (objHandle: HCkSecrets; jsonId: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask;
begin
  result := TCkSecrets_GetSecretJsonAsync(_map(36, 'CkSecrets_GetSecretJsonAsync'))
    (objHandle, jsonId, jsonOut);
end;

function CkSecrets_GetSecretSb (objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): wordbool;
begin
  result := TCkSecrets_GetSecretSb(_map(37, 'CkSecrets_GetSecretSb'))
    (objHandle, jsonId, sb);
end;

function CkSecrets_GetSecretSbAsync (objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkSecrets_GetSecretSbAsync(_map(38, 'CkSecrets_GetSecretSbAsync'))
    (objHandle, jsonId, sb);
end;

function CkSecrets_GetSecretStr (objHandle: HCkSecrets; jsonId: HCkJsonObject; outStr: HCkString): wordbool;
begin
  result := TCkSecrets_GetSecretStr(_map(39, 'CkSecrets_GetSecretStr'))
    (objHandle, jsonId, outStr);
end;

function CkSecrets__getSecretStr (objHandle: HCkSecrets; jsonId: HCkJsonObject): PWideChar;
begin
  result := TCkSecrets__getSecretStr(_map(40, 'CkSecrets__getSecretStr'))
    (objHandle, jsonId);
end;

function CkSecrets_GetSecretStrAsync (objHandle: HCkSecrets; jsonId: HCkJsonObject): HCkTask;
begin
  result := TCkSecrets_GetSecretStrAsync(_map(41, 'CkSecrets_GetSecretStrAsync'))
    (objHandle, jsonId);
end;

function CkSecrets_ListSecrets (objHandle: HCkSecrets; json: HCkJsonObject; jsonOut: HCkJsonObject): wordbool;
begin
  result := TCkSecrets_ListSecrets(_map(42, 'CkSecrets_ListSecrets'))
    (objHandle, json, jsonOut);
end;

function CkSecrets_ListSecretsAsync (objHandle: HCkSecrets; json: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask;
begin
  result := TCkSecrets_ListSecretsAsync(_map(43, 'CkSecrets_ListSecretsAsync'))
    (objHandle, json, jsonOut);
end;

function CkSecrets_SetBootstrapSecret (objHandle: HCkSecrets; jsonId: HCkJsonObject; secretContent: HCkSecrets): wordbool;
begin
  result := TCkSecrets_SetBootstrapSecret(_map(44, 'CkSecrets_SetBootstrapSecret'))
    (objHandle, jsonId, secretContent);
end;

function CkSecrets_UpdateSecretBd (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkBinData): wordbool;
begin
  result := TCkSecrets_UpdateSecretBd(_map(45, 'CkSecrets_UpdateSecretBd'))
    (objHandle, jsonId, secret);
end;

function CkSecrets_UpdateSecretBdAsync (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkBinData): HCkTask;
begin
  result := TCkSecrets_UpdateSecretBdAsync(_map(46, 'CkSecrets_UpdateSecretBdAsync'))
    (objHandle, jsonId, secret);
end;

function CkSecrets_UpdateSecretJson (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkJsonObject): wordbool;
begin
  result := TCkSecrets_UpdateSecretJson(_map(47, 'CkSecrets_UpdateSecretJson'))
    (objHandle, jsonId, secret);
end;

function CkSecrets_UpdateSecretJsonAsync (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkJsonObject): HCkTask;
begin
  result := TCkSecrets_UpdateSecretJsonAsync(_map(48, 'CkSecrets_UpdateSecretJsonAsync'))
    (objHandle, jsonId, secret);
end;

function CkSecrets_UpdateSecretSb (objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): wordbool;
begin
  result := TCkSecrets_UpdateSecretSb(_map(49, 'CkSecrets_UpdateSecretSb'))
    (objHandle, jsonId, sb);
end;

function CkSecrets_UpdateSecretSbAsync (objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkSecrets_UpdateSecretSbAsync(_map(50, 'CkSecrets_UpdateSecretSbAsync'))
    (objHandle, jsonId, sb);
end;

function CkSecrets_UpdateSecretStr (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: PWideChar): wordbool;
begin
  result := TCkSecrets_UpdateSecretStr(_map(51, 'CkSecrets_UpdateSecretStr'))
    (objHandle, jsonId, secret);
end;

function CkSecrets_UpdateSecretStrAsync (objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: PWideChar): HCkTask;
begin
  result := TCkSecrets_UpdateSecretStrAsync(_map(52, 'CkSecrets_UpdateSecretStrAsync'))
    (objHandle, jsonId, secret);
end;

end.
