unit SecureString;

interface

type

HCkStringBuilder = Pointer;
HCkSecureString = Pointer;
HCkString = Pointer;


function CkSecureString_Create: HCkSecureString;  stdcall;
procedure CkSecureString_Dispose(handle: HCkSecureString); stdcall;
procedure CkSecureString_getDebugLogFilePath(objHandle: HCkSecureString; outPropVal: HCkString);
procedure CkSecureString_putDebugLogFilePath(objHandle: HCkSecureString; newPropVal: PWideChar);
function CkSecureString__debugLogFilePath(objHandle: HCkSecureString): PWideChar;
procedure CkSecureString_getLastErrorHtml(objHandle: HCkSecureString; outPropVal: HCkString);
function CkSecureString__lastErrorHtml(objHandle: HCkSecureString): PWideChar;
procedure CkSecureString_getLastErrorText(objHandle: HCkSecureString; outPropVal: HCkString);
function CkSecureString__lastErrorText(objHandle: HCkSecureString): PWideChar;
procedure CkSecureString_getLastErrorXml(objHandle: HCkSecureString; outPropVal: HCkString);
function CkSecureString__lastErrorXml(objHandle: HCkSecureString): PWideChar;
function CkSecureString_getLastMethodSuccess(objHandle: HCkSecureString): wordbool;
procedure CkSecureString_putLastMethodSuccess(objHandle: HCkSecureString; newPropVal: wordbool);
procedure CkSecureString_getMaintainHash(objHandle: HCkSecureString; outPropVal: HCkString);
procedure CkSecureString_putMaintainHash(objHandle: HCkSecureString; newPropVal: PWideChar);
function CkSecureString__maintainHash(objHandle: HCkSecureString): PWideChar;
function CkSecureString_getReadOnly(objHandle: HCkSecureString): wordbool;
procedure CkSecureString_putReadOnly(objHandle: HCkSecureString; newPropVal: wordbool);
function CkSecureString_getVerboseLogging(objHandle: HCkSecureString): wordbool;
procedure CkSecureString_putVerboseLogging(objHandle: HCkSecureString; newPropVal: wordbool);
procedure CkSecureString_getVersion(objHandle: HCkSecureString; outPropVal: HCkString);
function CkSecureString__version(objHandle: HCkSecureString): PWideChar;
function CkSecureString_Access(objHandle: HCkSecureString; outStr: HCkString): wordbool;
function CkSecureString__access(objHandle: HCkSecureString): PWideChar;
function CkSecureString_Append(objHandle: HCkSecureString; str: PWideChar): wordbool;
function CkSecureString_AppendSb(objHandle: HCkSecureString; sb: HCkStringBuilder): wordbool;
function CkSecureString_AppendSecure(objHandle: HCkSecureString; secStr: HCkSecureString): wordbool;
function CkSecureString_HashVal(objHandle: HCkSecureString; encoding: PWideChar; outStr: HCkString): wordbool;
function CkSecureString__hashVal(objHandle: HCkSecureString; encoding: PWideChar): PWideChar;
function CkSecureString_LoadFile(objHandle: HCkSecureString; path: PWideChar; charset: PWideChar): wordbool;
function CkSecureString_SecStrEquals(objHandle: HCkSecureString; secStr: HCkSecureString): wordbool;
function CkSecureString_VerifyHash(objHandle: HCkSecureString; hashVal: PWideChar; encoding: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkSecureString_Create = function : HCkSecureString; stdcall;
  TCkSecureString_Dispose = procedure (handle: HCkSecureString); stdcall;
  TCkSecureString_getDebugLogFilePath = procedure (objHandle: HCkSecureString; outPropVal: HCkString); stdcall;
  TCkSecureString_putDebugLogFilePath = procedure (objHandle: HCkSecureString; newPropVal: PWideChar); stdcall;
  TCkSecureString__debugLogFilePath = function (objHandle: HCkSecureString): PWideChar; stdcall;
  TCkSecureString_getLastErrorHtml = procedure (objHandle: HCkSecureString; outPropVal: HCkString); stdcall;
  TCkSecureString__lastErrorHtml = function (objHandle: HCkSecureString): PWideChar; stdcall;
  TCkSecureString_getLastErrorText = procedure (objHandle: HCkSecureString; outPropVal: HCkString); stdcall;
  TCkSecureString__lastErrorText = function (objHandle: HCkSecureString): PWideChar; stdcall;
  TCkSecureString_getLastErrorXml = procedure (objHandle: HCkSecureString; outPropVal: HCkString); stdcall;
  TCkSecureString__lastErrorXml = function (objHandle: HCkSecureString): PWideChar; stdcall;
  TCkSecureString_getLastMethodSuccess = function (objHandle: HCkSecureString): wordbool; stdcall;
  TCkSecureString_putLastMethodSuccess = procedure (objHandle: HCkSecureString; newPropVal: wordbool); stdcall;
  TCkSecureString_getMaintainHash = procedure (objHandle: HCkSecureString; outPropVal: HCkString); stdcall;
  TCkSecureString_putMaintainHash = procedure (objHandle: HCkSecureString; newPropVal: PWideChar); stdcall;
  TCkSecureString__maintainHash = function (objHandle: HCkSecureString): PWideChar; stdcall;
  TCkSecureString_getReadOnly = function (objHandle: HCkSecureString): wordbool; stdcall;
  TCkSecureString_putReadOnly = procedure (objHandle: HCkSecureString; newPropVal: wordbool); stdcall;
  TCkSecureString_getVerboseLogging = function (objHandle: HCkSecureString): wordbool; stdcall;
  TCkSecureString_putVerboseLogging = procedure (objHandle: HCkSecureString; newPropVal: wordbool); stdcall;
  TCkSecureString_getVersion = procedure (objHandle: HCkSecureString; outPropVal: HCkString); stdcall;
  TCkSecureString__version = function (objHandle: HCkSecureString): PWideChar; stdcall;
  TCkSecureString_Access = function (objHandle: HCkSecureString; outStr: HCkString): wordbool; stdcall;
  TCkSecureString__access = function (objHandle: HCkSecureString): PWideChar; stdcall;
  TCkSecureString_Append = function (objHandle: HCkSecureString; str: PWideChar): wordbool; stdcall;
  TCkSecureString_AppendSb = function (objHandle: HCkSecureString; sb: HCkStringBuilder): wordbool; stdcall;
  TCkSecureString_AppendSecure = function (objHandle: HCkSecureString; secStr: HCkSecureString): wordbool; stdcall;
  TCkSecureString_HashVal = function (objHandle: HCkSecureString; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSecureString__hashVal = function (objHandle: HCkSecureString; encoding: PWideChar): PWideChar; stdcall;
  TCkSecureString_LoadFile = function (objHandle: HCkSecureString; path: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkSecureString_SecStrEquals = function (objHandle: HCkSecureString; secStr: HCkSecureString): wordbool; stdcall;
  TCkSecureString_VerifyHash = function (objHandle: HCkSecureString; hashVal: PWideChar; encoding: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..31] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkSecureString_Create : HCkSecureString;
begin
  result := TCkSecureString_Create(_map(0, 'CkSecureString_Create'));
end;

procedure CkSecureString_Dispose (handle: HCkSecureString);
begin
  TCkSecureString_Dispose(_map(1, 'CkSecureString_Dispose'))
    (handle);
end;


procedure CkSecureString_getDebugLogFilePath (objHandle: HCkSecureString; outPropVal: HCkString);
begin
  TCkSecureString_getDebugLogFilePath(_map(2, 'CkSecureString_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkSecureString_putDebugLogFilePath (objHandle: HCkSecureString; newPropVal: PWideChar);
begin
  TCkSecureString_putDebugLogFilePath(_map(3, 'CkSecureString_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkSecureString__debugLogFilePath (objHandle: HCkSecureString): PWideChar;
begin
  result := TCkSecureString__debugLogFilePath(_map(4, 'CkSecureString__debugLogFilePath'))
    (objHandle);
end;

procedure CkSecureString_getLastErrorHtml (objHandle: HCkSecureString; outPropVal: HCkString);
begin
  TCkSecureString_getLastErrorHtml(_map(5, 'CkSecureString_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkSecureString__lastErrorHtml (objHandle: HCkSecureString): PWideChar;
begin
  result := TCkSecureString__lastErrorHtml(_map(6, 'CkSecureString__lastErrorHtml'))
    (objHandle);
end;

procedure CkSecureString_getLastErrorText (objHandle: HCkSecureString; outPropVal: HCkString);
begin
  TCkSecureString_getLastErrorText(_map(7, 'CkSecureString_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkSecureString__lastErrorText (objHandle: HCkSecureString): PWideChar;
begin
  result := TCkSecureString__lastErrorText(_map(8, 'CkSecureString__lastErrorText'))
    (objHandle);
end;

procedure CkSecureString_getLastErrorXml (objHandle: HCkSecureString; outPropVal: HCkString);
begin
  TCkSecureString_getLastErrorXml(_map(9, 'CkSecureString_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkSecureString__lastErrorXml (objHandle: HCkSecureString): PWideChar;
begin
  result := TCkSecureString__lastErrorXml(_map(10, 'CkSecureString__lastErrorXml'))
    (objHandle);
end;

function CkSecureString_getLastMethodSuccess (objHandle: HCkSecureString): wordbool;
begin
    result := TCkSecureString_getLastMethodSuccess(_map(11, 'CkSecureString_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkSecureString_putLastMethodSuccess (objHandle: HCkSecureString; newPropVal: wordbool);
begin
  TCkSecureString_putLastMethodSuccess(_map(12, 'CkSecureString_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkSecureString_getMaintainHash (objHandle: HCkSecureString; outPropVal: HCkString);
begin
  TCkSecureString_getMaintainHash(_map(13, 'CkSecureString_getMaintainHash'))
    (objHandle, outPropVal);
end;

procedure CkSecureString_putMaintainHash (objHandle: HCkSecureString; newPropVal: PWideChar);
begin
  TCkSecureString_putMaintainHash(_map(14, 'CkSecureString_putMaintainHash'))
    (objHandle, newPropVal);
end;

function CkSecureString__maintainHash (objHandle: HCkSecureString): PWideChar;
begin
  result := TCkSecureString__maintainHash(_map(15, 'CkSecureString__maintainHash'))
    (objHandle);
end;

function CkSecureString_getReadOnly (objHandle: HCkSecureString): wordbool;
begin
    result := TCkSecureString_getReadOnly(_map(16, 'CkSecureString_getReadOnly'))
    (objHandle);
end;

procedure CkSecureString_putReadOnly (objHandle: HCkSecureString; newPropVal: wordbool);
begin
  TCkSecureString_putReadOnly(_map(17, 'CkSecureString_putReadOnly'))
    (objHandle, newPropVal);
end;

function CkSecureString_getVerboseLogging (objHandle: HCkSecureString): wordbool;
begin
    result := TCkSecureString_getVerboseLogging(_map(18, 'CkSecureString_getVerboseLogging'))
    (objHandle);
end;

procedure CkSecureString_putVerboseLogging (objHandle: HCkSecureString; newPropVal: wordbool);
begin
  TCkSecureString_putVerboseLogging(_map(19, 'CkSecureString_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkSecureString_getVersion (objHandle: HCkSecureString; outPropVal: HCkString);
begin
  TCkSecureString_getVersion(_map(20, 'CkSecureString_getVersion'))
    (objHandle, outPropVal);
end;

function CkSecureString__version (objHandle: HCkSecureString): PWideChar;
begin
  result := TCkSecureString__version(_map(21, 'CkSecureString__version'))
    (objHandle);
end;

function CkSecureString_Access (objHandle: HCkSecureString; outStr: HCkString): wordbool;
begin
  result := TCkSecureString_Access(_map(22, 'CkSecureString_Access'))
    (objHandle, outStr);
end;

function CkSecureString__access (objHandle: HCkSecureString): PWideChar;
begin
  result := TCkSecureString__access(_map(23, 'CkSecureString__access'))
    (objHandle);
end;

function CkSecureString_Append (objHandle: HCkSecureString; str: PWideChar): wordbool;
begin
  result := TCkSecureString_Append(_map(24, 'CkSecureString_Append'))
    (objHandle, str);
end;

function CkSecureString_AppendSb (objHandle: HCkSecureString; sb: HCkStringBuilder): wordbool;
begin
  result := TCkSecureString_AppendSb(_map(25, 'CkSecureString_AppendSb'))
    (objHandle, sb);
end;

function CkSecureString_AppendSecure (objHandle: HCkSecureString; secStr: HCkSecureString): wordbool;
begin
  result := TCkSecureString_AppendSecure(_map(26, 'CkSecureString_AppendSecure'))
    (objHandle, secStr);
end;

function CkSecureString_HashVal (objHandle: HCkSecureString; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSecureString_HashVal(_map(27, 'CkSecureString_HashVal'))
    (objHandle, encoding, outStr);
end;

function CkSecureString__hashVal (objHandle: HCkSecureString; encoding: PWideChar): PWideChar;
begin
  result := TCkSecureString__hashVal(_map(28, 'CkSecureString__hashVal'))
    (objHandle, encoding);
end;

function CkSecureString_LoadFile (objHandle: HCkSecureString; path: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkSecureString_LoadFile(_map(29, 'CkSecureString_LoadFile'))
    (objHandle, path, charset);
end;

function CkSecureString_SecStrEquals (objHandle: HCkSecureString; secStr: HCkSecureString): wordbool;
begin
  result := TCkSecureString_SecStrEquals(_map(30, 'CkSecureString_SecStrEquals'))
    (objHandle, secStr);
end;

function CkSecureString_VerifyHash (objHandle: HCkSecureString; hashVal: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkSecureString_VerifyHash(_map(31, 'CkSecureString_VerifyHash'))
    (objHandle, hashVal, encoding);
end;

end.
