unit Ssh;

interface

type

HCkSecureString = Pointer;
HCkSsh = Pointer;
HCkByteData = Pointer;
HCkSshKey = Pointer;
HCkString = Pointer;
HCkStringArray = Pointer;
HCkTask = Pointer;
HCkJsonObject = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TSshAbortCheck = function(): Integer; cdecl;
TSshProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TSshPercentDone = function(pctDone: Integer): Integer; cdecl;
TSshTaskCompleted = procedure(task: HCkTask); cdecl;


function CkSsh_Create: HCkSsh;  stdcall;
procedure CkSsh_Dispose(handle: HCkSsh); stdcall;

procedure CkSsh_SetAbortCheck(objHandle: HCkSsh; fn: TSshAbortCheck) stdcall;
procedure CkSsh_SetProgressInfo(objHandle: HCkSsh; fn: TSshProgressInfo) stdcall;
procedure CkSsh_SetPercentDone(objHandle: HCkSsh; fn: TSshPercentDone) stdcall;
procedure CkSsh_SetTaskCompleted(objHandle: HCkSsh; fn: TSshTaskCompleted) stdcall;
function CkSsh_getAbortCurrent(objHandle: HCkSsh): wordbool;
procedure CkSsh_putAbortCurrent(objHandle: HCkSsh; newPropVal: wordbool);
function CkSsh_getAuthFailReason(objHandle: HCkSsh): Integer;
function CkSsh_getCaretControl(objHandle: HCkSsh): wordbool;
procedure CkSsh_putCaretControl(objHandle: HCkSsh; newPropVal: wordbool);
function CkSsh_getChannelOpenFailCode(objHandle: HCkSsh): Integer;
procedure CkSsh_getChannelOpenFailReason(objHandle: HCkSsh; outPropVal: HCkString);
function CkSsh__channelOpenFailReason(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getClientIdentifier(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putClientIdentifier(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__clientIdentifier(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getClientIpAddress(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putClientIpAddress(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__clientIpAddress(objHandle: HCkSsh): PWideChar;
function CkSsh_getClientPort(objHandle: HCkSsh): Integer;
procedure CkSsh_putClientPort(objHandle: HCkSsh; newPropVal: Integer);
function CkSsh_getConnectTimeoutMs(objHandle: HCkSsh): Integer;
procedure CkSsh_putConnectTimeoutMs(objHandle: HCkSsh; newPropVal: Integer);
procedure CkSsh_getDebugLogFilePath(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putDebugLogFilePath(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__debugLogFilePath(objHandle: HCkSsh): PWideChar;
function CkSsh_getDisconnectCode(objHandle: HCkSsh): Integer;
procedure CkSsh_getDisconnectReason(objHandle: HCkSsh; outPropVal: HCkString);
function CkSsh__disconnectReason(objHandle: HCkSsh): PWideChar;
function CkSsh_getEnableCompression(objHandle: HCkSsh): wordbool;
procedure CkSsh_putEnableCompression(objHandle: HCkSsh; newPropVal: wordbool);
procedure CkSsh_getForceCipher(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putForceCipher(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__forceCipher(objHandle: HCkSsh): PWideChar;
function CkSsh_getHeartbeatMs(objHandle: HCkSsh): Integer;
procedure CkSsh_putHeartbeatMs(objHandle: HCkSsh; newPropVal: Integer);
procedure CkSsh_getHostKeyAlg(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putHostKeyAlg(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__hostKeyAlg(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getHostKeyFingerprint(objHandle: HCkSsh; outPropVal: HCkString);
function CkSsh__hostKeyFingerprint(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getHttpProxyAuthMethod(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putHttpProxyAuthMethod(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__httpProxyAuthMethod(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getHttpProxyDomain(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putHttpProxyDomain(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__httpProxyDomain(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getHttpProxyHostname(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putHttpProxyHostname(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__httpProxyHostname(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getHttpProxyPassword(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putHttpProxyPassword(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__httpProxyPassword(objHandle: HCkSsh): PWideChar;
function CkSsh_getHttpProxyPort(objHandle: HCkSsh): Integer;
procedure CkSsh_putHttpProxyPort(objHandle: HCkSsh; newPropVal: Integer);
procedure CkSsh_getHttpProxyUsername(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putHttpProxyUsername(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__httpProxyUsername(objHandle: HCkSsh): PWideChar;
function CkSsh_getIdleTimeoutMs(objHandle: HCkSsh): Integer;
procedure CkSsh_putIdleTimeoutMs(objHandle: HCkSsh; newPropVal: Integer);
function CkSsh_getIsConnected(objHandle: HCkSsh): wordbool;
function CkSsh_getKeepSessionLog(objHandle: HCkSsh): wordbool;
procedure CkSsh_putKeepSessionLog(objHandle: HCkSsh; newPropVal: wordbool);
procedure CkSsh_getLastErrorHtml(objHandle: HCkSsh; outPropVal: HCkString);
function CkSsh__lastErrorHtml(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getLastErrorText(objHandle: HCkSsh; outPropVal: HCkString);
function CkSsh__lastErrorText(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getLastErrorXml(objHandle: HCkSsh; outPropVal: HCkString);
function CkSsh__lastErrorXml(objHandle: HCkSsh): PWideChar;
function CkSsh_getLastMethodSuccess(objHandle: HCkSsh): wordbool;
procedure CkSsh_putLastMethodSuccess(objHandle: HCkSsh; newPropVal: wordbool);
function CkSsh_getMaxPacketSize(objHandle: HCkSsh): Integer;
procedure CkSsh_putMaxPacketSize(objHandle: HCkSsh; newPropVal: Integer);
function CkSsh_getNumOpenChannels(objHandle: HCkSsh): Integer;
function CkSsh_getPasswordChangeRequested(objHandle: HCkSsh): wordbool;
function CkSsh_getPreferIpv6(objHandle: HCkSsh): wordbool;
procedure CkSsh_putPreferIpv6(objHandle: HCkSsh; newPropVal: wordbool);
function CkSsh_getReadTimeoutMs(objHandle: HCkSsh): Integer;
procedure CkSsh_putReadTimeoutMs(objHandle: HCkSsh; newPropVal: Integer);
procedure CkSsh_getReqExecCharset(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putReqExecCharset(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__reqExecCharset(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getServerIdentifier(objHandle: HCkSsh; outPropVal: HCkString);
function CkSsh__serverIdentifier(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getSessionLog(objHandle: HCkSsh; outPropVal: HCkString);
function CkSsh__sessionLog(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getSocksHostname(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putSocksHostname(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__socksHostname(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getSocksPassword(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putSocksPassword(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__socksPassword(objHandle: HCkSsh): PWideChar;
function CkSsh_getSocksPort(objHandle: HCkSsh): Integer;
procedure CkSsh_putSocksPort(objHandle: HCkSsh; newPropVal: Integer);
procedure CkSsh_getSocksUsername(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putSocksUsername(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__socksUsername(objHandle: HCkSsh): PWideChar;
function CkSsh_getSocksVersion(objHandle: HCkSsh): Integer;
procedure CkSsh_putSocksVersion(objHandle: HCkSsh; newPropVal: Integer);
function CkSsh_getSoRcvBuf(objHandle: HCkSsh): Integer;
procedure CkSsh_putSoRcvBuf(objHandle: HCkSsh; newPropVal: Integer);
function CkSsh_getSoSndBuf(objHandle: HCkSsh): Integer;
procedure CkSsh_putSoSndBuf(objHandle: HCkSsh; newPropVal: Integer);
function CkSsh_getStderrToStdout(objHandle: HCkSsh): wordbool;
procedure CkSsh_putStderrToStdout(objHandle: HCkSsh; newPropVal: wordbool);
function CkSsh_getStripColorCodes(objHandle: HCkSsh): wordbool;
procedure CkSsh_putStripColorCodes(objHandle: HCkSsh; newPropVal: wordbool);
function CkSsh_getTcpNoDelay(objHandle: HCkSsh): wordbool;
procedure CkSsh_putTcpNoDelay(objHandle: HCkSsh; newPropVal: wordbool);
procedure CkSsh_getUncommonOptions(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putUncommonOptions(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__uncommonOptions(objHandle: HCkSsh): PWideChar;
procedure CkSsh_getUserAuthBanner(objHandle: HCkSsh; outPropVal: HCkString);
procedure CkSsh_putUserAuthBanner(objHandle: HCkSsh; newPropVal: PWideChar);
function CkSsh__userAuthBanner(objHandle: HCkSsh): PWideChar;
function CkSsh_getVerboseLogging(objHandle: HCkSsh): wordbool;
procedure CkSsh_putVerboseLogging(objHandle: HCkSsh; newPropVal: wordbool);
procedure CkSsh_getVersion(objHandle: HCkSsh; outPropVal: HCkString);
function CkSsh__version(objHandle: HCkSsh): PWideChar;
function CkSsh_AuthenticatePk(objHandle: HCkSsh; username: PWideChar; privateKey: HCkSshKey): wordbool;
function CkSsh_AuthenticatePkAsync(objHandle: HCkSsh; username: PWideChar; privateKey: HCkSshKey): HCkTask;
function CkSsh_AuthenticatePw(objHandle: HCkSsh; login: PWideChar; password: PWideChar): wordbool;
function CkSsh_AuthenticatePwAsync(objHandle: HCkSsh; login: PWideChar; password: PWideChar): HCkTask;
function CkSsh_AuthenticatePwPk(objHandle: HCkSsh; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): wordbool;
function CkSsh_AuthenticatePwPkAsync(objHandle: HCkSsh; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): HCkTask;
function CkSsh_AuthenticateSecPw(objHandle: HCkSsh; login: HCkSecureString; password: HCkSecureString): wordbool;
function CkSsh_AuthenticateSecPwAsync(objHandle: HCkSsh; login: HCkSecureString; password: HCkSecureString): HCkTask;
function CkSsh_AuthenticateSecPwPk(objHandle: HCkSsh; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): wordbool;
function CkSsh_AuthenticateSecPwPkAsync(objHandle: HCkSsh; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): HCkTask;
function CkSsh_ChannelIsOpen(objHandle: HCkSsh; channelNum: Integer): wordbool;
function CkSsh_ChannelPoll(objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): Integer;
function CkSsh_ChannelPollAsync(objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): HCkTask;
function CkSsh_ChannelRead(objHandle: HCkSsh; channelNum: Integer): Integer;
function CkSsh_ChannelReadAsync(objHandle: HCkSsh; channelNum: Integer): HCkTask;
function CkSsh_ChannelReadAndPoll(objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): Integer;
function CkSsh_ChannelReadAndPollAsync(objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): HCkTask;
function CkSsh_ChannelReadAndPoll2(objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer; maxNumBytes: Integer): Integer;
function CkSsh_ChannelReadAndPoll2Async(objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer; maxNumBytes: Integer): HCkTask;
function CkSsh_ChannelReceivedClose(objHandle: HCkSsh; channelNum: Integer): wordbool;
function CkSsh_ChannelReceivedEof(objHandle: HCkSsh; channelNum: Integer): wordbool;
function CkSsh_ChannelReceivedExitStatus(objHandle: HCkSsh; channelNum: Integer): wordbool;
function CkSsh_ChannelReceiveToClose(objHandle: HCkSsh; channelNum: Integer): wordbool;
function CkSsh_ChannelReceiveToCloseAsync(objHandle: HCkSsh; channelNum: Integer): HCkTask;
function CkSsh_ChannelReceiveUntilMatch(objHandle: HCkSsh; channelNum: Integer; matchPattern: PWideChar; charset: PWideChar; caseSensitive: wordbool): wordbool;
function CkSsh_ChannelReceiveUntilMatchAsync(objHandle: HCkSsh; channelNum: Integer; matchPattern: PWideChar; charset: PWideChar; caseSensitive: wordbool): HCkTask;
function CkSsh_ChannelReceiveUntilMatchN(objHandle: HCkSsh; channelNum: Integer; matchPatterns: HCkStringArray; charset: PWideChar; caseSensitive: wordbool): wordbool;
function CkSsh_ChannelReceiveUntilMatchNAsync(objHandle: HCkSsh; channelNum: Integer; matchPatterns: HCkStringArray; charset: PWideChar; caseSensitive: wordbool): HCkTask;
procedure CkSsh_ChannelRelease(objHandle: HCkSsh; channelNum: Integer);
function CkSsh_ChannelSendClose(objHandle: HCkSsh; channelNum: Integer): wordbool;
function CkSsh_ChannelSendCloseAsync(objHandle: HCkSsh; channelNum: Integer): HCkTask;
function CkSsh_ChannelSendData(objHandle: HCkSsh; channelNum: Integer; byteData: HCkByteData): wordbool;
function CkSsh_ChannelSendDataAsync(objHandle: HCkSsh; channelNum: Integer; byteData: HCkByteData): HCkTask;
function CkSsh_ChannelSendEof(objHandle: HCkSsh; channelNum: Integer): wordbool;
function CkSsh_ChannelSendEofAsync(objHandle: HCkSsh; channelNum: Integer): HCkTask;
function CkSsh_ChannelSendString(objHandle: HCkSsh; channelNum: Integer; textData: PWideChar; charset: PWideChar): wordbool;
function CkSsh_ChannelSendStringAsync(objHandle: HCkSsh; channelNum: Integer; textData: PWideChar; charset: PWideChar): HCkTask;
function CkSsh_CheckConnection(objHandle: HCkSsh): wordbool;
procedure CkSsh_ClearTtyModes(objHandle: HCkSsh);
function CkSsh_Connect(objHandle: HCkSsh; domainName: PWideChar; port: Integer): wordbool;
function CkSsh_ConnectAsync(objHandle: HCkSsh; domainName: PWideChar; port: Integer): HCkTask;
function CkSsh_ConnectThroughSsh(objHandle: HCkSsh; ssh: HCkSsh; hostname: PWideChar; port: Integer): wordbool;
function CkSsh_ConnectThroughSshAsync(objHandle: HCkSsh; ssh: HCkSsh; hostname: PWideChar; port: Integer): HCkTask;
function CkSsh_ContinueKeyboardAuth(objHandle: HCkSsh; response: PWideChar; outStr: HCkString): wordbool;
function CkSsh__continueKeyboardAuth(objHandle: HCkSsh; response: PWideChar): PWideChar;
function CkSsh_ContinueKeyboardAuthAsync(objHandle: HCkSsh; response: PWideChar): HCkTask;
procedure CkSsh_Disconnect(objHandle: HCkSsh);
function CkSsh_GetAuthMethods(objHandle: HCkSsh; outStr: HCkString): wordbool;
function CkSsh__getAuthMethods(objHandle: HCkSsh): PWideChar;
function CkSsh_GetAuthMethodsAsync(objHandle: HCkSsh): HCkTask;
function CkSsh_GetChannelExitStatus(objHandle: HCkSsh; channelNum: Integer): Integer;
function CkSsh_GetChannelNumber(objHandle: HCkSsh; index: Integer): Integer;
function CkSsh_GetChannelType(objHandle: HCkSsh; index: Integer; outStr: HCkString): wordbool;
function CkSsh__getChannelType(objHandle: HCkSsh; index: Integer): PWideChar;
function CkSsh_GetHostKeyFP(objHandle: HCkSsh; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool; outStr: HCkString): wordbool;
function CkSsh__getHostKeyFP(objHandle: HCkSsh; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool): PWideChar;
procedure CkSsh_GetLastJsonData(objHandle: HCkSsh; json: HCkJsonObject);
function CkSsh_GetReceivedData(objHandle: HCkSsh; channelNum: Integer; outData: HCkByteData): wordbool;
function CkSsh_GetReceivedDataN(objHandle: HCkSsh; channelNum: Integer; maxNumBytes: Integer; outData: HCkByteData): wordbool;
function CkSsh_GetReceivedNumBytes(objHandle: HCkSsh; channelNum: Integer): Integer;
function CkSsh_GetReceivedStderr(objHandle: HCkSsh; channelNum: Integer; outData: HCkByteData): wordbool;
function CkSsh_GetReceivedStderrText(objHandle: HCkSsh; channelNum: Integer; charset: PWideChar; outStr: HCkString): wordbool;
function CkSsh__getReceivedStderrText(objHandle: HCkSsh; channelNum: Integer; charset: PWideChar): PWideChar;
function CkSsh_GetReceivedText(objHandle: HCkSsh; channelNum: Integer; charset: PWideChar; outStr: HCkString): wordbool;
function CkSsh__getReceivedText(objHandle: HCkSsh; channelNum: Integer; charset: PWideChar): PWideChar;
function CkSsh_GetReceivedTextS(objHandle: HCkSsh; channelNum: Integer; substr: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkSsh__getReceivedTextS(objHandle: HCkSsh; channelNum: Integer; substr: PWideChar; charset: PWideChar): PWideChar;
function CkSsh_LastJsonData(objHandle: HCkSsh): HCkJsonObject;
function CkSsh_LoadTaskCaller(objHandle: HCkSsh; task: HCkTask): wordbool;
function CkSsh_OpenCustomChannel(objHandle: HCkSsh; channelType: PWideChar): Integer;
function CkSsh_OpenCustomChannelAsync(objHandle: HCkSsh; channelType: PWideChar): HCkTask;
function CkSsh_OpenDirectTcpIpChannel(objHandle: HCkSsh; targetHostname: PWideChar; targetPort: Integer): Integer;
function CkSsh_OpenDirectTcpIpChannelAsync(objHandle: HCkSsh; targetHostname: PWideChar; targetPort: Integer): HCkTask;
function CkSsh_OpenSessionChannel(objHandle: HCkSsh): Integer;
function CkSsh_OpenSessionChannelAsync(objHandle: HCkSsh): HCkTask;
function CkSsh_PeekReceivedText(objHandle: HCkSsh; channelNum: Integer; charset: PWideChar; outStr: HCkString): wordbool;
function CkSsh__peekReceivedText(objHandle: HCkSsh; channelNum: Integer; charset: PWideChar): PWideChar;
function CkSsh_QuickCmdCheck(objHandle: HCkSsh; pollTimeoutMs: Integer): Integer;
function CkSsh_QuickCmdCheckAsync(objHandle: HCkSsh; pollTimeoutMs: Integer): HCkTask;
function CkSsh_QuickCmdSend(objHandle: HCkSsh; command: PWideChar): Integer;
function CkSsh_QuickCmdSendAsync(objHandle: HCkSsh; command: PWideChar): HCkTask;
function CkSsh_QuickCommand(objHandle: HCkSsh; command: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
function CkSsh__quickCommand(objHandle: HCkSsh; command: PWideChar; charset: PWideChar): PWideChar;
function CkSsh_QuickCommandAsync(objHandle: HCkSsh; command: PWideChar; charset: PWideChar): HCkTask;
function CkSsh_QuickShell(objHandle: HCkSsh): Integer;
function CkSsh_QuickShellAsync(objHandle: HCkSsh): HCkTask;
function CkSsh_ReKey(objHandle: HCkSsh): wordbool;
function CkSsh_ReKeyAsync(objHandle: HCkSsh): HCkTask;
function CkSsh_SendIgnore(objHandle: HCkSsh): wordbool;
function CkSsh_SendIgnoreAsync(objHandle: HCkSsh): HCkTask;
function CkSsh_SendReqExec(objHandle: HCkSsh; channelNum: Integer; commandLine: PWideChar): wordbool;
function CkSsh_SendReqExecAsync(objHandle: HCkSsh; channelNum: Integer; commandLine: PWideChar): HCkTask;
function CkSsh_SendReqPty(objHandle: HCkSsh; channelNum: Integer; termType: PWideChar; widthInChars: Integer; heightInChars: Integer; widthInPixels: Integer; heightInPixels: Integer): wordbool;
function CkSsh_SendReqPtyAsync(objHandle: HCkSsh; channelNum: Integer; termType: PWideChar; widthInChars: Integer; heightInChars: Integer; widthInPixels: Integer; heightInPixels: Integer): HCkTask;
function CkSsh_SendReqSetEnv(objHandle: HCkSsh; channelNum: Integer; name: PWideChar; value: PWideChar): wordbool;
function CkSsh_SendReqSetEnvAsync(objHandle: HCkSsh; channelNum: Integer; name: PWideChar; value: PWideChar): HCkTask;
function CkSsh_SendReqShell(objHandle: HCkSsh; channelNum: Integer): wordbool;
function CkSsh_SendReqShellAsync(objHandle: HCkSsh; channelNum: Integer): HCkTask;
function CkSsh_SendReqSignal(objHandle: HCkSsh; channelNum: Integer; signalName: PWideChar): wordbool;
function CkSsh_SendReqSignalAsync(objHandle: HCkSsh; channelNum: Integer; signalName: PWideChar): HCkTask;
function CkSsh_SendReqSubsystem(objHandle: HCkSsh; channelNum: Integer; subsystemName: PWideChar): wordbool;
function CkSsh_SendReqSubsystemAsync(objHandle: HCkSsh; channelNum: Integer; subsystemName: PWideChar): HCkTask;
function CkSsh_SendReqWindowChange(objHandle: HCkSsh; channelNum: Integer; widthInChars: Integer; heightInRows: Integer; pixWidth: Integer; pixHeight: Integer): wordbool;
function CkSsh_SendReqWindowChangeAsync(objHandle: HCkSsh; channelNum: Integer; widthInChars: Integer; heightInRows: Integer; pixWidth: Integer; pixHeight: Integer): HCkTask;
function CkSsh_SendReqX11Forwarding(objHandle: HCkSsh; channelNum: Integer; singleConnection: wordbool; authProt: PWideChar; authCookie: PWideChar; screenNum: Integer): wordbool;
function CkSsh_SendReqX11ForwardingAsync(objHandle: HCkSsh; channelNum: Integer; singleConnection: wordbool; authProt: PWideChar; authCookie: PWideChar; screenNum: Integer): HCkTask;
function CkSsh_SendReqXonXoff(objHandle: HCkSsh; channelNum: Integer; clientCanDo: wordbool): wordbool;
function CkSsh_SendReqXonXoffAsync(objHandle: HCkSsh; channelNum: Integer; clientCanDo: wordbool): HCkTask;
function CkSsh_SetAllowedAlgorithms(objHandle: HCkSsh; json: HCkJsonObject): wordbool;
function CkSsh_SetTtyMode(objHandle: HCkSsh; ttyName: PWideChar; ttyValue: Integer): wordbool;
function CkSsh_StartKeyboardAuth(objHandle: HCkSsh; login: PWideChar; outStr: HCkString): wordbool;
function CkSsh__startKeyboardAuth(objHandle: HCkSsh; login: PWideChar): PWideChar;
function CkSsh_StartKeyboardAuthAsync(objHandle: HCkSsh; login: PWideChar): HCkTask;
function CkSsh_WaitForChannelMessage(objHandle: HCkSsh; pollTimeoutMs: Integer): Integer;
function CkSsh_WaitForChannelMessageAsync(objHandle: HCkSsh; pollTimeoutMs: Integer): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkSsh_Create = function : HCkSsh; stdcall;
  TCkSsh_Dispose = procedure (handle: HCkSsh); stdcall;
  TCkSsh_SetAbortCheck = procedure (objHandle: HCkSsh; fn: TSshAbortCheck); stdcall;
  TCkSsh_SetProgressInfo = procedure (objHandle: HCkSsh; fn: TSshProgressInfo); stdcall;
  TCkSsh_SetPercentDone = procedure (objHandle: HCkSsh; fn: TSshPercentDone); stdcall;
  TCkSsh_SetTaskCompleted = procedure (objHandle: HCkSsh; fn: TSshTaskCompleted); stdcall;
  TCkSsh_getAbortCurrent = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_putAbortCurrent = procedure (objHandle: HCkSsh; newPropVal: wordbool); stdcall;
  TCkSsh_getAuthFailReason = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_getCaretControl = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_putCaretControl = procedure (objHandle: HCkSsh; newPropVal: wordbool); stdcall;
  TCkSsh_getChannelOpenFailCode = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_getChannelOpenFailReason = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh__channelOpenFailReason = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getClientIdentifier = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putClientIdentifier = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__clientIdentifier = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getClientIpAddress = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putClientIpAddress = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__clientIpAddress = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getClientPort = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putClientPort = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getConnectTimeoutMs = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putConnectTimeoutMs = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getDebugLogFilePath = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putDebugLogFilePath = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__debugLogFilePath = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getDisconnectCode = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_getDisconnectReason = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh__disconnectReason = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getEnableCompression = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_putEnableCompression = procedure (objHandle: HCkSsh; newPropVal: wordbool); stdcall;
  TCkSsh_getForceCipher = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putForceCipher = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__forceCipher = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getHeartbeatMs = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putHeartbeatMs = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getHostKeyAlg = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putHostKeyAlg = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__hostKeyAlg = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getHostKeyFingerprint = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh__hostKeyFingerprint = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getHttpProxyAuthMethod = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putHttpProxyAuthMethod = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__httpProxyAuthMethod = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getHttpProxyDomain = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putHttpProxyDomain = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__httpProxyDomain = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getHttpProxyHostname = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putHttpProxyHostname = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__httpProxyHostname = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getHttpProxyPassword = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putHttpProxyPassword = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__httpProxyPassword = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getHttpProxyPort = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putHttpProxyPort = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getHttpProxyUsername = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putHttpProxyUsername = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__httpProxyUsername = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getIdleTimeoutMs = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putIdleTimeoutMs = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getIsConnected = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_getKeepSessionLog = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_putKeepSessionLog = procedure (objHandle: HCkSsh; newPropVal: wordbool); stdcall;
  TCkSsh_getLastErrorHtml = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh__lastErrorHtml = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getLastErrorText = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh__lastErrorText = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getLastErrorXml = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh__lastErrorXml = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getLastMethodSuccess = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_putLastMethodSuccess = procedure (objHandle: HCkSsh; newPropVal: wordbool); stdcall;
  TCkSsh_getMaxPacketSize = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putMaxPacketSize = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getNumOpenChannels = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_getPasswordChangeRequested = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_getPreferIpv6 = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_putPreferIpv6 = procedure (objHandle: HCkSsh; newPropVal: wordbool); stdcall;
  TCkSsh_getReadTimeoutMs = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putReadTimeoutMs = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getReqExecCharset = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putReqExecCharset = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__reqExecCharset = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getServerIdentifier = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh__serverIdentifier = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getSessionLog = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh__sessionLog = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getSocksHostname = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putSocksHostname = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__socksHostname = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getSocksPassword = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putSocksPassword = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__socksPassword = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getSocksPort = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putSocksPort = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getSocksUsername = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putSocksUsername = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__socksUsername = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getSocksVersion = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putSocksVersion = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getSoRcvBuf = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putSoRcvBuf = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getSoSndBuf = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_putSoSndBuf = procedure (objHandle: HCkSsh; newPropVal: Integer); stdcall;
  TCkSsh_getStderrToStdout = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_putStderrToStdout = procedure (objHandle: HCkSsh; newPropVal: wordbool); stdcall;
  TCkSsh_getStripColorCodes = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_putStripColorCodes = procedure (objHandle: HCkSsh; newPropVal: wordbool); stdcall;
  TCkSsh_getTcpNoDelay = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_putTcpNoDelay = procedure (objHandle: HCkSsh; newPropVal: wordbool); stdcall;
  TCkSsh_getUncommonOptions = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putUncommonOptions = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__uncommonOptions = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getUserAuthBanner = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh_putUserAuthBanner = procedure (objHandle: HCkSsh; newPropVal: PWideChar); stdcall;
  TCkSsh__userAuthBanner = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_getVerboseLogging = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_putVerboseLogging = procedure (objHandle: HCkSsh; newPropVal: wordbool); stdcall;
  TCkSsh_getVersion = procedure (objHandle: HCkSsh; outPropVal: HCkString); stdcall;
  TCkSsh__version = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_AuthenticatePk = function (objHandle: HCkSsh; username: PWideChar; privateKey: HCkSshKey): wordbool; stdcall;
  TCkSsh_AuthenticatePkAsync = function (objHandle: HCkSsh; username: PWideChar; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkSsh_AuthenticatePw = function (objHandle: HCkSsh; login: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkSsh_AuthenticatePwAsync = function (objHandle: HCkSsh; login: PWideChar; password: PWideChar): HCkTask; stdcall;
  TCkSsh_AuthenticatePwPk = function (objHandle: HCkSsh; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): wordbool; stdcall;
  TCkSsh_AuthenticatePwPkAsync = function (objHandle: HCkSsh; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkSsh_AuthenticateSecPw = function (objHandle: HCkSsh; login: HCkSecureString; password: HCkSecureString): wordbool; stdcall;
  TCkSsh_AuthenticateSecPwAsync = function (objHandle: HCkSsh; login: HCkSecureString; password: HCkSecureString): HCkTask; stdcall;
  TCkSsh_AuthenticateSecPwPk = function (objHandle: HCkSsh; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): wordbool; stdcall;
  TCkSsh_AuthenticateSecPwPkAsync = function (objHandle: HCkSsh; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkSsh_ChannelIsOpen = function (objHandle: HCkSsh; channelNum: Integer): wordbool; stdcall;
  TCkSsh_ChannelPoll = function (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): Integer; stdcall;
  TCkSsh_ChannelPollAsync = function (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): HCkTask; stdcall;
  TCkSsh_ChannelRead = function (objHandle: HCkSsh; channelNum: Integer): Integer; stdcall;
  TCkSsh_ChannelReadAsync = function (objHandle: HCkSsh; channelNum: Integer): HCkTask; stdcall;
  TCkSsh_ChannelReadAndPoll = function (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): Integer; stdcall;
  TCkSsh_ChannelReadAndPollAsync = function (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): HCkTask; stdcall;
  TCkSsh_ChannelReadAndPoll2 = function (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer; maxNumBytes: Integer): Integer; stdcall;
  TCkSsh_ChannelReadAndPoll2Async = function (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer; maxNumBytes: Integer): HCkTask; stdcall;
  TCkSsh_ChannelReceivedClose = function (objHandle: HCkSsh; channelNum: Integer): wordbool; stdcall;
  TCkSsh_ChannelReceivedEof = function (objHandle: HCkSsh; channelNum: Integer): wordbool; stdcall;
  TCkSsh_ChannelReceivedExitStatus = function (objHandle: HCkSsh; channelNum: Integer): wordbool; stdcall;
  TCkSsh_ChannelReceiveToClose = function (objHandle: HCkSsh; channelNum: Integer): wordbool; stdcall;
  TCkSsh_ChannelReceiveToCloseAsync = function (objHandle: HCkSsh; channelNum: Integer): HCkTask; stdcall;
  TCkSsh_ChannelReceiveUntilMatch = function (objHandle: HCkSsh; channelNum: Integer; matchPattern: PWideChar; charset: PWideChar; caseSensitive: wordbool): wordbool; stdcall;
  TCkSsh_ChannelReceiveUntilMatchAsync = function (objHandle: HCkSsh; channelNum: Integer; matchPattern: PWideChar; charset: PWideChar; caseSensitive: wordbool): HCkTask; stdcall;
  TCkSsh_ChannelReceiveUntilMatchN = function (objHandle: HCkSsh; channelNum: Integer; matchPatterns: HCkStringArray; charset: PWideChar; caseSensitive: wordbool): wordbool; stdcall;
  TCkSsh_ChannelReceiveUntilMatchNAsync = function (objHandle: HCkSsh; channelNum: Integer; matchPatterns: HCkStringArray; charset: PWideChar; caseSensitive: wordbool): HCkTask; stdcall;
  TCkSsh_ChannelRelease = procedure (objHandle: HCkSsh; channelNum: Integer); stdcall;
  TCkSsh_ChannelSendClose = function (objHandle: HCkSsh; channelNum: Integer): wordbool; stdcall;
  TCkSsh_ChannelSendCloseAsync = function (objHandle: HCkSsh; channelNum: Integer): HCkTask; stdcall;
  TCkSsh_ChannelSendData = function (objHandle: HCkSsh; channelNum: Integer; byteData: HCkByteData): wordbool; stdcall;
  TCkSsh_ChannelSendDataAsync = function (objHandle: HCkSsh; channelNum: Integer; byteData: HCkByteData): HCkTask; stdcall;
  TCkSsh_ChannelSendEof = function (objHandle: HCkSsh; channelNum: Integer): wordbool; stdcall;
  TCkSsh_ChannelSendEofAsync = function (objHandle: HCkSsh; channelNum: Integer): HCkTask; stdcall;
  TCkSsh_ChannelSendString = function (objHandle: HCkSsh; channelNum: Integer; textData: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkSsh_ChannelSendStringAsync = function (objHandle: HCkSsh; channelNum: Integer; textData: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkSsh_CheckConnection = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_ClearTtyModes = procedure (objHandle: HCkSsh); stdcall;
  TCkSsh_Connect = function (objHandle: HCkSsh; domainName: PWideChar; port: Integer): wordbool; stdcall;
  TCkSsh_ConnectAsync = function (objHandle: HCkSsh; domainName: PWideChar; port: Integer): HCkTask; stdcall;
  TCkSsh_ConnectThroughSsh = function (objHandle: HCkSsh; ssh: HCkSsh; hostname: PWideChar; port: Integer): wordbool; stdcall;
  TCkSsh_ConnectThroughSshAsync = function (objHandle: HCkSsh; ssh: HCkSsh; hostname: PWideChar; port: Integer): HCkTask; stdcall;
  TCkSsh_ContinueKeyboardAuth = function (objHandle: HCkSsh; response: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSsh__continueKeyboardAuth = function (objHandle: HCkSsh; response: PWideChar): PWideChar; stdcall;
  TCkSsh_ContinueKeyboardAuthAsync = function (objHandle: HCkSsh; response: PWideChar): HCkTask; stdcall;
  TCkSsh_Disconnect = procedure (objHandle: HCkSsh); stdcall;
  TCkSsh_GetAuthMethods = function (objHandle: HCkSsh; outStr: HCkString): wordbool; stdcall;
  TCkSsh__getAuthMethods = function (objHandle: HCkSsh): PWideChar; stdcall;
  TCkSsh_GetAuthMethodsAsync = function (objHandle: HCkSsh): HCkTask; stdcall;
  TCkSsh_GetChannelExitStatus = function (objHandle: HCkSsh; channelNum: Integer): Integer; stdcall;
  TCkSsh_GetChannelNumber = function (objHandle: HCkSsh; index: Integer): Integer; stdcall;
  TCkSsh_GetChannelType = function (objHandle: HCkSsh; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkSsh__getChannelType = function (objHandle: HCkSsh; index: Integer): PWideChar; stdcall;
  TCkSsh_GetHostKeyFP = function (objHandle: HCkSsh; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkSsh__getHostKeyFP = function (objHandle: HCkSsh; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool): PWideChar; stdcall;
  TCkSsh_GetLastJsonData = procedure (objHandle: HCkSsh; json: HCkJsonObject); stdcall;
  TCkSsh_GetReceivedData = function (objHandle: HCkSsh; channelNum: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkSsh_GetReceivedDataN = function (objHandle: HCkSsh; channelNum: Integer; maxNumBytes: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkSsh_GetReceivedNumBytes = function (objHandle: HCkSsh; channelNum: Integer): Integer; stdcall;
  TCkSsh_GetReceivedStderr = function (objHandle: HCkSsh; channelNum: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkSsh_GetReceivedStderrText = function (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSsh__getReceivedStderrText = function (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar): PWideChar; stdcall;
  TCkSsh_GetReceivedText = function (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSsh__getReceivedText = function (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar): PWideChar; stdcall;
  TCkSsh_GetReceivedTextS = function (objHandle: HCkSsh; channelNum: Integer; substr: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSsh__getReceivedTextS = function (objHandle: HCkSsh; channelNum: Integer; substr: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkSsh_LastJsonData = function (objHandle: HCkSsh): HCkJsonObject; stdcall;
  TCkSsh_LoadTaskCaller = function (objHandle: HCkSsh; task: HCkTask): wordbool; stdcall;
  TCkSsh_OpenCustomChannel = function (objHandle: HCkSsh; channelType: PWideChar): Integer; stdcall;
  TCkSsh_OpenCustomChannelAsync = function (objHandle: HCkSsh; channelType: PWideChar): HCkTask; stdcall;
  TCkSsh_OpenDirectTcpIpChannel = function (objHandle: HCkSsh; targetHostname: PWideChar; targetPort: Integer): Integer; stdcall;
  TCkSsh_OpenDirectTcpIpChannelAsync = function (objHandle: HCkSsh; targetHostname: PWideChar; targetPort: Integer): HCkTask; stdcall;
  TCkSsh_OpenSessionChannel = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_OpenSessionChannelAsync = function (objHandle: HCkSsh): HCkTask; stdcall;
  TCkSsh_PeekReceivedText = function (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSsh__peekReceivedText = function (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar): PWideChar; stdcall;
  TCkSsh_QuickCmdCheck = function (objHandle: HCkSsh; pollTimeoutMs: Integer): Integer; stdcall;
  TCkSsh_QuickCmdCheckAsync = function (objHandle: HCkSsh; pollTimeoutMs: Integer): HCkTask; stdcall;
  TCkSsh_QuickCmdSend = function (objHandle: HCkSsh; command: PWideChar): Integer; stdcall;
  TCkSsh_QuickCmdSendAsync = function (objHandle: HCkSsh; command: PWideChar): HCkTask; stdcall;
  TCkSsh_QuickCommand = function (objHandle: HCkSsh; command: PWideChar; charset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSsh__quickCommand = function (objHandle: HCkSsh; command: PWideChar; charset: PWideChar): PWideChar; stdcall;
  TCkSsh_QuickCommandAsync = function (objHandle: HCkSsh; command: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkSsh_QuickShell = function (objHandle: HCkSsh): Integer; stdcall;
  TCkSsh_QuickShellAsync = function (objHandle: HCkSsh): HCkTask; stdcall;
  TCkSsh_ReKey = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_ReKeyAsync = function (objHandle: HCkSsh): HCkTask; stdcall;
  TCkSsh_SendIgnore = function (objHandle: HCkSsh): wordbool; stdcall;
  TCkSsh_SendIgnoreAsync = function (objHandle: HCkSsh): HCkTask; stdcall;
  TCkSsh_SendReqExec = function (objHandle: HCkSsh; channelNum: Integer; commandLine: PWideChar): wordbool; stdcall;
  TCkSsh_SendReqExecAsync = function (objHandle: HCkSsh; channelNum: Integer; commandLine: PWideChar): HCkTask; stdcall;
  TCkSsh_SendReqPty = function (objHandle: HCkSsh; channelNum: Integer; termType: PWideChar; widthInChars: Integer; heightInChars: Integer; widthInPixels: Integer; heightInPixels: Integer): wordbool; stdcall;
  TCkSsh_SendReqPtyAsync = function (objHandle: HCkSsh; channelNum: Integer; termType: PWideChar; widthInChars: Integer; heightInChars: Integer; widthInPixels: Integer; heightInPixels: Integer): HCkTask; stdcall;
  TCkSsh_SendReqSetEnv = function (objHandle: HCkSsh; channelNum: Integer; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkSsh_SendReqSetEnvAsync = function (objHandle: HCkSsh; channelNum: Integer; name: PWideChar; value: PWideChar): HCkTask; stdcall;
  TCkSsh_SendReqShell = function (objHandle: HCkSsh; channelNum: Integer): wordbool; stdcall;
  TCkSsh_SendReqShellAsync = function (objHandle: HCkSsh; channelNum: Integer): HCkTask; stdcall;
  TCkSsh_SendReqSignal = function (objHandle: HCkSsh; channelNum: Integer; signalName: PWideChar): wordbool; stdcall;
  TCkSsh_SendReqSignalAsync = function (objHandle: HCkSsh; channelNum: Integer; signalName: PWideChar): HCkTask; stdcall;
  TCkSsh_SendReqSubsystem = function (objHandle: HCkSsh; channelNum: Integer; subsystemName: PWideChar): wordbool; stdcall;
  TCkSsh_SendReqSubsystemAsync = function (objHandle: HCkSsh; channelNum: Integer; subsystemName: PWideChar): HCkTask; stdcall;
  TCkSsh_SendReqWindowChange = function (objHandle: HCkSsh; channelNum: Integer; widthInChars: Integer; heightInRows: Integer; pixWidth: Integer; pixHeight: Integer): wordbool; stdcall;
  TCkSsh_SendReqWindowChangeAsync = function (objHandle: HCkSsh; channelNum: Integer; widthInChars: Integer; heightInRows: Integer; pixWidth: Integer; pixHeight: Integer): HCkTask; stdcall;
  TCkSsh_SendReqX11Forwarding = function (objHandle: HCkSsh; channelNum: Integer; singleConnection: wordbool; authProt: PWideChar; authCookie: PWideChar; screenNum: Integer): wordbool; stdcall;
  TCkSsh_SendReqX11ForwardingAsync = function (objHandle: HCkSsh; channelNum: Integer; singleConnection: wordbool; authProt: PWideChar; authCookie: PWideChar; screenNum: Integer): HCkTask; stdcall;
  TCkSsh_SendReqXonXoff = function (objHandle: HCkSsh; channelNum: Integer; clientCanDo: wordbool): wordbool; stdcall;
  TCkSsh_SendReqXonXoffAsync = function (objHandle: HCkSsh; channelNum: Integer; clientCanDo: wordbool): HCkTask; stdcall;
  TCkSsh_SetAllowedAlgorithms = function (objHandle: HCkSsh; json: HCkJsonObject): wordbool; stdcall;
  TCkSsh_SetTtyMode = function (objHandle: HCkSsh; ttyName: PWideChar; ttyValue: Integer): wordbool; stdcall;
  TCkSsh_StartKeyboardAuth = function (objHandle: HCkSsh; login: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSsh__startKeyboardAuth = function (objHandle: HCkSsh; login: PWideChar): PWideChar; stdcall;
  TCkSsh_StartKeyboardAuthAsync = function (objHandle: HCkSsh; login: PWideChar): HCkTask; stdcall;
  TCkSsh_WaitForChannelMessage = function (objHandle: HCkSsh; pollTimeoutMs: Integer): Integer; stdcall;
  TCkSsh_WaitForChannelMessageAsync = function (objHandle: HCkSsh; pollTimeoutMs: Integer): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..234] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkSsh_Create : HCkSsh;
begin
  result := TCkSsh_Create(_map(0, 'CkSsh_Create'));
end;

procedure CkSsh_Dispose (handle: HCkSsh);
begin
  TCkSsh_Dispose(_map(1, 'CkSsh_Dispose'))
    (handle);
end;


procedure CkSsh_SetAbortCheck (objHandle: HCkSsh; fn: TSshAbortCheck);
begin
    TCkSsh_SetAbortCheck(_map(2, 'CkSsh_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkSsh_SetProgressInfo (objHandle: HCkSsh; fn: TSshProgressInfo);
begin
    TCkSsh_SetProgressInfo(_map(3, 'CkSsh_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkSsh_SetPercentDone (objHandle: HCkSsh; fn: TSshPercentDone);
begin
    TCkSsh_SetPercentDone(_map(4, 'CkSsh_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkSsh_SetTaskCompleted (objHandle: HCkSsh; fn: TSshTaskCompleted);
begin
    TCkSsh_SetTaskCompleted(_map(5, 'CkSsh_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkSsh_getAbortCurrent (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getAbortCurrent(_map(6, 'CkSsh_getAbortCurrent'))
    (objHandle);
end;

procedure CkSsh_putAbortCurrent (objHandle: HCkSsh; newPropVal: wordbool);
begin
  TCkSsh_putAbortCurrent(_map(7, 'CkSsh_putAbortCurrent'))
    (objHandle, newPropVal);
end;

function CkSsh_getAuthFailReason (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getAuthFailReason(_map(8, 'CkSsh_getAuthFailReason'))
    (objHandle);
end;

function CkSsh_getCaretControl (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getCaretControl(_map(9, 'CkSsh_getCaretControl'))
    (objHandle);
end;

procedure CkSsh_putCaretControl (objHandle: HCkSsh; newPropVal: wordbool);
begin
  TCkSsh_putCaretControl(_map(10, 'CkSsh_putCaretControl'))
    (objHandle, newPropVal);
end;

function CkSsh_getChannelOpenFailCode (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getChannelOpenFailCode(_map(11, 'CkSsh_getChannelOpenFailCode'))
    (objHandle);
end;

procedure CkSsh_getChannelOpenFailReason (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getChannelOpenFailReason(_map(12, 'CkSsh_getChannelOpenFailReason'))
    (objHandle, outPropVal);
end;

function CkSsh__channelOpenFailReason (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__channelOpenFailReason(_map(13, 'CkSsh__channelOpenFailReason'))
    (objHandle);
end;

procedure CkSsh_getClientIdentifier (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getClientIdentifier(_map(14, 'CkSsh_getClientIdentifier'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putClientIdentifier (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putClientIdentifier(_map(15, 'CkSsh_putClientIdentifier'))
    (objHandle, newPropVal);
end;

function CkSsh__clientIdentifier (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__clientIdentifier(_map(16, 'CkSsh__clientIdentifier'))
    (objHandle);
end;

procedure CkSsh_getClientIpAddress (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getClientIpAddress(_map(17, 'CkSsh_getClientIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putClientIpAddress (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putClientIpAddress(_map(18, 'CkSsh_putClientIpAddress'))
    (objHandle, newPropVal);
end;

function CkSsh__clientIpAddress (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__clientIpAddress(_map(19, 'CkSsh__clientIpAddress'))
    (objHandle);
end;

function CkSsh_getClientPort (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getClientPort(_map(20, 'CkSsh_getClientPort'))
    (objHandle);
end;

procedure CkSsh_putClientPort (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putClientPort(_map(21, 'CkSsh_putClientPort'))
    (objHandle, newPropVal);
end;

function CkSsh_getConnectTimeoutMs (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getConnectTimeoutMs(_map(22, 'CkSsh_getConnectTimeoutMs'))
    (objHandle);
end;

procedure CkSsh_putConnectTimeoutMs (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putConnectTimeoutMs(_map(23, 'CkSsh_putConnectTimeoutMs'))
    (objHandle, newPropVal);
end;

procedure CkSsh_getDebugLogFilePath (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getDebugLogFilePath(_map(24, 'CkSsh_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putDebugLogFilePath (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putDebugLogFilePath(_map(25, 'CkSsh_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkSsh__debugLogFilePath (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__debugLogFilePath(_map(26, 'CkSsh__debugLogFilePath'))
    (objHandle);
end;

function CkSsh_getDisconnectCode (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getDisconnectCode(_map(27, 'CkSsh_getDisconnectCode'))
    (objHandle);
end;

procedure CkSsh_getDisconnectReason (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getDisconnectReason(_map(28, 'CkSsh_getDisconnectReason'))
    (objHandle, outPropVal);
end;

function CkSsh__disconnectReason (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__disconnectReason(_map(29, 'CkSsh__disconnectReason'))
    (objHandle);
end;

function CkSsh_getEnableCompression (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getEnableCompression(_map(30, 'CkSsh_getEnableCompression'))
    (objHandle);
end;

procedure CkSsh_putEnableCompression (objHandle: HCkSsh; newPropVal: wordbool);
begin
  TCkSsh_putEnableCompression(_map(31, 'CkSsh_putEnableCompression'))
    (objHandle, newPropVal);
end;

procedure CkSsh_getForceCipher (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getForceCipher(_map(32, 'CkSsh_getForceCipher'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putForceCipher (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putForceCipher(_map(33, 'CkSsh_putForceCipher'))
    (objHandle, newPropVal);
end;

function CkSsh__forceCipher (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__forceCipher(_map(34, 'CkSsh__forceCipher'))
    (objHandle);
end;

function CkSsh_getHeartbeatMs (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getHeartbeatMs(_map(35, 'CkSsh_getHeartbeatMs'))
    (objHandle);
end;

procedure CkSsh_putHeartbeatMs (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putHeartbeatMs(_map(36, 'CkSsh_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkSsh_getHostKeyAlg (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getHostKeyAlg(_map(37, 'CkSsh_getHostKeyAlg'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putHostKeyAlg (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putHostKeyAlg(_map(38, 'CkSsh_putHostKeyAlg'))
    (objHandle, newPropVal);
end;

function CkSsh__hostKeyAlg (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__hostKeyAlg(_map(39, 'CkSsh__hostKeyAlg'))
    (objHandle);
end;

procedure CkSsh_getHostKeyFingerprint (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getHostKeyFingerprint(_map(40, 'CkSsh_getHostKeyFingerprint'))
    (objHandle, outPropVal);
end;

function CkSsh__hostKeyFingerprint (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__hostKeyFingerprint(_map(41, 'CkSsh__hostKeyFingerprint'))
    (objHandle);
end;

procedure CkSsh_getHttpProxyAuthMethod (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getHttpProxyAuthMethod(_map(42, 'CkSsh_getHttpProxyAuthMethod'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putHttpProxyAuthMethod (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putHttpProxyAuthMethod(_map(43, 'CkSsh_putHttpProxyAuthMethod'))
    (objHandle, newPropVal);
end;

function CkSsh__httpProxyAuthMethod (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__httpProxyAuthMethod(_map(44, 'CkSsh__httpProxyAuthMethod'))
    (objHandle);
end;

procedure CkSsh_getHttpProxyDomain (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getHttpProxyDomain(_map(45, 'CkSsh_getHttpProxyDomain'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putHttpProxyDomain (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putHttpProxyDomain(_map(46, 'CkSsh_putHttpProxyDomain'))
    (objHandle, newPropVal);
end;

function CkSsh__httpProxyDomain (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__httpProxyDomain(_map(47, 'CkSsh__httpProxyDomain'))
    (objHandle);
end;

procedure CkSsh_getHttpProxyHostname (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getHttpProxyHostname(_map(48, 'CkSsh_getHttpProxyHostname'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putHttpProxyHostname (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putHttpProxyHostname(_map(49, 'CkSsh_putHttpProxyHostname'))
    (objHandle, newPropVal);
end;

function CkSsh__httpProxyHostname (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__httpProxyHostname(_map(50, 'CkSsh__httpProxyHostname'))
    (objHandle);
end;

procedure CkSsh_getHttpProxyPassword (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getHttpProxyPassword(_map(51, 'CkSsh_getHttpProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putHttpProxyPassword (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putHttpProxyPassword(_map(52, 'CkSsh_putHttpProxyPassword'))
    (objHandle, newPropVal);
end;

function CkSsh__httpProxyPassword (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__httpProxyPassword(_map(53, 'CkSsh__httpProxyPassword'))
    (objHandle);
end;

function CkSsh_getHttpProxyPort (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getHttpProxyPort(_map(54, 'CkSsh_getHttpProxyPort'))
    (objHandle);
end;

procedure CkSsh_putHttpProxyPort (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putHttpProxyPort(_map(55, 'CkSsh_putHttpProxyPort'))
    (objHandle, newPropVal);
end;

procedure CkSsh_getHttpProxyUsername (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getHttpProxyUsername(_map(56, 'CkSsh_getHttpProxyUsername'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putHttpProxyUsername (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putHttpProxyUsername(_map(57, 'CkSsh_putHttpProxyUsername'))
    (objHandle, newPropVal);
end;

function CkSsh__httpProxyUsername (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__httpProxyUsername(_map(58, 'CkSsh__httpProxyUsername'))
    (objHandle);
end;

function CkSsh_getIdleTimeoutMs (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getIdleTimeoutMs(_map(59, 'CkSsh_getIdleTimeoutMs'))
    (objHandle);
end;

procedure CkSsh_putIdleTimeoutMs (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putIdleTimeoutMs(_map(60, 'CkSsh_putIdleTimeoutMs'))
    (objHandle, newPropVal);
end;

function CkSsh_getIsConnected (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getIsConnected(_map(61, 'CkSsh_getIsConnected'))
    (objHandle);
end;

function CkSsh_getKeepSessionLog (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getKeepSessionLog(_map(62, 'CkSsh_getKeepSessionLog'))
    (objHandle);
end;

procedure CkSsh_putKeepSessionLog (objHandle: HCkSsh; newPropVal: wordbool);
begin
  TCkSsh_putKeepSessionLog(_map(63, 'CkSsh_putKeepSessionLog'))
    (objHandle, newPropVal);
end;

procedure CkSsh_getLastErrorHtml (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getLastErrorHtml(_map(64, 'CkSsh_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkSsh__lastErrorHtml (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__lastErrorHtml(_map(65, 'CkSsh__lastErrorHtml'))
    (objHandle);
end;

procedure CkSsh_getLastErrorText (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getLastErrorText(_map(66, 'CkSsh_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkSsh__lastErrorText (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__lastErrorText(_map(67, 'CkSsh__lastErrorText'))
    (objHandle);
end;

procedure CkSsh_getLastErrorXml (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getLastErrorXml(_map(68, 'CkSsh_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkSsh__lastErrorXml (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__lastErrorXml(_map(69, 'CkSsh__lastErrorXml'))
    (objHandle);
end;

function CkSsh_getLastMethodSuccess (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getLastMethodSuccess(_map(70, 'CkSsh_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkSsh_putLastMethodSuccess (objHandle: HCkSsh; newPropVal: wordbool);
begin
  TCkSsh_putLastMethodSuccess(_map(71, 'CkSsh_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkSsh_getMaxPacketSize (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getMaxPacketSize(_map(72, 'CkSsh_getMaxPacketSize'))
    (objHandle);
end;

procedure CkSsh_putMaxPacketSize (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putMaxPacketSize(_map(73, 'CkSsh_putMaxPacketSize'))
    (objHandle, newPropVal);
end;

function CkSsh_getNumOpenChannels (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getNumOpenChannels(_map(74, 'CkSsh_getNumOpenChannels'))
    (objHandle);
end;

function CkSsh_getPasswordChangeRequested (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getPasswordChangeRequested(_map(75, 'CkSsh_getPasswordChangeRequested'))
    (objHandle);
end;

function CkSsh_getPreferIpv6 (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getPreferIpv6(_map(76, 'CkSsh_getPreferIpv6'))
    (objHandle);
end;

procedure CkSsh_putPreferIpv6 (objHandle: HCkSsh; newPropVal: wordbool);
begin
  TCkSsh_putPreferIpv6(_map(77, 'CkSsh_putPreferIpv6'))
    (objHandle, newPropVal);
end;

function CkSsh_getReadTimeoutMs (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getReadTimeoutMs(_map(78, 'CkSsh_getReadTimeoutMs'))
    (objHandle);
end;

procedure CkSsh_putReadTimeoutMs (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putReadTimeoutMs(_map(79, 'CkSsh_putReadTimeoutMs'))
    (objHandle, newPropVal);
end;

procedure CkSsh_getReqExecCharset (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getReqExecCharset(_map(80, 'CkSsh_getReqExecCharset'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putReqExecCharset (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putReqExecCharset(_map(81, 'CkSsh_putReqExecCharset'))
    (objHandle, newPropVal);
end;

function CkSsh__reqExecCharset (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__reqExecCharset(_map(82, 'CkSsh__reqExecCharset'))
    (objHandle);
end;

procedure CkSsh_getServerIdentifier (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getServerIdentifier(_map(83, 'CkSsh_getServerIdentifier'))
    (objHandle, outPropVal);
end;

function CkSsh__serverIdentifier (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__serverIdentifier(_map(84, 'CkSsh__serverIdentifier'))
    (objHandle);
end;

procedure CkSsh_getSessionLog (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getSessionLog(_map(85, 'CkSsh_getSessionLog'))
    (objHandle, outPropVal);
end;

function CkSsh__sessionLog (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__sessionLog(_map(86, 'CkSsh__sessionLog'))
    (objHandle);
end;

procedure CkSsh_getSocksHostname (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getSocksHostname(_map(87, 'CkSsh_getSocksHostname'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putSocksHostname (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putSocksHostname(_map(88, 'CkSsh_putSocksHostname'))
    (objHandle, newPropVal);
end;

function CkSsh__socksHostname (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__socksHostname(_map(89, 'CkSsh__socksHostname'))
    (objHandle);
end;

procedure CkSsh_getSocksPassword (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getSocksPassword(_map(90, 'CkSsh_getSocksPassword'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putSocksPassword (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putSocksPassword(_map(91, 'CkSsh_putSocksPassword'))
    (objHandle, newPropVal);
end;

function CkSsh__socksPassword (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__socksPassword(_map(92, 'CkSsh__socksPassword'))
    (objHandle);
end;

function CkSsh_getSocksPort (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getSocksPort(_map(93, 'CkSsh_getSocksPort'))
    (objHandle);
end;

procedure CkSsh_putSocksPort (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putSocksPort(_map(94, 'CkSsh_putSocksPort'))
    (objHandle, newPropVal);
end;

procedure CkSsh_getSocksUsername (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getSocksUsername(_map(95, 'CkSsh_getSocksUsername'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putSocksUsername (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putSocksUsername(_map(96, 'CkSsh_putSocksUsername'))
    (objHandle, newPropVal);
end;

function CkSsh__socksUsername (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__socksUsername(_map(97, 'CkSsh__socksUsername'))
    (objHandle);
end;

function CkSsh_getSocksVersion (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getSocksVersion(_map(98, 'CkSsh_getSocksVersion'))
    (objHandle);
end;

procedure CkSsh_putSocksVersion (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putSocksVersion(_map(99, 'CkSsh_putSocksVersion'))
    (objHandle, newPropVal);
end;

function CkSsh_getSoRcvBuf (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getSoRcvBuf(_map(100, 'CkSsh_getSoRcvBuf'))
    (objHandle);
end;

procedure CkSsh_putSoRcvBuf (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putSoRcvBuf(_map(101, 'CkSsh_putSoRcvBuf'))
    (objHandle, newPropVal);
end;

function CkSsh_getSoSndBuf (objHandle: HCkSsh): Integer;
begin
    result := TCkSsh_getSoSndBuf(_map(102, 'CkSsh_getSoSndBuf'))
    (objHandle);
end;

procedure CkSsh_putSoSndBuf (objHandle: HCkSsh; newPropVal: Integer);
begin
  TCkSsh_putSoSndBuf(_map(103, 'CkSsh_putSoSndBuf'))
    (objHandle, newPropVal);
end;

function CkSsh_getStderrToStdout (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getStderrToStdout(_map(104, 'CkSsh_getStderrToStdout'))
    (objHandle);
end;

procedure CkSsh_putStderrToStdout (objHandle: HCkSsh; newPropVal: wordbool);
begin
  TCkSsh_putStderrToStdout(_map(105, 'CkSsh_putStderrToStdout'))
    (objHandle, newPropVal);
end;

function CkSsh_getStripColorCodes (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getStripColorCodes(_map(106, 'CkSsh_getStripColorCodes'))
    (objHandle);
end;

procedure CkSsh_putStripColorCodes (objHandle: HCkSsh; newPropVal: wordbool);
begin
  TCkSsh_putStripColorCodes(_map(107, 'CkSsh_putStripColorCodes'))
    (objHandle, newPropVal);
end;

function CkSsh_getTcpNoDelay (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getTcpNoDelay(_map(108, 'CkSsh_getTcpNoDelay'))
    (objHandle);
end;

procedure CkSsh_putTcpNoDelay (objHandle: HCkSsh; newPropVal: wordbool);
begin
  TCkSsh_putTcpNoDelay(_map(109, 'CkSsh_putTcpNoDelay'))
    (objHandle, newPropVal);
end;

procedure CkSsh_getUncommonOptions (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getUncommonOptions(_map(110, 'CkSsh_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putUncommonOptions (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putUncommonOptions(_map(111, 'CkSsh_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkSsh__uncommonOptions (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__uncommonOptions(_map(112, 'CkSsh__uncommonOptions'))
    (objHandle);
end;

procedure CkSsh_getUserAuthBanner (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getUserAuthBanner(_map(113, 'CkSsh_getUserAuthBanner'))
    (objHandle, outPropVal);
end;

procedure CkSsh_putUserAuthBanner (objHandle: HCkSsh; newPropVal: PWideChar);
begin
  TCkSsh_putUserAuthBanner(_map(114, 'CkSsh_putUserAuthBanner'))
    (objHandle, newPropVal);
end;

function CkSsh__userAuthBanner (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__userAuthBanner(_map(115, 'CkSsh__userAuthBanner'))
    (objHandle);
end;

function CkSsh_getVerboseLogging (objHandle: HCkSsh): wordbool;
begin
    result := TCkSsh_getVerboseLogging(_map(116, 'CkSsh_getVerboseLogging'))
    (objHandle);
end;

procedure CkSsh_putVerboseLogging (objHandle: HCkSsh; newPropVal: wordbool);
begin
  TCkSsh_putVerboseLogging(_map(117, 'CkSsh_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkSsh_getVersion (objHandle: HCkSsh; outPropVal: HCkString);
begin
  TCkSsh_getVersion(_map(118, 'CkSsh_getVersion'))
    (objHandle, outPropVal);
end;

function CkSsh__version (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__version(_map(119, 'CkSsh__version'))
    (objHandle);
end;

function CkSsh_AuthenticatePk (objHandle: HCkSsh; username: PWideChar; privateKey: HCkSshKey): wordbool;
begin
  result := TCkSsh_AuthenticatePk(_map(120, 'CkSsh_AuthenticatePk'))
    (objHandle, username, privateKey);
end;

function CkSsh_AuthenticatePkAsync (objHandle: HCkSsh; username: PWideChar; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkSsh_AuthenticatePkAsync(_map(121, 'CkSsh_AuthenticatePkAsync'))
    (objHandle, username, privateKey);
end;

function CkSsh_AuthenticatePw (objHandle: HCkSsh; login: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkSsh_AuthenticatePw(_map(122, 'CkSsh_AuthenticatePw'))
    (objHandle, login, password);
end;

function CkSsh_AuthenticatePwAsync (objHandle: HCkSsh; login: PWideChar; password: PWideChar): HCkTask;
begin
  result := TCkSsh_AuthenticatePwAsync(_map(123, 'CkSsh_AuthenticatePwAsync'))
    (objHandle, login, password);
end;

function CkSsh_AuthenticatePwPk (objHandle: HCkSsh; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): wordbool;
begin
  result := TCkSsh_AuthenticatePwPk(_map(124, 'CkSsh_AuthenticatePwPk'))
    (objHandle, username, password, privateKey);
end;

function CkSsh_AuthenticatePwPkAsync (objHandle: HCkSsh; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkSsh_AuthenticatePwPkAsync(_map(125, 'CkSsh_AuthenticatePwPkAsync'))
    (objHandle, username, password, privateKey);
end;

function CkSsh_AuthenticateSecPw (objHandle: HCkSsh; login: HCkSecureString; password: HCkSecureString): wordbool;
begin
  result := TCkSsh_AuthenticateSecPw(_map(126, 'CkSsh_AuthenticateSecPw'))
    (objHandle, login, password);
end;

function CkSsh_AuthenticateSecPwAsync (objHandle: HCkSsh; login: HCkSecureString; password: HCkSecureString): HCkTask;
begin
  result := TCkSsh_AuthenticateSecPwAsync(_map(127, 'CkSsh_AuthenticateSecPwAsync'))
    (objHandle, login, password);
end;

function CkSsh_AuthenticateSecPwPk (objHandle: HCkSsh; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): wordbool;
begin
  result := TCkSsh_AuthenticateSecPwPk(_map(128, 'CkSsh_AuthenticateSecPwPk'))
    (objHandle, username, password, privateKey);
end;

function CkSsh_AuthenticateSecPwPkAsync (objHandle: HCkSsh; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkSsh_AuthenticateSecPwPkAsync(_map(129, 'CkSsh_AuthenticateSecPwPkAsync'))
    (objHandle, username, password, privateKey);
end;

function CkSsh_ChannelIsOpen (objHandle: HCkSsh; channelNum: Integer): wordbool;
begin
  result := TCkSsh_ChannelIsOpen(_map(130, 'CkSsh_ChannelIsOpen'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelPoll (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): Integer;
begin
  result := TCkSsh_ChannelPoll(_map(131, 'CkSsh_ChannelPoll'))
    (objHandle, channelNum, pollTimeoutMs);
end;

function CkSsh_ChannelPollAsync (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): HCkTask;
begin
  result := TCkSsh_ChannelPollAsync(_map(132, 'CkSsh_ChannelPollAsync'))
    (objHandle, channelNum, pollTimeoutMs);
end;

function CkSsh_ChannelRead (objHandle: HCkSsh; channelNum: Integer): Integer;
begin
  result := TCkSsh_ChannelRead(_map(133, 'CkSsh_ChannelRead'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelReadAsync (objHandle: HCkSsh; channelNum: Integer): HCkTask;
begin
  result := TCkSsh_ChannelReadAsync(_map(134, 'CkSsh_ChannelReadAsync'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelReadAndPoll (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): Integer;
begin
  result := TCkSsh_ChannelReadAndPoll(_map(135, 'CkSsh_ChannelReadAndPoll'))
    (objHandle, channelNum, pollTimeoutMs);
end;

function CkSsh_ChannelReadAndPollAsync (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer): HCkTask;
begin
  result := TCkSsh_ChannelReadAndPollAsync(_map(136, 'CkSsh_ChannelReadAndPollAsync'))
    (objHandle, channelNum, pollTimeoutMs);
end;

function CkSsh_ChannelReadAndPoll2 (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer; maxNumBytes: Integer): Integer;
begin
  result := TCkSsh_ChannelReadAndPoll2(_map(137, 'CkSsh_ChannelReadAndPoll2'))
    (objHandle, channelNum, pollTimeoutMs, maxNumBytes);
end;

function CkSsh_ChannelReadAndPoll2Async (objHandle: HCkSsh; channelNum: Integer; pollTimeoutMs: Integer; maxNumBytes: Integer): HCkTask;
begin
  result := TCkSsh_ChannelReadAndPoll2Async(_map(138, 'CkSsh_ChannelReadAndPoll2Async'))
    (objHandle, channelNum, pollTimeoutMs, maxNumBytes);
end;

function CkSsh_ChannelReceivedClose (objHandle: HCkSsh; channelNum: Integer): wordbool;
begin
  result := TCkSsh_ChannelReceivedClose(_map(139, 'CkSsh_ChannelReceivedClose'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelReceivedEof (objHandle: HCkSsh; channelNum: Integer): wordbool;
begin
  result := TCkSsh_ChannelReceivedEof(_map(140, 'CkSsh_ChannelReceivedEof'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelReceivedExitStatus (objHandle: HCkSsh; channelNum: Integer): wordbool;
begin
  result := TCkSsh_ChannelReceivedExitStatus(_map(141, 'CkSsh_ChannelReceivedExitStatus'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelReceiveToClose (objHandle: HCkSsh; channelNum: Integer): wordbool;
begin
  result := TCkSsh_ChannelReceiveToClose(_map(142, 'CkSsh_ChannelReceiveToClose'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelReceiveToCloseAsync (objHandle: HCkSsh; channelNum: Integer): HCkTask;
begin
  result := TCkSsh_ChannelReceiveToCloseAsync(_map(143, 'CkSsh_ChannelReceiveToCloseAsync'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelReceiveUntilMatch (objHandle: HCkSsh; channelNum: Integer; matchPattern: PWideChar; charset: PWideChar; caseSensitive: wordbool): wordbool;
begin
  result := TCkSsh_ChannelReceiveUntilMatch(_map(144, 'CkSsh_ChannelReceiveUntilMatch'))
    (objHandle, channelNum, matchPattern, charset, caseSensitive);
end;

function CkSsh_ChannelReceiveUntilMatchAsync (objHandle: HCkSsh; channelNum: Integer; matchPattern: PWideChar; charset: PWideChar; caseSensitive: wordbool): HCkTask;
begin
  result := TCkSsh_ChannelReceiveUntilMatchAsync(_map(145, 'CkSsh_ChannelReceiveUntilMatchAsync'))
    (objHandle, channelNum, matchPattern, charset, caseSensitive);
end;

function CkSsh_ChannelReceiveUntilMatchN (objHandle: HCkSsh; channelNum: Integer; matchPatterns: HCkStringArray; charset: PWideChar; caseSensitive: wordbool): wordbool;
begin
  result := TCkSsh_ChannelReceiveUntilMatchN(_map(146, 'CkSsh_ChannelReceiveUntilMatchN'))
    (objHandle, channelNum, matchPatterns, charset, caseSensitive);
end;

function CkSsh_ChannelReceiveUntilMatchNAsync (objHandle: HCkSsh; channelNum: Integer; matchPatterns: HCkStringArray; charset: PWideChar; caseSensitive: wordbool): HCkTask;
begin
  result := TCkSsh_ChannelReceiveUntilMatchNAsync(_map(147, 'CkSsh_ChannelReceiveUntilMatchNAsync'))
    (objHandle, channelNum, matchPatterns, charset, caseSensitive);
end;

procedure CkSsh_ChannelRelease (objHandle: HCkSsh; channelNum: Integer);
begin
  TCkSsh_ChannelRelease(_map(148, 'CkSsh_ChannelRelease'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelSendClose (objHandle: HCkSsh; channelNum: Integer): wordbool;
begin
  result := TCkSsh_ChannelSendClose(_map(149, 'CkSsh_ChannelSendClose'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelSendCloseAsync (objHandle: HCkSsh; channelNum: Integer): HCkTask;
begin
  result := TCkSsh_ChannelSendCloseAsync(_map(150, 'CkSsh_ChannelSendCloseAsync'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelSendData (objHandle: HCkSsh; channelNum: Integer; byteData: HCkByteData): wordbool;
begin
  result := TCkSsh_ChannelSendData(_map(151, 'CkSsh_ChannelSendData'))
    (objHandle, channelNum, byteData);
end;

function CkSsh_ChannelSendDataAsync (objHandle: HCkSsh; channelNum: Integer; byteData: HCkByteData): HCkTask;
begin
  result := TCkSsh_ChannelSendDataAsync(_map(152, 'CkSsh_ChannelSendDataAsync'))
    (objHandle, channelNum, byteData);
end;

function CkSsh_ChannelSendEof (objHandle: HCkSsh; channelNum: Integer): wordbool;
begin
  result := TCkSsh_ChannelSendEof(_map(153, 'CkSsh_ChannelSendEof'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelSendEofAsync (objHandle: HCkSsh; channelNum: Integer): HCkTask;
begin
  result := TCkSsh_ChannelSendEofAsync(_map(154, 'CkSsh_ChannelSendEofAsync'))
    (objHandle, channelNum);
end;

function CkSsh_ChannelSendString (objHandle: HCkSsh; channelNum: Integer; textData: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkSsh_ChannelSendString(_map(155, 'CkSsh_ChannelSendString'))
    (objHandle, channelNum, textData, charset);
end;

function CkSsh_ChannelSendStringAsync (objHandle: HCkSsh; channelNum: Integer; textData: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkSsh_ChannelSendStringAsync(_map(156, 'CkSsh_ChannelSendStringAsync'))
    (objHandle, channelNum, textData, charset);
end;

function CkSsh_CheckConnection (objHandle: HCkSsh): wordbool;
begin
  result := TCkSsh_CheckConnection(_map(157, 'CkSsh_CheckConnection'))
    (objHandle);
end;

procedure CkSsh_ClearTtyModes (objHandle: HCkSsh);
begin
  TCkSsh_ClearTtyModes(_map(158, 'CkSsh_ClearTtyModes'))
    (objHandle);
end;

function CkSsh_Connect (objHandle: HCkSsh; domainName: PWideChar; port: Integer): wordbool;
begin
  result := TCkSsh_Connect(_map(159, 'CkSsh_Connect'))
    (objHandle, domainName, port);
end;

function CkSsh_ConnectAsync (objHandle: HCkSsh; domainName: PWideChar; port: Integer): HCkTask;
begin
  result := TCkSsh_ConnectAsync(_map(160, 'CkSsh_ConnectAsync'))
    (objHandle, domainName, port);
end;

function CkSsh_ConnectThroughSsh (objHandle: HCkSsh; ssh: HCkSsh; hostname: PWideChar; port: Integer): wordbool;
begin
  result := TCkSsh_ConnectThroughSsh(_map(161, 'CkSsh_ConnectThroughSsh'))
    (objHandle, ssh, hostname, port);
end;

function CkSsh_ConnectThroughSshAsync (objHandle: HCkSsh; ssh: HCkSsh; hostname: PWideChar; port: Integer): HCkTask;
begin
  result := TCkSsh_ConnectThroughSshAsync(_map(162, 'CkSsh_ConnectThroughSshAsync'))
    (objHandle, ssh, hostname, port);
end;

function CkSsh_ContinueKeyboardAuth (objHandle: HCkSsh; response: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSsh_ContinueKeyboardAuth(_map(163, 'CkSsh_ContinueKeyboardAuth'))
    (objHandle, response, outStr);
end;

function CkSsh__continueKeyboardAuth (objHandle: HCkSsh; response: PWideChar): PWideChar;
begin
  result := TCkSsh__continueKeyboardAuth(_map(164, 'CkSsh__continueKeyboardAuth'))
    (objHandle, response);
end;

function CkSsh_ContinueKeyboardAuthAsync (objHandle: HCkSsh; response: PWideChar): HCkTask;
begin
  result := TCkSsh_ContinueKeyboardAuthAsync(_map(165, 'CkSsh_ContinueKeyboardAuthAsync'))
    (objHandle, response);
end;

procedure CkSsh_Disconnect (objHandle: HCkSsh);
begin
  TCkSsh_Disconnect(_map(166, 'CkSsh_Disconnect'))
    (objHandle);
end;

function CkSsh_GetAuthMethods (objHandle: HCkSsh; outStr: HCkString): wordbool;
begin
  result := TCkSsh_GetAuthMethods(_map(167, 'CkSsh_GetAuthMethods'))
    (objHandle, outStr);
end;

function CkSsh__getAuthMethods (objHandle: HCkSsh): PWideChar;
begin
  result := TCkSsh__getAuthMethods(_map(168, 'CkSsh__getAuthMethods'))
    (objHandle);
end;

function CkSsh_GetAuthMethodsAsync (objHandle: HCkSsh): HCkTask;
begin
  result := TCkSsh_GetAuthMethodsAsync(_map(169, 'CkSsh_GetAuthMethodsAsync'))
    (objHandle);
end;

function CkSsh_GetChannelExitStatus (objHandle: HCkSsh; channelNum: Integer): Integer;
begin
  result := TCkSsh_GetChannelExitStatus(_map(170, 'CkSsh_GetChannelExitStatus'))
    (objHandle, channelNum);
end;

function CkSsh_GetChannelNumber (objHandle: HCkSsh; index: Integer): Integer;
begin
  result := TCkSsh_GetChannelNumber(_map(171, 'CkSsh_GetChannelNumber'))
    (objHandle, index);
end;

function CkSsh_GetChannelType (objHandle: HCkSsh; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkSsh_GetChannelType(_map(172, 'CkSsh_GetChannelType'))
    (objHandle, index, outStr);
end;

function CkSsh__getChannelType (objHandle: HCkSsh; index: Integer): PWideChar;
begin
  result := TCkSsh__getChannelType(_map(173, 'CkSsh__getChannelType'))
    (objHandle, index);
end;

function CkSsh_GetHostKeyFP (objHandle: HCkSsh; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkSsh_GetHostKeyFP(_map(174, 'CkSsh_GetHostKeyFP'))
    (objHandle, hashAlg, includeKeyType, includeHashName, outStr);
end;

function CkSsh__getHostKeyFP (objHandle: HCkSsh; hashAlg: PWideChar; includeKeyType: wordbool; includeHashName: wordbool): PWideChar;
begin
  result := TCkSsh__getHostKeyFP(_map(175, 'CkSsh__getHostKeyFP'))
    (objHandle, hashAlg, includeKeyType, includeHashName);
end;

procedure CkSsh_GetLastJsonData (objHandle: HCkSsh; json: HCkJsonObject);
begin
  TCkSsh_GetLastJsonData(_map(176, 'CkSsh_GetLastJsonData'))
    (objHandle, json);
end;

function CkSsh_GetReceivedData (objHandle: HCkSsh; channelNum: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkSsh_GetReceivedData(_map(177, 'CkSsh_GetReceivedData'))
    (objHandle, channelNum, outData);
end;

function CkSsh_GetReceivedDataN (objHandle: HCkSsh; channelNum: Integer; maxNumBytes: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkSsh_GetReceivedDataN(_map(178, 'CkSsh_GetReceivedDataN'))
    (objHandle, channelNum, maxNumBytes, outData);
end;

function CkSsh_GetReceivedNumBytes (objHandle: HCkSsh; channelNum: Integer): Integer;
begin
  result := TCkSsh_GetReceivedNumBytes(_map(179, 'CkSsh_GetReceivedNumBytes'))
    (objHandle, channelNum);
end;

function CkSsh_GetReceivedStderr (objHandle: HCkSsh; channelNum: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkSsh_GetReceivedStderr(_map(180, 'CkSsh_GetReceivedStderr'))
    (objHandle, channelNum, outData);
end;

function CkSsh_GetReceivedStderrText (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSsh_GetReceivedStderrText(_map(181, 'CkSsh_GetReceivedStderrText'))
    (objHandle, channelNum, charset, outStr);
end;

function CkSsh__getReceivedStderrText (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar): PWideChar;
begin
  result := TCkSsh__getReceivedStderrText(_map(182, 'CkSsh__getReceivedStderrText'))
    (objHandle, channelNum, charset);
end;

function CkSsh_GetReceivedText (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSsh_GetReceivedText(_map(183, 'CkSsh_GetReceivedText'))
    (objHandle, channelNum, charset, outStr);
end;

function CkSsh__getReceivedText (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar): PWideChar;
begin
  result := TCkSsh__getReceivedText(_map(184, 'CkSsh__getReceivedText'))
    (objHandle, channelNum, charset);
end;

function CkSsh_GetReceivedTextS (objHandle: HCkSsh; channelNum: Integer; substr: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSsh_GetReceivedTextS(_map(185, 'CkSsh_GetReceivedTextS'))
    (objHandle, channelNum, substr, charset, outStr);
end;

function CkSsh__getReceivedTextS (objHandle: HCkSsh; channelNum: Integer; substr: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkSsh__getReceivedTextS(_map(186, 'CkSsh__getReceivedTextS'))
    (objHandle, channelNum, substr, charset);
end;

function CkSsh_LastJsonData (objHandle: HCkSsh): HCkJsonObject;
begin
  result := TCkSsh_LastJsonData(_map(187, 'CkSsh_LastJsonData'))
    (objHandle);
end;

function CkSsh_LoadTaskCaller (objHandle: HCkSsh; task: HCkTask): wordbool;
begin
  result := TCkSsh_LoadTaskCaller(_map(188, 'CkSsh_LoadTaskCaller'))
    (objHandle, task);
end;

function CkSsh_OpenCustomChannel (objHandle: HCkSsh; channelType: PWideChar): Integer;
begin
  result := TCkSsh_OpenCustomChannel(_map(189, 'CkSsh_OpenCustomChannel'))
    (objHandle, channelType);
end;

function CkSsh_OpenCustomChannelAsync (objHandle: HCkSsh; channelType: PWideChar): HCkTask;
begin
  result := TCkSsh_OpenCustomChannelAsync(_map(190, 'CkSsh_OpenCustomChannelAsync'))
    (objHandle, channelType);
end;

function CkSsh_OpenDirectTcpIpChannel (objHandle: HCkSsh; targetHostname: PWideChar; targetPort: Integer): Integer;
begin
  result := TCkSsh_OpenDirectTcpIpChannel(_map(191, 'CkSsh_OpenDirectTcpIpChannel'))
    (objHandle, targetHostname, targetPort);
end;

function CkSsh_OpenDirectTcpIpChannelAsync (objHandle: HCkSsh; targetHostname: PWideChar; targetPort: Integer): HCkTask;
begin
  result := TCkSsh_OpenDirectTcpIpChannelAsync(_map(192, 'CkSsh_OpenDirectTcpIpChannelAsync'))
    (objHandle, targetHostname, targetPort);
end;

function CkSsh_OpenSessionChannel (objHandle: HCkSsh): Integer;
begin
  result := TCkSsh_OpenSessionChannel(_map(193, 'CkSsh_OpenSessionChannel'))
    (objHandle);
end;

function CkSsh_OpenSessionChannelAsync (objHandle: HCkSsh): HCkTask;
begin
  result := TCkSsh_OpenSessionChannelAsync(_map(194, 'CkSsh_OpenSessionChannelAsync'))
    (objHandle);
end;

function CkSsh_PeekReceivedText (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSsh_PeekReceivedText(_map(195, 'CkSsh_PeekReceivedText'))
    (objHandle, channelNum, charset, outStr);
end;

function CkSsh__peekReceivedText (objHandle: HCkSsh; channelNum: Integer; charset: PWideChar): PWideChar;
begin
  result := TCkSsh__peekReceivedText(_map(196, 'CkSsh__peekReceivedText'))
    (objHandle, channelNum, charset);
end;

function CkSsh_QuickCmdCheck (objHandle: HCkSsh; pollTimeoutMs: Integer): Integer;
begin
  result := TCkSsh_QuickCmdCheck(_map(197, 'CkSsh_QuickCmdCheck'))
    (objHandle, pollTimeoutMs);
end;

function CkSsh_QuickCmdCheckAsync (objHandle: HCkSsh; pollTimeoutMs: Integer): HCkTask;
begin
  result := TCkSsh_QuickCmdCheckAsync(_map(198, 'CkSsh_QuickCmdCheckAsync'))
    (objHandle, pollTimeoutMs);
end;

function CkSsh_QuickCmdSend (objHandle: HCkSsh; command: PWideChar): Integer;
begin
  result := TCkSsh_QuickCmdSend(_map(199, 'CkSsh_QuickCmdSend'))
    (objHandle, command);
end;

function CkSsh_QuickCmdSendAsync (objHandle: HCkSsh; command: PWideChar): HCkTask;
begin
  result := TCkSsh_QuickCmdSendAsync(_map(200, 'CkSsh_QuickCmdSendAsync'))
    (objHandle, command);
end;

function CkSsh_QuickCommand (objHandle: HCkSsh; command: PWideChar; charset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSsh_QuickCommand(_map(201, 'CkSsh_QuickCommand'))
    (objHandle, command, charset, outStr);
end;

function CkSsh__quickCommand (objHandle: HCkSsh; command: PWideChar; charset: PWideChar): PWideChar;
begin
  result := TCkSsh__quickCommand(_map(202, 'CkSsh__quickCommand'))
    (objHandle, command, charset);
end;

function CkSsh_QuickCommandAsync (objHandle: HCkSsh; command: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkSsh_QuickCommandAsync(_map(203, 'CkSsh_QuickCommandAsync'))
    (objHandle, command, charset);
end;

function CkSsh_QuickShell (objHandle: HCkSsh): Integer;
begin
  result := TCkSsh_QuickShell(_map(204, 'CkSsh_QuickShell'))
    (objHandle);
end;

function CkSsh_QuickShellAsync (objHandle: HCkSsh): HCkTask;
begin
  result := TCkSsh_QuickShellAsync(_map(205, 'CkSsh_QuickShellAsync'))
    (objHandle);
end;

function CkSsh_ReKey (objHandle: HCkSsh): wordbool;
begin
  result := TCkSsh_ReKey(_map(206, 'CkSsh_ReKey'))
    (objHandle);
end;

function CkSsh_ReKeyAsync (objHandle: HCkSsh): HCkTask;
begin
  result := TCkSsh_ReKeyAsync(_map(207, 'CkSsh_ReKeyAsync'))
    (objHandle);
end;

function CkSsh_SendIgnore (objHandle: HCkSsh): wordbool;
begin
  result := TCkSsh_SendIgnore(_map(208, 'CkSsh_SendIgnore'))
    (objHandle);
end;

function CkSsh_SendIgnoreAsync (objHandle: HCkSsh): HCkTask;
begin
  result := TCkSsh_SendIgnoreAsync(_map(209, 'CkSsh_SendIgnoreAsync'))
    (objHandle);
end;

function CkSsh_SendReqExec (objHandle: HCkSsh; channelNum: Integer; commandLine: PWideChar): wordbool;
begin
  result := TCkSsh_SendReqExec(_map(210, 'CkSsh_SendReqExec'))
    (objHandle, channelNum, commandLine);
end;

function CkSsh_SendReqExecAsync (objHandle: HCkSsh; channelNum: Integer; commandLine: PWideChar): HCkTask;
begin
  result := TCkSsh_SendReqExecAsync(_map(211, 'CkSsh_SendReqExecAsync'))
    (objHandle, channelNum, commandLine);
end;

function CkSsh_SendReqPty (objHandle: HCkSsh; channelNum: Integer; termType: PWideChar; widthInChars: Integer; heightInChars: Integer; widthInPixels: Integer; heightInPixels: Integer): wordbool;
begin
  result := TCkSsh_SendReqPty(_map(212, 'CkSsh_SendReqPty'))
    (objHandle, channelNum, termType, widthInChars, heightInChars, widthInPixels, heightInPixels);
end;

function CkSsh_SendReqPtyAsync (objHandle: HCkSsh; channelNum: Integer; termType: PWideChar; widthInChars: Integer; heightInChars: Integer; widthInPixels: Integer; heightInPixels: Integer): HCkTask;
begin
  result := TCkSsh_SendReqPtyAsync(_map(213, 'CkSsh_SendReqPtyAsync'))
    (objHandle, channelNum, termType, widthInChars, heightInChars, widthInPixels, heightInPixels);
end;

function CkSsh_SendReqSetEnv (objHandle: HCkSsh; channelNum: Integer; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkSsh_SendReqSetEnv(_map(214, 'CkSsh_SendReqSetEnv'))
    (objHandle, channelNum, name, value);
end;

function CkSsh_SendReqSetEnvAsync (objHandle: HCkSsh; channelNum: Integer; name: PWideChar; value: PWideChar): HCkTask;
begin
  result := TCkSsh_SendReqSetEnvAsync(_map(215, 'CkSsh_SendReqSetEnvAsync'))
    (objHandle, channelNum, name, value);
end;

function CkSsh_SendReqShell (objHandle: HCkSsh; channelNum: Integer): wordbool;
begin
  result := TCkSsh_SendReqShell(_map(216, 'CkSsh_SendReqShell'))
    (objHandle, channelNum);
end;

function CkSsh_SendReqShellAsync (objHandle: HCkSsh; channelNum: Integer): HCkTask;
begin
  result := TCkSsh_SendReqShellAsync(_map(217, 'CkSsh_SendReqShellAsync'))
    (objHandle, channelNum);
end;

function CkSsh_SendReqSignal (objHandle: HCkSsh; channelNum: Integer; signalName: PWideChar): wordbool;
begin
  result := TCkSsh_SendReqSignal(_map(218, 'CkSsh_SendReqSignal'))
    (objHandle, channelNum, signalName);
end;

function CkSsh_SendReqSignalAsync (objHandle: HCkSsh; channelNum: Integer; signalName: PWideChar): HCkTask;
begin
  result := TCkSsh_SendReqSignalAsync(_map(219, 'CkSsh_SendReqSignalAsync'))
    (objHandle, channelNum, signalName);
end;

function CkSsh_SendReqSubsystem (objHandle: HCkSsh; channelNum: Integer; subsystemName: PWideChar): wordbool;
begin
  result := TCkSsh_SendReqSubsystem(_map(220, 'CkSsh_SendReqSubsystem'))
    (objHandle, channelNum, subsystemName);
end;

function CkSsh_SendReqSubsystemAsync (objHandle: HCkSsh; channelNum: Integer; subsystemName: PWideChar): HCkTask;
begin
  result := TCkSsh_SendReqSubsystemAsync(_map(221, 'CkSsh_SendReqSubsystemAsync'))
    (objHandle, channelNum, subsystemName);
end;

function CkSsh_SendReqWindowChange (objHandle: HCkSsh; channelNum: Integer; widthInChars: Integer; heightInRows: Integer; pixWidth: Integer; pixHeight: Integer): wordbool;
begin
  result := TCkSsh_SendReqWindowChange(_map(222, 'CkSsh_SendReqWindowChange'))
    (objHandle, channelNum, widthInChars, heightInRows, pixWidth, pixHeight);
end;

function CkSsh_SendReqWindowChangeAsync (objHandle: HCkSsh; channelNum: Integer; widthInChars: Integer; heightInRows: Integer; pixWidth: Integer; pixHeight: Integer): HCkTask;
begin
  result := TCkSsh_SendReqWindowChangeAsync(_map(223, 'CkSsh_SendReqWindowChangeAsync'))
    (objHandle, channelNum, widthInChars, heightInRows, pixWidth, pixHeight);
end;

function CkSsh_SendReqX11Forwarding (objHandle: HCkSsh; channelNum: Integer; singleConnection: wordbool; authProt: PWideChar; authCookie: PWideChar; screenNum: Integer): wordbool;
begin
  result := TCkSsh_SendReqX11Forwarding(_map(224, 'CkSsh_SendReqX11Forwarding'))
    (objHandle, channelNum, singleConnection, authProt, authCookie, screenNum);
end;

function CkSsh_SendReqX11ForwardingAsync (objHandle: HCkSsh; channelNum: Integer; singleConnection: wordbool; authProt: PWideChar; authCookie: PWideChar; screenNum: Integer): HCkTask;
begin
  result := TCkSsh_SendReqX11ForwardingAsync(_map(225, 'CkSsh_SendReqX11ForwardingAsync'))
    (objHandle, channelNum, singleConnection, authProt, authCookie, screenNum);
end;

function CkSsh_SendReqXonXoff (objHandle: HCkSsh; channelNum: Integer; clientCanDo: wordbool): wordbool;
begin
  result := TCkSsh_SendReqXonXoff(_map(226, 'CkSsh_SendReqXonXoff'))
    (objHandle, channelNum, clientCanDo);
end;

function CkSsh_SendReqXonXoffAsync (objHandle: HCkSsh; channelNum: Integer; clientCanDo: wordbool): HCkTask;
begin
  result := TCkSsh_SendReqXonXoffAsync(_map(227, 'CkSsh_SendReqXonXoffAsync'))
    (objHandle, channelNum, clientCanDo);
end;

function CkSsh_SetAllowedAlgorithms (objHandle: HCkSsh; json: HCkJsonObject): wordbool;
begin
  result := TCkSsh_SetAllowedAlgorithms(_map(228, 'CkSsh_SetAllowedAlgorithms'))
    (objHandle, json);
end;

function CkSsh_SetTtyMode (objHandle: HCkSsh; ttyName: PWideChar; ttyValue: Integer): wordbool;
begin
  result := TCkSsh_SetTtyMode(_map(229, 'CkSsh_SetTtyMode'))
    (objHandle, ttyName, ttyValue);
end;

function CkSsh_StartKeyboardAuth (objHandle: HCkSsh; login: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSsh_StartKeyboardAuth(_map(230, 'CkSsh_StartKeyboardAuth'))
    (objHandle, login, outStr);
end;

function CkSsh__startKeyboardAuth (objHandle: HCkSsh; login: PWideChar): PWideChar;
begin
  result := TCkSsh__startKeyboardAuth(_map(231, 'CkSsh__startKeyboardAuth'))
    (objHandle, login);
end;

function CkSsh_StartKeyboardAuthAsync (objHandle: HCkSsh; login: PWideChar): HCkTask;
begin
  result := TCkSsh_StartKeyboardAuthAsync(_map(232, 'CkSsh_StartKeyboardAuthAsync'))
    (objHandle, login);
end;

function CkSsh_WaitForChannelMessage (objHandle: HCkSsh; pollTimeoutMs: Integer): Integer;
begin
  result := TCkSsh_WaitForChannelMessage(_map(233, 'CkSsh_WaitForChannelMessage'))
    (objHandle, pollTimeoutMs);
end;

function CkSsh_WaitForChannelMessageAsync (objHandle: HCkSsh; pollTimeoutMs: Integer): HCkTask;
begin
  result := TCkSsh_WaitForChannelMessageAsync(_map(234, 'CkSsh_WaitForChannelMessageAsync'))
    (objHandle, pollTimeoutMs);
end;

end.
