unit SshTunnel;

interface

type

HCkJsonObject = Pointer;
HCkSecureString = Pointer;
HCkSshKey = Pointer;
HCkString = Pointer;
HCkSsh = Pointer;
HCkSshTunnel = Pointer;
HCkTask = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TSshTunnelAbortCheck = function(): Integer; cdecl;
TSshTunnelProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TSshTunnelPercentDone = function(pctDone: Integer): Integer; cdecl;
TSshTunnelTaskCompleted = procedure(task: HCkTask); cdecl;


function CkSshTunnel_Create: HCkSshTunnel;  stdcall;
procedure CkSshTunnel_Dispose(handle: HCkSshTunnel); stdcall;

procedure CkSshTunnel_SetAbortCheck(objHandle: HCkSshTunnel; fn: TSshTunnelAbortCheck) stdcall;
procedure CkSshTunnel_SetProgressInfo(objHandle: HCkSshTunnel; fn: TSshTunnelProgressInfo) stdcall;
procedure CkSshTunnel_SetPercentDone(objHandle: HCkSshTunnel; fn: TSshTunnelPercentDone) stdcall;
procedure CkSshTunnel_SetTaskCompleted(objHandle: HCkSshTunnel; fn: TSshTunnelTaskCompleted) stdcall;
function CkSshTunnel_getAbortCurrent(objHandle: HCkSshTunnel): wordbool;
procedure CkSshTunnel_putAbortCurrent(objHandle: HCkSshTunnel; newPropVal: wordbool);
procedure CkSshTunnel_getAcceptLog(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putAcceptLog(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__acceptLog(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getAcceptLogPath(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putAcceptLogPath(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__acceptLogPath(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getClientIdentifier(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putClientIdentifier(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__clientIdentifier(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getClientLogDir(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putClientLogDir(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__clientLogDir(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getConnectTimeoutMs(objHandle: HCkSshTunnel): Integer;
procedure CkSshTunnel_putConnectTimeoutMs(objHandle: HCkSshTunnel; newPropVal: Integer);
procedure CkSshTunnel_getDebugLogFilePath(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putDebugLogFilePath(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__debugLogFilePath(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getDestHostname(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putDestHostname(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__destHostname(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getDestPort(objHandle: HCkSshTunnel): Integer;
procedure CkSshTunnel_putDestPort(objHandle: HCkSshTunnel; newPropVal: Integer);
function CkSshTunnel_getDynamicPortForwarding(objHandle: HCkSshTunnel): wordbool;
procedure CkSshTunnel_putDynamicPortForwarding(objHandle: HCkSshTunnel; newPropVal: wordbool);
procedure CkSshTunnel_getHostKeyFingerprint(objHandle: HCkSshTunnel; outPropVal: HCkString);
function CkSshTunnel__hostKeyFingerprint(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getHttpProxyAuthMethod(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putHttpProxyAuthMethod(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__httpProxyAuthMethod(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getHttpProxyDomain(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putHttpProxyDomain(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__httpProxyDomain(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getHttpProxyHostname(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putHttpProxyHostname(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__httpProxyHostname(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getHttpProxyPassword(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putHttpProxyPassword(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__httpProxyPassword(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getHttpProxyPort(objHandle: HCkSshTunnel): Integer;
procedure CkSshTunnel_putHttpProxyPort(objHandle: HCkSshTunnel; newPropVal: Integer);
procedure CkSshTunnel_getHttpProxyUsername(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putHttpProxyUsername(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__httpProxyUsername(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getIdleTimeoutMs(objHandle: HCkSshTunnel): Integer;
procedure CkSshTunnel_putIdleTimeoutMs(objHandle: HCkSshTunnel; newPropVal: Integer);
procedure CkSshTunnel_getInboundSocksPassword(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putInboundSocksPassword(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__inboundSocksPassword(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getInboundSocksUsername(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putInboundSocksUsername(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__inboundSocksUsername(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getIsAccepting(objHandle: HCkSshTunnel): wordbool;
function CkSshTunnel_getKeepAcceptLog(objHandle: HCkSshTunnel): wordbool;
procedure CkSshTunnel_putKeepAcceptLog(objHandle: HCkSshTunnel; newPropVal: wordbool);
function CkSshTunnel_getKeepTunnelLog(objHandle: HCkSshTunnel): wordbool;
procedure CkSshTunnel_putKeepTunnelLog(objHandle: HCkSshTunnel; newPropVal: wordbool);
procedure CkSshTunnel_getLastErrorHtml(objHandle: HCkSshTunnel; outPropVal: HCkString);
function CkSshTunnel__lastErrorHtml(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getLastErrorText(objHandle: HCkSshTunnel; outPropVal: HCkString);
function CkSshTunnel__lastErrorText(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getLastErrorXml(objHandle: HCkSshTunnel; outPropVal: HCkString);
function CkSshTunnel__lastErrorXml(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getLastMethodSuccess(objHandle: HCkSshTunnel): wordbool;
procedure CkSshTunnel_putLastMethodSuccess(objHandle: HCkSshTunnel; newPropVal: wordbool);
procedure CkSshTunnel_getListenBindIpAddress(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putListenBindIpAddress(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__listenBindIpAddress(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getListenPort(objHandle: HCkSshTunnel): Integer;
procedure CkSshTunnel_getOutboundBindIpAddress(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putOutboundBindIpAddress(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__outboundBindIpAddress(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getOutboundBindPort(objHandle: HCkSshTunnel): Integer;
procedure CkSshTunnel_putOutboundBindPort(objHandle: HCkSshTunnel; newPropVal: Integer);
function CkSshTunnel_getPreferIpv6(objHandle: HCkSshTunnel): wordbool;
procedure CkSshTunnel_putPreferIpv6(objHandle: HCkSshTunnel; newPropVal: wordbool);
procedure CkSshTunnel_getSocksHostname(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putSocksHostname(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__socksHostname(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getSocksPassword(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putSocksPassword(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__socksPassword(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getSocksPort(objHandle: HCkSshTunnel): Integer;
procedure CkSshTunnel_putSocksPort(objHandle: HCkSshTunnel; newPropVal: Integer);
procedure CkSshTunnel_getSocksUsername(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putSocksUsername(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__socksUsername(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getSocksVersion(objHandle: HCkSshTunnel): Integer;
procedure CkSshTunnel_putSocksVersion(objHandle: HCkSshTunnel; newPropVal: Integer);
function CkSshTunnel_getSoRcvBuf(objHandle: HCkSshTunnel): Integer;
procedure CkSshTunnel_putSoRcvBuf(objHandle: HCkSshTunnel; newPropVal: Integer);
function CkSshTunnel_getSoSndBuf(objHandle: HCkSshTunnel): Integer;
procedure CkSshTunnel_putSoSndBuf(objHandle: HCkSshTunnel; newPropVal: Integer);
function CkSshTunnel_getTcpNoDelay(objHandle: HCkSshTunnel): wordbool;
procedure CkSshTunnel_putTcpNoDelay(objHandle: HCkSshTunnel; newPropVal: wordbool);
procedure CkSshTunnel_getTunnelLog(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putTunnelLog(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__tunnelLog(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getTunnelLogPath(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putTunnelLogPath(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__tunnelLogPath(objHandle: HCkSshTunnel): PWideChar;
procedure CkSshTunnel_getUncommonOptions(objHandle: HCkSshTunnel; outPropVal: HCkString);
procedure CkSshTunnel_putUncommonOptions(objHandle: HCkSshTunnel; newPropVal: PWideChar);
function CkSshTunnel__uncommonOptions(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_getVerboseLogging(objHandle: HCkSshTunnel): wordbool;
procedure CkSshTunnel_putVerboseLogging(objHandle: HCkSshTunnel; newPropVal: wordbool);
procedure CkSshTunnel_getVersion(objHandle: HCkSshTunnel; outPropVal: HCkString);
function CkSshTunnel__version(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_AuthenticatePk(objHandle: HCkSshTunnel; username: PWideChar; privateKey: HCkSshKey): wordbool;
function CkSshTunnel_AuthenticatePkAsync(objHandle: HCkSshTunnel; username: PWideChar; privateKey: HCkSshKey): HCkTask;
function CkSshTunnel_AuthenticatePw(objHandle: HCkSshTunnel; login: PWideChar; password: PWideChar): wordbool;
function CkSshTunnel_AuthenticatePwAsync(objHandle: HCkSshTunnel; login: PWideChar; password: PWideChar): HCkTask;
function CkSshTunnel_AuthenticatePwPk(objHandle: HCkSshTunnel; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): wordbool;
function CkSshTunnel_AuthenticatePwPkAsync(objHandle: HCkSshTunnel; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): HCkTask;
function CkSshTunnel_AuthenticateSecPw(objHandle: HCkSshTunnel; login: HCkSecureString; password: HCkSecureString): wordbool;
function CkSshTunnel_AuthenticateSecPwAsync(objHandle: HCkSshTunnel; login: HCkSecureString; password: HCkSecureString): HCkTask;
function CkSshTunnel_AuthenticateSecPwPk(objHandle: HCkSshTunnel; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): wordbool;
function CkSshTunnel_AuthenticateSecPwPkAsync(objHandle: HCkSshTunnel; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): HCkTask;
function CkSshTunnel_BeginAccepting(objHandle: HCkSshTunnel; listenPort: Integer): wordbool;
function CkSshTunnel_BeginAcceptingAsync(objHandle: HCkSshTunnel; listenPort: Integer): HCkTask;
function CkSshTunnel_CloseTunnel(objHandle: HCkSshTunnel; waitForThreads: wordbool): wordbool;
function CkSshTunnel_Connect(objHandle: HCkSshTunnel; hostname: PWideChar; port: Integer): wordbool;
function CkSshTunnel_ConnectAsync(objHandle: HCkSshTunnel; hostname: PWideChar; port: Integer): HCkTask;
function CkSshTunnel_ConnectThroughSsh(objHandle: HCkSshTunnel; ssh: HCkSsh; hostname: PWideChar; port: Integer): wordbool;
function CkSshTunnel_ConnectThroughSshAsync(objHandle: HCkSshTunnel; ssh: HCkSsh; hostname: PWideChar; port: Integer): HCkTask;
function CkSshTunnel_ContinueKeyboardAuth(objHandle: HCkSshTunnel; response: PWideChar; outStr: HCkString): wordbool;
function CkSshTunnel__continueKeyboardAuth(objHandle: HCkSshTunnel; response: PWideChar): PWideChar;
function CkSshTunnel_ContinueKeyboardAuthAsync(objHandle: HCkSshTunnel; response: PWideChar): HCkTask;
function CkSshTunnel_DisconnectAllClients(objHandle: HCkSshTunnel; waitForThreads: wordbool): wordbool;
function CkSshTunnel_GetCurrentState(objHandle: HCkSshTunnel; outStr: HCkString): wordbool;
function CkSshTunnel__getCurrentState(objHandle: HCkSshTunnel): PWideChar;
function CkSshTunnel_IsSshConnected(objHandle: HCkSshTunnel): wordbool;
function CkSshTunnel_LoadTaskCaller(objHandle: HCkSshTunnel; task: HCkTask): wordbool;
function CkSshTunnel_SetAllowedAlgorithms(objHandle: HCkSshTunnel; json: HCkJsonObject): wordbool;
function CkSshTunnel_StartKeyboardAuth(objHandle: HCkSshTunnel; login: PWideChar; outStr: HCkString): wordbool;
function CkSshTunnel__startKeyboardAuth(objHandle: HCkSshTunnel; login: PWideChar): PWideChar;
function CkSshTunnel_StartKeyboardAuthAsync(objHandle: HCkSshTunnel; login: PWideChar): HCkTask;
function CkSshTunnel_StopAccepting(objHandle: HCkSshTunnel; waitForThread: wordbool): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkSshTunnel_Create = function : HCkSshTunnel; stdcall;
  TCkSshTunnel_Dispose = procedure (handle: HCkSshTunnel); stdcall;
  TCkSshTunnel_SetAbortCheck = procedure (objHandle: HCkSshTunnel; fn: TSshTunnelAbortCheck); stdcall;
  TCkSshTunnel_SetProgressInfo = procedure (objHandle: HCkSshTunnel; fn: TSshTunnelProgressInfo); stdcall;
  TCkSshTunnel_SetPercentDone = procedure (objHandle: HCkSshTunnel; fn: TSshTunnelPercentDone); stdcall;
  TCkSshTunnel_SetTaskCompleted = procedure (objHandle: HCkSshTunnel; fn: TSshTunnelTaskCompleted); stdcall;
  TCkSshTunnel_getAbortCurrent = function (objHandle: HCkSshTunnel): wordbool; stdcall;
  TCkSshTunnel_putAbortCurrent = procedure (objHandle: HCkSshTunnel; newPropVal: wordbool); stdcall;
  TCkSshTunnel_getAcceptLog = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putAcceptLog = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__acceptLog = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getAcceptLogPath = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putAcceptLogPath = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__acceptLogPath = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getClientIdentifier = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putClientIdentifier = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__clientIdentifier = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getClientLogDir = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putClientLogDir = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__clientLogDir = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getConnectTimeoutMs = function (objHandle: HCkSshTunnel): Integer; stdcall;
  TCkSshTunnel_putConnectTimeoutMs = procedure (objHandle: HCkSshTunnel; newPropVal: Integer); stdcall;
  TCkSshTunnel_getDebugLogFilePath = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putDebugLogFilePath = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__debugLogFilePath = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getDestHostname = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putDestHostname = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__destHostname = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getDestPort = function (objHandle: HCkSshTunnel): Integer; stdcall;
  TCkSshTunnel_putDestPort = procedure (objHandle: HCkSshTunnel; newPropVal: Integer); stdcall;
  TCkSshTunnel_getDynamicPortForwarding = function (objHandle: HCkSshTunnel): wordbool; stdcall;
  TCkSshTunnel_putDynamicPortForwarding = procedure (objHandle: HCkSshTunnel; newPropVal: wordbool); stdcall;
  TCkSshTunnel_getHostKeyFingerprint = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel__hostKeyFingerprint = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getHttpProxyAuthMethod = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putHttpProxyAuthMethod = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__httpProxyAuthMethod = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getHttpProxyDomain = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putHttpProxyDomain = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__httpProxyDomain = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getHttpProxyHostname = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putHttpProxyHostname = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__httpProxyHostname = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getHttpProxyPassword = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putHttpProxyPassword = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__httpProxyPassword = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getHttpProxyPort = function (objHandle: HCkSshTunnel): Integer; stdcall;
  TCkSshTunnel_putHttpProxyPort = procedure (objHandle: HCkSshTunnel; newPropVal: Integer); stdcall;
  TCkSshTunnel_getHttpProxyUsername = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putHttpProxyUsername = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__httpProxyUsername = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getIdleTimeoutMs = function (objHandle: HCkSshTunnel): Integer; stdcall;
  TCkSshTunnel_putIdleTimeoutMs = procedure (objHandle: HCkSshTunnel; newPropVal: Integer); stdcall;
  TCkSshTunnel_getInboundSocksPassword = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putInboundSocksPassword = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__inboundSocksPassword = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getInboundSocksUsername = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putInboundSocksUsername = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__inboundSocksUsername = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getIsAccepting = function (objHandle: HCkSshTunnel): wordbool; stdcall;
  TCkSshTunnel_getKeepAcceptLog = function (objHandle: HCkSshTunnel): wordbool; stdcall;
  TCkSshTunnel_putKeepAcceptLog = procedure (objHandle: HCkSshTunnel; newPropVal: wordbool); stdcall;
  TCkSshTunnel_getKeepTunnelLog = function (objHandle: HCkSshTunnel): wordbool; stdcall;
  TCkSshTunnel_putKeepTunnelLog = procedure (objHandle: HCkSshTunnel; newPropVal: wordbool); stdcall;
  TCkSshTunnel_getLastErrorHtml = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel__lastErrorHtml = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getLastErrorText = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel__lastErrorText = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getLastErrorXml = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel__lastErrorXml = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getLastMethodSuccess = function (objHandle: HCkSshTunnel): wordbool; stdcall;
  TCkSshTunnel_putLastMethodSuccess = procedure (objHandle: HCkSshTunnel; newPropVal: wordbool); stdcall;
  TCkSshTunnel_getListenBindIpAddress = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putListenBindIpAddress = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__listenBindIpAddress = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getListenPort = function (objHandle: HCkSshTunnel): Integer; stdcall;
  TCkSshTunnel_getOutboundBindIpAddress = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putOutboundBindIpAddress = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__outboundBindIpAddress = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getOutboundBindPort = function (objHandle: HCkSshTunnel): Integer; stdcall;
  TCkSshTunnel_putOutboundBindPort = procedure (objHandle: HCkSshTunnel; newPropVal: Integer); stdcall;
  TCkSshTunnel_getPreferIpv6 = function (objHandle: HCkSshTunnel): wordbool; stdcall;
  TCkSshTunnel_putPreferIpv6 = procedure (objHandle: HCkSshTunnel; newPropVal: wordbool); stdcall;
  TCkSshTunnel_getSocksHostname = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putSocksHostname = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__socksHostname = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getSocksPassword = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putSocksPassword = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__socksPassword = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getSocksPort = function (objHandle: HCkSshTunnel): Integer; stdcall;
  TCkSshTunnel_putSocksPort = procedure (objHandle: HCkSshTunnel; newPropVal: Integer); stdcall;
  TCkSshTunnel_getSocksUsername = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putSocksUsername = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__socksUsername = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getSocksVersion = function (objHandle: HCkSshTunnel): Integer; stdcall;
  TCkSshTunnel_putSocksVersion = procedure (objHandle: HCkSshTunnel; newPropVal: Integer); stdcall;
  TCkSshTunnel_getSoRcvBuf = function (objHandle: HCkSshTunnel): Integer; stdcall;
  TCkSshTunnel_putSoRcvBuf = procedure (objHandle: HCkSshTunnel; newPropVal: Integer); stdcall;
  TCkSshTunnel_getSoSndBuf = function (objHandle: HCkSshTunnel): Integer; stdcall;
  TCkSshTunnel_putSoSndBuf = procedure (objHandle: HCkSshTunnel; newPropVal: Integer); stdcall;
  TCkSshTunnel_getTcpNoDelay = function (objHandle: HCkSshTunnel): wordbool; stdcall;
  TCkSshTunnel_putTcpNoDelay = procedure (objHandle: HCkSshTunnel; newPropVal: wordbool); stdcall;
  TCkSshTunnel_getTunnelLog = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putTunnelLog = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__tunnelLog = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getTunnelLogPath = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putTunnelLogPath = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__tunnelLogPath = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getUncommonOptions = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel_putUncommonOptions = procedure (objHandle: HCkSshTunnel; newPropVal: PWideChar); stdcall;
  TCkSshTunnel__uncommonOptions = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_getVerboseLogging = function (objHandle: HCkSshTunnel): wordbool; stdcall;
  TCkSshTunnel_putVerboseLogging = procedure (objHandle: HCkSshTunnel; newPropVal: wordbool); stdcall;
  TCkSshTunnel_getVersion = procedure (objHandle: HCkSshTunnel; outPropVal: HCkString); stdcall;
  TCkSshTunnel__version = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_AuthenticatePk = function (objHandle: HCkSshTunnel; username: PWideChar; privateKey: HCkSshKey): wordbool; stdcall;
  TCkSshTunnel_AuthenticatePkAsync = function (objHandle: HCkSshTunnel; username: PWideChar; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkSshTunnel_AuthenticatePw = function (objHandle: HCkSshTunnel; login: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkSshTunnel_AuthenticatePwAsync = function (objHandle: HCkSshTunnel; login: PWideChar; password: PWideChar): HCkTask; stdcall;
  TCkSshTunnel_AuthenticatePwPk = function (objHandle: HCkSshTunnel; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): wordbool; stdcall;
  TCkSshTunnel_AuthenticatePwPkAsync = function (objHandle: HCkSshTunnel; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkSshTunnel_AuthenticateSecPw = function (objHandle: HCkSshTunnel; login: HCkSecureString; password: HCkSecureString): wordbool; stdcall;
  TCkSshTunnel_AuthenticateSecPwAsync = function (objHandle: HCkSshTunnel; login: HCkSecureString; password: HCkSecureString): HCkTask; stdcall;
  TCkSshTunnel_AuthenticateSecPwPk = function (objHandle: HCkSshTunnel; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): wordbool; stdcall;
  TCkSshTunnel_AuthenticateSecPwPkAsync = function (objHandle: HCkSshTunnel; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): HCkTask; stdcall;
  TCkSshTunnel_BeginAccepting = function (objHandle: HCkSshTunnel; listenPort: Integer): wordbool; stdcall;
  TCkSshTunnel_BeginAcceptingAsync = function (objHandle: HCkSshTunnel; listenPort: Integer): HCkTask; stdcall;
  TCkSshTunnel_CloseTunnel = function (objHandle: HCkSshTunnel; waitForThreads: wordbool): wordbool; stdcall;
  TCkSshTunnel_Connect = function (objHandle: HCkSshTunnel; hostname: PWideChar; port: Integer): wordbool; stdcall;
  TCkSshTunnel_ConnectAsync = function (objHandle: HCkSshTunnel; hostname: PWideChar; port: Integer): HCkTask; stdcall;
  TCkSshTunnel_ConnectThroughSsh = function (objHandle: HCkSshTunnel; ssh: HCkSsh; hostname: PWideChar; port: Integer): wordbool; stdcall;
  TCkSshTunnel_ConnectThroughSshAsync = function (objHandle: HCkSshTunnel; ssh: HCkSsh; hostname: PWideChar; port: Integer): HCkTask; stdcall;
  TCkSshTunnel_ContinueKeyboardAuth = function (objHandle: HCkSshTunnel; response: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSshTunnel__continueKeyboardAuth = function (objHandle: HCkSshTunnel; response: PWideChar): PWideChar; stdcall;
  TCkSshTunnel_ContinueKeyboardAuthAsync = function (objHandle: HCkSshTunnel; response: PWideChar): HCkTask; stdcall;
  TCkSshTunnel_DisconnectAllClients = function (objHandle: HCkSshTunnel; waitForThreads: wordbool): wordbool; stdcall;
  TCkSshTunnel_GetCurrentState = function (objHandle: HCkSshTunnel; outStr: HCkString): wordbool; stdcall;
  TCkSshTunnel__getCurrentState = function (objHandle: HCkSshTunnel): PWideChar; stdcall;
  TCkSshTunnel_IsSshConnected = function (objHandle: HCkSshTunnel): wordbool; stdcall;
  TCkSshTunnel_LoadTaskCaller = function (objHandle: HCkSshTunnel; task: HCkTask): wordbool; stdcall;
  TCkSshTunnel_SetAllowedAlgorithms = function (objHandle: HCkSshTunnel; json: HCkJsonObject): wordbool; stdcall;
  TCkSshTunnel_StartKeyboardAuth = function (objHandle: HCkSshTunnel; login: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkSshTunnel__startKeyboardAuth = function (objHandle: HCkSshTunnel; login: PWideChar): PWideChar; stdcall;
  TCkSshTunnel_StartKeyboardAuthAsync = function (objHandle: HCkSshTunnel; login: PWideChar): HCkTask; stdcall;
  TCkSshTunnel_StopAccepting = function (objHandle: HCkSshTunnel; waitForThread: wordbool): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..144] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkSshTunnel_Create : HCkSshTunnel;
begin
  result := TCkSshTunnel_Create(_map(0, 'CkSshTunnel_Create'));
end;

procedure CkSshTunnel_Dispose (handle: HCkSshTunnel);
begin
  TCkSshTunnel_Dispose(_map(1, 'CkSshTunnel_Dispose'))
    (handle);
end;


procedure CkSshTunnel_SetAbortCheck (objHandle: HCkSshTunnel; fn: TSshTunnelAbortCheck);
begin
    TCkSshTunnel_SetAbortCheck(_map(2, 'CkSshTunnel_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkSshTunnel_SetProgressInfo (objHandle: HCkSshTunnel; fn: TSshTunnelProgressInfo);
begin
    TCkSshTunnel_SetProgressInfo(_map(3, 'CkSshTunnel_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkSshTunnel_SetPercentDone (objHandle: HCkSshTunnel; fn: TSshTunnelPercentDone);
begin
    TCkSshTunnel_SetPercentDone(_map(4, 'CkSshTunnel_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkSshTunnel_SetTaskCompleted (objHandle: HCkSshTunnel; fn: TSshTunnelTaskCompleted);
begin
    TCkSshTunnel_SetTaskCompleted(_map(5, 'CkSshTunnel_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkSshTunnel_getAbortCurrent (objHandle: HCkSshTunnel): wordbool;
begin
    result := TCkSshTunnel_getAbortCurrent(_map(6, 'CkSshTunnel_getAbortCurrent'))
    (objHandle);
end;

procedure CkSshTunnel_putAbortCurrent (objHandle: HCkSshTunnel; newPropVal: wordbool);
begin
  TCkSshTunnel_putAbortCurrent(_map(7, 'CkSshTunnel_putAbortCurrent'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getAcceptLog (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getAcceptLog(_map(8, 'CkSshTunnel_getAcceptLog'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putAcceptLog (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putAcceptLog(_map(9, 'CkSshTunnel_putAcceptLog'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__acceptLog (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__acceptLog(_map(10, 'CkSshTunnel__acceptLog'))
    (objHandle);
end;

procedure CkSshTunnel_getAcceptLogPath (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getAcceptLogPath(_map(11, 'CkSshTunnel_getAcceptLogPath'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putAcceptLogPath (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putAcceptLogPath(_map(12, 'CkSshTunnel_putAcceptLogPath'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__acceptLogPath (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__acceptLogPath(_map(13, 'CkSshTunnel__acceptLogPath'))
    (objHandle);
end;

procedure CkSshTunnel_getClientIdentifier (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getClientIdentifier(_map(14, 'CkSshTunnel_getClientIdentifier'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putClientIdentifier (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putClientIdentifier(_map(15, 'CkSshTunnel_putClientIdentifier'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__clientIdentifier (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__clientIdentifier(_map(16, 'CkSshTunnel__clientIdentifier'))
    (objHandle);
end;

procedure CkSshTunnel_getClientLogDir (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getClientLogDir(_map(17, 'CkSshTunnel_getClientLogDir'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putClientLogDir (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putClientLogDir(_map(18, 'CkSshTunnel_putClientLogDir'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__clientLogDir (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__clientLogDir(_map(19, 'CkSshTunnel__clientLogDir'))
    (objHandle);
end;

function CkSshTunnel_getConnectTimeoutMs (objHandle: HCkSshTunnel): Integer;
begin
    result := TCkSshTunnel_getConnectTimeoutMs(_map(20, 'CkSshTunnel_getConnectTimeoutMs'))
    (objHandle);
end;

procedure CkSshTunnel_putConnectTimeoutMs (objHandle: HCkSshTunnel; newPropVal: Integer);
begin
  TCkSshTunnel_putConnectTimeoutMs(_map(21, 'CkSshTunnel_putConnectTimeoutMs'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getDebugLogFilePath (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getDebugLogFilePath(_map(22, 'CkSshTunnel_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putDebugLogFilePath (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putDebugLogFilePath(_map(23, 'CkSshTunnel_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__debugLogFilePath (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__debugLogFilePath(_map(24, 'CkSshTunnel__debugLogFilePath'))
    (objHandle);
end;

procedure CkSshTunnel_getDestHostname (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getDestHostname(_map(25, 'CkSshTunnel_getDestHostname'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putDestHostname (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putDestHostname(_map(26, 'CkSshTunnel_putDestHostname'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__destHostname (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__destHostname(_map(27, 'CkSshTunnel__destHostname'))
    (objHandle);
end;

function CkSshTunnel_getDestPort (objHandle: HCkSshTunnel): Integer;
begin
    result := TCkSshTunnel_getDestPort(_map(28, 'CkSshTunnel_getDestPort'))
    (objHandle);
end;

procedure CkSshTunnel_putDestPort (objHandle: HCkSshTunnel; newPropVal: Integer);
begin
  TCkSshTunnel_putDestPort(_map(29, 'CkSshTunnel_putDestPort'))
    (objHandle, newPropVal);
end;

function CkSshTunnel_getDynamicPortForwarding (objHandle: HCkSshTunnel): wordbool;
begin
    result := TCkSshTunnel_getDynamicPortForwarding(_map(30, 'CkSshTunnel_getDynamicPortForwarding'))
    (objHandle);
end;

procedure CkSshTunnel_putDynamicPortForwarding (objHandle: HCkSshTunnel; newPropVal: wordbool);
begin
  TCkSshTunnel_putDynamicPortForwarding(_map(31, 'CkSshTunnel_putDynamicPortForwarding'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getHostKeyFingerprint (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getHostKeyFingerprint(_map(32, 'CkSshTunnel_getHostKeyFingerprint'))
    (objHandle, outPropVal);
end;

function CkSshTunnel__hostKeyFingerprint (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__hostKeyFingerprint(_map(33, 'CkSshTunnel__hostKeyFingerprint'))
    (objHandle);
end;

procedure CkSshTunnel_getHttpProxyAuthMethod (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getHttpProxyAuthMethod(_map(34, 'CkSshTunnel_getHttpProxyAuthMethod'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putHttpProxyAuthMethod (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putHttpProxyAuthMethod(_map(35, 'CkSshTunnel_putHttpProxyAuthMethod'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__httpProxyAuthMethod (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__httpProxyAuthMethod(_map(36, 'CkSshTunnel__httpProxyAuthMethod'))
    (objHandle);
end;

procedure CkSshTunnel_getHttpProxyDomain (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getHttpProxyDomain(_map(37, 'CkSshTunnel_getHttpProxyDomain'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putHttpProxyDomain (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putHttpProxyDomain(_map(38, 'CkSshTunnel_putHttpProxyDomain'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__httpProxyDomain (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__httpProxyDomain(_map(39, 'CkSshTunnel__httpProxyDomain'))
    (objHandle);
end;

procedure CkSshTunnel_getHttpProxyHostname (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getHttpProxyHostname(_map(40, 'CkSshTunnel_getHttpProxyHostname'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putHttpProxyHostname (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putHttpProxyHostname(_map(41, 'CkSshTunnel_putHttpProxyHostname'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__httpProxyHostname (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__httpProxyHostname(_map(42, 'CkSshTunnel__httpProxyHostname'))
    (objHandle);
end;

procedure CkSshTunnel_getHttpProxyPassword (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getHttpProxyPassword(_map(43, 'CkSshTunnel_getHttpProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putHttpProxyPassword (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putHttpProxyPassword(_map(44, 'CkSshTunnel_putHttpProxyPassword'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__httpProxyPassword (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__httpProxyPassword(_map(45, 'CkSshTunnel__httpProxyPassword'))
    (objHandle);
end;

function CkSshTunnel_getHttpProxyPort (objHandle: HCkSshTunnel): Integer;
begin
    result := TCkSshTunnel_getHttpProxyPort(_map(46, 'CkSshTunnel_getHttpProxyPort'))
    (objHandle);
end;

procedure CkSshTunnel_putHttpProxyPort (objHandle: HCkSshTunnel; newPropVal: Integer);
begin
  TCkSshTunnel_putHttpProxyPort(_map(47, 'CkSshTunnel_putHttpProxyPort'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getHttpProxyUsername (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getHttpProxyUsername(_map(48, 'CkSshTunnel_getHttpProxyUsername'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putHttpProxyUsername (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putHttpProxyUsername(_map(49, 'CkSshTunnel_putHttpProxyUsername'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__httpProxyUsername (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__httpProxyUsername(_map(50, 'CkSshTunnel__httpProxyUsername'))
    (objHandle);
end;

function CkSshTunnel_getIdleTimeoutMs (objHandle: HCkSshTunnel): Integer;
begin
    result := TCkSshTunnel_getIdleTimeoutMs(_map(51, 'CkSshTunnel_getIdleTimeoutMs'))
    (objHandle);
end;

procedure CkSshTunnel_putIdleTimeoutMs (objHandle: HCkSshTunnel; newPropVal: Integer);
begin
  TCkSshTunnel_putIdleTimeoutMs(_map(52, 'CkSshTunnel_putIdleTimeoutMs'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getInboundSocksPassword (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getInboundSocksPassword(_map(53, 'CkSshTunnel_getInboundSocksPassword'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putInboundSocksPassword (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putInboundSocksPassword(_map(54, 'CkSshTunnel_putInboundSocksPassword'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__inboundSocksPassword (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__inboundSocksPassword(_map(55, 'CkSshTunnel__inboundSocksPassword'))
    (objHandle);
end;

procedure CkSshTunnel_getInboundSocksUsername (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getInboundSocksUsername(_map(56, 'CkSshTunnel_getInboundSocksUsername'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putInboundSocksUsername (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putInboundSocksUsername(_map(57, 'CkSshTunnel_putInboundSocksUsername'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__inboundSocksUsername (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__inboundSocksUsername(_map(58, 'CkSshTunnel__inboundSocksUsername'))
    (objHandle);
end;

function CkSshTunnel_getIsAccepting (objHandle: HCkSshTunnel): wordbool;
begin
    result := TCkSshTunnel_getIsAccepting(_map(59, 'CkSshTunnel_getIsAccepting'))
    (objHandle);
end;

function CkSshTunnel_getKeepAcceptLog (objHandle: HCkSshTunnel): wordbool;
begin
    result := TCkSshTunnel_getKeepAcceptLog(_map(60, 'CkSshTunnel_getKeepAcceptLog'))
    (objHandle);
end;

procedure CkSshTunnel_putKeepAcceptLog (objHandle: HCkSshTunnel; newPropVal: wordbool);
begin
  TCkSshTunnel_putKeepAcceptLog(_map(61, 'CkSshTunnel_putKeepAcceptLog'))
    (objHandle, newPropVal);
end;

function CkSshTunnel_getKeepTunnelLog (objHandle: HCkSshTunnel): wordbool;
begin
    result := TCkSshTunnel_getKeepTunnelLog(_map(62, 'CkSshTunnel_getKeepTunnelLog'))
    (objHandle);
end;

procedure CkSshTunnel_putKeepTunnelLog (objHandle: HCkSshTunnel; newPropVal: wordbool);
begin
  TCkSshTunnel_putKeepTunnelLog(_map(63, 'CkSshTunnel_putKeepTunnelLog'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getLastErrorHtml (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getLastErrorHtml(_map(64, 'CkSshTunnel_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkSshTunnel__lastErrorHtml (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__lastErrorHtml(_map(65, 'CkSshTunnel__lastErrorHtml'))
    (objHandle);
end;

procedure CkSshTunnel_getLastErrorText (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getLastErrorText(_map(66, 'CkSshTunnel_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkSshTunnel__lastErrorText (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__lastErrorText(_map(67, 'CkSshTunnel__lastErrorText'))
    (objHandle);
end;

procedure CkSshTunnel_getLastErrorXml (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getLastErrorXml(_map(68, 'CkSshTunnel_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkSshTunnel__lastErrorXml (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__lastErrorXml(_map(69, 'CkSshTunnel__lastErrorXml'))
    (objHandle);
end;

function CkSshTunnel_getLastMethodSuccess (objHandle: HCkSshTunnel): wordbool;
begin
    result := TCkSshTunnel_getLastMethodSuccess(_map(70, 'CkSshTunnel_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkSshTunnel_putLastMethodSuccess (objHandle: HCkSshTunnel; newPropVal: wordbool);
begin
  TCkSshTunnel_putLastMethodSuccess(_map(71, 'CkSshTunnel_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getListenBindIpAddress (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getListenBindIpAddress(_map(72, 'CkSshTunnel_getListenBindIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putListenBindIpAddress (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putListenBindIpAddress(_map(73, 'CkSshTunnel_putListenBindIpAddress'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__listenBindIpAddress (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__listenBindIpAddress(_map(74, 'CkSshTunnel__listenBindIpAddress'))
    (objHandle);
end;

function CkSshTunnel_getListenPort (objHandle: HCkSshTunnel): Integer;
begin
    result := TCkSshTunnel_getListenPort(_map(75, 'CkSshTunnel_getListenPort'))
    (objHandle);
end;

procedure CkSshTunnel_getOutboundBindIpAddress (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getOutboundBindIpAddress(_map(76, 'CkSshTunnel_getOutboundBindIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putOutboundBindIpAddress (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putOutboundBindIpAddress(_map(77, 'CkSshTunnel_putOutboundBindIpAddress'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__outboundBindIpAddress (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__outboundBindIpAddress(_map(78, 'CkSshTunnel__outboundBindIpAddress'))
    (objHandle);
end;

function CkSshTunnel_getOutboundBindPort (objHandle: HCkSshTunnel): Integer;
begin
    result := TCkSshTunnel_getOutboundBindPort(_map(79, 'CkSshTunnel_getOutboundBindPort'))
    (objHandle);
end;

procedure CkSshTunnel_putOutboundBindPort (objHandle: HCkSshTunnel; newPropVal: Integer);
begin
  TCkSshTunnel_putOutboundBindPort(_map(80, 'CkSshTunnel_putOutboundBindPort'))
    (objHandle, newPropVal);
end;

function CkSshTunnel_getPreferIpv6 (objHandle: HCkSshTunnel): wordbool;
begin
    result := TCkSshTunnel_getPreferIpv6(_map(81, 'CkSshTunnel_getPreferIpv6'))
    (objHandle);
end;

procedure CkSshTunnel_putPreferIpv6 (objHandle: HCkSshTunnel; newPropVal: wordbool);
begin
  TCkSshTunnel_putPreferIpv6(_map(82, 'CkSshTunnel_putPreferIpv6'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getSocksHostname (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getSocksHostname(_map(83, 'CkSshTunnel_getSocksHostname'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putSocksHostname (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putSocksHostname(_map(84, 'CkSshTunnel_putSocksHostname'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__socksHostname (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__socksHostname(_map(85, 'CkSshTunnel__socksHostname'))
    (objHandle);
end;

procedure CkSshTunnel_getSocksPassword (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getSocksPassword(_map(86, 'CkSshTunnel_getSocksPassword'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putSocksPassword (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putSocksPassword(_map(87, 'CkSshTunnel_putSocksPassword'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__socksPassword (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__socksPassword(_map(88, 'CkSshTunnel__socksPassword'))
    (objHandle);
end;

function CkSshTunnel_getSocksPort (objHandle: HCkSshTunnel): Integer;
begin
    result := TCkSshTunnel_getSocksPort(_map(89, 'CkSshTunnel_getSocksPort'))
    (objHandle);
end;

procedure CkSshTunnel_putSocksPort (objHandle: HCkSshTunnel; newPropVal: Integer);
begin
  TCkSshTunnel_putSocksPort(_map(90, 'CkSshTunnel_putSocksPort'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getSocksUsername (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getSocksUsername(_map(91, 'CkSshTunnel_getSocksUsername'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putSocksUsername (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putSocksUsername(_map(92, 'CkSshTunnel_putSocksUsername'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__socksUsername (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__socksUsername(_map(93, 'CkSshTunnel__socksUsername'))
    (objHandle);
end;

function CkSshTunnel_getSocksVersion (objHandle: HCkSshTunnel): Integer;
begin
    result := TCkSshTunnel_getSocksVersion(_map(94, 'CkSshTunnel_getSocksVersion'))
    (objHandle);
end;

procedure CkSshTunnel_putSocksVersion (objHandle: HCkSshTunnel; newPropVal: Integer);
begin
  TCkSshTunnel_putSocksVersion(_map(95, 'CkSshTunnel_putSocksVersion'))
    (objHandle, newPropVal);
end;

function CkSshTunnel_getSoRcvBuf (objHandle: HCkSshTunnel): Integer;
begin
    result := TCkSshTunnel_getSoRcvBuf(_map(96, 'CkSshTunnel_getSoRcvBuf'))
    (objHandle);
end;

procedure CkSshTunnel_putSoRcvBuf (objHandle: HCkSshTunnel; newPropVal: Integer);
begin
  TCkSshTunnel_putSoRcvBuf(_map(97, 'CkSshTunnel_putSoRcvBuf'))
    (objHandle, newPropVal);
end;

function CkSshTunnel_getSoSndBuf (objHandle: HCkSshTunnel): Integer;
begin
    result := TCkSshTunnel_getSoSndBuf(_map(98, 'CkSshTunnel_getSoSndBuf'))
    (objHandle);
end;

procedure CkSshTunnel_putSoSndBuf (objHandle: HCkSshTunnel; newPropVal: Integer);
begin
  TCkSshTunnel_putSoSndBuf(_map(99, 'CkSshTunnel_putSoSndBuf'))
    (objHandle, newPropVal);
end;

function CkSshTunnel_getTcpNoDelay (objHandle: HCkSshTunnel): wordbool;
begin
    result := TCkSshTunnel_getTcpNoDelay(_map(100, 'CkSshTunnel_getTcpNoDelay'))
    (objHandle);
end;

procedure CkSshTunnel_putTcpNoDelay (objHandle: HCkSshTunnel; newPropVal: wordbool);
begin
  TCkSshTunnel_putTcpNoDelay(_map(101, 'CkSshTunnel_putTcpNoDelay'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getTunnelLog (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getTunnelLog(_map(102, 'CkSshTunnel_getTunnelLog'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putTunnelLog (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putTunnelLog(_map(103, 'CkSshTunnel_putTunnelLog'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__tunnelLog (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__tunnelLog(_map(104, 'CkSshTunnel__tunnelLog'))
    (objHandle);
end;

procedure CkSshTunnel_getTunnelLogPath (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getTunnelLogPath(_map(105, 'CkSshTunnel_getTunnelLogPath'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putTunnelLogPath (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putTunnelLogPath(_map(106, 'CkSshTunnel_putTunnelLogPath'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__tunnelLogPath (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__tunnelLogPath(_map(107, 'CkSshTunnel__tunnelLogPath'))
    (objHandle);
end;

procedure CkSshTunnel_getUncommonOptions (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getUncommonOptions(_map(108, 'CkSshTunnel_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkSshTunnel_putUncommonOptions (objHandle: HCkSshTunnel; newPropVal: PWideChar);
begin
  TCkSshTunnel_putUncommonOptions(_map(109, 'CkSshTunnel_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkSshTunnel__uncommonOptions (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__uncommonOptions(_map(110, 'CkSshTunnel__uncommonOptions'))
    (objHandle);
end;

function CkSshTunnel_getVerboseLogging (objHandle: HCkSshTunnel): wordbool;
begin
    result := TCkSshTunnel_getVerboseLogging(_map(111, 'CkSshTunnel_getVerboseLogging'))
    (objHandle);
end;

procedure CkSshTunnel_putVerboseLogging (objHandle: HCkSshTunnel; newPropVal: wordbool);
begin
  TCkSshTunnel_putVerboseLogging(_map(112, 'CkSshTunnel_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkSshTunnel_getVersion (objHandle: HCkSshTunnel; outPropVal: HCkString);
begin
  TCkSshTunnel_getVersion(_map(113, 'CkSshTunnel_getVersion'))
    (objHandle, outPropVal);
end;

function CkSshTunnel__version (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__version(_map(114, 'CkSshTunnel__version'))
    (objHandle);
end;

function CkSshTunnel_AuthenticatePk (objHandle: HCkSshTunnel; username: PWideChar; privateKey: HCkSshKey): wordbool;
begin
  result := TCkSshTunnel_AuthenticatePk(_map(115, 'CkSshTunnel_AuthenticatePk'))
    (objHandle, username, privateKey);
end;

function CkSshTunnel_AuthenticatePkAsync (objHandle: HCkSshTunnel; username: PWideChar; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkSshTunnel_AuthenticatePkAsync(_map(116, 'CkSshTunnel_AuthenticatePkAsync'))
    (objHandle, username, privateKey);
end;

function CkSshTunnel_AuthenticatePw (objHandle: HCkSshTunnel; login: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkSshTunnel_AuthenticatePw(_map(117, 'CkSshTunnel_AuthenticatePw'))
    (objHandle, login, password);
end;

function CkSshTunnel_AuthenticatePwAsync (objHandle: HCkSshTunnel; login: PWideChar; password: PWideChar): HCkTask;
begin
  result := TCkSshTunnel_AuthenticatePwAsync(_map(118, 'CkSshTunnel_AuthenticatePwAsync'))
    (objHandle, login, password);
end;

function CkSshTunnel_AuthenticatePwPk (objHandle: HCkSshTunnel; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): wordbool;
begin
  result := TCkSshTunnel_AuthenticatePwPk(_map(119, 'CkSshTunnel_AuthenticatePwPk'))
    (objHandle, username, password, privateKey);
end;

function CkSshTunnel_AuthenticatePwPkAsync (objHandle: HCkSshTunnel; username: PWideChar; password: PWideChar; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkSshTunnel_AuthenticatePwPkAsync(_map(120, 'CkSshTunnel_AuthenticatePwPkAsync'))
    (objHandle, username, password, privateKey);
end;

function CkSshTunnel_AuthenticateSecPw (objHandle: HCkSshTunnel; login: HCkSecureString; password: HCkSecureString): wordbool;
begin
  result := TCkSshTunnel_AuthenticateSecPw(_map(121, 'CkSshTunnel_AuthenticateSecPw'))
    (objHandle, login, password);
end;

function CkSshTunnel_AuthenticateSecPwAsync (objHandle: HCkSshTunnel; login: HCkSecureString; password: HCkSecureString): HCkTask;
begin
  result := TCkSshTunnel_AuthenticateSecPwAsync(_map(122, 'CkSshTunnel_AuthenticateSecPwAsync'))
    (objHandle, login, password);
end;

function CkSshTunnel_AuthenticateSecPwPk (objHandle: HCkSshTunnel; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): wordbool;
begin
  result := TCkSshTunnel_AuthenticateSecPwPk(_map(123, 'CkSshTunnel_AuthenticateSecPwPk'))
    (objHandle, username, password, privateKey);
end;

function CkSshTunnel_AuthenticateSecPwPkAsync (objHandle: HCkSshTunnel; username: HCkSecureString; password: HCkSecureString; privateKey: HCkSshKey): HCkTask;
begin
  result := TCkSshTunnel_AuthenticateSecPwPkAsync(_map(124, 'CkSshTunnel_AuthenticateSecPwPkAsync'))
    (objHandle, username, password, privateKey);
end;

function CkSshTunnel_BeginAccepting (objHandle: HCkSshTunnel; listenPort: Integer): wordbool;
begin
  result := TCkSshTunnel_BeginAccepting(_map(125, 'CkSshTunnel_BeginAccepting'))
    (objHandle, listenPort);
end;

function CkSshTunnel_BeginAcceptingAsync (objHandle: HCkSshTunnel; listenPort: Integer): HCkTask;
begin
  result := TCkSshTunnel_BeginAcceptingAsync(_map(126, 'CkSshTunnel_BeginAcceptingAsync'))
    (objHandle, listenPort);
end;

function CkSshTunnel_CloseTunnel (objHandle: HCkSshTunnel; waitForThreads: wordbool): wordbool;
begin
  result := TCkSshTunnel_CloseTunnel(_map(127, 'CkSshTunnel_CloseTunnel'))
    (objHandle, waitForThreads);
end;

function CkSshTunnel_Connect (objHandle: HCkSshTunnel; hostname: PWideChar; port: Integer): wordbool;
begin
  result := TCkSshTunnel_Connect(_map(128, 'CkSshTunnel_Connect'))
    (objHandle, hostname, port);
end;

function CkSshTunnel_ConnectAsync (objHandle: HCkSshTunnel; hostname: PWideChar; port: Integer): HCkTask;
begin
  result := TCkSshTunnel_ConnectAsync(_map(129, 'CkSshTunnel_ConnectAsync'))
    (objHandle, hostname, port);
end;

function CkSshTunnel_ConnectThroughSsh (objHandle: HCkSshTunnel; ssh: HCkSsh; hostname: PWideChar; port: Integer): wordbool;
begin
  result := TCkSshTunnel_ConnectThroughSsh(_map(130, 'CkSshTunnel_ConnectThroughSsh'))
    (objHandle, ssh, hostname, port);
end;

function CkSshTunnel_ConnectThroughSshAsync (objHandle: HCkSshTunnel; ssh: HCkSsh; hostname: PWideChar; port: Integer): HCkTask;
begin
  result := TCkSshTunnel_ConnectThroughSshAsync(_map(131, 'CkSshTunnel_ConnectThroughSshAsync'))
    (objHandle, ssh, hostname, port);
end;

function CkSshTunnel_ContinueKeyboardAuth (objHandle: HCkSshTunnel; response: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSshTunnel_ContinueKeyboardAuth(_map(132, 'CkSshTunnel_ContinueKeyboardAuth'))
    (objHandle, response, outStr);
end;

function CkSshTunnel__continueKeyboardAuth (objHandle: HCkSshTunnel; response: PWideChar): PWideChar;
begin
  result := TCkSshTunnel__continueKeyboardAuth(_map(133, 'CkSshTunnel__continueKeyboardAuth'))
    (objHandle, response);
end;

function CkSshTunnel_ContinueKeyboardAuthAsync (objHandle: HCkSshTunnel; response: PWideChar): HCkTask;
begin
  result := TCkSshTunnel_ContinueKeyboardAuthAsync(_map(134, 'CkSshTunnel_ContinueKeyboardAuthAsync'))
    (objHandle, response);
end;

function CkSshTunnel_DisconnectAllClients (objHandle: HCkSshTunnel; waitForThreads: wordbool): wordbool;
begin
  result := TCkSshTunnel_DisconnectAllClients(_map(135, 'CkSshTunnel_DisconnectAllClients'))
    (objHandle, waitForThreads);
end;

function CkSshTunnel_GetCurrentState (objHandle: HCkSshTunnel; outStr: HCkString): wordbool;
begin
  result := TCkSshTunnel_GetCurrentState(_map(136, 'CkSshTunnel_GetCurrentState'))
    (objHandle, outStr);
end;

function CkSshTunnel__getCurrentState (objHandle: HCkSshTunnel): PWideChar;
begin
  result := TCkSshTunnel__getCurrentState(_map(137, 'CkSshTunnel__getCurrentState'))
    (objHandle);
end;

function CkSshTunnel_IsSshConnected (objHandle: HCkSshTunnel): wordbool;
begin
  result := TCkSshTunnel_IsSshConnected(_map(138, 'CkSshTunnel_IsSshConnected'))
    (objHandle);
end;

function CkSshTunnel_LoadTaskCaller (objHandle: HCkSshTunnel; task: HCkTask): wordbool;
begin
  result := TCkSshTunnel_LoadTaskCaller(_map(139, 'CkSshTunnel_LoadTaskCaller'))
    (objHandle, task);
end;

function CkSshTunnel_SetAllowedAlgorithms (objHandle: HCkSshTunnel; json: HCkJsonObject): wordbool;
begin
  result := TCkSshTunnel_SetAllowedAlgorithms(_map(140, 'CkSshTunnel_SetAllowedAlgorithms'))
    (objHandle, json);
end;

function CkSshTunnel_StartKeyboardAuth (objHandle: HCkSshTunnel; login: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkSshTunnel_StartKeyboardAuth(_map(141, 'CkSshTunnel_StartKeyboardAuth'))
    (objHandle, login, outStr);
end;

function CkSshTunnel__startKeyboardAuth (objHandle: HCkSshTunnel; login: PWideChar): PWideChar;
begin
  result := TCkSshTunnel__startKeyboardAuth(_map(142, 'CkSshTunnel__startKeyboardAuth'))
    (objHandle, login);
end;

function CkSshTunnel_StartKeyboardAuthAsync (objHandle: HCkSshTunnel; login: PWideChar): HCkTask;
begin
  result := TCkSshTunnel_StartKeyboardAuthAsync(_map(143, 'CkSshTunnel_StartKeyboardAuthAsync'))
    (objHandle, login);
end;

function CkSshTunnel_StopAccepting (objHandle: HCkSshTunnel; waitForThread: wordbool): wordbool;
begin
  result := TCkSshTunnel_StopAccepting(_map(144, 'CkSshTunnel_StopAccepting'))
    (objHandle, waitForThread);
end;

end.
