unit Stream;

interface

type

HCkBinData = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkStream = Pointer;
HCkTask = Pointer;
HCkStringBuilder = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TStreamAbortCheck = function(): Integer; cdecl;
TStreamProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TStreamPercentDone = function(pctDone: Integer): Integer; cdecl;
TStreamTaskCompleted = procedure(task: HCkTask); cdecl;


function CkStream_Create: HCkStream;  stdcall;
procedure CkStream_Dispose(handle: HCkStream); stdcall;

procedure CkStream_SetAbortCheck(objHandle: HCkStream; fn: TStreamAbortCheck) stdcall;
procedure CkStream_SetProgressInfo(objHandle: HCkStream; fn: TStreamProgressInfo) stdcall;
procedure CkStream_SetPercentDone(objHandle: HCkStream; fn: TStreamPercentDone) stdcall;
procedure CkStream_SetTaskCompleted(objHandle: HCkStream; fn: TStreamTaskCompleted) stdcall;
function CkStream_getAbortCurrent(objHandle: HCkStream): wordbool;
procedure CkStream_putAbortCurrent(objHandle: HCkStream; newPropVal: wordbool);
function CkStream_getCanRead(objHandle: HCkStream): wordbool;
function CkStream_getCanWrite(objHandle: HCkStream): wordbool;
function CkStream_getDataAvailable(objHandle: HCkStream): wordbool;
procedure CkStream_getDebugLogFilePath(objHandle: HCkStream; outPropVal: HCkString);
procedure CkStream_putDebugLogFilePath(objHandle: HCkStream; newPropVal: PWideChar);
function CkStream__debugLogFilePath(objHandle: HCkStream): PWideChar;
function CkStream_getDefaultChunkSize(objHandle: HCkStream): Integer;
procedure CkStream_putDefaultChunkSize(objHandle: HCkStream; newPropVal: Integer);
function CkStream_getEndOfStream(objHandle: HCkStream): wordbool;
function CkStream_getHeartbeatMs(objHandle: HCkStream): Integer;
procedure CkStream_putHeartbeatMs(objHandle: HCkStream; newPropVal: Integer);
function CkStream_getIsWriteClosed(objHandle: HCkStream): wordbool;
procedure CkStream_getLastErrorHtml(objHandle: HCkStream; outPropVal: HCkString);
function CkStream__lastErrorHtml(objHandle: HCkStream): PWideChar;
procedure CkStream_getLastErrorText(objHandle: HCkStream; outPropVal: HCkString);
function CkStream__lastErrorText(objHandle: HCkStream): PWideChar;
procedure CkStream_getLastErrorXml(objHandle: HCkStream; outPropVal: HCkString);
function CkStream__lastErrorXml(objHandle: HCkStream): PWideChar;
function CkStream_getLastMethodSuccess(objHandle: HCkStream): wordbool;
procedure CkStream_putLastMethodSuccess(objHandle: HCkStream; newPropVal: wordbool);
function CkStream_getLength(objHandle: HCkStream): Int64;
procedure CkStream_putLength(objHandle: HCkStream; newPropVal: Int64);
function CkStream_getLength32(objHandle: HCkStream): Integer;
procedure CkStream_putLength32(objHandle: HCkStream; newPropVal: Integer);
function CkStream_getNumReceived(objHandle: HCkStream): Int64;
function CkStream_getNumSent(objHandle: HCkStream): Int64;
function CkStream_getReadFailReason(objHandle: HCkStream): Integer;
function CkStream_getReadTimeoutMs(objHandle: HCkStream): Integer;
procedure CkStream_putReadTimeoutMs(objHandle: HCkStream; newPropVal: Integer);
procedure CkStream_getSinkFile(objHandle: HCkStream; outPropVal: HCkString);
procedure CkStream_putSinkFile(objHandle: HCkStream; newPropVal: PWideChar);
function CkStream__sinkFile(objHandle: HCkStream): PWideChar;
function CkStream_getSinkFileAppend(objHandle: HCkStream): wordbool;
procedure CkStream_putSinkFileAppend(objHandle: HCkStream; newPropVal: wordbool);
procedure CkStream_getSourceFile(objHandle: HCkStream; outPropVal: HCkString);
procedure CkStream_putSourceFile(objHandle: HCkStream; newPropVal: PWideChar);
function CkStream__sourceFile(objHandle: HCkStream): PWideChar;
function CkStream_getSourceFilePart(objHandle: HCkStream): Integer;
procedure CkStream_putSourceFilePart(objHandle: HCkStream; newPropVal: Integer);
function CkStream_getSourceFilePartSize(objHandle: HCkStream): Integer;
procedure CkStream_putSourceFilePartSize(objHandle: HCkStream; newPropVal: Integer);
function CkStream_getStringBom(objHandle: HCkStream): wordbool;
procedure CkStream_putStringBom(objHandle: HCkStream; newPropVal: wordbool);
procedure CkStream_getStringCharset(objHandle: HCkStream; outPropVal: HCkString);
procedure CkStream_putStringCharset(objHandle: HCkStream; newPropVal: PWideChar);
function CkStream__stringCharset(objHandle: HCkStream): PWideChar;
function CkStream_getVerboseLogging(objHandle: HCkStream): wordbool;
procedure CkStream_putVerboseLogging(objHandle: HCkStream; newPropVal: wordbool);
procedure CkStream_getVersion(objHandle: HCkStream; outPropVal: HCkString);
function CkStream__version(objHandle: HCkStream): PWideChar;
function CkStream_getWriteFailReason(objHandle: HCkStream): Integer;
function CkStream_getWriteTimeoutMs(objHandle: HCkStream): Integer;
procedure CkStream_putWriteTimeoutMs(objHandle: HCkStream; newPropVal: Integer);
function CkStream_LoadTaskCaller(objHandle: HCkStream; task: HCkTask): wordbool;
function CkStream_ReadBd(objHandle: HCkStream; binData: HCkBinData): wordbool;
function CkStream_ReadBdAsync(objHandle: HCkStream; binData: HCkBinData): HCkTask;
function CkStream_ReadBytes(objHandle: HCkStream; outData: HCkByteData): wordbool;
function CkStream_ReadBytesAsync(objHandle: HCkStream): HCkTask;
function CkStream_ReadBytesENC(objHandle: HCkStream; encoding: PWideChar; outStr: HCkString): wordbool;
function CkStream__readBytesENC(objHandle: HCkStream; encoding: PWideChar): PWideChar;
function CkStream_ReadBytesENCAsync(objHandle: HCkStream; encoding: PWideChar): HCkTask;
function CkStream_ReadNBytes(objHandle: HCkStream; numBytes: Integer; outData: HCkByteData): wordbool;
function CkStream_ReadNBytesAsync(objHandle: HCkStream; numBytes: Integer): HCkTask;
function CkStream_ReadNBytesENC(objHandle: HCkStream; numBytes: Integer; encoding: PWideChar; outStr: HCkString): wordbool;
function CkStream__readNBytesENC(objHandle: HCkStream; numBytes: Integer; encoding: PWideChar): PWideChar;
function CkStream_ReadNBytesENCAsync(objHandle: HCkStream; numBytes: Integer; encoding: PWideChar): HCkTask;
function CkStream_ReadSb(objHandle: HCkStream; sb: HCkStringBuilder): wordbool;
function CkStream_ReadSbAsync(objHandle: HCkStream; sb: HCkStringBuilder): HCkTask;
function CkStream_ReadString(objHandle: HCkStream; outStr: HCkString): wordbool;
function CkStream__readString(objHandle: HCkStream): PWideChar;
function CkStream_ReadStringAsync(objHandle: HCkStream): HCkTask;
function CkStream_ReadToCRLF(objHandle: HCkStream; outStr: HCkString): wordbool;
function CkStream__readToCRLF(objHandle: HCkStream): PWideChar;
function CkStream_ReadToCRLFAsync(objHandle: HCkStream): HCkTask;
function CkStream_ReadUntilMatch(objHandle: HCkStream; matchStr: PWideChar; outStr: HCkString): wordbool;
function CkStream__readUntilMatch(objHandle: HCkStream; matchStr: PWideChar): PWideChar;
function CkStream_ReadUntilMatchAsync(objHandle: HCkStream; matchStr: PWideChar): HCkTask;
procedure CkStream_Reset(objHandle: HCkStream);
function CkStream_SetSourceBytes(objHandle: HCkStream; sourceData: HCkByteData): wordbool;
function CkStream_SetSourceString(objHandle: HCkStream; srcStr: PWideChar; charset: PWideChar): wordbool;
function CkStream_WriteBd(objHandle: HCkStream; binData: HCkBinData): wordbool;
function CkStream_WriteBdAsync(objHandle: HCkStream; binData: HCkBinData): HCkTask;
function CkStream_WriteByte(objHandle: HCkStream; byteVal: Integer): wordbool;
function CkStream_WriteByteAsync(objHandle: HCkStream; byteVal: Integer): HCkTask;
function CkStream_WriteBytes(objHandle: HCkStream; byteData: HCkByteData): wordbool;
function CkStream_WriteBytesAsync(objHandle: HCkStream; byteData: HCkByteData): HCkTask;
function CkStream_WriteBytesENC(objHandle: HCkStream; byteData: PWideChar; encoding: PWideChar): wordbool;
function CkStream_WriteBytesENCAsync(objHandle: HCkStream; byteData: PWideChar; encoding: PWideChar): HCkTask;
function CkStream_WriteClose(objHandle: HCkStream): wordbool;
function CkStream_WriteSb(objHandle: HCkStream; sb: HCkStringBuilder): wordbool;
function CkStream_WriteSbAsync(objHandle: HCkStream; sb: HCkStringBuilder): HCkTask;
function CkStream_WriteString(objHandle: HCkStream; str: PWideChar): wordbool;
function CkStream_WriteStringAsync(objHandle: HCkStream; str: PWideChar): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkStream_Create = function : HCkStream; stdcall;
  TCkStream_Dispose = procedure (handle: HCkStream); stdcall;
  TCkStream_SetAbortCheck = procedure (objHandle: HCkStream; fn: TStreamAbortCheck); stdcall;
  TCkStream_SetProgressInfo = procedure (objHandle: HCkStream; fn: TStreamProgressInfo); stdcall;
  TCkStream_SetPercentDone = procedure (objHandle: HCkStream; fn: TStreamPercentDone); stdcall;
  TCkStream_SetTaskCompleted = procedure (objHandle: HCkStream; fn: TStreamTaskCompleted); stdcall;
  TCkStream_getAbortCurrent = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_putAbortCurrent = procedure (objHandle: HCkStream; newPropVal: wordbool); stdcall;
  TCkStream_getCanRead = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_getCanWrite = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_getDataAvailable = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_getDebugLogFilePath = procedure (objHandle: HCkStream; outPropVal: HCkString); stdcall;
  TCkStream_putDebugLogFilePath = procedure (objHandle: HCkStream; newPropVal: PWideChar); stdcall;
  TCkStream__debugLogFilePath = function (objHandle: HCkStream): PWideChar; stdcall;
  TCkStream_getDefaultChunkSize = function (objHandle: HCkStream): Integer; stdcall;
  TCkStream_putDefaultChunkSize = procedure (objHandle: HCkStream; newPropVal: Integer); stdcall;
  TCkStream_getEndOfStream = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_getHeartbeatMs = function (objHandle: HCkStream): Integer; stdcall;
  TCkStream_putHeartbeatMs = procedure (objHandle: HCkStream; newPropVal: Integer); stdcall;
  TCkStream_getIsWriteClosed = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_getLastErrorHtml = procedure (objHandle: HCkStream; outPropVal: HCkString); stdcall;
  TCkStream__lastErrorHtml = function (objHandle: HCkStream): PWideChar; stdcall;
  TCkStream_getLastErrorText = procedure (objHandle: HCkStream; outPropVal: HCkString); stdcall;
  TCkStream__lastErrorText = function (objHandle: HCkStream): PWideChar; stdcall;
  TCkStream_getLastErrorXml = procedure (objHandle: HCkStream; outPropVal: HCkString); stdcall;
  TCkStream__lastErrorXml = function (objHandle: HCkStream): PWideChar; stdcall;
  TCkStream_getLastMethodSuccess = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_putLastMethodSuccess = procedure (objHandle: HCkStream; newPropVal: wordbool); stdcall;
  TCkStream_getLength = function (objHandle: HCkStream): Int64; stdcall;
  TCkStream_putLength = procedure (objHandle: HCkStream; newPropVal: Int64); stdcall;
  TCkStream_getLength32 = function (objHandle: HCkStream): Integer; stdcall;
  TCkStream_putLength32 = procedure (objHandle: HCkStream; newPropVal: Integer); stdcall;
  TCkStream_getNumReceived = function (objHandle: HCkStream): Int64; stdcall;
  TCkStream_getNumSent = function (objHandle: HCkStream): Int64; stdcall;
  TCkStream_getReadFailReason = function (objHandle: HCkStream): Integer; stdcall;
  TCkStream_getReadTimeoutMs = function (objHandle: HCkStream): Integer; stdcall;
  TCkStream_putReadTimeoutMs = procedure (objHandle: HCkStream; newPropVal: Integer); stdcall;
  TCkStream_getSinkFile = procedure (objHandle: HCkStream; outPropVal: HCkString); stdcall;
  TCkStream_putSinkFile = procedure (objHandle: HCkStream; newPropVal: PWideChar); stdcall;
  TCkStream__sinkFile = function (objHandle: HCkStream): PWideChar; stdcall;
  TCkStream_getSinkFileAppend = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_putSinkFileAppend = procedure (objHandle: HCkStream; newPropVal: wordbool); stdcall;
  TCkStream_getSourceFile = procedure (objHandle: HCkStream; outPropVal: HCkString); stdcall;
  TCkStream_putSourceFile = procedure (objHandle: HCkStream; newPropVal: PWideChar); stdcall;
  TCkStream__sourceFile = function (objHandle: HCkStream): PWideChar; stdcall;
  TCkStream_getSourceFilePart = function (objHandle: HCkStream): Integer; stdcall;
  TCkStream_putSourceFilePart = procedure (objHandle: HCkStream; newPropVal: Integer); stdcall;
  TCkStream_getSourceFilePartSize = function (objHandle: HCkStream): Integer; stdcall;
  TCkStream_putSourceFilePartSize = procedure (objHandle: HCkStream; newPropVal: Integer); stdcall;
  TCkStream_getStringBom = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_putStringBom = procedure (objHandle: HCkStream; newPropVal: wordbool); stdcall;
  TCkStream_getStringCharset = procedure (objHandle: HCkStream; outPropVal: HCkString); stdcall;
  TCkStream_putStringCharset = procedure (objHandle: HCkStream; newPropVal: PWideChar); stdcall;
  TCkStream__stringCharset = function (objHandle: HCkStream): PWideChar; stdcall;
  TCkStream_getVerboseLogging = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_putVerboseLogging = procedure (objHandle: HCkStream; newPropVal: wordbool); stdcall;
  TCkStream_getVersion = procedure (objHandle: HCkStream; outPropVal: HCkString); stdcall;
  TCkStream__version = function (objHandle: HCkStream): PWideChar; stdcall;
  TCkStream_getWriteFailReason = function (objHandle: HCkStream): Integer; stdcall;
  TCkStream_getWriteTimeoutMs = function (objHandle: HCkStream): Integer; stdcall;
  TCkStream_putWriteTimeoutMs = procedure (objHandle: HCkStream; newPropVal: Integer); stdcall;
  TCkStream_LoadTaskCaller = function (objHandle: HCkStream; task: HCkTask): wordbool; stdcall;
  TCkStream_ReadBd = function (objHandle: HCkStream; binData: HCkBinData): wordbool; stdcall;
  TCkStream_ReadBdAsync = function (objHandle: HCkStream; binData: HCkBinData): HCkTask; stdcall;
  TCkStream_ReadBytes = function (objHandle: HCkStream; outData: HCkByteData): wordbool; stdcall;
  TCkStream_ReadBytesAsync = function (objHandle: HCkStream): HCkTask; stdcall;
  TCkStream_ReadBytesENC = function (objHandle: HCkStream; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkStream__readBytesENC = function (objHandle: HCkStream; encoding: PWideChar): PWideChar; stdcall;
  TCkStream_ReadBytesENCAsync = function (objHandle: HCkStream; encoding: PWideChar): HCkTask; stdcall;
  TCkStream_ReadNBytes = function (objHandle: HCkStream; numBytes: Integer; outData: HCkByteData): wordbool; stdcall;
  TCkStream_ReadNBytesAsync = function (objHandle: HCkStream; numBytes: Integer): HCkTask; stdcall;
  TCkStream_ReadNBytesENC = function (objHandle: HCkStream; numBytes: Integer; encoding: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkStream__readNBytesENC = function (objHandle: HCkStream; numBytes: Integer; encoding: PWideChar): PWideChar; stdcall;
  TCkStream_ReadNBytesENCAsync = function (objHandle: HCkStream; numBytes: Integer; encoding: PWideChar): HCkTask; stdcall;
  TCkStream_ReadSb = function (objHandle: HCkStream; sb: HCkStringBuilder): wordbool; stdcall;
  TCkStream_ReadSbAsync = function (objHandle: HCkStream; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkStream_ReadString = function (objHandle: HCkStream; outStr: HCkString): wordbool; stdcall;
  TCkStream__readString = function (objHandle: HCkStream): PWideChar; stdcall;
  TCkStream_ReadStringAsync = function (objHandle: HCkStream): HCkTask; stdcall;
  TCkStream_ReadToCRLF = function (objHandle: HCkStream; outStr: HCkString): wordbool; stdcall;
  TCkStream__readToCRLF = function (objHandle: HCkStream): PWideChar; stdcall;
  TCkStream_ReadToCRLFAsync = function (objHandle: HCkStream): HCkTask; stdcall;
  TCkStream_ReadUntilMatch = function (objHandle: HCkStream; matchStr: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkStream__readUntilMatch = function (objHandle: HCkStream; matchStr: PWideChar): PWideChar; stdcall;
  TCkStream_ReadUntilMatchAsync = function (objHandle: HCkStream; matchStr: PWideChar): HCkTask; stdcall;
  TCkStream_Reset = procedure (objHandle: HCkStream); stdcall;
  TCkStream_SetSourceBytes = function (objHandle: HCkStream; sourceData: HCkByteData): wordbool; stdcall;
  TCkStream_SetSourceString = function (objHandle: HCkStream; srcStr: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkStream_WriteBd = function (objHandle: HCkStream; binData: HCkBinData): wordbool; stdcall;
  TCkStream_WriteBdAsync = function (objHandle: HCkStream; binData: HCkBinData): HCkTask; stdcall;
  TCkStream_WriteByte = function (objHandle: HCkStream; byteVal: Integer): wordbool; stdcall;
  TCkStream_WriteByteAsync = function (objHandle: HCkStream; byteVal: Integer): HCkTask; stdcall;
  TCkStream_WriteBytes = function (objHandle: HCkStream; byteData: HCkByteData): wordbool; stdcall;
  TCkStream_WriteBytesAsync = function (objHandle: HCkStream; byteData: HCkByteData): HCkTask; stdcall;
  TCkStream_WriteBytesENC = function (objHandle: HCkStream; byteData: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkStream_WriteBytesENCAsync = function (objHandle: HCkStream; byteData: PWideChar; encoding: PWideChar): HCkTask; stdcall;
  TCkStream_WriteClose = function (objHandle: HCkStream): wordbool; stdcall;
  TCkStream_WriteSb = function (objHandle: HCkStream; sb: HCkStringBuilder): wordbool; stdcall;
  TCkStream_WriteSbAsync = function (objHandle: HCkStream; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkStream_WriteString = function (objHandle: HCkStream; str: PWideChar): wordbool; stdcall;
  TCkStream_WriteStringAsync = function (objHandle: HCkStream; str: PWideChar): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..100] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkStream_Create : HCkStream;
begin
  result := TCkStream_Create(_map(0, 'CkStream_Create'));
end;

procedure CkStream_Dispose (handle: HCkStream);
begin
  TCkStream_Dispose(_map(1, 'CkStream_Dispose'))
    (handle);
end;


procedure CkStream_SetAbortCheck (objHandle: HCkStream; fn: TStreamAbortCheck);
begin
    TCkStream_SetAbortCheck(_map(2, 'CkStream_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkStream_SetProgressInfo (objHandle: HCkStream; fn: TStreamProgressInfo);
begin
    TCkStream_SetProgressInfo(_map(3, 'CkStream_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkStream_SetPercentDone (objHandle: HCkStream; fn: TStreamPercentDone);
begin
    TCkStream_SetPercentDone(_map(4, 'CkStream_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkStream_SetTaskCompleted (objHandle: HCkStream; fn: TStreamTaskCompleted);
begin
    TCkStream_SetTaskCompleted(_map(5, 'CkStream_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkStream_getAbortCurrent (objHandle: HCkStream): wordbool;
begin
    result := TCkStream_getAbortCurrent(_map(6, 'CkStream_getAbortCurrent'))
    (objHandle);
end;

procedure CkStream_putAbortCurrent (objHandle: HCkStream; newPropVal: wordbool);
begin
  TCkStream_putAbortCurrent(_map(7, 'CkStream_putAbortCurrent'))
    (objHandle, newPropVal);
end;

function CkStream_getCanRead (objHandle: HCkStream): wordbool;
begin
    result := TCkStream_getCanRead(_map(8, 'CkStream_getCanRead'))
    (objHandle);
end;

function CkStream_getCanWrite (objHandle: HCkStream): wordbool;
begin
    result := TCkStream_getCanWrite(_map(9, 'CkStream_getCanWrite'))
    (objHandle);
end;

function CkStream_getDataAvailable (objHandle: HCkStream): wordbool;
begin
    result := TCkStream_getDataAvailable(_map(10, 'CkStream_getDataAvailable'))
    (objHandle);
end;

procedure CkStream_getDebugLogFilePath (objHandle: HCkStream; outPropVal: HCkString);
begin
  TCkStream_getDebugLogFilePath(_map(11, 'CkStream_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkStream_putDebugLogFilePath (objHandle: HCkStream; newPropVal: PWideChar);
begin
  TCkStream_putDebugLogFilePath(_map(12, 'CkStream_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkStream__debugLogFilePath (objHandle: HCkStream): PWideChar;
begin
  result := TCkStream__debugLogFilePath(_map(13, 'CkStream__debugLogFilePath'))
    (objHandle);
end;

function CkStream_getDefaultChunkSize (objHandle: HCkStream): Integer;
begin
    result := TCkStream_getDefaultChunkSize(_map(14, 'CkStream_getDefaultChunkSize'))
    (objHandle);
end;

procedure CkStream_putDefaultChunkSize (objHandle: HCkStream; newPropVal: Integer);
begin
  TCkStream_putDefaultChunkSize(_map(15, 'CkStream_putDefaultChunkSize'))
    (objHandle, newPropVal);
end;

function CkStream_getEndOfStream (objHandle: HCkStream): wordbool;
begin
    result := TCkStream_getEndOfStream(_map(16, 'CkStream_getEndOfStream'))
    (objHandle);
end;

function CkStream_getHeartbeatMs (objHandle: HCkStream): Integer;
begin
    result := TCkStream_getHeartbeatMs(_map(17, 'CkStream_getHeartbeatMs'))
    (objHandle);
end;

procedure CkStream_putHeartbeatMs (objHandle: HCkStream; newPropVal: Integer);
begin
  TCkStream_putHeartbeatMs(_map(18, 'CkStream_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

function CkStream_getIsWriteClosed (objHandle: HCkStream): wordbool;
begin
    result := TCkStream_getIsWriteClosed(_map(19, 'CkStream_getIsWriteClosed'))
    (objHandle);
end;

procedure CkStream_getLastErrorHtml (objHandle: HCkStream; outPropVal: HCkString);
begin
  TCkStream_getLastErrorHtml(_map(20, 'CkStream_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkStream__lastErrorHtml (objHandle: HCkStream): PWideChar;
begin
  result := TCkStream__lastErrorHtml(_map(21, 'CkStream__lastErrorHtml'))
    (objHandle);
end;

procedure CkStream_getLastErrorText (objHandle: HCkStream; outPropVal: HCkString);
begin
  TCkStream_getLastErrorText(_map(22, 'CkStream_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkStream__lastErrorText (objHandle: HCkStream): PWideChar;
begin
  result := TCkStream__lastErrorText(_map(23, 'CkStream__lastErrorText'))
    (objHandle);
end;

procedure CkStream_getLastErrorXml (objHandle: HCkStream; outPropVal: HCkString);
begin
  TCkStream_getLastErrorXml(_map(24, 'CkStream_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkStream__lastErrorXml (objHandle: HCkStream): PWideChar;
begin
  result := TCkStream__lastErrorXml(_map(25, 'CkStream__lastErrorXml'))
    (objHandle);
end;

function CkStream_getLastMethodSuccess (objHandle: HCkStream): wordbool;
begin
    result := TCkStream_getLastMethodSuccess(_map(26, 'CkStream_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkStream_putLastMethodSuccess (objHandle: HCkStream; newPropVal: wordbool);
begin
  TCkStream_putLastMethodSuccess(_map(27, 'CkStream_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkStream_getLength (objHandle: HCkStream): Int64;
begin
    result := TCkStream_getLength(_map(28, 'CkStream_getLength'))
    (objHandle);
end;

procedure CkStream_putLength (objHandle: HCkStream; newPropVal: Int64);
begin
  TCkStream_putLength(_map(29, 'CkStream_putLength'))
    (objHandle, newPropVal);
end;

function CkStream_getLength32 (objHandle: HCkStream): Integer;
begin
    result := TCkStream_getLength32(_map(30, 'CkStream_getLength32'))
    (objHandle);
end;

procedure CkStream_putLength32 (objHandle: HCkStream; newPropVal: Integer);
begin
  TCkStream_putLength32(_map(31, 'CkStream_putLength32'))
    (objHandle, newPropVal);
end;

function CkStream_getNumReceived (objHandle: HCkStream): Int64;
begin
    result := TCkStream_getNumReceived(_map(32, 'CkStream_getNumReceived'))
    (objHandle);
end;

function CkStream_getNumSent (objHandle: HCkStream): Int64;
begin
    result := TCkStream_getNumSent(_map(33, 'CkStream_getNumSent'))
    (objHandle);
end;

function CkStream_getReadFailReason (objHandle: HCkStream): Integer;
begin
    result := TCkStream_getReadFailReason(_map(34, 'CkStream_getReadFailReason'))
    (objHandle);
end;

function CkStream_getReadTimeoutMs (objHandle: HCkStream): Integer;
begin
    result := TCkStream_getReadTimeoutMs(_map(35, 'CkStream_getReadTimeoutMs'))
    (objHandle);
end;

procedure CkStream_putReadTimeoutMs (objHandle: HCkStream; newPropVal: Integer);
begin
  TCkStream_putReadTimeoutMs(_map(36, 'CkStream_putReadTimeoutMs'))
    (objHandle, newPropVal);
end;

procedure CkStream_getSinkFile (objHandle: HCkStream; outPropVal: HCkString);
begin
  TCkStream_getSinkFile(_map(37, 'CkStream_getSinkFile'))
    (objHandle, outPropVal);
end;

procedure CkStream_putSinkFile (objHandle: HCkStream; newPropVal: PWideChar);
begin
  TCkStream_putSinkFile(_map(38, 'CkStream_putSinkFile'))
    (objHandle, newPropVal);
end;

function CkStream__sinkFile (objHandle: HCkStream): PWideChar;
begin
  result := TCkStream__sinkFile(_map(39, 'CkStream__sinkFile'))
    (objHandle);
end;

function CkStream_getSinkFileAppend (objHandle: HCkStream): wordbool;
begin
    result := TCkStream_getSinkFileAppend(_map(40, 'CkStream_getSinkFileAppend'))
    (objHandle);
end;

procedure CkStream_putSinkFileAppend (objHandle: HCkStream; newPropVal: wordbool);
begin
  TCkStream_putSinkFileAppend(_map(41, 'CkStream_putSinkFileAppend'))
    (objHandle, newPropVal);
end;

procedure CkStream_getSourceFile (objHandle: HCkStream; outPropVal: HCkString);
begin
  TCkStream_getSourceFile(_map(42, 'CkStream_getSourceFile'))
    (objHandle, outPropVal);
end;

procedure CkStream_putSourceFile (objHandle: HCkStream; newPropVal: PWideChar);
begin
  TCkStream_putSourceFile(_map(43, 'CkStream_putSourceFile'))
    (objHandle, newPropVal);
end;

function CkStream__sourceFile (objHandle: HCkStream): PWideChar;
begin
  result := TCkStream__sourceFile(_map(44, 'CkStream__sourceFile'))
    (objHandle);
end;

function CkStream_getSourceFilePart (objHandle: HCkStream): Integer;
begin
    result := TCkStream_getSourceFilePart(_map(45, 'CkStream_getSourceFilePart'))
    (objHandle);
end;

procedure CkStream_putSourceFilePart (objHandle: HCkStream; newPropVal: Integer);
begin
  TCkStream_putSourceFilePart(_map(46, 'CkStream_putSourceFilePart'))
    (objHandle, newPropVal);
end;

function CkStream_getSourceFilePartSize (objHandle: HCkStream): Integer;
begin
    result := TCkStream_getSourceFilePartSize(_map(47, 'CkStream_getSourceFilePartSize'))
    (objHandle);
end;

procedure CkStream_putSourceFilePartSize (objHandle: HCkStream; newPropVal: Integer);
begin
  TCkStream_putSourceFilePartSize(_map(48, 'CkStream_putSourceFilePartSize'))
    (objHandle, newPropVal);
end;

function CkStream_getStringBom (objHandle: HCkStream): wordbool;
begin
    result := TCkStream_getStringBom(_map(49, 'CkStream_getStringBom'))
    (objHandle);
end;

procedure CkStream_putStringBom (objHandle: HCkStream; newPropVal: wordbool);
begin
  TCkStream_putStringBom(_map(50, 'CkStream_putStringBom'))
    (objHandle, newPropVal);
end;

procedure CkStream_getStringCharset (objHandle: HCkStream; outPropVal: HCkString);
begin
  TCkStream_getStringCharset(_map(51, 'CkStream_getStringCharset'))
    (objHandle, outPropVal);
end;

procedure CkStream_putStringCharset (objHandle: HCkStream; newPropVal: PWideChar);
begin
  TCkStream_putStringCharset(_map(52, 'CkStream_putStringCharset'))
    (objHandle, newPropVal);
end;

function CkStream__stringCharset (objHandle: HCkStream): PWideChar;
begin
  result := TCkStream__stringCharset(_map(53, 'CkStream__stringCharset'))
    (objHandle);
end;

function CkStream_getVerboseLogging (objHandle: HCkStream): wordbool;
begin
    result := TCkStream_getVerboseLogging(_map(54, 'CkStream_getVerboseLogging'))
    (objHandle);
end;

procedure CkStream_putVerboseLogging (objHandle: HCkStream; newPropVal: wordbool);
begin
  TCkStream_putVerboseLogging(_map(55, 'CkStream_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkStream_getVersion (objHandle: HCkStream; outPropVal: HCkString);
begin
  TCkStream_getVersion(_map(56, 'CkStream_getVersion'))
    (objHandle, outPropVal);
end;

function CkStream__version (objHandle: HCkStream): PWideChar;
begin
  result := TCkStream__version(_map(57, 'CkStream__version'))
    (objHandle);
end;

function CkStream_getWriteFailReason (objHandle: HCkStream): Integer;
begin
    result := TCkStream_getWriteFailReason(_map(58, 'CkStream_getWriteFailReason'))
    (objHandle);
end;

function CkStream_getWriteTimeoutMs (objHandle: HCkStream): Integer;
begin
    result := TCkStream_getWriteTimeoutMs(_map(59, 'CkStream_getWriteTimeoutMs'))
    (objHandle);
end;

procedure CkStream_putWriteTimeoutMs (objHandle: HCkStream; newPropVal: Integer);
begin
  TCkStream_putWriteTimeoutMs(_map(60, 'CkStream_putWriteTimeoutMs'))
    (objHandle, newPropVal);
end;

function CkStream_LoadTaskCaller (objHandle: HCkStream; task: HCkTask): wordbool;
begin
  result := TCkStream_LoadTaskCaller(_map(61, 'CkStream_LoadTaskCaller'))
    (objHandle, task);
end;

function CkStream_ReadBd (objHandle: HCkStream; binData: HCkBinData): wordbool;
begin
  result := TCkStream_ReadBd(_map(62, 'CkStream_ReadBd'))
    (objHandle, binData);
end;

function CkStream_ReadBdAsync (objHandle: HCkStream; binData: HCkBinData): HCkTask;
begin
  result := TCkStream_ReadBdAsync(_map(63, 'CkStream_ReadBdAsync'))
    (objHandle, binData);
end;

function CkStream_ReadBytes (objHandle: HCkStream; outData: HCkByteData): wordbool;
begin
  result := TCkStream_ReadBytes(_map(64, 'CkStream_ReadBytes'))
    (objHandle, outData);
end;

function CkStream_ReadBytesAsync (objHandle: HCkStream): HCkTask;
begin
  result := TCkStream_ReadBytesAsync(_map(65, 'CkStream_ReadBytesAsync'))
    (objHandle);
end;

function CkStream_ReadBytesENC (objHandle: HCkStream; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkStream_ReadBytesENC(_map(66, 'CkStream_ReadBytesENC'))
    (objHandle, encoding, outStr);
end;

function CkStream__readBytesENC (objHandle: HCkStream; encoding: PWideChar): PWideChar;
begin
  result := TCkStream__readBytesENC(_map(67, 'CkStream__readBytesENC'))
    (objHandle, encoding);
end;

function CkStream_ReadBytesENCAsync (objHandle: HCkStream; encoding: PWideChar): HCkTask;
begin
  result := TCkStream_ReadBytesENCAsync(_map(68, 'CkStream_ReadBytesENCAsync'))
    (objHandle, encoding);
end;

function CkStream_ReadNBytes (objHandle: HCkStream; numBytes: Integer; outData: HCkByteData): wordbool;
begin
  result := TCkStream_ReadNBytes(_map(69, 'CkStream_ReadNBytes'))
    (objHandle, numBytes, outData);
end;

function CkStream_ReadNBytesAsync (objHandle: HCkStream; numBytes: Integer): HCkTask;
begin
  result := TCkStream_ReadNBytesAsync(_map(70, 'CkStream_ReadNBytesAsync'))
    (objHandle, numBytes);
end;

function CkStream_ReadNBytesENC (objHandle: HCkStream; numBytes: Integer; encoding: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkStream_ReadNBytesENC(_map(71, 'CkStream_ReadNBytesENC'))
    (objHandle, numBytes, encoding, outStr);
end;

function CkStream__readNBytesENC (objHandle: HCkStream; numBytes: Integer; encoding: PWideChar): PWideChar;
begin
  result := TCkStream__readNBytesENC(_map(72, 'CkStream__readNBytesENC'))
    (objHandle, numBytes, encoding);
end;

function CkStream_ReadNBytesENCAsync (objHandle: HCkStream; numBytes: Integer; encoding: PWideChar): HCkTask;
begin
  result := TCkStream_ReadNBytesENCAsync(_map(73, 'CkStream_ReadNBytesENCAsync'))
    (objHandle, numBytes, encoding);
end;

function CkStream_ReadSb (objHandle: HCkStream; sb: HCkStringBuilder): wordbool;
begin
  result := TCkStream_ReadSb(_map(74, 'CkStream_ReadSb'))
    (objHandle, sb);
end;

function CkStream_ReadSbAsync (objHandle: HCkStream; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkStream_ReadSbAsync(_map(75, 'CkStream_ReadSbAsync'))
    (objHandle, sb);
end;

function CkStream_ReadString (objHandle: HCkStream; outStr: HCkString): wordbool;
begin
  result := TCkStream_ReadString(_map(76, 'CkStream_ReadString'))
    (objHandle, outStr);
end;

function CkStream__readString (objHandle: HCkStream): PWideChar;
begin
  result := TCkStream__readString(_map(77, 'CkStream__readString'))
    (objHandle);
end;

function CkStream_ReadStringAsync (objHandle: HCkStream): HCkTask;
begin
  result := TCkStream_ReadStringAsync(_map(78, 'CkStream_ReadStringAsync'))
    (objHandle);
end;

function CkStream_ReadToCRLF (objHandle: HCkStream; outStr: HCkString): wordbool;
begin
  result := TCkStream_ReadToCRLF(_map(79, 'CkStream_ReadToCRLF'))
    (objHandle, outStr);
end;

function CkStream__readToCRLF (objHandle: HCkStream): PWideChar;
begin
  result := TCkStream__readToCRLF(_map(80, 'CkStream__readToCRLF'))
    (objHandle);
end;

function CkStream_ReadToCRLFAsync (objHandle: HCkStream): HCkTask;
begin
  result := TCkStream_ReadToCRLFAsync(_map(81, 'CkStream_ReadToCRLFAsync'))
    (objHandle);
end;

function CkStream_ReadUntilMatch (objHandle: HCkStream; matchStr: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkStream_ReadUntilMatch(_map(82, 'CkStream_ReadUntilMatch'))
    (objHandle, matchStr, outStr);
end;

function CkStream__readUntilMatch (objHandle: HCkStream; matchStr: PWideChar): PWideChar;
begin
  result := TCkStream__readUntilMatch(_map(83, 'CkStream__readUntilMatch'))
    (objHandle, matchStr);
end;

function CkStream_ReadUntilMatchAsync (objHandle: HCkStream; matchStr: PWideChar): HCkTask;
begin
  result := TCkStream_ReadUntilMatchAsync(_map(84, 'CkStream_ReadUntilMatchAsync'))
    (objHandle, matchStr);
end;

procedure CkStream_Reset (objHandle: HCkStream);
begin
  TCkStream_Reset(_map(85, 'CkStream_Reset'))
    (objHandle);
end;

function CkStream_SetSourceBytes (objHandle: HCkStream; sourceData: HCkByteData): wordbool;
begin
  result := TCkStream_SetSourceBytes(_map(86, 'CkStream_SetSourceBytes'))
    (objHandle, sourceData);
end;

function CkStream_SetSourceString (objHandle: HCkStream; srcStr: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkStream_SetSourceString(_map(87, 'CkStream_SetSourceString'))
    (objHandle, srcStr, charset);
end;

function CkStream_WriteBd (objHandle: HCkStream; binData: HCkBinData): wordbool;
begin
  result := TCkStream_WriteBd(_map(88, 'CkStream_WriteBd'))
    (objHandle, binData);
end;

function CkStream_WriteBdAsync (objHandle: HCkStream; binData: HCkBinData): HCkTask;
begin
  result := TCkStream_WriteBdAsync(_map(89, 'CkStream_WriteBdAsync'))
    (objHandle, binData);
end;

function CkStream_WriteByte (objHandle: HCkStream; byteVal: Integer): wordbool;
begin
  result := TCkStream_WriteByte(_map(90, 'CkStream_WriteByte'))
    (objHandle, byteVal);
end;

function CkStream_WriteByteAsync (objHandle: HCkStream; byteVal: Integer): HCkTask;
begin
  result := TCkStream_WriteByteAsync(_map(91, 'CkStream_WriteByteAsync'))
    (objHandle, byteVal);
end;

function CkStream_WriteBytes (objHandle: HCkStream; byteData: HCkByteData): wordbool;
begin
  result := TCkStream_WriteBytes(_map(92, 'CkStream_WriteBytes'))
    (objHandle, byteData);
end;

function CkStream_WriteBytesAsync (objHandle: HCkStream; byteData: HCkByteData): HCkTask;
begin
  result := TCkStream_WriteBytesAsync(_map(93, 'CkStream_WriteBytesAsync'))
    (objHandle, byteData);
end;

function CkStream_WriteBytesENC (objHandle: HCkStream; byteData: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkStream_WriteBytesENC(_map(94, 'CkStream_WriteBytesENC'))
    (objHandle, byteData, encoding);
end;

function CkStream_WriteBytesENCAsync (objHandle: HCkStream; byteData: PWideChar; encoding: PWideChar): HCkTask;
begin
  result := TCkStream_WriteBytesENCAsync(_map(95, 'CkStream_WriteBytesENCAsync'))
    (objHandle, byteData, encoding);
end;

function CkStream_WriteClose (objHandle: HCkStream): wordbool;
begin
  result := TCkStream_WriteClose(_map(96, 'CkStream_WriteClose'))
    (objHandle);
end;

function CkStream_WriteSb (objHandle: HCkStream; sb: HCkStringBuilder): wordbool;
begin
  result := TCkStream_WriteSb(_map(97, 'CkStream_WriteSb'))
    (objHandle, sb);
end;

function CkStream_WriteSbAsync (objHandle: HCkStream; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkStream_WriteSbAsync(_map(98, 'CkStream_WriteSbAsync'))
    (objHandle, sb);
end;

function CkStream_WriteString (objHandle: HCkStream; str: PWideChar): wordbool;
begin
  result := TCkStream_WriteString(_map(99, 'CkStream_WriteString'))
    (objHandle, str);
end;

function CkStream_WriteStringAsync (objHandle: HCkStream; str: PWideChar): HCkTask;
begin
  result := TCkStream_WriteStringAsync(_map(100, 'CkStream_WriteStringAsync'))
    (objHandle, str);
end;

end.
