unit Task;

interface

type

HCkTask = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TTaskAbortCheck = function(): Integer; cdecl;
TTaskProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TTaskPercentDone = function(pctDone: Integer): Integer; cdecl;
TTaskTaskCompleted = procedure(task: HCkTask); cdecl;


function CkTask_Create: HCkTask;  stdcall;
procedure CkTask_Dispose(handle: HCkTask); stdcall;

procedure CkTask_SetAbortCheck(objHandle: HCkTask; fn: TTaskAbortCheck) stdcall;
procedure CkTask_SetProgressInfo(objHandle: HCkTask; fn: TTaskProgressInfo) stdcall;
procedure CkTask_SetPercentDone(objHandle: HCkTask; fn: TTaskPercentDone) stdcall;
procedure CkTask_SetTaskCompleted(objHandle: HCkTask; fn: TTaskTaskCompleted) stdcall;
procedure CkTask_getDebugLogFilePath(objHandle: HCkTask; outPropVal: HCkString);
procedure CkTask_putDebugLogFilePath(objHandle: HCkTask; newPropVal: PWideChar);
function CkTask__debugLogFilePath(objHandle: HCkTask): PWideChar;
function CkTask_getFinished(objHandle: HCkTask): wordbool;
function CkTask_getHeartbeatMs(objHandle: HCkTask): Integer;
procedure CkTask_putHeartbeatMs(objHandle: HCkTask; newPropVal: Integer);
function CkTask_getInert(objHandle: HCkTask): wordbool;
function CkTask_getKeepProgressLog(objHandle: HCkTask): wordbool;
procedure CkTask_putKeepProgressLog(objHandle: HCkTask; newPropVal: wordbool);
procedure CkTask_getLastErrorHtml(objHandle: HCkTask; outPropVal: HCkString);
function CkTask__lastErrorHtml(objHandle: HCkTask): PWideChar;
procedure CkTask_getLastErrorText(objHandle: HCkTask; outPropVal: HCkString);
function CkTask__lastErrorText(objHandle: HCkTask): PWideChar;
procedure CkTask_getLastErrorXml(objHandle: HCkTask; outPropVal: HCkString);
function CkTask__lastErrorXml(objHandle: HCkTask): PWideChar;
function CkTask_getLastMethodSuccess(objHandle: HCkTask): wordbool;
procedure CkTask_putLastMethodSuccess(objHandle: HCkTask; newPropVal: wordbool);
function CkTask_getLive(objHandle: HCkTask): wordbool;
function CkTask_getPercentDone(objHandle: HCkTask): Integer;
function CkTask_getProgressLogSize(objHandle: HCkTask): Integer;
procedure CkTask_getResultErrorText(objHandle: HCkTask; outPropVal: HCkString);
function CkTask__resultErrorText(objHandle: HCkTask): PWideChar;
procedure CkTask_getResultType(objHandle: HCkTask; outPropVal: HCkString);
function CkTask__resultType(objHandle: HCkTask): PWideChar;
procedure CkTask_getStatus(objHandle: HCkTask; outPropVal: HCkString);
function CkTask__status(objHandle: HCkTask): PWideChar;
function CkTask_getStatusInt(objHandle: HCkTask): Integer;
function CkTask_getTaskId(objHandle: HCkTask): Integer;
function CkTask_getTaskSuccess(objHandle: HCkTask): wordbool;
procedure CkTask_getUserData(objHandle: HCkTask; outPropVal: HCkString);
procedure CkTask_putUserData(objHandle: HCkTask; newPropVal: PWideChar);
function CkTask__userData(objHandle: HCkTask): PWideChar;
function CkTask_getVerboseLogging(objHandle: HCkTask): wordbool;
procedure CkTask_putVerboseLogging(objHandle: HCkTask; newPropVal: wordbool);
procedure CkTask_getVersion(objHandle: HCkTask; outPropVal: HCkString);
function CkTask__version(objHandle: HCkTask): PWideChar;
function CkTask_Cancel(objHandle: HCkTask): wordbool;
procedure CkTask_ClearProgressLog(objHandle: HCkTask);
function CkTask_CopyResultBytes(objHandle: HCkTask; outData: HCkByteData): wordbool;
function CkTask_GetResultBool(objHandle: HCkTask): wordbool;
function CkTask_GetResultBytes(objHandle: HCkTask; outData: HCkByteData): wordbool;
function CkTask_GetResultInt(objHandle: HCkTask): Integer;
function CkTask_GetResultString(objHandle: HCkTask; outStr: HCkString): wordbool;
function CkTask__getResultString(objHandle: HCkTask): PWideChar;
function CkTask_ProgressInfoName(objHandle: HCkTask; index: Integer; outStr: HCkString): wordbool;
function CkTask__progressInfoName(objHandle: HCkTask; index: Integer): PWideChar;
function CkTask_ProgressInfoValue(objHandle: HCkTask; index: Integer; outStr: HCkString): wordbool;
function CkTask__progressInfoValue(objHandle: HCkTask; index: Integer): PWideChar;
procedure CkTask_RemoveProgressInfo(objHandle: HCkTask; index: Integer);
function CkTask_Run(objHandle: HCkTask): wordbool;
function CkTask_RunSynchronously(objHandle: HCkTask): wordbool;
procedure CkTask_SleepMs(objHandle: HCkTask; numMs: Integer);
function CkTask_Wait(objHandle: HCkTask; maxWaitMs: Integer): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkTask_Create = function : HCkTask; stdcall;
  TCkTask_Dispose = procedure (handle: HCkTask); stdcall;
  TCkTask_SetAbortCheck = procedure (objHandle: HCkTask; fn: TTaskAbortCheck); stdcall;
  TCkTask_SetProgressInfo = procedure (objHandle: HCkTask; fn: TTaskProgressInfo); stdcall;
  TCkTask_SetPercentDone = procedure (objHandle: HCkTask; fn: TTaskPercentDone); stdcall;
  TCkTask_SetTaskCompleted = procedure (objHandle: HCkTask; fn: TTaskTaskCompleted); stdcall;
  TCkTask_getDebugLogFilePath = procedure (objHandle: HCkTask; outPropVal: HCkString); stdcall;
  TCkTask_putDebugLogFilePath = procedure (objHandle: HCkTask; newPropVal: PWideChar); stdcall;
  TCkTask__debugLogFilePath = function (objHandle: HCkTask): PWideChar; stdcall;
  TCkTask_getFinished = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_getHeartbeatMs = function (objHandle: HCkTask): Integer; stdcall;
  TCkTask_putHeartbeatMs = procedure (objHandle: HCkTask; newPropVal: Integer); stdcall;
  TCkTask_getInert = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_getKeepProgressLog = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_putKeepProgressLog = procedure (objHandle: HCkTask; newPropVal: wordbool); stdcall;
  TCkTask_getLastErrorHtml = procedure (objHandle: HCkTask; outPropVal: HCkString); stdcall;
  TCkTask__lastErrorHtml = function (objHandle: HCkTask): PWideChar; stdcall;
  TCkTask_getLastErrorText = procedure (objHandle: HCkTask; outPropVal: HCkString); stdcall;
  TCkTask__lastErrorText = function (objHandle: HCkTask): PWideChar; stdcall;
  TCkTask_getLastErrorXml = procedure (objHandle: HCkTask; outPropVal: HCkString); stdcall;
  TCkTask__lastErrorXml = function (objHandle: HCkTask): PWideChar; stdcall;
  TCkTask_getLastMethodSuccess = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_putLastMethodSuccess = procedure (objHandle: HCkTask; newPropVal: wordbool); stdcall;
  TCkTask_getLive = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_getPercentDone = function (objHandle: HCkTask): Integer; stdcall;
  TCkTask_getProgressLogSize = function (objHandle: HCkTask): Integer; stdcall;
  TCkTask_getResultErrorText = procedure (objHandle: HCkTask; outPropVal: HCkString); stdcall;
  TCkTask__resultErrorText = function (objHandle: HCkTask): PWideChar; stdcall;
  TCkTask_getResultType = procedure (objHandle: HCkTask; outPropVal: HCkString); stdcall;
  TCkTask__resultType = function (objHandle: HCkTask): PWideChar; stdcall;
  TCkTask_getStatus = procedure (objHandle: HCkTask; outPropVal: HCkString); stdcall;
  TCkTask__status = function (objHandle: HCkTask): PWideChar; stdcall;
  TCkTask_getStatusInt = function (objHandle: HCkTask): Integer; stdcall;
  TCkTask_getTaskId = function (objHandle: HCkTask): Integer; stdcall;
  TCkTask_getTaskSuccess = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_getUserData = procedure (objHandle: HCkTask; outPropVal: HCkString); stdcall;
  TCkTask_putUserData = procedure (objHandle: HCkTask; newPropVal: PWideChar); stdcall;
  TCkTask__userData = function (objHandle: HCkTask): PWideChar; stdcall;
  TCkTask_getVerboseLogging = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_putVerboseLogging = procedure (objHandle: HCkTask; newPropVal: wordbool); stdcall;
  TCkTask_getVersion = procedure (objHandle: HCkTask; outPropVal: HCkString); stdcall;
  TCkTask__version = function (objHandle: HCkTask): PWideChar; stdcall;
  TCkTask_Cancel = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_ClearProgressLog = procedure (objHandle: HCkTask); stdcall;
  TCkTask_CopyResultBytes = function (objHandle: HCkTask; outData: HCkByteData): wordbool; stdcall;
  TCkTask_GetResultBool = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_GetResultBytes = function (objHandle: HCkTask; outData: HCkByteData): wordbool; stdcall;
  TCkTask_GetResultInt = function (objHandle: HCkTask): Integer; stdcall;
  TCkTask_GetResultString = function (objHandle: HCkTask; outStr: HCkString): wordbool; stdcall;
  TCkTask__getResultString = function (objHandle: HCkTask): PWideChar; stdcall;
  TCkTask_ProgressInfoName = function (objHandle: HCkTask; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkTask__progressInfoName = function (objHandle: HCkTask; index: Integer): PWideChar; stdcall;
  TCkTask_ProgressInfoValue = function (objHandle: HCkTask; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkTask__progressInfoValue = function (objHandle: HCkTask; index: Integer): PWideChar; stdcall;
  TCkTask_RemoveProgressInfo = procedure (objHandle: HCkTask; index: Integer); stdcall;
  TCkTask_Run = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_RunSynchronously = function (objHandle: HCkTask): wordbool; stdcall;
  TCkTask_SleepMs = procedure (objHandle: HCkTask; numMs: Integer); stdcall;
  TCkTask_Wait = function (objHandle: HCkTask; maxWaitMs: Integer): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..58] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkTask_Create : HCkTask;
begin
  result := TCkTask_Create(_map(0, 'CkTask_Create'));
end;

procedure CkTask_Dispose (handle: HCkTask);
begin
  TCkTask_Dispose(_map(1, 'CkTask_Dispose'))
    (handle);
end;


procedure CkTask_SetAbortCheck (objHandle: HCkTask; fn: TTaskAbortCheck);
begin
    TCkTask_SetAbortCheck(_map(2, 'CkTask_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkTask_SetProgressInfo (objHandle: HCkTask; fn: TTaskProgressInfo);
begin
    TCkTask_SetProgressInfo(_map(3, 'CkTask_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkTask_SetPercentDone (objHandle: HCkTask; fn: TTaskPercentDone);
begin
    TCkTask_SetPercentDone(_map(4, 'CkTask_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkTask_SetTaskCompleted (objHandle: HCkTask; fn: TTaskTaskCompleted);
begin
    TCkTask_SetTaskCompleted(_map(5, 'CkTask_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkTask_getDebugLogFilePath (objHandle: HCkTask; outPropVal: HCkString);
begin
  TCkTask_getDebugLogFilePath(_map(6, 'CkTask_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkTask_putDebugLogFilePath (objHandle: HCkTask; newPropVal: PWideChar);
begin
  TCkTask_putDebugLogFilePath(_map(7, 'CkTask_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkTask__debugLogFilePath (objHandle: HCkTask): PWideChar;
begin
  result := TCkTask__debugLogFilePath(_map(8, 'CkTask__debugLogFilePath'))
    (objHandle);
end;

function CkTask_getFinished (objHandle: HCkTask): wordbool;
begin
    result := TCkTask_getFinished(_map(9, 'CkTask_getFinished'))
    (objHandle);
end;

function CkTask_getHeartbeatMs (objHandle: HCkTask): Integer;
begin
    result := TCkTask_getHeartbeatMs(_map(10, 'CkTask_getHeartbeatMs'))
    (objHandle);
end;

procedure CkTask_putHeartbeatMs (objHandle: HCkTask; newPropVal: Integer);
begin
  TCkTask_putHeartbeatMs(_map(11, 'CkTask_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

function CkTask_getInert (objHandle: HCkTask): wordbool;
begin
    result := TCkTask_getInert(_map(12, 'CkTask_getInert'))
    (objHandle);
end;

function CkTask_getKeepProgressLog (objHandle: HCkTask): wordbool;
begin
    result := TCkTask_getKeepProgressLog(_map(13, 'CkTask_getKeepProgressLog'))
    (objHandle);
end;

procedure CkTask_putKeepProgressLog (objHandle: HCkTask; newPropVal: wordbool);
begin
  TCkTask_putKeepProgressLog(_map(14, 'CkTask_putKeepProgressLog'))
    (objHandle, newPropVal);
end;

procedure CkTask_getLastErrorHtml (objHandle: HCkTask; outPropVal: HCkString);
begin
  TCkTask_getLastErrorHtml(_map(15, 'CkTask_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkTask__lastErrorHtml (objHandle: HCkTask): PWideChar;
begin
  result := TCkTask__lastErrorHtml(_map(16, 'CkTask__lastErrorHtml'))
    (objHandle);
end;

procedure CkTask_getLastErrorText (objHandle: HCkTask; outPropVal: HCkString);
begin
  TCkTask_getLastErrorText(_map(17, 'CkTask_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkTask__lastErrorText (objHandle: HCkTask): PWideChar;
begin
  result := TCkTask__lastErrorText(_map(18, 'CkTask__lastErrorText'))
    (objHandle);
end;

procedure CkTask_getLastErrorXml (objHandle: HCkTask; outPropVal: HCkString);
begin
  TCkTask_getLastErrorXml(_map(19, 'CkTask_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkTask__lastErrorXml (objHandle: HCkTask): PWideChar;
begin
  result := TCkTask__lastErrorXml(_map(20, 'CkTask__lastErrorXml'))
    (objHandle);
end;

function CkTask_getLastMethodSuccess (objHandle: HCkTask): wordbool;
begin
    result := TCkTask_getLastMethodSuccess(_map(21, 'CkTask_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkTask_putLastMethodSuccess (objHandle: HCkTask; newPropVal: wordbool);
begin
  TCkTask_putLastMethodSuccess(_map(22, 'CkTask_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkTask_getLive (objHandle: HCkTask): wordbool;
begin
    result := TCkTask_getLive(_map(23, 'CkTask_getLive'))
    (objHandle);
end;

function CkTask_getPercentDone (objHandle: HCkTask): Integer;
begin
    result := TCkTask_getPercentDone(_map(24, 'CkTask_getPercentDone'))
    (objHandle);
end;

function CkTask_getProgressLogSize (objHandle: HCkTask): Integer;
begin
    result := TCkTask_getProgressLogSize(_map(25, 'CkTask_getProgressLogSize'))
    (objHandle);
end;

procedure CkTask_getResultErrorText (objHandle: HCkTask; outPropVal: HCkString);
begin
  TCkTask_getResultErrorText(_map(26, 'CkTask_getResultErrorText'))
    (objHandle, outPropVal);
end;

function CkTask__resultErrorText (objHandle: HCkTask): PWideChar;
begin
  result := TCkTask__resultErrorText(_map(27, 'CkTask__resultErrorText'))
    (objHandle);
end;

procedure CkTask_getResultType (objHandle: HCkTask; outPropVal: HCkString);
begin
  TCkTask_getResultType(_map(28, 'CkTask_getResultType'))
    (objHandle, outPropVal);
end;

function CkTask__resultType (objHandle: HCkTask): PWideChar;
begin
  result := TCkTask__resultType(_map(29, 'CkTask__resultType'))
    (objHandle);
end;

procedure CkTask_getStatus (objHandle: HCkTask; outPropVal: HCkString);
begin
  TCkTask_getStatus(_map(30, 'CkTask_getStatus'))
    (objHandle, outPropVal);
end;

function CkTask__status (objHandle: HCkTask): PWideChar;
begin
  result := TCkTask__status(_map(31, 'CkTask__status'))
    (objHandle);
end;

function CkTask_getStatusInt (objHandle: HCkTask): Integer;
begin
    result := TCkTask_getStatusInt(_map(32, 'CkTask_getStatusInt'))
    (objHandle);
end;

function CkTask_getTaskId (objHandle: HCkTask): Integer;
begin
    result := TCkTask_getTaskId(_map(33, 'CkTask_getTaskId'))
    (objHandle);
end;

function CkTask_getTaskSuccess (objHandle: HCkTask): wordbool;
begin
    result := TCkTask_getTaskSuccess(_map(34, 'CkTask_getTaskSuccess'))
    (objHandle);
end;

procedure CkTask_getUserData (objHandle: HCkTask; outPropVal: HCkString);
begin
  TCkTask_getUserData(_map(35, 'CkTask_getUserData'))
    (objHandle, outPropVal);
end;

procedure CkTask_putUserData (objHandle: HCkTask; newPropVal: PWideChar);
begin
  TCkTask_putUserData(_map(36, 'CkTask_putUserData'))
    (objHandle, newPropVal);
end;

function CkTask__userData (objHandle: HCkTask): PWideChar;
begin
  result := TCkTask__userData(_map(37, 'CkTask__userData'))
    (objHandle);
end;

function CkTask_getVerboseLogging (objHandle: HCkTask): wordbool;
begin
    result := TCkTask_getVerboseLogging(_map(38, 'CkTask_getVerboseLogging'))
    (objHandle);
end;

procedure CkTask_putVerboseLogging (objHandle: HCkTask; newPropVal: wordbool);
begin
  TCkTask_putVerboseLogging(_map(39, 'CkTask_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkTask_getVersion (objHandle: HCkTask; outPropVal: HCkString);
begin
  TCkTask_getVersion(_map(40, 'CkTask_getVersion'))
    (objHandle, outPropVal);
end;

function CkTask__version (objHandle: HCkTask): PWideChar;
begin
  result := TCkTask__version(_map(41, 'CkTask__version'))
    (objHandle);
end;

function CkTask_Cancel (objHandle: HCkTask): wordbool;
begin
  result := TCkTask_Cancel(_map(42, 'CkTask_Cancel'))
    (objHandle);
end;

procedure CkTask_ClearProgressLog (objHandle: HCkTask);
begin
  TCkTask_ClearProgressLog(_map(43, 'CkTask_ClearProgressLog'))
    (objHandle);
end;

function CkTask_CopyResultBytes (objHandle: HCkTask; outData: HCkByteData): wordbool;
begin
  result := TCkTask_CopyResultBytes(_map(44, 'CkTask_CopyResultBytes'))
    (objHandle, outData);
end;

function CkTask_GetResultBool (objHandle: HCkTask): wordbool;
begin
  result := TCkTask_GetResultBool(_map(45, 'CkTask_GetResultBool'))
    (objHandle);
end;

function CkTask_GetResultBytes (objHandle: HCkTask; outData: HCkByteData): wordbool;
begin
  result := TCkTask_GetResultBytes(_map(46, 'CkTask_GetResultBytes'))
    (objHandle, outData);
end;

function CkTask_GetResultInt (objHandle: HCkTask): Integer;
begin
  result := TCkTask_GetResultInt(_map(47, 'CkTask_GetResultInt'))
    (objHandle);
end;

function CkTask_GetResultString (objHandle: HCkTask; outStr: HCkString): wordbool;
begin
  result := TCkTask_GetResultString(_map(48, 'CkTask_GetResultString'))
    (objHandle, outStr);
end;

function CkTask__getResultString (objHandle: HCkTask): PWideChar;
begin
  result := TCkTask__getResultString(_map(49, 'CkTask__getResultString'))
    (objHandle);
end;

function CkTask_ProgressInfoName (objHandle: HCkTask; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkTask_ProgressInfoName(_map(50, 'CkTask_ProgressInfoName'))
    (objHandle, index, outStr);
end;

function CkTask__progressInfoName (objHandle: HCkTask; index: Integer): PWideChar;
begin
  result := TCkTask__progressInfoName(_map(51, 'CkTask__progressInfoName'))
    (objHandle, index);
end;

function CkTask_ProgressInfoValue (objHandle: HCkTask; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkTask_ProgressInfoValue(_map(52, 'CkTask_ProgressInfoValue'))
    (objHandle, index, outStr);
end;

function CkTask__progressInfoValue (objHandle: HCkTask; index: Integer): PWideChar;
begin
  result := TCkTask__progressInfoValue(_map(53, 'CkTask__progressInfoValue'))
    (objHandle, index);
end;

procedure CkTask_RemoveProgressInfo (objHandle: HCkTask; index: Integer);
begin
  TCkTask_RemoveProgressInfo(_map(54, 'CkTask_RemoveProgressInfo'))
    (objHandle, index);
end;

function CkTask_Run (objHandle: HCkTask): wordbool;
begin
  result := TCkTask_Run(_map(55, 'CkTask_Run'))
    (objHandle);
end;

function CkTask_RunSynchronously (objHandle: HCkTask): wordbool;
begin
  result := TCkTask_RunSynchronously(_map(56, 'CkTask_RunSynchronously'))
    (objHandle);
end;

procedure CkTask_SleepMs (objHandle: HCkTask; numMs: Integer);
begin
  TCkTask_SleepMs(_map(57, 'CkTask_SleepMs'))
    (objHandle, numMs);
end;

function CkTask_Wait (objHandle: HCkTask; maxWaitMs: Integer): wordbool;
begin
  result := TCkTask_Wait(_map(58, 'CkTask_Wait'))
    (objHandle, maxWaitMs);
end;

end.
