unit TaskChain;

interface

type

HCkTask = Pointer;
HCkTaskChain = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TTaskChainAbortCheck = function(): Integer; cdecl;
TTaskChainProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TTaskChainPercentDone = function(pctDone: Integer): Integer; cdecl;
TTaskChainTaskCompleted = procedure(task: HCkTask); cdecl;


function CkTaskChain_Create: HCkTaskChain;  stdcall;
procedure CkTaskChain_Dispose(handle: HCkTaskChain); stdcall;

procedure CkTaskChain_SetAbortCheck(objHandle: HCkTaskChain; fn: TTaskChainAbortCheck) stdcall;
procedure CkTaskChain_SetProgressInfo(objHandle: HCkTaskChain; fn: TTaskChainProgressInfo) stdcall;
procedure CkTaskChain_SetPercentDone(objHandle: HCkTaskChain; fn: TTaskChainPercentDone) stdcall;
procedure CkTaskChain_SetTaskCompleted(objHandle: HCkTaskChain; fn: TTaskChainTaskCompleted) stdcall;
procedure CkTaskChain_getDebugLogFilePath(objHandle: HCkTaskChain; outPropVal: HCkString);
procedure CkTaskChain_putDebugLogFilePath(objHandle: HCkTaskChain; newPropVal: PWideChar);
function CkTaskChain__debugLogFilePath(objHandle: HCkTaskChain): PWideChar;
function CkTaskChain_getFinished(objHandle: HCkTaskChain): wordbool;
function CkTaskChain_getHeartbeatMs(objHandle: HCkTaskChain): Integer;
procedure CkTaskChain_putHeartbeatMs(objHandle: HCkTaskChain; newPropVal: Integer);
function CkTaskChain_getInert(objHandle: HCkTaskChain): wordbool;
procedure CkTaskChain_getLastErrorHtml(objHandle: HCkTaskChain; outPropVal: HCkString);
function CkTaskChain__lastErrorHtml(objHandle: HCkTaskChain): PWideChar;
procedure CkTaskChain_getLastErrorText(objHandle: HCkTaskChain; outPropVal: HCkString);
function CkTaskChain__lastErrorText(objHandle: HCkTaskChain): PWideChar;
procedure CkTaskChain_getLastErrorXml(objHandle: HCkTaskChain; outPropVal: HCkString);
function CkTaskChain__lastErrorXml(objHandle: HCkTaskChain): PWideChar;
function CkTaskChain_getLastMethodSuccess(objHandle: HCkTaskChain): wordbool;
procedure CkTaskChain_putLastMethodSuccess(objHandle: HCkTaskChain; newPropVal: wordbool);
function CkTaskChain_getLive(objHandle: HCkTaskChain): wordbool;
function CkTaskChain_getNumTasks(objHandle: HCkTaskChain): Integer;
procedure CkTaskChain_getStatus(objHandle: HCkTaskChain; outPropVal: HCkString);
function CkTaskChain__status(objHandle: HCkTaskChain): PWideChar;
function CkTaskChain_getStatusInt(objHandle: HCkTaskChain): Integer;
function CkTaskChain_getStopOnFailedTask(objHandle: HCkTaskChain): wordbool;
procedure CkTaskChain_putStopOnFailedTask(objHandle: HCkTaskChain; newPropVal: wordbool);
function CkTaskChain_getVerboseLogging(objHandle: HCkTaskChain): wordbool;
procedure CkTaskChain_putVerboseLogging(objHandle: HCkTaskChain; newPropVal: wordbool);
procedure CkTaskChain_getVersion(objHandle: HCkTaskChain; outPropVal: HCkString);
function CkTaskChain__version(objHandle: HCkTaskChain): PWideChar;
function CkTaskChain_Append(objHandle: HCkTaskChain; task: HCkTask): wordbool;
function CkTaskChain_Cancel(objHandle: HCkTaskChain): wordbool;
function CkTaskChain_GetTask(objHandle: HCkTaskChain; index: Integer): HCkTask;
function CkTaskChain_Run(objHandle: HCkTaskChain): wordbool;
function CkTaskChain_RunSynchronously(objHandle: HCkTaskChain): wordbool;
procedure CkTaskChain_SleepMs(objHandle: HCkTaskChain; numMs: Integer);
function CkTaskChain_Wait(objHandle: HCkTaskChain; maxWaitMs: Integer): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkTaskChain_Create = function : HCkTaskChain; stdcall;
  TCkTaskChain_Dispose = procedure (handle: HCkTaskChain); stdcall;
  TCkTaskChain_SetAbortCheck = procedure (objHandle: HCkTaskChain; fn: TTaskChainAbortCheck); stdcall;
  TCkTaskChain_SetProgressInfo = procedure (objHandle: HCkTaskChain; fn: TTaskChainProgressInfo); stdcall;
  TCkTaskChain_SetPercentDone = procedure (objHandle: HCkTaskChain; fn: TTaskChainPercentDone); stdcall;
  TCkTaskChain_SetTaskCompleted = procedure (objHandle: HCkTaskChain; fn: TTaskChainTaskCompleted); stdcall;
  TCkTaskChain_getDebugLogFilePath = procedure (objHandle: HCkTaskChain; outPropVal: HCkString); stdcall;
  TCkTaskChain_putDebugLogFilePath = procedure (objHandle: HCkTaskChain; newPropVal: PWideChar); stdcall;
  TCkTaskChain__debugLogFilePath = function (objHandle: HCkTaskChain): PWideChar; stdcall;
  TCkTaskChain_getFinished = function (objHandle: HCkTaskChain): wordbool; stdcall;
  TCkTaskChain_getHeartbeatMs = function (objHandle: HCkTaskChain): Integer; stdcall;
  TCkTaskChain_putHeartbeatMs = procedure (objHandle: HCkTaskChain; newPropVal: Integer); stdcall;
  TCkTaskChain_getInert = function (objHandle: HCkTaskChain): wordbool; stdcall;
  TCkTaskChain_getLastErrorHtml = procedure (objHandle: HCkTaskChain; outPropVal: HCkString); stdcall;
  TCkTaskChain__lastErrorHtml = function (objHandle: HCkTaskChain): PWideChar; stdcall;
  TCkTaskChain_getLastErrorText = procedure (objHandle: HCkTaskChain; outPropVal: HCkString); stdcall;
  TCkTaskChain__lastErrorText = function (objHandle: HCkTaskChain): PWideChar; stdcall;
  TCkTaskChain_getLastErrorXml = procedure (objHandle: HCkTaskChain; outPropVal: HCkString); stdcall;
  TCkTaskChain__lastErrorXml = function (objHandle: HCkTaskChain): PWideChar; stdcall;
  TCkTaskChain_getLastMethodSuccess = function (objHandle: HCkTaskChain): wordbool; stdcall;
  TCkTaskChain_putLastMethodSuccess = procedure (objHandle: HCkTaskChain; newPropVal: wordbool); stdcall;
  TCkTaskChain_getLive = function (objHandle: HCkTaskChain): wordbool; stdcall;
  TCkTaskChain_getNumTasks = function (objHandle: HCkTaskChain): Integer; stdcall;
  TCkTaskChain_getStatus = procedure (objHandle: HCkTaskChain; outPropVal: HCkString); stdcall;
  TCkTaskChain__status = function (objHandle: HCkTaskChain): PWideChar; stdcall;
  TCkTaskChain_getStatusInt = function (objHandle: HCkTaskChain): Integer; stdcall;
  TCkTaskChain_getStopOnFailedTask = function (objHandle: HCkTaskChain): wordbool; stdcall;
  TCkTaskChain_putStopOnFailedTask = procedure (objHandle: HCkTaskChain; newPropVal: wordbool); stdcall;
  TCkTaskChain_getVerboseLogging = function (objHandle: HCkTaskChain): wordbool; stdcall;
  TCkTaskChain_putVerboseLogging = procedure (objHandle: HCkTaskChain; newPropVal: wordbool); stdcall;
  TCkTaskChain_getVersion = procedure (objHandle: HCkTaskChain; outPropVal: HCkString); stdcall;
  TCkTaskChain__version = function (objHandle: HCkTaskChain): PWideChar; stdcall;
  TCkTaskChain_Append = function (objHandle: HCkTaskChain; task: HCkTask): wordbool; stdcall;
  TCkTaskChain_Cancel = function (objHandle: HCkTaskChain): wordbool; stdcall;
  TCkTaskChain_GetTask = function (objHandle: HCkTaskChain; index: Integer): HCkTask; stdcall;
  TCkTaskChain_Run = function (objHandle: HCkTaskChain): wordbool; stdcall;
  TCkTaskChain_RunSynchronously = function (objHandle: HCkTaskChain): wordbool; stdcall;
  TCkTaskChain_SleepMs = procedure (objHandle: HCkTaskChain; numMs: Integer); stdcall;
  TCkTaskChain_Wait = function (objHandle: HCkTaskChain; maxWaitMs: Integer): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..38] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkTaskChain_Create : HCkTaskChain;
begin
  result := TCkTaskChain_Create(_map(0, 'CkTaskChain_Create'));
end;

procedure CkTaskChain_Dispose (handle: HCkTaskChain);
begin
  TCkTaskChain_Dispose(_map(1, 'CkTaskChain_Dispose'))
    (handle);
end;


procedure CkTaskChain_SetAbortCheck (objHandle: HCkTaskChain; fn: TTaskChainAbortCheck);
begin
    TCkTaskChain_SetAbortCheck(_map(2, 'CkTaskChain_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkTaskChain_SetProgressInfo (objHandle: HCkTaskChain; fn: TTaskChainProgressInfo);
begin
    TCkTaskChain_SetProgressInfo(_map(3, 'CkTaskChain_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkTaskChain_SetPercentDone (objHandle: HCkTaskChain; fn: TTaskChainPercentDone);
begin
    TCkTaskChain_SetPercentDone(_map(4, 'CkTaskChain_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkTaskChain_SetTaskCompleted (objHandle: HCkTaskChain; fn: TTaskChainTaskCompleted);
begin
    TCkTaskChain_SetTaskCompleted(_map(5, 'CkTaskChain_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkTaskChain_getDebugLogFilePath (objHandle: HCkTaskChain; outPropVal: HCkString);
begin
  TCkTaskChain_getDebugLogFilePath(_map(6, 'CkTaskChain_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkTaskChain_putDebugLogFilePath (objHandle: HCkTaskChain; newPropVal: PWideChar);
begin
  TCkTaskChain_putDebugLogFilePath(_map(7, 'CkTaskChain_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkTaskChain__debugLogFilePath (objHandle: HCkTaskChain): PWideChar;
begin
  result := TCkTaskChain__debugLogFilePath(_map(8, 'CkTaskChain__debugLogFilePath'))
    (objHandle);
end;

function CkTaskChain_getFinished (objHandle: HCkTaskChain): wordbool;
begin
    result := TCkTaskChain_getFinished(_map(9, 'CkTaskChain_getFinished'))
    (objHandle);
end;

function CkTaskChain_getHeartbeatMs (objHandle: HCkTaskChain): Integer;
begin
    result := TCkTaskChain_getHeartbeatMs(_map(10, 'CkTaskChain_getHeartbeatMs'))
    (objHandle);
end;

procedure CkTaskChain_putHeartbeatMs (objHandle: HCkTaskChain; newPropVal: Integer);
begin
  TCkTaskChain_putHeartbeatMs(_map(11, 'CkTaskChain_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

function CkTaskChain_getInert (objHandle: HCkTaskChain): wordbool;
begin
    result := TCkTaskChain_getInert(_map(12, 'CkTaskChain_getInert'))
    (objHandle);
end;

procedure CkTaskChain_getLastErrorHtml (objHandle: HCkTaskChain; outPropVal: HCkString);
begin
  TCkTaskChain_getLastErrorHtml(_map(13, 'CkTaskChain_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkTaskChain__lastErrorHtml (objHandle: HCkTaskChain): PWideChar;
begin
  result := TCkTaskChain__lastErrorHtml(_map(14, 'CkTaskChain__lastErrorHtml'))
    (objHandle);
end;

procedure CkTaskChain_getLastErrorText (objHandle: HCkTaskChain; outPropVal: HCkString);
begin
  TCkTaskChain_getLastErrorText(_map(15, 'CkTaskChain_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkTaskChain__lastErrorText (objHandle: HCkTaskChain): PWideChar;
begin
  result := TCkTaskChain__lastErrorText(_map(16, 'CkTaskChain__lastErrorText'))
    (objHandle);
end;

procedure CkTaskChain_getLastErrorXml (objHandle: HCkTaskChain; outPropVal: HCkString);
begin
  TCkTaskChain_getLastErrorXml(_map(17, 'CkTaskChain_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkTaskChain__lastErrorXml (objHandle: HCkTaskChain): PWideChar;
begin
  result := TCkTaskChain__lastErrorXml(_map(18, 'CkTaskChain__lastErrorXml'))
    (objHandle);
end;

function CkTaskChain_getLastMethodSuccess (objHandle: HCkTaskChain): wordbool;
begin
    result := TCkTaskChain_getLastMethodSuccess(_map(19, 'CkTaskChain_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkTaskChain_putLastMethodSuccess (objHandle: HCkTaskChain; newPropVal: wordbool);
begin
  TCkTaskChain_putLastMethodSuccess(_map(20, 'CkTaskChain_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkTaskChain_getLive (objHandle: HCkTaskChain): wordbool;
begin
    result := TCkTaskChain_getLive(_map(21, 'CkTaskChain_getLive'))
    (objHandle);
end;

function CkTaskChain_getNumTasks (objHandle: HCkTaskChain): Integer;
begin
    result := TCkTaskChain_getNumTasks(_map(22, 'CkTaskChain_getNumTasks'))
    (objHandle);
end;

procedure CkTaskChain_getStatus (objHandle: HCkTaskChain; outPropVal: HCkString);
begin
  TCkTaskChain_getStatus(_map(23, 'CkTaskChain_getStatus'))
    (objHandle, outPropVal);
end;

function CkTaskChain__status (objHandle: HCkTaskChain): PWideChar;
begin
  result := TCkTaskChain__status(_map(24, 'CkTaskChain__status'))
    (objHandle);
end;

function CkTaskChain_getStatusInt (objHandle: HCkTaskChain): Integer;
begin
    result := TCkTaskChain_getStatusInt(_map(25, 'CkTaskChain_getStatusInt'))
    (objHandle);
end;

function CkTaskChain_getStopOnFailedTask (objHandle: HCkTaskChain): wordbool;
begin
    result := TCkTaskChain_getStopOnFailedTask(_map(26, 'CkTaskChain_getStopOnFailedTask'))
    (objHandle);
end;

procedure CkTaskChain_putStopOnFailedTask (objHandle: HCkTaskChain; newPropVal: wordbool);
begin
  TCkTaskChain_putStopOnFailedTask(_map(27, 'CkTaskChain_putStopOnFailedTask'))
    (objHandle, newPropVal);
end;

function CkTaskChain_getVerboseLogging (objHandle: HCkTaskChain): wordbool;
begin
    result := TCkTaskChain_getVerboseLogging(_map(28, 'CkTaskChain_getVerboseLogging'))
    (objHandle);
end;

procedure CkTaskChain_putVerboseLogging (objHandle: HCkTaskChain; newPropVal: wordbool);
begin
  TCkTaskChain_putVerboseLogging(_map(29, 'CkTaskChain_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkTaskChain_getVersion (objHandle: HCkTaskChain; outPropVal: HCkString);
begin
  TCkTaskChain_getVersion(_map(30, 'CkTaskChain_getVersion'))
    (objHandle, outPropVal);
end;

function CkTaskChain__version (objHandle: HCkTaskChain): PWideChar;
begin
  result := TCkTaskChain__version(_map(31, 'CkTaskChain__version'))
    (objHandle);
end;

function CkTaskChain_Append (objHandle: HCkTaskChain; task: HCkTask): wordbool;
begin
  result := TCkTaskChain_Append(_map(32, 'CkTaskChain_Append'))
    (objHandle, task);
end;

function CkTaskChain_Cancel (objHandle: HCkTaskChain): wordbool;
begin
  result := TCkTaskChain_Cancel(_map(33, 'CkTaskChain_Cancel'))
    (objHandle);
end;

function CkTaskChain_GetTask (objHandle: HCkTaskChain; index: Integer): HCkTask;
begin
  result := TCkTaskChain_GetTask(_map(34, 'CkTaskChain_GetTask'))
    (objHandle, index);
end;

function CkTaskChain_Run (objHandle: HCkTaskChain): wordbool;
begin
  result := TCkTaskChain_Run(_map(35, 'CkTaskChain_Run'))
    (objHandle);
end;

function CkTaskChain_RunSynchronously (objHandle: HCkTaskChain): wordbool;
begin
  result := TCkTaskChain_RunSynchronously(_map(36, 'CkTaskChain_RunSynchronously'))
    (objHandle);
end;

procedure CkTaskChain_SleepMs (objHandle: HCkTaskChain; numMs: Integer);
begin
  TCkTaskChain_SleepMs(_map(37, 'CkTaskChain_SleepMs'))
    (objHandle, numMs);
end;

function CkTaskChain_Wait (objHandle: HCkTaskChain; maxWaitMs: Integer): wordbool;
begin
  result := TCkTaskChain_Wait(_map(38, 'CkTaskChain_Wait'))
    (objHandle, maxWaitMs);
end;

end.
