unit TrustedRoots;

interface

type

HCkTrustedRoots = Pointer;
HCkCert = Pointer;
HCkTask = Pointer;
HCkJavaKeyStore = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TTrustedRootsAbortCheck = function(): Integer; cdecl;
TTrustedRootsProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TTrustedRootsPercentDone = function(pctDone: Integer): Integer; cdecl;
TTrustedRootsTaskCompleted = procedure(task: HCkTask); cdecl;


function CkTrustedRoots_Create: HCkTrustedRoots;  stdcall;
procedure CkTrustedRoots_Dispose(handle: HCkTrustedRoots); stdcall;

procedure CkTrustedRoots_SetAbortCheck(objHandle: HCkTrustedRoots; fn: TTrustedRootsAbortCheck) stdcall;
procedure CkTrustedRoots_SetProgressInfo(objHandle: HCkTrustedRoots; fn: TTrustedRootsProgressInfo) stdcall;
procedure CkTrustedRoots_SetPercentDone(objHandle: HCkTrustedRoots; fn: TTrustedRootsPercentDone) stdcall;
procedure CkTrustedRoots_SetTaskCompleted(objHandle: HCkTrustedRoots; fn: TTrustedRootsTaskCompleted) stdcall;
procedure CkTrustedRoots_getDebugLogFilePath(objHandle: HCkTrustedRoots; outPropVal: HCkString);
procedure CkTrustedRoots_putDebugLogFilePath(objHandle: HCkTrustedRoots; newPropVal: PWideChar);
function CkTrustedRoots__debugLogFilePath(objHandle: HCkTrustedRoots): PWideChar;
procedure CkTrustedRoots_getLastErrorHtml(objHandle: HCkTrustedRoots; outPropVal: HCkString);
function CkTrustedRoots__lastErrorHtml(objHandle: HCkTrustedRoots): PWideChar;
procedure CkTrustedRoots_getLastErrorText(objHandle: HCkTrustedRoots; outPropVal: HCkString);
function CkTrustedRoots__lastErrorText(objHandle: HCkTrustedRoots): PWideChar;
procedure CkTrustedRoots_getLastErrorXml(objHandle: HCkTrustedRoots; outPropVal: HCkString);
function CkTrustedRoots__lastErrorXml(objHandle: HCkTrustedRoots): PWideChar;
function CkTrustedRoots_getLastMethodSuccess(objHandle: HCkTrustedRoots): wordbool;
procedure CkTrustedRoots_putLastMethodSuccess(objHandle: HCkTrustedRoots; newPropVal: wordbool);
function CkTrustedRoots_getNumCerts(objHandle: HCkTrustedRoots): Integer;
function CkTrustedRoots_getRejectSelfSignedCerts(objHandle: HCkTrustedRoots): wordbool;
procedure CkTrustedRoots_putRejectSelfSignedCerts(objHandle: HCkTrustedRoots; newPropVal: wordbool);
function CkTrustedRoots_getTrustSystemCaRoots(objHandle: HCkTrustedRoots): wordbool;
procedure CkTrustedRoots_putTrustSystemCaRoots(objHandle: HCkTrustedRoots; newPropVal: wordbool);
function CkTrustedRoots_getVerboseLogging(objHandle: HCkTrustedRoots): wordbool;
procedure CkTrustedRoots_putVerboseLogging(objHandle: HCkTrustedRoots; newPropVal: wordbool);
procedure CkTrustedRoots_getVersion(objHandle: HCkTrustedRoots; outPropVal: HCkString);
function CkTrustedRoots__version(objHandle: HCkTrustedRoots): PWideChar;
function CkTrustedRoots_Activate(objHandle: HCkTrustedRoots): wordbool;
function CkTrustedRoots_AddCert(objHandle: HCkTrustedRoots; cert: HCkCert): wordbool;
function CkTrustedRoots_AddJavaKeyStore(objHandle: HCkTrustedRoots; keystore: HCkJavaKeyStore): wordbool;
function CkTrustedRoots_AddJavaKeyStoreAsync(objHandle: HCkTrustedRoots; keystore: HCkJavaKeyStore): HCkTask;
function CkTrustedRoots_CertAt(objHandle: HCkTrustedRoots; index: Integer; cert: HCkCert): wordbool;
function CkTrustedRoots_Deactivate(objHandle: HCkTrustedRoots): wordbool;
function CkTrustedRoots_GetCert(objHandle: HCkTrustedRoots; index: Integer): HCkCert;
function CkTrustedRoots_LoadCaCertsPem(objHandle: HCkTrustedRoots; path: PWideChar): wordbool;
function CkTrustedRoots_LoadCaCertsPemAsync(objHandle: HCkTrustedRoots; path: PWideChar): HCkTask;
function CkTrustedRoots_LoadTaskCaller(objHandle: HCkTrustedRoots; task: HCkTask): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkTrustedRoots_Create = function : HCkTrustedRoots; stdcall;
  TCkTrustedRoots_Dispose = procedure (handle: HCkTrustedRoots); stdcall;
  TCkTrustedRoots_SetAbortCheck = procedure (objHandle: HCkTrustedRoots; fn: TTrustedRootsAbortCheck); stdcall;
  TCkTrustedRoots_SetProgressInfo = procedure (objHandle: HCkTrustedRoots; fn: TTrustedRootsProgressInfo); stdcall;
  TCkTrustedRoots_SetPercentDone = procedure (objHandle: HCkTrustedRoots; fn: TTrustedRootsPercentDone); stdcall;
  TCkTrustedRoots_SetTaskCompleted = procedure (objHandle: HCkTrustedRoots; fn: TTrustedRootsTaskCompleted); stdcall;
  TCkTrustedRoots_getDebugLogFilePath = procedure (objHandle: HCkTrustedRoots; outPropVal: HCkString); stdcall;
  TCkTrustedRoots_putDebugLogFilePath = procedure (objHandle: HCkTrustedRoots; newPropVal: PWideChar); stdcall;
  TCkTrustedRoots__debugLogFilePath = function (objHandle: HCkTrustedRoots): PWideChar; stdcall;
  TCkTrustedRoots_getLastErrorHtml = procedure (objHandle: HCkTrustedRoots; outPropVal: HCkString); stdcall;
  TCkTrustedRoots__lastErrorHtml = function (objHandle: HCkTrustedRoots): PWideChar; stdcall;
  TCkTrustedRoots_getLastErrorText = procedure (objHandle: HCkTrustedRoots; outPropVal: HCkString); stdcall;
  TCkTrustedRoots__lastErrorText = function (objHandle: HCkTrustedRoots): PWideChar; stdcall;
  TCkTrustedRoots_getLastErrorXml = procedure (objHandle: HCkTrustedRoots; outPropVal: HCkString); stdcall;
  TCkTrustedRoots__lastErrorXml = function (objHandle: HCkTrustedRoots): PWideChar; stdcall;
  TCkTrustedRoots_getLastMethodSuccess = function (objHandle: HCkTrustedRoots): wordbool; stdcall;
  TCkTrustedRoots_putLastMethodSuccess = procedure (objHandle: HCkTrustedRoots; newPropVal: wordbool); stdcall;
  TCkTrustedRoots_getNumCerts = function (objHandle: HCkTrustedRoots): Integer; stdcall;
  TCkTrustedRoots_getRejectSelfSignedCerts = function (objHandle: HCkTrustedRoots): wordbool; stdcall;
  TCkTrustedRoots_putRejectSelfSignedCerts = procedure (objHandle: HCkTrustedRoots; newPropVal: wordbool); stdcall;
  TCkTrustedRoots_getTrustSystemCaRoots = function (objHandle: HCkTrustedRoots): wordbool; stdcall;
  TCkTrustedRoots_putTrustSystemCaRoots = procedure (objHandle: HCkTrustedRoots; newPropVal: wordbool); stdcall;
  TCkTrustedRoots_getVerboseLogging = function (objHandle: HCkTrustedRoots): wordbool; stdcall;
  TCkTrustedRoots_putVerboseLogging = procedure (objHandle: HCkTrustedRoots; newPropVal: wordbool); stdcall;
  TCkTrustedRoots_getVersion = procedure (objHandle: HCkTrustedRoots; outPropVal: HCkString); stdcall;
  TCkTrustedRoots__version = function (objHandle: HCkTrustedRoots): PWideChar; stdcall;
  TCkTrustedRoots_Activate = function (objHandle: HCkTrustedRoots): wordbool; stdcall;
  TCkTrustedRoots_AddCert = function (objHandle: HCkTrustedRoots; cert: HCkCert): wordbool; stdcall;
  TCkTrustedRoots_AddJavaKeyStore = function (objHandle: HCkTrustedRoots; keystore: HCkJavaKeyStore): wordbool; stdcall;
  TCkTrustedRoots_AddJavaKeyStoreAsync = function (objHandle: HCkTrustedRoots; keystore: HCkJavaKeyStore): HCkTask; stdcall;
  TCkTrustedRoots_CertAt = function (objHandle: HCkTrustedRoots; index: Integer; cert: HCkCert): wordbool; stdcall;
  TCkTrustedRoots_Deactivate = function (objHandle: HCkTrustedRoots): wordbool; stdcall;
  TCkTrustedRoots_GetCert = function (objHandle: HCkTrustedRoots; index: Integer): HCkCert; stdcall;
  TCkTrustedRoots_LoadCaCertsPem = function (objHandle: HCkTrustedRoots; path: PWideChar): wordbool; stdcall;
  TCkTrustedRoots_LoadCaCertsPemAsync = function (objHandle: HCkTrustedRoots; path: PWideChar): HCkTask; stdcall;
  TCkTrustedRoots_LoadTaskCaller = function (objHandle: HCkTrustedRoots; task: HCkTask): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..35] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkTrustedRoots_Create : HCkTrustedRoots;
begin
  result := TCkTrustedRoots_Create(_map(0, 'CkTrustedRoots_Create'));
end;

procedure CkTrustedRoots_Dispose (handle: HCkTrustedRoots);
begin
  TCkTrustedRoots_Dispose(_map(1, 'CkTrustedRoots_Dispose'))
    (handle);
end;


procedure CkTrustedRoots_SetAbortCheck (objHandle: HCkTrustedRoots; fn: TTrustedRootsAbortCheck);
begin
    TCkTrustedRoots_SetAbortCheck(_map(2, 'CkTrustedRoots_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkTrustedRoots_SetProgressInfo (objHandle: HCkTrustedRoots; fn: TTrustedRootsProgressInfo);
begin
    TCkTrustedRoots_SetProgressInfo(_map(3, 'CkTrustedRoots_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkTrustedRoots_SetPercentDone (objHandle: HCkTrustedRoots; fn: TTrustedRootsPercentDone);
begin
    TCkTrustedRoots_SetPercentDone(_map(4, 'CkTrustedRoots_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkTrustedRoots_SetTaskCompleted (objHandle: HCkTrustedRoots; fn: TTrustedRootsTaskCompleted);
begin
    TCkTrustedRoots_SetTaskCompleted(_map(5, 'CkTrustedRoots_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkTrustedRoots_getDebugLogFilePath (objHandle: HCkTrustedRoots; outPropVal: HCkString);
begin
  TCkTrustedRoots_getDebugLogFilePath(_map(6, 'CkTrustedRoots_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkTrustedRoots_putDebugLogFilePath (objHandle: HCkTrustedRoots; newPropVal: PWideChar);
begin
  TCkTrustedRoots_putDebugLogFilePath(_map(7, 'CkTrustedRoots_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkTrustedRoots__debugLogFilePath (objHandle: HCkTrustedRoots): PWideChar;
begin
  result := TCkTrustedRoots__debugLogFilePath(_map(8, 'CkTrustedRoots__debugLogFilePath'))
    (objHandle);
end;

procedure CkTrustedRoots_getLastErrorHtml (objHandle: HCkTrustedRoots; outPropVal: HCkString);
begin
  TCkTrustedRoots_getLastErrorHtml(_map(9, 'CkTrustedRoots_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkTrustedRoots__lastErrorHtml (objHandle: HCkTrustedRoots): PWideChar;
begin
  result := TCkTrustedRoots__lastErrorHtml(_map(10, 'CkTrustedRoots__lastErrorHtml'))
    (objHandle);
end;

procedure CkTrustedRoots_getLastErrorText (objHandle: HCkTrustedRoots; outPropVal: HCkString);
begin
  TCkTrustedRoots_getLastErrorText(_map(11, 'CkTrustedRoots_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkTrustedRoots__lastErrorText (objHandle: HCkTrustedRoots): PWideChar;
begin
  result := TCkTrustedRoots__lastErrorText(_map(12, 'CkTrustedRoots__lastErrorText'))
    (objHandle);
end;

procedure CkTrustedRoots_getLastErrorXml (objHandle: HCkTrustedRoots; outPropVal: HCkString);
begin
  TCkTrustedRoots_getLastErrorXml(_map(13, 'CkTrustedRoots_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkTrustedRoots__lastErrorXml (objHandle: HCkTrustedRoots): PWideChar;
begin
  result := TCkTrustedRoots__lastErrorXml(_map(14, 'CkTrustedRoots__lastErrorXml'))
    (objHandle);
end;

function CkTrustedRoots_getLastMethodSuccess (objHandle: HCkTrustedRoots): wordbool;
begin
    result := TCkTrustedRoots_getLastMethodSuccess(_map(15, 'CkTrustedRoots_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkTrustedRoots_putLastMethodSuccess (objHandle: HCkTrustedRoots; newPropVal: wordbool);
begin
  TCkTrustedRoots_putLastMethodSuccess(_map(16, 'CkTrustedRoots_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkTrustedRoots_getNumCerts (objHandle: HCkTrustedRoots): Integer;
begin
    result := TCkTrustedRoots_getNumCerts(_map(17, 'CkTrustedRoots_getNumCerts'))
    (objHandle);
end;

function CkTrustedRoots_getRejectSelfSignedCerts (objHandle: HCkTrustedRoots): wordbool;
begin
    result := TCkTrustedRoots_getRejectSelfSignedCerts(_map(18, 'CkTrustedRoots_getRejectSelfSignedCerts'))
    (objHandle);
end;

procedure CkTrustedRoots_putRejectSelfSignedCerts (objHandle: HCkTrustedRoots; newPropVal: wordbool);
begin
  TCkTrustedRoots_putRejectSelfSignedCerts(_map(19, 'CkTrustedRoots_putRejectSelfSignedCerts'))
    (objHandle, newPropVal);
end;

function CkTrustedRoots_getTrustSystemCaRoots (objHandle: HCkTrustedRoots): wordbool;
begin
    result := TCkTrustedRoots_getTrustSystemCaRoots(_map(20, 'CkTrustedRoots_getTrustSystemCaRoots'))
    (objHandle);
end;

procedure CkTrustedRoots_putTrustSystemCaRoots (objHandle: HCkTrustedRoots; newPropVal: wordbool);
begin
  TCkTrustedRoots_putTrustSystemCaRoots(_map(21, 'CkTrustedRoots_putTrustSystemCaRoots'))
    (objHandle, newPropVal);
end;

function CkTrustedRoots_getVerboseLogging (objHandle: HCkTrustedRoots): wordbool;
begin
    result := TCkTrustedRoots_getVerboseLogging(_map(22, 'CkTrustedRoots_getVerboseLogging'))
    (objHandle);
end;

procedure CkTrustedRoots_putVerboseLogging (objHandle: HCkTrustedRoots; newPropVal: wordbool);
begin
  TCkTrustedRoots_putVerboseLogging(_map(23, 'CkTrustedRoots_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkTrustedRoots_getVersion (objHandle: HCkTrustedRoots; outPropVal: HCkString);
begin
  TCkTrustedRoots_getVersion(_map(24, 'CkTrustedRoots_getVersion'))
    (objHandle, outPropVal);
end;

function CkTrustedRoots__version (objHandle: HCkTrustedRoots): PWideChar;
begin
  result := TCkTrustedRoots__version(_map(25, 'CkTrustedRoots__version'))
    (objHandle);
end;

function CkTrustedRoots_Activate (objHandle: HCkTrustedRoots): wordbool;
begin
  result := TCkTrustedRoots_Activate(_map(26, 'CkTrustedRoots_Activate'))
    (objHandle);
end;

function CkTrustedRoots_AddCert (objHandle: HCkTrustedRoots; cert: HCkCert): wordbool;
begin
  result := TCkTrustedRoots_AddCert(_map(27, 'CkTrustedRoots_AddCert'))
    (objHandle, cert);
end;

function CkTrustedRoots_AddJavaKeyStore (objHandle: HCkTrustedRoots; keystore: HCkJavaKeyStore): wordbool;
begin
  result := TCkTrustedRoots_AddJavaKeyStore(_map(28, 'CkTrustedRoots_AddJavaKeyStore'))
    (objHandle, keystore);
end;

function CkTrustedRoots_AddJavaKeyStoreAsync (objHandle: HCkTrustedRoots; keystore: HCkJavaKeyStore): HCkTask;
begin
  result := TCkTrustedRoots_AddJavaKeyStoreAsync(_map(29, 'CkTrustedRoots_AddJavaKeyStoreAsync'))
    (objHandle, keystore);
end;

function CkTrustedRoots_CertAt (objHandle: HCkTrustedRoots; index: Integer; cert: HCkCert): wordbool;
begin
  result := TCkTrustedRoots_CertAt(_map(30, 'CkTrustedRoots_CertAt'))
    (objHandle, index, cert);
end;

function CkTrustedRoots_Deactivate (objHandle: HCkTrustedRoots): wordbool;
begin
  result := TCkTrustedRoots_Deactivate(_map(31, 'CkTrustedRoots_Deactivate'))
    (objHandle);
end;

function CkTrustedRoots_GetCert (objHandle: HCkTrustedRoots; index: Integer): HCkCert;
begin
  result := TCkTrustedRoots_GetCert(_map(32, 'CkTrustedRoots_GetCert'))
    (objHandle, index);
end;

function CkTrustedRoots_LoadCaCertsPem (objHandle: HCkTrustedRoots; path: PWideChar): wordbool;
begin
  result := TCkTrustedRoots_LoadCaCertsPem(_map(33, 'CkTrustedRoots_LoadCaCertsPem'))
    (objHandle, path);
end;

function CkTrustedRoots_LoadCaCertsPemAsync (objHandle: HCkTrustedRoots; path: PWideChar): HCkTask;
begin
  result := TCkTrustedRoots_LoadCaCertsPemAsync(_map(34, 'CkTrustedRoots_LoadCaCertsPemAsync'))
    (objHandle, path);
end;

function CkTrustedRoots_LoadTaskCaller (objHandle: HCkTrustedRoots; task: HCkTask): wordbool;
begin
  result := TCkTrustedRoots_LoadTaskCaller(_map(35, 'CkTrustedRoots_LoadTaskCaller'))
    (objHandle, task);
end;

end.
