unit Upload;

interface

type

HCkUpload = Pointer;
HCkTask = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TUploadAbortCheck = function(): Integer; cdecl;
TUploadProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TUploadPercentDone = function(pctDone: Integer): Integer; cdecl;
TUploadTaskCompleted = procedure(task: HCkTask); cdecl;


function CkUpload_Create: HCkUpload;  stdcall;
procedure CkUpload_Dispose(handle: HCkUpload); stdcall;

procedure CkUpload_SetAbortCheck(objHandle: HCkUpload; fn: TUploadAbortCheck) stdcall;
procedure CkUpload_SetProgressInfo(objHandle: HCkUpload; fn: TUploadProgressInfo) stdcall;
procedure CkUpload_SetPercentDone(objHandle: HCkUpload; fn: TUploadPercentDone) stdcall;
procedure CkUpload_SetTaskCompleted(objHandle: HCkUpload; fn: TUploadTaskCompleted) stdcall;
function CkUpload_getAbortCurrent(objHandle: HCkUpload): wordbool;
procedure CkUpload_putAbortCurrent(objHandle: HCkUpload; newPropVal: wordbool);
function CkUpload_getBandwidthThrottleUp(objHandle: HCkUpload): Integer;
procedure CkUpload_putBandwidthThrottleUp(objHandle: HCkUpload; newPropVal: Integer);
function CkUpload_getChunkSize(objHandle: HCkUpload): Integer;
procedure CkUpload_putChunkSize(objHandle: HCkUpload; newPropVal: Integer);
procedure CkUpload_getClientIpAddress(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putClientIpAddress(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__clientIpAddress(objHandle: HCkUpload): PWideChar;
procedure CkUpload_getCurrentFilename(objHandle: HCkUpload; outPropVal: HCkString);
function CkUpload__currentFilename(objHandle: HCkUpload): PWideChar;
procedure CkUpload_getDebugLogFilePath(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putDebugLogFilePath(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__debugLogFilePath(objHandle: HCkUpload): PWideChar;
function CkUpload_getExpect100Continue(objHandle: HCkUpload): wordbool;
procedure CkUpload_putExpect100Continue(objHandle: HCkUpload; newPropVal: wordbool);
function CkUpload_getHeartbeatMs(objHandle: HCkUpload): Integer;
procedure CkUpload_putHeartbeatMs(objHandle: HCkUpload; newPropVal: Integer);
procedure CkUpload_getHostname(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putHostname(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__hostname(objHandle: HCkUpload): PWideChar;
function CkUpload_getIdleTimeoutMs(objHandle: HCkUpload): Integer;
procedure CkUpload_putIdleTimeoutMs(objHandle: HCkUpload; newPropVal: Integer);
procedure CkUpload_getLastErrorHtml(objHandle: HCkUpload; outPropVal: HCkString);
function CkUpload__lastErrorHtml(objHandle: HCkUpload): PWideChar;
procedure CkUpload_getLastErrorText(objHandle: HCkUpload; outPropVal: HCkString);
function CkUpload__lastErrorText(objHandle: HCkUpload): PWideChar;
procedure CkUpload_getLastErrorXml(objHandle: HCkUpload; outPropVal: HCkString);
function CkUpload__lastErrorXml(objHandle: HCkUpload): PWideChar;
function CkUpload_getLastMethodSuccess(objHandle: HCkUpload): wordbool;
procedure CkUpload_putLastMethodSuccess(objHandle: HCkUpload; newPropVal: wordbool);
procedure CkUpload_getLogin(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putLogin(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__login(objHandle: HCkUpload): PWideChar;
function CkUpload_getNumBytesSent(objHandle: HCkUpload): LongWord;
procedure CkUpload_getPassword(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putPassword(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__password(objHandle: HCkUpload): PWideChar;
procedure CkUpload_getPath(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putPath(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__path(objHandle: HCkUpload): PWideChar;
function CkUpload_getPercentDoneScale(objHandle: HCkUpload): Integer;
procedure CkUpload_putPercentDoneScale(objHandle: HCkUpload; newPropVal: Integer);
function CkUpload_getPercentUploaded(objHandle: HCkUpload): LongWord;
function CkUpload_getPort(objHandle: HCkUpload): Integer;
procedure CkUpload_putPort(objHandle: HCkUpload; newPropVal: Integer);
function CkUpload_getPreferIpv6(objHandle: HCkUpload): wordbool;
procedure CkUpload_putPreferIpv6(objHandle: HCkUpload; newPropVal: wordbool);
procedure CkUpload_getProxyDomain(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putProxyDomain(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__proxyDomain(objHandle: HCkUpload): PWideChar;
procedure CkUpload_getProxyLogin(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putProxyLogin(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__proxyLogin(objHandle: HCkUpload): PWideChar;
procedure CkUpload_getProxyPassword(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putProxyPassword(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__proxyPassword(objHandle: HCkUpload): PWideChar;
function CkUpload_getProxyPort(objHandle: HCkUpload): Integer;
procedure CkUpload_putProxyPort(objHandle: HCkUpload; newPropVal: Integer);
procedure CkUpload_getResponseBodyStr(objHandle: HCkUpload; outPropVal: HCkString);
function CkUpload__responseBodyStr(objHandle: HCkUpload): PWideChar;
procedure CkUpload_getResponseHeader(objHandle: HCkUpload; outPropVal: HCkString);
function CkUpload__responseHeader(objHandle: HCkUpload): PWideChar;
function CkUpload_getResponseStatus(objHandle: HCkUpload): Integer;
function CkUpload_getSsl(objHandle: HCkUpload): wordbool;
procedure CkUpload_putSsl(objHandle: HCkUpload; newPropVal: wordbool);
procedure CkUpload_getSslAllowedCiphers(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putSslAllowedCiphers(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__sslAllowedCiphers(objHandle: HCkUpload): PWideChar;
procedure CkUpload_getSslProtocol(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putSslProtocol(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__sslProtocol(objHandle: HCkUpload): PWideChar;
procedure CkUpload_getTlsPinSet(objHandle: HCkUpload; outPropVal: HCkString);
procedure CkUpload_putTlsPinSet(objHandle: HCkUpload; newPropVal: PWideChar);
function CkUpload__tlsPinSet(objHandle: HCkUpload): PWideChar;
function CkUpload_getTotalUploadSize(objHandle: HCkUpload): LongWord;
function CkUpload_getUploadInProgress(objHandle: HCkUpload): wordbool;
function CkUpload_getUploadSuccess(objHandle: HCkUpload): wordbool;
function CkUpload_getVerboseLogging(objHandle: HCkUpload): wordbool;
procedure CkUpload_putVerboseLogging(objHandle: HCkUpload; newPropVal: wordbool);
procedure CkUpload_getVersion(objHandle: HCkUpload; outPropVal: HCkString);
function CkUpload__version(objHandle: HCkUpload): PWideChar;
procedure CkUpload_AbortUpload(objHandle: HCkUpload);
procedure CkUpload_AddCustomHeader(objHandle: HCkUpload; name: PWideChar; value: PWideChar);
procedure CkUpload_AddFileReference(objHandle: HCkUpload; name: PWideChar; filename: PWideChar);
procedure CkUpload_AddParam(objHandle: HCkUpload; name: PWideChar; value: PWideChar);
function CkUpload_BeginUpload(objHandle: HCkUpload): wordbool;
function CkUpload_BlockingUpload(objHandle: HCkUpload): wordbool;
function CkUpload_BlockingUploadAsync(objHandle: HCkUpload): HCkTask;
procedure CkUpload_ClearFileReferences(objHandle: HCkUpload);
procedure CkUpload_ClearParams(objHandle: HCkUpload);
function CkUpload_LoadTaskCaller(objHandle: HCkUpload; task: HCkTask): wordbool;
procedure CkUpload_SleepMs(objHandle: HCkUpload; millisec: Integer);
function CkUpload_UploadToMemory(objHandle: HCkUpload; outData: HCkByteData): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkUpload_Create = function : HCkUpload; stdcall;
  TCkUpload_Dispose = procedure (handle: HCkUpload); stdcall;
  TCkUpload_SetAbortCheck = procedure (objHandle: HCkUpload; fn: TUploadAbortCheck); stdcall;
  TCkUpload_SetProgressInfo = procedure (objHandle: HCkUpload; fn: TUploadProgressInfo); stdcall;
  TCkUpload_SetPercentDone = procedure (objHandle: HCkUpload; fn: TUploadPercentDone); stdcall;
  TCkUpload_SetTaskCompleted = procedure (objHandle: HCkUpload; fn: TUploadTaskCompleted); stdcall;
  TCkUpload_getAbortCurrent = function (objHandle: HCkUpload): wordbool; stdcall;
  TCkUpload_putAbortCurrent = procedure (objHandle: HCkUpload; newPropVal: wordbool); stdcall;
  TCkUpload_getBandwidthThrottleUp = function (objHandle: HCkUpload): Integer; stdcall;
  TCkUpload_putBandwidthThrottleUp = procedure (objHandle: HCkUpload; newPropVal: Integer); stdcall;
  TCkUpload_getChunkSize = function (objHandle: HCkUpload): Integer; stdcall;
  TCkUpload_putChunkSize = procedure (objHandle: HCkUpload; newPropVal: Integer); stdcall;
  TCkUpload_getClientIpAddress = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putClientIpAddress = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__clientIpAddress = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getCurrentFilename = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload__currentFilename = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getDebugLogFilePath = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putDebugLogFilePath = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__debugLogFilePath = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getExpect100Continue = function (objHandle: HCkUpload): wordbool; stdcall;
  TCkUpload_putExpect100Continue = procedure (objHandle: HCkUpload; newPropVal: wordbool); stdcall;
  TCkUpload_getHeartbeatMs = function (objHandle: HCkUpload): Integer; stdcall;
  TCkUpload_putHeartbeatMs = procedure (objHandle: HCkUpload; newPropVal: Integer); stdcall;
  TCkUpload_getHostname = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putHostname = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__hostname = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getIdleTimeoutMs = function (objHandle: HCkUpload): Integer; stdcall;
  TCkUpload_putIdleTimeoutMs = procedure (objHandle: HCkUpload; newPropVal: Integer); stdcall;
  TCkUpload_getLastErrorHtml = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload__lastErrorHtml = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getLastErrorText = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload__lastErrorText = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getLastErrorXml = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload__lastErrorXml = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getLastMethodSuccess = function (objHandle: HCkUpload): wordbool; stdcall;
  TCkUpload_putLastMethodSuccess = procedure (objHandle: HCkUpload; newPropVal: wordbool); stdcall;
  TCkUpload_getLogin = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putLogin = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__login = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getNumBytesSent = function (objHandle: HCkUpload): LongWord; stdcall;
  TCkUpload_getPassword = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putPassword = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__password = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getPath = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putPath = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__path = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getPercentDoneScale = function (objHandle: HCkUpload): Integer; stdcall;
  TCkUpload_putPercentDoneScale = procedure (objHandle: HCkUpload; newPropVal: Integer); stdcall;
  TCkUpload_getPercentUploaded = function (objHandle: HCkUpload): LongWord; stdcall;
  TCkUpload_getPort = function (objHandle: HCkUpload): Integer; stdcall;
  TCkUpload_putPort = procedure (objHandle: HCkUpload; newPropVal: Integer); stdcall;
  TCkUpload_getPreferIpv6 = function (objHandle: HCkUpload): wordbool; stdcall;
  TCkUpload_putPreferIpv6 = procedure (objHandle: HCkUpload; newPropVal: wordbool); stdcall;
  TCkUpload_getProxyDomain = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putProxyDomain = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__proxyDomain = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getProxyLogin = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putProxyLogin = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__proxyLogin = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getProxyPassword = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putProxyPassword = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__proxyPassword = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getProxyPort = function (objHandle: HCkUpload): Integer; stdcall;
  TCkUpload_putProxyPort = procedure (objHandle: HCkUpload; newPropVal: Integer); stdcall;
  TCkUpload_getResponseBodyStr = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload__responseBodyStr = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getResponseHeader = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload__responseHeader = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getResponseStatus = function (objHandle: HCkUpload): Integer; stdcall;
  TCkUpload_getSsl = function (objHandle: HCkUpload): wordbool; stdcall;
  TCkUpload_putSsl = procedure (objHandle: HCkUpload; newPropVal: wordbool); stdcall;
  TCkUpload_getSslAllowedCiphers = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putSslAllowedCiphers = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__sslAllowedCiphers = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getSslProtocol = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putSslProtocol = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__sslProtocol = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getTlsPinSet = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload_putTlsPinSet = procedure (objHandle: HCkUpload; newPropVal: PWideChar); stdcall;
  TCkUpload__tlsPinSet = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_getTotalUploadSize = function (objHandle: HCkUpload): LongWord; stdcall;
  TCkUpload_getUploadInProgress = function (objHandle: HCkUpload): wordbool; stdcall;
  TCkUpload_getUploadSuccess = function (objHandle: HCkUpload): wordbool; stdcall;
  TCkUpload_getVerboseLogging = function (objHandle: HCkUpload): wordbool; stdcall;
  TCkUpload_putVerboseLogging = procedure (objHandle: HCkUpload; newPropVal: wordbool); stdcall;
  TCkUpload_getVersion = procedure (objHandle: HCkUpload; outPropVal: HCkString); stdcall;
  TCkUpload__version = function (objHandle: HCkUpload): PWideChar; stdcall;
  TCkUpload_AbortUpload = procedure (objHandle: HCkUpload); stdcall;
  TCkUpload_AddCustomHeader = procedure (objHandle: HCkUpload; name: PWideChar; value: PWideChar); stdcall;
  TCkUpload_AddFileReference = procedure (objHandle: HCkUpload; name: PWideChar; filename: PWideChar); stdcall;
  TCkUpload_AddParam = procedure (objHandle: HCkUpload; name: PWideChar; value: PWideChar); stdcall;
  TCkUpload_BeginUpload = function (objHandle: HCkUpload): wordbool; stdcall;
  TCkUpload_BlockingUpload = function (objHandle: HCkUpload): wordbool; stdcall;
  TCkUpload_BlockingUploadAsync = function (objHandle: HCkUpload): HCkTask; stdcall;
  TCkUpload_ClearFileReferences = procedure (objHandle: HCkUpload); stdcall;
  TCkUpload_ClearParams = procedure (objHandle: HCkUpload); stdcall;
  TCkUpload_LoadTaskCaller = function (objHandle: HCkUpload; task: HCkTask): wordbool; stdcall;
  TCkUpload_SleepMs = procedure (objHandle: HCkUpload; millisec: Integer); stdcall;
  TCkUpload_UploadToMemory = function (objHandle: HCkUpload; outData: HCkByteData): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..99] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkUpload_Create : HCkUpload;
begin
  result := TCkUpload_Create(_map(0, 'CkUpload_Create'));
end;

procedure CkUpload_Dispose (handle: HCkUpload);
begin
  TCkUpload_Dispose(_map(1, 'CkUpload_Dispose'))
    (handle);
end;


procedure CkUpload_SetAbortCheck (objHandle: HCkUpload; fn: TUploadAbortCheck);
begin
    TCkUpload_SetAbortCheck(_map(2, 'CkUpload_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkUpload_SetProgressInfo (objHandle: HCkUpload; fn: TUploadProgressInfo);
begin
    TCkUpload_SetProgressInfo(_map(3, 'CkUpload_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkUpload_SetPercentDone (objHandle: HCkUpload; fn: TUploadPercentDone);
begin
    TCkUpload_SetPercentDone(_map(4, 'CkUpload_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkUpload_SetTaskCompleted (objHandle: HCkUpload; fn: TUploadTaskCompleted);
begin
    TCkUpload_SetTaskCompleted(_map(5, 'CkUpload_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkUpload_getAbortCurrent (objHandle: HCkUpload): wordbool;
begin
    result := TCkUpload_getAbortCurrent(_map(6, 'CkUpload_getAbortCurrent'))
    (objHandle);
end;

procedure CkUpload_putAbortCurrent (objHandle: HCkUpload; newPropVal: wordbool);
begin
  TCkUpload_putAbortCurrent(_map(7, 'CkUpload_putAbortCurrent'))
    (objHandle, newPropVal);
end;

function CkUpload_getBandwidthThrottleUp (objHandle: HCkUpload): Integer;
begin
    result := TCkUpload_getBandwidthThrottleUp(_map(8, 'CkUpload_getBandwidthThrottleUp'))
    (objHandle);
end;

procedure CkUpload_putBandwidthThrottleUp (objHandle: HCkUpload; newPropVal: Integer);
begin
  TCkUpload_putBandwidthThrottleUp(_map(9, 'CkUpload_putBandwidthThrottleUp'))
    (objHandle, newPropVal);
end;

function CkUpload_getChunkSize (objHandle: HCkUpload): Integer;
begin
    result := TCkUpload_getChunkSize(_map(10, 'CkUpload_getChunkSize'))
    (objHandle);
end;

procedure CkUpload_putChunkSize (objHandle: HCkUpload; newPropVal: Integer);
begin
  TCkUpload_putChunkSize(_map(11, 'CkUpload_putChunkSize'))
    (objHandle, newPropVal);
end;

procedure CkUpload_getClientIpAddress (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getClientIpAddress(_map(12, 'CkUpload_getClientIpAddress'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putClientIpAddress (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putClientIpAddress(_map(13, 'CkUpload_putClientIpAddress'))
    (objHandle, newPropVal);
end;

function CkUpload__clientIpAddress (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__clientIpAddress(_map(14, 'CkUpload__clientIpAddress'))
    (objHandle);
end;

procedure CkUpload_getCurrentFilename (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getCurrentFilename(_map(15, 'CkUpload_getCurrentFilename'))
    (objHandle, outPropVal);
end;

function CkUpload__currentFilename (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__currentFilename(_map(16, 'CkUpload__currentFilename'))
    (objHandle);
end;

procedure CkUpload_getDebugLogFilePath (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getDebugLogFilePath(_map(17, 'CkUpload_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putDebugLogFilePath (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putDebugLogFilePath(_map(18, 'CkUpload_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkUpload__debugLogFilePath (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__debugLogFilePath(_map(19, 'CkUpload__debugLogFilePath'))
    (objHandle);
end;

function CkUpload_getExpect100Continue (objHandle: HCkUpload): wordbool;
begin
    result := TCkUpload_getExpect100Continue(_map(20, 'CkUpload_getExpect100Continue'))
    (objHandle);
end;

procedure CkUpload_putExpect100Continue (objHandle: HCkUpload; newPropVal: wordbool);
begin
  TCkUpload_putExpect100Continue(_map(21, 'CkUpload_putExpect100Continue'))
    (objHandle, newPropVal);
end;

function CkUpload_getHeartbeatMs (objHandle: HCkUpload): Integer;
begin
    result := TCkUpload_getHeartbeatMs(_map(22, 'CkUpload_getHeartbeatMs'))
    (objHandle);
end;

procedure CkUpload_putHeartbeatMs (objHandle: HCkUpload; newPropVal: Integer);
begin
  TCkUpload_putHeartbeatMs(_map(23, 'CkUpload_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

procedure CkUpload_getHostname (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getHostname(_map(24, 'CkUpload_getHostname'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putHostname (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putHostname(_map(25, 'CkUpload_putHostname'))
    (objHandle, newPropVal);
end;

function CkUpload__hostname (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__hostname(_map(26, 'CkUpload__hostname'))
    (objHandle);
end;

function CkUpload_getIdleTimeoutMs (objHandle: HCkUpload): Integer;
begin
    result := TCkUpload_getIdleTimeoutMs(_map(27, 'CkUpload_getIdleTimeoutMs'))
    (objHandle);
end;

procedure CkUpload_putIdleTimeoutMs (objHandle: HCkUpload; newPropVal: Integer);
begin
  TCkUpload_putIdleTimeoutMs(_map(28, 'CkUpload_putIdleTimeoutMs'))
    (objHandle, newPropVal);
end;

procedure CkUpload_getLastErrorHtml (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getLastErrorHtml(_map(29, 'CkUpload_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkUpload__lastErrorHtml (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__lastErrorHtml(_map(30, 'CkUpload__lastErrorHtml'))
    (objHandle);
end;

procedure CkUpload_getLastErrorText (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getLastErrorText(_map(31, 'CkUpload_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkUpload__lastErrorText (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__lastErrorText(_map(32, 'CkUpload__lastErrorText'))
    (objHandle);
end;

procedure CkUpload_getLastErrorXml (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getLastErrorXml(_map(33, 'CkUpload_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkUpload__lastErrorXml (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__lastErrorXml(_map(34, 'CkUpload__lastErrorXml'))
    (objHandle);
end;

function CkUpload_getLastMethodSuccess (objHandle: HCkUpload): wordbool;
begin
    result := TCkUpload_getLastMethodSuccess(_map(35, 'CkUpload_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkUpload_putLastMethodSuccess (objHandle: HCkUpload; newPropVal: wordbool);
begin
  TCkUpload_putLastMethodSuccess(_map(36, 'CkUpload_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkUpload_getLogin (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getLogin(_map(37, 'CkUpload_getLogin'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putLogin (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putLogin(_map(38, 'CkUpload_putLogin'))
    (objHandle, newPropVal);
end;

function CkUpload__login (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__login(_map(39, 'CkUpload__login'))
    (objHandle);
end;

function CkUpload_getNumBytesSent (objHandle: HCkUpload): LongWord;
begin
    result := TCkUpload_getNumBytesSent(_map(40, 'CkUpload_getNumBytesSent'))
    (objHandle);
end;

procedure CkUpload_getPassword (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getPassword(_map(41, 'CkUpload_getPassword'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putPassword (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putPassword(_map(42, 'CkUpload_putPassword'))
    (objHandle, newPropVal);
end;

function CkUpload__password (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__password(_map(43, 'CkUpload__password'))
    (objHandle);
end;

procedure CkUpload_getPath (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getPath(_map(44, 'CkUpload_getPath'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putPath (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putPath(_map(45, 'CkUpload_putPath'))
    (objHandle, newPropVal);
end;

function CkUpload__path (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__path(_map(46, 'CkUpload__path'))
    (objHandle);
end;

function CkUpload_getPercentDoneScale (objHandle: HCkUpload): Integer;
begin
    result := TCkUpload_getPercentDoneScale(_map(47, 'CkUpload_getPercentDoneScale'))
    (objHandle);
end;

procedure CkUpload_putPercentDoneScale (objHandle: HCkUpload; newPropVal: Integer);
begin
  TCkUpload_putPercentDoneScale(_map(48, 'CkUpload_putPercentDoneScale'))
    (objHandle, newPropVal);
end;

function CkUpload_getPercentUploaded (objHandle: HCkUpload): LongWord;
begin
    result := TCkUpload_getPercentUploaded(_map(49, 'CkUpload_getPercentUploaded'))
    (objHandle);
end;

function CkUpload_getPort (objHandle: HCkUpload): Integer;
begin
    result := TCkUpload_getPort(_map(50, 'CkUpload_getPort'))
    (objHandle);
end;

procedure CkUpload_putPort (objHandle: HCkUpload; newPropVal: Integer);
begin
  TCkUpload_putPort(_map(51, 'CkUpload_putPort'))
    (objHandle, newPropVal);
end;

function CkUpload_getPreferIpv6 (objHandle: HCkUpload): wordbool;
begin
    result := TCkUpload_getPreferIpv6(_map(52, 'CkUpload_getPreferIpv6'))
    (objHandle);
end;

procedure CkUpload_putPreferIpv6 (objHandle: HCkUpload; newPropVal: wordbool);
begin
  TCkUpload_putPreferIpv6(_map(53, 'CkUpload_putPreferIpv6'))
    (objHandle, newPropVal);
end;

procedure CkUpload_getProxyDomain (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getProxyDomain(_map(54, 'CkUpload_getProxyDomain'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putProxyDomain (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putProxyDomain(_map(55, 'CkUpload_putProxyDomain'))
    (objHandle, newPropVal);
end;

function CkUpload__proxyDomain (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__proxyDomain(_map(56, 'CkUpload__proxyDomain'))
    (objHandle);
end;

procedure CkUpload_getProxyLogin (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getProxyLogin(_map(57, 'CkUpload_getProxyLogin'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putProxyLogin (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putProxyLogin(_map(58, 'CkUpload_putProxyLogin'))
    (objHandle, newPropVal);
end;

function CkUpload__proxyLogin (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__proxyLogin(_map(59, 'CkUpload__proxyLogin'))
    (objHandle);
end;

procedure CkUpload_getProxyPassword (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getProxyPassword(_map(60, 'CkUpload_getProxyPassword'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putProxyPassword (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putProxyPassword(_map(61, 'CkUpload_putProxyPassword'))
    (objHandle, newPropVal);
end;

function CkUpload__proxyPassword (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__proxyPassword(_map(62, 'CkUpload__proxyPassword'))
    (objHandle);
end;

function CkUpload_getProxyPort (objHandle: HCkUpload): Integer;
begin
    result := TCkUpload_getProxyPort(_map(63, 'CkUpload_getProxyPort'))
    (objHandle);
end;

procedure CkUpload_putProxyPort (objHandle: HCkUpload; newPropVal: Integer);
begin
  TCkUpload_putProxyPort(_map(64, 'CkUpload_putProxyPort'))
    (objHandle, newPropVal);
end;

procedure CkUpload_getResponseBodyStr (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getResponseBodyStr(_map(65, 'CkUpload_getResponseBodyStr'))
    (objHandle, outPropVal);
end;

function CkUpload__responseBodyStr (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__responseBodyStr(_map(66, 'CkUpload__responseBodyStr'))
    (objHandle);
end;

procedure CkUpload_getResponseHeader (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getResponseHeader(_map(67, 'CkUpload_getResponseHeader'))
    (objHandle, outPropVal);
end;

function CkUpload__responseHeader (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__responseHeader(_map(68, 'CkUpload__responseHeader'))
    (objHandle);
end;

function CkUpload_getResponseStatus (objHandle: HCkUpload): Integer;
begin
    result := TCkUpload_getResponseStatus(_map(69, 'CkUpload_getResponseStatus'))
    (objHandle);
end;

function CkUpload_getSsl (objHandle: HCkUpload): wordbool;
begin
    result := TCkUpload_getSsl(_map(70, 'CkUpload_getSsl'))
    (objHandle);
end;

procedure CkUpload_putSsl (objHandle: HCkUpload; newPropVal: wordbool);
begin
  TCkUpload_putSsl(_map(71, 'CkUpload_putSsl'))
    (objHandle, newPropVal);
end;

procedure CkUpload_getSslAllowedCiphers (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getSslAllowedCiphers(_map(72, 'CkUpload_getSslAllowedCiphers'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putSslAllowedCiphers (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putSslAllowedCiphers(_map(73, 'CkUpload_putSslAllowedCiphers'))
    (objHandle, newPropVal);
end;

function CkUpload__sslAllowedCiphers (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__sslAllowedCiphers(_map(74, 'CkUpload__sslAllowedCiphers'))
    (objHandle);
end;

procedure CkUpload_getSslProtocol (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getSslProtocol(_map(75, 'CkUpload_getSslProtocol'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putSslProtocol (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putSslProtocol(_map(76, 'CkUpload_putSslProtocol'))
    (objHandle, newPropVal);
end;

function CkUpload__sslProtocol (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__sslProtocol(_map(77, 'CkUpload__sslProtocol'))
    (objHandle);
end;

procedure CkUpload_getTlsPinSet (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getTlsPinSet(_map(78, 'CkUpload_getTlsPinSet'))
    (objHandle, outPropVal);
end;

procedure CkUpload_putTlsPinSet (objHandle: HCkUpload; newPropVal: PWideChar);
begin
  TCkUpload_putTlsPinSet(_map(79, 'CkUpload_putTlsPinSet'))
    (objHandle, newPropVal);
end;

function CkUpload__tlsPinSet (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__tlsPinSet(_map(80, 'CkUpload__tlsPinSet'))
    (objHandle);
end;

function CkUpload_getTotalUploadSize (objHandle: HCkUpload): LongWord;
begin
    result := TCkUpload_getTotalUploadSize(_map(81, 'CkUpload_getTotalUploadSize'))
    (objHandle);
end;

function CkUpload_getUploadInProgress (objHandle: HCkUpload): wordbool;
begin
    result := TCkUpload_getUploadInProgress(_map(82, 'CkUpload_getUploadInProgress'))
    (objHandle);
end;

function CkUpload_getUploadSuccess (objHandle: HCkUpload): wordbool;
begin
    result := TCkUpload_getUploadSuccess(_map(83, 'CkUpload_getUploadSuccess'))
    (objHandle);
end;

function CkUpload_getVerboseLogging (objHandle: HCkUpload): wordbool;
begin
    result := TCkUpload_getVerboseLogging(_map(84, 'CkUpload_getVerboseLogging'))
    (objHandle);
end;

procedure CkUpload_putVerboseLogging (objHandle: HCkUpload; newPropVal: wordbool);
begin
  TCkUpload_putVerboseLogging(_map(85, 'CkUpload_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkUpload_getVersion (objHandle: HCkUpload; outPropVal: HCkString);
begin
  TCkUpload_getVersion(_map(86, 'CkUpload_getVersion'))
    (objHandle, outPropVal);
end;

function CkUpload__version (objHandle: HCkUpload): PWideChar;
begin
  result := TCkUpload__version(_map(87, 'CkUpload__version'))
    (objHandle);
end;

procedure CkUpload_AbortUpload (objHandle: HCkUpload);
begin
  TCkUpload_AbortUpload(_map(88, 'CkUpload_AbortUpload'))
    (objHandle);
end;

procedure CkUpload_AddCustomHeader (objHandle: HCkUpload; name: PWideChar; value: PWideChar);
begin
  TCkUpload_AddCustomHeader(_map(89, 'CkUpload_AddCustomHeader'))
    (objHandle, name, value);
end;

procedure CkUpload_AddFileReference (objHandle: HCkUpload; name: PWideChar; filename: PWideChar);
begin
  TCkUpload_AddFileReference(_map(90, 'CkUpload_AddFileReference'))
    (objHandle, name, filename);
end;

procedure CkUpload_AddParam (objHandle: HCkUpload; name: PWideChar; value: PWideChar);
begin
  TCkUpload_AddParam(_map(91, 'CkUpload_AddParam'))
    (objHandle, name, value);
end;

function CkUpload_BeginUpload (objHandle: HCkUpload): wordbool;
begin
  result := TCkUpload_BeginUpload(_map(92, 'CkUpload_BeginUpload'))
    (objHandle);
end;

function CkUpload_BlockingUpload (objHandle: HCkUpload): wordbool;
begin
  result := TCkUpload_BlockingUpload(_map(93, 'CkUpload_BlockingUpload'))
    (objHandle);
end;

function CkUpload_BlockingUploadAsync (objHandle: HCkUpload): HCkTask;
begin
  result := TCkUpload_BlockingUploadAsync(_map(94, 'CkUpload_BlockingUploadAsync'))
    (objHandle);
end;

procedure CkUpload_ClearFileReferences (objHandle: HCkUpload);
begin
  TCkUpload_ClearFileReferences(_map(95, 'CkUpload_ClearFileReferences'))
    (objHandle);
end;

procedure CkUpload_ClearParams (objHandle: HCkUpload);
begin
  TCkUpload_ClearParams(_map(96, 'CkUpload_ClearParams'))
    (objHandle);
end;

function CkUpload_LoadTaskCaller (objHandle: HCkUpload; task: HCkTask): wordbool;
begin
  result := TCkUpload_LoadTaskCaller(_map(97, 'CkUpload_LoadTaskCaller'))
    (objHandle, task);
end;

procedure CkUpload_SleepMs (objHandle: HCkUpload; millisec: Integer);
begin
  TCkUpload_SleepMs(_map(98, 'CkUpload_SleepMs'))
    (objHandle, millisec);
end;

function CkUpload_UploadToMemory (objHandle: HCkUpload; outData: HCkByteData): wordbool;
begin
  result := TCkUpload_UploadToMemory(_map(99, 'CkUpload_UploadToMemory'))
    (objHandle, outData);
end;

end.
