unit Url;

interface

type

HCkUrl = Pointer;
HCkString = Pointer;


function CkUrl_Create: HCkUrl;  stdcall;
procedure CkUrl_Dispose(handle: HCkUrl); stdcall;
procedure CkUrl_getDebugLogFilePath(objHandle: HCkUrl; outPropVal: HCkString);
procedure CkUrl_putDebugLogFilePath(objHandle: HCkUrl; newPropVal: PWideChar);
function CkUrl__debugLogFilePath(objHandle: HCkUrl): PWideChar;
procedure CkUrl_getFrag(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__frag(objHandle: HCkUrl): PWideChar;
procedure CkUrl_getHost(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__host(objHandle: HCkUrl): PWideChar;
procedure CkUrl_getHostType(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__hostType(objHandle: HCkUrl): PWideChar;
procedure CkUrl_getLastErrorHtml(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__lastErrorHtml(objHandle: HCkUrl): PWideChar;
procedure CkUrl_getLastErrorText(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__lastErrorText(objHandle: HCkUrl): PWideChar;
procedure CkUrl_getLastErrorXml(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__lastErrorXml(objHandle: HCkUrl): PWideChar;
function CkUrl_getLastMethodSuccess(objHandle: HCkUrl): wordbool;
procedure CkUrl_putLastMethodSuccess(objHandle: HCkUrl; newPropVal: wordbool);
procedure CkUrl_getLogin(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__login(objHandle: HCkUrl): PWideChar;
procedure CkUrl_getPassword(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__password(objHandle: HCkUrl): PWideChar;
procedure CkUrl_getPath(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__path(objHandle: HCkUrl): PWideChar;
procedure CkUrl_getPathWithQueryParams(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__pathWithQueryParams(objHandle: HCkUrl): PWideChar;
function CkUrl_getPort(objHandle: HCkUrl): Integer;
procedure CkUrl_getQuery(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__query(objHandle: HCkUrl): PWideChar;
function CkUrl_getSsl(objHandle: HCkUrl): wordbool;
function CkUrl_getVerboseLogging(objHandle: HCkUrl): wordbool;
procedure CkUrl_putVerboseLogging(objHandle: HCkUrl; newPropVal: wordbool);
procedure CkUrl_getVersion(objHandle: HCkUrl; outPropVal: HCkString);
function CkUrl__version(objHandle: HCkUrl): PWideChar;
function CkUrl_ParseUrl(objHandle: HCkUrl; url: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkUrl_Create = function : HCkUrl; stdcall;
  TCkUrl_Dispose = procedure (handle: HCkUrl); stdcall;
  TCkUrl_getDebugLogFilePath = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl_putDebugLogFilePath = procedure (objHandle: HCkUrl; newPropVal: PWideChar); stdcall;
  TCkUrl__debugLogFilePath = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getFrag = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__frag = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getHost = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__host = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getHostType = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__hostType = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getLastErrorHtml = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__lastErrorHtml = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getLastErrorText = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__lastErrorText = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getLastErrorXml = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__lastErrorXml = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getLastMethodSuccess = function (objHandle: HCkUrl): wordbool; stdcall;
  TCkUrl_putLastMethodSuccess = procedure (objHandle: HCkUrl; newPropVal: wordbool); stdcall;
  TCkUrl_getLogin = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__login = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getPassword = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__password = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getPath = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__path = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getPathWithQueryParams = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__pathWithQueryParams = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getPort = function (objHandle: HCkUrl): Integer; stdcall;
  TCkUrl_getQuery = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__query = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_getSsl = function (objHandle: HCkUrl): wordbool; stdcall;
  TCkUrl_getVerboseLogging = function (objHandle: HCkUrl): wordbool; stdcall;
  TCkUrl_putVerboseLogging = procedure (objHandle: HCkUrl; newPropVal: wordbool); stdcall;
  TCkUrl_getVersion = procedure (objHandle: HCkUrl; outPropVal: HCkString); stdcall;
  TCkUrl__version = function (objHandle: HCkUrl): PWideChar; stdcall;
  TCkUrl_ParseUrl = function (objHandle: HCkUrl; url: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..35] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkUrl_Create : HCkUrl;
begin
  result := TCkUrl_Create(_map(0, 'CkUrl_Create'));
end;

procedure CkUrl_Dispose (handle: HCkUrl);
begin
  TCkUrl_Dispose(_map(1, 'CkUrl_Dispose'))
    (handle);
end;


procedure CkUrl_getDebugLogFilePath (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getDebugLogFilePath(_map(2, 'CkUrl_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkUrl_putDebugLogFilePath (objHandle: HCkUrl; newPropVal: PWideChar);
begin
  TCkUrl_putDebugLogFilePath(_map(3, 'CkUrl_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkUrl__debugLogFilePath (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__debugLogFilePath(_map(4, 'CkUrl__debugLogFilePath'))
    (objHandle);
end;

procedure CkUrl_getFrag (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getFrag(_map(5, 'CkUrl_getFrag'))
    (objHandle, outPropVal);
end;

function CkUrl__frag (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__frag(_map(6, 'CkUrl__frag'))
    (objHandle);
end;

procedure CkUrl_getHost (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getHost(_map(7, 'CkUrl_getHost'))
    (objHandle, outPropVal);
end;

function CkUrl__host (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__host(_map(8, 'CkUrl__host'))
    (objHandle);
end;

procedure CkUrl_getHostType (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getHostType(_map(9, 'CkUrl_getHostType'))
    (objHandle, outPropVal);
end;

function CkUrl__hostType (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__hostType(_map(10, 'CkUrl__hostType'))
    (objHandle);
end;

procedure CkUrl_getLastErrorHtml (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getLastErrorHtml(_map(11, 'CkUrl_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkUrl__lastErrorHtml (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__lastErrorHtml(_map(12, 'CkUrl__lastErrorHtml'))
    (objHandle);
end;

procedure CkUrl_getLastErrorText (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getLastErrorText(_map(13, 'CkUrl_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkUrl__lastErrorText (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__lastErrorText(_map(14, 'CkUrl__lastErrorText'))
    (objHandle);
end;

procedure CkUrl_getLastErrorXml (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getLastErrorXml(_map(15, 'CkUrl_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkUrl__lastErrorXml (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__lastErrorXml(_map(16, 'CkUrl__lastErrorXml'))
    (objHandle);
end;

function CkUrl_getLastMethodSuccess (objHandle: HCkUrl): wordbool;
begin
    result := TCkUrl_getLastMethodSuccess(_map(17, 'CkUrl_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkUrl_putLastMethodSuccess (objHandle: HCkUrl; newPropVal: wordbool);
begin
  TCkUrl_putLastMethodSuccess(_map(18, 'CkUrl_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkUrl_getLogin (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getLogin(_map(19, 'CkUrl_getLogin'))
    (objHandle, outPropVal);
end;

function CkUrl__login (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__login(_map(20, 'CkUrl__login'))
    (objHandle);
end;

procedure CkUrl_getPassword (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getPassword(_map(21, 'CkUrl_getPassword'))
    (objHandle, outPropVal);
end;

function CkUrl__password (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__password(_map(22, 'CkUrl__password'))
    (objHandle);
end;

procedure CkUrl_getPath (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getPath(_map(23, 'CkUrl_getPath'))
    (objHandle, outPropVal);
end;

function CkUrl__path (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__path(_map(24, 'CkUrl__path'))
    (objHandle);
end;

procedure CkUrl_getPathWithQueryParams (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getPathWithQueryParams(_map(25, 'CkUrl_getPathWithQueryParams'))
    (objHandle, outPropVal);
end;

function CkUrl__pathWithQueryParams (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__pathWithQueryParams(_map(26, 'CkUrl__pathWithQueryParams'))
    (objHandle);
end;

function CkUrl_getPort (objHandle: HCkUrl): Integer;
begin
    result := TCkUrl_getPort(_map(27, 'CkUrl_getPort'))
    (objHandle);
end;

procedure CkUrl_getQuery (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getQuery(_map(28, 'CkUrl_getQuery'))
    (objHandle, outPropVal);
end;

function CkUrl__query (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__query(_map(29, 'CkUrl__query'))
    (objHandle);
end;

function CkUrl_getSsl (objHandle: HCkUrl): wordbool;
begin
    result := TCkUrl_getSsl(_map(30, 'CkUrl_getSsl'))
    (objHandle);
end;

function CkUrl_getVerboseLogging (objHandle: HCkUrl): wordbool;
begin
    result := TCkUrl_getVerboseLogging(_map(31, 'CkUrl_getVerboseLogging'))
    (objHandle);
end;

procedure CkUrl_putVerboseLogging (objHandle: HCkUrl; newPropVal: wordbool);
begin
  TCkUrl_putVerboseLogging(_map(32, 'CkUrl_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkUrl_getVersion (objHandle: HCkUrl; outPropVal: HCkString);
begin
  TCkUrl_getVersion(_map(33, 'CkUrl_getVersion'))
    (objHandle, outPropVal);
end;

function CkUrl__version (objHandle: HCkUrl): PWideChar;
begin
  result := TCkUrl__version(_map(34, 'CkUrl__version'))
    (objHandle);
end;

function CkUrl_ParseUrl (objHandle: HCkUrl; url: PWideChar): wordbool;
begin
  result := TCkUrl_ParseUrl(_map(35, 'CkUrl_ParseUrl'))
    (objHandle, url);
end;

end.
