unit Xml;

interface

type

HCkBinData = Pointer;
HCkXml = Pointer;
HCkStringBuilder = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;


function CkXml_Create: HCkXml;  stdcall;
procedure CkXml_Dispose(handle: HCkXml); stdcall;
function CkXml_getCdata(objHandle: HCkXml): wordbool;
procedure CkXml_putCdata(objHandle: HCkXml; newPropVal: wordbool);
procedure CkXml_getContent(objHandle: HCkXml; outPropVal: HCkString);
procedure CkXml_putContent(objHandle: HCkXml; newPropVal: PWideChar);
function CkXml__content(objHandle: HCkXml): PWideChar;
function CkXml_getContentInt(objHandle: HCkXml): Integer;
procedure CkXml_putContentInt(objHandle: HCkXml; newPropVal: Integer);
procedure CkXml_getDebugLogFilePath(objHandle: HCkXml; outPropVal: HCkString);
procedure CkXml_putDebugLogFilePath(objHandle: HCkXml; newPropVal: PWideChar);
function CkXml__debugLogFilePath(objHandle: HCkXml): PWideChar;
procedure CkXml_getDocType(objHandle: HCkXml; outPropVal: HCkString);
procedure CkXml_putDocType(objHandle: HCkXml; newPropVal: PWideChar);
function CkXml__docType(objHandle: HCkXml): PWideChar;
function CkXml_getEmitBom(objHandle: HCkXml): wordbool;
procedure CkXml_putEmitBom(objHandle: HCkXml; newPropVal: wordbool);
function CkXml_getEmitCompact(objHandle: HCkXml): wordbool;
procedure CkXml_putEmitCompact(objHandle: HCkXml; newPropVal: wordbool);
function CkXml_getEmitXmlDecl(objHandle: HCkXml): wordbool;
procedure CkXml_putEmitXmlDecl(objHandle: HCkXml; newPropVal: wordbool);
procedure CkXml_getEncoding(objHandle: HCkXml; outPropVal: HCkString);
procedure CkXml_putEncoding(objHandle: HCkXml; newPropVal: PWideChar);
function CkXml__encoding(objHandle: HCkXml): PWideChar;
function CkXml_getI(objHandle: HCkXml): Integer;
procedure CkXml_putI(objHandle: HCkXml; newPropVal: Integer);
function CkXml_getIsBase64(objHandle: HCkXml): wordbool;
function CkXml_getJ(objHandle: HCkXml): Integer;
procedure CkXml_putJ(objHandle: HCkXml; newPropVal: Integer);
function CkXml_getK(objHandle: HCkXml): Integer;
procedure CkXml_putK(objHandle: HCkXml; newPropVal: Integer);
procedure CkXml_getLastErrorHtml(objHandle: HCkXml; outPropVal: HCkString);
function CkXml__lastErrorHtml(objHandle: HCkXml): PWideChar;
procedure CkXml_getLastErrorText(objHandle: HCkXml; outPropVal: HCkString);
function CkXml__lastErrorText(objHandle: HCkXml): PWideChar;
procedure CkXml_getLastErrorXml(objHandle: HCkXml; outPropVal: HCkString);
function CkXml__lastErrorXml(objHandle: HCkXml): PWideChar;
function CkXml_getLastMethodSuccess(objHandle: HCkXml): wordbool;
procedure CkXml_putLastMethodSuccess(objHandle: HCkXml; newPropVal: wordbool);
function CkXml_getNumAttributes(objHandle: HCkXml): Integer;
function CkXml_getNumChildren(objHandle: HCkXml): Integer;
function CkXml_getSortCaseInsensitive(objHandle: HCkXml): wordbool;
procedure CkXml_putSortCaseInsensitive(objHandle: HCkXml; newPropVal: wordbool);
function CkXml_getStandalone(objHandle: HCkXml): wordbool;
procedure CkXml_putStandalone(objHandle: HCkXml; newPropVal: wordbool);
procedure CkXml_getTag(objHandle: HCkXml; outPropVal: HCkString);
procedure CkXml_putTag(objHandle: HCkXml; newPropVal: PWideChar);
function CkXml__tag(objHandle: HCkXml): PWideChar;
procedure CkXml_getTagNsPrefix(objHandle: HCkXml; outPropVal: HCkString);
procedure CkXml_putTagNsPrefix(objHandle: HCkXml; newPropVal: PWideChar);
function CkXml__tagNsPrefix(objHandle: HCkXml): PWideChar;
procedure CkXml_getTagPath(objHandle: HCkXml; outPropVal: HCkString);
function CkXml__tagPath(objHandle: HCkXml): PWideChar;
procedure CkXml_getTagUnprefixed(objHandle: HCkXml; outPropVal: HCkString);
procedure CkXml_putTagUnprefixed(objHandle: HCkXml; newPropVal: PWideChar);
function CkXml__tagUnprefixed(objHandle: HCkXml): PWideChar;
function CkXml_getTreeId(objHandle: HCkXml): Integer;
procedure CkXml_getUncommonOptions(objHandle: HCkXml; outPropVal: HCkString);
procedure CkXml_putUncommonOptions(objHandle: HCkXml; newPropVal: PWideChar);
function CkXml__uncommonOptions(objHandle: HCkXml): PWideChar;
function CkXml_getVerboseLogging(objHandle: HCkXml): wordbool;
procedure CkXml_putVerboseLogging(objHandle: HCkXml; newPropVal: wordbool);
procedure CkXml_getVersion(objHandle: HCkXml; outPropVal: HCkString);
function CkXml__version(objHandle: HCkXml): PWideChar;
function CkXml_AccumulateTagContent(objHandle: HCkXml; tag: PWideChar; skipTags: PWideChar; outStr: HCkString): wordbool;
function CkXml__accumulateTagContent(objHandle: HCkXml; tag: PWideChar; skipTags: PWideChar): PWideChar;
function CkXml_AddAttribute(objHandle: HCkXml; name: PWideChar; value: PWideChar): wordbool;
function CkXml_AddAttributeInt(objHandle: HCkXml; name: PWideChar; value: Integer): wordbool;
function CkXml_AddChildTree(objHandle: HCkXml; tree: HCkXml): wordbool;
procedure CkXml_AddOrUpdateAttribute(objHandle: HCkXml; name: PWideChar; value: PWideChar);
procedure CkXml_AddOrUpdateAttributeI(objHandle: HCkXml; name: PWideChar; value: Integer);
procedure CkXml_AddStyleSheet(objHandle: HCkXml; styleSheet: PWideChar);
procedure CkXml_AddToAttribute(objHandle: HCkXml; name: PWideChar; amount: Integer);
procedure CkXml_AddToChildContent(objHandle: HCkXml; tag: PWideChar; amount: Integer);
procedure CkXml_AddToContent(objHandle: HCkXml; amount: Integer);
function CkXml_AppendToContent(objHandle: HCkXml; str: PWideChar): wordbool;
function CkXml_BEncodeContent(objHandle: HCkXml; charset: PWideChar; inData: HCkByteData): wordbool;
function CkXml_ChildContentMatches(objHandle: HCkXml; tagPath: PWideChar; pattern: PWideChar; caseSensitive: wordbool): wordbool;
function CkXml_ChilkatPath(objHandle: HCkXml; pathCmd: PWideChar; outStr: HCkString): wordbool;
function CkXml__chilkatPath(objHandle: HCkXml; pathCmd: PWideChar): PWideChar;
procedure CkXml_Clear(objHandle: HCkXml);
function CkXml_ContentMatches(objHandle: HCkXml; pattern: PWideChar; caseSensitive: wordbool): wordbool;
procedure CkXml_Copy(objHandle: HCkXml; node: HCkXml);
procedure CkXml_CopyRef(objHandle: HCkXml; copyFromNode: HCkXml);
function CkXml_DecodeContent(objHandle: HCkXml; outData: HCkByteData): wordbool;
function CkXml_DecodeEntities(objHandle: HCkXml; str: PWideChar; outStr: HCkString): wordbool;
function CkXml__decodeEntities(objHandle: HCkXml; str: PWideChar): PWideChar;
function CkXml_DecryptContent(objHandle: HCkXml; password: PWideChar): wordbool;
function CkXml_EncryptContent(objHandle: HCkXml; password: PWideChar): wordbool;
function CkXml_ExtractChildByIndex(objHandle: HCkXml; index: Integer): HCkXml;
function CkXml_ExtractChildByName(objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar; attrValue: PWideChar): HCkXml;
function CkXml_FindChild(objHandle: HCkXml; tagPath: PWideChar): HCkXml;
function CkXml_FindChild2(objHandle: HCkXml; tagPath: PWideChar): wordbool;
function CkXml_FindNextRecord(objHandle: HCkXml; tagPath: PWideChar; contentPattern: PWideChar): HCkXml;
function CkXml_FindOrAddNewChild(objHandle: HCkXml; tagPath: PWideChar): HCkXml;
function CkXml_FirstChild(objHandle: HCkXml): HCkXml;
function CkXml_FirstChild2(objHandle: HCkXml): wordbool;
function CkXml_GetAttributeName(objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool;
function CkXml__getAttributeName(objHandle: HCkXml; index: Integer): PWideChar;
function CkXml_GetAttributeValue(objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool;
function CkXml__getAttributeValue(objHandle: HCkXml; index: Integer): PWideChar;
function CkXml_GetAttributeValueInt(objHandle: HCkXml; index: Integer): Integer;
function CkXml_GetAttrValue(objHandle: HCkXml; name: PWideChar; outStr: HCkString): wordbool;
function CkXml__getAttrValue(objHandle: HCkXml; name: PWideChar): PWideChar;
function CkXml_GetAttrValueInt(objHandle: HCkXml; name: PWideChar): Integer;
function CkXml_GetBinaryContent(objHandle: HCkXml; unzipFlag: wordbool; decryptFlag: wordbool; password: PWideChar; outData: HCkByteData): wordbool;
function CkXml_GetChild(objHandle: HCkXml; index: Integer): HCkXml;
function CkXml_GetChild2(objHandle: HCkXml; index: Integer): wordbool;
function CkXml_GetChildAttrValue(objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar; outStr: HCkString): wordbool;
function CkXml__getChildAttrValue(objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar): PWideChar;
function CkXml_GetChildBoolValue(objHandle: HCkXml; tagPath: PWideChar): wordbool;
function CkXml_GetChildContent(objHandle: HCkXml; tagPath: PWideChar; outStr: HCkString): wordbool;
function CkXml__getChildContent(objHandle: HCkXml; tagPath: PWideChar): PWideChar;
function CkXml_GetChildContentByIndex(objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool;
function CkXml__getChildContentByIndex(objHandle: HCkXml; index: Integer): PWideChar;
function CkXml_GetChildContentSb(objHandle: HCkXml; tagPath: PWideChar; sb: HCkStringBuilder): wordbool;
function CkXml_GetChildExact(objHandle: HCkXml; tag: PWideChar; content: PWideChar): HCkXml;
function CkXml_GetChildIntValue(objHandle: HCkXml; tagPath: PWideChar): Integer;
function CkXml_GetChildTag(objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool;
function CkXml__getChildTag(objHandle: HCkXml; index: Integer): PWideChar;
function CkXml_GetChildTagByIndex(objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool;
function CkXml__getChildTagByIndex(objHandle: HCkXml; index: Integer): PWideChar;
function CkXml_GetChildWithAttr(objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar; attrValue: PWideChar): HCkXml;
function CkXml_GetChildWithContent(objHandle: HCkXml; content: PWideChar): HCkXml;
function CkXml_GetChildWithTag(objHandle: HCkXml; tagPath: PWideChar): HCkXml;
function CkXml_GetChildWithTag2(objHandle: HCkXml; tagPath: PWideChar): wordbool;
function CkXml_GetNthChildWithTag(objHandle: HCkXml; tag: PWideChar; n: Integer): HCkXml;
function CkXml_GetNthChildWithTag2(objHandle: HCkXml; tag: PWideChar; n: Integer): wordbool;
function CkXml_GetParent(objHandle: HCkXml): HCkXml;
function CkXml_GetParent2(objHandle: HCkXml): wordbool;
function CkXml_GetRoot(objHandle: HCkXml): HCkXml;
procedure CkXml_GetRoot2(objHandle: HCkXml);
function CkXml_GetSelf(objHandle: HCkXml): HCkXml;
function CkXml_GetXml(objHandle: HCkXml; outStr: HCkString): wordbool;
function CkXml__getXml(objHandle: HCkXml): PWideChar;
function CkXml_GetXmlBd(objHandle: HCkXml; bd: HCkBinData): wordbool;
function CkXml_GetXmlSb(objHandle: HCkXml; sb: HCkStringBuilder): wordbool;
function CkXml_HasAttribute(objHandle: HCkXml; name: PWideChar): wordbool;
function CkXml_HasAttrWithValue(objHandle: HCkXml; name: PWideChar; value: PWideChar): wordbool;
function CkXml_HasChildWithContent(objHandle: HCkXml; content: PWideChar): wordbool;
function CkXml_HasChildWithTag(objHandle: HCkXml; tagPath: PWideChar): wordbool;
function CkXml_HasChildWithTagAndContent(objHandle: HCkXml; tagPath: PWideChar; content: PWideChar): wordbool;
procedure CkXml_InsertChildTreeAfter(objHandle: HCkXml; index: Integer; tree: HCkXml);
procedure CkXml_InsertChildTreeBefore(objHandle: HCkXml; index: Integer; tree: HCkXml);
function CkXml_LastChild(objHandle: HCkXml): HCkXml;
function CkXml_LastChild2(objHandle: HCkXml): wordbool;
function CkXml_LoadBd(objHandle: HCkXml; bd: HCkBinData; autoTrim: wordbool): wordbool;
function CkXml_LoadSb(objHandle: HCkXml; sb: HCkStringBuilder; autoTrim: wordbool): wordbool;
function CkXml_LoadXml(objHandle: HCkXml; xmlData: PWideChar): wordbool;
function CkXml_LoadXml2(objHandle: HCkXml; xmlData: PWideChar; autoTrim: wordbool): wordbool;
function CkXml_LoadXmlFile(objHandle: HCkXml; fileName: PWideChar): wordbool;
function CkXml_LoadXmlFile2(objHandle: HCkXml; fileName: PWideChar; autoTrim: wordbool): wordbool;
function CkXml_NewChild(objHandle: HCkXml; tagPath: PWideChar; content: PWideChar): HCkXml;
procedure CkXml_NewChild2(objHandle: HCkXml; tagPath: PWideChar; content: PWideChar);
function CkXml_NewChildAfter(objHandle: HCkXml; index: Integer; tag: PWideChar; content: PWideChar): HCkXml;
function CkXml_NewChildBefore(objHandle: HCkXml; index: Integer; tag: PWideChar; content: PWideChar): HCkXml;
procedure CkXml_NewChildInt2(objHandle: HCkXml; tagPath: PWideChar; value: Integer);
function CkXml_NextInTraversal2(objHandle: HCkXml; sbState: HCkStringBuilder): wordbool;
function CkXml_NextSibling(objHandle: HCkXml): HCkXml;
function CkXml_NextSibling2(objHandle: HCkXml): wordbool;
function CkXml_NumChildrenAt(objHandle: HCkXml; tagPath: PWideChar): Integer;
function CkXml_NumChildrenHavingTag(objHandle: HCkXml; tag: PWideChar): Integer;
function CkXml_PreviousSibling(objHandle: HCkXml): HCkXml;
function CkXml_PreviousSibling2(objHandle: HCkXml): wordbool;
function CkXml_PruneAttribute(objHandle: HCkXml; attrName: PWideChar): Integer;
function CkXml_PruneTag(objHandle: HCkXml; tag: PWideChar): Integer;
function CkXml_QEncodeContent(objHandle: HCkXml; charset: PWideChar; inData: HCkByteData): wordbool;
function CkXml_RemoveAllAttributes(objHandle: HCkXml): wordbool;
procedure CkXml_RemoveAllChildren(objHandle: HCkXml);
function CkXml_RemoveAttribute(objHandle: HCkXml; name: PWideChar): wordbool;
procedure CkXml_RemoveChild(objHandle: HCkXml; tagPath: PWideChar);
procedure CkXml_RemoveChildByIndex(objHandle: HCkXml; index: Integer);
procedure CkXml_RemoveChildWithContent(objHandle: HCkXml; content: PWideChar);
procedure CkXml_RemoveFromTree(objHandle: HCkXml);
function CkXml_RemoveStyleSheet(objHandle: HCkXml; attrName: PWideChar; attrValue: PWideChar): Integer;
function CkXml_SaveBinaryContent(objHandle: HCkXml; filename: PWideChar; unzipFlag: wordbool; decryptFlag: wordbool; password: PWideChar): wordbool;
function CkXml_SaveXml(objHandle: HCkXml; fileName: PWideChar): wordbool;
procedure CkXml_Scrub(objHandle: HCkXml; directives: PWideChar);
function CkXml_SearchAllForContent(objHandle: HCkXml; afterPtr: HCkXml; contentPattern: PWideChar): HCkXml;
function CkXml_SearchAllForContent2(objHandle: HCkXml; afterPtr: HCkXml; contentPattern: PWideChar): wordbool;
function CkXml_SearchForAttribute(objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; attr: PWideChar; valuePattern: PWideChar): HCkXml;
function CkXml_SearchForAttribute2(objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; attr: PWideChar; valuePattern: PWideChar): wordbool;
function CkXml_SearchForContent(objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; contentPattern: PWideChar): HCkXml;
function CkXml_SearchForContent2(objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; contentPattern: PWideChar): wordbool;
function CkXml_SearchForTag(objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar): HCkXml;
function CkXml_SearchForTag2(objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar): wordbool;
function CkXml_SetBinaryContent(objHandle: HCkXml; inData: HCkByteData; zipFlag: wordbool; encryptFlag: wordbool; password: PWideChar): wordbool;
function CkXml_SetBinaryContentBd(objHandle: HCkXml; data: HCkBinData; zipFlag: wordbool; encryptFlag: wordbool; password: PWideChar): wordbool;
function CkXml_SetBinaryContentFromFile(objHandle: HCkXml; filename: PWideChar; zipFlag: wordbool; encryptFlag: wordbool; password: PWideChar): wordbool;
procedure CkXml_SortByAttribute(objHandle: HCkXml; attrName: PWideChar; ascending: wordbool);
procedure CkXml_SortByAttributeInt(objHandle: HCkXml; attrName: PWideChar; ascending: wordbool);
procedure CkXml_SortByContent(objHandle: HCkXml; ascending: wordbool);
procedure CkXml_SortByTag(objHandle: HCkXml; ascending: wordbool);
procedure CkXml_SortRecordsByAttribute(objHandle: HCkXml; sortTag: PWideChar; attrName: PWideChar; ascending: wordbool);
procedure CkXml_SortRecordsByContent(objHandle: HCkXml; sortTag: PWideChar; ascending: wordbool);
procedure CkXml_SortRecordsByContentInt(objHandle: HCkXml; sortTag: PWideChar; ascending: wordbool);
function CkXml_SwapNode(objHandle: HCkXml; node: HCkXml): wordbool;
function CkXml_SwapTree(objHandle: HCkXml; tree: HCkXml): wordbool;
function CkXml_TagContent(objHandle: HCkXml; tagName: PWideChar; outStr: HCkString): wordbool;
function CkXml__tagContent(objHandle: HCkXml; tagName: PWideChar): PWideChar;
function CkXml_TagEquals(objHandle: HCkXml; tag: PWideChar): wordbool;
function CkXml_TagIndex(objHandle: HCkXml; tagPath: PWideChar): Integer;
function CkXml_TagNsEquals(objHandle: HCkXml; ns: PWideChar): wordbool;
function CkXml_TagUnpEquals(objHandle: HCkXml; unprefixedTag: PWideChar): wordbool;
function CkXml_UnzipContent(objHandle: HCkXml): wordbool;
function CkXml_UnzipTree(objHandle: HCkXml): wordbool;
function CkXml_UpdateAt(objHandle: HCkXml; tagPath: PWideChar; autoCreate: wordbool; value: PWideChar): wordbool;
function CkXml_UpdateAttrAt(objHandle: HCkXml; tagPath: PWideChar; autoCreate: wordbool; attrName: PWideChar; attrValue: PWideChar): wordbool;
function CkXml_UpdateAttribute(objHandle: HCkXml; attrName: PWideChar; attrValue: PWideChar): wordbool;
function CkXml_UpdateAttributeInt(objHandle: HCkXml; attrName: PWideChar; value: Integer): wordbool;
procedure CkXml_UpdateChildContent(objHandle: HCkXml; tagPath: PWideChar; value: PWideChar);
procedure CkXml_UpdateChildContentInt(objHandle: HCkXml; tagPath: PWideChar; value: Integer);
function CkXml_ZipContent(objHandle: HCkXml): wordbool;
function CkXml_ZipTree(objHandle: HCkXml): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkXml_Create = function : HCkXml; stdcall;
  TCkXml_Dispose = procedure (handle: HCkXml); stdcall;
  TCkXml_getCdata = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_putCdata = procedure (objHandle: HCkXml; newPropVal: wordbool); stdcall;
  TCkXml_getContent = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml_putContent = procedure (objHandle: HCkXml; newPropVal: PWideChar); stdcall;
  TCkXml__content = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getContentInt = function (objHandle: HCkXml): Integer; stdcall;
  TCkXml_putContentInt = procedure (objHandle: HCkXml; newPropVal: Integer); stdcall;
  TCkXml_getDebugLogFilePath = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml_putDebugLogFilePath = procedure (objHandle: HCkXml; newPropVal: PWideChar); stdcall;
  TCkXml__debugLogFilePath = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getDocType = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml_putDocType = procedure (objHandle: HCkXml; newPropVal: PWideChar); stdcall;
  TCkXml__docType = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getEmitBom = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_putEmitBom = procedure (objHandle: HCkXml; newPropVal: wordbool); stdcall;
  TCkXml_getEmitCompact = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_putEmitCompact = procedure (objHandle: HCkXml; newPropVal: wordbool); stdcall;
  TCkXml_getEmitXmlDecl = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_putEmitXmlDecl = procedure (objHandle: HCkXml; newPropVal: wordbool); stdcall;
  TCkXml_getEncoding = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml_putEncoding = procedure (objHandle: HCkXml; newPropVal: PWideChar); stdcall;
  TCkXml__encoding = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getI = function (objHandle: HCkXml): Integer; stdcall;
  TCkXml_putI = procedure (objHandle: HCkXml; newPropVal: Integer); stdcall;
  TCkXml_getIsBase64 = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_getJ = function (objHandle: HCkXml): Integer; stdcall;
  TCkXml_putJ = procedure (objHandle: HCkXml; newPropVal: Integer); stdcall;
  TCkXml_getK = function (objHandle: HCkXml): Integer; stdcall;
  TCkXml_putK = procedure (objHandle: HCkXml; newPropVal: Integer); stdcall;
  TCkXml_getLastErrorHtml = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml__lastErrorHtml = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getLastErrorText = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml__lastErrorText = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getLastErrorXml = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml__lastErrorXml = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getLastMethodSuccess = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_putLastMethodSuccess = procedure (objHandle: HCkXml; newPropVal: wordbool); stdcall;
  TCkXml_getNumAttributes = function (objHandle: HCkXml): Integer; stdcall;
  TCkXml_getNumChildren = function (objHandle: HCkXml): Integer; stdcall;
  TCkXml_getSortCaseInsensitive = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_putSortCaseInsensitive = procedure (objHandle: HCkXml; newPropVal: wordbool); stdcall;
  TCkXml_getStandalone = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_putStandalone = procedure (objHandle: HCkXml; newPropVal: wordbool); stdcall;
  TCkXml_getTag = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml_putTag = procedure (objHandle: HCkXml; newPropVal: PWideChar); stdcall;
  TCkXml__tag = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getTagNsPrefix = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml_putTagNsPrefix = procedure (objHandle: HCkXml; newPropVal: PWideChar); stdcall;
  TCkXml__tagNsPrefix = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getTagPath = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml__tagPath = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getTagUnprefixed = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml_putTagUnprefixed = procedure (objHandle: HCkXml; newPropVal: PWideChar); stdcall;
  TCkXml__tagUnprefixed = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getTreeId = function (objHandle: HCkXml): Integer; stdcall;
  TCkXml_getUncommonOptions = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml_putUncommonOptions = procedure (objHandle: HCkXml; newPropVal: PWideChar); stdcall;
  TCkXml__uncommonOptions = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_getVerboseLogging = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_putVerboseLogging = procedure (objHandle: HCkXml; newPropVal: wordbool); stdcall;
  TCkXml_getVersion = procedure (objHandle: HCkXml; outPropVal: HCkString); stdcall;
  TCkXml__version = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_AccumulateTagContent = function (objHandle: HCkXml; tag: PWideChar; skipTags: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkXml__accumulateTagContent = function (objHandle: HCkXml; tag: PWideChar; skipTags: PWideChar): PWideChar; stdcall;
  TCkXml_AddAttribute = function (objHandle: HCkXml; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkXml_AddAttributeInt = function (objHandle: HCkXml; name: PWideChar; value: Integer): wordbool; stdcall;
  TCkXml_AddChildTree = function (objHandle: HCkXml; tree: HCkXml): wordbool; stdcall;
  TCkXml_AddOrUpdateAttribute = procedure (objHandle: HCkXml; name: PWideChar; value: PWideChar); stdcall;
  TCkXml_AddOrUpdateAttributeI = procedure (objHandle: HCkXml; name: PWideChar; value: Integer); stdcall;
  TCkXml_AddStyleSheet = procedure (objHandle: HCkXml; styleSheet: PWideChar); stdcall;
  TCkXml_AddToAttribute = procedure (objHandle: HCkXml; name: PWideChar; amount: Integer); stdcall;
  TCkXml_AddToChildContent = procedure (objHandle: HCkXml; tag: PWideChar; amount: Integer); stdcall;
  TCkXml_AddToContent = procedure (objHandle: HCkXml; amount: Integer); stdcall;
  TCkXml_AppendToContent = function (objHandle: HCkXml; str: PWideChar): wordbool; stdcall;
  TCkXml_BEncodeContent = function (objHandle: HCkXml; charset: PWideChar; inData: HCkByteData): wordbool; stdcall;
  TCkXml_ChildContentMatches = function (objHandle: HCkXml; tagPath: PWideChar; pattern: PWideChar; caseSensitive: wordbool): wordbool; stdcall;
  TCkXml_ChilkatPath = function (objHandle: HCkXml; pathCmd: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkXml__chilkatPath = function (objHandle: HCkXml; pathCmd: PWideChar): PWideChar; stdcall;
  TCkXml_Clear = procedure (objHandle: HCkXml); stdcall;
  TCkXml_ContentMatches = function (objHandle: HCkXml; pattern: PWideChar; caseSensitive: wordbool): wordbool; stdcall;
  TCkXml_Copy = procedure (objHandle: HCkXml; node: HCkXml); stdcall;
  TCkXml_CopyRef = procedure (objHandle: HCkXml; copyFromNode: HCkXml); stdcall;
  TCkXml_DecodeContent = function (objHandle: HCkXml; outData: HCkByteData): wordbool; stdcall;
  TCkXml_DecodeEntities = function (objHandle: HCkXml; str: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkXml__decodeEntities = function (objHandle: HCkXml; str: PWideChar): PWideChar; stdcall;
  TCkXml_DecryptContent = function (objHandle: HCkXml; password: PWideChar): wordbool; stdcall;
  TCkXml_EncryptContent = function (objHandle: HCkXml; password: PWideChar): wordbool; stdcall;
  TCkXml_ExtractChildByIndex = function (objHandle: HCkXml; index: Integer): HCkXml; stdcall;
  TCkXml_ExtractChildByName = function (objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar; attrValue: PWideChar): HCkXml; stdcall;
  TCkXml_FindChild = function (objHandle: HCkXml; tagPath: PWideChar): HCkXml; stdcall;
  TCkXml_FindChild2 = function (objHandle: HCkXml; tagPath: PWideChar): wordbool; stdcall;
  TCkXml_FindNextRecord = function (objHandle: HCkXml; tagPath: PWideChar; contentPattern: PWideChar): HCkXml; stdcall;
  TCkXml_FindOrAddNewChild = function (objHandle: HCkXml; tagPath: PWideChar): HCkXml; stdcall;
  TCkXml_FirstChild = function (objHandle: HCkXml): HCkXml; stdcall;
  TCkXml_FirstChild2 = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_GetAttributeName = function (objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkXml__getAttributeName = function (objHandle: HCkXml; index: Integer): PWideChar; stdcall;
  TCkXml_GetAttributeValue = function (objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkXml__getAttributeValue = function (objHandle: HCkXml; index: Integer): PWideChar; stdcall;
  TCkXml_GetAttributeValueInt = function (objHandle: HCkXml; index: Integer): Integer; stdcall;
  TCkXml_GetAttrValue = function (objHandle: HCkXml; name: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkXml__getAttrValue = function (objHandle: HCkXml; name: PWideChar): PWideChar; stdcall;
  TCkXml_GetAttrValueInt = function (objHandle: HCkXml; name: PWideChar): Integer; stdcall;
  TCkXml_GetBinaryContent = function (objHandle: HCkXml; unzipFlag: wordbool; decryptFlag: wordbool; password: PWideChar; outData: HCkByteData): wordbool; stdcall;
  TCkXml_GetChild = function (objHandle: HCkXml; index: Integer): HCkXml; stdcall;
  TCkXml_GetChild2 = function (objHandle: HCkXml; index: Integer): wordbool; stdcall;
  TCkXml_GetChildAttrValue = function (objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkXml__getChildAttrValue = function (objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar): PWideChar; stdcall;
  TCkXml_GetChildBoolValue = function (objHandle: HCkXml; tagPath: PWideChar): wordbool; stdcall;
  TCkXml_GetChildContent = function (objHandle: HCkXml; tagPath: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkXml__getChildContent = function (objHandle: HCkXml; tagPath: PWideChar): PWideChar; stdcall;
  TCkXml_GetChildContentByIndex = function (objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkXml__getChildContentByIndex = function (objHandle: HCkXml; index: Integer): PWideChar; stdcall;
  TCkXml_GetChildContentSb = function (objHandle: HCkXml; tagPath: PWideChar; sb: HCkStringBuilder): wordbool; stdcall;
  TCkXml_GetChildExact = function (objHandle: HCkXml; tag: PWideChar; content: PWideChar): HCkXml; stdcall;
  TCkXml_GetChildIntValue = function (objHandle: HCkXml; tagPath: PWideChar): Integer; stdcall;
  TCkXml_GetChildTag = function (objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkXml__getChildTag = function (objHandle: HCkXml; index: Integer): PWideChar; stdcall;
  TCkXml_GetChildTagByIndex = function (objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkXml__getChildTagByIndex = function (objHandle: HCkXml; index: Integer): PWideChar; stdcall;
  TCkXml_GetChildWithAttr = function (objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar; attrValue: PWideChar): HCkXml; stdcall;
  TCkXml_GetChildWithContent = function (objHandle: HCkXml; content: PWideChar): HCkXml; stdcall;
  TCkXml_GetChildWithTag = function (objHandle: HCkXml; tagPath: PWideChar): HCkXml; stdcall;
  TCkXml_GetChildWithTag2 = function (objHandle: HCkXml; tagPath: PWideChar): wordbool; stdcall;
  TCkXml_GetNthChildWithTag = function (objHandle: HCkXml; tag: PWideChar; n: Integer): HCkXml; stdcall;
  TCkXml_GetNthChildWithTag2 = function (objHandle: HCkXml; tag: PWideChar; n: Integer): wordbool; stdcall;
  TCkXml_GetParent = function (objHandle: HCkXml): HCkXml; stdcall;
  TCkXml_GetParent2 = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_GetRoot = function (objHandle: HCkXml): HCkXml; stdcall;
  TCkXml_GetRoot2 = procedure (objHandle: HCkXml); stdcall;
  TCkXml_GetSelf = function (objHandle: HCkXml): HCkXml; stdcall;
  TCkXml_GetXml = function (objHandle: HCkXml; outStr: HCkString): wordbool; stdcall;
  TCkXml__getXml = function (objHandle: HCkXml): PWideChar; stdcall;
  TCkXml_GetXmlBd = function (objHandle: HCkXml; bd: HCkBinData): wordbool; stdcall;
  TCkXml_GetXmlSb = function (objHandle: HCkXml; sb: HCkStringBuilder): wordbool; stdcall;
  TCkXml_HasAttribute = function (objHandle: HCkXml; name: PWideChar): wordbool; stdcall;
  TCkXml_HasAttrWithValue = function (objHandle: HCkXml; name: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkXml_HasChildWithContent = function (objHandle: HCkXml; content: PWideChar): wordbool; stdcall;
  TCkXml_HasChildWithTag = function (objHandle: HCkXml; tagPath: PWideChar): wordbool; stdcall;
  TCkXml_HasChildWithTagAndContent = function (objHandle: HCkXml; tagPath: PWideChar; content: PWideChar): wordbool; stdcall;
  TCkXml_InsertChildTreeAfter = procedure (objHandle: HCkXml; index: Integer; tree: HCkXml); stdcall;
  TCkXml_InsertChildTreeBefore = procedure (objHandle: HCkXml; index: Integer; tree: HCkXml); stdcall;
  TCkXml_LastChild = function (objHandle: HCkXml): HCkXml; stdcall;
  TCkXml_LastChild2 = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_LoadBd = function (objHandle: HCkXml; bd: HCkBinData; autoTrim: wordbool): wordbool; stdcall;
  TCkXml_LoadSb = function (objHandle: HCkXml; sb: HCkStringBuilder; autoTrim: wordbool): wordbool; stdcall;
  TCkXml_LoadXml = function (objHandle: HCkXml; xmlData: PWideChar): wordbool; stdcall;
  TCkXml_LoadXml2 = function (objHandle: HCkXml; xmlData: PWideChar; autoTrim: wordbool): wordbool; stdcall;
  TCkXml_LoadXmlFile = function (objHandle: HCkXml; fileName: PWideChar): wordbool; stdcall;
  TCkXml_LoadXmlFile2 = function (objHandle: HCkXml; fileName: PWideChar; autoTrim: wordbool): wordbool; stdcall;
  TCkXml_NewChild = function (objHandle: HCkXml; tagPath: PWideChar; content: PWideChar): HCkXml; stdcall;
  TCkXml_NewChild2 = procedure (objHandle: HCkXml; tagPath: PWideChar; content: PWideChar); stdcall;
  TCkXml_NewChildAfter = function (objHandle: HCkXml; index: Integer; tag: PWideChar; content: PWideChar): HCkXml; stdcall;
  TCkXml_NewChildBefore = function (objHandle: HCkXml; index: Integer; tag: PWideChar; content: PWideChar): HCkXml; stdcall;
  TCkXml_NewChildInt2 = procedure (objHandle: HCkXml; tagPath: PWideChar; value: Integer); stdcall;
  TCkXml_NextInTraversal2 = function (objHandle: HCkXml; sbState: HCkStringBuilder): wordbool; stdcall;
  TCkXml_NextSibling = function (objHandle: HCkXml): HCkXml; stdcall;
  TCkXml_NextSibling2 = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_NumChildrenAt = function (objHandle: HCkXml; tagPath: PWideChar): Integer; stdcall;
  TCkXml_NumChildrenHavingTag = function (objHandle: HCkXml; tag: PWideChar): Integer; stdcall;
  TCkXml_PreviousSibling = function (objHandle: HCkXml): HCkXml; stdcall;
  TCkXml_PreviousSibling2 = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_PruneAttribute = function (objHandle: HCkXml; attrName: PWideChar): Integer; stdcall;
  TCkXml_PruneTag = function (objHandle: HCkXml; tag: PWideChar): Integer; stdcall;
  TCkXml_QEncodeContent = function (objHandle: HCkXml; charset: PWideChar; inData: HCkByteData): wordbool; stdcall;
  TCkXml_RemoveAllAttributes = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_RemoveAllChildren = procedure (objHandle: HCkXml); stdcall;
  TCkXml_RemoveAttribute = function (objHandle: HCkXml; name: PWideChar): wordbool; stdcall;
  TCkXml_RemoveChild = procedure (objHandle: HCkXml; tagPath: PWideChar); stdcall;
  TCkXml_RemoveChildByIndex = procedure (objHandle: HCkXml; index: Integer); stdcall;
  TCkXml_RemoveChildWithContent = procedure (objHandle: HCkXml; content: PWideChar); stdcall;
  TCkXml_RemoveFromTree = procedure (objHandle: HCkXml); stdcall;
  TCkXml_RemoveStyleSheet = function (objHandle: HCkXml; attrName: PWideChar; attrValue: PWideChar): Integer; stdcall;
  TCkXml_SaveBinaryContent = function (objHandle: HCkXml; filename: PWideChar; unzipFlag: wordbool; decryptFlag: wordbool; password: PWideChar): wordbool; stdcall;
  TCkXml_SaveXml = function (objHandle: HCkXml; fileName: PWideChar): wordbool; stdcall;
  TCkXml_Scrub = procedure (objHandle: HCkXml; directives: PWideChar); stdcall;
  TCkXml_SearchAllForContent = function (objHandle: HCkXml; afterPtr: HCkXml; contentPattern: PWideChar): HCkXml; stdcall;
  TCkXml_SearchAllForContent2 = function (objHandle: HCkXml; afterPtr: HCkXml; contentPattern: PWideChar): wordbool; stdcall;
  TCkXml_SearchForAttribute = function (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; attr: PWideChar; valuePattern: PWideChar): HCkXml; stdcall;
  TCkXml_SearchForAttribute2 = function (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; attr: PWideChar; valuePattern: PWideChar): wordbool; stdcall;
  TCkXml_SearchForContent = function (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; contentPattern: PWideChar): HCkXml; stdcall;
  TCkXml_SearchForContent2 = function (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; contentPattern: PWideChar): wordbool; stdcall;
  TCkXml_SearchForTag = function (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar): HCkXml; stdcall;
  TCkXml_SearchForTag2 = function (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar): wordbool; stdcall;
  TCkXml_SetBinaryContent = function (objHandle: HCkXml; inData: HCkByteData; zipFlag: wordbool; encryptFlag: wordbool; password: PWideChar): wordbool; stdcall;
  TCkXml_SetBinaryContentBd = function (objHandle: HCkXml; data: HCkBinData; zipFlag: wordbool; encryptFlag: wordbool; password: PWideChar): wordbool; stdcall;
  TCkXml_SetBinaryContentFromFile = function (objHandle: HCkXml; filename: PWideChar; zipFlag: wordbool; encryptFlag: wordbool; password: PWideChar): wordbool; stdcall;
  TCkXml_SortByAttribute = procedure (objHandle: HCkXml; attrName: PWideChar; ascending: wordbool); stdcall;
  TCkXml_SortByAttributeInt = procedure (objHandle: HCkXml; attrName: PWideChar; ascending: wordbool); stdcall;
  TCkXml_SortByContent = procedure (objHandle: HCkXml; ascending: wordbool); stdcall;
  TCkXml_SortByTag = procedure (objHandle: HCkXml; ascending: wordbool); stdcall;
  TCkXml_SortRecordsByAttribute = procedure (objHandle: HCkXml; sortTag: PWideChar; attrName: PWideChar; ascending: wordbool); stdcall;
  TCkXml_SortRecordsByContent = procedure (objHandle: HCkXml; sortTag: PWideChar; ascending: wordbool); stdcall;
  TCkXml_SortRecordsByContentInt = procedure (objHandle: HCkXml; sortTag: PWideChar; ascending: wordbool); stdcall;
  TCkXml_SwapNode = function (objHandle: HCkXml; node: HCkXml): wordbool; stdcall;
  TCkXml_SwapTree = function (objHandle: HCkXml; tree: HCkXml): wordbool; stdcall;
  TCkXml_TagContent = function (objHandle: HCkXml; tagName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkXml__tagContent = function (objHandle: HCkXml; tagName: PWideChar): PWideChar; stdcall;
  TCkXml_TagEquals = function (objHandle: HCkXml; tag: PWideChar): wordbool; stdcall;
  TCkXml_TagIndex = function (objHandle: HCkXml; tagPath: PWideChar): Integer; stdcall;
  TCkXml_TagNsEquals = function (objHandle: HCkXml; ns: PWideChar): wordbool; stdcall;
  TCkXml_TagUnpEquals = function (objHandle: HCkXml; unprefixedTag: PWideChar): wordbool; stdcall;
  TCkXml_UnzipContent = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_UnzipTree = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_UpdateAt = function (objHandle: HCkXml; tagPath: PWideChar; autoCreate: wordbool; value: PWideChar): wordbool; stdcall;
  TCkXml_UpdateAttrAt = function (objHandle: HCkXml; tagPath: PWideChar; autoCreate: wordbool; attrName: PWideChar; attrValue: PWideChar): wordbool; stdcall;
  TCkXml_UpdateAttribute = function (objHandle: HCkXml; attrName: PWideChar; attrValue: PWideChar): wordbool; stdcall;
  TCkXml_UpdateAttributeInt = function (objHandle: HCkXml; attrName: PWideChar; value: Integer): wordbool; stdcall;
  TCkXml_UpdateChildContent = procedure (objHandle: HCkXml; tagPath: PWideChar; value: PWideChar); stdcall;
  TCkXml_UpdateChildContentInt = procedure (objHandle: HCkXml; tagPath: PWideChar; value: Integer); stdcall;
  TCkXml_ZipContent = function (objHandle: HCkXml): wordbool; stdcall;
  TCkXml_ZipTree = function (objHandle: HCkXml): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..213] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkXml_Create : HCkXml;
begin
  result := TCkXml_Create(_map(0, 'CkXml_Create'));
end;

procedure CkXml_Dispose (handle: HCkXml);
begin
  TCkXml_Dispose(_map(1, 'CkXml_Dispose'))
    (handle);
end;


function CkXml_getCdata (objHandle: HCkXml): wordbool;
begin
    result := TCkXml_getCdata(_map(2, 'CkXml_getCdata'))
    (objHandle);
end;

procedure CkXml_putCdata (objHandle: HCkXml; newPropVal: wordbool);
begin
  TCkXml_putCdata(_map(3, 'CkXml_putCdata'))
    (objHandle, newPropVal);
end;

procedure CkXml_getContent (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getContent(_map(4, 'CkXml_getContent'))
    (objHandle, outPropVal);
end;

procedure CkXml_putContent (objHandle: HCkXml; newPropVal: PWideChar);
begin
  TCkXml_putContent(_map(5, 'CkXml_putContent'))
    (objHandle, newPropVal);
end;

function CkXml__content (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__content(_map(6, 'CkXml__content'))
    (objHandle);
end;

function CkXml_getContentInt (objHandle: HCkXml): Integer;
begin
    result := TCkXml_getContentInt(_map(7, 'CkXml_getContentInt'))
    (objHandle);
end;

procedure CkXml_putContentInt (objHandle: HCkXml; newPropVal: Integer);
begin
  TCkXml_putContentInt(_map(8, 'CkXml_putContentInt'))
    (objHandle, newPropVal);
end;

procedure CkXml_getDebugLogFilePath (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getDebugLogFilePath(_map(9, 'CkXml_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkXml_putDebugLogFilePath (objHandle: HCkXml; newPropVal: PWideChar);
begin
  TCkXml_putDebugLogFilePath(_map(10, 'CkXml_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkXml__debugLogFilePath (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__debugLogFilePath(_map(11, 'CkXml__debugLogFilePath'))
    (objHandle);
end;

procedure CkXml_getDocType (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getDocType(_map(12, 'CkXml_getDocType'))
    (objHandle, outPropVal);
end;

procedure CkXml_putDocType (objHandle: HCkXml; newPropVal: PWideChar);
begin
  TCkXml_putDocType(_map(13, 'CkXml_putDocType'))
    (objHandle, newPropVal);
end;

function CkXml__docType (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__docType(_map(14, 'CkXml__docType'))
    (objHandle);
end;

function CkXml_getEmitBom (objHandle: HCkXml): wordbool;
begin
    result := TCkXml_getEmitBom(_map(15, 'CkXml_getEmitBom'))
    (objHandle);
end;

procedure CkXml_putEmitBom (objHandle: HCkXml; newPropVal: wordbool);
begin
  TCkXml_putEmitBom(_map(16, 'CkXml_putEmitBom'))
    (objHandle, newPropVal);
end;

function CkXml_getEmitCompact (objHandle: HCkXml): wordbool;
begin
    result := TCkXml_getEmitCompact(_map(17, 'CkXml_getEmitCompact'))
    (objHandle);
end;

procedure CkXml_putEmitCompact (objHandle: HCkXml; newPropVal: wordbool);
begin
  TCkXml_putEmitCompact(_map(18, 'CkXml_putEmitCompact'))
    (objHandle, newPropVal);
end;

function CkXml_getEmitXmlDecl (objHandle: HCkXml): wordbool;
begin
    result := TCkXml_getEmitXmlDecl(_map(19, 'CkXml_getEmitXmlDecl'))
    (objHandle);
end;

procedure CkXml_putEmitXmlDecl (objHandle: HCkXml; newPropVal: wordbool);
begin
  TCkXml_putEmitXmlDecl(_map(20, 'CkXml_putEmitXmlDecl'))
    (objHandle, newPropVal);
end;

procedure CkXml_getEncoding (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getEncoding(_map(21, 'CkXml_getEncoding'))
    (objHandle, outPropVal);
end;

procedure CkXml_putEncoding (objHandle: HCkXml; newPropVal: PWideChar);
begin
  TCkXml_putEncoding(_map(22, 'CkXml_putEncoding'))
    (objHandle, newPropVal);
end;

function CkXml__encoding (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__encoding(_map(23, 'CkXml__encoding'))
    (objHandle);
end;

function CkXml_getI (objHandle: HCkXml): Integer;
begin
    result := TCkXml_getI(_map(24, 'CkXml_getI'))
    (objHandle);
end;

procedure CkXml_putI (objHandle: HCkXml; newPropVal: Integer);
begin
  TCkXml_putI(_map(25, 'CkXml_putI'))
    (objHandle, newPropVal);
end;

function CkXml_getIsBase64 (objHandle: HCkXml): wordbool;
begin
    result := TCkXml_getIsBase64(_map(26, 'CkXml_getIsBase64'))
    (objHandle);
end;

function CkXml_getJ (objHandle: HCkXml): Integer;
begin
    result := TCkXml_getJ(_map(27, 'CkXml_getJ'))
    (objHandle);
end;

procedure CkXml_putJ (objHandle: HCkXml; newPropVal: Integer);
begin
  TCkXml_putJ(_map(28, 'CkXml_putJ'))
    (objHandle, newPropVal);
end;

function CkXml_getK (objHandle: HCkXml): Integer;
begin
    result := TCkXml_getK(_map(29, 'CkXml_getK'))
    (objHandle);
end;

procedure CkXml_putK (objHandle: HCkXml; newPropVal: Integer);
begin
  TCkXml_putK(_map(30, 'CkXml_putK'))
    (objHandle, newPropVal);
end;

procedure CkXml_getLastErrorHtml (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getLastErrorHtml(_map(31, 'CkXml_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkXml__lastErrorHtml (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__lastErrorHtml(_map(32, 'CkXml__lastErrorHtml'))
    (objHandle);
end;

procedure CkXml_getLastErrorText (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getLastErrorText(_map(33, 'CkXml_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkXml__lastErrorText (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__lastErrorText(_map(34, 'CkXml__lastErrorText'))
    (objHandle);
end;

procedure CkXml_getLastErrorXml (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getLastErrorXml(_map(35, 'CkXml_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkXml__lastErrorXml (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__lastErrorXml(_map(36, 'CkXml__lastErrorXml'))
    (objHandle);
end;

function CkXml_getLastMethodSuccess (objHandle: HCkXml): wordbool;
begin
    result := TCkXml_getLastMethodSuccess(_map(37, 'CkXml_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkXml_putLastMethodSuccess (objHandle: HCkXml; newPropVal: wordbool);
begin
  TCkXml_putLastMethodSuccess(_map(38, 'CkXml_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkXml_getNumAttributes (objHandle: HCkXml): Integer;
begin
    result := TCkXml_getNumAttributes(_map(39, 'CkXml_getNumAttributes'))
    (objHandle);
end;

function CkXml_getNumChildren (objHandle: HCkXml): Integer;
begin
    result := TCkXml_getNumChildren(_map(40, 'CkXml_getNumChildren'))
    (objHandle);
end;

function CkXml_getSortCaseInsensitive (objHandle: HCkXml): wordbool;
begin
    result := TCkXml_getSortCaseInsensitive(_map(41, 'CkXml_getSortCaseInsensitive'))
    (objHandle);
end;

procedure CkXml_putSortCaseInsensitive (objHandle: HCkXml; newPropVal: wordbool);
begin
  TCkXml_putSortCaseInsensitive(_map(42, 'CkXml_putSortCaseInsensitive'))
    (objHandle, newPropVal);
end;

function CkXml_getStandalone (objHandle: HCkXml): wordbool;
begin
    result := TCkXml_getStandalone(_map(43, 'CkXml_getStandalone'))
    (objHandle);
end;

procedure CkXml_putStandalone (objHandle: HCkXml; newPropVal: wordbool);
begin
  TCkXml_putStandalone(_map(44, 'CkXml_putStandalone'))
    (objHandle, newPropVal);
end;

procedure CkXml_getTag (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getTag(_map(45, 'CkXml_getTag'))
    (objHandle, outPropVal);
end;

procedure CkXml_putTag (objHandle: HCkXml; newPropVal: PWideChar);
begin
  TCkXml_putTag(_map(46, 'CkXml_putTag'))
    (objHandle, newPropVal);
end;

function CkXml__tag (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__tag(_map(47, 'CkXml__tag'))
    (objHandle);
end;

procedure CkXml_getTagNsPrefix (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getTagNsPrefix(_map(48, 'CkXml_getTagNsPrefix'))
    (objHandle, outPropVal);
end;

procedure CkXml_putTagNsPrefix (objHandle: HCkXml; newPropVal: PWideChar);
begin
  TCkXml_putTagNsPrefix(_map(49, 'CkXml_putTagNsPrefix'))
    (objHandle, newPropVal);
end;

function CkXml__tagNsPrefix (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__tagNsPrefix(_map(50, 'CkXml__tagNsPrefix'))
    (objHandle);
end;

procedure CkXml_getTagPath (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getTagPath(_map(51, 'CkXml_getTagPath'))
    (objHandle, outPropVal);
end;

function CkXml__tagPath (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__tagPath(_map(52, 'CkXml__tagPath'))
    (objHandle);
end;

procedure CkXml_getTagUnprefixed (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getTagUnprefixed(_map(53, 'CkXml_getTagUnprefixed'))
    (objHandle, outPropVal);
end;

procedure CkXml_putTagUnprefixed (objHandle: HCkXml; newPropVal: PWideChar);
begin
  TCkXml_putTagUnprefixed(_map(54, 'CkXml_putTagUnprefixed'))
    (objHandle, newPropVal);
end;

function CkXml__tagUnprefixed (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__tagUnprefixed(_map(55, 'CkXml__tagUnprefixed'))
    (objHandle);
end;

function CkXml_getTreeId (objHandle: HCkXml): Integer;
begin
    result := TCkXml_getTreeId(_map(56, 'CkXml_getTreeId'))
    (objHandle);
end;

procedure CkXml_getUncommonOptions (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getUncommonOptions(_map(57, 'CkXml_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkXml_putUncommonOptions (objHandle: HCkXml; newPropVal: PWideChar);
begin
  TCkXml_putUncommonOptions(_map(58, 'CkXml_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkXml__uncommonOptions (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__uncommonOptions(_map(59, 'CkXml__uncommonOptions'))
    (objHandle);
end;

function CkXml_getVerboseLogging (objHandle: HCkXml): wordbool;
begin
    result := TCkXml_getVerboseLogging(_map(60, 'CkXml_getVerboseLogging'))
    (objHandle);
end;

procedure CkXml_putVerboseLogging (objHandle: HCkXml; newPropVal: wordbool);
begin
  TCkXml_putVerboseLogging(_map(61, 'CkXml_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkXml_getVersion (objHandle: HCkXml; outPropVal: HCkString);
begin
  TCkXml_getVersion(_map(62, 'CkXml_getVersion'))
    (objHandle, outPropVal);
end;

function CkXml__version (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__version(_map(63, 'CkXml__version'))
    (objHandle);
end;

function CkXml_AccumulateTagContent (objHandle: HCkXml; tag: PWideChar; skipTags: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkXml_AccumulateTagContent(_map(64, 'CkXml_AccumulateTagContent'))
    (objHandle, tag, skipTags, outStr);
end;

function CkXml__accumulateTagContent (objHandle: HCkXml; tag: PWideChar; skipTags: PWideChar): PWideChar;
begin
  result := TCkXml__accumulateTagContent(_map(65, 'CkXml__accumulateTagContent'))
    (objHandle, tag, skipTags);
end;

function CkXml_AddAttribute (objHandle: HCkXml; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkXml_AddAttribute(_map(66, 'CkXml_AddAttribute'))
    (objHandle, name, value);
end;

function CkXml_AddAttributeInt (objHandle: HCkXml; name: PWideChar; value: Integer): wordbool;
begin
  result := TCkXml_AddAttributeInt(_map(67, 'CkXml_AddAttributeInt'))
    (objHandle, name, value);
end;

function CkXml_AddChildTree (objHandle: HCkXml; tree: HCkXml): wordbool;
begin
  result := TCkXml_AddChildTree(_map(68, 'CkXml_AddChildTree'))
    (objHandle, tree);
end;

procedure CkXml_AddOrUpdateAttribute (objHandle: HCkXml; name: PWideChar; value: PWideChar);
begin
  TCkXml_AddOrUpdateAttribute(_map(69, 'CkXml_AddOrUpdateAttribute'))
    (objHandle, name, value);
end;

procedure CkXml_AddOrUpdateAttributeI (objHandle: HCkXml; name: PWideChar; value: Integer);
begin
  TCkXml_AddOrUpdateAttributeI(_map(70, 'CkXml_AddOrUpdateAttributeI'))
    (objHandle, name, value);
end;

procedure CkXml_AddStyleSheet (objHandle: HCkXml; styleSheet: PWideChar);
begin
  TCkXml_AddStyleSheet(_map(71, 'CkXml_AddStyleSheet'))
    (objHandle, styleSheet);
end;

procedure CkXml_AddToAttribute (objHandle: HCkXml; name: PWideChar; amount: Integer);
begin
  TCkXml_AddToAttribute(_map(72, 'CkXml_AddToAttribute'))
    (objHandle, name, amount);
end;

procedure CkXml_AddToChildContent (objHandle: HCkXml; tag: PWideChar; amount: Integer);
begin
  TCkXml_AddToChildContent(_map(73, 'CkXml_AddToChildContent'))
    (objHandle, tag, amount);
end;

procedure CkXml_AddToContent (objHandle: HCkXml; amount: Integer);
begin
  TCkXml_AddToContent(_map(74, 'CkXml_AddToContent'))
    (objHandle, amount);
end;

function CkXml_AppendToContent (objHandle: HCkXml; str: PWideChar): wordbool;
begin
  result := TCkXml_AppendToContent(_map(75, 'CkXml_AppendToContent'))
    (objHandle, str);
end;

function CkXml_BEncodeContent (objHandle: HCkXml; charset: PWideChar; inData: HCkByteData): wordbool;
begin
  result := TCkXml_BEncodeContent(_map(76, 'CkXml_BEncodeContent'))
    (objHandle, charset, inData);
end;

function CkXml_ChildContentMatches (objHandle: HCkXml; tagPath: PWideChar; pattern: PWideChar; caseSensitive: wordbool): wordbool;
begin
  result := TCkXml_ChildContentMatches(_map(77, 'CkXml_ChildContentMatches'))
    (objHandle, tagPath, pattern, caseSensitive);
end;

function CkXml_ChilkatPath (objHandle: HCkXml; pathCmd: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkXml_ChilkatPath(_map(78, 'CkXml_ChilkatPath'))
    (objHandle, pathCmd, outStr);
end;

function CkXml__chilkatPath (objHandle: HCkXml; pathCmd: PWideChar): PWideChar;
begin
  result := TCkXml__chilkatPath(_map(79, 'CkXml__chilkatPath'))
    (objHandle, pathCmd);
end;

procedure CkXml_Clear (objHandle: HCkXml);
begin
  TCkXml_Clear(_map(80, 'CkXml_Clear'))
    (objHandle);
end;

function CkXml_ContentMatches (objHandle: HCkXml; pattern: PWideChar; caseSensitive: wordbool): wordbool;
begin
  result := TCkXml_ContentMatches(_map(81, 'CkXml_ContentMatches'))
    (objHandle, pattern, caseSensitive);
end;

procedure CkXml_Copy (objHandle: HCkXml; node: HCkXml);
begin
  TCkXml_Copy(_map(82, 'CkXml_Copy'))
    (objHandle, node);
end;

procedure CkXml_CopyRef (objHandle: HCkXml; copyFromNode: HCkXml);
begin
  TCkXml_CopyRef(_map(83, 'CkXml_CopyRef'))
    (objHandle, copyFromNode);
end;

function CkXml_DecodeContent (objHandle: HCkXml; outData: HCkByteData): wordbool;
begin
  result := TCkXml_DecodeContent(_map(84, 'CkXml_DecodeContent'))
    (objHandle, outData);
end;

function CkXml_DecodeEntities (objHandle: HCkXml; str: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkXml_DecodeEntities(_map(85, 'CkXml_DecodeEntities'))
    (objHandle, str, outStr);
end;

function CkXml__decodeEntities (objHandle: HCkXml; str: PWideChar): PWideChar;
begin
  result := TCkXml__decodeEntities(_map(86, 'CkXml__decodeEntities'))
    (objHandle, str);
end;

function CkXml_DecryptContent (objHandle: HCkXml; password: PWideChar): wordbool;
begin
  result := TCkXml_DecryptContent(_map(87, 'CkXml_DecryptContent'))
    (objHandle, password);
end;

function CkXml_EncryptContent (objHandle: HCkXml; password: PWideChar): wordbool;
begin
  result := TCkXml_EncryptContent(_map(88, 'CkXml_EncryptContent'))
    (objHandle, password);
end;

function CkXml_ExtractChildByIndex (objHandle: HCkXml; index: Integer): HCkXml;
begin
  result := TCkXml_ExtractChildByIndex(_map(89, 'CkXml_ExtractChildByIndex'))
    (objHandle, index);
end;

function CkXml_ExtractChildByName (objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar; attrValue: PWideChar): HCkXml;
begin
  result := TCkXml_ExtractChildByName(_map(90, 'CkXml_ExtractChildByName'))
    (objHandle, tagPath, attrName, attrValue);
end;

function CkXml_FindChild (objHandle: HCkXml; tagPath: PWideChar): HCkXml;
begin
  result := TCkXml_FindChild(_map(91, 'CkXml_FindChild'))
    (objHandle, tagPath);
end;

function CkXml_FindChild2 (objHandle: HCkXml; tagPath: PWideChar): wordbool;
begin
  result := TCkXml_FindChild2(_map(92, 'CkXml_FindChild2'))
    (objHandle, tagPath);
end;

function CkXml_FindNextRecord (objHandle: HCkXml; tagPath: PWideChar; contentPattern: PWideChar): HCkXml;
begin
  result := TCkXml_FindNextRecord(_map(93, 'CkXml_FindNextRecord'))
    (objHandle, tagPath, contentPattern);
end;

function CkXml_FindOrAddNewChild (objHandle: HCkXml; tagPath: PWideChar): HCkXml;
begin
  result := TCkXml_FindOrAddNewChild(_map(94, 'CkXml_FindOrAddNewChild'))
    (objHandle, tagPath);
end;

function CkXml_FirstChild (objHandle: HCkXml): HCkXml;
begin
  result := TCkXml_FirstChild(_map(95, 'CkXml_FirstChild'))
    (objHandle);
end;

function CkXml_FirstChild2 (objHandle: HCkXml): wordbool;
begin
  result := TCkXml_FirstChild2(_map(96, 'CkXml_FirstChild2'))
    (objHandle);
end;

function CkXml_GetAttributeName (objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkXml_GetAttributeName(_map(97, 'CkXml_GetAttributeName'))
    (objHandle, index, outStr);
end;

function CkXml__getAttributeName (objHandle: HCkXml; index: Integer): PWideChar;
begin
  result := TCkXml__getAttributeName(_map(98, 'CkXml__getAttributeName'))
    (objHandle, index);
end;

function CkXml_GetAttributeValue (objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkXml_GetAttributeValue(_map(99, 'CkXml_GetAttributeValue'))
    (objHandle, index, outStr);
end;

function CkXml__getAttributeValue (objHandle: HCkXml; index: Integer): PWideChar;
begin
  result := TCkXml__getAttributeValue(_map(100, 'CkXml__getAttributeValue'))
    (objHandle, index);
end;

function CkXml_GetAttributeValueInt (objHandle: HCkXml; index: Integer): Integer;
begin
  result := TCkXml_GetAttributeValueInt(_map(101, 'CkXml_GetAttributeValueInt'))
    (objHandle, index);
end;

function CkXml_GetAttrValue (objHandle: HCkXml; name: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkXml_GetAttrValue(_map(102, 'CkXml_GetAttrValue'))
    (objHandle, name, outStr);
end;

function CkXml__getAttrValue (objHandle: HCkXml; name: PWideChar): PWideChar;
begin
  result := TCkXml__getAttrValue(_map(103, 'CkXml__getAttrValue'))
    (objHandle, name);
end;

function CkXml_GetAttrValueInt (objHandle: HCkXml; name: PWideChar): Integer;
begin
  result := TCkXml_GetAttrValueInt(_map(104, 'CkXml_GetAttrValueInt'))
    (objHandle, name);
end;

function CkXml_GetBinaryContent (objHandle: HCkXml; unzipFlag: wordbool; decryptFlag: wordbool; password: PWideChar; outData: HCkByteData): wordbool;
begin
  result := TCkXml_GetBinaryContent(_map(105, 'CkXml_GetBinaryContent'))
    (objHandle, unzipFlag, decryptFlag, password, outData);
end;

function CkXml_GetChild (objHandle: HCkXml; index: Integer): HCkXml;
begin
  result := TCkXml_GetChild(_map(106, 'CkXml_GetChild'))
    (objHandle, index);
end;

function CkXml_GetChild2 (objHandle: HCkXml; index: Integer): wordbool;
begin
  result := TCkXml_GetChild2(_map(107, 'CkXml_GetChild2'))
    (objHandle, index);
end;

function CkXml_GetChildAttrValue (objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkXml_GetChildAttrValue(_map(108, 'CkXml_GetChildAttrValue'))
    (objHandle, tagPath, attrName, outStr);
end;

function CkXml__getChildAttrValue (objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar): PWideChar;
begin
  result := TCkXml__getChildAttrValue(_map(109, 'CkXml__getChildAttrValue'))
    (objHandle, tagPath, attrName);
end;

function CkXml_GetChildBoolValue (objHandle: HCkXml; tagPath: PWideChar): wordbool;
begin
  result := TCkXml_GetChildBoolValue(_map(110, 'CkXml_GetChildBoolValue'))
    (objHandle, tagPath);
end;

function CkXml_GetChildContent (objHandle: HCkXml; tagPath: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkXml_GetChildContent(_map(111, 'CkXml_GetChildContent'))
    (objHandle, tagPath, outStr);
end;

function CkXml__getChildContent (objHandle: HCkXml; tagPath: PWideChar): PWideChar;
begin
  result := TCkXml__getChildContent(_map(112, 'CkXml__getChildContent'))
    (objHandle, tagPath);
end;

function CkXml_GetChildContentByIndex (objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkXml_GetChildContentByIndex(_map(113, 'CkXml_GetChildContentByIndex'))
    (objHandle, index, outStr);
end;

function CkXml__getChildContentByIndex (objHandle: HCkXml; index: Integer): PWideChar;
begin
  result := TCkXml__getChildContentByIndex(_map(114, 'CkXml__getChildContentByIndex'))
    (objHandle, index);
end;

function CkXml_GetChildContentSb (objHandle: HCkXml; tagPath: PWideChar; sb: HCkStringBuilder): wordbool;
begin
  result := TCkXml_GetChildContentSb(_map(115, 'CkXml_GetChildContentSb'))
    (objHandle, tagPath, sb);
end;

function CkXml_GetChildExact (objHandle: HCkXml; tag: PWideChar; content: PWideChar): HCkXml;
begin
  result := TCkXml_GetChildExact(_map(116, 'CkXml_GetChildExact'))
    (objHandle, tag, content);
end;

function CkXml_GetChildIntValue (objHandle: HCkXml; tagPath: PWideChar): Integer;
begin
  result := TCkXml_GetChildIntValue(_map(117, 'CkXml_GetChildIntValue'))
    (objHandle, tagPath);
end;

function CkXml_GetChildTag (objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkXml_GetChildTag(_map(118, 'CkXml_GetChildTag'))
    (objHandle, index, outStr);
end;

function CkXml__getChildTag (objHandle: HCkXml; index: Integer): PWideChar;
begin
  result := TCkXml__getChildTag(_map(119, 'CkXml__getChildTag'))
    (objHandle, index);
end;

function CkXml_GetChildTagByIndex (objHandle: HCkXml; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkXml_GetChildTagByIndex(_map(120, 'CkXml_GetChildTagByIndex'))
    (objHandle, index, outStr);
end;

function CkXml__getChildTagByIndex (objHandle: HCkXml; index: Integer): PWideChar;
begin
  result := TCkXml__getChildTagByIndex(_map(121, 'CkXml__getChildTagByIndex'))
    (objHandle, index);
end;

function CkXml_GetChildWithAttr (objHandle: HCkXml; tagPath: PWideChar; attrName: PWideChar; attrValue: PWideChar): HCkXml;
begin
  result := TCkXml_GetChildWithAttr(_map(122, 'CkXml_GetChildWithAttr'))
    (objHandle, tagPath, attrName, attrValue);
end;

function CkXml_GetChildWithContent (objHandle: HCkXml; content: PWideChar): HCkXml;
begin
  result := TCkXml_GetChildWithContent(_map(123, 'CkXml_GetChildWithContent'))
    (objHandle, content);
end;

function CkXml_GetChildWithTag (objHandle: HCkXml; tagPath: PWideChar): HCkXml;
begin
  result := TCkXml_GetChildWithTag(_map(124, 'CkXml_GetChildWithTag'))
    (objHandle, tagPath);
end;

function CkXml_GetChildWithTag2 (objHandle: HCkXml; tagPath: PWideChar): wordbool;
begin
  result := TCkXml_GetChildWithTag2(_map(125, 'CkXml_GetChildWithTag2'))
    (objHandle, tagPath);
end;

function CkXml_GetNthChildWithTag (objHandle: HCkXml; tag: PWideChar; n: Integer): HCkXml;
begin
  result := TCkXml_GetNthChildWithTag(_map(126, 'CkXml_GetNthChildWithTag'))
    (objHandle, tag, n);
end;

function CkXml_GetNthChildWithTag2 (objHandle: HCkXml; tag: PWideChar; n: Integer): wordbool;
begin
  result := TCkXml_GetNthChildWithTag2(_map(127, 'CkXml_GetNthChildWithTag2'))
    (objHandle, tag, n);
end;

function CkXml_GetParent (objHandle: HCkXml): HCkXml;
begin
  result := TCkXml_GetParent(_map(128, 'CkXml_GetParent'))
    (objHandle);
end;

function CkXml_GetParent2 (objHandle: HCkXml): wordbool;
begin
  result := TCkXml_GetParent2(_map(129, 'CkXml_GetParent2'))
    (objHandle);
end;

function CkXml_GetRoot (objHandle: HCkXml): HCkXml;
begin
  result := TCkXml_GetRoot(_map(130, 'CkXml_GetRoot'))
    (objHandle);
end;

procedure CkXml_GetRoot2 (objHandle: HCkXml);
begin
  TCkXml_GetRoot2(_map(131, 'CkXml_GetRoot2'))
    (objHandle);
end;

function CkXml_GetSelf (objHandle: HCkXml): HCkXml;
begin
  result := TCkXml_GetSelf(_map(132, 'CkXml_GetSelf'))
    (objHandle);
end;

function CkXml_GetXml (objHandle: HCkXml; outStr: HCkString): wordbool;
begin
  result := TCkXml_GetXml(_map(133, 'CkXml_GetXml'))
    (objHandle, outStr);
end;

function CkXml__getXml (objHandle: HCkXml): PWideChar;
begin
  result := TCkXml__getXml(_map(134, 'CkXml__getXml'))
    (objHandle);
end;

function CkXml_GetXmlBd (objHandle: HCkXml; bd: HCkBinData): wordbool;
begin
  result := TCkXml_GetXmlBd(_map(135, 'CkXml_GetXmlBd'))
    (objHandle, bd);
end;

function CkXml_GetXmlSb (objHandle: HCkXml; sb: HCkStringBuilder): wordbool;
begin
  result := TCkXml_GetXmlSb(_map(136, 'CkXml_GetXmlSb'))
    (objHandle, sb);
end;

function CkXml_HasAttribute (objHandle: HCkXml; name: PWideChar): wordbool;
begin
  result := TCkXml_HasAttribute(_map(137, 'CkXml_HasAttribute'))
    (objHandle, name);
end;

function CkXml_HasAttrWithValue (objHandle: HCkXml; name: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkXml_HasAttrWithValue(_map(138, 'CkXml_HasAttrWithValue'))
    (objHandle, name, value);
end;

function CkXml_HasChildWithContent (objHandle: HCkXml; content: PWideChar): wordbool;
begin
  result := TCkXml_HasChildWithContent(_map(139, 'CkXml_HasChildWithContent'))
    (objHandle, content);
end;

function CkXml_HasChildWithTag (objHandle: HCkXml; tagPath: PWideChar): wordbool;
begin
  result := TCkXml_HasChildWithTag(_map(140, 'CkXml_HasChildWithTag'))
    (objHandle, tagPath);
end;

function CkXml_HasChildWithTagAndContent (objHandle: HCkXml; tagPath: PWideChar; content: PWideChar): wordbool;
begin
  result := TCkXml_HasChildWithTagAndContent(_map(141, 'CkXml_HasChildWithTagAndContent'))
    (objHandle, tagPath, content);
end;

procedure CkXml_InsertChildTreeAfter (objHandle: HCkXml; index: Integer; tree: HCkXml);
begin
  TCkXml_InsertChildTreeAfter(_map(142, 'CkXml_InsertChildTreeAfter'))
    (objHandle, index, tree);
end;

procedure CkXml_InsertChildTreeBefore (objHandle: HCkXml; index: Integer; tree: HCkXml);
begin
  TCkXml_InsertChildTreeBefore(_map(143, 'CkXml_InsertChildTreeBefore'))
    (objHandle, index, tree);
end;

function CkXml_LastChild (objHandle: HCkXml): HCkXml;
begin
  result := TCkXml_LastChild(_map(144, 'CkXml_LastChild'))
    (objHandle);
end;

function CkXml_LastChild2 (objHandle: HCkXml): wordbool;
begin
  result := TCkXml_LastChild2(_map(145, 'CkXml_LastChild2'))
    (objHandle);
end;

function CkXml_LoadBd (objHandle: HCkXml; bd: HCkBinData; autoTrim: wordbool): wordbool;
begin
  result := TCkXml_LoadBd(_map(146, 'CkXml_LoadBd'))
    (objHandle, bd, autoTrim);
end;

function CkXml_LoadSb (objHandle: HCkXml; sb: HCkStringBuilder; autoTrim: wordbool): wordbool;
begin
  result := TCkXml_LoadSb(_map(147, 'CkXml_LoadSb'))
    (objHandle, sb, autoTrim);
end;

function CkXml_LoadXml (objHandle: HCkXml; xmlData: PWideChar): wordbool;
begin
  result := TCkXml_LoadXml(_map(148, 'CkXml_LoadXml'))
    (objHandle, xmlData);
end;

function CkXml_LoadXml2 (objHandle: HCkXml; xmlData: PWideChar; autoTrim: wordbool): wordbool;
begin
  result := TCkXml_LoadXml2(_map(149, 'CkXml_LoadXml2'))
    (objHandle, xmlData, autoTrim);
end;

function CkXml_LoadXmlFile (objHandle: HCkXml; fileName: PWideChar): wordbool;
begin
  result := TCkXml_LoadXmlFile(_map(150, 'CkXml_LoadXmlFile'))
    (objHandle, fileName);
end;

function CkXml_LoadXmlFile2 (objHandle: HCkXml; fileName: PWideChar; autoTrim: wordbool): wordbool;
begin
  result := TCkXml_LoadXmlFile2(_map(151, 'CkXml_LoadXmlFile2'))
    (objHandle, fileName, autoTrim);
end;

function CkXml_NewChild (objHandle: HCkXml; tagPath: PWideChar; content: PWideChar): HCkXml;
begin
  result := TCkXml_NewChild(_map(152, 'CkXml_NewChild'))
    (objHandle, tagPath, content);
end;

procedure CkXml_NewChild2 (objHandle: HCkXml; tagPath: PWideChar; content: PWideChar);
begin
  TCkXml_NewChild2(_map(153, 'CkXml_NewChild2'))
    (objHandle, tagPath, content);
end;

function CkXml_NewChildAfter (objHandle: HCkXml; index: Integer; tag: PWideChar; content: PWideChar): HCkXml;
begin
  result := TCkXml_NewChildAfter(_map(154, 'CkXml_NewChildAfter'))
    (objHandle, index, tag, content);
end;

function CkXml_NewChildBefore (objHandle: HCkXml; index: Integer; tag: PWideChar; content: PWideChar): HCkXml;
begin
  result := TCkXml_NewChildBefore(_map(155, 'CkXml_NewChildBefore'))
    (objHandle, index, tag, content);
end;

procedure CkXml_NewChildInt2 (objHandle: HCkXml; tagPath: PWideChar; value: Integer);
begin
  TCkXml_NewChildInt2(_map(156, 'CkXml_NewChildInt2'))
    (objHandle, tagPath, value);
end;

function CkXml_NextInTraversal2 (objHandle: HCkXml; sbState: HCkStringBuilder): wordbool;
begin
  result := TCkXml_NextInTraversal2(_map(157, 'CkXml_NextInTraversal2'))
    (objHandle, sbState);
end;

function CkXml_NextSibling (objHandle: HCkXml): HCkXml;
begin
  result := TCkXml_NextSibling(_map(158, 'CkXml_NextSibling'))
    (objHandle);
end;

function CkXml_NextSibling2 (objHandle: HCkXml): wordbool;
begin
  result := TCkXml_NextSibling2(_map(159, 'CkXml_NextSibling2'))
    (objHandle);
end;

function CkXml_NumChildrenAt (objHandle: HCkXml; tagPath: PWideChar): Integer;
begin
  result := TCkXml_NumChildrenAt(_map(160, 'CkXml_NumChildrenAt'))
    (objHandle, tagPath);
end;

function CkXml_NumChildrenHavingTag (objHandle: HCkXml; tag: PWideChar): Integer;
begin
  result := TCkXml_NumChildrenHavingTag(_map(161, 'CkXml_NumChildrenHavingTag'))
    (objHandle, tag);
end;

function CkXml_PreviousSibling (objHandle: HCkXml): HCkXml;
begin
  result := TCkXml_PreviousSibling(_map(162, 'CkXml_PreviousSibling'))
    (objHandle);
end;

function CkXml_PreviousSibling2 (objHandle: HCkXml): wordbool;
begin
  result := TCkXml_PreviousSibling2(_map(163, 'CkXml_PreviousSibling2'))
    (objHandle);
end;

function CkXml_PruneAttribute (objHandle: HCkXml; attrName: PWideChar): Integer;
begin
  result := TCkXml_PruneAttribute(_map(164, 'CkXml_PruneAttribute'))
    (objHandle, attrName);
end;

function CkXml_PruneTag (objHandle: HCkXml; tag: PWideChar): Integer;
begin
  result := TCkXml_PruneTag(_map(165, 'CkXml_PruneTag'))
    (objHandle, tag);
end;

function CkXml_QEncodeContent (objHandle: HCkXml; charset: PWideChar; inData: HCkByteData): wordbool;
begin
  result := TCkXml_QEncodeContent(_map(166, 'CkXml_QEncodeContent'))
    (objHandle, charset, inData);
end;

function CkXml_RemoveAllAttributes (objHandle: HCkXml): wordbool;
begin
  result := TCkXml_RemoveAllAttributes(_map(167, 'CkXml_RemoveAllAttributes'))
    (objHandle);
end;

procedure CkXml_RemoveAllChildren (objHandle: HCkXml);
begin
  TCkXml_RemoveAllChildren(_map(168, 'CkXml_RemoveAllChildren'))
    (objHandle);
end;

function CkXml_RemoveAttribute (objHandle: HCkXml; name: PWideChar): wordbool;
begin
  result := TCkXml_RemoveAttribute(_map(169, 'CkXml_RemoveAttribute'))
    (objHandle, name);
end;

procedure CkXml_RemoveChild (objHandle: HCkXml; tagPath: PWideChar);
begin
  TCkXml_RemoveChild(_map(170, 'CkXml_RemoveChild'))
    (objHandle, tagPath);
end;

procedure CkXml_RemoveChildByIndex (objHandle: HCkXml; index: Integer);
begin
  TCkXml_RemoveChildByIndex(_map(171, 'CkXml_RemoveChildByIndex'))
    (objHandle, index);
end;

procedure CkXml_RemoveChildWithContent (objHandle: HCkXml; content: PWideChar);
begin
  TCkXml_RemoveChildWithContent(_map(172, 'CkXml_RemoveChildWithContent'))
    (objHandle, content);
end;

procedure CkXml_RemoveFromTree (objHandle: HCkXml);
begin
  TCkXml_RemoveFromTree(_map(173, 'CkXml_RemoveFromTree'))
    (objHandle);
end;

function CkXml_RemoveStyleSheet (objHandle: HCkXml; attrName: PWideChar; attrValue: PWideChar): Integer;
begin
  result := TCkXml_RemoveStyleSheet(_map(174, 'CkXml_RemoveStyleSheet'))
    (objHandle, attrName, attrValue);
end;

function CkXml_SaveBinaryContent (objHandle: HCkXml; filename: PWideChar; unzipFlag: wordbool; decryptFlag: wordbool; password: PWideChar): wordbool;
begin
  result := TCkXml_SaveBinaryContent(_map(175, 'CkXml_SaveBinaryContent'))
    (objHandle, filename, unzipFlag, decryptFlag, password);
end;

function CkXml_SaveXml (objHandle: HCkXml; fileName: PWideChar): wordbool;
begin
  result := TCkXml_SaveXml(_map(176, 'CkXml_SaveXml'))
    (objHandle, fileName);
end;

procedure CkXml_Scrub (objHandle: HCkXml; directives: PWideChar);
begin
  TCkXml_Scrub(_map(177, 'CkXml_Scrub'))
    (objHandle, directives);
end;

function CkXml_SearchAllForContent (objHandle: HCkXml; afterPtr: HCkXml; contentPattern: PWideChar): HCkXml;
begin
  result := TCkXml_SearchAllForContent(_map(178, 'CkXml_SearchAllForContent'))
    (objHandle, afterPtr, contentPattern);
end;

function CkXml_SearchAllForContent2 (objHandle: HCkXml; afterPtr: HCkXml; contentPattern: PWideChar): wordbool;
begin
  result := TCkXml_SearchAllForContent2(_map(179, 'CkXml_SearchAllForContent2'))
    (objHandle, afterPtr, contentPattern);
end;

function CkXml_SearchForAttribute (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; attr: PWideChar; valuePattern: PWideChar): HCkXml;
begin
  result := TCkXml_SearchForAttribute(_map(180, 'CkXml_SearchForAttribute'))
    (objHandle, afterPtr, tag, attr, valuePattern);
end;

function CkXml_SearchForAttribute2 (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; attr: PWideChar; valuePattern: PWideChar): wordbool;
begin
  result := TCkXml_SearchForAttribute2(_map(181, 'CkXml_SearchForAttribute2'))
    (objHandle, afterPtr, tag, attr, valuePattern);
end;

function CkXml_SearchForContent (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; contentPattern: PWideChar): HCkXml;
begin
  result := TCkXml_SearchForContent(_map(182, 'CkXml_SearchForContent'))
    (objHandle, afterPtr, tag, contentPattern);
end;

function CkXml_SearchForContent2 (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar; contentPattern: PWideChar): wordbool;
begin
  result := TCkXml_SearchForContent2(_map(183, 'CkXml_SearchForContent2'))
    (objHandle, afterPtr, tag, contentPattern);
end;

function CkXml_SearchForTag (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar): HCkXml;
begin
  result := TCkXml_SearchForTag(_map(184, 'CkXml_SearchForTag'))
    (objHandle, afterPtr, tag);
end;

function CkXml_SearchForTag2 (objHandle: HCkXml; afterPtr: HCkXml; tag: PWideChar): wordbool;
begin
  result := TCkXml_SearchForTag2(_map(185, 'CkXml_SearchForTag2'))
    (objHandle, afterPtr, tag);
end;

function CkXml_SetBinaryContent (objHandle: HCkXml; inData: HCkByteData; zipFlag: wordbool; encryptFlag: wordbool; password: PWideChar): wordbool;
begin
  result := TCkXml_SetBinaryContent(_map(186, 'CkXml_SetBinaryContent'))
    (objHandle, inData, zipFlag, encryptFlag, password);
end;

function CkXml_SetBinaryContentBd (objHandle: HCkXml; data: HCkBinData; zipFlag: wordbool; encryptFlag: wordbool; password: PWideChar): wordbool;
begin
  result := TCkXml_SetBinaryContentBd(_map(187, 'CkXml_SetBinaryContentBd'))
    (objHandle, data, zipFlag, encryptFlag, password);
end;

function CkXml_SetBinaryContentFromFile (objHandle: HCkXml; filename: PWideChar; zipFlag: wordbool; encryptFlag: wordbool; password: PWideChar): wordbool;
begin
  result := TCkXml_SetBinaryContentFromFile(_map(188, 'CkXml_SetBinaryContentFromFile'))
    (objHandle, filename, zipFlag, encryptFlag, password);
end;

procedure CkXml_SortByAttribute (objHandle: HCkXml; attrName: PWideChar; ascending: wordbool);
begin
  TCkXml_SortByAttribute(_map(189, 'CkXml_SortByAttribute'))
    (objHandle, attrName, ascending);
end;

procedure CkXml_SortByAttributeInt (objHandle: HCkXml; attrName: PWideChar; ascending: wordbool);
begin
  TCkXml_SortByAttributeInt(_map(190, 'CkXml_SortByAttributeInt'))
    (objHandle, attrName, ascending);
end;

procedure CkXml_SortByContent (objHandle: HCkXml; ascending: wordbool);
begin
  TCkXml_SortByContent(_map(191, 'CkXml_SortByContent'))
    (objHandle, ascending);
end;

procedure CkXml_SortByTag (objHandle: HCkXml; ascending: wordbool);
begin
  TCkXml_SortByTag(_map(192, 'CkXml_SortByTag'))
    (objHandle, ascending);
end;

procedure CkXml_SortRecordsByAttribute (objHandle: HCkXml; sortTag: PWideChar; attrName: PWideChar; ascending: wordbool);
begin
  TCkXml_SortRecordsByAttribute(_map(193, 'CkXml_SortRecordsByAttribute'))
    (objHandle, sortTag, attrName, ascending);
end;

procedure CkXml_SortRecordsByContent (objHandle: HCkXml; sortTag: PWideChar; ascending: wordbool);
begin
  TCkXml_SortRecordsByContent(_map(194, 'CkXml_SortRecordsByContent'))
    (objHandle, sortTag, ascending);
end;

procedure CkXml_SortRecordsByContentInt (objHandle: HCkXml; sortTag: PWideChar; ascending: wordbool);
begin
  TCkXml_SortRecordsByContentInt(_map(195, 'CkXml_SortRecordsByContentInt'))
    (objHandle, sortTag, ascending);
end;

function CkXml_SwapNode (objHandle: HCkXml; node: HCkXml): wordbool;
begin
  result := TCkXml_SwapNode(_map(196, 'CkXml_SwapNode'))
    (objHandle, node);
end;

function CkXml_SwapTree (objHandle: HCkXml; tree: HCkXml): wordbool;
begin
  result := TCkXml_SwapTree(_map(197, 'CkXml_SwapTree'))
    (objHandle, tree);
end;

function CkXml_TagContent (objHandle: HCkXml; tagName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkXml_TagContent(_map(198, 'CkXml_TagContent'))
    (objHandle, tagName, outStr);
end;

function CkXml__tagContent (objHandle: HCkXml; tagName: PWideChar): PWideChar;
begin
  result := TCkXml__tagContent(_map(199, 'CkXml__tagContent'))
    (objHandle, tagName);
end;

function CkXml_TagEquals (objHandle: HCkXml; tag: PWideChar): wordbool;
begin
  result := TCkXml_TagEquals(_map(200, 'CkXml_TagEquals'))
    (objHandle, tag);
end;

function CkXml_TagIndex (objHandle: HCkXml; tagPath: PWideChar): Integer;
begin
  result := TCkXml_TagIndex(_map(201, 'CkXml_TagIndex'))
    (objHandle, tagPath);
end;

function CkXml_TagNsEquals (objHandle: HCkXml; ns: PWideChar): wordbool;
begin
  result := TCkXml_TagNsEquals(_map(202, 'CkXml_TagNsEquals'))
    (objHandle, ns);
end;

function CkXml_TagUnpEquals (objHandle: HCkXml; unprefixedTag: PWideChar): wordbool;
begin
  result := TCkXml_TagUnpEquals(_map(203, 'CkXml_TagUnpEquals'))
    (objHandle, unprefixedTag);
end;

function CkXml_UnzipContent (objHandle: HCkXml): wordbool;
begin
  result := TCkXml_UnzipContent(_map(204, 'CkXml_UnzipContent'))
    (objHandle);
end;

function CkXml_UnzipTree (objHandle: HCkXml): wordbool;
begin
  result := TCkXml_UnzipTree(_map(205, 'CkXml_UnzipTree'))
    (objHandle);
end;

function CkXml_UpdateAt (objHandle: HCkXml; tagPath: PWideChar; autoCreate: wordbool; value: PWideChar): wordbool;
begin
  result := TCkXml_UpdateAt(_map(206, 'CkXml_UpdateAt'))
    (objHandle, tagPath, autoCreate, value);
end;

function CkXml_UpdateAttrAt (objHandle: HCkXml; tagPath: PWideChar; autoCreate: wordbool; attrName: PWideChar; attrValue: PWideChar): wordbool;
begin
  result := TCkXml_UpdateAttrAt(_map(207, 'CkXml_UpdateAttrAt'))
    (objHandle, tagPath, autoCreate, attrName, attrValue);
end;

function CkXml_UpdateAttribute (objHandle: HCkXml; attrName: PWideChar; attrValue: PWideChar): wordbool;
begin
  result := TCkXml_UpdateAttribute(_map(208, 'CkXml_UpdateAttribute'))
    (objHandle, attrName, attrValue);
end;

function CkXml_UpdateAttributeInt (objHandle: HCkXml; attrName: PWideChar; value: Integer): wordbool;
begin
  result := TCkXml_UpdateAttributeInt(_map(209, 'CkXml_UpdateAttributeInt'))
    (objHandle, attrName, value);
end;

procedure CkXml_UpdateChildContent (objHandle: HCkXml; tagPath: PWideChar; value: PWideChar);
begin
  TCkXml_UpdateChildContent(_map(210, 'CkXml_UpdateChildContent'))
    (objHandle, tagPath, value);
end;

procedure CkXml_UpdateChildContentInt (objHandle: HCkXml; tagPath: PWideChar; value: Integer);
begin
  TCkXml_UpdateChildContentInt(_map(211, 'CkXml_UpdateChildContentInt'))
    (objHandle, tagPath, value);
end;

function CkXml_ZipContent (objHandle: HCkXml): wordbool;
begin
  result := TCkXml_ZipContent(_map(212, 'CkXml_ZipContent'))
    (objHandle);
end;

function CkXml_ZipTree (objHandle: HCkXml): wordbool;
begin
  result := TCkXml_ZipTree(_map(213, 'CkXml_ZipTree'))
    (objHandle);
end;

end.
