unit XmlDSig;

interface

type

HCkPublicKey = Pointer;
HCkJsonObject = Pointer;
HCkHttp = Pointer;
HCkXmlDSig = Pointer;
HCkXml = Pointer;
HCkString = Pointer;
HCkStringArray = Pointer;
HCkStringBuilder = Pointer;
HCkXmlCertVault = Pointer;
HCkBinData = Pointer;


function CkXmlDSig_Create: HCkXmlDSig;  stdcall;
procedure CkXmlDSig_Dispose(handle: HCkXmlDSig); stdcall;
procedure CkXmlDSig_getDebugLogFilePath(objHandle: HCkXmlDSig; outPropVal: HCkString);
procedure CkXmlDSig_putDebugLogFilePath(objHandle: HCkXmlDSig; newPropVal: PWideChar);
function CkXmlDSig__debugLogFilePath(objHandle: HCkXmlDSig): PWideChar;
procedure CkXmlDSig_getExternalRefDirs(objHandle: HCkXmlDSig; outPropVal: HCkString);
procedure CkXmlDSig_putExternalRefDirs(objHandle: HCkXmlDSig; newPropVal: PWideChar);
function CkXmlDSig__externalRefDirs(objHandle: HCkXmlDSig): PWideChar;
function CkXmlDSig_getIgnoreExternalRefs(objHandle: HCkXmlDSig): wordbool;
procedure CkXmlDSig_putIgnoreExternalRefs(objHandle: HCkXmlDSig; newPropVal: wordbool);
procedure CkXmlDSig_getLastErrorHtml(objHandle: HCkXmlDSig; outPropVal: HCkString);
function CkXmlDSig__lastErrorHtml(objHandle: HCkXmlDSig): PWideChar;
procedure CkXmlDSig_getLastErrorText(objHandle: HCkXmlDSig; outPropVal: HCkString);
function CkXmlDSig__lastErrorText(objHandle: HCkXmlDSig): PWideChar;
procedure CkXmlDSig_getLastErrorXml(objHandle: HCkXmlDSig; outPropVal: HCkString);
function CkXmlDSig__lastErrorXml(objHandle: HCkXmlDSig): PWideChar;
function CkXmlDSig_getLastMethodSuccess(objHandle: HCkXmlDSig): wordbool;
procedure CkXmlDSig_putLastMethodSuccess(objHandle: HCkXmlDSig; newPropVal: wordbool);
function CkXmlDSig_getNumReferences(objHandle: HCkXmlDSig): Integer;
function CkXmlDSig_getNumSignatures(objHandle: HCkXmlDSig): Integer;
function CkXmlDSig_getRefFailReason(objHandle: HCkXmlDSig): Integer;
function CkXmlDSig_getSelector(objHandle: HCkXmlDSig): Integer;
procedure CkXmlDSig_putSelector(objHandle: HCkXmlDSig; newPropVal: Integer);
procedure CkXmlDSig_getUncommonOptions(objHandle: HCkXmlDSig; outPropVal: HCkString);
procedure CkXmlDSig_putUncommonOptions(objHandle: HCkXmlDSig; newPropVal: PWideChar);
function CkXmlDSig__uncommonOptions(objHandle: HCkXmlDSig): PWideChar;
function CkXmlDSig_getVerboseLogging(objHandle: HCkXmlDSig): wordbool;
procedure CkXmlDSig_putVerboseLogging(objHandle: HCkXmlDSig; newPropVal: wordbool);
procedure CkXmlDSig_getVersion(objHandle: HCkXmlDSig; outPropVal: HCkString);
function CkXmlDSig__version(objHandle: HCkXmlDSig): PWideChar;
function CkXmlDSig_AddEncapsulatedTimeStamp(objHandle: HCkXmlDSig; json: HCkJsonObject; sbOut: HCkStringBuilder): wordbool;
function CkXmlDSig_CanonicalizeFragment(objHandle: HCkXmlDSig; xml: PWideChar; fragmentId: PWideChar; version: PWideChar; prefixList: PWideChar; withComments: wordbool; outStr: HCkString): wordbool;
function CkXmlDSig__canonicalizeFragment(objHandle: HCkXmlDSig; xml: PWideChar; fragmentId: PWideChar; version: PWideChar; prefixList: PWideChar; withComments: wordbool): PWideChar;
function CkXmlDSig_CanonicalizeXml(objHandle: HCkXmlDSig; xml: PWideChar; version: PWideChar; withComments: wordbool; outStr: HCkString): wordbool;
function CkXmlDSig__canonicalizeXml(objHandle: HCkXmlDSig; xml: PWideChar; version: PWideChar; withComments: wordbool): PWideChar;
function CkXmlDSig_GetCerts(objHandle: HCkXmlDSig; sa: HCkStringArray): wordbool;
function CkXmlDSig_GetKeyInfo(objHandle: HCkXmlDSig): HCkXml;
function CkXmlDSig_GetPublicKey(objHandle: HCkXmlDSig): HCkPublicKey;
function CkXmlDSig_HasEncapsulatedTimeStamp(objHandle: HCkXmlDSig): wordbool;
function CkXmlDSig_IsReferenceExternal(objHandle: HCkXmlDSig; index: Integer): wordbool;
function CkXmlDSig_LoadSignature(objHandle: HCkXmlDSig; xmlSig: PWideChar): wordbool;
function CkXmlDSig_LoadSignatureBd(objHandle: HCkXmlDSig; binData: HCkBinData): wordbool;
function CkXmlDSig_LoadSignatureSb(objHandle: HCkXmlDSig; sbXmlSig: HCkStringBuilder): wordbool;
function CkXmlDSig_ReferenceUri(objHandle: HCkXmlDSig; index: Integer; outStr: HCkString): wordbool;
function CkXmlDSig__referenceUri(objHandle: HCkXmlDSig; index: Integer): PWideChar;
function CkXmlDSig_SetHmacKey(objHandle: HCkXmlDSig; key: PWideChar; encoding: PWideChar): wordbool;
procedure CkXmlDSig_SetHttpObj(objHandle: HCkXmlDSig; http: HCkHttp);
function CkXmlDSig_SetPublicKey(objHandle: HCkXmlDSig; pubKey: HCkPublicKey): wordbool;
function CkXmlDSig_SetRefDataBd(objHandle: HCkXmlDSig; index: Integer; binData: HCkBinData): wordbool;
function CkXmlDSig_SetRefDataFile(objHandle: HCkXmlDSig; index: Integer; path: PWideChar): wordbool;
function CkXmlDSig_SetRefDataSb(objHandle: HCkXmlDSig; index: Integer; sb: HCkStringBuilder; charset: PWideChar): wordbool;
function CkXmlDSig_UseCertVault(objHandle: HCkXmlDSig; certVault: HCkXmlCertVault): wordbool;
function CkXmlDSig_VerifyReferenceDigest(objHandle: HCkXmlDSig; index: Integer): wordbool;
function CkXmlDSig_VerifySignature(objHandle: HCkXmlDSig; verifyReferenceDigests: wordbool): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkXmlDSig_Create = function : HCkXmlDSig; stdcall;
  TCkXmlDSig_Dispose = procedure (handle: HCkXmlDSig); stdcall;
  TCkXmlDSig_getDebugLogFilePath = procedure (objHandle: HCkXmlDSig; outPropVal: HCkString); stdcall;
  TCkXmlDSig_putDebugLogFilePath = procedure (objHandle: HCkXmlDSig; newPropVal: PWideChar); stdcall;
  TCkXmlDSig__debugLogFilePath = function (objHandle: HCkXmlDSig): PWideChar; stdcall;
  TCkXmlDSig_getExternalRefDirs = procedure (objHandle: HCkXmlDSig; outPropVal: HCkString); stdcall;
  TCkXmlDSig_putExternalRefDirs = procedure (objHandle: HCkXmlDSig; newPropVal: PWideChar); stdcall;
  TCkXmlDSig__externalRefDirs = function (objHandle: HCkXmlDSig): PWideChar; stdcall;
  TCkXmlDSig_getIgnoreExternalRefs = function (objHandle: HCkXmlDSig): wordbool; stdcall;
  TCkXmlDSig_putIgnoreExternalRefs = procedure (objHandle: HCkXmlDSig; newPropVal: wordbool); stdcall;
  TCkXmlDSig_getLastErrorHtml = procedure (objHandle: HCkXmlDSig; outPropVal: HCkString); stdcall;
  TCkXmlDSig__lastErrorHtml = function (objHandle: HCkXmlDSig): PWideChar; stdcall;
  TCkXmlDSig_getLastErrorText = procedure (objHandle: HCkXmlDSig; outPropVal: HCkString); stdcall;
  TCkXmlDSig__lastErrorText = function (objHandle: HCkXmlDSig): PWideChar; stdcall;
  TCkXmlDSig_getLastErrorXml = procedure (objHandle: HCkXmlDSig; outPropVal: HCkString); stdcall;
  TCkXmlDSig__lastErrorXml = function (objHandle: HCkXmlDSig): PWideChar; stdcall;
  TCkXmlDSig_getLastMethodSuccess = function (objHandle: HCkXmlDSig): wordbool; stdcall;
  TCkXmlDSig_putLastMethodSuccess = procedure (objHandle: HCkXmlDSig; newPropVal: wordbool); stdcall;
  TCkXmlDSig_getNumReferences = function (objHandle: HCkXmlDSig): Integer; stdcall;
  TCkXmlDSig_getNumSignatures = function (objHandle: HCkXmlDSig): Integer; stdcall;
  TCkXmlDSig_getRefFailReason = function (objHandle: HCkXmlDSig): Integer; stdcall;
  TCkXmlDSig_getSelector = function (objHandle: HCkXmlDSig): Integer; stdcall;
  TCkXmlDSig_putSelector = procedure (objHandle: HCkXmlDSig; newPropVal: Integer); stdcall;
  TCkXmlDSig_getUncommonOptions = procedure (objHandle: HCkXmlDSig; outPropVal: HCkString); stdcall;
  TCkXmlDSig_putUncommonOptions = procedure (objHandle: HCkXmlDSig; newPropVal: PWideChar); stdcall;
  TCkXmlDSig__uncommonOptions = function (objHandle: HCkXmlDSig): PWideChar; stdcall;
  TCkXmlDSig_getVerboseLogging = function (objHandle: HCkXmlDSig): wordbool; stdcall;
  TCkXmlDSig_putVerboseLogging = procedure (objHandle: HCkXmlDSig; newPropVal: wordbool); stdcall;
  TCkXmlDSig_getVersion = procedure (objHandle: HCkXmlDSig; outPropVal: HCkString); stdcall;
  TCkXmlDSig__version = function (objHandle: HCkXmlDSig): PWideChar; stdcall;
  TCkXmlDSig_AddEncapsulatedTimeStamp = function (objHandle: HCkXmlDSig; json: HCkJsonObject; sbOut: HCkStringBuilder): wordbool; stdcall;
  TCkXmlDSig_CanonicalizeFragment = function (objHandle: HCkXmlDSig; xml: PWideChar; fragmentId: PWideChar; version: PWideChar; prefixList: PWideChar; withComments: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkXmlDSig__canonicalizeFragment = function (objHandle: HCkXmlDSig; xml: PWideChar; fragmentId: PWideChar; version: PWideChar; prefixList: PWideChar; withComments: wordbool): PWideChar; stdcall;
  TCkXmlDSig_CanonicalizeXml = function (objHandle: HCkXmlDSig; xml: PWideChar; version: PWideChar; withComments: wordbool; outStr: HCkString): wordbool; stdcall;
  TCkXmlDSig__canonicalizeXml = function (objHandle: HCkXmlDSig; xml: PWideChar; version: PWideChar; withComments: wordbool): PWideChar; stdcall;
  TCkXmlDSig_GetCerts = function (objHandle: HCkXmlDSig; sa: HCkStringArray): wordbool; stdcall;
  TCkXmlDSig_GetKeyInfo = function (objHandle: HCkXmlDSig): HCkXml; stdcall;
  TCkXmlDSig_GetPublicKey = function (objHandle: HCkXmlDSig): HCkPublicKey; stdcall;
  TCkXmlDSig_HasEncapsulatedTimeStamp = function (objHandle: HCkXmlDSig): wordbool; stdcall;
  TCkXmlDSig_IsReferenceExternal = function (objHandle: HCkXmlDSig; index: Integer): wordbool; stdcall;
  TCkXmlDSig_LoadSignature = function (objHandle: HCkXmlDSig; xmlSig: PWideChar): wordbool; stdcall;
  TCkXmlDSig_LoadSignatureBd = function (objHandle: HCkXmlDSig; binData: HCkBinData): wordbool; stdcall;
  TCkXmlDSig_LoadSignatureSb = function (objHandle: HCkXmlDSig; sbXmlSig: HCkStringBuilder): wordbool; stdcall;
  TCkXmlDSig_ReferenceUri = function (objHandle: HCkXmlDSig; index: Integer; outStr: HCkString): wordbool; stdcall;
  TCkXmlDSig__referenceUri = function (objHandle: HCkXmlDSig; index: Integer): PWideChar; stdcall;
  TCkXmlDSig_SetHmacKey = function (objHandle: HCkXmlDSig; key: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkXmlDSig_SetHttpObj = procedure (objHandle: HCkXmlDSig; http: HCkHttp); stdcall;
  TCkXmlDSig_SetPublicKey = function (objHandle: HCkXmlDSig; pubKey: HCkPublicKey): wordbool; stdcall;
  TCkXmlDSig_SetRefDataBd = function (objHandle: HCkXmlDSig; index: Integer; binData: HCkBinData): wordbool; stdcall;
  TCkXmlDSig_SetRefDataFile = function (objHandle: HCkXmlDSig; index: Integer; path: PWideChar): wordbool; stdcall;
  TCkXmlDSig_SetRefDataSb = function (objHandle: HCkXmlDSig; index: Integer; sb: HCkStringBuilder; charset: PWideChar): wordbool; stdcall;
  TCkXmlDSig_UseCertVault = function (objHandle: HCkXmlDSig; certVault: HCkXmlCertVault): wordbool; stdcall;
  TCkXmlDSig_VerifyReferenceDigest = function (objHandle: HCkXmlDSig; index: Integer): wordbool; stdcall;
  TCkXmlDSig_VerifySignature = function (objHandle: HCkXmlDSig; verifyReferenceDigests: wordbool): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..53] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkXmlDSig_Create : HCkXmlDSig;
begin
  result := TCkXmlDSig_Create(_map(0, 'CkXmlDSig_Create'));
end;

procedure CkXmlDSig_Dispose (handle: HCkXmlDSig);
begin
  TCkXmlDSig_Dispose(_map(1, 'CkXmlDSig_Dispose'))
    (handle);
end;


procedure CkXmlDSig_getDebugLogFilePath (objHandle: HCkXmlDSig; outPropVal: HCkString);
begin
  TCkXmlDSig_getDebugLogFilePath(_map(2, 'CkXmlDSig_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSig_putDebugLogFilePath (objHandle: HCkXmlDSig; newPropVal: PWideChar);
begin
  TCkXmlDSig_putDebugLogFilePath(_map(3, 'CkXmlDSig_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkXmlDSig__debugLogFilePath (objHandle: HCkXmlDSig): PWideChar;
begin
  result := TCkXmlDSig__debugLogFilePath(_map(4, 'CkXmlDSig__debugLogFilePath'))
    (objHandle);
end;

procedure CkXmlDSig_getExternalRefDirs (objHandle: HCkXmlDSig; outPropVal: HCkString);
begin
  TCkXmlDSig_getExternalRefDirs(_map(5, 'CkXmlDSig_getExternalRefDirs'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSig_putExternalRefDirs (objHandle: HCkXmlDSig; newPropVal: PWideChar);
begin
  TCkXmlDSig_putExternalRefDirs(_map(6, 'CkXmlDSig_putExternalRefDirs'))
    (objHandle, newPropVal);
end;

function CkXmlDSig__externalRefDirs (objHandle: HCkXmlDSig): PWideChar;
begin
  result := TCkXmlDSig__externalRefDirs(_map(7, 'CkXmlDSig__externalRefDirs'))
    (objHandle);
end;

function CkXmlDSig_getIgnoreExternalRefs (objHandle: HCkXmlDSig): wordbool;
begin
    result := TCkXmlDSig_getIgnoreExternalRefs(_map(8, 'CkXmlDSig_getIgnoreExternalRefs'))
    (objHandle);
end;

procedure CkXmlDSig_putIgnoreExternalRefs (objHandle: HCkXmlDSig; newPropVal: wordbool);
begin
  TCkXmlDSig_putIgnoreExternalRefs(_map(9, 'CkXmlDSig_putIgnoreExternalRefs'))
    (objHandle, newPropVal);
end;

procedure CkXmlDSig_getLastErrorHtml (objHandle: HCkXmlDSig; outPropVal: HCkString);
begin
  TCkXmlDSig_getLastErrorHtml(_map(10, 'CkXmlDSig_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkXmlDSig__lastErrorHtml (objHandle: HCkXmlDSig): PWideChar;
begin
  result := TCkXmlDSig__lastErrorHtml(_map(11, 'CkXmlDSig__lastErrorHtml'))
    (objHandle);
end;

procedure CkXmlDSig_getLastErrorText (objHandle: HCkXmlDSig; outPropVal: HCkString);
begin
  TCkXmlDSig_getLastErrorText(_map(12, 'CkXmlDSig_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkXmlDSig__lastErrorText (objHandle: HCkXmlDSig): PWideChar;
begin
  result := TCkXmlDSig__lastErrorText(_map(13, 'CkXmlDSig__lastErrorText'))
    (objHandle);
end;

procedure CkXmlDSig_getLastErrorXml (objHandle: HCkXmlDSig; outPropVal: HCkString);
begin
  TCkXmlDSig_getLastErrorXml(_map(14, 'CkXmlDSig_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkXmlDSig__lastErrorXml (objHandle: HCkXmlDSig): PWideChar;
begin
  result := TCkXmlDSig__lastErrorXml(_map(15, 'CkXmlDSig__lastErrorXml'))
    (objHandle);
end;

function CkXmlDSig_getLastMethodSuccess (objHandle: HCkXmlDSig): wordbool;
begin
    result := TCkXmlDSig_getLastMethodSuccess(_map(16, 'CkXmlDSig_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkXmlDSig_putLastMethodSuccess (objHandle: HCkXmlDSig; newPropVal: wordbool);
begin
  TCkXmlDSig_putLastMethodSuccess(_map(17, 'CkXmlDSig_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkXmlDSig_getNumReferences (objHandle: HCkXmlDSig): Integer;
begin
    result := TCkXmlDSig_getNumReferences(_map(18, 'CkXmlDSig_getNumReferences'))
    (objHandle);
end;

function CkXmlDSig_getNumSignatures (objHandle: HCkXmlDSig): Integer;
begin
    result := TCkXmlDSig_getNumSignatures(_map(19, 'CkXmlDSig_getNumSignatures'))
    (objHandle);
end;

function CkXmlDSig_getRefFailReason (objHandle: HCkXmlDSig): Integer;
begin
    result := TCkXmlDSig_getRefFailReason(_map(20, 'CkXmlDSig_getRefFailReason'))
    (objHandle);
end;

function CkXmlDSig_getSelector (objHandle: HCkXmlDSig): Integer;
begin
    result := TCkXmlDSig_getSelector(_map(21, 'CkXmlDSig_getSelector'))
    (objHandle);
end;

procedure CkXmlDSig_putSelector (objHandle: HCkXmlDSig; newPropVal: Integer);
begin
  TCkXmlDSig_putSelector(_map(22, 'CkXmlDSig_putSelector'))
    (objHandle, newPropVal);
end;

procedure CkXmlDSig_getUncommonOptions (objHandle: HCkXmlDSig; outPropVal: HCkString);
begin
  TCkXmlDSig_getUncommonOptions(_map(23, 'CkXmlDSig_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSig_putUncommonOptions (objHandle: HCkXmlDSig; newPropVal: PWideChar);
begin
  TCkXmlDSig_putUncommonOptions(_map(24, 'CkXmlDSig_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkXmlDSig__uncommonOptions (objHandle: HCkXmlDSig): PWideChar;
begin
  result := TCkXmlDSig__uncommonOptions(_map(25, 'CkXmlDSig__uncommonOptions'))
    (objHandle);
end;

function CkXmlDSig_getVerboseLogging (objHandle: HCkXmlDSig): wordbool;
begin
    result := TCkXmlDSig_getVerboseLogging(_map(26, 'CkXmlDSig_getVerboseLogging'))
    (objHandle);
end;

procedure CkXmlDSig_putVerboseLogging (objHandle: HCkXmlDSig; newPropVal: wordbool);
begin
  TCkXmlDSig_putVerboseLogging(_map(27, 'CkXmlDSig_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkXmlDSig_getVersion (objHandle: HCkXmlDSig; outPropVal: HCkString);
begin
  TCkXmlDSig_getVersion(_map(28, 'CkXmlDSig_getVersion'))
    (objHandle, outPropVal);
end;

function CkXmlDSig__version (objHandle: HCkXmlDSig): PWideChar;
begin
  result := TCkXmlDSig__version(_map(29, 'CkXmlDSig__version'))
    (objHandle);
end;

function CkXmlDSig_AddEncapsulatedTimeStamp (objHandle: HCkXmlDSig; json: HCkJsonObject; sbOut: HCkStringBuilder): wordbool;
begin
  result := TCkXmlDSig_AddEncapsulatedTimeStamp(_map(30, 'CkXmlDSig_AddEncapsulatedTimeStamp'))
    (objHandle, json, sbOut);
end;

function CkXmlDSig_CanonicalizeFragment (objHandle: HCkXmlDSig; xml: PWideChar; fragmentId: PWideChar; version: PWideChar; prefixList: PWideChar; withComments: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkXmlDSig_CanonicalizeFragment(_map(31, 'CkXmlDSig_CanonicalizeFragment'))
    (objHandle, xml, fragmentId, version, prefixList, withComments, outStr);
end;

function CkXmlDSig__canonicalizeFragment (objHandle: HCkXmlDSig; xml: PWideChar; fragmentId: PWideChar; version: PWideChar; prefixList: PWideChar; withComments: wordbool): PWideChar;
begin
  result := TCkXmlDSig__canonicalizeFragment(_map(32, 'CkXmlDSig__canonicalizeFragment'))
    (objHandle, xml, fragmentId, version, prefixList, withComments);
end;

function CkXmlDSig_CanonicalizeXml (objHandle: HCkXmlDSig; xml: PWideChar; version: PWideChar; withComments: wordbool; outStr: HCkString): wordbool;
begin
  result := TCkXmlDSig_CanonicalizeXml(_map(33, 'CkXmlDSig_CanonicalizeXml'))
    (objHandle, xml, version, withComments, outStr);
end;

function CkXmlDSig__canonicalizeXml (objHandle: HCkXmlDSig; xml: PWideChar; version: PWideChar; withComments: wordbool): PWideChar;
begin
  result := TCkXmlDSig__canonicalizeXml(_map(34, 'CkXmlDSig__canonicalizeXml'))
    (objHandle, xml, version, withComments);
end;

function CkXmlDSig_GetCerts (objHandle: HCkXmlDSig; sa: HCkStringArray): wordbool;
begin
  result := TCkXmlDSig_GetCerts(_map(35, 'CkXmlDSig_GetCerts'))
    (objHandle, sa);
end;

function CkXmlDSig_GetKeyInfo (objHandle: HCkXmlDSig): HCkXml;
begin
  result := TCkXmlDSig_GetKeyInfo(_map(36, 'CkXmlDSig_GetKeyInfo'))
    (objHandle);
end;

function CkXmlDSig_GetPublicKey (objHandle: HCkXmlDSig): HCkPublicKey;
begin
  result := TCkXmlDSig_GetPublicKey(_map(37, 'CkXmlDSig_GetPublicKey'))
    (objHandle);
end;

function CkXmlDSig_HasEncapsulatedTimeStamp (objHandle: HCkXmlDSig): wordbool;
begin
  result := TCkXmlDSig_HasEncapsulatedTimeStamp(_map(38, 'CkXmlDSig_HasEncapsulatedTimeStamp'))
    (objHandle);
end;

function CkXmlDSig_IsReferenceExternal (objHandle: HCkXmlDSig; index: Integer): wordbool;
begin
  result := TCkXmlDSig_IsReferenceExternal(_map(39, 'CkXmlDSig_IsReferenceExternal'))
    (objHandle, index);
end;

function CkXmlDSig_LoadSignature (objHandle: HCkXmlDSig; xmlSig: PWideChar): wordbool;
begin
  result := TCkXmlDSig_LoadSignature(_map(40, 'CkXmlDSig_LoadSignature'))
    (objHandle, xmlSig);
end;

function CkXmlDSig_LoadSignatureBd (objHandle: HCkXmlDSig; binData: HCkBinData): wordbool;
begin
  result := TCkXmlDSig_LoadSignatureBd(_map(41, 'CkXmlDSig_LoadSignatureBd'))
    (objHandle, binData);
end;

function CkXmlDSig_LoadSignatureSb (objHandle: HCkXmlDSig; sbXmlSig: HCkStringBuilder): wordbool;
begin
  result := TCkXmlDSig_LoadSignatureSb(_map(42, 'CkXmlDSig_LoadSignatureSb'))
    (objHandle, sbXmlSig);
end;

function CkXmlDSig_ReferenceUri (objHandle: HCkXmlDSig; index: Integer; outStr: HCkString): wordbool;
begin
  result := TCkXmlDSig_ReferenceUri(_map(43, 'CkXmlDSig_ReferenceUri'))
    (objHandle, index, outStr);
end;

function CkXmlDSig__referenceUri (objHandle: HCkXmlDSig; index: Integer): PWideChar;
begin
  result := TCkXmlDSig__referenceUri(_map(44, 'CkXmlDSig__referenceUri'))
    (objHandle, index);
end;

function CkXmlDSig_SetHmacKey (objHandle: HCkXmlDSig; key: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkXmlDSig_SetHmacKey(_map(45, 'CkXmlDSig_SetHmacKey'))
    (objHandle, key, encoding);
end;

procedure CkXmlDSig_SetHttpObj (objHandle: HCkXmlDSig; http: HCkHttp);
begin
  TCkXmlDSig_SetHttpObj(_map(46, 'CkXmlDSig_SetHttpObj'))
    (objHandle, http);
end;

function CkXmlDSig_SetPublicKey (objHandle: HCkXmlDSig; pubKey: HCkPublicKey): wordbool;
begin
  result := TCkXmlDSig_SetPublicKey(_map(47, 'CkXmlDSig_SetPublicKey'))
    (objHandle, pubKey);
end;

function CkXmlDSig_SetRefDataBd (objHandle: HCkXmlDSig; index: Integer; binData: HCkBinData): wordbool;
begin
  result := TCkXmlDSig_SetRefDataBd(_map(48, 'CkXmlDSig_SetRefDataBd'))
    (objHandle, index, binData);
end;

function CkXmlDSig_SetRefDataFile (objHandle: HCkXmlDSig; index: Integer; path: PWideChar): wordbool;
begin
  result := TCkXmlDSig_SetRefDataFile(_map(49, 'CkXmlDSig_SetRefDataFile'))
    (objHandle, index, path);
end;

function CkXmlDSig_SetRefDataSb (objHandle: HCkXmlDSig; index: Integer; sb: HCkStringBuilder; charset: PWideChar): wordbool;
begin
  result := TCkXmlDSig_SetRefDataSb(_map(50, 'CkXmlDSig_SetRefDataSb'))
    (objHandle, index, sb, charset);
end;

function CkXmlDSig_UseCertVault (objHandle: HCkXmlDSig; certVault: HCkXmlCertVault): wordbool;
begin
  result := TCkXmlDSig_UseCertVault(_map(51, 'CkXmlDSig_UseCertVault'))
    (objHandle, certVault);
end;

function CkXmlDSig_VerifyReferenceDigest (objHandle: HCkXmlDSig; index: Integer): wordbool;
begin
  result := TCkXmlDSig_VerifyReferenceDigest(_map(52, 'CkXmlDSig_VerifyReferenceDigest'))
    (objHandle, index);
end;

function CkXmlDSig_VerifySignature (objHandle: HCkXmlDSig; verifyReferenceDigests: wordbool): wordbool;
begin
  result := TCkXmlDSig_VerifySignature(_map(53, 'CkXmlDSig_VerifySignature'))
    (objHandle, verifyReferenceDigests);
end;

end.
