unit ZipEntry;

interface

type

HCkBinData = Pointer;
HCkDateTime = Pointer;
HCkByteData = Pointer;
HCkZipEntry = Pointer;
HCkString = Pointer;
HCkStream = Pointer;
HCkStringBuilder = Pointer;
HCkTask = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TZipEntryAbortCheck = function(): Integer; cdecl;
TZipEntryProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TZipEntryPercentDone = function(pctDone: Integer): Integer; cdecl;
TZipEntryTaskCompleted = procedure(task: HCkTask); cdecl;


function CkZipEntry_Create: HCkZipEntry;  stdcall;
procedure CkZipEntry_Dispose(handle: HCkZipEntry); stdcall;

procedure CkZipEntry_SetAbortCheck(objHandle: HCkZipEntry; fn: TZipEntryAbortCheck) stdcall;
procedure CkZipEntry_SetProgressInfo(objHandle: HCkZipEntry; fn: TZipEntryProgressInfo) stdcall;
procedure CkZipEntry_SetPercentDone(objHandle: HCkZipEntry; fn: TZipEntryPercentDone) stdcall;
procedure CkZipEntry_SetTaskCompleted(objHandle: HCkZipEntry; fn: TZipEntryTaskCompleted) stdcall;
procedure CkZipEntry_getComment(objHandle: HCkZipEntry; outPropVal: HCkString);
procedure CkZipEntry_putComment(objHandle: HCkZipEntry; newPropVal: PWideChar);
function CkZipEntry__comment(objHandle: HCkZipEntry): PWideChar;
function CkZipEntry_getCompressedLength(objHandle: HCkZipEntry): LongWord;
function CkZipEntry_getCompressedLength64(objHandle: HCkZipEntry): Int64;
procedure CkZipEntry_getCompressedLengthStr(objHandle: HCkZipEntry; outPropVal: HCkString);
function CkZipEntry__compressedLengthStr(objHandle: HCkZipEntry): PWideChar;
function CkZipEntry_getCompressionLevel(objHandle: HCkZipEntry): Integer;
procedure CkZipEntry_putCompressionLevel(objHandle: HCkZipEntry; newPropVal: Integer);
function CkZipEntry_getCompressionMethod(objHandle: HCkZipEntry): Integer;
procedure CkZipEntry_putCompressionMethod(objHandle: HCkZipEntry; newPropVal: Integer);
function CkZipEntry_getCrc(objHandle: HCkZipEntry): Integer;
procedure CkZipEntry_getDebugLogFilePath(objHandle: HCkZipEntry; outPropVal: HCkString);
procedure CkZipEntry_putDebugLogFilePath(objHandle: HCkZipEntry; newPropVal: PWideChar);
function CkZipEntry__debugLogFilePath(objHandle: HCkZipEntry): PWideChar;
function CkZipEntry_getEncryptionKeyLen(objHandle: HCkZipEntry): Integer;
function CkZipEntry_getEntryID(objHandle: HCkZipEntry): Integer;
function CkZipEntry_getEntryType(objHandle: HCkZipEntry): Integer;
procedure CkZipEntry_getFileDateTimeStr(objHandle: HCkZipEntry; outPropVal: HCkString);
procedure CkZipEntry_putFileDateTimeStr(objHandle: HCkZipEntry; newPropVal: PWideChar);
function CkZipEntry__fileDateTimeStr(objHandle: HCkZipEntry): PWideChar;
procedure CkZipEntry_getFileName(objHandle: HCkZipEntry; outPropVal: HCkString);
procedure CkZipEntry_putFileName(objHandle: HCkZipEntry; newPropVal: PWideChar);
function CkZipEntry__fileName(objHandle: HCkZipEntry): PWideChar;
procedure CkZipEntry_getFileNameHex(objHandle: HCkZipEntry; outPropVal: HCkString);
function CkZipEntry__fileNameHex(objHandle: HCkZipEntry): PWideChar;
function CkZipEntry_getHeartbeatMs(objHandle: HCkZipEntry): Integer;
procedure CkZipEntry_putHeartbeatMs(objHandle: HCkZipEntry; newPropVal: Integer);
function CkZipEntry_getIsAesEncrypted(objHandle: HCkZipEntry): wordbool;
function CkZipEntry_getIsDirectory(objHandle: HCkZipEntry): wordbool;
procedure CkZipEntry_getLastErrorHtml(objHandle: HCkZipEntry; outPropVal: HCkString);
function CkZipEntry__lastErrorHtml(objHandle: HCkZipEntry): PWideChar;
procedure CkZipEntry_getLastErrorText(objHandle: HCkZipEntry; outPropVal: HCkString);
function CkZipEntry__lastErrorText(objHandle: HCkZipEntry): PWideChar;
procedure CkZipEntry_getLastErrorXml(objHandle: HCkZipEntry; outPropVal: HCkString);
function CkZipEntry__lastErrorXml(objHandle: HCkZipEntry): PWideChar;
function CkZipEntry_getLastMethodSuccess(objHandle: HCkZipEntry): wordbool;
procedure CkZipEntry_putLastMethodSuccess(objHandle: HCkZipEntry; newPropVal: wordbool);
function CkZipEntry_getTextFlag(objHandle: HCkZipEntry): wordbool;
procedure CkZipEntry_putTextFlag(objHandle: HCkZipEntry; newPropVal: wordbool);
function CkZipEntry_getUncompressedLength(objHandle: HCkZipEntry): LongWord;
function CkZipEntry_getUncompressedLength64(objHandle: HCkZipEntry): Int64;
procedure CkZipEntry_getUncompressedLengthStr(objHandle: HCkZipEntry; outPropVal: HCkString);
function CkZipEntry__uncompressedLengthStr(objHandle: HCkZipEntry): PWideChar;
function CkZipEntry_getVerboseLogging(objHandle: HCkZipEntry): wordbool;
procedure CkZipEntry_putVerboseLogging(objHandle: HCkZipEntry; newPropVal: wordbool);
procedure CkZipEntry_getVersion(objHandle: HCkZipEntry; outPropVal: HCkString);
function CkZipEntry__version(objHandle: HCkZipEntry): PWideChar;
function CkZipEntry_AppendData(objHandle: HCkZipEntry; inData: HCkByteData): wordbool;
function CkZipEntry_AppendDataAsync(objHandle: HCkZipEntry; inData: HCkByteData): HCkTask;
function CkZipEntry_AppendString(objHandle: HCkZipEntry; strContent: PWideChar; charset: PWideChar): wordbool;
function CkZipEntry_AppendStringAsync(objHandle: HCkZipEntry; strContent: PWideChar; charset: PWideChar): HCkTask;
function CkZipEntry_Copy(objHandle: HCkZipEntry; outData: HCkByteData): wordbool;
function CkZipEntry_CopyToBase64(objHandle: HCkZipEntry; outStr: HCkString): wordbool;
function CkZipEntry__copyToBase64(objHandle: HCkZipEntry): PWideChar;
function CkZipEntry_CopyToHex(objHandle: HCkZipEntry; outStr: HCkString): wordbool;
function CkZipEntry__copyToHex(objHandle: HCkZipEntry): PWideChar;
function CkZipEntry_Extract(objHandle: HCkZipEntry; dirPath: PWideChar): wordbool;
function CkZipEntry_ExtractAsync(objHandle: HCkZipEntry; dirPath: PWideChar): HCkTask;
function CkZipEntry_ExtractInto(objHandle: HCkZipEntry; dirPath: PWideChar): wordbool;
function CkZipEntry_ExtractIntoAsync(objHandle: HCkZipEntry; dirPath: PWideChar): HCkTask;
function CkZipEntry_GetDt(objHandle: HCkZipEntry): HCkDateTime;
function CkZipEntry_GetNext(objHandle: HCkZipEntry): wordbool;
function CkZipEntry_GetNextMatch(objHandle: HCkZipEntry; pattern: PWideChar): wordbool;
function CkZipEntry_Inflate(objHandle: HCkZipEntry; outData: HCkByteData): wordbool;
function CkZipEntry_InflateAsync(objHandle: HCkZipEntry): HCkTask;
function CkZipEntry_LoadTaskCaller(objHandle: HCkZipEntry; task: HCkTask): wordbool;
function CkZipEntry_NextEntry(objHandle: HCkZipEntry): HCkZipEntry;
function CkZipEntry_NextMatchingEntry(objHandle: HCkZipEntry; matchStr: PWideChar): HCkZipEntry;
function CkZipEntry_ReplaceData(objHandle: HCkZipEntry; inData: HCkByteData): wordbool;
function CkZipEntry_ReplaceString(objHandle: HCkZipEntry; strContent: PWideChar; charset: PWideChar): wordbool;
procedure CkZipEntry_SetDt(objHandle: HCkZipEntry; dt: HCkDateTime);
function CkZipEntry_UnzipToBd(objHandle: HCkZipEntry; binData: HCkBinData): wordbool;
function CkZipEntry_UnzipToBdAsync(objHandle: HCkZipEntry; binData: HCkBinData): HCkTask;
function CkZipEntry_UnzipToSb(objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar; sb: HCkStringBuilder): wordbool;
function CkZipEntry_UnzipToSbAsync(objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar; sb: HCkStringBuilder): HCkTask;
function CkZipEntry_UnzipToStream(objHandle: HCkZipEntry; toStream: HCkStream): wordbool;
function CkZipEntry_UnzipToStreamAsync(objHandle: HCkZipEntry; toStream: HCkStream): HCkTask;
function CkZipEntry_UnzipToString(objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar; outStr: HCkString): wordbool;
function CkZipEntry__unzipToString(objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar): PWideChar;
function CkZipEntry_UnzipToStringAsync(objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkZipEntry_Create = function : HCkZipEntry; stdcall;
  TCkZipEntry_Dispose = procedure (handle: HCkZipEntry); stdcall;
  TCkZipEntry_SetAbortCheck = procedure (objHandle: HCkZipEntry; fn: TZipEntryAbortCheck); stdcall;
  TCkZipEntry_SetProgressInfo = procedure (objHandle: HCkZipEntry; fn: TZipEntryProgressInfo); stdcall;
  TCkZipEntry_SetPercentDone = procedure (objHandle: HCkZipEntry; fn: TZipEntryPercentDone); stdcall;
  TCkZipEntry_SetTaskCompleted = procedure (objHandle: HCkZipEntry; fn: TZipEntryTaskCompleted); stdcall;
  TCkZipEntry_getComment = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry_putComment = procedure (objHandle: HCkZipEntry; newPropVal: PWideChar); stdcall;
  TCkZipEntry__comment = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_getCompressedLength = function (objHandle: HCkZipEntry): LongWord; stdcall;
  TCkZipEntry_getCompressedLength64 = function (objHandle: HCkZipEntry): Int64; stdcall;
  TCkZipEntry_getCompressedLengthStr = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry__compressedLengthStr = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_getCompressionLevel = function (objHandle: HCkZipEntry): Integer; stdcall;
  TCkZipEntry_putCompressionLevel = procedure (objHandle: HCkZipEntry; newPropVal: Integer); stdcall;
  TCkZipEntry_getCompressionMethod = function (objHandle: HCkZipEntry): Integer; stdcall;
  TCkZipEntry_putCompressionMethod = procedure (objHandle: HCkZipEntry; newPropVal: Integer); stdcall;
  TCkZipEntry_getCrc = function (objHandle: HCkZipEntry): Integer; stdcall;
  TCkZipEntry_getDebugLogFilePath = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry_putDebugLogFilePath = procedure (objHandle: HCkZipEntry; newPropVal: PWideChar); stdcall;
  TCkZipEntry__debugLogFilePath = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_getEncryptionKeyLen = function (objHandle: HCkZipEntry): Integer; stdcall;
  TCkZipEntry_getEntryID = function (objHandle: HCkZipEntry): Integer; stdcall;
  TCkZipEntry_getEntryType = function (objHandle: HCkZipEntry): Integer; stdcall;
  TCkZipEntry_getFileDateTimeStr = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry_putFileDateTimeStr = procedure (objHandle: HCkZipEntry; newPropVal: PWideChar); stdcall;
  TCkZipEntry__fileDateTimeStr = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_getFileName = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry_putFileName = procedure (objHandle: HCkZipEntry; newPropVal: PWideChar); stdcall;
  TCkZipEntry__fileName = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_getFileNameHex = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry__fileNameHex = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_getHeartbeatMs = function (objHandle: HCkZipEntry): Integer; stdcall;
  TCkZipEntry_putHeartbeatMs = procedure (objHandle: HCkZipEntry; newPropVal: Integer); stdcall;
  TCkZipEntry_getIsAesEncrypted = function (objHandle: HCkZipEntry): wordbool; stdcall;
  TCkZipEntry_getIsDirectory = function (objHandle: HCkZipEntry): wordbool; stdcall;
  TCkZipEntry_getLastErrorHtml = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry__lastErrorHtml = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_getLastErrorText = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry__lastErrorText = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_getLastErrorXml = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry__lastErrorXml = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_getLastMethodSuccess = function (objHandle: HCkZipEntry): wordbool; stdcall;
  TCkZipEntry_putLastMethodSuccess = procedure (objHandle: HCkZipEntry; newPropVal: wordbool); stdcall;
  TCkZipEntry_getTextFlag = function (objHandle: HCkZipEntry): wordbool; stdcall;
  TCkZipEntry_putTextFlag = procedure (objHandle: HCkZipEntry; newPropVal: wordbool); stdcall;
  TCkZipEntry_getUncompressedLength = function (objHandle: HCkZipEntry): LongWord; stdcall;
  TCkZipEntry_getUncompressedLength64 = function (objHandle: HCkZipEntry): Int64; stdcall;
  TCkZipEntry_getUncompressedLengthStr = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry__uncompressedLengthStr = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_getVerboseLogging = function (objHandle: HCkZipEntry): wordbool; stdcall;
  TCkZipEntry_putVerboseLogging = procedure (objHandle: HCkZipEntry; newPropVal: wordbool); stdcall;
  TCkZipEntry_getVersion = procedure (objHandle: HCkZipEntry; outPropVal: HCkString); stdcall;
  TCkZipEntry__version = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_AppendData = function (objHandle: HCkZipEntry; inData: HCkByteData): wordbool; stdcall;
  TCkZipEntry_AppendDataAsync = function (objHandle: HCkZipEntry; inData: HCkByteData): HCkTask; stdcall;
  TCkZipEntry_AppendString = function (objHandle: HCkZipEntry; strContent: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkZipEntry_AppendStringAsync = function (objHandle: HCkZipEntry; strContent: PWideChar; charset: PWideChar): HCkTask; stdcall;
  TCkZipEntry_Copy = function (objHandle: HCkZipEntry; outData: HCkByteData): wordbool; stdcall;
  TCkZipEntry_CopyToBase64 = function (objHandle: HCkZipEntry; outStr: HCkString): wordbool; stdcall;
  TCkZipEntry__copyToBase64 = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_CopyToHex = function (objHandle: HCkZipEntry; outStr: HCkString): wordbool; stdcall;
  TCkZipEntry__copyToHex = function (objHandle: HCkZipEntry): PWideChar; stdcall;
  TCkZipEntry_Extract = function (objHandle: HCkZipEntry; dirPath: PWideChar): wordbool; stdcall;
  TCkZipEntry_ExtractAsync = function (objHandle: HCkZipEntry; dirPath: PWideChar): HCkTask; stdcall;
  TCkZipEntry_ExtractInto = function (objHandle: HCkZipEntry; dirPath: PWideChar): wordbool; stdcall;
  TCkZipEntry_ExtractIntoAsync = function (objHandle: HCkZipEntry; dirPath: PWideChar): HCkTask; stdcall;
  TCkZipEntry_GetDt = function (objHandle: HCkZipEntry): HCkDateTime; stdcall;
  TCkZipEntry_GetNext = function (objHandle: HCkZipEntry): wordbool; stdcall;
  TCkZipEntry_GetNextMatch = function (objHandle: HCkZipEntry; pattern: PWideChar): wordbool; stdcall;
  TCkZipEntry_Inflate = function (objHandle: HCkZipEntry; outData: HCkByteData): wordbool; stdcall;
  TCkZipEntry_InflateAsync = function (objHandle: HCkZipEntry): HCkTask; stdcall;
  TCkZipEntry_LoadTaskCaller = function (objHandle: HCkZipEntry; task: HCkTask): wordbool; stdcall;
  TCkZipEntry_NextEntry = function (objHandle: HCkZipEntry): HCkZipEntry; stdcall;
  TCkZipEntry_NextMatchingEntry = function (objHandle: HCkZipEntry; matchStr: PWideChar): HCkZipEntry; stdcall;
  TCkZipEntry_ReplaceData = function (objHandle: HCkZipEntry; inData: HCkByteData): wordbool; stdcall;
  TCkZipEntry_ReplaceString = function (objHandle: HCkZipEntry; strContent: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkZipEntry_SetDt = procedure (objHandle: HCkZipEntry; dt: HCkDateTime); stdcall;
  TCkZipEntry_UnzipToBd = function (objHandle: HCkZipEntry; binData: HCkBinData): wordbool; stdcall;
  TCkZipEntry_UnzipToBdAsync = function (objHandle: HCkZipEntry; binData: HCkBinData): HCkTask; stdcall;
  TCkZipEntry_UnzipToSb = function (objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar; sb: HCkStringBuilder): wordbool; stdcall;
  TCkZipEntry_UnzipToSbAsync = function (objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar; sb: HCkStringBuilder): HCkTask; stdcall;
  TCkZipEntry_UnzipToStream = function (objHandle: HCkZipEntry; toStream: HCkStream): wordbool; stdcall;
  TCkZipEntry_UnzipToStreamAsync = function (objHandle: HCkZipEntry; toStream: HCkStream): HCkTask; stdcall;
  TCkZipEntry_UnzipToString = function (objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkZipEntry__unzipToString = function (objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar): PWideChar; stdcall;
  TCkZipEntry_UnzipToStringAsync = function (objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..86] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkZipEntry_Create : HCkZipEntry;
begin
  result := TCkZipEntry_Create(_map(0, 'CkZipEntry_Create'));
end;

procedure CkZipEntry_Dispose (handle: HCkZipEntry);
begin
  TCkZipEntry_Dispose(_map(1, 'CkZipEntry_Dispose'))
    (handle);
end;


procedure CkZipEntry_SetAbortCheck (objHandle: HCkZipEntry; fn: TZipEntryAbortCheck);
begin
    TCkZipEntry_SetAbortCheck(_map(2, 'CkZipEntry_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkZipEntry_SetProgressInfo (objHandle: HCkZipEntry; fn: TZipEntryProgressInfo);
begin
    TCkZipEntry_SetProgressInfo(_map(3, 'CkZipEntry_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkZipEntry_SetPercentDone (objHandle: HCkZipEntry; fn: TZipEntryPercentDone);
begin
    TCkZipEntry_SetPercentDone(_map(4, 'CkZipEntry_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkZipEntry_SetTaskCompleted (objHandle: HCkZipEntry; fn: TZipEntryTaskCompleted);
begin
    TCkZipEntry_SetTaskCompleted(_map(5, 'CkZipEntry_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkZipEntry_getComment (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getComment(_map(6, 'CkZipEntry_getComment'))
    (objHandle, outPropVal);
end;

procedure CkZipEntry_putComment (objHandle: HCkZipEntry; newPropVal: PWideChar);
begin
  TCkZipEntry_putComment(_map(7, 'CkZipEntry_putComment'))
    (objHandle, newPropVal);
end;

function CkZipEntry__comment (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__comment(_map(8, 'CkZipEntry__comment'))
    (objHandle);
end;

function CkZipEntry_getCompressedLength (objHandle: HCkZipEntry): LongWord;
begin
    result := TCkZipEntry_getCompressedLength(_map(9, 'CkZipEntry_getCompressedLength'))
    (objHandle);
end;

function CkZipEntry_getCompressedLength64 (objHandle: HCkZipEntry): Int64;
begin
    result := TCkZipEntry_getCompressedLength64(_map(10, 'CkZipEntry_getCompressedLength64'))
    (objHandle);
end;

procedure CkZipEntry_getCompressedLengthStr (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getCompressedLengthStr(_map(11, 'CkZipEntry_getCompressedLengthStr'))
    (objHandle, outPropVal);
end;

function CkZipEntry__compressedLengthStr (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__compressedLengthStr(_map(12, 'CkZipEntry__compressedLengthStr'))
    (objHandle);
end;

function CkZipEntry_getCompressionLevel (objHandle: HCkZipEntry): Integer;
begin
    result := TCkZipEntry_getCompressionLevel(_map(13, 'CkZipEntry_getCompressionLevel'))
    (objHandle);
end;

procedure CkZipEntry_putCompressionLevel (objHandle: HCkZipEntry; newPropVal: Integer);
begin
  TCkZipEntry_putCompressionLevel(_map(14, 'CkZipEntry_putCompressionLevel'))
    (objHandle, newPropVal);
end;

function CkZipEntry_getCompressionMethod (objHandle: HCkZipEntry): Integer;
begin
    result := TCkZipEntry_getCompressionMethod(_map(15, 'CkZipEntry_getCompressionMethod'))
    (objHandle);
end;

procedure CkZipEntry_putCompressionMethod (objHandle: HCkZipEntry; newPropVal: Integer);
begin
  TCkZipEntry_putCompressionMethod(_map(16, 'CkZipEntry_putCompressionMethod'))
    (objHandle, newPropVal);
end;

function CkZipEntry_getCrc (objHandle: HCkZipEntry): Integer;
begin
    result := TCkZipEntry_getCrc(_map(17, 'CkZipEntry_getCrc'))
    (objHandle);
end;

procedure CkZipEntry_getDebugLogFilePath (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getDebugLogFilePath(_map(18, 'CkZipEntry_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkZipEntry_putDebugLogFilePath (objHandle: HCkZipEntry; newPropVal: PWideChar);
begin
  TCkZipEntry_putDebugLogFilePath(_map(19, 'CkZipEntry_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkZipEntry__debugLogFilePath (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__debugLogFilePath(_map(20, 'CkZipEntry__debugLogFilePath'))
    (objHandle);
end;

function CkZipEntry_getEncryptionKeyLen (objHandle: HCkZipEntry): Integer;
begin
    result := TCkZipEntry_getEncryptionKeyLen(_map(21, 'CkZipEntry_getEncryptionKeyLen'))
    (objHandle);
end;

function CkZipEntry_getEntryID (objHandle: HCkZipEntry): Integer;
begin
    result := TCkZipEntry_getEntryID(_map(22, 'CkZipEntry_getEntryID'))
    (objHandle);
end;

function CkZipEntry_getEntryType (objHandle: HCkZipEntry): Integer;
begin
    result := TCkZipEntry_getEntryType(_map(23, 'CkZipEntry_getEntryType'))
    (objHandle);
end;

procedure CkZipEntry_getFileDateTimeStr (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getFileDateTimeStr(_map(24, 'CkZipEntry_getFileDateTimeStr'))
    (objHandle, outPropVal);
end;

procedure CkZipEntry_putFileDateTimeStr (objHandle: HCkZipEntry; newPropVal: PWideChar);
begin
  TCkZipEntry_putFileDateTimeStr(_map(25, 'CkZipEntry_putFileDateTimeStr'))
    (objHandle, newPropVal);
end;

function CkZipEntry__fileDateTimeStr (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__fileDateTimeStr(_map(26, 'CkZipEntry__fileDateTimeStr'))
    (objHandle);
end;

procedure CkZipEntry_getFileName (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getFileName(_map(27, 'CkZipEntry_getFileName'))
    (objHandle, outPropVal);
end;

procedure CkZipEntry_putFileName (objHandle: HCkZipEntry; newPropVal: PWideChar);
begin
  TCkZipEntry_putFileName(_map(28, 'CkZipEntry_putFileName'))
    (objHandle, newPropVal);
end;

function CkZipEntry__fileName (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__fileName(_map(29, 'CkZipEntry__fileName'))
    (objHandle);
end;

procedure CkZipEntry_getFileNameHex (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getFileNameHex(_map(30, 'CkZipEntry_getFileNameHex'))
    (objHandle, outPropVal);
end;

function CkZipEntry__fileNameHex (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__fileNameHex(_map(31, 'CkZipEntry__fileNameHex'))
    (objHandle);
end;

function CkZipEntry_getHeartbeatMs (objHandle: HCkZipEntry): Integer;
begin
    result := TCkZipEntry_getHeartbeatMs(_map(32, 'CkZipEntry_getHeartbeatMs'))
    (objHandle);
end;

procedure CkZipEntry_putHeartbeatMs (objHandle: HCkZipEntry; newPropVal: Integer);
begin
  TCkZipEntry_putHeartbeatMs(_map(33, 'CkZipEntry_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

function CkZipEntry_getIsAesEncrypted (objHandle: HCkZipEntry): wordbool;
begin
    result := TCkZipEntry_getIsAesEncrypted(_map(34, 'CkZipEntry_getIsAesEncrypted'))
    (objHandle);
end;

function CkZipEntry_getIsDirectory (objHandle: HCkZipEntry): wordbool;
begin
    result := TCkZipEntry_getIsDirectory(_map(35, 'CkZipEntry_getIsDirectory'))
    (objHandle);
end;

procedure CkZipEntry_getLastErrorHtml (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getLastErrorHtml(_map(36, 'CkZipEntry_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkZipEntry__lastErrorHtml (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__lastErrorHtml(_map(37, 'CkZipEntry__lastErrorHtml'))
    (objHandle);
end;

procedure CkZipEntry_getLastErrorText (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getLastErrorText(_map(38, 'CkZipEntry_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkZipEntry__lastErrorText (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__lastErrorText(_map(39, 'CkZipEntry__lastErrorText'))
    (objHandle);
end;

procedure CkZipEntry_getLastErrorXml (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getLastErrorXml(_map(40, 'CkZipEntry_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkZipEntry__lastErrorXml (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__lastErrorXml(_map(41, 'CkZipEntry__lastErrorXml'))
    (objHandle);
end;

function CkZipEntry_getLastMethodSuccess (objHandle: HCkZipEntry): wordbool;
begin
    result := TCkZipEntry_getLastMethodSuccess(_map(42, 'CkZipEntry_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkZipEntry_putLastMethodSuccess (objHandle: HCkZipEntry; newPropVal: wordbool);
begin
  TCkZipEntry_putLastMethodSuccess(_map(43, 'CkZipEntry_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkZipEntry_getTextFlag (objHandle: HCkZipEntry): wordbool;
begin
    result := TCkZipEntry_getTextFlag(_map(44, 'CkZipEntry_getTextFlag'))
    (objHandle);
end;

procedure CkZipEntry_putTextFlag (objHandle: HCkZipEntry; newPropVal: wordbool);
begin
  TCkZipEntry_putTextFlag(_map(45, 'CkZipEntry_putTextFlag'))
    (objHandle, newPropVal);
end;

function CkZipEntry_getUncompressedLength (objHandle: HCkZipEntry): LongWord;
begin
    result := TCkZipEntry_getUncompressedLength(_map(46, 'CkZipEntry_getUncompressedLength'))
    (objHandle);
end;

function CkZipEntry_getUncompressedLength64 (objHandle: HCkZipEntry): Int64;
begin
    result := TCkZipEntry_getUncompressedLength64(_map(47, 'CkZipEntry_getUncompressedLength64'))
    (objHandle);
end;

procedure CkZipEntry_getUncompressedLengthStr (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getUncompressedLengthStr(_map(48, 'CkZipEntry_getUncompressedLengthStr'))
    (objHandle, outPropVal);
end;

function CkZipEntry__uncompressedLengthStr (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__uncompressedLengthStr(_map(49, 'CkZipEntry__uncompressedLengthStr'))
    (objHandle);
end;

function CkZipEntry_getVerboseLogging (objHandle: HCkZipEntry): wordbool;
begin
    result := TCkZipEntry_getVerboseLogging(_map(50, 'CkZipEntry_getVerboseLogging'))
    (objHandle);
end;

procedure CkZipEntry_putVerboseLogging (objHandle: HCkZipEntry; newPropVal: wordbool);
begin
  TCkZipEntry_putVerboseLogging(_map(51, 'CkZipEntry_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkZipEntry_getVersion (objHandle: HCkZipEntry; outPropVal: HCkString);
begin
  TCkZipEntry_getVersion(_map(52, 'CkZipEntry_getVersion'))
    (objHandle, outPropVal);
end;

function CkZipEntry__version (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__version(_map(53, 'CkZipEntry__version'))
    (objHandle);
end;

function CkZipEntry_AppendData (objHandle: HCkZipEntry; inData: HCkByteData): wordbool;
begin
  result := TCkZipEntry_AppendData(_map(54, 'CkZipEntry_AppendData'))
    (objHandle, inData);
end;

function CkZipEntry_AppendDataAsync (objHandle: HCkZipEntry; inData: HCkByteData): HCkTask;
begin
  result := TCkZipEntry_AppendDataAsync(_map(55, 'CkZipEntry_AppendDataAsync'))
    (objHandle, inData);
end;

function CkZipEntry_AppendString (objHandle: HCkZipEntry; strContent: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkZipEntry_AppendString(_map(56, 'CkZipEntry_AppendString'))
    (objHandle, strContent, charset);
end;

function CkZipEntry_AppendStringAsync (objHandle: HCkZipEntry; strContent: PWideChar; charset: PWideChar): HCkTask;
begin
  result := TCkZipEntry_AppendStringAsync(_map(57, 'CkZipEntry_AppendStringAsync'))
    (objHandle, strContent, charset);
end;

function CkZipEntry_Copy (objHandle: HCkZipEntry; outData: HCkByteData): wordbool;
begin
  result := TCkZipEntry_Copy(_map(58, 'CkZipEntry_Copy'))
    (objHandle, outData);
end;

function CkZipEntry_CopyToBase64 (objHandle: HCkZipEntry; outStr: HCkString): wordbool;
begin
  result := TCkZipEntry_CopyToBase64(_map(59, 'CkZipEntry_CopyToBase64'))
    (objHandle, outStr);
end;

function CkZipEntry__copyToBase64 (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__copyToBase64(_map(60, 'CkZipEntry__copyToBase64'))
    (objHandle);
end;

function CkZipEntry_CopyToHex (objHandle: HCkZipEntry; outStr: HCkString): wordbool;
begin
  result := TCkZipEntry_CopyToHex(_map(61, 'CkZipEntry_CopyToHex'))
    (objHandle, outStr);
end;

function CkZipEntry__copyToHex (objHandle: HCkZipEntry): PWideChar;
begin
  result := TCkZipEntry__copyToHex(_map(62, 'CkZipEntry__copyToHex'))
    (objHandle);
end;

function CkZipEntry_Extract (objHandle: HCkZipEntry; dirPath: PWideChar): wordbool;
begin
  result := TCkZipEntry_Extract(_map(63, 'CkZipEntry_Extract'))
    (objHandle, dirPath);
end;

function CkZipEntry_ExtractAsync (objHandle: HCkZipEntry; dirPath: PWideChar): HCkTask;
begin
  result := TCkZipEntry_ExtractAsync(_map(64, 'CkZipEntry_ExtractAsync'))
    (objHandle, dirPath);
end;

function CkZipEntry_ExtractInto (objHandle: HCkZipEntry; dirPath: PWideChar): wordbool;
begin
  result := TCkZipEntry_ExtractInto(_map(65, 'CkZipEntry_ExtractInto'))
    (objHandle, dirPath);
end;

function CkZipEntry_ExtractIntoAsync (objHandle: HCkZipEntry; dirPath: PWideChar): HCkTask;
begin
  result := TCkZipEntry_ExtractIntoAsync(_map(66, 'CkZipEntry_ExtractIntoAsync'))
    (objHandle, dirPath);
end;

function CkZipEntry_GetDt (objHandle: HCkZipEntry): HCkDateTime;
begin
  result := TCkZipEntry_GetDt(_map(67, 'CkZipEntry_GetDt'))
    (objHandle);
end;

function CkZipEntry_GetNext (objHandle: HCkZipEntry): wordbool;
begin
  result := TCkZipEntry_GetNext(_map(68, 'CkZipEntry_GetNext'))
    (objHandle);
end;

function CkZipEntry_GetNextMatch (objHandle: HCkZipEntry; pattern: PWideChar): wordbool;
begin
  result := TCkZipEntry_GetNextMatch(_map(69, 'CkZipEntry_GetNextMatch'))
    (objHandle, pattern);
end;

function CkZipEntry_Inflate (objHandle: HCkZipEntry; outData: HCkByteData): wordbool;
begin
  result := TCkZipEntry_Inflate(_map(70, 'CkZipEntry_Inflate'))
    (objHandle, outData);
end;

function CkZipEntry_InflateAsync (objHandle: HCkZipEntry): HCkTask;
begin
  result := TCkZipEntry_InflateAsync(_map(71, 'CkZipEntry_InflateAsync'))
    (objHandle);
end;

function CkZipEntry_LoadTaskCaller (objHandle: HCkZipEntry; task: HCkTask): wordbool;
begin
  result := TCkZipEntry_LoadTaskCaller(_map(72, 'CkZipEntry_LoadTaskCaller'))
    (objHandle, task);
end;

function CkZipEntry_NextEntry (objHandle: HCkZipEntry): HCkZipEntry;
begin
  result := TCkZipEntry_NextEntry(_map(73, 'CkZipEntry_NextEntry'))
    (objHandle);
end;

function CkZipEntry_NextMatchingEntry (objHandle: HCkZipEntry; matchStr: PWideChar): HCkZipEntry;
begin
  result := TCkZipEntry_NextMatchingEntry(_map(74, 'CkZipEntry_NextMatchingEntry'))
    (objHandle, matchStr);
end;

function CkZipEntry_ReplaceData (objHandle: HCkZipEntry; inData: HCkByteData): wordbool;
begin
  result := TCkZipEntry_ReplaceData(_map(75, 'CkZipEntry_ReplaceData'))
    (objHandle, inData);
end;

function CkZipEntry_ReplaceString (objHandle: HCkZipEntry; strContent: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkZipEntry_ReplaceString(_map(76, 'CkZipEntry_ReplaceString'))
    (objHandle, strContent, charset);
end;

procedure CkZipEntry_SetDt (objHandle: HCkZipEntry; dt: HCkDateTime);
begin
  TCkZipEntry_SetDt(_map(77, 'CkZipEntry_SetDt'))
    (objHandle, dt);
end;

function CkZipEntry_UnzipToBd (objHandle: HCkZipEntry; binData: HCkBinData): wordbool;
begin
  result := TCkZipEntry_UnzipToBd(_map(78, 'CkZipEntry_UnzipToBd'))
    (objHandle, binData);
end;

function CkZipEntry_UnzipToBdAsync (objHandle: HCkZipEntry; binData: HCkBinData): HCkTask;
begin
  result := TCkZipEntry_UnzipToBdAsync(_map(79, 'CkZipEntry_UnzipToBdAsync'))
    (objHandle, binData);
end;

function CkZipEntry_UnzipToSb (objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar; sb: HCkStringBuilder): wordbool;
begin
  result := TCkZipEntry_UnzipToSb(_map(80, 'CkZipEntry_UnzipToSb'))
    (objHandle, lineEndingBehavior, srcCharset, sb);
end;

function CkZipEntry_UnzipToSbAsync (objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar; sb: HCkStringBuilder): HCkTask;
begin
  result := TCkZipEntry_UnzipToSbAsync(_map(81, 'CkZipEntry_UnzipToSbAsync'))
    (objHandle, lineEndingBehavior, srcCharset, sb);
end;

function CkZipEntry_UnzipToStream (objHandle: HCkZipEntry; toStream: HCkStream): wordbool;
begin
  result := TCkZipEntry_UnzipToStream(_map(82, 'CkZipEntry_UnzipToStream'))
    (objHandle, toStream);
end;

function CkZipEntry_UnzipToStreamAsync (objHandle: HCkZipEntry; toStream: HCkStream): HCkTask;
begin
  result := TCkZipEntry_UnzipToStreamAsync(_map(83, 'CkZipEntry_UnzipToStreamAsync'))
    (objHandle, toStream);
end;

function CkZipEntry_UnzipToString (objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkZipEntry_UnzipToString(_map(84, 'CkZipEntry_UnzipToString'))
    (objHandle, lineEndingBehavior, srcCharset, outStr);
end;

function CkZipEntry__unzipToString (objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar): PWideChar;
begin
  result := TCkZipEntry__unzipToString(_map(85, 'CkZipEntry__unzipToString'))
    (objHandle, lineEndingBehavior, srcCharset);
end;

function CkZipEntry_UnzipToStringAsync (objHandle: HCkZipEntry; lineEndingBehavior: Integer; srcCharset: PWideChar): HCkTask;
begin
  result := TCkZipEntry_UnzipToStringAsync(_map(86, 'CkZipEntry_UnzipToStringAsync'))
    (objHandle, lineEndingBehavior, srcCharset);
end;

end.
