unit Ai;

interface

type

HCkJsonObject = Pointer;
HCkSocket = Pointer;
HCkString = Pointer;
HCkBinData = Pointer;
HCkAi = Pointer;
HCkTask = Pointer;
HCkStringTable = Pointer;
HCkStringBuilder = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TAiAbortCheck = function(): Integer; cdecl;
TAiProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TAiPercentDone = function(pctDone: Integer): Integer; cdecl;
TAiTaskCompleted = procedure(task: HCkTask); cdecl;


function CkAi_Create: HCkAi; stdcall;
procedure CkAi_Dispose(handle: HCkAi); stdcall;

procedure CkAi_SetAbortCheck(objHandle: HCkAi; fn: TAiAbortCheck) stdcall;
procedure CkAi_SetProgressInfo(objHandle: HCkAi; fn: TAiProgressInfo) stdcall;
procedure CkAi_SetPercentDone(objHandle: HCkAi; fn: TAiPercentDone) stdcall;
procedure CkAi_SetTaskCompleted(objHandle: HCkAi; fn: TAiTaskCompleted) stdcall;
procedure CkAi_getApiKey(objHandle: HCkAi; outPropVal: HCkString); stdcall;

procedure CkAi_putApiKey(objHandle: HCkAi; newPropVal: PWideChar); stdcall;

function CkAi__apiKey(objHandle: HCkAi): PWideChar; stdcall;

procedure CkAi_getDebugLogFilePath(objHandle: HCkAi; outPropVal: HCkString); stdcall;

procedure CkAi_putDebugLogFilePath(objHandle: HCkAi; newPropVal: PWideChar); stdcall;

function CkAi__debugLogFilePath(objHandle: HCkAi): PWideChar; stdcall;

function CkAi_getFullTranscript(objHandle: HCkAi): wordbool; stdcall;

procedure CkAi_putFullTranscript(objHandle: HCkAi; newPropVal: wordbool); stdcall;

function CkAi_getHeartbeatMs(objHandle: HCkAi): Integer; stdcall;

procedure CkAi_putHeartbeatMs(objHandle: HCkAi; newPropVal: Integer); stdcall;

function CkAi_getHostedConvo(objHandle: HCkAi): wordbool; stdcall;

procedure CkAi_putHostedConvo(objHandle: HCkAi; newPropVal: wordbool); stdcall;

function CkAi_getIdleTimeoutMs(objHandle: HCkAi): Integer; stdcall;

procedure CkAi_putIdleTimeoutMs(objHandle: HCkAi; newPropVal: Integer); stdcall;

procedure CkAi_getLastErrorHtml(objHandle: HCkAi; outPropVal: HCkString); stdcall;

function CkAi__lastErrorHtml(objHandle: HCkAi): PWideChar; stdcall;

procedure CkAi_getLastErrorText(objHandle: HCkAi; outPropVal: HCkString); stdcall;

function CkAi__lastErrorText(objHandle: HCkAi): PWideChar; stdcall;

procedure CkAi_getLastErrorXml(objHandle: HCkAi; outPropVal: HCkString); stdcall;

function CkAi__lastErrorXml(objHandle: HCkAi): PWideChar; stdcall;

function CkAi_getLastMethodSuccess(objHandle: HCkAi): wordbool; stdcall;

procedure CkAi_putLastMethodSuccess(objHandle: HCkAi; newPropVal: wordbool); stdcall;

procedure CkAi_getModel(objHandle: HCkAi; outPropVal: HCkString); stdcall;

procedure CkAi_putModel(objHandle: HCkAi; newPropVal: PWideChar); stdcall;

function CkAi__model(objHandle: HCkAi): PWideChar; stdcall;

procedure CkAi_getProvider(objHandle: HCkAi; outPropVal: HCkString); stdcall;

procedure CkAi_putProvider(objHandle: HCkAi; newPropVal: PWideChar); stdcall;

function CkAi__provider(objHandle: HCkAi): PWideChar; stdcall;

function CkAi_getResponseStatusCode(objHandle: HCkAi): Integer; stdcall;

procedure CkAi_getSelectedConvo(objHandle: HCkAi; outPropVal: HCkString); stdcall;

procedure CkAi_putSelectedConvo(objHandle: HCkAi; newPropVal: PWideChar); stdcall;

function CkAi__selectedConvo(objHandle: HCkAi): PWideChar; stdcall;

function CkAi_getStreaming(objHandle: HCkAi): wordbool; stdcall;

procedure CkAi_putStreaming(objHandle: HCkAi; newPropVal: wordbool); stdcall;

procedure CkAi_getUncommonOptions(objHandle: HCkAi; outPropVal: HCkString); stdcall;

procedure CkAi_putUncommonOptions(objHandle: HCkAi; newPropVal: PWideChar); stdcall;

function CkAi__uncommonOptions(objHandle: HCkAi): PWideChar; stdcall;

function CkAi_getVerboseLogging(objHandle: HCkAi): wordbool; stdcall;

procedure CkAi_putVerboseLogging(objHandle: HCkAi; newPropVal: wordbool); stdcall;

procedure CkAi_getVersion(objHandle: HCkAi; outPropVal: HCkString); stdcall;

function CkAi__version(objHandle: HCkAi): PWideChar; stdcall;

function CkAi_Ask(objHandle: HCkAi; outputType: PWideChar): wordbool; stdcall;

function CkAi_AskAsync(objHandle: HCkAi; outputType: PWideChar): HCkTask; stdcall;

function CkAi_DeleteConvo(objHandle: HCkAi; name: PWideChar): wordbool; stdcall;

function CkAi_ExportConvo(objHandle: HCkAi; name: PWideChar; json: HCkJsonObject): wordbool; stdcall;

procedure CkAi_GetLastJsonData(objHandle: HCkAi; json: HCkJsonObject); stdcall;

function CkAi_GetModels(objHandle: HCkAi; st: HCkStringTable): wordbool; stdcall;

function CkAi_GetModelsAsync(objHandle: HCkAi; st: HCkStringTable): HCkTask; stdcall;

function CkAi_GetOutputText(objHandle: HCkAi; outStr: HCkString): wordbool; stdcall;

function CkAi__getOutputText(objHandle: HCkAi): PWideChar; stdcall;

function CkAi_GetOutputTextSb(objHandle: HCkAi; sb: HCkStringBuilder): wordbool; stdcall;

function CkAi_ImportConvo(objHandle: HCkAi; name: PWideChar; json: HCkJsonObject): wordbool; stdcall;

function CkAi_InputAddFileData(objHandle: HCkAi; filename: PWideChar; bd: HCkBinData; summary: PWideChar): wordbool; stdcall;

function CkAi_InputAddFileUrl(objHandle: HCkAi; url: PWideChar; summary: PWideChar): wordbool; stdcall;

function CkAi_InputAddImageData(objHandle: HCkAi; bd: HCkBinData; summary: PWideChar): wordbool; stdcall;

function CkAi_InputAddImageUrl(objHandle: HCkAi; url: PWideChar; summary: PWideChar): wordbool; stdcall;

function CkAi_InputAddText(objHandle: HCkAi; text: PWideChar): wordbool; stdcall;

function CkAi_InputAddTextSb(objHandle: HCkAi; sb: HCkStringBuilder): wordbool; stdcall;

procedure CkAi_InputClear(objHandle: HCkAi); stdcall;

function CkAi_ListConvos(objHandle: HCkAi; st: HCkStringTable): wordbool; stdcall;

function CkAi_NewConvo(objHandle: HCkAi; name: PWideChar; sysMsg: PWideChar; devMsg: PWideChar): wordbool; stdcall;

function CkAi_NextAiEvent(objHandle: HCkAi; maxWaitMs: Integer; sbName: HCkStringBuilder; sbDelta: HCkStringBuilder): wordbool; stdcall;

function CkAi_PollAi(objHandle: HCkAi; abort: wordbool): Integer; stdcall;

function CkAi_SetConnectionSettings(objHandle: HCkAi; sock: HCkSocket): wordbool; stdcall;

procedure CkAi_SleepMs(objHandle: HCkAi; millisec: Integer); stdcall;

implementation

{$Include chilkatDllPath.inc}

function CkAi_Create; external DLLName;
procedure CkAi_Dispose; external DLLName;

procedure CkAi_SetAbortCheck; external DLLName;
procedure CkAi_SetProgressInfo; external DLLName;
procedure CkAi_SetPercentDone; external DLLName;
procedure CkAi_SetTaskCompleted; external DLLName;
procedure CkAi_getApiKey; external DLLName;
procedure CkAi_putApiKey; external DLLName;
function CkAi__apiKey; external DLLName;
procedure CkAi_getDebugLogFilePath; external DLLName;
procedure CkAi_putDebugLogFilePath; external DLLName;
function CkAi__debugLogFilePath; external DLLName;
function CkAi_getFullTranscript; external DLLName;
procedure CkAi_putFullTranscript; external DLLName;
function CkAi_getHeartbeatMs; external DLLName;
procedure CkAi_putHeartbeatMs; external DLLName;
function CkAi_getHostedConvo; external DLLName;
procedure CkAi_putHostedConvo; external DLLName;
function CkAi_getIdleTimeoutMs; external DLLName;
procedure CkAi_putIdleTimeoutMs; external DLLName;
procedure CkAi_getLastErrorHtml; external DLLName;
function CkAi__lastErrorHtml; external DLLName;
procedure CkAi_getLastErrorText; external DLLName;
function CkAi__lastErrorText; external DLLName;
procedure CkAi_getLastErrorXml; external DLLName;
function CkAi__lastErrorXml; external DLLName;
function CkAi_getLastMethodSuccess; external DLLName;
procedure CkAi_putLastMethodSuccess; external DLLName;
procedure CkAi_getModel; external DLLName;
procedure CkAi_putModel; external DLLName;
function CkAi__model; external DLLName;
procedure CkAi_getProvider; external DLLName;
procedure CkAi_putProvider; external DLLName;
function CkAi__provider; external DLLName;
function CkAi_getResponseStatusCode; external DLLName;
procedure CkAi_getSelectedConvo; external DLLName;
procedure CkAi_putSelectedConvo; external DLLName;
function CkAi__selectedConvo; external DLLName;
function CkAi_getStreaming; external DLLName;
procedure CkAi_putStreaming; external DLLName;
procedure CkAi_getUncommonOptions; external DLLName;
procedure CkAi_putUncommonOptions; external DLLName;
function CkAi__uncommonOptions; external DLLName;
function CkAi_getVerboseLogging; external DLLName;
procedure CkAi_putVerboseLogging; external DLLName;
procedure CkAi_getVersion; external DLLName;
function CkAi__version; external DLLName;
function CkAi_Ask; external DLLName;
function CkAi_AskAsync; external DLLName;
function CkAi_DeleteConvo; external DLLName;
function CkAi_ExportConvo; external DLLName;
procedure CkAi_GetLastJsonData; external DLLName;
function CkAi_GetModels; external DLLName;
function CkAi_GetModelsAsync; external DLLName;
function CkAi_GetOutputText; external DLLName;
function CkAi__getOutputText; external DLLName;
function CkAi_GetOutputTextSb; external DLLName;
function CkAi_ImportConvo; external DLLName;
function CkAi_InputAddFileData; external DLLName;
function CkAi_InputAddFileUrl; external DLLName;
function CkAi_InputAddImageData; external DLLName;
function CkAi_InputAddImageUrl; external DLLName;
function CkAi_InputAddText; external DLLName;
function CkAi_InputAddTextSb; external DLLName;
procedure CkAi_InputClear; external DLLName;
function CkAi_ListConvos; external DLLName;
function CkAi_NewConvo; external DLLName;
function CkAi_NextAiEvent; external DLLName;
function CkAi_PollAi; external DLLName;
function CkAi_SetConnectionSettings; external DLLName;
procedure CkAi_SleepMs; external DLLName;



end.
