// Chilkat Objective-C header.
// This is a generated header file for Chilkat version 11.2.0

// Generic/internal class name =  Secrets
// Wrapped Chilkat C++ class name =  CkSecrets

@class CkoJsonObject;
@class CkoTask;
@class CkoBinData;
@class CkoStringBuilder;


@class CkoBaseProgress;

@interface CkoSecrets : NSObject {

	@private
		void *m_eventCallback;
		void *m_obj;

}

- (id)init;
- (void)dealloc;
- (void)dispose;
- (NSString *)stringWithUtf8: (const char *)s;
- (void *)CppImplObj;
- (void)setCppImplObj: (void *)pObj;

- (void)clearCppImplObj;

// property setter: EventCallbackObject
- (void)setEventCallbackObject: (CkoBaseProgress *)eventObj;

@property (nonatomic) BOOL AutoSplit;
@property (nonatomic) BOOL Compression;
@property (nonatomic, copy) NSString *DebugLogFilePath;
@property (nonatomic, readonly, copy) NSString *LastErrorHtml;
@property (nonatomic, readonly, copy) NSString *LastErrorText;
@property (nonatomic, readonly, copy) NSString *LastErrorXml;
@property (nonatomic) BOOL LastMethodSuccess;
@property (nonatomic, copy) NSString *Location;
@property (nonatomic, copy) NSString *UncommonOptions;
@property (nonatomic) BOOL VerboseLogging;
@property (nonatomic, readonly, copy) NSString *Version;
// method: DeleteSecret
- (BOOL)DeleteSecret: (CkoJsonObject *)jsonId;
// method: DeleteSecretAsync
- (CkoTask *)DeleteSecretAsync: (CkoJsonObject *)jsonId;
// method: GetSecretBd
- (BOOL)GetSecretBd: (CkoJsonObject *)jsonId 
	bd: (CkoBinData *)bd;
// method: GetSecretBdAsync
- (CkoTask *)GetSecretBdAsync: (CkoJsonObject *)jsonId 
	bd: (CkoBinData *)bd;
// method: GetSecretJson
- (BOOL)GetSecretJson: (CkoJsonObject *)jsonId 
	jsonOut: (CkoJsonObject *)jsonOut;
// method: GetSecretJsonAsync
- (CkoTask *)GetSecretJsonAsync: (CkoJsonObject *)jsonId 
	jsonOut: (CkoJsonObject *)jsonOut;
// method: GetSecretSb
- (BOOL)GetSecretSb: (CkoJsonObject *)jsonId 
	sb: (CkoStringBuilder *)sb;
// method: GetSecretSbAsync
- (CkoTask *)GetSecretSbAsync: (CkoJsonObject *)jsonId 
	sb: (CkoStringBuilder *)sb;
// method: GetSecretStr
- (NSString *)GetSecretStr: (CkoJsonObject *)jsonId;
// method: GetSecretStrAsync
- (CkoTask *)GetSecretStrAsync: (CkoJsonObject *)jsonId;
// method: ListSecrets
- (BOOL)ListSecrets: (CkoJsonObject *)json 
	jsonOut: (CkoJsonObject *)jsonOut;
// method: ListSecretsAsync
- (CkoTask *)ListSecretsAsync: (CkoJsonObject *)json 
	jsonOut: (CkoJsonObject *)jsonOut;
// method: SetBootstrapSecret
- (BOOL)SetBootstrapSecret: (CkoJsonObject *)jsonId 
	secretContent: (CkoSecrets *)secretContent;
// method: UpdateSecretBd
- (BOOL)UpdateSecretBd: (CkoJsonObject *)jsonId 
	secret: (CkoBinData *)secret;
// method: UpdateSecretBdAsync
- (CkoTask *)UpdateSecretBdAsync: (CkoJsonObject *)jsonId 
	secret: (CkoBinData *)secret;
// method: UpdateSecretJson
- (BOOL)UpdateSecretJson: (CkoJsonObject *)jsonId 
	secret: (CkoJsonObject *)secret;
// method: UpdateSecretJsonAsync
- (CkoTask *)UpdateSecretJsonAsync: (CkoJsonObject *)jsonId 
	secret: (CkoJsonObject *)secret;
// method: UpdateSecretSb
- (BOOL)UpdateSecretSb: (CkoJsonObject *)jsonId 
	sb: (CkoStringBuilder *)sb;
// method: UpdateSecretSbAsync
- (CkoTask *)UpdateSecretSbAsync: (CkoJsonObject *)jsonId 
	sb: (CkoStringBuilder *)sb;
// method: UpdateSecretStr
- (BOOL)UpdateSecretStr: (CkoJsonObject *)jsonId 
	secret: (NSString *)secret;
// method: UpdateSecretStrAsync
- (CkoTask *)UpdateSecretStrAsync: (CkoJsonObject *)jsonId 
	secret: (NSString *)secret;

@end
