// CkSecretsU.h: interface for the CkSecretsU class.
//
//////////////////////////////////////////////////////////////////////

// This header is generated for Chilkat 11.2.0

#ifndef _CkSecretsU_H
#define _CkSecretsU_H
	
#include "../../Cpp/include/chilkatDefs.h"
#include "../../Cpp/include/CkString.h"
#include "CkClassWithCallbacksU.h"

class CkJsonObjectU;
class CkTaskU;
class CkBinDataU;
class CkStringBuilderU;
class CkBaseProgressU;



#if !defined(__sun__) && !defined(__sun)
#pragma pack (push, 8)
#endif
 

// CLASS: CkSecretsU
class CK_VISIBLE_PUBLIC CkSecretsU  : public CkClassWithCallbacksU
{
	public:
	bool m_cbOwned;

	private:
	
	// Don't allow assignment or copying these objects.
	CkSecretsU(const CkSecretsU &);
	CkSecretsU &operator=(const CkSecretsU &);

    public:
	CkSecretsU(void);
	virtual ~CkSecretsU(void);

	

	static CkSecretsU *createNew(void);
	

	CkSecretsU(bool bCallbackOwned);
	static CkSecretsU *createNew(bool bCallbackOwned);

	
	void CK_VISIBLE_PRIVATE inject(void *impl);

	// May be called when finished with the object to free/dispose of any
	// internal resources held by the object. 
	void dispose(void);

	CkBaseProgressU *get_EventCallbackObject(void) const;
	void put_EventCallbackObject(CkBaseProgressU *progress);


	// BEGIN PUBLIC INTERFACE

	// ----------------------
	// Properties
	// ----------------------
	// The AutoSplit property is specific to local_manager secrets on Windows. The
	// Windows Credentials Manager supports a maximum of 2560 bytes per secret. If a
	// secret exceeds this size, it will be automatically compressed and split when
	// created or updated, and automatically recomposed when retrieved.
	// 
	// A secret can be split into a maximum of 10 parts.
	// 
	// The default value is true.
	// 
	bool get_AutoSplit(void);
	// The AutoSplit property is specific to local_manager secrets on Windows. The
	// Windows Credentials Manager supports a maximum of 2560 bytes per secret. If a
	// secret exceeds this size, it will be automatically compressed and split when
	// created or updated, and automatically recomposed when retrieved.
	// 
	// A secret can be split into a maximum of 10 parts.
	// 
	// The default value is true.
	// 
	void put_AutoSplit(bool newVal);

	// If set to true, then the contents of the secret will be stored compressed. The
	// default value of this property is false.
	bool get_Compression(void);
	// If set to true, then the contents of the secret will be stored compressed. The
	// default value of this property is false.
	void put_Compression(bool newVal);

	// The location of the secrets. Possible values are:
	//     * local_manager - On Windows this is the Credentials Manager. On MacOS and
	//     iOS it is the Keychain. This is not yet an option on Linux or Android.
	//     * aws_secrets_manager - AWS Secrets Manager
	//     * azure_key_vault - Azure Key Vault
	//     * ibm_cloud - IBM Cloud Secrets Manager
	//     * oracle_cloud - Oracle Cloud Secrets
	//     * doppler - Doppler Secrets
	//     * memory - In-Memory Secrets
	// 
	// The default location is the local_manager . On Linux and Android, local_manager
	// will behave the same as memory .
	// 
	void get_Location(CkString &str);
	// The location of the secrets. Possible values are:
	//     * local_manager - On Windows this is the Credentials Manager. On MacOS and
	//     iOS it is the Keychain. This is not yet an option on Linux or Android.
	//     * aws_secrets_manager - AWS Secrets Manager
	//     * azure_key_vault - Azure Key Vault
	//     * ibm_cloud - IBM Cloud Secrets Manager
	//     * oracle_cloud - Oracle Cloud Secrets
	//     * doppler - Doppler Secrets
	//     * memory - In-Memory Secrets
	// 
	// The default location is the local_manager . On Linux and Android, local_manager
	// will behave the same as memory .
	// 
	const uint16_t *location(void);
	// The location of the secrets. Possible values are:
	//     * local_manager - On Windows this is the Credentials Manager. On MacOS and
	//     iOS it is the Keychain. This is not yet an option on Linux or Android.
	//     * aws_secrets_manager - AWS Secrets Manager
	//     * azure_key_vault - Azure Key Vault
	//     * ibm_cloud - IBM Cloud Secrets Manager
	//     * oracle_cloud - Oracle Cloud Secrets
	//     * doppler - Doppler Secrets
	//     * memory - In-Memory Secrets
	// 
	// The default location is the local_manager . On Linux and Android, local_manager
	// will behave the same as memory .
	// 
	void put_Location(const uint16_t *newVal);

	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string and should typically remain empty.
	void get_UncommonOptions(CkString &str);
	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string and should typically remain empty.
	const uint16_t *uncommonOptions(void);
	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string and should typically remain empty.
	void put_UncommonOptions(const uint16_t *newVal);



	// ----------------------
	// Methods
	// ----------------------
	// Deletes a secret. Cloud secrets managers will typically disable the secret and
	// schedule the secret for deletion after some number of days.
	bool DeleteSecret(CkJsonObjectU &jsonId);

	// Creates an asynchronous task to call the DeleteSecret method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *DeleteSecretAsync(CkJsonObjectU &jsonId);

	// Fetches a binary secret and returns the content in bd.
	bool GetSecretBd(CkJsonObjectU &jsonId, CkBinDataU &bd);

	// Creates an asynchronous task to call the GetSecretBd method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *GetSecretBdAsync(CkJsonObjectU &jsonId, CkBinDataU &bd);

	// Fetches a JSON secret and returns the content in jsonOut.
	bool GetSecretJson(CkJsonObjectU &jsonId, CkJsonObjectU &jsonOut);

	// Creates an asynchronous task to call the GetSecretJson method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *GetSecretJsonAsync(CkJsonObjectU &jsonId, CkJsonObjectU &jsonOut);

	// Fetches a string secret and returns the content in sb.
	bool GetSecretSb(CkJsonObjectU &jsonId, CkStringBuilderU &sb);

	// Creates an asynchronous task to call the GetSecretSb method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *GetSecretSbAsync(CkJsonObjectU &jsonId, CkStringBuilderU &sb);

	// Fetches a string secret and returns the content of the secret.
	bool GetSecretStr(CkJsonObjectU &jsonId, CkString &outStr);
	// Fetches a string secret and returns the content of the secret.
	const uint16_t *getSecretStr(CkJsonObjectU &jsonId);
	// Fetches a string secret and returns the content of the secret.
	const uint16_t *secretStr(CkJsonObjectU &jsonId);

	// Creates an asynchronous task to call the GetSecretStr method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *GetSecretStrAsync(CkJsonObjectU &jsonId);

	// Lists secrets matching the wildcarded or exact values passed in json. The
	// results of the query are returned in jsonOut.
	bool ListSecrets(CkJsonObjectU &json, CkJsonObjectU &jsonOut);

	// Creates an asynchronous task to call the ListSecrets method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *ListSecretsAsync(CkJsonObjectU &json, CkJsonObjectU &jsonOut);

	// Accessing a cloud-based secrets manager requires authentication credentials,
	// which cannot be stored in the manager itself. Instead, they must be securely
	// stored locally.
	// 
	// One solution is to store the authentication credentials as a secret in the
	// Windows Credentials Manager or Apple Keychain. These credentials serve as the
	// bootstrap secret for authenticating with the cloud-based secrets manager.
	// 
	// jsonId contains the name of the bootstrap secret. secretContent contains the bootstrap's
	// secret content.
	// 
	bool SetBootstrapSecret(CkJsonObjectU &jsonId, CkSecretsU &secretContent);

	// Creates a binary secret if it does not yet exist, or updates an existing secret.
	// The name of the secret is specified in jsonId, and the binary content of the
	// secret in secret.
	bool UpdateSecretBd(CkJsonObjectU &jsonId, CkBinDataU &secret);

	// Creates an asynchronous task to call the UpdateSecretBd method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *UpdateSecretBdAsync(CkJsonObjectU &jsonId, CkBinDataU &secret);

	// Creates a JSON secret if it does not yet exist, or updates an existing secret.
	// The name of the secret is specified in jsonId, and the JSON content of the secret
	// in secret.
	bool UpdateSecretJson(CkJsonObjectU &jsonId, CkJsonObjectU &secret);

	// Creates an asynchronous task to call the UpdateSecretJson method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *UpdateSecretJsonAsync(CkJsonObjectU &jsonId, CkJsonObjectU &secret);

	// Creates a string secret if it does not yet exist, or updates an existing secret.
	// The name of the secret is specified in jsonId, and the string content of the
	// secret in sb.
	bool UpdateSecretSb(CkJsonObjectU &jsonId, CkStringBuilderU &sb);

	// Creates an asynchronous task to call the UpdateSecretSb method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *UpdateSecretSbAsync(CkJsonObjectU &jsonId, CkStringBuilderU &sb);

	// Creates a string secret if it does not yet exist, or updates an existing secret.
	// The name of the secret is specified in jsonId, and the string content of the
	// secret in secret.
	bool UpdateSecretStr(CkJsonObjectU &jsonId, const uint16_t *secret);

	// Creates an asynchronous task to call the UpdateSecretStr method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *UpdateSecretStrAsync(CkJsonObjectU &jsonId, const uint16_t *secret);





	// END PUBLIC INTERFACE


};
#if !defined(__sun__) && !defined(__sun)
#pragma pack (pop)
#endif
	
#endif
