// CkBz2U.h: interface for the CkBz2U class.
//
//////////////////////////////////////////////////////////////////////

// This header is generated for Chilkat 11.2.0

#ifndef _CkBz2U_H
#define _CkBz2U_H
	
#include "../../Cpp/include/chilkatDefs.h"
#include "../../Cpp/include/CkString.h"
#include "CkClassWithCallbacksU.h"

class CkBinDataU;
class CkTaskU;
class CkByteData;
class CkBaseProgressU;



#if !defined(__sun__) && !defined(__sun)
#pragma pack (push, 8)
#endif
 

// CLASS: CkBz2U
class CK_VISIBLE_PUBLIC CkBz2U  : public CkClassWithCallbacksU
{
	public:
	bool m_cbOwned;

	private:
	
	// Don't allow assignment or copying these objects.
	CkBz2U(const CkBz2U &);
	CkBz2U &operator=(const CkBz2U &);

    public:
	CkBz2U(void);
	virtual ~CkBz2U(void);

	

	static CkBz2U *createNew(void);
	

	CkBz2U(bool bCallbackOwned);
	static CkBz2U *createNew(bool bCallbackOwned);

	
	void CK_VISIBLE_PRIVATE inject(void *impl);

	// May be called when finished with the object to free/dispose of any
	// internal resources held by the object. 
	void dispose(void);

	CkBaseProgressU *get_EventCallbackObject(void) const;
	void put_EventCallbackObject(CkBaseProgressU *progress);


	// BEGIN PUBLIC INTERFACE

	// ----------------------
	// Properties
	// ----------------------
	// When set to true, causes the currently running method to abort. Methods that
	// always finish quickly (i.e.have no length file operations or network
	// communications) are not affected. If no method is running, then this property is
	// automatically reset to false when the next method is called. When the abort
	// occurs, this property is reset to false. Both synchronous and asynchronous
	// method calls can be aborted. (A synchronous method call could be aborted by
	// setting this property from a separate thread.)
	bool get_AbortCurrent(void);
	// When set to true, causes the currently running method to abort. Methods that
	// always finish quickly (i.e.have no length file operations or network
	// communications) are not affected. If no method is running, then this property is
	// automatically reset to false when the next method is called. When the abort
	// occurs, this property is reset to false. Both synchronous and asynchronous
	// method calls can be aborted. (A synchronous method call could be aborted by
	// setting this property from a separate thread.)
	void put_AbortCurrent(bool newVal);

	// The interval in milliseconds between each AbortCheck event callback, which
	// enables an application to abort certain method calls before they complete. By
	// default, HeartbeatMs is set to 0 , meaning no AbortCheck event callbacks will
	// trigger.
	// 
	// References:
	// 1: #AbortCheck
	int get_HeartbeatMs(void);
	// The interval in milliseconds between each AbortCheck event callback, which
	// enables an application to abort certain method calls before they complete. By
	// default, HeartbeatMs is set to 0 , meaning no AbortCheck event callbacks will
	// trigger.
	// 
	// References:
	// 1: #AbortCheck
	void put_HeartbeatMs(int newVal);



	// ----------------------
	// Methods
	// ----------------------
	// BZ2 compress the contents of bd. After compression, the bd contains the
	// binary content of a .bz2 file, which is slightly different than simple BZIP2
	// compressed data because a .bz2 file contains:
	//     1. Header
	//     2. Compressed blocks
	//     3. End-of-stream trailer
	bool CompressBd(CkBinDataU &bd);

	// Creates an asynchronous task to call the CompressBd method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *CompressBdAsync(CkBinDataU &bd);

	// Compresses a file to create a BZip2 compressed file (.bz2).
	// 
	// Note: Both inFilename and toPath should be relative or absolute file paths (not just a
	// path to a directory). For example someDir1/someDir2/myFile.txt or
	// c:/someDir1/myFile.bz2 .
	// 
	bool CompressFile(const uint16_t *inFilename, const uint16_t *toPath);

	// Creates an asynchronous task to call the CompressFile method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *CompressFileAsync(const uint16_t *inFilename, const uint16_t *toPath);

	// BZip2 compresses a file to an in-memory image of a .bz2 file.
	bool CompressFileToMem(const uint16_t *inFilename, CkByteData &outBytes);

	// Creates an asynchronous task to call the CompressFileToMem method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *CompressFileToMemAsync(const uint16_t *inFilename);

	// Compresses in-memory data to an in-memory image of a .bz2 file.
	bool CompressMemory(CkByteData &inData, CkByteData &outBytes);

	// Creates an asynchronous task to call the CompressMemory method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *CompressMemoryAsync(CkByteData &inData);

	// BZip2 compresses and creates a .bz2 file from in-memory data.
	bool CompressMemToFile(CkByteData &inData, const uint16_t *toPath);

	// Creates an asynchronous task to call the CompressMemToFile method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *CompressMemToFileAsync(CkByteData &inData, const uint16_t *toPath);

	// Loads the caller of the task's async method.
	bool LoadTaskCaller(CkTaskU &task);

	// BZ2 uncompress the contents of bd, which initially should contain the bytes of
	// a .bz2 file. After uncompressing, the bd contains the original uncompressed
	// content.
	bool UncompressBd(CkBinDataU &bd);

	// Creates an asynchronous task to call the UncompressBd method with the arguments
	// provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *UncompressBdAsync(CkBinDataU &bd);

	// Unzips a .bz2 file.
	bool UncompressFile(const uint16_t *inFilename, const uint16_t *toPath);

	// Creates an asynchronous task to call the UncompressFile method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *UncompressFileAsync(const uint16_t *inFilename, const uint16_t *toPath);

	// Unzips a .bz2 file directly to memory.
	bool UncompressFileToMem(const uint16_t *inFilename, CkByteData &outBytes);

	// Creates an asynchronous task to call the UncompressFileToMem method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *UncompressFileToMemAsync(const uint16_t *inFilename);

	// Unzips from an in-memory image of a .bz2 file directly into memory.
	bool UncompressMemory(CkByteData &inData, CkByteData &outBytes);

	// Creates an asynchronous task to call the UncompressMemory method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *UncompressMemoryAsync(CkByteData &inData);

	// Unzips from an in-memory image of a .bz2 file to a file.
	bool UncompressMemToFile(CkByteData &inData, const uint16_t *toPath);

	// Creates an asynchronous task to call the UncompressMemToFile method with the
	// arguments provided.
	// The caller is responsible for deleting the object returned by this method.
	CkTaskU *UncompressMemToFileAsync(CkByteData &inData, const uint16_t *toPath);





	// END PUBLIC INTERFACE


};
#if !defined(__sun__) && !defined(__sun)
#pragma pack (pop)
#endif
	
#endif
