// CkEmailU.h: interface for the CkEmailU class.
//
//////////////////////////////////////////////////////////////////////

// This header is generated for Chilkat 11.2.0

#ifndef _CkEmailU_H
#define _CkEmailU_H
	
#include "../../Cpp/include/chilkatDefs.h"
#include "../../Cpp/include/CkString.h"
#include "CkUtf16Base.h"

class CkBinDataU;
class CkByteData;
class CkCertU;
class CkStringArrayU;
class CkJsonObjectU;
class CkDateTimeU;
class CkStringBuilderU;
class CkCertChainU;
class CkStringTableU;
class CkTaskU;
class CkPrivateKeyU;
class CkXmlCertVaultU;



#if !defined(__sun__) && !defined(__sun)
#pragma pack (push, 8)
#endif
 

// CLASS: CkEmailU
class CK_VISIBLE_PUBLIC CkEmailU  : public CkUtf16Base
{
	

	private:
	
	// Don't allow assignment or copying these objects.
	CkEmailU(const CkEmailU &);
	CkEmailU &operator=(const CkEmailU &);

    public:
	CkEmailU(void);
	virtual ~CkEmailU(void);

	

	static CkEmailU *createNew(void);
	

	
	void CK_VISIBLE_PRIVATE inject(void *impl);

	// May be called when finished with the object to free/dispose of any
	// internal resources held by the object. 
	void dispose(void);

	

	// BEGIN PUBLIC INTERFACE

	// ----------------------
	// Properties
	// ----------------------
	// The body of the email. If the email has both HTML and plain-text bodies, this
	// property returns the HTML body. The GetHtmlBody and GetPlainTextBody methods can
	// be used to access a specific body. The HasHtmlBody and HasPlainTextBody methods
	// can be used to determine the presence of a body.
	void get_Body(CkString &str);
	// The body of the email. If the email has both HTML and plain-text bodies, this
	// property returns the HTML body. The GetHtmlBody and GetPlainTextBody methods can
	// be used to access a specific body. The HasHtmlBody and HasPlainTextBody methods
	// can be used to determine the presence of a body.
	const uint16_t *body(void);
	// The body of the email. If the email has both HTML and plain-text bodies, this
	// property returns the HTML body. The GetHtmlBody and GetPlainTextBody methods can
	// be used to access a specific body. The HasHtmlBody and HasPlainTextBody methods
	// can be used to determine the presence of a body.
	void put_Body(const uint16_t *newVal);

	// This property is deprecated and applications should use the MailMan.SmtpMailFrom
	// property instead.
	void get_BounceAddress(CkString &str);
	// This property is deprecated and applications should use the MailMan.SmtpMailFrom
	// property instead.
	const uint16_t *bounceAddress(void);
	// This property is deprecated and applications should use the MailMan.SmtpMailFrom
	// property instead.
	void put_BounceAddress(const uint16_t *newVal);

	// Represents the main charset of the email, such as utf-8 , iso-8859-1 , Shift_JIS
	// , us-ascii , etc. This property can be empty if there is no explicit charset,
	// such as for emails with only us-ascii.
	// 
	// Setting this property causes Chilkat to use the new charset in HTML and
	// plain-text bodies, where possible. This can include updating the HTML META tag
	// in HTML bodies to agree with the charset specified in the email header and also
	// the byte representation of the HTML body in the email.
	// 
	void get_Charset(CkString &str);
	// Represents the main charset of the email, such as utf-8 , iso-8859-1 , Shift_JIS
	// , us-ascii , etc. This property can be empty if there is no explicit charset,
	// such as for emails with only us-ascii.
	// 
	// Setting this property causes Chilkat to use the new charset in HTML and
	// plain-text bodies, where possible. This can include updating the HTML META tag
	// in HTML bodies to agree with the charset specified in the email header and also
	// the byte representation of the HTML body in the email.
	// 
	const uint16_t *charset(void);
	// Represents the main charset of the email, such as utf-8 , iso-8859-1 , Shift_JIS
	// , us-ascii , etc. This property can be empty if there is no explicit charset,
	// such as for emails with only us-ascii.
	// 
	// Setting this property causes Chilkat to use the new charset in HTML and
	// plain-text bodies, where possible. This can include updating the HTML META tag
	// in HTML bodies to agree with the charset specified in the email header and also
	// the byte representation of the HTML body in the email.
	// 
	void put_Charset(const uint16_t *newVal);

	// true if the email arrived encrypted and was successfully decrypted, otherwise
	// false. This property is only meaningful when the ReceivedEncrypted property is
	// equal to true.
	bool get_Decrypted(void);

	// The date/time from the Date header in the UTC/GMT timezone in RFC822 string
	// form.
	void get_EmailDateStr(CkString &str);
	// The date/time from the Date header in the UTC/GMT timezone in RFC822 string
	// form.
	const uint16_t *emailDateStr(void);
	// The date/time from the Date header in the UTC/GMT timezone in RFC822 string
	// form.
	void put_EmailDateStr(const uint16_t *newVal);

	// If the email was received encrypted, this contains the details of the
	// certificate used for encryption.
	void get_EncryptedBy(CkString &str);
	// If the email was received encrypted, this contains the details of the
	// certificate used for encryption.
	const uint16_t *encryptedBy(void);

	// Set this property to send an email to a list of recipients stored in a plain
	// text file. The file format is simple: one recipient per line, no comments
	// allowed, blank lines are ignored.Setting this property is equivalent to adding a
	// CKX-FileDistList header field to the email. Chilkat Mail treats header fields
	// beginning with CKX- specially in that these fields are never transmitted with
	// the email when sent. However, CKX fields are saved and restored when saving to
	// XML or loading from XML (or MIME). When sending an email containing a
	// CKX-FileDistList header field, Chilkat Mail will read the distribution list file
	// and send the email to each recipient. Emails can be sent individually, or with
	// BCC, 100 recipients at a time. (see the MailMan.SendIndividual property).
	void get_FileDistList(CkString &str);
	// Set this property to send an email to a list of recipients stored in a plain
	// text file. The file format is simple: one recipient per line, no comments
	// allowed, blank lines are ignored.Setting this property is equivalent to adding a
	// CKX-FileDistList header field to the email. Chilkat Mail treats header fields
	// beginning with CKX- specially in that these fields are never transmitted with
	// the email when sent. However, CKX fields are saved and restored when saving to
	// XML or loading from XML (or MIME). When sending an email containing a
	// CKX-FileDistList header field, Chilkat Mail will read the distribution list file
	// and send the email to each recipient. Emails can be sent individually, or with
	// BCC, 100 recipients at a time. (see the MailMan.SendIndividual property).
	const uint16_t *fileDistList(void);
	// Set this property to send an email to a list of recipients stored in a plain
	// text file. The file format is simple: one recipient per line, no comments
	// allowed, blank lines are ignored.Setting this property is equivalent to adding a
	// CKX-FileDistList header field to the email. Chilkat Mail treats header fields
	// beginning with CKX- specially in that these fields are never transmitted with
	// the email when sent. However, CKX fields are saved and restored when saving to
	// XML or loading from XML (or MIME). When sending an email containing a
	// CKX-FileDistList header field, Chilkat Mail will read the distribution list file
	// and send the email to each recipient. Emails can be sent individually, or with
	// BCC, 100 recipients at a time. (see the MailMan.SendIndividual property).
	void put_FileDistList(const uint16_t *newVal);

	// The combined name and email address of the sender, such as John Smith . This is
	// the content that will be placed in the From: header field. If the actual sender
	// is to be different, then set the Sender property to a different email address.
	void get_From(CkString &str);
	// The combined name and email address of the sender, such as John Smith . This is
	// the content that will be placed in the From: header field. If the actual sender
	// is to be different, then set the Sender property to a different email address.
	const uint16_t *ck_from(void);
	// The combined name and email address of the sender, such as John Smith . This is
	// the content that will be placed in the From: header field. If the actual sender
	// is to be different, then set the Sender property to a different email address.
	void put_From(const uint16_t *newVal);

	// The email address of the sender.
	void get_FromAddress(CkString &str);
	// The email address of the sender.
	const uint16_t *fromAddress(void);
	// The email address of the sender.
	void put_FromAddress(const uint16_t *newVal);

	// The name of the sender.
	void get_FromName(CkString &str);
	// The name of the sender.
	const uint16_t *fromName(void);
	// The name of the sender.
	void put_FromName(const uint16_t *newVal);

	// The complete MIME header of the email.
	void get_Header(CkString &str);
	// The complete MIME header of the email.
	const uint16_t *header(void);

	// A read-only property that identifies the primary language group for the email.
	// Possible values are:
	// 
	//         * latin1 (for English and all Western European languages)
	//         * central (for Central European languages such as Polish, Czech,
	//         Hungarian, etc.)
	//         * russian (for Cyrillic languages)
	//         * greek
	//         * turkish
	//         * hebrew
	//         * arabic
	//         * thai
	//         * vietnamese
	//         * chinese
	//         * japanese
	//         * korean
	//         * devanagari
	//         * bengali
	//         * gurmukhi
	//         * gujarati
	//         * oriya
	//         * tamil
	//         * telugu
	//         * kannada
	//         * malayalam
	//         * sinhala
	//         * lao
	//         * tibetan
	//         * myanmar
	//         * georgian
	//         * unknown
	// 
	// The language group determination is made soley on the subject and
	// plain-text/HTML email bodies. Characters in the FROM, TO, CC, and other header
	// fields are not considered.
	// 
	// The primary determining factor is the characters found in the Subject header
	// field. For example, if an email contains Japanese in the Subject, but the body
	// contains Russian characters, it will be considered japanese .
	// 
	// The language is determined by where the Unicode chars fall in various blocks in
	// the Unicode Basic Multilingual Plane. For more information, see the book Unicode
	// Demystified by Richard Gillam.
	// 
	void get_Language(CkString &str);
	// A read-only property that identifies the primary language group for the email.
	// Possible values are:
	// 
	//         * latin1 (for English and all Western European languages)
	//         * central (for Central European languages such as Polish, Czech,
	//         Hungarian, etc.)
	//         * russian (for Cyrillic languages)
	//         * greek
	//         * turkish
	//         * hebrew
	//         * arabic
	//         * thai
	//         * vietnamese
	//         * chinese
	//         * japanese
	//         * korean
	//         * devanagari
	//         * bengali
	//         * gurmukhi
	//         * gujarati
	//         * oriya
	//         * tamil
	//         * telugu
	//         * kannada
	//         * malayalam
	//         * sinhala
	//         * lao
	//         * tibetan
	//         * myanmar
	//         * georgian
	//         * unknown
	// 
	// The language group determination is made soley on the subject and
	// plain-text/HTML email bodies. Characters in the FROM, TO, CC, and other header
	// fields are not considered.
	// 
	// The primary determining factor is the characters found in the Subject header
	// field. For example, if an email contains Japanese in the Subject, but the body
	// contains Russian characters, it will be considered japanese .
	// 
	// The language is determined by where the Unicode chars fall in various blocks in
	// the Unicode Basic Multilingual Plane. For more information, see the book Unicode
	// Demystified by Richard Gillam.
	// 
	const uint16_t *language(void);

	// The date/time found in the Date header field returned in the local timezone in
	// RFC822 string form.
	void get_LocalDateStr(CkString &str);
	// The date/time found in the Date header field returned in the local timezone in
	// RFC822 string form.
	const uint16_t *localDateStr(void);
	// The date/time found in the Date header field returned in the local timezone in
	// RFC822 string form.
	void put_LocalDateStr(const uint16_t *newVal);

	// Identifies the email software that sent the email.
	void get_Mailer(CkString &str);
	// Identifies the email software that sent the email.
	const uint16_t *mailer(void);
	// Identifies the email software that sent the email.
	void put_Mailer(const uint16_t *newVal);

	// The number of alternative bodies present in the email. An email that is not
	// multipart/alternative will return 0 alternatives. An email that is
	// multipart/alternative will return a number greater than or equal to 1.
	int get_NumAlternatives(void);

	// Returns the number of embedded emails. Some mail clients will embed an email
	// that is to be forwarded into a new email as a message/rfc822 subpart of the MIME
	// message structure. This property tells how many emails have been embedded. The
	// original email can be retrieved by calling GetAttachedMessage.
	int get_NumAttachedMessages(void);

	// The number of attachments contained in the email.
	// 
	// Note: If an email is downloaded from an IMAP server without attachments, then
	// the number of attachments should be obtained by calling the IMAP object's
	// GetMailNumAttach method. This property indicates the actual number of
	// attachments already present within the email object.
	// 
	int get_NumAttachments(void);

	// The number of blind carbon-copy email recipients.
	int get_NumBcc(void);

	// The number of carbon-copy email recipients.
	int get_NumCC(void);

	// Returns the number of days old from the current system date/time. The email's
	// date is obtained from the Date header field. If the Date header field is
	// missing, or invalid, then -9999 is returned. A negative number may be returned
	// if the Date header field contains a future date/time. (However, -9999 represents
	// an error condition.)
	int get_NumDaysOld(void);

	// Returns the number of message/rfc822 parts contained within the multipart/digest
	// enclosure. If no multipart/digest enclosure exists, then this property has the
	// value of 0. The GetDigest method is called to get the Nth digest as an email
	// object.
	int get_NumDigests(void);

	// The number of header fields. When accessing a header field by index, the 1st
	// header field is at index 0, and the last is at NumHeaderFields-1. (Chilkat
	// indexing is always 0-based.)
	int get_NumHeaderFields(void);

	// The number of related items present in this email. Related items are typically
	// image files (JPEGs or GIFs) or style sheets (CSS files) that are included with
	// HTML formatted messages with internal CID hyperlinks.
	int get_NumRelatedItems(void);

	// Returns the number of replacement patterns previously set by calling the
	// SetReplacePattern method 1 or more times. If replacement patterns are set, the
	// email bodies and header fields are modified by applying the search/replacement
	// strings during the message sending process.
	int get_NumReplacePatterns(void);

	// (For multipart/report emails that have sub-parts with Content-Types such as
	// message/feedback-report.) Any MIME sub-part within the email that has a
	// Content-Type of message/* , but is not a message/rfc822 , is considered to be a
	// report and is included in this count. (A message/rfc822 is considered an
	// attached message and is handled by the NumAttachedMessages property and the
	// GetAttachedMessage method.) Any MIME sub-part having a Content-Type equal to
	// text/rfc822-headers is also considered to be a report . The GetReport method may
	// be called to get the body content of each report contained within a
	// multipart/report email.
	int get_NumReports(void);

	// The number of direct email recipients.
	int get_NumTo(void);

	// Selects the hash algorithm for use within OAEP padding when encrypting email
	// using RSAES-OAEP. The valid choices are sha1 , sha256 , sha384 , sha512 ,
	void get_OaepHash(CkString &str);
	// Selects the hash algorithm for use within OAEP padding when encrypting email
	// using RSAES-OAEP. The valid choices are sha1 , sha256 , sha384 , sha512 ,
	const uint16_t *oaepHash(void);
	// Selects the hash algorithm for use within OAEP padding when encrypting email
	// using RSAES-OAEP. The valid choices are sha1 , sha256 , sha384 , sha512 ,
	void put_OaepHash(const uint16_t *newVal);

	// Selects the MGF hash algorithm for use within OAEP padding when encrypting email
	// using RSAES-OAEP. The valid choices are sha1 , sha256 , sha384 , sha512 ,
	void get_OaepMgfHash(CkString &str);
	// Selects the MGF hash algorithm for use within OAEP padding when encrypting email
	// using RSAES-OAEP. The valid choices are sha1 , sha256 , sha384 , sha512 ,
	const uint16_t *oaepMgfHash(void);
	// Selects the MGF hash algorithm for use within OAEP padding when encrypting email
	// using RSAES-OAEP. The valid choices are sha1 , sha256 , sha384 , sha512 ,
	void put_OaepMgfHash(const uint16_t *newVal);

	// Selects the RSA encryption scheme when encrypting email. The default value is
	// false, which selects RSAES_PKCS1-V1_5. If set to true, then RSAES_OAEP is
	// used.
	bool get_OaepPadding(void);
	// Selects the RSA encryption scheme when encrypting email. The default value is
	// false, which selects RSAES_PKCS1-V1_5. If set to true, then RSAES_OAEP is
	// used.
	void put_OaepPadding(bool newVal);

	// When true (the default) the methods to save email attachments and related
	// items will overwrite files if they already exist. If false, then the methods
	// that save email attachments and related items will append a string of 4
	// characters to create a unique filename if a file already exists. The filename of
	// the attachment (or related item) within the email object is updated and can be
	// retrieved by the program to determine the actual file(s) created.
	bool get_OverwriteExisting(void);
	// When true (the default) the methods to save email attachments and related
	// items will overwrite files if they already exist. If false, then the methods
	// that save email attachments and related items will append a string of 4
	// characters to create a unique filename if a file already exists. The filename of
	// the attachment (or related item) within the email object is updated and can be
	// retrieved by the program to determine the actual file(s) created.
	void put_OverwriteExisting(bool newVal);

	// When an email is sent encrypted (using PKCS7 public-key encryption), this
	// selects the underlying symmetric encryption algorithm. Possible values are: aes
	// , aes-gcm , des , 3des , and rc2 . The default value is aes .
	// 
	// Note: The aes-gcm option was added in Chilkat v10.0.0
	// 
	void get_Pkcs7CryptAlg(CkString &str);
	// When an email is sent encrypted (using PKCS7 public-key encryption), this
	// selects the underlying symmetric encryption algorithm. Possible values are: aes
	// , aes-gcm , des , 3des , and rc2 . The default value is aes .
	// 
	// Note: The aes-gcm option was added in Chilkat v10.0.0
	// 
	const uint16_t *pkcs7CryptAlg(void);
	// When an email is sent encrypted (using PKCS7 public-key encryption), this
	// selects the underlying symmetric encryption algorithm. Possible values are: aes
	// , aes-gcm , des , 3des , and rc2 . The default value is aes .
	// 
	// Note: The aes-gcm option was added in Chilkat v10.0.0
	// 
	void put_Pkcs7CryptAlg(const uint16_t *newVal);

	// When the email is sent encrypted (using PKCS7 public-key encryption), this
	// selects the key length of the underlying symmetric encryption algorithm. The
	// possible values allowed depend on the Pkcs7CryptAlg property. For aes , the key
	// length may be 128, 192, or 256. For 3des the key length must be 192. For des the
	// key length must be 40. For rc2 the key length can be 40, 56, 64, or 128.
	int get_Pkcs7KeyLength(void);
	// When the email is sent encrypted (using PKCS7 public-key encryption), this
	// selects the key length of the underlying symmetric encryption algorithm. The
	// possible values allowed depend on the Pkcs7CryptAlg property. For aes , the key
	// length may be 128, 192, or 256. For 3des the key length must be 192. For des the
	// key length must be 40. For rc2 the key length can be 40, 56, 64, or 128.
	void put_Pkcs7KeyLength(int newVal);

	// Only applies when building an email with non-English characters where the
	// charset is not explicitly set. The Chilkat email component will automatically
	// choose a charset based on the languages found within an email (if the charset is
	// not already specified within the MIME or explicitly specified by setting the
	// Charset property). The default charset chosen for each language is:
	// 
	// Chinese: gb2312
	// Japanese: shift_JIS
	// Korean: ks_c_5601-1987
	// Thai: windows-874
	// All others: iso-8859-*
	//  
	// 
	// This allows for charsets such as iso-2022-jp to be chosen instead of the
	// default. If the preferred charset does not apply to the situation, it is not
	// used. For example, if the preferred charset is iso-2022-jp, but the email
	// contains Greek characters, then the preferred charset is ignored.
	// 
	void get_PreferredCharset(CkString &str);
	// Only applies when building an email with non-English characters where the
	// charset is not explicitly set. The Chilkat email component will automatically
	// choose a charset based on the languages found within an email (if the charset is
	// not already specified within the MIME or explicitly specified by setting the
	// Charset property). The default charset chosen for each language is:
	// 
	// Chinese: gb2312
	// Japanese: shift_JIS
	// Korean: ks_c_5601-1987
	// Thai: windows-874
	// All others: iso-8859-*
	//  
	// 
	// This allows for charsets such as iso-2022-jp to be chosen instead of the
	// default. If the preferred charset does not apply to the situation, it is not
	// used. For example, if the preferred charset is iso-2022-jp, but the email
	// contains Greek characters, then the preferred charset is ignored.
	// 
	const uint16_t *preferredCharset(void);
	// Only applies when building an email with non-English characters where the
	// charset is not explicitly set. The Chilkat email component will automatically
	// choose a charset based on the languages found within an email (if the charset is
	// not already specified within the MIME or explicitly specified by setting the
	// Charset property). The default charset chosen for each language is:
	// 
	// Chinese: gb2312
	// Japanese: shift_JIS
	// Korean: ks_c_5601-1987
	// Thai: windows-874
	// All others: iso-8859-*
	//  
	// 
	// This allows for charsets such as iso-2022-jp to be chosen instead of the
	// default. If the preferred charset does not apply to the situation, it is not
	// used. For example, if the preferred charset is iso-2022-jp, but the email
	// contains Greek characters, then the preferred charset is ignored.
	// 
	void put_PreferredCharset(const uint16_t *newVal);

	// If true, then header fields added via the AddHeaderField or AddHeaderField2
	// methods are prepended to the top of the header as opposed to appended to the
	// bottom. The default value is false.
	bool get_PrependHeaders(void);
	// If true, then header fields added via the AddHeaderField or AddHeaderField2
	// methods are prepended to the top of the header as opposed to appended to the
	// bottom. The default value is false.
	void put_PrependHeaders(bool newVal);

	// true if this email was originally received with encryption, otherwise false.
	bool get_ReceivedEncrypted(void);

	// true if this email was originally received with a digital signature, otherwise
	// false.
	bool get_ReceivedSigned(void);

	// Sets the Reply-To header field to the specified email address such as
	// john@example.com . The Reply-To header automatically defaults to the From email
	// address. You would only set this property if you wish for the Reply-To email
	// address to be different from the From address.
	// 
	// There is usually only a single Reply-To email address. If multiple Reply-To
	// addresses are needed, then set with a comma separated list of email addresses
	// such as john@example.com, mary@somewhere.com .
	// 
	void get_ReplyTo(CkString &str);
	// Sets the Reply-To header field to the specified email address such as
	// john@example.com . The Reply-To header automatically defaults to the From email
	// address. You would only set this property if you wish for the Reply-To email
	// address to be different from the From address.
	// 
	// There is usually only a single Reply-To email address. If multiple Reply-To
	// addresses are needed, then set with a comma separated list of email addresses
	// such as john@example.com, mary@somewhere.com .
	// 
	const uint16_t *replyTo(void);
	// Sets the Reply-To header field to the specified email address such as
	// john@example.com . The Reply-To header automatically defaults to the From email
	// address. You would only set this property if you wish for the Reply-To email
	// address to be different from the From address.
	// 
	// There is usually only a single Reply-To email address. If multiple Reply-To
	// addresses are needed, then set with a comma separated list of email addresses
	// such as john@example.com, mary@somewhere.com .
	// 
	void put_ReplyTo(const uint16_t *newVal);

	// Set to true if you want the email to request a return-receipt when received by
	// the recipient. The default value is false.
	// 
	// Setting this property causes the Disposition-Notification-To email header to be
	// added when the email is sent.
	// 
	bool get_ReturnReceipt(void);
	// Set to true if you want the email to request a return-receipt when received by
	// the recipient. The default value is false.
	// 
	// Setting this property causes the Disposition-Notification-To email header to be
	// added when the email is sent.
	// 
	void put_ReturnReceipt(bool newVal);

	// Set to true if this email should be sent encrypted.
	bool get_SendEncrypted(void);
	// Set to true if this email should be sent encrypted.
	void put_SendEncrypted(bool newVal);

	// Set to true if this email should be sent with a digital signature.
	// 
	// Note: Please be aware of the Apple Mail bug explained in the web page at the
	// link below.
	// 
	bool get_SendSigned(void);
	// Set to true if this email should be sent with a digital signature.
	// 
	// Note: Please be aware of the Apple Mail bug explained in the web page at the
	// link below.
	// 
	void put_SendSigned(bool newVal);

	// true if the email was received with one or more digital signatures, and if all
	// the signatures were validated indicating that the email was not altered.
	// Otherwise this property is set to false. (This property is only meaningful
	// when the ReceivedSigned property is equal to true.)
	bool get_SignaturesValid(void);

	// If the email was received digitally signed, this property contains the fields of
	// the cert's SubjectDN.
	// 
	// For example: US, 60187, Illinois, Wheaton, 1719 E Forest Ave, Chilkat Software,
	// Inc. , Chilkat Software, Inc.
	// 
	// It is like the DN (Distinguished Name), but without the AttrName= before each
	// attribute.
	// 
	void get_SignedBy(CkString &str);
	// If the email was received digitally signed, this property contains the fields of
	// the cert's SubjectDN.
	// 
	// For example: US, 60187, Illinois, Wheaton, 1719 E Forest Ave, Chilkat Software,
	// Inc. , Chilkat Software, Inc.
	// 
	// It is like the DN (Distinguished Name), but without the AttrName= before each
	// attribute.
	// 
	const uint16_t *signedBy(void);

	// Selects the signature algorithm to be used when sending signed (PKCS7) email.
	// The default value is PKCS1-v1_5 . This can be set to RSASSA-PSS (or simply pss )
	// to use the RSASSA-PSS signature scheme.
	// 
	// Note: This property only applies when signing with an RSA private key. It does
	// not apply for ECC or DSA private keys.
	// 
	void get_SigningAlg(CkString &str);
	// Selects the signature algorithm to be used when sending signed (PKCS7) email.
	// The default value is PKCS1-v1_5 . This can be set to RSASSA-PSS (or simply pss )
	// to use the RSASSA-PSS signature scheme.
	// 
	// Note: This property only applies when signing with an RSA private key. It does
	// not apply for ECC or DSA private keys.
	// 
	const uint16_t *signingAlg(void);
	// Selects the signature algorithm to be used when sending signed (PKCS7) email.
	// The default value is PKCS1-v1_5 . This can be set to RSASSA-PSS (or simply pss )
	// to use the RSASSA-PSS signature scheme.
	// 
	// Note: This property only applies when signing with an RSA private key. It does
	// not apply for ECC or DSA private keys.
	// 
	void put_SigningAlg(const uint16_t *newVal);

	// Selects the underlying hash algorithm used when sending signed (PKCS7) email.
	// Possible values are sha1 , sha256 , sha384 , sha512 , md5 , and md2 .
	void get_SigningHashAlg(CkString &str);
	// Selects the underlying hash algorithm used when sending signed (PKCS7) email.
	// Possible values are sha1 , sha256 , sha384 , sha512 , md5 , and md2 .
	const uint16_t *signingHashAlg(void);
	// Selects the underlying hash algorithm used when sending signed (PKCS7) email.
	// Possible values are sha1 , sha256 , sha384 , sha512 , md5 , and md2 .
	void put_SigningHashAlg(const uint16_t *newVal);

	// The size in bytes of the email, including all parts and attachments.
	// 
	// Note: This property is only valid if the full email was downloaded. If only the
	// header was downloaded, then this property will contain the size of just the
	// header.
	// 
	int get_Size(void);

	// The email subject.
	void get_Subject(CkString &str);
	// The email subject.
	const uint16_t *subject(void);
	// The email subject.
	void put_Subject(const uint16_t *newVal);

	// This is the unique ID assigned by the POP3 server. Emails can be retrieved or
	// deleted from the POP3 server via the UIDL. The header field for this property is
	// X-UIDL .
	// 
	// Important: Emails downloaded via the IMAP protocol do not have UIDL's. UIDL's
	// are specific to the POP3 protocol. IMAP servers use UID's (notice the spelling
	// difference -- UIDL vs. UID ). An email downloaded via the Chilkat IMAP component
	// will contain a ckx-imap-uid header field that holds either an IMAP UID or
	// sequence number. If the email was downloaded (from IMAP) using a UID,then
	// ckx-imap-uid contains a UID. If the email was downloaded by sequence number,
	// then it contains a sequence number (not unique and can change with a new
	// session). The ckx-imap-isUid header, which can have the value YES or NO , tells
	// what ckx-imap-uid contains.
	// 
	void get_Uidl(CkString &str);
	// This is the unique ID assigned by the POP3 server. Emails can be retrieved or
	// deleted from the POP3 server via the UIDL. The header field for this property is
	// X-UIDL .
	// 
	// Important: Emails downloaded via the IMAP protocol do not have UIDL's. UIDL's
	// are specific to the POP3 protocol. IMAP servers use UID's (notice the spelling
	// difference -- UIDL vs. UID ). An email downloaded via the Chilkat IMAP component
	// will contain a ckx-imap-uid header field that holds either an IMAP UID or
	// sequence number. If the email was downloaded (from IMAP) using a UID,then
	// ckx-imap-uid contains a UID. If the email was downloaded by sequence number,
	// then it contains a sequence number (not unique and can change with a new
	// session). The ckx-imap-isUid header, which can have the value YES or NO , tells
	// what ckx-imap-uid contains.
	// 
	const uint16_t *uidl(void);

	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string, and should typically remain empty.
	// 
	// As of v9.5.0.79, the only possible value is:
	//     * NO_FORMAT_FLOWED - Don't automatically add format=flowed to any
	//     Content-Type header.
	// 
	void get_UncommonOptions(CkString &str);
	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string, and should typically remain empty.
	// 
	// As of v9.5.0.79, the only possible value is:
	//     * NO_FORMAT_FLOWED - Don't automatically add format=flowed to any
	//     Content-Type header.
	// 
	const uint16_t *uncommonOptions(void);
	// This is a catch-all property to be used for uncommon needs. This property
	// defaults to the empty string, and should typically remain empty.
	// 
	// As of v9.5.0.79, the only possible value is:
	//     * NO_FORMAT_FLOWED - Don't automatically add format=flowed to any
	//     Content-Type header.
	// 
	void put_UncommonOptions(const uint16_t *newVal);

	// Applies to the UnpackHtml method. If true, then relative paths are used within
	// the HTML for the links to the related files (images and style sheets) that were
	// unpacked to the filesystem. Otherwise absolute paths are used. The default value
	// is true.
	bool get_UnpackUseRelPaths(void);
	// Applies to the UnpackHtml method. If true, then relative paths are used within
	// the HTML for the links to the related files (images and style sheets) that were
	// unpacked to the filesystem. Otherwise absolute paths are used. The default value
	// is true.
	void put_UnpackUseRelPaths(bool newVal);



	// ----------------------
	// Methods
	// ----------------------
	// Adds an attachment using the contents of a BinData object. If contentType is empty,
	// then the content-type will be inferred from the filename extension.
	bool AddAttachmentBd(const uint16_t *filename, CkBinDataU &binData, const uint16_t *contentType);

	// Adds or replaces a MIME header field in one of the email attachments. If the
	// header field does not exist, it is added. Otherwise it is replaced.
	void AddAttachmentHeader(int index, const uint16_t *fieldName, const uint16_t *fieldValue);

	// Adds a recipient to the blind carbon-copy list. emailAddress is required, but friendlyName may
	// be empty.
	// 
	// To add multiple BCC recipients, call this method once per recipient.
	// 
	bool AddBcc(const uint16_t *friendlyName, const uint16_t *emailAddress);

	// Adds a recipient to the carbon-copy list. emailAddress is required, but friendlyName may be
	// empty.
	// 
	// To add multiple CC recipients, call this method once per recipient.
	// 
	bool AddCC(const uint16_t *friendlyName, const uint16_t *emailAddress);

	// Adds an attachment directly from data in memory to the email.
	bool AddDataAttachment(const uint16_t *fileName, CkByteData &content);

	// Adds an attachment to an email from in-memory data. Same as AddDataAttachment
	// but allows the content-type to be specified.
	bool AddDataAttachment2(const uint16_t *fileName, CkByteData &content, const uint16_t *contentType);

	// Allows for certificates to be explicitly specified for sending encrypted email
	// to one or more recipients. Call this method once per certificate to be used. The
	// ClearEncryptCerts method may be called to clear the list of explicitly-specified
	// certificates.
	// 
	// Note: It is possible to send encrypted email without explicitly specifying the
	// certificates. On Windows computers, the registry-based Current-User and
	// Local-Machine certificate stores are automatically searched for certs matching
	// each of the recipients (To, CC, and BCC recipients).
	// 
	// Note: The SetEncryptCert method is equivalent to calling ClearEncryptCerts
	// followed by AddEncryptCert.
	// 
	bool AddEncryptCert(CkCertU &cert);

	// Adds a file as an attachment to the email. Returns the MIME content-type of the
	// attachment, which is inferred based on the filename extension.
	bool AddFileAttachment(const uint16_t *path, CkString &outStrContentType);
	// Adds a file as an attachment to the email. Returns the MIME content-type of the
	// attachment, which is inferred based on the filename extension.
	const uint16_t *addFileAttachment(const uint16_t *path);

	// Same as AddFileAttachment, but the content type can be explicitly specified.
	bool AddFileAttachment2(const uint16_t *path, const uint16_t *contentType);

	// Any standard or non-standard (custom) header field can be added to the email
	// with this method. One interesting feature is that all header fields whose name
	// begins with CKX- will not be included in the header when an email is sent. These
	// fields will be included when saved to or loaded from XML. This makes it easy to
	// include persistent meta-data with an email which your programs can use in any
	// way it chooses.
	// 
	// Important: This method will replace an already-existing header field. To allow
	// for adding duplicate header fields, call AddHeaderField2 (see below).
	// 
	void AddHeaderField(const uint16_t *fieldName, const uint16_t *fieldValue);

	// This method is the same as AddHeaderField, except that if the header field
	// already exists, it is not replaced. A duplicate header will be added.
	void AddHeaderField2(const uint16_t *fieldName, const uint16_t *fieldValue);

	// Sets the HTML body of the email. Use this method if there will be multiple
	// versions of the body, but in different formats, such as HTML and plain text.
	// Otherwise, set the body by calling the SetHtmlBody method.
	bool AddHtmlAlternativeBody(const uint16_t *body);

	// Adds an iCalendar (text/calendar) alternative body to the email. The icalContent
	// contains the content of the iCalendar data. A sample is shown here:BEGIN:VCALENDAR
	// VERSION:2.0
	// PRODID:-//hacksw/handcal//NONSGML v1.0//EN
	// BEGIN:VEVENT
	// UID:uid1@example.com
	// DTSTAMP:19970714T170000Z
	// ORGANIZER;CN=John Doe:MAILTO:john.doe@example.com
	// DTSTART:19970714T170000Z
	// DTEND:19970715T035959Z
	// SUMMARY:Bastille Day Party
	// END:VEVENT
	// END:VCALENDAR
	// The methodName is the method attribute used in the Content-Type header field in the
	// alternative body. For example, if set to REQUEST , then the alternative body's
	// header would look like this:Content-Type: text/calendar; method=REQUEST
	// Content-Transfer-Encoding: base64
	bool AddiCalendarAlternativeBody(const uint16_t *icalContent, const uint16_t *methodName);

	// Adds multiple recipients to the blind carbon-copy list. The parameter is a
	// string containing a comma separated list of full email addresses. Returns True
	// if successful.
	bool AddMultipleBcc(const uint16_t *commaSeparatedAddresses);

	// Adds multiple recipients to the carbon-copy list. The parameter is a string
	// containing a comma separated list of full email addresses. Returns True if
	// successful.
	bool AddMultipleCC(const uint16_t *commaSeparatedAddresses);

	// Adds multiple recipients to the to list. The parameter is a string containing a
	// comma separated list of full email addresses. Returns True if successful.
	bool AddMultipleTo(const uint16_t *commaSeparatedAddresses);

	// Adds a PFX file to the object's list of sources for locating certificates and
	// private keys during decryption or signing. To add multiple PFX sources, call
	// this method for each file. bd should contain the bytes of a PFX file (also
	// known as PKCS12 or .p12). The password is the password for the PFX.
	bool AddPfxSourceBd(CkBinDataU &bd, const uint16_t *password);

	// Adds a PFX to the object's internal list of sources to be searched for
	// certificates and private keys when decrypting. Multiple PFX sources can be added
	// by calling this method once for each. (On the Windows operating system, the
	// registry-based certificate stores are also automatically searched, so it is
	// commonly not required to explicitly add PFX sources.)
	// 
	// The pfxBytes contains the bytes of a PFX file (also known as PKCS12 or .p12).
	// 
	bool AddPfxSourceData(CkByteData &pfxBytes, const uint16_t *pfxPassword);

	// Adds a PFX file to the object's internal list of sources to be searched for
	// certificates and private keys when decrypting. Multiple PFX files can be added
	// by calling this method once for each. (On the Windows operating system, the
	// registry-based certificate stores are also automatically searched, so it is
	// commonly not required to explicitly add PFX sources.)
	// 
	// The pfxFilePath contains the bytes of a PFX file (also known as PKCS12 or .p12).
	// 
	bool AddPfxSourceFile(const uint16_t *pfxFilePath, const uint16_t *pfxPassword);

	// Sets the plain-text body of the email. Use this method if there will be multiple
	// versions of the body, but in different formats, such as HTML and plain text.
	// Otherwise, simply set the Body property.
	bool AddPlainTextAlternativeBody(const uint16_t *body);

	// Adds a related item using the contents of a BinData object. Returns the
	// Content-ID for the newly added relted item.
	bool AddRelatedBd(const uint16_t *filename, CkBinDataU &binData, CkString &outStr);
	// Adds a related item using the contents of a BinData object. Returns the
	// Content-ID for the newly added relted item.
	const uint16_t *addRelatedBd(const uint16_t *filename, CkBinDataU &binData);

	// Adds a related item using the contents of a BinData object. The fileNameInHtml should be
	// set to the filename/path/url used in the corresponding HTML IMG tag's src
	// attribute.
	bool AddRelatedBd2(CkBinDataU &binData, const uint16_t *fileNameInHtml);

	// Adds the memory data as a related item to the email and returns the Content-ID.
	// Emails formatted in HTML can include images with this call and internally
	// reference the image through a cid hyperlink. (Chilkat Email.NET fully supports
	// the MHTML standard.)
	bool AddRelatedData(const uint16_t *fileName, CkByteData &inData, CkString &outStr);
	// Adds the memory data as a related item to the email and returns the Content-ID.
	// Emails formatted in HTML can include images with this call and internally
	// reference the image through a cid hyperlink. (Chilkat Email.NET fully supports
	// the MHTML standard.)
	const uint16_t *addRelatedData(const uint16_t *fileName, CkByteData &inData);

	// Adds a related item to the email from in-memory byte data. Related items are
	// things such as images and style sheets that are embedded within an HTML email.
	// They are not considered attachments because their sole purpose is to participate
	// in the display of the HTML. This method differs from AddRelatedData in that it
	// does not use or return a Content-ID. The filename argument should be set to the
	// filename used in the HTML img tag's src attribute (if it's an image), or the URL
	// referenced in an HTML link tag for a stylesheet.
	void AddRelatedData2(CkByteData &inData, const uint16_t *fileNameInHtml);

	// Adds the contents of a file to the email and returns the Content-ID. Emails
	// formatted in HTML can include images with this call and internally reference the
	// image through a cid hyperlink. (Chilkat Email.NET fully supports the MHTML
	// standard.)
	bool AddRelatedFile(const uint16_t *path, CkString &outStrContentID);
	// Adds the contents of a file to the email and returns the Content-ID. Emails
	// formatted in HTML can include images with this call and internally reference the
	// image through a cid hyperlink. (Chilkat Email.NET fully supports the MHTML
	// standard.)
	const uint16_t *addRelatedFile(const uint16_t *path);

	// Adds a related item to the email from a file. Related items are things such as
	// images and style sheets that are embedded within an HTML email. They are not
	// considered attachments because their sole purpose is to participate in the
	// display of the HTML. This method differs from AddRelatedFile in that it does not
	// use or return a Content-ID. The filenameInHtml argument should be set to the filename used
	// in the HTML img tag's src attribute (if it's an image), or the URL referenced in
	// an HTML link tag for a stylesheet. The filenameOnDisk is the path in the local filesystem
	// of the file to be added.
	// 
	// Note: Outlook.com will not properly display embedded HTMl images when the filenameInHtml
	// includes a path part. Apparently, Outlook.com is only capable of correctly
	// displaying images when the filenameInHtml is a only a filename. Other email clients, such
	// as Mozilla Thunderbird, have no trouble when the filenameInHtml includes a path part.
	// 
	bool AddRelatedFile2(const uint16_t *filenameOnDisk, const uint16_t *filenameInHtml);

	// Adds or replaces a MIME header field in one of the email's related items. If the
	// header field does not exist, it is added. Otherwise it is replaced.
	void AddRelatedHeader(int index, const uint16_t *fieldName, const uint16_t *fieldValue);

	// Adds a related item to the email. A related item is typically an image or style
	// sheet referenced by an HTML tag within the HTML email body. The contents of the
	// related item are passed str. nameInHtml specifies the filename that should be used
	// within the HTML, and not an actual filename on the local filesystem. charset
	// specifies the charset that should be used for the text content of the related
	// item. Returns the content-ID generated for the added item.
	bool AddRelatedString(const uint16_t *nameInHtml, const uint16_t *str, const uint16_t *charset, CkString &outCid);
	// Adds a related item to the email. A related item is typically an image or style
	// sheet referenced by an HTML tag within the HTML email body. The contents of the
	// related item are passed str. nameInHtml specifies the filename that should be used
	// within the HTML, and not an actual filename on the local filesystem. charset
	// specifies the charset that should be used for the text content of the related
	// item. Returns the content-ID generated for the added item.
	const uint16_t *addRelatedString(const uint16_t *nameInHtml, const uint16_t *str, const uint16_t *charset);

	// Adds a related item to the email from an in-memory string. Related items are
	// things such as images and style sheets that are embedded within an HTML email.
	// They are not considered attachments because their sole purpose is to participate
	// in the display of the HTML. The filenameInHtml argument should be set to the
	// filename used in the HTML img tag's src attribute (if it's an image), or the URL
	// referenced in an HTML link tag for a stylesheet. The charset argument indicates
	// that the content should first be converted to the specified charset prior to
	// adding to the email. It should hava a value such as iso-8859-1 , utf-8 ,
	// Shift_JIS , etc.
	void AddRelatedString2(const uint16_t *fileNameInHtml, const uint16_t *content, const uint16_t *charset);

	// Adds an attachment directly from a string in memory to the email.
	bool AddStringAttachment(const uint16_t *path, const uint16_t *content);

	// Adds an attachment to an email. The path specifies the filename to be used for
	// the attachment and is not an actual filename existing on the local filesystem.
	// The content contains the text data for the attachment. The string will be converted
	// to the charset specified in charset before being added to the email.
	// 
	// Note: Beginning in v9.5.0.48, the charset may be prepended with bom- or no-bom- to
	// include or exclude the BOM (preamble) for charsets such as utf-16 or utf-8. For
	// example: no-bom-utf-8 or bom-utf-8 .
	// 
	bool AddStringAttachment2(const uint16_t *path, const uint16_t *content, const uint16_t *charset);

	// Adds a recipient to the to list. emailAddress is required, but friendlyName may be empty. Emails
	// that have no To recipients will be sent to _LT_undisclosed-recipients_GT_.
	// 
	// To add multiple recipients, call this method once per TO recipient.
	// 
	bool AddTo(const uint16_t *friendlyName, const uint16_t *emailAddress);

	// Decrypts and restores an email message that was previously encrypted using
	// AesEncrypt. The password must match the password used for encryption.
	bool AesDecrypt(const uint16_t *password);

	// Encrypts the email body, all alternative bodies, all message sub-parts and
	// attachments using 128-bit AES CBC encryption. Decrypting is achieved by calling
	// AesDecrypt with the same password. The AesEncrypt/Decrypt methods use symmetric
	// password-based AES encryption and greatly simplify sending and receiving
	// encrypted emails because certificates and private keys are not used. However,
	// the sending and receiving applications must both use Chilkat, and the password
	// must be pre-known on both ends.
	bool AesEncrypt(const uint16_t *password);

	// Appends a string to the plain-text body.
	void AppendToBody(const uint16_t *str);

	// Sometimes emails created by other software or systems are not formatted
	// according to typical conventions. This method provides a means to automatically
	// fix certain problems.
	// 
	// The fixups set to a comma-separated list of keywords that identify the fixups to
	// be applied. At the moment, there is only one fixup defined ( FixRelated ) as
	// described here:
	//     * FixRelated: Fixes the email so that HTML related items (images for
	//     example) are properly located in the email MIME structure. This prevents them
	//     from being seen as attachments.
	// 
	bool ApplyFixups(const uint16_t *fixups);

	// Please see the examples at the following pages for detailed information:
	bool AspUnpack(const uint16_t *prefix, const uint16_t *saveDir, const uint16_t *urlPath, bool cleanFiles);

	// Please see the examples at the following pages for detailed information:
	bool AspUnpack2(const uint16_t *prefix, const uint16_t *saveDir, const uint16_t *urlPath, bool cleanFiles, CkByteData &outHtml);

	// Attaches copy of the email to this email object. The attached email will be
	// encapsulated in an message/rfc822 sub-part.
	bool AttachEmail(CkEmailU &email);

	// Attaches a MIME message to the email object. The attached MIME will be
	// encapsulated in an message/rfc822 sub-part.
	bool AttachMessage(CkByteData &mimeBytes);

	// Takes a byte array of multibyte (non-Unicode) data and returns a Unicode
	// B-Encoded string.
	bool BEncodeBytes(CkByteData &inData, const uint16_t *charset, CkString &outEncodedStr);
	// Takes a byte array of multibyte (non-Unicode) data and returns a Unicode
	// B-Encoded string.
	const uint16_t *bEncodeBytes(CkByteData &inData, const uint16_t *charset);

	// Takes a Unicode string, converts it to the charset specified in the 2nd
	// parameter, B-Encodes the converted multibyte data, and returns the encoded
	// Unicode string.
	bool BEncodeString(const uint16_t *str, const uint16_t *charset, CkString &outEncodedStr);
	// Takes a Unicode string, converts it to the charset specified in the 2nd
	// parameter, B-Encodes the converted multibyte data, and returns the encoded
	// Unicode string.
	const uint16_t *bEncodeString(const uint16_t *str, const uint16_t *charset);

	// Clears the email object of all information to the state as if the object was
	// just created, which will have default headers such as Mime-Version, Date,
	// Message-ID, Content-Type, Content-Transfer-Encoding, and X-Priority.
	void Clear(void);

	// Clears the list of blind carbon-copy recipients.
	void ClearBcc(void);

	// Clears the list of carbon-copy recipients.
	void ClearCC(void);

	// Clears the internal list of explicitly specified certificates to be used for
	// this encrypted email.
	void ClearEncryptCerts(void);

	// Clears the list of to recipients.
	void ClearTo(void);

	// This method is deprecated. Applications should instead call MakeCopy .
	// 
	// Creates and returns an identical copy of the Email object.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkEmailU *Clone(void);

	// Computes a global unique key for the email. The key is created by a digest-MD5
	// hash of the concatenation of the following:messageID + CRLF + subject + CRLF + from + CRLF + date + CRLF + recipientAddrs
	// 
	// messageID contains the contents of the Message-ID header field.
	// subject contains the contents of the Subject header field, trimmed of whitespace from both ends, 
	//     where TAB chars are converted to SPACE chars, and internal whitespace is trimmed so that 
	//    no more than one SPACE char in a row exists.
	// from contains the lowercase FROM header email address.
	// date contains the contents of the DATE header field.
	// toAddrs contains lowercase TO and CC recipient email addresses, comma separated, with duplicates removed, and sorted 
	//     in ascending order.  The BCC addresses are NOT included.
	// 
	// (After calling this method, the LastErrorText property can be examined to see the string that was hashed.)
	// The 16-byte MD5 hash is returned as an encoded string. The encoding determines the
	// encoding: base64, hex, url, etc. If bFold is true, then the 16-byte MD5 hash is
	// folded to 8 bytes with an XOR to produce a shorter key.
	bool ComputeGlobalKey2(const uint16_t *encoding, bool bFold, CkString &outStr);
	// Computes a global unique key for the email. The key is created by a digest-MD5
	// hash of the concatenation of the following:messageID + CRLF + subject + CRLF + from + CRLF + date + CRLF + recipientAddrs
	// 
	// messageID contains the contents of the Message-ID header field.
	// subject contains the contents of the Subject header field, trimmed of whitespace from both ends, 
	//     where TAB chars are converted to SPACE chars, and internal whitespace is trimmed so that 
	//    no more than one SPACE char in a row exists.
	// from contains the lowercase FROM header email address.
	// date contains the contents of the DATE header field.
	// toAddrs contains lowercase TO and CC recipient email addresses, comma separated, with duplicates removed, and sorted 
	//     in ascending order.  The BCC addresses are NOT included.
	// 
	// (After calling this method, the LastErrorText property can be examined to see the string that was hashed.)
	// The 16-byte MD5 hash is returned as an encoded string. The encoding determines the
	// encoding: base64, hex, url, etc. If bFold is true, then the 16-byte MD5 hash is
	// folded to 8 bytes with an XOR to produce a shorter key.
	const uint16_t *computeGlobalKey2(const uint16_t *encoding, bool bFold);

	// Converts images embedded inline within HTML to multipart/related MIME parts
	// referenced from the HTML by CID.
	bool ConvertInlineImages(void);

	// This method is deprecated. Applications should instead call ToDsn .
	// 
	// Creates a new DSN (Delivery Status Notification) email having the format as
	// specified in RFC 3464. See the example (below) for more detailed information.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkEmailU *CreateDsn(const uint16_t *humanReadableMessage, const uint16_t *xmlStatusFields, bool bHeaderOnly);

	// This method is deprecated. Applications should instead call ToForward .
	// 
	// Returns a copy of the Email object with the body and header fields changed so
	// that the newly created email can be forwarded. After calling CreateForward,
	// simply add new recipients to the created email, and call MailMan.SendEmail.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkEmailU *CreateForward(void);

	// This method is deprecated. Applications should instead call ToMdn .
	// 
	// Creates a new MDN (Message Disposition Notification) email having the format as
	// specified in RFC 3798. See the example (below) for more detailed information.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkEmailU *CreateMdn(const uint16_t *humanReadableMessage, const uint16_t *xmlStatusFields, bool bHeaderOnly);

	// This method is deprecated. Applications should instead call ToReply .
	// 
	// Returns a copy of the Email object with the body and header fields changed so
	// that the newly created email can be sent as a reply. After calling CreateReply,
	// simply prepend additional information to the body, and call MailMan.SendEmail.
	// 
	// Note: Attachments are not included in the returned reply email. However,
	// attached messages are included. If an application does not wish to include the
	// attached messages in a reply email, they can be removed by calling
	// RemoveAttachedMessages on the reply email object.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkEmailU *CreateReply(void);

	// Saves the email to a temporary MHT file so that a WebBrowser control can
	// navigate to it and display it. If fileName is empty, a temporary filename is
	// generated and returned. If fileName is non-empty, then it will be created or
	// overwritten, and the input filename is simply returned.The MHT file that is
	// created will not contain any of the email's attachments, if any existed. Also,
	// if the email was plain-text, the MHT file will be saved such that the plain-text
	// is converted to HTML using pre-formatted text ( pre HTML tags) allowing it to be
	// displayed correctly in a WebBrowser.
	bool CreateTempMht(const uint16_t *inFilename, CkString &outPath);
	// Saves the email to a temporary MHT file so that a WebBrowser control can
	// navigate to it and display it. If fileName is empty, a temporary filename is
	// generated and returned. If fileName is non-empty, then it will be created or
	// overwritten, and the input filename is simply returned.The MHT file that is
	// created will not contain any of the email's attachments, if any existed. Also,
	// if the email was plain-text, the MHT file will be saved such that the plain-text
	// is converted to HTML using pre-formatted text ( pre HTML tags) allowing it to be
	// displayed correctly in a WebBrowser.
	const uint16_t *createTempMht(const uint16_t *inFilename);

	// Removes all attachments from the email.
	void DropAttachments(void);

	// A related item is typically an embedded image referenced from the HTML in the
	// email via a CID hyperlink. This method removes the Nth embedded image from the
	// email. Note: If the HTML tries to reference the removed image, it will be
	// displayed as a broken image link.
	void DropRelatedItem(int index);

	// A related item is typically an embedded image referenced from the HTML in the
	// email via a CID hyperlink. This method removes all the embedded images from the
	// email.
	void DropRelatedItems(void);

	// Drops a single attachment from the email. Returns True if successful.
	bool DropSingleAttachment(int index);

	// This method is deprecated. Applications can instead call the certificate
	// object's GetIssuer method.
	// 
	// Digitally signed and/or encrypted emails are automatically unwrapped when
	// received from a POP3 or IMAP server, or when loaded from any source such as a
	// MIME string, in-memory byte data, or a .eml file. The results of the signature
	// verification / decryption are stored in the properties such as ReceivedSigned,
	// ReceivedEncrypted, SignaturesValid, etc. The signing certificate can be obtained
	// via the GetSigningCert function. If the signature contained more certificates in
	// the chain of authentication, this method provides a means to access them.
	// 
	// During signature verification, the email object collects the certs found in the
	// signature and holds onto them internally. To get the issuing certificate of the
	// signing certificate, call this method passing the cert returned by
	// GetSigningCert. If the issuing cert is available, it is returned. Otherwise
	// _NULL_ is returned. If the cert passed in is the root (i.e. a self-signed
	// certificate), then the cert object returned is a copy of the cert passed in.
	// 
	// To traverse the chain to the root, one would write a loop that on first
	// iteration passes the cert returned by GetSignedByCert (not GetSignerCert), and
	// then on each subsequent iteration passes the cert from the previous iteration.
	// The loop would exit when a cert is returned that has the same SubjectDN and
	// SerialNumber as what was passed in (or when FindIssuer returns _NULL_).
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkCertU *FindIssuer(CkCertU &cert);

	// Generates a unique filename for this email. The filename will be different each
	// time the method is called.
	bool GenerateFilename(CkString &outStrFilename);
	// Generates a unique filename for this email. The filename will be different each
	// time the method is called.
	const uint16_t *generateFilename(void);

	// Returns the Nth alternative body. The NumAlternatives property tells the number
	// of alternative bodies present. Use the GetHtmlBody and GetPlainTextBody methods
	// to easily get the HTML or plain text alternative bodies.
	bool GetAlternativeBody(int index, CkString &outStrBody);
	// Returns the Nth alternative body. The NumAlternatives property tells the number
	// of alternative bodies present. Use the GetHtmlBody and GetPlainTextBody methods
	// to easily get the HTML or plain text alternative bodies.
	const uint16_t *getAlternativeBody(int index);
	// Returns the Nth alternative body. The NumAlternatives property tells the number
	// of alternative bodies present. Use the GetHtmlBody and GetPlainTextBody methods
	// to easily get the HTML or plain text alternative bodies.
	const uint16_t *alternativeBody(int index);

	// Returns contents of the Nth alternative body to binData. The 1st alternative body
	// is at index 0. This method should only be called when the NumAlternatives
	// property has a value greater than 0.
	bool GetAlternativeBodyBd(int index, CkBinDataU &binData);

	// Returns the alternative body by content-type, such as text/plain , text/html ,
	// text/xml , etc.
	bool GetAlternativeBodyByContentType(const uint16_t *contentType, CkString &outStr);
	// Returns the alternative body by content-type, such as text/plain , text/html ,
	// text/xml , etc.
	const uint16_t *getAlternativeBodyByContentType(const uint16_t *contentType);
	// Returns the alternative body by content-type, such as text/plain , text/html ,
	// text/xml , etc.
	const uint16_t *alternativeBodyByContentType(const uint16_t *contentType);

	// Returns the content type of the Nth alternative body. The NumAlternatives
	// property tells the number of alternative bodies present.
	bool GetAlternativeContentType(int index, CkString &outStrContentType);
	// Returns the content type of the Nth alternative body. The NumAlternatives
	// property tells the number of alternative bodies present.
	const uint16_t *getAlternativeContentType(int index);
	// Returns the content type of the Nth alternative body. The NumAlternatives
	// property tells the number of alternative bodies present.
	const uint16_t *alternativeContentType(int index);

	// Returns the value of a header field within the Nth alternative body's MIME
	// sub-part.
	bool GetAltHeaderField(int index, const uint16_t *fieldName, CkString &outStr);
	// Returns the value of a header field within the Nth alternative body's MIME
	// sub-part.
	const uint16_t *getAltHeaderField(int index, const uint16_t *fieldName);
	// Returns the value of a header field within the Nth alternative body's MIME
	// sub-part.
	const uint16_t *altHeaderField(int index, const uint16_t *fieldName);

	// The Nth embedded message/rfc822 subpart in email.
	bool GetAttachedEmail(int index, CkEmailU &email);

	// This method is deprecated. Applications should instead call GetAttachedEmail .
	// 
	// Returns an embedded message/rfc822 subpart as an email object. (Emails are
	// embedded as message/rfc822 subparts by some mail clients when forwarding an
	// email.) This method allows the original email to be accessed.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkEmailU *GetAttachedMessage(int index);

	// Returns a header field attribute value for the Nth attached (embedded) email.
	// For example, to get the value of the name attribute in the Content-Type header
	// for the 1st attached message:Content-Type: message/rfc822; name="md75000024149.eml"
	// then the method arguments should contain the values 0, Content-Type , name .
	bool GetAttachedMessageAttr(int index, const uint16_t *fieldName, const uint16_t *attrName, CkString &outStr);
	// Returns a header field attribute value for the Nth attached (embedded) email.
	// For example, to get the value of the name attribute in the Content-Type header
	// for the 1st attached message:Content-Type: message/rfc822; name="md75000024149.eml"
	// then the method arguments should contain the values 0, Content-Type , name .
	const uint16_t *getAttachedMessageAttr(int index, const uint16_t *fieldName, const uint16_t *attrName);
	// Returns a header field attribute value for the Nth attached (embedded) email.
	// For example, to get the value of the name attribute in the Content-Type header
	// for the 1st attached message:Content-Type: message/rfc822; name="md75000024149.eml"
	// then the method arguments should contain the values 0, Content-Type , name .
	const uint16_t *attachedMessageAttr(int index, const uint16_t *fieldName, const uint16_t *attrName);

	// Returns the filename of the Nth attached (embedded) email. The filename is the
	// filename attribute of the content-disposition header field found within the Nth
	// message/rfc822 sub-part of the calling email object.
	// 
	// Important: The attached message filename is only present if the
	// Content-Disposition header exists AND contains a filename attribute. If
	// questions arise, one could open the email in a text editor to examine the MIME
	// sub-header for the attached message (where the Content-Type = message/rfc822 ).
	// For example, here is a sub-header that has a filename:Content-Type: message/rfc822; name="GetAttachedMessageAttr.eml"
	// Content-Transfer-Encoding: 7bit
	// Content-Disposition: attachment; filename="GetAttachedMessageAttr.eml"
	// Here is an attached message sub-header that does NOT have a filename:Content-Type: message/rfc822
	// Content-Transfer-Encoding: 7bit
	// Content-Disposition: attachment
	// 
	bool GetAttachedMessageFilename(int index, CkString &outStr);
	// Returns the filename of the Nth attached (embedded) email. The filename is the
	// filename attribute of the content-disposition header field found within the Nth
	// message/rfc822 sub-part of the calling email object.
	// 
	// Important: The attached message filename is only present if the
	// Content-Disposition header exists AND contains a filename attribute. If
	// questions arise, one could open the email in a text editor to examine the MIME
	// sub-header for the attached message (where the Content-Type = message/rfc822 ).
	// For example, here is a sub-header that has a filename:Content-Type: message/rfc822; name="GetAttachedMessageAttr.eml"
	// Content-Transfer-Encoding: 7bit
	// Content-Disposition: attachment; filename="GetAttachedMessageAttr.eml"
	// Here is an attached message sub-header that does NOT have a filename:Content-Type: message/rfc822
	// Content-Transfer-Encoding: 7bit
	// Content-Disposition: attachment
	// 
	const uint16_t *getAttachedMessageFilename(int index);
	// Returns the filename of the Nth attached (embedded) email. The filename is the
	// filename attribute of the content-disposition header field found within the Nth
	// message/rfc822 sub-part of the calling email object.
	// 
	// Important: The attached message filename is only present if the
	// Content-Disposition header exists AND contains a filename attribute. If
	// questions arise, one could open the email in a text editor to examine the MIME
	// sub-header for the attached message (where the Content-Type = message/rfc822 ).
	// For example, here is a sub-header that has a filename:Content-Type: message/rfc822; name="GetAttachedMessageAttr.eml"
	// Content-Transfer-Encoding: 7bit
	// Content-Disposition: attachment; filename="GetAttachedMessageAttr.eml"
	// Here is an attached message sub-header that does NOT have a filename:Content-Type: message/rfc822
	// Content-Transfer-Encoding: 7bit
	// Content-Disposition: attachment
	// 
	const uint16_t *attachedMessageFilename(int index);

	// Returns a header field attribute value from the header field of the Nth
	// attachment.
	bool GetAttachmentAttr(int index, const uint16_t *fieldName, const uint16_t *attrName, CkString &outStr);
	// Returns a header field attribute value from the header field of the Nth
	// attachment.
	const uint16_t *getAttachmentAttr(int index, const uint16_t *fieldName, const uint16_t *attrName);
	// Returns a header field attribute value from the header field of the Nth
	// attachment.
	const uint16_t *attachmentAttr(int index, const uint16_t *fieldName, const uint16_t *attrName);

	// Copies an attachment's binary data into binData. The first attachment is at index
	// 0.
	bool GetAttachmentBd(int index, CkBinDataU &binData);

	// Returns the ContentID header field for the Nth attachment. The first attachment
	// is at index 0.
	bool GetAttachmentContentID(int index, CkString &outStrContentID);
	// Returns the ContentID header field for the Nth attachment. The first attachment
	// is at index 0.
	const uint16_t *getAttachmentContentID(int index);
	// Returns the ContentID header field for the Nth attachment. The first attachment
	// is at index 0.
	const uint16_t *attachmentContentID(int index);

	// Returns the Content-Type header field for the Nth attachment. Indexing of
	// attachments begins at 0.
	bool GetAttachmentContentType(int index, CkString &outStrContentType);
	// Returns the Content-Type header field for the Nth attachment. Indexing of
	// attachments begins at 0.
	const uint16_t *getAttachmentContentType(int index);
	// Returns the Content-Type header field for the Nth attachment. Indexing of
	// attachments begins at 0.
	const uint16_t *attachmentContentType(int index);

	// Retrieves an attachment's binary data for in-memory access.
	bool GetAttachmentData(int index, CkByteData &outData);

	// Retrieves an attachment's filename.
	bool GetAttachmentFilename(int index, CkString &outStrFilename);
	// Retrieves an attachment's filename.
	const uint16_t *getAttachmentFilename(int index);
	// Retrieves an attachment's filename.
	const uint16_t *attachmentFilename(int index);

	// Returns the value of a header field (by name) of an attachment.
	bool GetAttachmentHeader(int attachIndex, const uint16_t *fieldName, CkString &outFieldValue);
	// Returns the value of a header field (by name) of an attachment.
	const uint16_t *getAttachmentHeader(int attachIndex, const uint16_t *fieldName);
	// Returns the value of a header field (by name) of an attachment.
	const uint16_t *attachmentHeader(int attachIndex, const uint16_t *fieldName);

	// Returns the size (in bytes) of the Nth attachment. The 1st attachment is at
	// index 0. Returns -1 if there is no attachment at the specified index.
	int GetAttachmentSize(int index);

	// Retrieves an attachment's data as a String. All CRLF sequences will be
	// translated to single newline characters. The charset indicates how to interpret the
	// bytes of the attachment. For example, if the attachment is a text file using the
	// utf-8 byte representation for characters, pass utf-8 .
	bool GetAttachmentString(int index, const uint16_t *charset, CkString &outStr);
	// Retrieves an attachment's data as a String. All CRLF sequences will be
	// translated to single newline characters. The charset indicates how to interpret the
	// bytes of the attachment. For example, if the attachment is a text file using the
	// utf-8 byte representation for characters, pass utf-8 .
	const uint16_t *getAttachmentString(int index, const uint16_t *charset);
	// Retrieves an attachment's data as a String. All CRLF sequences will be
	// translated to single newline characters. The charset indicates how to interpret the
	// bytes of the attachment. For example, if the attachment is a text file using the
	// utf-8 byte representation for characters, pass utf-8 .
	const uint16_t *attachmentString(int index, const uint16_t *charset);

	// Retrieves an attachment's data as a String. All end-of-lines will be translated
	// to CRLF sequences.
	bool GetAttachmentStringCrLf(int index, const uint16_t *charset, CkString &outStrData);
	// Retrieves an attachment's data as a String. All end-of-lines will be translated
	// to CRLF sequences.
	const uint16_t *getAttachmentStringCrLf(int index, const uint16_t *charset);
	// Retrieves an attachment's data as a String. All end-of-lines will be translated
	// to CRLF sequences.
	const uint16_t *attachmentStringCrLf(int index, const uint16_t *charset);

	// Returns a blind carbon-copy recipient's full email address.
	bool GetBcc(int index, CkString &outStr);
	// Returns a blind carbon-copy recipient's full email address.
	const uint16_t *getBcc(int index);
	// Returns a blind carbon-copy recipient's full email address.
	const uint16_t *bcc(int index);

	// Returns the Nth BCC address (only the address part, not the friendly-name part).
	bool GetBccAddr(int index, CkString &outStr);
	// Returns the Nth BCC address (only the address part, not the friendly-name part).
	const uint16_t *getBccAddr(int index);
	// Returns the Nth BCC address (only the address part, not the friendly-name part).
	const uint16_t *bccAddr(int index);

	// Returns the Nth BCC name (only the friendly-name part, not the address part).
	bool GetBccName(int index, CkString &outStr);
	// Returns the Nth BCC name (only the friendly-name part, not the address part).
	const uint16_t *getBccName(int index);
	// Returns the Nth BCC name (only the friendly-name part, not the address part).
	const uint16_t *bccName(int index);

	// Returns a carbon-copy recipient's full email address.
	bool GetCC(int index, CkString &outStr);
	// Returns a carbon-copy recipient's full email address.
	const uint16_t *getCC(int index);
	// Returns a carbon-copy recipient's full email address.
	const uint16_t *cC(int index);

	// Returns the Nth CC address (only the address part, not the friendly-name part).
	bool GetCcAddr(int index, CkString &outStr);
	// Returns the Nth CC address (only the address part, not the friendly-name part).
	const uint16_t *getCcAddr(int index);
	// Returns the Nth CC address (only the address part, not the friendly-name part).
	const uint16_t *ccAddr(int index);

	// Returns the Nth CC name (only the friendly-name part, not the address part).
	bool GetCcName(int index, CkString &outStr);
	// Returns the Nth CC name (only the friendly-name part, not the address part).
	const uint16_t *getCcName(int index);
	// Returns the Nth CC name (only the friendly-name part, not the address part).
	const uint16_t *ccName(int index);

	// If the email is a multipart/report, then it is a delivery status notification.
	// This method can be used to get individual pieces of information from the
	// message/delivery-status part of the email. This method should only be called if
	// the IsMultipartReport method returns true.
	// 
	// The fieldName should be set a string such as Final-Recipient , Status , Action ,
	// Reporting-MTA , etc.Reporting-MTA: dns; XYZ.abc.nl
	// 
	// Final-recipient: RFC822; someEmailAddr@doesnotexist123.nl
	// Action: failed
	// Status: 5.4.4
	// X-Supplementary-Info: 
	// 
	bool GetDeliveryStatusInfo(const uint16_t *fieldName, CkString &outFieldValue);
	// If the email is a multipart/report, then it is a delivery status notification.
	// This method can be used to get individual pieces of information from the
	// message/delivery-status part of the email. This method should only be called if
	// the IsMultipartReport method returns true.
	// 
	// The fieldName should be set a string such as Final-Recipient , Status , Action ,
	// Reporting-MTA , etc.Reporting-MTA: dns; XYZ.abc.nl
	// 
	// Final-recipient: RFC822; someEmailAddr@doesnotexist123.nl
	// Action: failed
	// Status: 5.4.4
	// X-Supplementary-Info: 
	// 
	const uint16_t *getDeliveryStatusInfo(const uint16_t *fieldName);
	// If the email is a multipart/report, then it is a delivery status notification.
	// This method can be used to get individual pieces of information from the
	// message/delivery-status part of the email. This method should only be called if
	// the IsMultipartReport method returns true.
	// 
	// The fieldName should be set a string such as Final-Recipient , Status , Action ,
	// Reporting-MTA , etc.Reporting-MTA: dns; XYZ.abc.nl
	// 
	// Final-recipient: RFC822; someEmailAddr@doesnotexist123.nl
	// Action: failed
	// Status: 5.4.4
	// X-Supplementary-Info: 
	// 
	const uint16_t *deliveryStatusInfo(const uint16_t *fieldName);

	// This method is deprecated. Applications should instead call GetDigestEmail .
	// 
	// Returns an digest contained within a multipart/digest as an email object. The
	// 1st digest is at index 0. Use the NumDigests property to get the number of
	// digests available.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkEmailU *GetDigest(int index);

	// Returns in email the Nth digest email contained within a multipart/digest. The
	// 1st digest is at index 0. Use the NumDigests property to get the number of
	// digests available.
	bool GetDigestEmail(int index, CkEmailU &email);

	// This method is deprecated. Applications should instead call GetDsnInfo .
	// 
	// If the email is a multipart/report, then it is a delivery status notification.
	// This method can be used to get Final-Recipient values from the
	// message/delivery-status part of the email. This method should only be called if
	// the IsMultipartReport method returns true.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkStringArrayU *GetDsnFinalRecipients(void);

	// If the IsMultipartReport property indicates that the email is multipart/report ,
	// you can use this method to obtain the delivery status information, including the
	// final recipients, in a JSON format that is easy to parse.
	// 
	// References:
	// 1: #IsMultipartReport
	bool GetDsnInfo(CkJsonObjectU &json);

	// This method is deprecated. Applications should instead use the EmailDateStr
	// property.
	// 
	// Returns the date/time found in the Date header field as a date/time object.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkDateTimeU *GetDt(void);

	// Returns the certificate that was previously set by SetEncryptCert.
	// The caller is responsible for deleting the object returned by this method.
	CkCertU *GetEncryptCert(void);

	// This method is deprecated. Applications should instead call LastDecryptCert to
	// get the certificate used to decrypt this email.
	// 
	// Returns the certificate associated with a received encrypted email.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkCertU *GetEncryptedByCert(void);

	// Reads a file and returns the contents. This is here purely for convenience.
	bool GetFileContent(const uint16_t *path, CkByteData &outData);

	// Returns the value of a header field.
	bool GetHeaderField(const uint16_t *fieldName, CkString &outStrFieldData);
	// Returns the value of a header field.
	const uint16_t *getHeaderField(const uint16_t *fieldName);
	// Returns the value of a header field.
	const uint16_t *headerField(const uint16_t *fieldName);

	// Return the name of the Nth header field. The NumHeaderFields() method can be
	// used to get the number of header fields. The GetHeaderField() method can be used
	// to get the value of the field given the field name.
	// 
	// The 1st header field is at index 0. (All Chilkat indexing is 0-based.)
	// 
	bool GetHeaderFieldName(int index, CkString &outStrFieldName);
	// Return the name of the Nth header field. The NumHeaderFields() method can be
	// used to get the number of header fields. The GetHeaderField() method can be used
	// to get the value of the field given the field name.
	// 
	// The 1st header field is at index 0. (All Chilkat indexing is 0-based.)
	// 
	const uint16_t *getHeaderFieldName(int index);
	// Return the name of the Nth header field. The NumHeaderFields() method can be
	// used to get the number of header fields. The GetHeaderField() method can be used
	// to get the value of the field given the field name.
	// 
	// The 1st header field is at index 0. (All Chilkat indexing is 0-based.)
	// 
	const uint16_t *headerFieldName(int index);

	// Returns the value of the Nth header field. (Indexing begins at 0) The number of
	// header fields can be obtained from the NumHeaderFields property.
	// 
	// The 1st header field is at index 0, the last header field is at index
	// NumHeaderFields-1. (All Chilkat indexing is 0-based.)
	// 
	bool GetHeaderFieldValue(int index, CkString &outStrFieldValue);
	// Returns the value of the Nth header field. (Indexing begins at 0) The number of
	// header fields can be obtained from the NumHeaderFields property.
	// 
	// The 1st header field is at index 0, the last header field is at index
	// NumHeaderFields-1. (All Chilkat indexing is 0-based.)
	// 
	const uint16_t *getHeaderFieldValue(int index);
	// Returns the value of the Nth header field. (Indexing begins at 0) The number of
	// header fields can be obtained from the NumHeaderFields property.
	// 
	// The 1st header field is at index 0, the last header field is at index
	// NumHeaderFields-1. (All Chilkat indexing is 0-based.)
	// 
	const uint16_t *headerFieldValue(int index);

	// Returns the body having the text/html content type.
	bool GetHtmlBody(CkString &outStrBody);
	// Returns the body having the text/html content type.
	const uint16_t *getHtmlBody(void);
	// Returns the body having the text/html content type.
	const uint16_t *htmlBody(void);

	// Returns the body having the text/html content type. If inlineImageData is true, the
	// related images found in the MIME are inlined as base64 directly within the
	// returned HTML. The HTML is returned in sb.
	bool GetHtmlBodySb(bool inlineImageData, CkStringBuilderU &sb);

	// When email headers are downloaded from an IMAP server (using Chilkat IMAP), a
	// ckx-imap-uid header field is added. The content of this header is the UID or
	// sequence number of the email on the IMAP server. In addition, a ckx-imap-isUid
	// header field is added, and this will have the value YES or NO. If the value is
	// YES, then ckx-imap-uid contains a UID, if the value is NO, then ckx-imap-uid
	// contains the sequence number. This method returns the UID if ckx-imap-uid exists
	// and contains a UID, otherwise it returns 0xFFFFFFFF.
	// 
	// An application that wishes to download the full email would use this UID and
	// then call the Chilkat IMAP object's FetchSingle or FetchSingleAsMime methods.
	// 
	// Note:If an email was downloaded from the IMAP server in a way such that the UID
	// is not received, then there will be no ckx-imap-uid header field and this method
	// would return 0xFFFFFFFF. For example, if emails are downloaded by sequence
	// numbers via the Imap.FetchSequence method, then UIDs are not used and therefore
	// the email object will not contain this information.
	// 
	unsigned long GetImapUid(void);

	// This method is deprecated. Applications should instead call LinkedDomains .
	// 
	// Parses an HTML email and returns the set of domain names that occur in
	// hyperlinks within the HTML body.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkStringArrayU *GetLinkedDomains(void);

	// Return the email as MIME text containing the email header, body (or bodies),
	// related items (if any), and all attachments
	bool GetMime(CkString &outStrMime);
	// Return the email as MIME text containing the email header, body (or bodies),
	// related items (if any), and all attachments
	const uint16_t *getMime(void);
	// Return the email as MIME text containing the email header, body (or bodies),
	// related items (if any), and all attachments
	const uint16_t *mime(void);

	// Return the email as binary MIME containing the email header, body (or bodies),
	// related items (if any), and all attachments. The MIME is appended to the
	// existing contents (if any) of bindat.
	bool GetMimeBd(CkBinDataU &bindat);

	// Returns the full MIME of an email.
	bool GetMimeBinary(CkByteData &outBytes);

	// Return the email as MIME text containing the email header, body (or bodies),
	// related items (if any), and all attachments. The MIME is appended to the
	// existing contents (if any) of sb.
	bool GetMimeSb(CkStringBuilderU &sb);

	// Returns the binary bytes of the Nth MIME sub-part having a specified content
	// type (such as application/pdf . Indexing begins at 0. Call GetNumPartsOfType to
	// find out how many MIME sub-parts exist for any given content type. If inlineOnly is
	// true, then only MIME sub-parts having a content-disposition of inline are
	// included. If excludeAttachments is true, then MIME sub-parts having a content-disposition of
	// attachment are excluded.
	// 
	// Note: If the email was downloaded as header-only, it will not contain all the
	// parts of the full email. Also, if downloaded from IMAP excluding attachments,
	// those parts that are the attachments will (of course) be missing.
	// 
	// Note: Beginning in v9.5.0.95, the contentType can be wildcarded. For example, it is
	// possible to specify text/* , or simply * to match any Content-Type.
	// 
	// Note: Only non-multipart MIME parts are matched.
	// 
	bool GetNthBinaryPartOfType(int index, const uint16_t *contentType, bool inlineOnly, bool excludeAttachments, CkByteData &outBytes);

	// Loads bd with the binary bytes of the Nth MIME sub-part matching the contentType,
	// which can be an exact Content-Type such as application/pdf , or a wildcarded
	// Content-Type such as application/* , or */* . Indexing begins at 0. Call
	// GetNumPartsOfType to find out how many MIME sub-parts exist for any given
	// content type. If inlineOnly is true, then only MIME sub-parts having a
	// content-disposition of inline are included. If excludeAttachments is true, then MIME
	// sub-parts having a content-disposition of attachment are excluded.
	// 
	// Note: If the email was downloaded as header-only, it will not contain all the
	// parts of the full email. Also, if downloaded from IMAP excluding attachments,
	// those parts that are the attachments will (of course) be missing.
	// 
	// Note: Beginning in v9.5.0.95, the contentType can be wildcarded. For example, it is
	// possible to specify text/* , or simply * to match any Content-Type.
	// 
	// Note: Only non-multipart MIME parts are matched.
	// 
	bool GetNthBinaryPartOfTypeBd(int index, const uint16_t *contentType, bool inlineOnly, bool excludeAttachments, CkBinDataU &bd);

	// Returns the Content-Type of the Nth MIME sub-part matching the specified contentType.
	// The contentType can be a Content-Type such as text/plain , or a wildcarded Content-Type
	// such as text/* , or even just * to match all Content-Types. If inlineOnly is true,
	// then only MIME sub-parts having a content-disposition of inline are included. If
	// excludeAttachments is true, then MIME sub-parts having a content-disposition of attachment
	// are excluded.
	// 
	// Note: Only non-multipart content-types are matched.
	// 
	bool GetNthContentType(int index, const uint16_t *contentType, bool inlineOnly, bool excludeAttachments, CkString &outStr);
	// Returns the Content-Type of the Nth MIME sub-part matching the specified contentType.
	// The contentType can be a Content-Type such as text/plain , or a wildcarded Content-Type
	// such as text/* , or even just * to match all Content-Types. If inlineOnly is true,
	// then only MIME sub-parts having a content-disposition of inline are included. If
	// excludeAttachments is true, then MIME sub-parts having a content-disposition of attachment
	// are excluded.
	// 
	// Note: Only non-multipart content-types are matched.
	// 
	const uint16_t *getNthContentType(int index, const uint16_t *contentType, bool inlineOnly, bool excludeAttachments);
	// Returns the Content-Type of the Nth MIME sub-part matching the specified contentType.
	// The contentType can be a Content-Type such as text/plain , or a wildcarded Content-Type
	// such as text/* , or even just * to match all Content-Types. If inlineOnly is true,
	// then only MIME sub-parts having a content-disposition of inline are included. If
	// excludeAttachments is true, then MIME sub-parts having a content-disposition of attachment
	// are excluded.
	// 
	// Note: Only non-multipart content-types are matched.
	// 
	const uint16_t *nthContentType(int index, const uint16_t *contentType, bool inlineOnly, bool excludeAttachments);

	// Returns the text of the Nth MIME sub-part having a specified content type (such
	// as text/plain . Indexing begins at 0. Call GetNumPartsOfType to find out how
	// many MIME sub-parts exist for any given content type. If inlineOnly is true, then
	// only MIME sub-parts having a content-disposition of inline are included. If excludeAttachments
	// is true, then MIME sub-parts having a content-disposition of attachment are
	// excluded.
	// 
	// Note: If the email was downloaded as header-only, it will not contain all the
	// parts of the full email. Also, if downloaded from IMAP excluding attachments,
	// those parts that are the attachments will (of course) be missing.
	// 
	// Note: Beginning in v9.5.0.95, the contentType can be wildcarded. For example, it is
	// possible to specify text/* , or simply * to match any Content-Type.
	// 
	// Note: Only non-multipart MIME parts are matched.
	// 
	bool GetNthTextPartOfType(int index, const uint16_t *contentType, bool inlineOnly, bool excludeAttachments, CkString &outStr);
	// Returns the text of the Nth MIME sub-part having a specified content type (such
	// as text/plain . Indexing begins at 0. Call GetNumPartsOfType to find out how
	// many MIME sub-parts exist for any given content type. If inlineOnly is true, then
	// only MIME sub-parts having a content-disposition of inline are included. If excludeAttachments
	// is true, then MIME sub-parts having a content-disposition of attachment are
	// excluded.
	// 
	// Note: If the email was downloaded as header-only, it will not contain all the
	// parts of the full email. Also, if downloaded from IMAP excluding attachments,
	// those parts that are the attachments will (of course) be missing.
	// 
	// Note: Beginning in v9.5.0.95, the contentType can be wildcarded. For example, it is
	// possible to specify text/* , or simply * to match any Content-Type.
	// 
	// Note: Only non-multipart MIME parts are matched.
	// 
	const uint16_t *getNthTextPartOfType(int index, const uint16_t *contentType, bool inlineOnly, bool excludeAttachments);
	// Returns the text of the Nth MIME sub-part having a specified content type (such
	// as text/plain . Indexing begins at 0. Call GetNumPartsOfType to find out how
	// many MIME sub-parts exist for any given content type. If inlineOnly is true, then
	// only MIME sub-parts having a content-disposition of inline are included. If excludeAttachments
	// is true, then MIME sub-parts having a content-disposition of attachment are
	// excluded.
	// 
	// Note: If the email was downloaded as header-only, it will not contain all the
	// parts of the full email. Also, if downloaded from IMAP excluding attachments,
	// those parts that are the attachments will (of course) be missing.
	// 
	// Note: Beginning in v9.5.0.95, the contentType can be wildcarded. For example, it is
	// possible to specify text/* , or simply * to match any Content-Type.
	// 
	// Note: Only non-multipart MIME parts are matched.
	// 
	const uint16_t *nthTextPartOfType(int index, const uint16_t *contentType, bool inlineOnly, bool excludeAttachments);

	// Returns the number of MIME sub-parts within the email having a specified content
	// type (such as text/plain ). If inlineOnly is true, then only MIME sub-parts having a
	// content-disposition of inline are included. If excludeAttachments is true, then MIME
	// sub-parts having a content-disposition of attachment are excluded.
	// 
	// Note: If the email was downloaded as header-only, it will not contain all the
	// parts of the full email. Also, if downloaded from IMAP excluding attachments,
	// those parts that are the attachments will (of course) be missing.
	// 
	// Note: Beginning in v9.5.0.95, the inlineOnly can be wildcarded. For example, it is
	// possible to specify text/* , or simply * to match any Content-Type.
	// 
	// Note: Only non-multipart MIME parts are matched (i.e. leaf-node MIME parts that
	// contain a text or binary body).
	// 
	int GetNumPartsOfType(const uint16_t *contentType, bool inlineOnly, bool excludeAttachments);

	// Returns the email body having the text/plain content type.
	bool GetPlainTextBody(CkString &outStrBody);
	// Returns the email body having the text/plain content type.
	const uint16_t *getPlainTextBody(void);
	// Returns the email body having the text/plain content type.
	const uint16_t *plainTextBody(void);

	// Returns a header field attribute value from the header field of the Nth related
	// item.
	bool GetRelatedAttr(int index, const uint16_t *fieldName, const uint16_t *attrName, CkString &outStr);
	// Returns a header field attribute value from the header field of the Nth related
	// item.
	const uint16_t *getRelatedAttr(int index, const uint16_t *fieldName, const uint16_t *attrName);
	// Returns a header field attribute value from the header field of the Nth related
	// item.
	const uint16_t *relatedAttr(int index, const uint16_t *fieldName, const uint16_t *attrName);

	// Returns the content ID of a related item contained with the email. Related items
	// are typically images and style-sheets embedded within HTML emails.
	bool GetRelatedContentID(int index, CkString &outStrContentID);
	// Returns the content ID of a related item contained with the email. Related items
	// are typically images and style-sheets embedded within HTML emails.
	const uint16_t *getRelatedContentID(int index);
	// Returns the content ID of a related item contained with the email. Related items
	// are typically images and style-sheets embedded within HTML emails.
	const uint16_t *relatedContentID(int index);

	// Returns the Content-Location of a related item contained with the email. Related
	// items are typically images and style-sheets embedded within HTML emails.
	bool GetRelatedContentLocation(int index, CkString &outStr);
	// Returns the Content-Location of a related item contained with the email. Related
	// items are typically images and style-sheets embedded within HTML emails.
	const uint16_t *getRelatedContentLocation(int index);
	// Returns the Content-Location of a related item contained with the email. Related
	// items are typically images and style-sheets embedded within HTML emails.
	const uint16_t *relatedContentLocation(int index);

	// Returns the content-type of the Nth related content item in an email message.
	bool GetRelatedContentType(int index, CkString &outStrContentType);
	// Returns the content-type of the Nth related content item in an email message.
	const uint16_t *getRelatedContentType(int index);
	// Returns the content-type of the Nth related content item in an email message.
	const uint16_t *relatedContentType(int index);

	// Returns the content of a related item contained with the email. Related items
	// are typically images and style-sheets embedded within HTML emails.
	bool GetRelatedData(int index, CkByteData &outBuffer);

	// Returns the filename of a related item contained with the email. Related items
	// are typically images and style-sheets embedded within HTML emails.
	bool GetRelatedFilename(int index, CkString &outStrFilename);
	// Returns the filename of a related item contained with the email. Related items
	// are typically images and style-sheets embedded within HTML emails.
	const uint16_t *getRelatedFilename(int index);
	// Returns the filename of a related item contained with the email. Related items
	// are typically images and style-sheets embedded within HTML emails.
	const uint16_t *relatedFilename(int index);

	// Returns the value of a header field (by name) of a related item.
	bool GetRelatedHeader(int index, const uint16_t *fieldName, CkString &outStr);
	// Returns the value of a header field (by name) of a related item.
	const uint16_t *getRelatedHeader(int index, const uint16_t *fieldName);
	// Returns the value of a header field (by name) of a related item.
	const uint16_t *relatedHeader(int index, const uint16_t *fieldName);

	// Returns the text with CR line-endings of a related item contained with the
	// email. Related items are typically images and style-sheets embedded within HTML
	// emails.
	bool GetRelatedString(int index, const uint16_t *charset, CkString &outStrData);
	// Returns the text with CR line-endings of a related item contained with the
	// email. Related items are typically images and style-sheets embedded within HTML
	// emails.
	const uint16_t *getRelatedString(int index, const uint16_t *charset);
	// Returns the text with CR line-endings of a related item contained with the
	// email. Related items are typically images and style-sheets embedded within HTML
	// emails.
	const uint16_t *relatedString(int index, const uint16_t *charset);

	// Returns the text with CRLF line-endings of a related item contained with the
	// email. Related items are typically images and style-sheets embedded within HTML
	// emails.
	bool GetRelatedStringCrLf(int index, const uint16_t *charset, CkString &outStr);
	// Returns the text with CRLF line-endings of a related item contained with the
	// email. Related items are typically images and style-sheets embedded within HTML
	// emails.
	const uint16_t *getRelatedStringCrLf(int index, const uint16_t *charset);
	// Returns the text with CRLF line-endings of a related item contained with the
	// email. Related items are typically images and style-sheets embedded within HTML
	// emails.
	const uint16_t *relatedStringCrLf(int index, const uint16_t *charset);

	// Returns a replacement pattern previously defined for mail-merge operations.
	bool GetReplacePattern(int index, CkString &outStrPattern);
	// Returns a replacement pattern previously defined for mail-merge operations.
	const uint16_t *getReplacePattern(int index);
	// Returns a replacement pattern previously defined for mail-merge operations.
	const uint16_t *replacePattern(int index);

	// Returns a replacement string for a previously defined pattern/replacement string
	// pair. (This is a mail-merge feature.)
	// 
	// Note: This method was found to not be working correctly and is fixed in Chilkat
	// v9.5.0.91.
	// 
	bool GetReplaceString(int index, CkString &outStr);
	// Returns a replacement string for a previously defined pattern/replacement string
	// pair. (This is a mail-merge feature.)
	// 
	// Note: This method was found to not be working correctly and is fixed in Chilkat
	// v9.5.0.91.
	// 
	const uint16_t *getReplaceString(int index);
	// Returns a replacement string for a previously defined pattern/replacement string
	// pair. (This is a mail-merge feature.)
	// 
	// Note: This method was found to not be working correctly and is fixed in Chilkat
	// v9.5.0.91.
	// 
	const uint16_t *replaceString(int index);

	// Returns a replacement string for a previously defined pattern/replacement string
	// pair. (This is a mail-merge feature.)
	bool GetReplaceString2(const uint16_t *pattern, CkString &outStr);
	// Returns a replacement string for a previously defined pattern/replacement string
	// pair. (This is a mail-merge feature.)
	const uint16_t *getReplaceString2(const uint16_t *pattern);
	// Returns a replacement string for a previously defined pattern/replacement string
	// pair. (This is a mail-merge feature.)
	const uint16_t *replaceString2(const uint16_t *pattern);

	// (See the NumReports property.) Returns the body content of the Nth report within
	// a multipart/report email.
	// 
	// Multipart/report is a message type that contains data formatted for a mail
	// server to read. It is split between a text/plain (or some other content/type
	// easily readable) and a message/delivery-status, which contains the data
	// formatted for the mail server to read.
	// 
	// It is defined in RFC 3462
	// 
	bool GetReport(int index, CkString &outStr);
	// (See the NumReports property.) Returns the body content of the Nth report within
	// a multipart/report email.
	// 
	// Multipart/report is a message type that contains data formatted for a mail
	// server to read. It is split between a text/plain (or some other content/type
	// easily readable) and a message/delivery-status, which contains the data
	// formatted for the mail server to read.
	// 
	// It is defined in RFC 3462
	// 
	const uint16_t *getReport(int index);
	// (See the NumReports property.) Returns the body content of the Nth report within
	// a multipart/report email.
	// 
	// Multipart/report is a message type that contains data formatted for a mail
	// server to read. It is split between a text/plain (or some other content/type
	// easily readable) and a message/delivery-status, which contains the data
	// formatted for the mail server to read.
	// 
	// It is defined in RFC 3462
	// 
	const uint16_t *report(int index);

	// This method is deprecated. Applications should instead call LastSignerCert to
	// get the certificate used to sign this email.
	// 
	// Return the certificate used to digitally sign this email.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkCertU *GetSignedByCert(void);

	// This method is deprecated. Applications can get the cert chain by calling
	// LastSignerCert to get the certificate object, and then get the certificate chain
	// from the certificate object.
	// 
	// Return the full certificate chain of the certificate used to digitally sign this
	// email.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkCertChainU *GetSignedByCertChain(void);

	// Return the certificate that will be used to digitally sign this email. This is
	// the cerficate that was previously set by calling the SetSigningCert method.
	// The caller is responsible for deleting the object returned by this method.
	CkCertU *GetSigningCert(void);

	// Returns a to recipient's full email address.
	bool GetTo(int index, CkString &outStr);
	// Returns a to recipient's full email address.
	const uint16_t *getTo(int index);
	// Returns a to recipient's full email address.
	const uint16_t *to(int index);

	// Returns the Nth To address (only the address part, not the friendly-name part).
	bool GetToAddr(int index, CkString &outStr);
	// Returns the Nth To address (only the address part, not the friendly-name part).
	const uint16_t *getToAddr(int index);
	// Returns the Nth To address (only the address part, not the friendly-name part).
	const uint16_t *toAddr(int index);

	// Returns the Nth To name (only the friendly-name part, not the address part).
	bool GetToName(int index, CkString &outStr);
	// Returns the Nth To name (only the friendly-name part, not the address part).
	const uint16_t *getToName(int index);
	// Returns the Nth To name (only the friendly-name part, not the address part).
	const uint16_t *toName(int index);

	// Convert the email object to an XML document in memory
	bool GetXml(CkString &outStrXml);
	// Convert the email object to an XML document in memory
	const uint16_t *getXml(void);
	// Convert the email object to an XML document in memory
	const uint16_t *xml(void);

	// Returns true if the email has a header field with the specified fieldName with a
	// value matching valuePattern. Case sensitivity is controlled by caseSensitive. The valuePattern may
	// include 0 or more asterisk (wildcard) characters which match 0 or more of any
	// character.
	bool HasHeaderMatching(const uint16_t *fieldName, const uint16_t *valuePattern, bool caseSensitive);

	// Returns true if the email has an HTML body.
	bool HasHtmlBody(void);

	// Returns true if the email has a plain-text body.
	bool HasPlainTextBody(void);

	// Returns true if the email is a multipart/report email.
	bool IsMultipartReport(void);

	// Returns in cert the certificate used to decrypt this email.
	bool LastDecryptCert(CkCertU &cert);

	// Returns the Nth certificate in index used to digitally sign this email. Signed
	// emails are typically signed by a single signer, but it is possible to have
	// multiple signers. The 1st signer is at index 0.
	bool LastSignerCert(int index, CkCertU &cert);

	// Extracts domain names from hyperlinks in an HTML email. Lowercase domains are
	// appended to domains without creating duplicates.
	bool LinkedDomains(CkStringTableU &domains);

	// Loads a complete email from a .EML file. (EML files are simply RFC822 MIME text
	// files.)
	// 
	// Note: This replaces the entire contents of the email object, including the To/CC
	// recipients.
	// 
	bool LoadEml(const uint16_t *mimePath);

	// Loads the email object from a completed asynchronous task.
	bool LoadTaskResult(CkTaskU &task);

	// Loads an email with the contents of an XML email file.
	// 
	// Note: This replaces the entire contents of the email object, including the To/CC
	// recipients.
	// 
	bool LoadXml(const uint16_t *xmlPath);

	// Loads an email from an XML string (previously obtained by calling the GetXml
	// method). The contents of the calling email object are erased and replaced with
	// the email contained within the XML string.
	bool LoadXmlString(const uint16_t *xmlStr);

	// Creates a copy of this email in destEmail.
	bool MakeCopy(CkEmailU &destEmail);

	// Takes a byte array of multibyte (non-Unicode) data and returns a Unicode
	// Q-Encoded string.
	bool QEncodeBytes(CkByteData &inData, const uint16_t *charset, CkString &outEncodedStr);
	// Takes a byte array of multibyte (non-Unicode) data and returns a Unicode
	// Q-Encoded string.
	const uint16_t *qEncodeBytes(CkByteData &inData, const uint16_t *charset);

	// Takes a Unicode string, converts it to the charset specified in the 2nd
	// parameter, Q-Encodes the converted multibyte data, and returns the encoded
	// Unicode string.
	bool QEncodeString(const uint16_t *str, const uint16_t *charset, CkString &outEncodedStr);
	// Takes a Unicode string, converts it to the charset specified in the 2nd
	// parameter, Q-Encodes the converted multibyte data, and returns the encoded
	// Unicode string.
	const uint16_t *qEncodeString(const uint16_t *str, const uint16_t *charset);

	// Removes the Nth message/rfc822 sub-part of the email. Indexing begins at 0.
	void RemoveAttachedMessage(int idx);

	// Removes all message/rfc822 sub-parts of the email object.
	void RemoveAttachedMessages(void);

	// Removes path information from all attachment filenames.
	void RemoveAttachmentPaths(void);

	// Removes by name all occurrences of a header field.
	void RemoveHeaderField(const uint16_t *fieldName);

	// Removes the HTML body from the email (if an HTML body exists).
	void RemoveHtmlAlternative(void);

	// Removes the plain-text body from the email (if a plain-text body exists).
	void RemovePlainTextAlternative(void);

	// Save all the attachments of an email to files in a directory specified by dirPath.
	// The OverwriteExisting property controls whether existing files are allowed to be
	// overwritten.
	// 
	// Note: Email attachment filenames can be renamed or modified prior to saving. The
	// number of attachments is available in the NumAttachments property. An
	// application can loop over the attachments to get the filename for each by
	// calling GetAttachmentFilename(index). Each attachment's filename can be set by
	// calling SetAttachmentFilename(index, newFilename).
	// 
	bool SaveAllAttachments(const uint16_t *dirPath);

	// Saves the Nth email attachment to the directory specified by dirPath. The 1st
	// attachment is at index 0. The OverwriteExisting property controls whether
	// existing files are allowed to be overwritten.
	bool SaveAttachedFile(int index, const uint16_t *dirPath);

	// Convert this email object to EML and save it to a file.
	bool SaveEml(const uint16_t *emlFilePath);

	// Saves the Nth related item to the directory specified by dirPath. (The 1st related
	// item is at index 0) Related content items are typically image or style-sheets
	// embedded within an HTML email. The OverwriteExisting property controls whether
	// existing files are allowed to be overwritten.
	bool SaveRelatedItem(int index, const uint16_t *dirPath);

	// Convert this email object to XML and save it to a file.
	bool SaveXml(const uint16_t *path);

	// Sets the charset attribute of the content-type header field for a specified
	// attachment. This can be used if the attachment is a text file that contains text
	// in a non us-ascii charset such as Shift_JIS, iso-8859-2, big5, iso-8859-5, etc.
	bool SetAttachmentCharset(int index, const uint16_t *charset);

	// Set's an attachment's disposition. The default disposition of an attachment is
	// attachment . This method is typically called to change the disposition to inline
	// . The 1st attachment is at index 0.
	bool SetAttachmentDisposition(int index, const uint16_t *disposition);

	// Renames a email attachment's filename. The 1st attachment is at index 0.
	bool SetAttachmentFilename(int index, const uint16_t *filename);

	// Sets the main body of the email to binary content of any type. The disposition
	// can be an empty string, inline , or attachment . If a filename is specified, the
	// disposition must be non-empty because the filename is an attribute of the
	// content-disposition header field.
	bool SetBinaryBody(CkByteData &byteData, const uint16_t *contentType, const uint16_t *disposition, const uint16_t *filename);

	// This function sets the email's main body to binary content. bd contains the
	// binary data. disposition specifies the disposition and can be an empty string, inline ,
	// or attachment . If filename is provided, disposition must be specified because filename is an
	// attribute of the content-disposition header.
	bool SetBodyBd(CkBinDataU &bd, const uint16_t *contentType, const uint16_t *disposition, const uint16_t *filename);

	// Allows for a certificate to be explicity provided for decryption. When an email
	// object is loaded via any method, such as LoadEml, SetFromMimeText,
	// SetFromMimeBytes, etc., security layers (signatures and encryption) are
	// automatically unwrapped. This method could be called prior to calling a method
	// that loads the email.
	bool SetDecryptCert(CkCertU &cert);

	// Allows for a certificate and private key to be explicity specified for
	// decryption. When an email object is loaded via any method, such as LoadEml,
	// SetFromMimeText, SetFromMimeBytes, etc., security layers (signatures and
	// encryption) are automatically unwrapped. Decryption requires a private key. On
	// Windows-based systems, the private key is often pre-installed and nothing need
	// be done to provide it because Chilkat will automatically find it and use it.
	// However, if not on a Windows system, or if the private key was not
	// pre-installed, then it can be provided by this method, or via the
	// AddPfxSourceFile / AddPfxSourceData methods.
	bool SetDecryptCert2(CkCertU &cert, CkPrivateKeyU &key);

	// Sets the Date header field of the email to have the value of the date/time
	// object provided.
	bool SetDt(CkDateTimeU &dt);

	// Creates a typical email used to send EDIFACT messages. Does the following:
	//     1. Sets the email body to the EDIFACT message passed in message.
	//     2. Sets the Content-Transfer-Encoding to Base64.
	//     3. Set the Content-Type equal to application/EDIFACT .
	//     4. Sets the Content-Type header's name attribute to name.
	//     5. Sets the Content-Disposition equal to attachment .
	//     6. Sets the Content-Disposition's filename attribute equal to filename.
	//     7. The EDIFACT message is converted to the charset indicated by charset, and
	//     encoded using Base64 in the email body.
	// The email's subject, recipients, FROM address, and other headers are left
	// unmodified.
	void SetEdifactBody(const uint16_t *message, const uint16_t *name, const uint16_t *filename, const uint16_t *charset);

	// Set the encryption certificate to be used in encryption. Use the CreateCS,
	// CertStore, and Cert classes to create a Cert object by either locating a
	// certificate in a certificate store or loading one from a file.
	bool SetEncryptCert(CkCertU &cert);

	// Loads an email with the MIME stored in a BinData object.
	// 
	// Note: This replaces the entire contents of the email object, including the To/CC
	// recipients.
	// 
	bool SetFromMimeBd(CkBinDataU &bindat);

	// Loads the email object with the mimeBytes. If the email object already contained an
	// email, it is entirely replaced. The character encoding (such as utf-8 ,
	// iso-8859-1 , etc.) of the bytes is automatically inferred from the content. If
	// for some reason it is not possible to determine the character encoding, the
	// SetFromMimeBytes2 method may be called to explicitly specify the charset.
	bool SetFromMimeBytes(CkByteData &mimeBytes);

	// Loads the email object with the mimeBytes. If the email object already contained an
	// email, it is entirely replaced.
	// 
	// The charset specifies the character encoding of the MIME bytes (such as utf-8 ,
	// iso-8859-1 , etc.).
	// 
	bool SetFromMimeBytes2(CkByteData &mimeBytes, const uint16_t *charset);

	// Loads an email with the MIME stored in a StringBuilder object.
	// 
	// Note: This replaces the entire contents of the email object, including the To/CC
	// recipients.
	// 
	bool SetFromMimeSb(CkStringBuilderU &sb);

	// Loads an email with the contents of a .eml (i.e. MIME) contained in a string.
	// 
	// Note: This replaces the entire contents of the email object, including the To/CC
	// recipients.
	// 
	bool SetFromMimeText(const uint16_t *mimeText);

	// Loads an email from an XML string.
	// 
	// Note: This replaces the entire contents of the email object, including the To/CC
	// recipients.
	// 
	bool SetFromXmlText(const uint16_t *xmlStr);

	// Sets the HTML body of an email.
	void SetHtmlBody(const uint16_t *html);

	// Sets the HTML email body from a byte array containing character data in the
	// specified character set. This method also updates the email content-type header
	// to properly reflect the content type of the body.
	bool SetMbHtmlBody(const uint16_t *charset, CkByteData &inData);

	// Sets the plain-text email body from a byte array containing character data in
	// the specified character set. This method also updates the email content-type
	// header to properly reflect the content type of the body.
	bool SetMbPlainTextBody(const uint16_t *charset, CkByteData &inData);

	// Sets the filename for a related item within the email.
	bool SetRelatedFilename(int index, const uint16_t *path);

	// Create a pattern/replacement-text pair for mail-merge. When the email is sent
	// via the MailMan's SendEmail method, or any other mail-sending method, the
	// patterns are replaced with the replacement strings during the sending process.
	// To define multiple replacement patterns, simply call SetReplacePattern once per
	// pattern/replacement string. (Note: The MailMan's RenderToMime method will also
	// do pattern replacements. Methods such as SaveEml or GetMime do not replace
	// patterns.)
	// 
	// Note: Replacement patterns may be placed in any header field, and in both HTML
	// and plain-text email bodies.
	// 
	bool SetReplacePattern(const uint16_t *pattern, const uint16_t *replaceString);

	// Set the certificate to be used in creating a digital signature. Use the
	// CreateCS, CertStore, and Cert classes to create a Cert object by either locating
	// a certificate in a certificate store or loading one from a file.
	bool SetSigningCert(CkCertU &cert);

	// Explicitly sets the certificate and private key to be used for sending digitally
	// signed email. If the certificate's private key is already installed on the
	// computer, then one may simply call SetSigningCert because the Chilkat component
	// will automatically locate and use the corresponding private key (stored in the
	// Windows Protected Store). In most cases, if the digital certificate is already
	// installed w/ private key on the computer, it is not necessary to explicitly set
	// the signing certificate at all. The Chilkat component will automatically locate
	// and use the certificate containing the FROM email address (from the
	// registry-based certificate store where it was installed).
	bool SetSigningCert2(CkCertU &cert, CkPrivateKeyU &key);

	// Sets the body of the email and also sets the Content-Type header field of the
	// contentType. If the email is already multipart/alternative, an additional alternative
	// with the indicated Content-Type will be added. If an alternative with the same
	// Content-Type already exists, it is replaced.
	void SetTextBody(const uint16_t *bodyText, const uint16_t *contentType);

	// Creates a new Delivery Status Notification (DSN) email in the format specified
	// by RFC 3464. The DSN email is generated in dsnEmail.
	bool ToDsn(const uint16_t *explanation, const uint16_t *statusFields, bool headerOnly, CkEmailU &dsnEmail);

	// Creates inline forward of this email in forward.
	bool ToForward(CkEmailU &forward);

	// Creates a new MDN (Message Disposition Notification) email in message having the
	// format as specified in RFC 3798.
	bool ToMdn(const uint16_t *message, const uint16_t *statusFields, bool headerOnly, CkEmailU &mdn);

	// Generates a reply email in reply with updated header and body fields to enable
	// sending as a reply. Note: Attachments are excluded from the reply, but attached
	// messages are included. To exclude attached messages, call RemoveAttachedMessages
	// on the reply email object.
	bool ToReply(CkEmailU &reply);

	// True if the caller email has a UIDL that equals the email passed in the
	// argument.
	bool UidlEquals(CkEmailU &e);

	// Unpacks an HTML email into an HTML file and related files (images and style
	// sheets). The links within the HTML are updated to point to the files unpacked
	// and saved to disk.
	// 
	// The unpackDir is the absolute or relative directory path where the HTML file should
	// be written. The partsSubdir is the subdirectory beneath unpackDir where images and style
	// sheets should be written. If partsSubdir does not already exist, it is automatically
	// created.
	// 
	// For example, if unpackDir = C:/test , htmlFilename = myEmail.html , and partsSubdir = images , then
	// C:/test/myEmail.html is created, and the related files are written into
	// C:/test/images.
	// 
	// Note: The UnpackHtml method extracts images that are actually contained within
	// the email itself. If the HTML contains an IMG tag that just links to an image on
	// the web (but the image data is not contained locally within the email), then the
	// image is not unpacked (because it would need to be downloaded from the web).
	// 
	bool UnpackHtml(const uint16_t *unpackDir, const uint16_t *htmlFilename, const uint16_t *partsSubdir);

	// Unobfuscates emails by undoing what spammers do to obfuscate email. It removes
	// comments from HTML bodies and unobfuscates hyperlinked URLs.
	void UnSpamify(void);

	// Unzips and replaces any Zip file attachments with the expanded contents. As an
	// example, if an email contained a single Zip file containing 3 GIF image files as
	// an attachment, then after calling this method the email would contain 3 GIF file
	// attachments, and the Zip attachment would be gone.If an email contains multiple
	// Zip file attachments, each Zip is expanded and replaced with the contents.
	bool UnzipAttachments(void);

	// Adds an XML certificate vault to the object's internal list of sources to be
	// searched for certificates and private keys when encrypting/decrypting or
	// signing/verifying. Unlike the AddPfxSourceData and AddPfxSourceFile methods,
	// only a single XML certificate vault can be used. If UseCertVault is called
	// multiple times, only the last certificate vault will be used, as each call to
	// UseCertVault will replace the certificate vault provided in previous calls.
	bool UseCertVault(CkXmlCertVaultU &vault);

	// Replaces all the attachments of an email with a single Zip file attachment
	// having the filename specified.
	bool ZipAttachments(const uint16_t *zipFilename);





	// END PUBLIC INTERFACE


};
#if !defined(__sun__) && !defined(__sun)
#pragma pack (pop)
#endif
	
#endif
